# NVDA NVDA_VERSION User Guide

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Commands Quick Reference -->



## Introduktion {#toc2}

NonVisual Desktop Access (NVDA) är en gratis skärmläsare baserad på öppen källkod för Microsoft Windows operativsystem.
Genom att ge återkoppling via syntetiskt tal och punktskrift ger den blinda och synnedsatta tillgång till datorer som kör Windows för ingen ytterliggare kostnad i jämförelse med en seende person.
NVDA utvecklas av [NV Access](https://www.nvaccess.org/), med bidrag från gemenskapen.

### Allmänna funktioner {#toc3}

NVDA låter blinda och synskadade människor få tillgång till och interagera med operativsystemet Windows och många tredjepartsprogram.

Större höjdpunkter inkluderar:

* Stöd för populära program, inklusive webbläsare, e-postklienter, internetchattprogram och kontorssviter
* Inbyggd talsyntes som stöder över 43 språk
* Rapportering av textformatering där sådana finns till exempel teckensnitt och storlek, stil och stavfel
* Automatisk rapportering av text som befinner sig under muspekaren och valfri hörbar indikation för muspositionen
* Stöd för många punktskriftsdisplayer, inklusive inmatning av datorpunktskrift för punktskriftsskärmar som har ett punktskriftstangentbord
* Möjlighet att köra helt och hållet från ett USB-minne eller annan bärbar media utan behov av installation
* Lättanvänd talande installerare
* Översatt till 45 språk
* Stöd för moderna Windows-operativsystem, inklusive både 32- och 64-bitars varianter
* Möjlighet att köra under Windows-inloggning och andra skyddade skärmar
* Stöd för vanliga tillgänglighetsgränssnitt som Microsoft Active Accessibility, Java Access Bridge, IAccessible2 och UI Automation (UI Automation stöds endast i Windows 7 och senare)
* Stöd för Windows Kommandotolken och konsolapplikationer

### Internationalisering {#toc4}

Det är viktigt att människor överallt i världen, oavsett vilket språk de talar, får lika tillgång till teknik.
Förutom engelska, har NVDA översatts till 45 språk, inklusive: afrikaans, albanska, amhariska, arabiska, aragoniska, brasiliansk portugisiska, bulgariska, katalanska, kroatiska, tjeckiska, danska, holländska, persiska, finska, franska, galiciska, grekiska, georgiska, tyska , hebreiska, hindi, ungerska, isländska, iriska, italienska, japanska, koreanska, nepalesiska, norska, polska, portugisiska, rumänska, ryska, serbiska, slovakiska, slovenska, spanska, svenska, tamil, thailändska, traditionell och förenklad kinesiska, turkiska, ukrainska och vietnamesiska.

### Talsyntessupport {#toc5}

Förutom att tillhandahålla meddelanden och gränssnitt på flera språk kan NVDA också göra det möjligt för användaren att få innehåll uppläst på alla språk. Detta gäller så länge användaren har en talsyntes som kan tala det språket.

NVDA levereras med [eSpeak](https://espeak.sourceforge.net/), en fri, öppen källkod, flerspråkig talsyntes.

Information om andra talsynteser som NVDA stöder finns under [Talsyntesstöd](#SupportedSpeechSynths).

### Punktskriftsstöd {#toc6}

För användare som äger en uppdateringsbar punktskriftsdisplay kan NVDA mata ut sin information i punktskrift.
Se [Punktskriftsdisplaystöd](#SupportedBrailleDisplays) för information om vilka punktskriftsdisplayer som stöds.

NVDA stöder punktskrift för många språk, däribland kontrakterade, icke-kontrakterade och datorpunktskrift för många språk.

### Licencs och copyright {#toc7}

NVDA is copyright NVDA_COPYRIGHT_YEARS NVDA contributors.

NVDA täcks av GNU General Public License (Version 2).
Du är fri att dela eller ändra den här mjukvaran på vilket sätt du vill sålänge licensen medföljer och du gör all källkod tillgänglig till alla som vill ha den.
Det här gäller både originalet och modifierade exemplar av denna mjukvara, samt  eventuella härledda verk.
För vidare information kan du se hela licensen [här.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)

## Systemkrav {#toc8}

* Operativsystem: alla 32-bitars och 64-bitars versioner av Windows XP, Windows Vista, Windows 7 och Windows 8 (inluderar även serverversionerna)
 * För Windows XP 32-bit kräver NVDA Service Pack 2 eller högre.
 * För Windows Server 2003 kräver NVDA Service Pack 1 eller högre.
* RAM-minne: 256 mb eller mer
* Processor: 1.0 ghz or above
* Cirka 50 MB diskutrymme.

## Hämtning och installation av NVDA {#toc9}

Om du ännu inte har ett exemplar av NVDA, kan du hämta det från [www.nvaccess.org](NVDA_URL).

Gå till nedladdningssektionen där du hittar en länk för att ladda ner den senaste versionen av NVDA.

Körning av filen du just har laddat ner kommer att starta en temporärt exemplar av NVDA.
Du kommer därefter att få frågan om du vill installera NVDA, skapa ett portabelt exemplar eller bara fortsätta att använda det tillfälliga exemplaret.

Om du planerar att alltid använda NVDA på den här datorn, bör du välja att installera NVDA.
Installation av NVDA tillåter ytterligare funktioner som automatisk start efter inloggning, förmågan att läsa upp Windows-inloggning och skyddade skärmar (som inte kan göras med portabla och tillfälliga exemplar) och skapandet av Startmeny- och skrivbordsgenvägar.
Det installerade exemplaret är när som helst också kapabelt att skapa en portabel kopia av sig själv.

Om du vill ta med dig NVDA på ett USB-minne eller annan skrivbar media, så ska du välja att skapa ett portabelt exemplar.
Det portabla exemplaret har också förmågan att installera sig själv på alla datorer vid ett senare tillfälle.
Men om du vill kopiera NVDA till skrivskyddade medier som en CD, ska du bara kopiera nedladdningspaketet.
Körning av den portabla versionen direkt från skrivskyddad media stöds inte för nuvarande.

Att använda det tillfälliga exemplaret av NVDA är också ett alternativ (t.ex. för demonstrationsändamål), men att starta NVDA på detta sätt varje gång kan bli mycket tidskrävande.

### Portabla och tillfälliga exemplars begränsningar {#toc10}

Förutom oförmågan att starta automatiskt under och eller efter inloggning har portabla och tillfälliga exemplar av NVDA även följande begränsningar:

* Oförmågan att interagera med program som körs med administrativa rättigheter, såvida inte NVDA själv också körs med dessa privilegier (rekommenderas ej).
* Oförmågan att läsa Kontroll av användarkonto-skärmar (UAC) när du försöker starta ett program med administratörsbehörighet.
* Windows 8: oförmågan att stödja inmatning från en pekskärm.
* Windows 8: oförmågan att tillhandahålla funktioner som bläddringsläget och läs skrivna tecken i Windows Store-appar.

### Installera NVDA {#toc11}

Om du installerar NVDA direkt från NVDA:s nedladdningspaket trycker du på Installera NVDA-knappen.
Om du redan har stängt den här dialogrutan eller vill installera från ett portabelt exemplar, välj Installera NVDA-menyalternativet som finns under Verktyg i NVDA-menyn.

Installationsdialogrutan som dyker upp kommer att bekräfta om du vill installera NVDA och den kommer också att informera om denna installation kommer att uppdatera en tidigare installation.
Tryck på Fortsätt-knappen för att påbörja installationen av NVDA.
Det finns också några alternativ i den här dialogrutan som förklaras nedan.
När installationen är klar visas ett meddelande som talar om ifall installationen lyckades.
Ett tryck på OK vid denna tidpunkt kommer att starta det nyinstallerade exemplaret av NVDA.

#### Starta vid Windows-inloggning {#toc12}

Det här alternativet tillåter dig att välja om NVDA ska starta automatiskt vid Windows-inloggningsskärm dvs innan du har matat in ett lösenord.
Det här inkluderar även UAC och andra skyddade skärmar.

#### Skapa skrivbordsgenväg (ctrl+alt+n) {#toc13}

Det här alternativet tillåter dig att välja om NVDA ska skapa en genväg på skrivbordet för att starta NVDA.
Denna genväg, om skapad, kommer också att tilldelas ett kortkommando bestående av control+alt+n så att du kan starta NVDA när som helst med denna knapptryckning.

#### Kopiera portabel konfiguration till nuvarande användarkonto {#toc14}

Det här alternativet tillåter dig att välja om NVDA ska kopiera användarkonfigurationen från nuvarande körande NVDA-exemplar till konfigurationen för den inloggade användaren, för den installerade kopian av NVDA. 
Detta kommer inte att kopiera konfigurationen för andra användare av systemet eller till systemkonfiguration för användning vid Windows-inloggning och andra skyddade skärmar.
Det här alternativet är bara tillgängligt när du installerar från ett portabelt exemplar, inte när du installerar direkt från nedladdningspaketet.

### Skapa ett portabelt exemplar {#toc15}

Om du skapar ett portabelt exemplar direkt från NVDA nedladdningspaketet tryck bara på knappen Skapa portabelt exemplar.
Om du redan har stängt den här dialogrutan eller om du kör ett installerat exemplar av NVDA, välj Skapa portabelt exemplar som finns under Verktyg i NVDA-menyn.

Dialogrutan som dyker upp låter dig välja var det portabla exemplaret ska installeras.
Detta kan vara en mapp på hårddisken eller en plats på ett USB-minne eller annan bärbar media.
Det finns också en möjlighet att välja om NVDA ska kopiera den inloggade användarens nuvarande NVDA-konfiguration för användning med det nyskapade portabla exemplaret.
Det här alternativet är endast tillgängligt när du skapar ett portabelt exemplar från ett installerat exemplar, inte när du skapar från nedladdningspaketet.
Tryck på Fortsätt-knappen för att skapa det portabla exemplaret.
När skapandet är klart visas ett meddelande som talar om ifall den lyckades.
Tryck OK för att stänga dialogrutan.

## Komma igång med NVDA {#toc16}
### Starta NVDA {#toc17}

Om du har installerat NVDA med installeraren kan du därefter enkelt starta NVDA genom att antingen trycka ctrl+alt+n, eller välja NVDA från NVDA menyn under Alla program på Start-menyn.
Dessutom kan du skriva NVDA i dialogrutan Kör och trycka på Enter.

För att starta den portabla versionen gå till mappen där du packade upp NVDA till och tryck på Enter eller dubbelklicka på nvda.exe.

När NVDA startar kommer du först höra ett antal stigande toner (som talar om att NVDA laddas).
Beroende på hur snabbt din dator är, eller om du kör NVDA från ett USB-minne eller annat långsammare medium, kan det ta ett tag att starta.
Om det tar extra lång tid, kommer NVDA att säga "Laddar NVDA. Var god vänta..."

Om du inte hör något av detta, eller om du hör Windows felljud, eller ett antal fallande toner, då betyder det att NVDA har råkat ut för ett fel, och du bör eventuellt rapportera felet till utvecklarna.
Vänligen se NVDA:s hemsida för hur man gör detta.

När NVDA startas för första gången kommer du att välkomnas av en dialogruta som ger dig lite grundläggande information om NVDA-tangenten och NVDA-menyn.
(Se vidare avsnitt om dessa frågor.)
Dialogrutan innehåller också tre kryssrutor.
Den första låter dig välja om NVDA ska använda skiftlås som NVDA-tangent.
Den andra anger om NVDA ska starta automatiskt när du loggar in i Windows och är endast tillgänglig för installerade exemplar av NVDA.
Den tredje låter dig välja om denna Välkommen-dialog ska visas varje gång NVDA startar.

### Om NVDA tangentbordskommandon {#toc18}
#### NVDA-tangenten {#toc19}

De flesta NVDA-specifika tangentbordskommandon består av att trycka på en särskild knapp som kallas NVDA-tangenten tillsammans med en eller flera andra tangenter.
Noterbara undantag är textgranskningskommandona för stationära tangentbord som endast använder tangenterna på det numeriska tangentbordet, men det finns några andra undantag också.

NVDA kan konfigureras så att antingen numerisk insert, insert eller skiftlås-tangenten kan användas som NVDA-tangent.

Som standard är både numerisk insert och insert inställda som NVDA-tangenter.

Om du vill få en av NVDA-tangenterna att agera som den ursprungliga tangenten (till exempel om du vill slå på skiftlås när du har ställt in skiftlås som NVDA-tangent) kan du trycka på tangenten två gånger i snabb följd.

#### Tangentbordslayout {#toc20}

NVDA kommer för nuvarande med två uppsättningar av kortkommandon.
Det finns en layout för stationära och en för bärbara datorer.
NVDA är som standard inställd på att använda den stationära layouten men du kan byta till den bärbara layouten i Tangentbordsinställningar som finns under Inställningar i NVDA-menyn.

Den stationära layouten använder sig flitigt av numeriska delen (med sifferlås av).
Även om de flesta bärbara datorer inte har en fysisk numerisk tangentbordsdel kan vissa bärbara datorer emulera en genom att hålla ned FN-tangenten och samtidigt trycka på bokstäver och siffror på den högra sidan av tangentbordet (7 8 9 u i o j k l etc).
Om din bärbara dator inte kan göra det, eller inte tillåter dig att stänga av sifferlås, kanske du vill använda den bärbara layouten istället

### NVDA pekgester {#toc21}

Om du kör NVDA på en enhet med en pekskärm och Windows 8 eller senare kan du också styra NVDA direkt via pekskärmen.
Medan NVDA är igång kommer alla pekgester att direkt hanteras av NVDA. 
Därför kommer åtgärder som normalt kan utföras utan NVDA inte att fungera.

#### Utforska skärmen {#toc22}

Den mest grundläggande åtgärden du kan utföra med pekskärmen är att meddela kontrollen eller texten på något ställe av skärmen.
För att göra detta, placera ett finger var som helst på skärmen.
Du kan också hålla fingret på skärmen och flytta runt för att läsa andra kontroller och texter som ditt finger rör sig över.

#### Pekgester {#toc23}

När NVDA-kommandona beskrivs senare i denna användarhandbok kan de lista en pekgest som kan användas för att aktivera aktuellt kommando med hjälp av pekskärmen.
Nedan följer några instruktioner om hur du utför de olika pekgesterna.

##### Tryckningar {#toc24}

Tryck snabbt på skärmen med ett eller flera fingrar.

Att trycka en gång med ett finger kallas helt enkelt för ett tryck.
Att trycka med 2 fingrar på samma gång är ett 2-fingerss tryck och så vidare.

Om samma tryckning utförs snabbt en eller flera gånger igen kommer NVDA att behandla den som en flertrycksgest istället.
Att trycka två gånger resulterar i ett dubbeltryck.
Att trycka två gånger resulterar i ett trippeltryck och så vidare.
Naturligtvis registrerar dessa flertrycksgester också hur många fingrar som användes, så det är möjligt att ha gester som ett 2-fingerss trippeltryck, ett 4-fingers tryck, etc.

##### Snärtar {#toc25}

Svep snabbt med fingret längs skärmen.

Det finns 4 möjliga snärtgester beroende på riktning: snärta vänster, snärta höger, snärta upp och snärta ner.

Precis som med tryckningar kan ett eller fler fingrar användas för utföra gesten.
Därför är gester som en 2-fingerss snärta upp och en 4-fingers snärta vänster möjliga.

#### Peklägen {#toc26}

Då det finns många fler NVDA-kommandon än det möjliga pekgester så har NVDA flera peklägen du kan skifta mellan vilka göra vissa undergrupper av kommandon tillgängliga.
De två lägena är textläge och objektläge.
Vissa av NVDA-kommandona som beskrivs i detta dokument kan ha ett pekläge angett i parentes efter pekgesten.
Till exempel snärta upp (textläge) betyder att kommandot kommer att utföras om du snärtar uppåt men endast om du befinner i dig i textläge.
Om kommandot inte har ett läge listat kommer det att fungera i alla lägen.

<!-- KC:beginInclude -->
För att växla pekläge utför ett 3-fingers tryck.
<!-- KC:endInclude -->

### Inmatningshjälpläge {#toc27}

Många NVDA-kommandon nämns i resten av den här användarhandboken, men ett enkelt sätt att utforska alla de olika kommandona är att aktivera inmatningshjälpen.

För att slå på inmatningshjälp tryck NVDA+1.
För att stänga av den tryck NVDA+1 igen.
När inmatningshjälpen är på kommer alla inmatningsgester (som att trycka på en tangent eller att utföra en pekgest) att rapportera åtgärden och beskriva vad den gör (om den gör något).
De faktiska kommandona kommer inte att exekveras i inmatningshjälpläget.

### NVDA-menyn {#toc28}

NVDA-menyn låter dig att hantera NVDA:s inställningar, få tillgång till hjälp, spara/återställa din konfiguration, Ändra talordlistor, få tillgång till ytterliggare verktyg och avsluta NVDA.

För att nå NVDA-menyn från var som helst i Windows när NVDA körs trycker du NVDA+n på tangentbordet eller utför ett 2-fingerss dubbeltryck på pekskärmen.
Du kan också nå NVDA-menyn via Windows aktivitetsfält.
Antingen högerklicka på NVDA-ikonen i aktivitetsfältet, eller kom åt aktivitetsfältet genom att trycka på Windows-tangenten+B, pil nedåt till NVDA-ikonen och tryck applikationstangenten som befinner sig bredvid höger ctrl-tangent på de flesta tangentbord.
När menyn dyker upp, kan du använda piltangenterna för att navigera i menyn och Enter för att aktivera ett objekt.

### Grundläggande NVDA-kommandon {#toc29}

<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Pekgest |Beskrivning|
|---|---|---|---|---|
|Stoppa tal |Control |control |2-fingerss tryck |Avbryter tal omedelbart|
|Pausa tal |shift |shift |ingen |Pausar tal omedelbart. Om du trycker på den igen kommer den att fortsätta där den slutade (om paus stöds av den aktuell talsyntes)|
|NVDA-meny |NVDA+n |NVDA+n |2-fingerss dubbeltryck |Poppar upp NVDA-menyn så att du kan komma åt inställningar, verktyg, hjälp etc|
|Växlar talläge |NVDA+s |NVDA+s |ingen |Växlar mellan tallägena tal, pip och av.|
|Växlar inmatningshjälpläge |NVDA+1 |NVDA+1 |ingen |Ett tryck på valfri tangent i detta läge kommer att rapportera tangenten och eventuellt beskrivningen av NVDA kommandot kopplad till det|
|Avsluta NVDA |NVDA+q |NVDA+q |ingen |Avslutar NVDA|
|Släpp igenom nästa tangent |NVDA+f2 |NVDA+f2 |ingen |Talar om för NVDA att släppa igenom nästa knapptryckning till den aktiva applikationen, även om det i vanliga fall behandlas som ett NVDA-kortkommando|
|Växla mellan applikationslägena på och av |NVDA+shift+s |NVDA+shift+z |ingen |I viloläge inaktiveras alla NVDA-kommandon, tal och punktskriftsutmatningar för den nuvarande applikationen. Detta är mest användbart i applikationer som tillhandahåller sina egna tal- eller skärmläsningsfunktioner. Tryck det här kommandot igen för att avaktivera självtalsläget.|

<!-- KC:endInclude -->

### Rapportera systeminformation {#toc30}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Rapportera datum/tid |NVDA+f12 |Ett tryck rapporterar nuvarande tid, två tryck rapporterar datumet|
|Rapportera batteristatus |NVDA+shift+b |Rapporterar batteristatus t.ex. om strömmen är ansluten eller nuvarande batteriladdningsnivå.|
|Rapportera klippbordstext |NVDA+c |Rapporterar texten, om den finns, på klippbordet.|

<!-- KC:endInclude -->

## Navigera med NVDA {#toc31}

NVDA låter dig utforska och navigera i systemet på flera sätt, bland annat både normal interaktion och granskning.

### Objekt {#Objects}

Varje applikation och operativsystemet i sig består av många objekt.
Ett objekt är ett enda föremål, t.ex. en bit text, en knapp, en kryssruta, ett reglage, en lista eller ett redigerbart textfält.

### Navigera med systemfokus {#SystemFocus}

Systemfokus, också känt som endast fokus, är det [objekt](#Objects) som tar emot tangenttryckningar.
T.ex. om du skriver i redigerbard textfält så är det redigerbara textfältet som har fokus.

Det vanligaste sättet att navigera Windows med NVDA är att helt enkelt flytta systemets fokus med vanliga Windows tangentbordskommandon, till exempel trycka på tab och shift+tab för att gå fram och tillbaka mellan kontroller, trycka alt för att komma till menyraden och sedan använda piltangenterna för att navigera i menyer, och använda alt+tab för att växla mellan olika program.
När du gör detta kommer NVDA att rapportera information om objektet med fokus, såsom dess namn, typ, värde, status, beskrivning, kortkommando och positionsinformation.

Det finns några viktiga kommandon som är användbara när du navigerar med systemfokus:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Beskrivning|
|---|---|---|---|
|Rapportera nuvarande fokus |NVDA+tab |NVDA+tab |meddelar det aktuella objektet eller kontroll som har systemfokus. Två tryck bokstaverar informationen|
|Rapportera titel |NVDA+t |NVDA+t |Rapporterar nuvarande aktivt fönsters titel. Två tryck bokstaverar titeln. Tre tryck kopierar titeln till klippbordet|
|Läs aktivt fönster |NVDA+b |NVDA+b |läser alla kontroller i det nuvarande aktiva fönstret (användbart för dialogrutor)|
|Rapportera statusrad |NVDA+end |NVDA+shift+end |Rapporterar statusraden om NVDA hittar den. Flyttar också navigatorn till den här platsen|

<!-- KC:endInclude -->

### Navigera med systemmarkören {#SystemCaret}

När ett [objekt](#Objects) som tillåter navigering och/eller redigering av text är [fokuserat](#SystemFocus) kan du navigera genom texten med hjälp av systemetmarkören, även känd som redigeringsmarkören.

När fokus ligger på ett objekt som har systemmarkören, kan du använda piltangenterna, sida upp, sida ner, hem, slut, etc. för att navigera genom texten.
Du kan också ändra texten, om kontrollen stöder redigering.
NVDA kommer att meddela när du rör dig per tecken, ord och rad, och kommer också att meddela när du markerar och avmarkerar text.

NVDA tillhandahåller följande kortkommandon i samband med systemmarkören:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Beskrivning|
|---|---|---|---|
|Läs allt |NVDA+downArrow |NVDA+a |Börjar läsa från systemmarkörens nuvarande position och markören följer med under läsningen|
|Läs nuvarande rad |NVDA+upArrow |NVDA+l |Läser raden där systemmarkören befinner sig. Två tryck bokstaverar raden.|
|Läs nuvarande markerad text |NVDA+Shift+upArrow |NVDA+shift+s |Läser all för tillfället markerad text|

Inom en tabell är följande viktiga kommandon också tillgängliga:

| Namn |Tangent |Beskrivning|
|---|---|---|
|Hoppa till föregående kolumn |control+alt+leftArrow |Flyttar systemmarkören till föregående kolumn (stannar i samma rad)|
|Hoppa till nästa kolumn |control+alt+rightArrow |Flyttar systemmarkören till nästa kolumn (stannar i samma rad)|
|Hoppa till föregående rad |control+alt+upArrow |Flyttar systemmarkören till föregående rad (stannar i samma kolumn)|
|Hoppa till nästa rad |control+alt+downArrow |Flyttar systemmarkören till nästa rad (stannar i samma kolumn)|

<!-- KC:endInclude -->

### Objektnavigation {#toc35}

Merparten av tiden kommer du att arbeta med applikationer med hjälp av kommandon som flyttar [fokus](#SystemFocus) och [markör](#SystemCaret).
Men ibland kanske du vill utforska det aktuella programmet eller operativsystemet utan att flytta fokus eller markör.
Du kanske också vill arbeta med [objekt](#Objects) som inte vanligtvis kan nås med hjälp av tangentbordet.
I dessa fall kan du använda objektnavigering.

Objekt-navigering gör det möjligt att röra sig mellan och få information om enskilda [objekt](#Objects).
När du flyttar till ett objekt, kommer NVDA att rapportera det på liknande sätt som systemfokus.
För att granska all text såsom den visas på skärmen kan du i stället använda [skärmgranskning](#ScreenReview).

I stället för att behöva flytta fram och tillbaka mellan varje enskilt objekt i systemet är objekten organiserade hierarkiskt.
Det innebär att vissa objekt innehåller andra objekt och du måste gå i dem för att komma åt de objekt de innehåller.
Till exempel en lista innehåller listobjekt, så du måste gå in i listan för att komma åt dess listobjekt.
Om du har flyttat till ett listobjekt så kommer flytta till nästa och flytta till föregående ta dig till andra listobjekt i samma lista.
Att flytta till ett listobjekts behållare tar dig tillbaka till listan.
Du kan sedan flytta förbi listan om du vill komma åt andra objekt.
På samma sätt innehåller ett verktygsfält kontroller, så du måste gå in i verktygsfältet för att komma åt kontrollerna i verktygsfältet.

Föremålet som för närvarande granskas kallas navigatorobjektet.
När du navigerar till ett objekt, kan du granska dess innehåll med hjälp av [textgranskningskommandon](#ReviewingText) i [Objektgranskningsläget](#ObjectReview).
Som standard rör sig navigatorobjekt tillsammans med systemfokus, även om detta beteende kan växlas på och av.

Observera att punktskrift följer [fokus](#SystemFocus) och [systemmarkören](#SystemCaret) som standard, snarare än objektnavigering och textgranskning.
Om du vill att det ska följa objektnavigering och textgranskning i stället måste du [konfigurera punktskrift att vara bunden till](#BrailleTether) granskning.

För objektnavigering använd följande kommandon:

<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Pekgest |Beskrivning|
|---|---|---|---|---|
|Rapportera nuvarande objekt |NVDA+numpad5 |NVDA+shift+o |ingen |Rapporterar nuvarande navigatorobjekt. Två tryck bokstaverar informationen och 3 tryck kopierar detta objekts namn och värde till klippbordet.|
|Hoppa till behållarobjekt |NVDA+numpad8 |NVDA+shift+upArrow |snärta upp (objektläge) |Hoppar till objektet som innehåller nuvarande navigatorobjekt|
|Hoppa till föregående objekt |NVDA+numpad4 |NVDA+shift+leftArrow |snärta vänster (objektläge) |Hoppar till objektet innan nuvarande navigatorobjekt|
|Hoppa till nästa objekt |NVDA+numpad6 |NVDA+shift+rightArrow |snärta höger (objektläge) |Hoppar till objektet efter nuvarande navigatorobjekt|
|Hoppa till första objekt denna behållare innehåller |NVDA+numpad2 |NVDA+shift+downArrow |snärta ner (objektläge) |Hoppar till första objektet inuti nuvarande navigatorobjekt|
|Hoppa till fokuserat objekt |NVDA+numpadMinus |NVDA+backspace |ingen |Hoppar till objektet som har systemfokus och placerar granskningsmarkören vid systemmarkören om den visas|
|Aktivera nuvarande navigatorobjekt |NVDA+numpadEnter |NVDA+enter |dubbeltryck |Aktiverar det nuvarande navigatorobjektet (i princip som att klicka med musen eller trycka blanksteg när det har systemfokus)|
|Flytta systemfokus eller markör till nuvarande granskningsposition |NVDA+shift+numpadMinus |NVDA+shift+backspace |ingen |ett tryck flyttar systemfokus till nuvarande navigatorobjekt, två tryck flyttar systemmarkören till granskningsmarkörens position|
|Rapportera granskningsmarkörens läge |NVDA+numpadDelete |NVDA+delete |ingen |Rapporterar information om var texten eller objektet befinner sig under granskningsmarkören. Till exempel kan detta inkludera hur många procent av ett dokument, sträckan till sidkanten eller den exakta skärmpositionen. Två tryck kan ge ytterliggare detaljer.|

<!-- KC:endInclude -->

Obs: tangenterna på det numeriska tangentbordet kräver att sifferlås är av för att fungera korrekt.

### Granska text {#ReviewingText}

NVDA låter dig läsa innehållet på [skärmen](#ScreenReview), nuvarande [dokument](#DocumentReview) eller nuvarande [objekt](#ObjectReview) per tecken, ord eller rad.
Det är oftast användbart på platser (inklusive Windows kommandokonsol) där det inte finns en [systemmarkör](#SystemCaret).
Till exempel kan du använda det för att granska texten i ett långt informationsmeddelande i en dialogruta.

När du flyttar granskningsmarkören, följer systemmarkören inte med, så du kan granska texten utan att förlora din redigeringsposition.
Men som standard, då systemmarkören rör sig, följer granskningsmarkören med.
Detta kan växlas på och av.

Observera att punktskrift följer [fokus](#SystemFocus) och [systemmarkören](#SystemCaret) som standard, snarare än objektnavigering och textgranskning.
Om du vill att det ska följa objektnavigering och textgranskning i stället måste du [konfigurera punktskrift att vara bunden till](#BrailleTether) granskning.

De följande kommandona finns tillgängliga för granskning av text:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Pekgest |Beskrivning|
|---|---|---|---|---|
|Flytta till översta raden i granskning |shift+numpad7 |NVDA+control+home |ingen |Flyttar granskningsmarkören till översta raden i texten|
|Flytta till föregående rad i granskning |numpad7 |NVDA+upArrow |snärta upp (text mode) |Flyttar granskningsmarkören till föregående rad text|
|Rapportera nuvarande rad i granskning |numpad8 |NVDA+shift+. |ingen |Läser upp nuvarande rad text där granskningsmarkören befinner sig. Två tryck bokstaverar raden. Tre tryck bokstaverar raden med teckenbeskrivning.|
|Flytta till nästa rad i granskning |numpad9 |NVDA+downArrow |snärta ner (text mode) |Flyttar granskningsmarkören till nästa rad text|
|Flytta till sista raden i granskning |shift+numpad9 |NVDA+control+end |ingen |Flyttar granskningsmarkören till sista raden text|
|Flytta till föregående ord i granskning |numpad4 |NVDA+control+leftArrow |2-fingers snärta vänster (text mode) |Flyttar granskningsmarkören till föregående ord i texten|
|Rapportera nuvarande ord i granskning |numpad5 |NVDA+control+. |ingen |Läser upp nuvarande ord i texten där granskningsmarkören befinner sig. Två tryck bokstaverar ordet. Tre tryck bokstaverar ordet med teckenbeskrivning.|
|Flytta till nästa ord i granskning |numpad6 |NVDA+control+rightArrow |2-fingers snärta höger (text mode) |Move the review cursor to the nästa word in the text|
|Flytta till radens start i granskning |shift+numpad1 |NVDA+home |ingen |Flyttar granskningsmarkören till början av nuvarande raden i texten|
|Flytta till föregående tecken i granskning |numpad1 |NVDA+leftArrow |snärta vänster (text mode) |Flyttar granskningsmarkören till föregående tecken i nuvarande raden text|
|Rapportera nuvarande tecken i granskning |numpad2 |NVDA+. |ingen |Läser upp nuvarande ord i texten där granskningsmarkören befinner sig. Två tryck rapporterar en beskrivning eller ett exempel av tecknet. Tre tryck rapporterar det numeriska värdet av tecknet i decimal- och hexadecimalform.|
|Flytta till nästa tecken i granskning |numpad3 |NVDA+rightArrow |snärta höger (text mode) |Flyttar granskningsmarkören till nästa tecken i nuvarande rad text|
|Flytta till radens slut i granskning |shift+numpad3 |NVDA+end |ingen |Flyttar granskningsmarkören till slutet av nuvarande rad text|
|Läs allt med granskning |numpadPlus |NVDA+shift+a |3-finger snärta ner (text mode) |Läser upp från nuvarande granskningsmarkörsposition. Markören följer med under läsningen|
|Kopiera från granskingsmarkören |NVDA+f9 |NVDA+f9 |ingen |starts copying text from the current position of the review cursor. The actual copy is not performed until you tell NVDA where to copy to|
|Kopiera till granskningsmarkören |NVDA+f10 |NVDA+f10 |ingen |Kopierar från granskningsmarkörens position satt med Kopiera från granskningsmarkör till granskningsmarkörens nuvarande position. Texten kopieras till Windows klippbord|
|Rapportera textformattering |NVDA+f |NVDA+f |ingen |Rapporterar textformatteringen där granskningsmarkören befinner sig|

<!-- KC:endInclude -->

Obs: tangenterna på det numeriska tangentbordet kräver att sifferlås är av för att fungera korrekt.

Ett bra sätt att komma ihåg grundläggande textgranskningskommandon när du använder den stationära tangentbordslayouten är att föreställa dig dem i ett rutnät tre och tre, där topp till botten är rad, ord och tecken och vänster till höger är föregående, nuvarande och nästa.
Layouten illustreras enligt följande:

|Föregående rad |Nuvarande rad |Nästa rad|
|Föregående ord |Nuvarande ord |Nästa ord|
|Föregående tecken |Nuvarande tecken |Nästa tecken|

### Granskningslägen {#ReviewModes}

NVDA:s [textgranskningskommandon](#ReviewingText) kan granska innehåll inuti nuvarande navigatorobjekt, nuvarande dokument eller skärm beroende på valt granskningsläge.
Granskningslägen ersätter det äldre Platta granskningskonceptet som fanns i NVDA.

Följande kommandon växlar mellan granskningslägena:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Pekgest |Beskrivning|
|---|---|---|---|---|
|växla till nästa granskningsläge |NVDA+numpad7 |NVDA+pageUp |2-fingers snärta upp |växlar till nästa tillgängliga granskningsläge|
|växla till föregående granskningsläge |NVDA+numpad1 |NVDA+pageDown |2-fingers snärta ner |växlar till föregående tillgängliga granskningsläge|

<!-- KC:endInclude -->

#### Objektgranskning {#ObjectReview}

När du är i objektgranskningsläge kan du bara se över innehållet i det nuvarande [navigatorobjektet](#ObjectNavigation).
För objekt såsom redigerbara textfält eller andra grundläggande textkontroller kommer detta i allmänhet vara textinnehållet.
För andra objekt kan detta vara namn och/eller värde.

#### Dokumentgranskning {#DocumentReview}

När [navigatorobjektet](#ObjectNavigation) befinner sig inom ett läslägesdokument (t.ex. en webbsida) eller andra komplexa dokument (t.ex. ett Lotus Symphony-dokument) är det möjligt att växla till dokumentetgranskningsläget.
Dokumentgranskningsläget låter dig granska texten i hela dokumentet.

När du växlar från objektgranskning till dokumentgranskning placeras granskningsmarkören i dokumentet vid positionen för navigatorobjektet.
När du navigerar runt i dokumentet med granskningskommandon uppdateras navigatorobjektet automatiskt till objektet som befinner sig vid granskningsmarkörens position.

Observera att NVDA kommer att automatiskt byta till dokumentgranskning från objektgranskning när du navigerar i ett läslägesdokument.

#### Skärmgranskning {#ScreenReview}

Skärmgranskningsläget låter dig granska texten på skärmen precis som den visas visuellt inom den nuvarande applikationen.
Detta liknar skärmgranskningen eller muspekarfunktionaliteten i många andra skärmläsare för Windows.

När du växlar till skärmgranskningsläget kommer granskningsmarkören att placeras vid skärmpositionen av det nuvarande [navigatorobjektet](#ObjectNavigation).
När du navigerar runt på skärmen med granskningskommandon uppdateras navigatorobjektet automatiskt till objektet som befinner sig vid granskningsmarkörens position.

Observera att i en del nyare applikationer kan NVDA inte se en del eller ingen text som visas på skärmen på grund av användningen av nyare skärmritningstekniker som är omöjliga att stödja just nu.

### Navigera med mus {#toc41}

När du flyttar musen rapporterar NVDA som standard texten som befinner sig direkt under muspekaren när pekaren rör sig över den.
Där det stöds kommer NVDA att läsa upp det omgivande stycket text, även om vissa kontroller endast kan läsas per rad.

NVDA kan konfigureras för att också meddela vilken typ av [objekt](#Objects) som befinner sig under musen när den rör sig (t.ex. lista, knapp, etc.).
Detta kan vara användbart för helt blinda användare eftersom endast texten inte räcker till ibland.

NVDA tillhandahåller ett sätt för användarna att förstå var musen befinner sig i förhållande till dimensionerna på skärmen genom att spela upp de nuvarande muskoordinaterna som ljudpip.
Ju högre musen är på skärmen desto högre tonhöjd på pipen.
Ju längre till vänster eller höger musen befinner sig på skärmen, ju längre till vänster eller höger kommer ljudet att spelas upp (förutsatt att användaren har stereohögtalare eller hörlurar).

Dessa extra musfunktioner är inte aktiverade som standard i NVDA.
Om du vill dra nytta av dem kan du konfigurera dem från [Musinställningar](#MouseSettings)-dialogrutan, som finns i Inställningar-menyn för NVDA.

Även om en fysisk mus eller styrplatta bör användas för att navigera med musen, har NVDA några viktiga kommandon som rör musen:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Beskrivning|
|---|---|---|---|
|Vänster musklick |numpadDivide |NVDA+[ |klickar vänster musknapp en gång. The common double click can be performed by pressing this key twice in quick succession|
|Vänster muslås |shift+numpadDivide |NVDA+control+[ |Låser vänster musknapp i nerläge. Tryck igen för att släppa det. För att dra musen tryck på den här knappen för att låsa vänster knapp i nerläge och flytta sedan musen fysiskt eller med något annat muskommando|
|Höger musklick |numpadMultiply |NVDA+] |Klickar höger musknapp en gång.|
|Höger muslås |shift+numpadMultiply |NVDA+control+] |Låser höger musknapp i nerläge. PTryck igen för att släppa det. För att dra musen tryck på den här knappen för att låsa höger knapp i nerläge och flytta sedan musen fysiskt eller med något annat muskommando|
|Flytta musen till nuvarande navigatorobjekt |NVDA+numpadDivide |NVDA+shift+m |Flyttar musen till positionen av nuvarande navigatorobjekt och granskningsmarkör|
|Navigera till objektet som befinner sig under musen |NVDA+numpadMultiply |NVDA+shift+n |Sätter navigatorobjektet till objektet som befinner sig vid musens position|

<!-- KC:endInclude -->

## Läsläge {#toc42}

Komplexa skrivskyddade dokument såsom webbsidor bläddras i NVDA genom läsläget.
Detta inkluderar dokument i Mozilla Firefox, Microsoft Internet Explorer, Google Chrome, Adobe Reader and Adobe Flash.

I läsläge tillgängliggörs dokumentets innehåll i en platt representation som kan navigeras med piltangenterna som om det vore ett vanligt textdokument.
Alla NVDA:s [systemmarkör](#SystemCaret)kommandon fungerar i detta läge t.ex. läs allt, rapportera formatering, tabellnavigationskommandon, etc.
Information såsom om en text är en länk, rubrik, etc. rapporteras med texten medan du bläddrar.

Ibland kommer du att behöva interagera direkt med kontroller i dessa dokument.
Till exempel behöver du göra detta för redigerbara textfält och listor så att du kan mata in tecken och använda piltangenterna för att arbeta med kontrollen.
Du gör detta genom att växla till fokusläge där nästan alla tecken släpps igenom till kontrollen.
När du befinner dig i läsläget kommer NVDA som standard att automatiskt växla till fokusläge om du tabbar eller klickar på en särskild kontroll som behöver det.
Omvänt, att tabba till eller klicka på en kontroll som inte kräver fokusläge kommer att växla tillbaka till läsläget.
Du kan också trycka på enter eller mellanslag för att växla to fokusläge på kontroller som behöver det.
Genom att trycka på escape kan du växla tillbaka till läsläge.
Dessutom kan du manuellt forcera fokusläge varefter det kommer vara aktivt tills du väljer att inaktivera det.

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Växla läs/fokuslägen |NVDA+space |Växlar mellan läs- och fokusläge|
|Lämna fokusläge |escape |växlar tillbaka till läsläge om fokusläge aktiverades automatiskt|
|Uppdatera läslägesdokument |NVDA+f5 |Laddar om det nuvarande dokumentets innehåll (användbart om visst innehåll verkar saknas från dokumentet)|
|Sök |NVDA+control+f |Poppar upp en dialogruta där du kan mata in text att söka efter i nuvarande dokument|
|Sök nästa |NVDA+f3 |Söker efter nästa förekomst av texten i dokumentet som du tidigare sökt efter|
|Sök föregående |NVDA+shift+f3 |Söker efter föregående förekomst av texten i dokumentet som du tidigare sökt efter|
|öppna lång beskrivning |NVDA+d |Öppnar ett nytt fönster innehållandes en lång beskrivning av elementet du befinner dig på ifall det finns en.|

<!-- KC:endInclude -->

### En-bokstavsnavigering {#toc43}

När du befinner dig i läsläge tillhandahåller NVDA också, för snabbare navigering, enskilda teckentangenter för att hoppa till specifika fält i dokumentet.

<!-- KC:beginInclude -->
Följande tangenttryck hoppar till nästa möjliga element, medan om man lägger till skift-tangenten hoppar de till föregående element:

* h: rubrik
* l: lista
* i: listpunkt
* t: tabell
* k: länk
* n: ickelänkad text
* f: formulär
* u: obesökt länk
* v: besökt länk
* e: redigeringsfält
* b: knapp
* x: kryssruta
* c: kombinationsruta
* r: radioknapp
* q: blockcitat
* s: avskiljare
* m: ram
* g: grafik
* d: landmärke
* o: inbäddat objekt
* 1 till 6: rubriker på nivåer 1 till 6

För att hoppa till början eller slutet på behållarelement såsom listor tabeller:

| Namn |Tangent |Beskrivning|
|---|---|---|
|Hoppa till början av behållaren |shift+comma |Hoppar till början av behållaren (lista, tabell, etc.) där markören befinner sig|
|Hoppa förbi slutet av behållaren |comma |Hoppar förbi slutet av behållaren (lista, tabell, etc.) där markören befinner sig|

<!-- KC:endInclude -->

### Elementlistan {#toc44}

Elementlistan ger tillgång till en lista of antingen länkar, rubriker eller landmärken i dokumentet.
Radioknappar låter dig växla mellan dessa tre informationstyper.
Ett redigeringsfält tillhandahålls också i dialogrutan vilket tillåter dig att filtrera listan för att hjälpa dig söka efter ett visst objekt på sidan.
När du har valt ett objekt kan du använda de medföljande knapparna i dialogrutan för att flytta eller aktivera det objektet.
<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Läsläge elementlista |NVDA+f7 |Tar fram elementlistan som innehåller länkar, rubriker och landmärken från nuvarande dokument|

<!-- KC:endInclude -->

### Inbäddade Objects {#toc45}

Sidor kan innehålla rikt formaterat innehåll med hjälp av teknologier såsom Adobe Flash och Oracle Java så väl som applikationer och dialogrutor.
När dessa påträffas i läsläge rapporterar NVDA "inbäddat objekt", "applikation" eller "dialogrutan" bereonde på typ.
Du kan trycka på enter på dessa objekt för att interagera med dem.
Om det är tillgängligt, kan du sedan tabba runt det och interagera med det som alla andra program.
Ett viktigt kommando tillhandahålls för att gå tillbaka till ursprungliga sidan som innehåller det inbäddade objektet:
<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Flytta till behållande läslägesdokument |NVDA+control+space |Flyttar fokus ut från nuvarande inbäddat objekt in till dokumentet som innehåller det|

<!-- KC:endInclude -->

## Applikationsspecifika NVDA-kommandon {#toc46}

NVDA tillhandahåller sina egna extra kommandon för några applikationer för att göra vissa uppgifter enklare eller för att ge tillgång till funktionalitet som inte annars är tillgänglig för skärmläsaranvändare.

### Microsoft Word {#toc47}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Rapportera nuvarande kommentar |NVDA+Alt+c |Rapporterar texten i kommentaren vid systemmarkören.|
|Sätt kolumnrubriker |NVDA+shift+c |Ett tryck säger till NVDA att detta är den första rubrikcellen i raden som innehåller kolumnrubriker, vilket automatiskt borde annonseras när man navigerar mellan kolumner under den här raden. Två tryck tar bort inställningen.|
|Sätt radrubriker |NVDA+shift+r |Ett tryck säger till NVDA att detta är den första rubrikcellen i kolumnen som innehåller radrubriker, vilket automatiskt borde annonseras när man navigerar mellan rader under den här kolumnen. Två tryck tar bort inställningen.|

<!-- KC:endInclude -->

### Microsoft Excel {#toc48}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Sätt kolumnrubriker |NVDA+shift+c |Ett tryck säger till NVDA att detta är den första rubrikcellen i raden som innehåller kolumnrubriker, vilket automatiskt borde annonseras när man navigerar mellan kolumner under den här raden. Två tryck tar bort inställningen.|
|Sätt radrubrikers |NVDA+shift+r |Ett tryck säger till NVDA att detta är den första rubrikcellen i kolumnen som innehåller radrubriker, vilket automatiskt borde annonseras när man navigerar mellan rader under den här kolumnen. Två tryck tar bort inställningen.|
|Rapportera kommentar |NVDA+alt+c |Rapporterar kommentaren i nuvarande cell om tillgänglig.|

<!-- KC:endInclude -->

### Microsoft PowerPoint {#toc49}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Växlar mellan uppläsning och inte uppläsning av anteckningar |control+shift+s |När du är i ett bildspel, kommer detta kommando växla mellan anteckningarna för bilden och innehållet för bilden. Detta påverkar bara vad NVDA läser, inte vad som visas på skärmen.|

<!-- KC:endInclude -->

### foobar2000 {#toc50}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Rapportera återstående tid |control+shift+r |Rapporterar den återstående tiden av spelande spår om tillgänglig.|

<!-- KC:endInclude -->

Obs: Rapport av återstående tid fungerar endast med standardformateringssträngen för foobars statusrad.

### Miranda IM {#toc51}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Rapportera senaste meddelande |NVDA+control+1-4 |Rapporterar en av de senaste meddelandena beroende på vilket nummer som trycks t.ex. NVDA+control läser upp det nästsenaste meddelandet.|

<!-- KC:endInclude -->

### Poedit {#toc52}

<!-- KC:beginInclude -->

| Namn |Tangent |Beskrivning|
|---|---|---|
|Rapportera kommentarruta |control+shift+c |Rapporterar alla kommentarer i kommentarrutan.|
|Rapportera kommentarer till översättare |control+shift+a |Rapporterar alla kommentarer till översättare.|

<!-- KC:endInclude -->

## Konfigurera NVDA {#toc53}
### Inställningar {#toc54}

<!-- KC:settingsSection: || Namn | Stationär tangent | Bärbar tangent | Beskrivning | -->
De flesta NVDA-inställningar kan ändras genom dialogrutor som nås genom submenyn Inställningar i NVDA-menyn.
I alla NVDA-inställningsdialogrutor trycker du på OK-knappen för att acceptera alla ändringar du har gjort.
För att avbryta alla ändringar trycker du på Avbryt-knappen eller escape-tangenten.
Några inställningar kan också ändras med kortkommandon som som anges i tillämpliga fall i avsnitten nedan.

#### Allmänna inställningar (NVDA+control+g) {#toc55}

Dialogrutan för allmänna inställningar finns att hitta i Inställningar-menyn.
Den innehåller följande alternativ:

##### Språk {#toc56}

En kombinationsruta som låter dig välja vilket språk NVDA:s användargränssnitt och meddelanden skall visas i.
Det finns många språk men standardalternativet är Standard.
Det här alternativet talar om för NVDA att använda det språk som Windows är för närvarande satt till.

Vänligen observera att NVDA måste startas om vid byte av språk.
NVDA kommer att fråga om du vill starta om när du byter val.
Tryck OK och NVDA kommer att starta om.

##### Spara konfigurationen vid avslut {#toc57}

Det här alternativet är en kryssruta som om den är kryssad talar om för NVDA att automatiskt spara nuvarande konfiguration när du avslutar NVDA.

##### Varna innan NVDA avslutas {#toc58}

Det här alternativet är en kryssruta som låter dig välja om en dialogrutan, som frågar om du vill avsluta NVDA, ska dyka upp när du avslutar NVDA.
Om kryssad visas en dialogruta när du försöker avsluta NVDA som frågar om du vill avsluta.

##### Spela upp ljud när NVDA startas eller avslutas {#toc59}

Det här alternativet är en kryssruta som om kryssad talar om för NVDA att spela upp ljud vid start och avslut.

##### Loggningsnivå {#toc60}

Det här är en kombinationsruta som låter dig välja hur mycket NVDA ska logga under körning.
I allmänhet ska användare inte behöva röra den här inställningen eftersom inte alltför mycket loggas.
Men om du vill lämna information i en felrapport kan det vara ett användbart alternativ.

##### Starta NVDA automatiskt när jag loggar in på Windows {#toc61}

Om det här alternativet är aktiverat kommer NVDA att starta så fort du loggar in på Windows.
Det här alternativet är endast tillgängligt för installerade kopior av NVDA.

##### Använd NVDA vid Windows inloggningsskärm (kräver administratörsbehörighet) {#toc62}

Om du loggar in på Windows med namn och lösenord så tillåter det här alternativet att NVDA automatiskt är igång vid inloggningsskärmen.
Det här alternativet är endast tillgängligt för installerade kopior av NVDA.

##### Använd nuvarande sparad konfiguration vid inloggningsskärmen och andra skyddade skärmar (kräver administratörbehörighet) {#toc63}

Ett tryck på den här knappen kopierar dina nuvarande sparad användarkonfiguration till NVDA:s systemkonfigurationsmapp så att NVDA kan använda den vid login, Kontroll av användarkonto-skärmar (UAC) och andra skyddade Windowsskärmar.
För att säkerställa att alla dina inställningar förs över spara först din konfiguration med control+NVDA+c eller i NVDA-menyn.
Det här alternativet är endast tillgängligt för installerade kopior av NVDA.

##### Sök automatiskt efter uppdatering av NVDA {#toc64}

Om detta är aktivarat kommer NVDA automatiskt att söka efter uppdaterade versioner av NVDA och meddela dig om en uppdatering finns tillgänglig.
Du kan också manuellt söka efter uppdateringar genom att välja Sök efter uppdatering under Hjälp i NVDA-menyn.

#### Talsyntes (NVDA+control+s) {#toc65}

Talsynstesdialogrutan som finns under "Talsyntes..." i Inställningar-menyn låter dig välja vilken talsyntes NVDA skall använda sig av.
När du har gjort ditt val av talsyntes kan du trycka OK och NVDA kommer att ladda in vald talsyntes.
Om det sker ett fel under inladdningen av talsyntesen kommer NVDA att notifiera dig med ett meddelande och fortsätta använda föregående talsyntes.

##### Talsyntes {#toc66}

Det här alterntivet låter dig välja den talsyntes du vill att NVDA ska använda för talutmatning.

För en lista av de talsynteser NVDA stöder se [Talsyntesstöd](#SupportedSpeechSynths)-avsnittet.

En särskild post som alltid kommer att visas i den här listan är "Inget tal", vilket gör att du kan använda NVDA utan någon som helst talsyntes.
Detta kan vara användbart för någon som endast önskar använda NVDA med punktskrigt eller möjligtvis normalseende utvecklare som endast vill använda Talrutan.

##### Utmatningsenhet {#toc67}

Det här alternativet låter dig välja det ljudkort NVDA ska instruera den valda talsyntesen att tala genom.

#### Röstinställningar (NVDA+control+v) {#VoiceSettings}

Röstinställningsdialogrutan som finns under Inställningar-menyn innehåller alternativ för att ändra ljudet av talet.
För ett snabbare alternativt sätt att kontrollera talparametrar från varsom vänligen se [Talsyntesinställningsring](#SynthSettingsRing)-avsnittet.

Röstinställningsdialogrutan innehåller följande alternativ:

##### Röst {#toc69}

Det första alternativet du landar på i den här dialogrutan är en kombinationsruta som listar alla röster av den nuvarande talsyntesen du har installerad.
Du kan använda piltangenterna för att lyssna på de olika valen.
Vänster piltangent och piltangent upp tar dig uppåt i listan medan höger piltangent och piltangent ner tar dig neråt i listan.

##### Variant {#toc70}

Om du använder ESpeak-talsyntesen som är paketerad med NVDA är detta en kombinationsruta som låter dig välja vilken variant talsyntesen ska tala med.
ESpeaks varianter är lite som röster eftersom tillhandahåller något annourlunda attribut till eSpeak-rösten.
Några varianter låter som en man, några som en kvinna och några till och med som en groda.

##### Hastighet {#toc71}

Det här alternativet låter dig ändra hastigheten på rösten.
Det här är ett skjutreglare som går från 0 till 100 där 0 är den långsammaste och 100 den snabbaste.

##### Tonhöjd {#toc72}

Det här alternativet låter dig ändra tonhöjden på nuvarande röst.
Det är ett skjutreglage som går från 0 till 100 där 0 är den långsammaste och 100 den snabbaste.

##### Volym {#toc73}

Det här alternativet är ett skjutreglare som går från 0 till 100 där 0 är den lägsta volymen och 100 den högsta.

##### Betoning {#toc74}

Det här alternativet är ett skjutreglare som låter dig välja hur kraftig betoning talsyntesen ska använda. (Den enda talsyntesen som tillhandahåller detta alternativ för närvarande är eSpeak).

##### Skifta språk automatiskt {#toc75}

Den här kryssrutan låter dig växla om NVDA ska byta talsyntesspråk automatiskt om språkmärkning finns tillgänglig i texten som läses upp.
Det här alternativet är aktiverat som standard.
För närvarande stöder endast eSpeaks talsyntes automatisk skiftning av språk.

##### Skifta dialekt automatiskt {#toc76}

Om skifta språk automatiskt är aktiverat låter den här kryssrutan dig växla om du vill att dialektändringar ska göras utöver språkskifte t.ex. Om text läses i engelsk-amerikansk röst men dokumentet anger att en del text är på engelsk engelska då kommer talsyntes att skifta dialekt.
Det här alternativet är inaktiverat som standard.

<!-- KC:setting -->

##### Skiljetecken/symbol nivå {#toc77}

Tangent: NVDA+p

Det här låter dig välja mängden avskiljare och andra symboler som ska uttalas som ord.
Till exempel när det är satt till alla kommer alla symboler att uttalas som ord.
Det här alternativet gäller för alla talsynteser, inte endast den nuvarande aktiva talsyntesen.

##### Versaltonhöjning {#toc78}

Det här redigeringsfältet ger dig möjlighet att skriva in beloppet som tonhöjden kommer att förändras när en versal uttalas.
Det här värdet är ett procenttal, där negativa värden minskar tonhöjden och positiva värden ökar den.
För ingen tonhöjning använd 0.

##### Säg "stort" före versaler {#toc79}

Det här alternativet är en kryssruta som talar om för NVDA att säga ordet "stort" före alla versaler när de uttalas som individuella tecken såsom vid bokstavering.
Vanligtvis höjer NVDA tonhöjden en bit för alla versaler men några talsynteser kanske inte stöder detta väl, så kanske kan det här alternativet vara till nytta.

##### Avge pip för versaler {#toc80}

Om den här kryssrutan är kryssad kommer NVDA att avge ett litet pip varje gång den påträffar en ensam versal.
Liksom "säg stort före versaler"-kryssrutan kan detta vara användbart för talsyntewser som inte kan ändra tonhöjd för versaler.

##### Använd stavningsfunktionalitet om möjligt {#VoiceSpellingFunctionality}

Några ord består endast av ett tecken men uttalen är olika beroende på om tecknet uttalas som ett individuellt tecken (som vid bokstavering) eller ett ord.
Till exempel, på engelska, är "a" både ett tecken och ett ord.
Det här alternativet tillåter talsyntesen att göra skillnad på dessa två fall om talsyntesen stöder det.
De flesta talsynteser stöder detta.

Det hör alternativet bör vara aktivt.
Men några Microsoft Speech API-talsynteser implementerar inte detta korrekt och beter sig konstigt när det är påslaget.
Om du har problem med uttalet av individuella tecken prova att inaktivera detta alternativ.

#### Talsyntesinställningsring {#SynthSettingsRing}

Om du vill snabbt ändra talinställningar utan att gå till Röstinställningar-dialogrutan finns det några NVDA-kortkommandon som låter dig navigera genom de flesta röstinställningar från varsom när NVDA körs:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Beskrivning|
|---|---|---|---|
|Hoppar till nästa talsyntesinställning |NVDA+control+rightArrow |NVDA+shift+control+rightArrow |Hoppar till nästa tillgängliga röstinställning efter nuvarande|
|Hoppar till föregående talsyntesinställning |NVDA+control+leftArrow |NVDA+shift+control+leftArrow |Hoppar till föregående tillgängliga röstinställning|
|Inkrementera nuvarande talsyntesinställning |NVDA+control+upArrow |NVDA+shift+control+upArrow |Ökar aktuell röstinställning. T.ex. ökar hastigheten, väljer nästa röst, ökar volymen|
|Dekrementera nuvarande talsyntesinställning |NVDA+control+downArrow |NVDA+shift+control+downArrow |Minskar aktuell röstinställning. T.ex. minskar hastigheten, väljer föregående röst, minskar volymen|

<!-- KC:endInclude -->

#### Punktskriftsinställningar {#toc83}

Punktskriftsinställningar-dialogrutan kan öppnas genom att gå till Inställningar-menyn och till Punktskriftsinställningar-alternativet.

##### Punktskriftsdisplay {#toc84}

Det första alternativet du stöter på i dialogrutan är en kombinationsruta som säger "punktskriftsdisplay".
Du kommer att presenteras ett flertal val beroende på vilka punktskriftsdrivare som är tillgängliga på ditt system.
Navigera mellan dessa alternativ med piltangenterna.

Ingen punktskriftsdisplay betyder att du inte använder punktskrift.

Se [Punktskriftsdisplaystöd](#SupportedBrailleDisplays)-avsnittet för mer information om stöd för punktskriftsdisplayer.

##### Port {#toc85}

Det här alternativet, om tillgängligt, låter dig välja vilken port eller typ av anslutning som ska användas för att kommunicera med punktskriftsdisplayen du har valt.
Det är en kombinationsruta som innehåller de möjliga valen för din punktskriftsdisplay.

Som standard använder NVDA sig av automatisk portdetektering, vilket betyder att anslutning till din punktskriftsdisplay kommer att etableras automatiskt genom att skanna för tillgängliga USB- och bluetoothenheter på ditt system.
Men för vissa punktskriftsdisplayer måste explicit ange vilken port som ska användas.
Vanliga val är "Automatisk" (som talar om för NVDA att använda sig av standard automatisk portdetekteringsprocedur), "USB", "Bluetooth" och legacy serial kommunikationsportar om din punktskriftsdisplay stöder den här typen av kommunikation.

Det här alternativet kommer inte att vara tillgängligt om din punktskriftsdisplay endast stöder automatisk portdetektering.

Du kan konsultera dokumentationen för din punktskriftsdisplay i avsnittet [Punktskriftsdisplaystöd](#SupportedBrailleDisplays) för att se mer detaljer om de stödda typerna av kommunikation och tillgängliga portar.

##### Utmatningstabell {#toc86}

Nästa alternativ du kommer att se i den här dialogrutan är punktskriftsutmatningstabell-kombinationsrutan.
I den här kombinationsrutan finner du punktskriftstabeller för olika språk, punktskriftsstandarder och grader.
Den valda tabellen kommer att användas för att översätta text till punktskrift som kommer presenteras på din punktskriftsdisplay.
Du kan flytta från punktskriftstabell till punktskriftstabell i listan med hjälp av piltangenterna.

##### Inmatningstabell {#toc87}

Som komplement till det förra alternativet, är nästa inställning du hittar punktskriftsinmatningstabell-kombinationsrutan.
Den valda tabellen kommer att användas för att översätta punktskrift som matats in på din punktskriftsdisplay till text.
NVDA stöder för närvarande endast datorpunktskriftsinmatning så endast 8-punkters datorpunktskriftstabeller kommer att visas.
Du kan flytta från punktskriftstabell till punktskriftstabell i listan med hjälp av piltangenterna.

Observera att det här alternativet endast är användbart om din punktskriftsdisplay har ett Perkins-style tangentbord och den här funktionen stöds av punktskriftsdisplaydrivaren.
Om inmatning inte stöds på en display som har ett punktskriftstangentbord kommer det att noteras i [Punktskriftsdisplaystöd](#SupportedBrailleDisplays).

##### Expandera till punktskrift för ordet vid markören {#toc88}

Det här alternativet låter ordet som befinner sig under markören att visas i icke-kontrakterad datorpunktskrift.

##### Markörens blinkningshastighet (ms) {#toc89}

Det här alternativet är ett numeriskt fält som låter dig ändra markörens blinkhastighet i millisekunder.

##### Meddelandetimeout (sec) {#toc90}

Det här alternativet är ett numeriskt fält som låter dig bestämma hur länge NVDA-meddelanden ska visas på punktskriftsdisplayen.
0 inaktiverar visningen av meddelandena helt och hållet.

<!-- KC:setting -->

##### Koppla punktskrift till {#BrailleTether}

Tangent: NVDA+control+t

Det här alternativet låter dig välja om punktskriftsdisplayen ska följa systemfokus eller om det ska följa navigatorobjekt/granskningsmarkör.

##### Läs styckvis {#toc92}

Om aktiverat kommer punktskrift att visas per stycke istället för rad.
Dessutom kommer nästa och föregående rad-kommandon, i enlighet, att flytta stycke.
Detta betyder att du inte behöver skrolla displayen till slutet av varje rad även om mer text skulle kunna få plats på displayen.
Det här kan möjliggöra mer flytande läsning av större mängder text.
Detta alternativ är inaktiverat som standard.

#### Tangentbordsinställningar (NVDA+control+k) {#toc93}

Den här dialogrutan finns under "Tangentbordsinställningar..." i Inställningar-menyn.
Den innehåller följande alternativ:

##### Tangentbordslayout {#toc94}

Den här kombinationsrutan låter dig välja vilken typ av tangentbordslayout NVDA ska använda. För närvarande är de två som medföljer NVDA Stationär och Bärbar layout.

##### Använd skiftlås som NVDA-tangent {#toc95}

Om den här kryssrutan är kryssad kan skiftlås användas som NVDA-tangent.

##### Använd insert som NVDA-tangent {#toc96}

Om den här kryssrutan är kryssad kan insert användas som NVDA-tangent (finns oftas ovanför piltangenterna, nära home och end).

##### Använd numerisk insert som NVDA-tangent {#toc97}

Om den här kryssrutan är kryssad kan numerisk insert användas som NVDA-tangent.

Om ingen tangent väljs som NVDA-tangent kan det vara omöjligt att nå vissa NVDA-kommandon.
Därför kommer Tangentbordsinställningar-dialogrutan att visa ett felmeddelande om alla tangenter ej är valda när du trycker OK.
Efter att du avfärdar felmeddelandet måste du välja minst en innan du kan trycka på OK för att stänga dialogrutan ordentligt.

<!-- KC:setting -->

##### Tangenteko {#toc98}

Tangent: NVDA+2

Om aktiverad kommer NVDA att annonsera alla tecken du skriver med tangentbordet.

<!-- KC:setting -->

##### Tangenteko ord {#toc99}

Tangent: NVDA+3

Om aktiverad kommer NVDA att annonsera alla ord du skriver med tangentbordet.

##### Talavbrott för skrivna tecken {#toc100}

Om aktiverad kommer detta alternativ avbryta tal varje gång ett tecken matas in. Detta är aktiverat som standard.

##### Talavbrott för Enter-tangenten {#toc101}

Om aktiverad kommer detta alternativ avbryta tal varje gång enter matas in. Detta är aktiverat som standard.

##### Tillåt skumläsning i Läs allt {#toc102}

Om aktiverad kommer vissa navigeringskommandon (såsom snabbnavigation i läsläge eller att hoppa per rad eller avsnitt) inte att avbryta Läs allt utan Läs allt hoppar till den nya positionen och fortsätter att läsa.

##### Pip om skiftlås är på och små bokstäver skrivs {#toc103}

Om aktiverad kommer ett varningspip att höras om ett tecken skrivs med shift-tangenten ifal skiftlås är på.
Att skriva med skiftade tecken när skiftlås är på är ofta oavsiktligt och beror på att man inte är medeveten om att skiftlås är på.
Därför kan det vara ganska bra att varnas om detta.

<!-- KC:setting -->

##### Läs kommandotangenter {#toc104}

Tangent: NVDA+4

Om aktiverad kommer NVDA att annonsera alla icke-bokstavs tangenter du trycker på tangentbordet. Detta inkluderar tangentkombinationer såsom control plus ett annat tecken.

##### Hantera tangentbordstryckningar från andra applikationer {#toc105}

Det här alternativet låter användaren bestämma om tangentbordstryckningar generarade av applikationer såsom skärmtangentbord och taligenkänningsprogramvara bör behandlas av NVDA.
Detta alternativ är aktiverat som standard men vissa användare kanske vill stänga av detta, exempelvis de som skriver vietnamesiska med Unikey eftersom det kommer att orsaka felaktig inmatning av tecken.

#### Musinställningar (NVDA+control+m) {#MouseSettings}

Musinställningar-dialogrutan hittas under "Musinställningar..." i Inställningar-menyn.
Den innehåller följande alternativ:

##### Rapportera ändringar av musmarkörens utseende {#toc107}

En kryssruta som om ikryssad betyder att NVDA kommer att annonsera musens form varje gång muspekaren ändras.
Muspekaren i Windows ändrar form för att förmedla viss information såsom när något är redigerbart eller om något laddas etc.

<!-- KC:setting -->

##### Aktivera musföljning {#toc108}

Tangent: NVDA+m

Om aktiverad kommer NVDA att annonsera texten under muspekaren när du flyttar den runt på skärmen. Detta låter dig hitta saker på skärmen genom att fysiskt flytta musen istället för att försöka hitta dem genom objektnavigation.

##### Textenhetsupplösning {#toc109}

Om NVDA är inställd på att annonsera text under musen när du rör på den kommer detta allternativt att låta dig välja exakt hur mycket text som ska läsas upp.
Alternativen är tecken, ord, rad och avsnitt.

##### Rapportera objektets roll när musmarkören är över objektet {#toc110}

Om den här kryssrutan är ikryssad kommer NVDA att annonsera rollen (typen) objektet har när musen går in över det.

##### Spela upp koordinater när musen förflyttas {#toc111}

Om den här kryssrutan är ikryssad kommer NVDA att pipa när musen rör på sig, så att användaren kan lista ut var musen befinner sig förhållande till skärmens dimensioner.

##### Ljusstyrkan bestämmer ljudnivån på uppspelning av koordinater {#toc112}

Om "Spela upp koordinater när musen förflyttas"-kryssrutan är ikryssad och den här kryssrutan kryssas betyder det att ljudvolymen av koordinatpipen beror på hur ljus skärmen är under musen.
Den här inställningen är inaktiverad som standard.

#### Granskningsmarkörinställningar {#toc113}

Hittas under "Granskningsmarkör..." i Inställningar-menyn.
Den här dialogrutan innehåller följande alternativ: 

<!-- KC:setting -->

##### Följ systemfokus {#toc114}

Tangent: NVDA+7

Om aktiverad kommer granskningsmarkören alltid att placeras i samma objekt som nuvarande systemfokus när fokus ändras.

<!-- KC:setting -->

##### Följ systemmarkör {#toc115}

Tangent: NVDA+6

Om aktiverad kommer granskningsmarkören automatiskt att flyttas till positionen av systemmarkören varje gång den rör på sig.

##### Följ mus {#toc116}

Om aktiverad kommer granskningsmarkören att följa musen när den rör på sig.

##### Enkelt läsläge {#toc117}

Om aktiverad kommer NVDA att filtrerar hierarking av objekt som kan navigeras för att exkludera objekt som inte är intressanta för användaren, t. ex. osynliga objekt och objekt som endast används layout.

#### Objektpresentationsinställningar (NVDA+control+o) {#toc118}

Hittas under "Objektpresentation..." i Inställningar-menyn.
Den här dialogrutan innehåller följande alternativ:

##### Läs verktygstips {#toc119}

En kryssruta som om ikryssad talar om för NVDA att läsa verktygstips när de dyker upp.
Många Windows och kontroller visar ett litet meddelande (eller verktygstips) när du för musen över dem eller ibland när du för fokus till dem.

##### Läs hjälpballonger {#toc120}

Om den här kryssrutan är ikryssad kommer NVDA att läsa upp hjälpballonger när de dyker upp.
Hjälpballonger är som verktygstips menär vanligtvis större i storlek och associerade med systemhändelser såsom nätverkskabeln har blivit frånkopplad eller kanske för att varna dig om Windows säkerhetsfrågor. 

##### Rapportera objektkortkommandon {#toc121}

Om den här kryssrutan är ikryssad kommer NVDA att inkludera ett kortkommando som är associerat med ett visst objekt eller kontroll när den rapportas.
Exempelvis Arkiv-menyn på en menyrad kan ha ett kortkommando som alt+f.

##### Rapportera objektpositionsinformation {#toc122}

Det här alternativet låter dig välja om du vill objektets position (t.ex. 1 av 4) rapporterat när du flyttar till objektet med fokus- eller objektnavigation.

##### Gissa objektpositionsinformation när det är otillgängligt {#toc123}

Om Rapportera objektpositionsinformation är aktiverad kommer detta alternativ att tillåtta NVDA att gissa sig fram till positionsinformationen om den annars otillgänglig för en viss kontroll.

När den är på kommer NVDA att rapportera positionsinformation för fler kontroller såsom menyer och verktygsfält men informationen kan vara något felaktig.

##### Rapportera objektbeskrivning {#toc124}

Kryssa inte i denna kryssruta om du inte vill ha beskrivning rapporterad tillsammans med objekten.

<!-- KC:setting -->

##### Förloppsindikator-utmatning {#toc125}

Tangent: NVDA+u

Det här alternativet kontrollerar hur NVDA rapporterar förloppsindikatoruppdatering till dig

Det har följande alternativ:

* Av: Förloppsindikatorer kommer inte att rapporteras när de ändras.
* Tal: Det här alternativet talar om för NVDA att berätta förloppsframstegen i procent. Varje gång förloppsindikatorn ändras kommer NVDA att rapportera det nya värdet.
* Pip: Det här alternativet talar om för NVDA att pipa varje gång förloppsindikatorn ändras. Ju högre pip desto närmare är förloppsindikatorn målet.
* Pip och tal: Det här alternativet talar om för NVDA att både berätta och pipa förloppet.

##### Läs förloppsindikatorer i bakgrunden {#toc126}

Det här är ett alternativ som om ikryssat talar om för NVDA att rapportera förloppsindikatorer som inte befinner sig i förgrunden.
Om du minimerar eller växlar från ett fönster som innehåller en förloppsindikator kommer NVDA att hålla reda på den och tillåta dig göra andra saker under tiden.

<!-- KC:setting -->

##### Rapportera förändringar av dynamiskt innehåll {#toc127}

Tangent: NVDA+5

Växlar mellan annonsering av nytt innehåll i vissa objekt såsom terminaler och historik i chat-program.

#### Input Composition Settings {#toc128}

The Input Composition Settings dialog can be found under the Preferences menu.
This dialog allows you to control how NVDA reports the input of Asian characters, such as with IME or Text Service input methods.
Note that due to the fact that input methods vary greatly by available features and by how they convey information, it will most likely be necessary to configure these options differently for each input method to get the most efficient typing experience.

##### Automatically report all available candidates {#toc129}

This option, which is on by default,  allows you to choose whether or not all visible candidates should be reported automatically when a candidate list appears or its page is changed.
Having this option on for pictographic input methods such as chinese New ChangJie or Boshiami is useful, as you can automatically hear all symbols and their numbers and you can choose one right away.
However, for phonetic input methods such as chinese New Phonetic, it may be more useful to turn this option off, as all the symbols will sound the same and you will have to use the arrow keys to navigate the list items individually to gain more information  from the character descriptions for each candidate.

##### Announce Selected Candidate {#toc130}

This option, which is on by default, allows you to choose whether NVDA should announce the selected candidate when a candidate list appears or when the selection is changed.
For input methods where the selection can be changed with the arrow keys  (such as Chinese New Phonetic) this is necessary, but for some input methods it may be more efficient typing with this option turned off.
Note that even with this option off, the review cursor will still be placed on the selected candidate allowing you to use object navigation / review to manually read this or other candidates.

##### Always include short character descriptions for candidates {#toc131}

This option, which is on by default, allows you to choose whether or not NVDA should provide a short description for each character in a candidate, either when its selected or when its automatically read when the candidate list appears.
Note that for locales such as Chinese, the announcement of extra character descriptions for the selected candidate is not affected by this option.
This option may be useful for Korean and japanese input methods.

##### Report changes to the reading string {#toc132}

Some input methods such as Chinese New Phonetic and New ChangJie have a reading string (sometimes known as a precomposition string).
You can choose whether or not NVDA should announce new characters being typed into this reading string with this option.
This option is on by default.
Note some older input methods such as Chinese ChangJie may not use the reading string to hold precomposition characters, but instead use the composition string directly. Please see the next option for configuring reporting of the composition string.

##### Report changes to the composition string {#toc133}

After reading or precomposition data has been combined into a valid pictographic symbol, most input methods place this symbol into a composition string for temporary storage along with other combined symbols before they are finally inserted into the document.
This option allows you to choose whether or not NVDA should report new symbols as they appear  in the composition string.
This option is on by default.

#### Browse Mode Settings (NVDA+control+b) {#toc134}

The Browse Mode settings dialog can be found in the Preferences menu, under "Browse mode...".

The dialog contains the following options:

##### Maximum Number of Characters on One Line {#toc135}

This field sets the maximum length of a line in browse mode (in characters).

##### Maximum Lines Per Page {#toc136}

This field sets the amount of lines you will move by when pressing page up or page down while in browse mode.

<!-- KC:setting -->

##### Use screen layout {#toc137}

Tangent: NVDA+v

This option allows you to specify whether content in browse mode should place content such as links and other fields on their own line, or if it should keep them in the flow of text as it is visually shown. If the option is enabled then things will stay as they are visually shown, but if it is disabled then fields will be placed on their own line.

##### Automatic Say All on page load {#toc138}

This checkbox toggles the automatic reading of a page after it loads in browse mode.
This option is enabled by default.

##### Include layout tables {#toc139}

This option affects how NVDA handles tables used purely for layout purposes.
When on, NVDA will treat these as normal tables, reporting them based on [Document Formatting Settings](#DocumentFormattingSettings) and locating them with quick navigation commands.
When off, they will not be reported nor found with quick navigation.
However, the content of the tables will still be included as normal text.
This option is turned off by default.

##### Configuring reporting of fields such as links and headings {#toc140}

Please see the options in the [Document Formatting Settings dialog](#DocumentFormattingSettings) to configure the fields that are reported when navigating, such as links, headings and tables.

##### Automatic focus mode for focus changes {#toc141}

This option allows focus mode to be invoked if focus changes.
For example, when on a web page, if you press tab and you land on a form, if this option is checked, focus mode will automatically be invoked.

##### Automatic focus mode for caret movement {#toc142}

This option, when checked, allows NVDA to enter and leave focus mode when using arrow keys.
For example, if arrowing down a webpage and you land on an edit box, NVDA will automatically bring you into focus mode. If you arrow out of the edit box, NVDA will put you back in browse mode.

##### Audio indication of Focus and Browse modes {#toc143}

If this option is enabled, NVDA will play special sounds when it switches between browse mode and focus mode, rather than speaking the change.

#### Document Formatting Settings (NVDA+control+d) {#DocumentFormattingSettings}

This dialog box is found in the Preferences menu, under "Document Formatting...".

Most of the checkboxes in this dialog are for configuring what type of formatting you wish to have reported as you move the cursor around documents.
For example, if you check the report font name checkbox, each time you arrow onto text with a different font, the name of the font will be announced.

You can configure reporting of:

* Font name
* Font size
* Font attributes
* Text alignment
* Colors
* editor revisions
* Text style
* Spelling errors
* Page numbers
* Line numbers
* Line indentation
* Paragraph indentation (e.g. hanging indent, first line indent)
* Tables
* Table row/column headers
* Table cell coordinates
* Links
* Headings
* Lists
* Block quotes
* Landmarks
* Frames

##### Announce formatting changes after the cursor {#toc145}

If enabled, this setting tells NVDA to try and detect all the formatting changes on a line as it speaks it, even if doing this may slow down NVDA's performance.

By default, NVDA will detect the formatting at the position of the System caret / Review Cursor, and in some instances may detect formatting on the rest of the line, only if it is not going to cause a performance decrease.

Enable this option while proof reading documents in applications such as Microsoft Word, where formatting is important.

#### Speech dictionaries {#toc146}

The speech dictionaries menu (found in the Preferences menu) contains dialogs that allow you to manage the way NVDA pronounces particular words or phrases.
There are currently three different types of speech dictionaries.
They are:

* Default: rules in this dictionary affect all speech in NVDA.
* Voice: rules in this dictionary affect speech for the synthesizer voice currently being used.
* Temporary: rules in this dictionary affect all speech in NVDA, but only for the current session. These rules are temporary and will be lost if NVDA is restarted.

All dictionary dialogs contain a list of rules which will be used for processing the speech.
The dialog also contains Add, Edit and Remove buttons.

To add a new rule to the dictionary, press the Add button, and fill in the fields in the dialog box that appears and then press Ok.
You will then see your new rule in the list of rules.
However to make sure your rule is actually saved, make sure to press Ok to exit the dictionary dialog all together once you have finished adding/editing rules.

The rules for NVDA's speech dictionaries allow you to change one string of characters into another.
A simple example would be that you want to have NVDA say the word frog each time it is supposed to say the word bird.
In the Add rule dialog, the easiest way to do this is to type the word bird in the Pattern field, and the word frog in the Replacement field.
You may also want to type a description of the rule in the Comment field (something like: changes bird to frog).

NVDA's speech dictionaries however are much more powerful than simple word replacement.
The Add rule dialog also contains a checkbox to say whether or not you want the rule to be case sensitive (meaning that NVDA should care whether the characters are uppercase or lowercase.
NVDA ignores case by default).
Another checkbox allows you to state whether your pattern is a "Regular expression".
A regular expression is a pattern containing special symbols that allow you to match on more than one character at a time, or match on just numbers, or just letters, as a few examples.
Regular expressions are not covered in this user guide, but there are many tutorials on the web which can provide you with more information.

#### Punctuation/symbol pronunciation {#SymbolPronunciation}

This dialog allows you to change the way punctuation and other symbols are pronounced, as well as the symbol level at which they are spoken.

To change a symbol, first select it in the Symbols list.
The Replacement field allows you to change the text that should be spoken in place of this symbol.
Using the Level field, you can adjust the lowest symbol level at which this symbol should be spoken.

When you are finished, press the OK button to save your changes or the Cancel button to discard them.

#### Input Gestures {#toc148}

In this dialog, you can customize the input gestures (keys on the keyboard, buttons on a braille display, etc.) for NVDA commands.

Only commands that are applicable immediately before the dialog is opened are shown.
For example, if you want to customize commands related to browse mode, you should open the Input Gestures dialog while you are in browse mode.

The tree in this dialog lists all of the applicable NVDA commands grouped by category.
Any gestures associated with a command are listed beneath the command.

To add an input gesture to a command, select the command and press the Add button.
Then, perform the input gesture you wish to associate; e.g. press a key on the keyboard or a button on a braille display.
Often, a gesture can be interpreted in more than one way.
For example, if you pressed a key on the keyboard, you may wish it to be specific to the current keyboard layout (e.g. desktop or laptop) or you may wish it to apply for all layouts.
In this case, a menu will appear allowing you to select the desired option.

To remove a gesture from a command, select the gesture and press the Remove button.

When you are finished making changes, press the OK button to save them or the Cancel button to discard them.

### Saving and Reloading the configuration {#toc149}

By default NVDA will automatically save your settings on exit.
Note, however, that this option can be changed under the general options in the preferences menu.
To save the settings manually at any time, choose the Save configuration item in the NVDA menu.

If you ever make a mistake with your settings and need to revert back to the saved settings, choose the "revert to saved configuration" item in the NVDA menu.
You can also reset your settings to their original factory defaults by choosing Reset Configuration To Factory Defaults, which is also found in the NVDA menu.

The following NVDA key commands are also useful:
<!-- KC:beginInclude -->

| Namn |Stationär tangent |Bärbar tangent |Beskrivning|
|---|---|---|---|
|Save configuration |NVDA+control+c |NVDA+control+c |Saves your current configuration so that it is not lost when you exit NVDA|
|Revert  configuration |NVDA+control+r |NVDA+control+r |Pressing once resets your configuration to when you last saved it. Pressing three times will reset it back to factory defaults.|

<!-- KC:endInclude -->

### Configuration Profiles {#toc150}

Sometimes, you may wish to have different settings for different situations.
For example, you may wish to have reporting of indentation enabled while you are editing or reporting of font attributes enabled while you are proofreading.
NVDA allows you to do this using configuration profiles.

A configuration profile contains only those settings which are changed while the profile is being edited.
Most settings can be changed in configuration profiles except for those in the General Settings dialog, which apply to the entirety of NVDA.

Configuration profiles can be manually activated.
They can also be activated automatically due to triggers such as switching to a particular application.

#### Basic Management {#toc151}

You manage configuration profiles by selecting "Configuration profiles" in the NVDA menu.
You can also do this using a key command:
<!-- KC:beginInclude -->

* NVDA+control+p: Show the Configuration Profiles dialog.

<!-- KC:endInclude -->

The first control in this dialog is the profile list from which you can select one of the available profiles.
When you open the dialog, the profile you are currently editing is selected.
Additional information is also shown for active profiles, indicating whether they are manually activated, triggered and/or being edited.

To rename or delete a profile, press the Rename or Delete buttons, respectively.

Press the Close button to close the dialog.

#### Creating a Profile {#toc152}

To create a profile, press the New button.

In the New Profile dialog, you can enter a name for the profile.
You can also select how this profile should be used.
If you only want to use this profile manually, select Manual activation, which is the default.
Otherwise, select a trigger which should automatically activate this profile.
For convenience, if you haven't entered a name for the profile, selecting a trigger will fill in the name accordingly.
See [below](#ConfigProfileTriggers) for more information about triggers.

Pressing OK will create the profile and close the Configuration Profiles dialog so you can edit it.

#### Manual Activation {#ConfigProfileManual}

You can manually activate a profile by selecting a profile and pressing the Manual activate button.
Once activated, other profiles can still be activated due to triggers, but any settings in the manually activated profile will override them.
For example, if a profile is triggered for the current application and reporting of links is enabled in that profile but disabled it in the manually activated profile, links will not be reported.
However, if you have changed the voice in the triggered profile but have never changed it in the manually activated profile, the voice from the triggered profile will be used.
Any settings you change will be saved in the manually activated profile.
To deactivate a manually activated profile, select it in the Configuration Profiles dialog and press the Manual deactivate button.

#### Triggers {#ConfigProfileTriggers}

Pressing the Triggers button in the Configuration Profiles dialog allows you to change the profiles which should be automatically activated for various triggers.

The Triggers list shows the available triggers, which are as follows:

* Current application: Triggered when you switch to the current application.
* Läs allt: Triggered while reading with the say all command.

To change the profile which should be automatically activated for a trigger, select the trigger and then select the desired profile from the Profile list.
You can select (normal configuration) if you don't want a profile to be used.

Press the Close button to return to the Configuration Profiles dialog.

#### Editing a Profile {#toc155}

If you have manually activated a profile, any settings you change will be saved to that profile.
Otherwise, any settings you change will be saved to the most recently triggered profile.
For example, if you have associated a profile with the Notepad application and you switch to Notepad, any changed settings will be saved to that profile.
Finally, if there is neither a manually activated nor a triggered profile, any settings you change will be saved to your normal configuration.

To edit the profile associated with say all, you must [manually activate](#ConfigProfileManual) that profile.

#### Temporarily Disabling Triggers {#toc156}

Sometimes, it is useful to temporarily disable all triggers.
For example, you might wish to edit a manually activated profile or your normal configuration without triggered profiles interfering.
You can do this by checking the Temporarily disable all triggers checkbox in the Configuration Profiles dialog.

### Location of Configuration files {#toc157}

Portable versions of NVDA store all settings, custom appModules and custom drivers in a directory called userConfig, found in the NVDA directory.

Installed versions of NVDA store all settings, custom appModules and custom drivers in a special NVDA directory located in your Windows user profile.
This means that each user on the system can have their own NVDA settings.
To get to your settings directory for an installed version of NVDA, on the start menu you can go to programs -> NVDA -> explore user configuration directory.

Settings for NVDA when running on the logon or UAC screens are stored in the systemConfig directory in NVDA's installation directory.
Usually, this configuration should not be touched.
To change NVDA's configuration on the logon/UAC screens, configure NVDA as you wish while logged into Windows, save the configuration, and then press the "Use currently saved settings on the logon and other secure screens" button in the General Settings dialog.

## Extra Tools {#toc158}
### Log Viewer {#toc159}

The log viewer, found under Tools in the NVDA menu, allows you to view all the logging output that has occured up until now from when you last started NVDA.

Apart from reading the content, you can also Save a copy of the log file, or refresh the viewer so that it shows the most recent output since the Log viewer was opened.
These actions are available under the viewer's Log menu.

### Speech Viewer {#toc160}

For sighted software developers or people demoing NVDA to sighted audiences, a floating window is available that allows you to view all the text that NVDA is currently speaking.

To enable the speech viewer, check the "Speech Viewer" menu item under Tools in the NVDA menu.
Uncheck the menu item to disable it.

While the speech viewer is enabled, it constantly updates to show you the most current text being spoken.
However, if you click or focus inside the viewer, NVDA will temporarily stop updating the text, so that you are able to easily select or copy the existing content.

### Add-ons Manager {#toc161}

The Add-ons Manager, accessed by selecting Manage add-ons under Tools in the NVDA menu, allows you to install and uninstall add-on packages for NVDA.
These packages are provided by the community and contain custom code that may add or change features in NVDA or even provide support for extra Braille displays or speech synthesizers.

The Add-ons Manager contains a list that displays all the add-ons currently installed in your NVDA user configuration. 
A package name, version and author are shown for each add-on, though further information such as a description and URL can be viewed by selecting the add-on and pressing the About add-on button.
If there is help available for the selected add-on, you can access it by pressing the Add-on help button.

To browse and download available add-ons online, press the Get add-ons button.
This button opens the [NVDA Add-ons page](https://addons.nvda-project.org/).
If NVDA is installed on your system, you can open the add-on directly from the browser to begin the installation process as described below.
Otherwise, save the add-on package and follow the instructions below.

To install an Add-on you previously obtained, press the Install button.
This will allow you to browse for an add-on package (.nvda-addon file) somewhere on your computer or on a network.
Once you press Open, the installation process will begin.

When an add-on is being installed, NVDA will first ask you to confirm that you really wish to install the add-on.
As the functionality of add-ons is unrestricted inside NVDA, which in theory could include accessing your personal data or even the entire system if NVDA is an installed copy, it is very important to only install add-ons from sources you trust.
Once the add-on is installed, NVDA must be restarted for the add-on to start running. 
Until you do, a status of "install" will show for that add-on in the list.

To remove an add-on, select the add-on from the list and press the Remove button.
NVDA will ask if you really wish to do this.
As with installing, NVDA must be restarted for the add-on to be fully  removed.
Until you do, a status of "remove" will be shown for that add-on in the list.

The manager also has a Close button to close the dialog.
If you have installed or removed add-ons, NVDA will first ask you if you wish to restart so that your changes can take effect.

In the past it has been possible to extend NVDA's functionality by copying individual plugins and drivers in to your NVDA user Configuration directory.
Although this version of NVDA  may still   load them, they will not be shown in the Add-on Manager.
It is best to remove these files from your configuration and install  the appropriate add-on if one is available.

### Python Console {#toc162}

The NVDA Python console, found under Tools in the NVDA menu, is a development tool which is useful for debugging, general inspection of NVDA internals or inspection of the accessibility hierarchy of an application.
For more information, please see the Developer Guide available from [the Development section of the NVDA web site](https://community.nvda-project.org/wiki/Development).

### Reload plugins {#toc163}

This item, once activated, reloads app modules and global plugins without restarting NVDA, which can be useful for developers.

## Supported Speech Synthesizers {#SupportedSpeechSynths}

This section contains information about the speech synthesizers supported by NVDA.
For an even more extensive list of  free and commercial synthesizers that you can purchase and download for use with NVDA, please see the page at [https://www.nvda-project.org/wiki/ExtraVoices](https://www.nvda-project.org/wiki/ExtraVoices).

### eSpeak {#toc165}

The [eSpeak](https://espeak.sourceforge.net/) synthesizer is built directly into NVDA and does not require any other special drivers or components to be installed.
NVDA starts using eSpeak by default.
As this synthesizer is built into NVDA, this is a great choice for when running NVDA off a USB thumb drive on other systems.

Each voice that comes with eSpeak speaks a different language.
There are over 43 different languages supported by eSpeak.

There are also many variants which can be chosen to alter the sound of the voice.

### Microsoft Speech API version 4 (SAPI 4) {#toc166}

SAPI 4 is an older Microsoft standard for software speech synthesizers.
Many speech synthesizers that comply with this standard may be purchased or downloaded for free from various companies and websites.
When using this synthesizer with NVDA, the available voices (accessed from the [Voice Settings dialog](#VoiceSettings) or by the [Synth Settings Ring](#SynthSettingsRing)) will contain all the voices from all the installed SAPI 4 engines found on your system.

If you have SAPI 4 voices installed but the synthesizer does not appear in NVDA's list of synthesizers, please install the SAPI 4.0 runtime binaries, available at https://activex.microsoft.com/activex/controls/sapi/spchapi.exe.

### Microsoft Speech API version 5 (SAPI 5) {#toc167}

SAPI 5 is a Microsoft standard for software speech synthesizers.
Many speech synthesizers that comply with this standard may be purchased or downloaded for free from various companies and websites, though your system will probably already come with at least one SAPI 5 voice preinstalled.
When using this synthesizer with NVDA, the available voices (accessed from the [Voice Settings dialog](#VoiceSettings) or by the [Synth Settings Ring](#SynthSettingsRing)) will contain all the voices from all the installed SAPI 5 engines found on your system.

### Microsoft Speech Platform {#toc168}

The Microsoft Speech Platform provides voices for many languages which are normally used in the development of server-based speech applications.
These voices can also be used with NVDA.

To use these voices, you will need to install two components:

* Microsoft Speech Platform - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * This page includes many files for both speech recognition and text-to-speech.
 Choose the files containing the TTS data for the desired languages/voices.
 For example, the file MSSpeech_TTS_en-US_ZiraPro.msi is a U.S. English voice.

### Audiologic Tts3 {#toc169}

This is a commercial speech synthesizer specifically for the Italian language.
You must have the synthesizer installed on your system in order for it to be used with NVDA.
For more information, please visit the Audiologic website at [www.audiologic.it](http://www.audiologic.it).

This synthesizer does not support [spelling functionality](#VoiceSpellingFunctionality).

### Newfon {#toc170}

Newfon is a free commercial synthesizer by Sergey Shishmintzev which supports the Russian and Ukrainian languages.
To download this synthesizer, please visit the downloads section of the Russian NVDA community site: https://ru.nvda-community.org/?page_id=10

This synthesizer does not support [spelling functionality](#VoiceSpellingFunctionality).

### Nuance Vocalizer for NVDA {#toc171}

Nuance Vocalizer is a commercial, high quality voice synthesizer developed by Nuance Communications, Inc. and packaged specifically for NVDA by Tiflotecnia, Lda.
It contains over 50 different voices you can install, speaking over 30 languages.
All synthesizer components and voices are bundled in add-on packages, which allows for full usage in portable copies of NVDA.

You can get more information about Nuance Vocalizer for NVDA and how to buy it on its web site at [www.vocalizer-nvda.com](https://www.vocalizer-nvda.com/).
A percentage of sales of this product is donated to NV Access to fund further development of the NVDA Screen Reader.

## Supported Braille Displays {#SupportedBrailleDisplays}

This section contains information about the Braille displays supported by NVDA.

### Freedom Scientific Focus/PAC Mate Series {#toc173}

All Focus and PAC Mate displays from [Freedom Scientific](https://www.freedomscientific.com/) are supported when connected via USB or bluetooth.
You will need the Freedom Scientific braille display drivers installed on your system.
If you do not have them already, you can obtain them from https://www.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp.
Although this page only mentions the Focus Blue display, the drivers support all Freedom Scientific Focus and Pacmate displays.
If your system is running 64 bit Windows and the drivers were already installed by another screen reader, you will probably still need to install the drivers from this link, as the files required by NVDA were probably not installed by the other screen reader.

By default, NVDA can automatically detect and connect to these displays either via USB or bluetooth.
However, when configuring the display, you can explicitly select "USB" or "Bluetooth" ports to restrict the connection type to be used.
This might be useful if you want to connect the focus display to NVDA using bluetooth, but still be able to charge it using USB power from your computer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |topRouting1 (first cell on display)|
|Scroll braille display forward |topRouting20/40/80 (last cell on display)|
|Scroll braille display back |leftAdvanceBar|
|Scroll braille display forward |rightAdvanceBar|
|Toggle braille tethered to |leftGDFButton+rightGDFButton|
|Toggle left wiz wheel action |leftWizWheelPress|
|Move back using left wiz wheel action |leftWizWheelUp|
|Move forward using left wiz wheel action |leftWizWheelDown|
|Toggle right wiz wheel action |rightWizWheelPress|
|Move back using right wiz wheel action |rightWizWheelUp|
|Move forward using right wiz wheel action |rightWizWheelDown|
|Route to braille cell |routing|
|backspace key |dot7|
|enter key |dot8|
|shift+tab key |brailleSpaceBar+dot1+dot2|
|tab key |brailleSpaceBar+dot4+dot5|
|upArrow key |brailleSpaceBar+dot1|
|downArrow key |brailleSpaceBar+dot4|
|control+leftArrow key |brailleSpaceBar+dot2|
|control+rightArrow key |brailleSpaceBar+dot5|
|leftArrow |brailleSpaceBar+dot3|
|rightArrow key |brailleSpaceBar+dot6|
|home key |brailleSpaceBar+dot1+dot3|
|end key |brailleSpaceBar+dot4+dot6|
|control+home key |brailleSpaceBar+dot1+dot2+dot3|
|control+end key |brailleSpaceBar+dot4+dot5+dot6|
|alt key |brailleSpaceBar+dot1+dot3+dot4|
|alt+tab key |brailleSpaceBar+dot2+dot3+dot4+dot5|
|escape key |brailleSpaceBar+dot1+dot5|
|windows key |brailleSpaceBar+dot2+dot4+dot5+dot6|
|space key |brailleSpaceBar|
|windows+d key (minimize all applications) |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|Report Current Line |brailleSpaceBar+dot1+dot4|
|NVDA menu |brailleSpaceBar+dot1+dot3+dot4+dot5|

For newer Focus models that contain rocker bar keys (focus 40, focus 80 and focus blue):

| Namn |Tangent|
|---|---|
|Move braille display to previous line |leftRockerBarUp, rightRockerBarUp|
|Move braille display to next line |leftRockerBarDown, rightRockerBarDown|

For Focus 80 only:

| Namn |Tangent|
|---|---|
|Scroll braille display back |leftBumperBarUp, rightBumperBarUp|
|Scroll braille display forward |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc174}

Both the ALVA BC640 and BC680 displays from [Optelec](https://www.optelec.com/) are supported when connected via USB or bluetooth.
You do not need any specific drivers to be installed to use these displays.
Just plug in the display and configure NVDA to use it.

While these displays do have a braille keyboard, they handle translation from braille to text themselves.
Therefore, NVDA's braille input table setting is not relevant.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |t1|
|Move braille display to previous line |t2|
|Move braille display to next line |t4|
|Scroll braille display forward |t5|
|Route to braille cell |routing|
|shift+tab key |sp1|
|alt key |sp2|
|escape key |sp3|
|tab key |sp4|
|upArrow key |spUp|
|downArrow key |spDown|
|leftArrow key |spLeft|
|rightArrow key |spRight|
|enter key |spEnter|
|NVDA Menu |sp1+sp3|
|windows+d key (minimize all applications) |sp1+sp4|
|windows key |sp2+sp3|
|alt+tab key |sp2+sp4|

<!-- KC:endInclude -->

### Handy Tech Displays {#toc175}

NVDA supports all displays from [Handy Tech](https://www.handytech.de/) when connected via USB or bluetooth.
For older USB displays, you will need to install the USB drivers from Handy Tech on your system.

Braille input is not yet supported.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left, up|
|Scroll braille display forward |right, down|
|Move braille display to previous line |b4|
|Move braille display to next line |b5|
|Route to braille cell |routing|
|shift+tab key |esc|
|alt key |b2+b4+b5|
|escape key |b4+b6|
|tab key |enter|
|enter key |esc+enter|
|upArrow key |leftSpace|
|downArrow key |rightSpace|
|NVDA Menu |b2+b4+b5+b6|
|Handy Tech configuration |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc176}

The Lilli braille display available from [MDV](https://www.mdvbologna.it/) is supported.
You do not need any specific drivers to be installed to use this display.
Just plug in the display and configure NVDA to use it.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display backward |LF|
|Scroll braille display forward |RG|
|Move braille display to previous line |UP|
|Move braille display to next line |DN|
|Route to braille cell |route|
|shift+tab key |SLF|
|tab key |SRG|
|alt+tab key |SDN|
|alt+shift+tab key |SUP|

<!-- KC:endInclude -->

### Baum/Humanware/APH Braille Displays {#toc177}

Several [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/) and [APH](https://www.aph.org/) displays are supported when connected via USB or bluetooth.
These include:

* Baum: SuperVario, PocketVario
* HumanWare: Brailliant, BrailleConnect
* APH: Refreshabraille

Some other displays manufactured by Baum may also work, though this has not been tested.

If connecting via USB, you must first install the USB drivers provided by the manufacturer.
For the APH Refreshabraille, the USB mode must be set to serial.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |d2|
|Scroll braille display forward |d5|
|Move braille display to previous line |d1|
|Move braille display to next line |d3|
|Route to braille cell |routing|

For displays which have a joystick:

| Namn |Tangent|
|---|---|
|upArrow key |up|
|downArrow key |down|
|leftArrow key |left|
|rightArrow key |right|
|enter key |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#toc178}

The hedo ProfiLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Läs allt |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#toc179}

The hedo MobilLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Läs allt |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series {#toc180}

The Brailliant BI and B series of displays from [HumanWare](https://www.humanware.com/), including the BI 32, BI 40 and B 80, are supported when connected via USB or bluetooth.
If connecting via USB, you must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |down|
|Route to braille cell |routing|
|Toggle braille tethered to |up+down|
|upArrow key |space+dot1|
|downArrow key |space+dot4|
|leftArrow key |space+dot3|
|rightArrow key |space+dot6|
|NVDA Menu |c1+c3+c4+c5 (command n)|
|shift+tab key |space+dot1+dot3|
|tab key |space+dot4+dot6|
|alt key |space+dot1+dot3+dot4 (space+m)|
|escape key |space+dot1+dot5 (space+e)|
|enter key |dot8|
|windows+d key (minimize all applications) |c1+c4+c5 (command d)|
|windows key |space+dot3+dot4|
|alt+tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Läs allt |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE Series {#toc181}

NVDA supports Braille Sense and Braille EDGE displays from [Hims](https://www.hims-inc.com/) when connected via USB or bluetooth. 
If connecting via USB, you will need to install the USB drivers from HIMS on your system.
You can download these from the HIMS Resource Center: https://www.hims-inc.com/resource-center/
On this page, select your device and download the driver in the Window-Eyes section.
Although the section only mentions Window-Eyes, this is a general USB driver which will work with NVDA as well.

Following are the key assignments for these displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Move braille display to previous line |left side scroll up|
|Move braille display to next line |right side scroll up|
|Route to braille cell |routing|
|shift+tab key |dot1+dot2+space|
|alt key |dot1+dot3+dot4+Space|
|escape key |dot1+dot5+Space|
|tab key |dot4+dot5+Space|
|enter key |dot8|
|backspace key |dot7|
|upArrow key |dot1+Space|
|downArrow key |dot4+Space|
|capsLock |dot1+dot3+dot6+space|
|shift+alt+tab key |advance2+advance3+advance1|
|alt+tab key |advance2+advance3|
|end key |dot4+dot6+space|
|Control+end key |dot4+dot5+dot6+space|
|home key |dot1+dot3+space|
|control+home key |dot1+dot2+dot3+space|
|leftArrow key |dot3+space|
|control+shift+leftArrow key |dot2+dot8+space+advance1|
|control+leftArrow key |dot2+space|
|shift+alt+leftArrow key |dot2+dot7+advance1|
|alt+leftArrow key |dot2+dot7|
|rightArrow key |dot6+space|
|control+shift+rightArrow key |dot5+dot8+space+advance1|
|control+rightArrow key |dot5+space|
|shift+alt+rightArrow key |dot5+dot7+advance1|
|alt+rightArrow key |dot5+dot7|
|pageUp key |dot1+dot2+dot6+space|
|control+pageUp key |dot1+dot2+dot6+dot8+space|
|control+shift+upArrow key |dot2+dot3+dot8+space+advance1|
|control+upArrow key |dot2+dot3+space|
|shift+alt+upArrow key |dot2+dot3+dot7+advance1|
|alt+upArrow key |dot2+dot3+dot7|
|shift+upArrow key |left side scroll down + space|
|pageDown key |dot3+dot4+dot5+space|
|control+pagedown key |dot3+dot4+dot5+dot8+space|
|control+shift+downArrow key |dot5+dot6+dot8+space+advance1|
|control+downArrow key |dot5+dot6+space|
|shift+alt+downArrow key |dot5+dot6+dot7+advance1|
|alt+downArrow key |dot5+dot6+dot7|
|shift+downArrow key |right side scroll down + space|
|delete key |dot1+dot3+dot5+space|
|f1 key |dot1+dot2+dot5+space|
|f3 key |dot1+dot2+dot4+dot8|
|f4 key |dot7+advance3|
|windows+b key |dot1+dot2+advance1|
|windows+d key |dot1+dot4+dot5+advance1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc182}

NVDA supports the SyncBraille Display from [HIMS](https://www.hims-inc.com/).
You will need to install the USB drivers from HIMS on your system.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Seika Braille Displays {#toc183}

The Seika Version 3, 4 and 5 (40 cells) and Seika80 (80 cells) braille displays from [Nippon Telesoft](https://www.nippontelesoft.com/) are supported.
You can find more information about these displays at https://www.seika-braille.com/.
You must first install the USB drivers provided by the manufacturer.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |b3|
|Move braille display to next line |b4|
|Toggle braille tethered to |b5|
|Läs allt |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|NVDA Menu |left+right|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Newer Models {#toc184}

The following Braille displays are supported: 

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB and bluetooth)

If BrxCom is installed, NVDA will use BrxCom.
BrxCom is a tool that allows you to use the Braille input independently from a screen reader.
A new version of BrxCom which works with NVDA will be released by Papenmeier soon.  
However, braille input is possible with the Trio device without BrxCom.

Most devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
The c-series is the only exception to this rule.

The c-series and some other displays have two routing rows whereby the upper row is used to report formatting information.
Holding one of the upper routing keys and pressing the EAB on c-series devices emulates the second switch state.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.

Generally, the following keys are available on these braille displays:

| Namn |Tangent|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:
<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Report title |l1+up|
|Report Status Bar |l2+down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |left2|
|Move to next object |right2|
|Report text formatting |upper routing row|

<!-- KC:endInclude -->

The Trio model has four additional keys which are in front of the braille keyboard.
These are (ordered from left to right):

* left thumb key (lt)
* space
* space
* right thumb key (rt)

Currently, the right thumb key is not in use.
The inner keys are both mapped to space.

<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|backspace key |dot 7|
|enter key |dot 8|
|escape key |space with dot 7|
|upArrow key |space with dot 2|
|leftArrow key |space with dot 1|
|rightArrow key |space with dot 4|
|downArrow |space with dot 5|
|control key |lt+dot2|
|alt key |lt+dot3|
|control+escape key |space with dot 1 2 3 4 5 6|
|tab key |space with dot 3 7|

<!-- KC:endInclude  -->

### Papenmeier Braille BRAILLEX Older Models {#toc185}

The following Braille displays are supported: 

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Note that these displays can only be connected via a serial port.
Therefore, you should select the port to which the display is connected after you have chosen this driver in the Braille Settings dialogue.

Some of these devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.
Older devices do not have an EAB; front keys are used instead.

Generally, the following keys are available on braille displays:

| Namn |Tangent|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:

<!-- KC:beginInclude -->
Devices with EAB:

| Namn |Tangent|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Report title |l1up|
|Report Status Bar |l2down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to next object |right2|
|Move to previous object |left2|
|Report text formatting |Upper routing strip|

BRAILLEX Tiny:

| Namn |Tangent|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Toggle braille tethered to |r2|
|Move to containing object |r1+up|
|Move to first contained object |r1+dn|
|Move to previous object |r1+left|
|Move to next object |r1+right|
|Report text formatting |reportf|

BRAILLEX 2D Screen:

| Namn |Tangent|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report text formatting |reportf|
|Move braille display to previous line |up|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to next line |dn|
|Move to next object |left2|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#toc186}

NVDA supports the BrailleNote notetakers from [Humanware](https://www.humanware.com) when acting as a display terminal for a screen reader.
The following models are supported:

* BrailleNote Classic (serial connection only)
* BrailleNote PK (Serial and bluetooth connections)
* BrailleNote MPower (Serial and bluetooth connections)
* BrailleNote Apex (USB and Bluetooth connections)

If your device supports more than one type of connection, when connecting your BrailleNote to NVDA, you must set the braille terminal port in braille terminal options.
Please check the BrailleNote manual for details.
In NVDA, you may also need to set the port in the Braille Settings dialog.
If you are connecting via USB or bluetooth, you can set the port to "Automatic", "USB" or "Bluetooth", depending on the available choices.
If connecting using a legacy serial port (or a USB to serial converter) or if none of the previous options appear, you must explicitly choose the communication port to be used from the list of hardware ports.

Before connecting your BrailleNote Apex using its USB client interface, you must install the drivers provided by HumanWare.

Following are the BrailleNote command assignments for NVDA.
Please check your BrailleNote's documentation to find where these keys are located.

<!-- KC:beginInclude -->

| Namn |Tangent|
|---|---|
|Scroll braille display back |back|
|Scroll braille display forward |advance|
|Move braille display to previous line |previous|
|Move braille display to next line |next|
|Route to braille cell |routing|
|Toggle braille tethered to |previous+next|
|Up arrow key |space+dot1|
|Down arrow key |space+dot4|
|Left Arrow key |space+dot3|
|Right arrow key |space+dot6|
|Page up key |space+dot1+dot3|
|Page down key |space+dot4+dot6|
|Home key |space+dot1+dot2|
|End key |space+dot4+dot5|
|Control+home keys |space+dot1+dot2+dot3|
|Control+end keys |space+dot4+dot5+dot6|
|Space key |space|
|Enter key |space+dot8|
|Backspace key |space+dot7|
|Tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Shift+tab keys |space+dot1+dot2+dot5+dot6|
|Windows key |space+dot2+dot4+dot5+dot6 (space+w)|
|Alt key |space+dot1+dot3+dot4 (space+m)|
|Toggle input help |space+dot2+dot3+dot6 (space+lower h)|

<!-- KC:endInclude -->

### BRLTTY {#toc187}

[BRLTTY](https://mielke.cc/brltty/) is a separate program which can be used to support many more braille displays.
In order to use this, you need to install [BRLTTY for Windows](https://brl.thefreecat.org/brltty/).
You should download and install the latest installer package, which will be named, for example, brltty-win-4.2-2.exe.
When configuring the display and port to use, be sure to pay close attention to the instructions, especially if you are using a USB display and already have the manufacturer's drivers installed.

For displays which have a braille keyboard, BRLTTY currently handles braille input itself.
Therefore, NVDA's braille input table setting is not relevant.

Following are the BRLTTY command assignments for NVDA.
Please see the [BRLTTY key tables documentation](https://mielke.cc/brltty/doc/drivers/) for information about how BRLTTY commands are mapped to controls on braille displays.
<!-- KC:beginInclude -->

| Namn |BRLTTY command|
|---|---|
|Scroll braille display back |fwinlt (go left one window)|
|Scroll braille display forward |fwinrt (go right one window)|
|Move braille display to previous line |lnup (go up one line)|
|Move braille display to next line |lndn (go down one line)|
|Route to braille cell |route (bring cursor to character)|

<!-- KC:endInclude -->

## Advanced Topics {#toc188}
### Advanced Customization of Symbol Pronunciation {#toc189}

It is possible to customize the pronunciation of punctuation and other symbols beyond what can be done using the [Punctuation/symbol pronunciation](#SymbolPronunciation) dialog.
For example, you can specify whether the raw symbol should be sent to the synthesizer (e.g. to cause a pause or change in inflection) and you can add custom symbols.

To do this, you must edit the symbol pronunciation information file in your NVDA user configuration directory.
The file is called symbols-xx.dic, where xx is the language code.
The format of this file is documented in the Symbol Pronunciation section of the NVDA Developer Guide, which is available from [the Development section of the NVDA web site](https://community.nvda-project.org/wiki/Development).
However, it is not possible for users to define complex symbols.

## Further Information {#toc190}

If you require further information or assistance regarding NVDA, please visit the NVDA web site at NVDA_URL.
Here, you can find additional documentation, as well as technical support and community resources.
This site also provides information and resources concerning NVDA development.

