## Get support

Whether you are a beginner, an advanced user, a new or a long time developer; or if you represent an organization wishing to know more or to contribute to NVDA: you can get support through the included documentation as well as several communication channels dedicated to the NVDA screen reader.
Here is an overview of the most important support sources.

### Important links

* You can find information on user support on the [NV Access website](https://www.nvaccess.org/get-help/).
* [Reporting issues on GitHub](../issues/readme.md)
* [NVDA on GitHub](https://github.com/nvaccess/nvda)
* [Contributing to NVDA](../../.github/CONTRIBUTING.md).
This includes information on reporting issues, triaging issues, testing, translating, contributing code/documentation and creating add-ons.
* The NVDA repository [Wiki](https://github.com/nvaccess/nvda/wiki) contains more guides and documentation.
* [NVDA development snapshots](https://download.nvaccess.org/snapshots/alpha/): Automatically generated builds of the project in its current state of development
* [Translating NVDA](../translating/readme.md): Information about how to translate NVDA into another language

### Documentation

* [NVDA User Guide](https://download.nvaccess.org/documentation/userGuide.html)
* [NVDA Developer Guide](https://download.nvaccess.org/documentation/developerGuide.html)
* [Key Commands](https://download.nvaccess.org/documentation/keyCommands.html)
* [Changes in the latest release](https://download.nvaccess.org/documentation/changes.html)
* [Release process](./releaseProcess.md)

### Add-ons

* [The NVDA Add-on store](https://download.nvaccess.org/documentation/userGuide.html#AddonsManager)
* [Community add-ons website](https://addons.nvda-project.org/).
This website is considered legacy software, using the NVDA Add-on Store instead is encouraged.

### Communication channels

* [Experts list](./expertsList.md) for finding experts in the NVDA community

#### NV Access

* See the [NV Access](https://www.nvaccess.org/contact-us/) website for our social media accounts and other contact information.
* [NVDA Add-on API Mailing List](https://groups.google.com/a/nvaccess.org/g/nvda-api)

#### NVDA Community

* [NVDA Users Mailing List](https://groups.google.com/a/nvaccess.org/g/nvda-users)
* [NVDA Developers Mailing List](https://groups.io/g/nvda-devel)
* [NVDA Translators list](https://groups.io/g/nvda-translations)
* [NVDA Add-ons Mailing List](https://groups.io/g/nvda-addons)
* [NVDA Community Gitter channel](https://gitter.im/nvaccess/NVDA) (Instant Messaging)
* [Other sources including groups and profiles on social media channels, language-specific websites and mailing lists etc.](https://github.com/nvaccess/nvda/wiki/Connect)
