# A part of NonVisual Desktop Access (NVDA)
# Copyright (C) 2017 NV Access Limited
# This file is covered by the GNU General Public License.

import controlTypes

msoShape10pointStar = 149
msoShape12pointStar = 150
msoShape16pointStar = 94
msoShape24pointStar = 95
msoShape32pointStar = 96
msoShape4pointStar = 91
msoShape5pointStar = 92
msoShape6pointStar = 147
msoShape7pointStar = 148
msoShape8pointStar = 93
msoShapeActionButtonBackorPrevious = 129
msoShapeActionButtonBeginning = 131
msoShapeActionButtonCustom = 125
msoShapeActionButtonDocument = 134
msoShapeActionButtonEnd = 132
msoShapeActionButtonForwardorNext = 130
msoShapeActionButtonHelp = 127
msoShapeActionButtonHome = 126
msoShapeActionButtonInformation = 128
msoShapeActionButtonMovie = 136
msoShapeActionButtonReturn = 133
msoShapeActionButtonSound = 135
msoShapeArc = 25
msoShapeBalloon = 137
msoShapeBentArrow = 41
msoShapeBentUpArrow = 44
msoShapeBevel = 15
msoShapeBlockArc = 20
msoShapeCan = 13
msoShapeChartPlus = 182
msoShapeChartStar = 181
msoShapeChartX = 180
msoShapeChevron = 52
msoShapeChord = 161
msoShapeCircularArrow = 60
msoShapeCloud = 179
msoShapeCloudCallout = 108
msoShapeCorner = 162
msoShapeCornerTabs = 169
msoShapeCross = 11
msoShapeCube = 14
msoShapeCurvedDownArrow = 48
msoShapeCurvedDownRibbon = 100
msoShapeCurvedLeftArrow = 46
msoShapeCurvedRightArrow = 45
msoShapeCurvedUpArrow = 47
msoShapeCurvedUpRibbon = 99
msoShapeDecagon = 144
msoShapeDiagonalStripe = 141
msoShapeDiamond = 4
msoShapeDodecagon = 146
msoShapeDonut = 18
msoShapeDoubleBrace = 27
msoShapeDoubleBracket = 26
msoShapeDoubleWave = 104
msoShapeDownArrow = 36
msoShapeDownArrowCallout = 56
msoShapeDownRibbon = 98
msoShapeExplosion1 = 89
msoShapeExplosion2 = 90
msoShapeFlowchartAlternateProcess = 62
msoShapeFlowchartCard = 75
msoShapeFlowchartCollate = 79
msoShapeFlowchartConnector = 73
msoShapeFlowchartData = 64
msoShapeFlowchartDecision = 63
msoShapeFlowchartDelay = 84
msoShapeFlowchartDirectAccessStorage = 87
msoShapeFlowchartDisplay = 88
msoShapeFlowchartDocument = 67
msoShapeFlowchartExtract = 81
msoShapeFlowchartInternalStorage = 66
msoShapeFlowchartMagneticDisk = 86
msoShapeFlowchartManualInput = 71
msoShapeFlowchartManualOperation = 72
msoShapeFlowchartMerge = 82
msoShapeFlowchartMultidocument = 68
msoShapeFlowchartOfflineStorage = 139
msoShapeFlowchartOffpageConnector = 74
msoShapeFlowchartOr = 78
msoShapeFlowchartPredefinedProcess = 65
msoShapeFlowchartPreparation = 70
msoShapeFlowchartProcess = 61
msoShapeFlowchartPunchedTape = 76
msoShapeFlowchartSequentialAccessStorage = 85
msoShapeFlowchartSort = 80
msoShapeFlowchartStoredData = 83
msoShapeFlowchartSummingJunction = 77
msoShapeFlowchartTerminator = 69
msoShapeFoldedCorner = 16
msoShapeFrame = 158
msoShapeFunnel = 174
msoShapeGear6 = 172
msoShapeGear9 = 173
msoShapeHalfFrame = 159
msoShapeHeart = 21
msoShapeHeptagon = 145
msoShapeHexagon = 10
msoShapeHorizontalScroll = 102
msoShapeIsoscelesTriangle = 7
msoShapeLeftArrow = 34
msoShapeLeftArrowCallout = 54
msoShapeLeftBrace = 31
msoShapeLeftBracket = 29
msoShapeLeftCircularArrow = 176
msoShapeLeftRightArrow = 37
msoShapeLeftRightArrowCallout = 57
msoShapeLeftRightCircularArrow = 177
msoShapeLeftRightRibbon = 140
msoShapeLeftRightUpArrow = 40
msoShapeLeftUpArrow = 43
msoShapeLightningBolt = 22
msoShapeLineCallout1 = 109
msoShapeLineCallout1AccentBar = 113
msoShapeLineCallout1BorderandAccentBar = 121
msoShapeLineCallout1NoBorder = 117
msoShapeLineCallout2 = 110
msoShapeLineCallout2AccentBar = 114
msoShapeLineCallout2BorderandAccentBar = 122
msoShapeLineCallout2NoBorder = 118
msoShapeLineCallout3 = 111
msoShapeLineCallout3AccentBar = 115
msoShapeLineCallout3BorderandAccentBar = 123
msoShapeLineCallout3NoBorder = 119
msoShapeLineCallout4 = 112
msoShapeLineCallout4AccentBar = 116
msoShapeLineCallout4BorderandAccentBar = 124
msoShapeLineCallout4NoBorder = 120
msoShapeLineInverse = 183
msoShapeMathDivide = 166
msoShapeMathEqual = 167
msoShapeMathMinus = 164
msoShapeMathMultiply = 165
msoShapeMathNotEqual = 168
msoShapeMathPlus = 163
msoShapeMixed = -2
msoShapeMoon = 24
msoShapeNonIsoscelesTrapezoid = 143
msoShapeNoSymbol = 19
msoShapeNotchedRightArrow = 50
msoShapeNotPrimitive = 138
msoShapeOctagon = 6
msoShapeOval = 9
msoShapeOvalCallout = 107
msoShapeParallelogram = 2
msoShapePentagon = 51
msoShapePie = 142
msoShapePieWedge = 175
msoShapePlaque = 28
msoShapePlaqueTabs = 171
msoShapeQuadArrow = 39
msoShapeQuadArrowCallout = 59
msoShapeRectangle = 1
msoShapeRectangularCallout = 105
msoShapeRegularPentagon = 12
msoShapeRightArrow = 33
msoShapeRightArrowCallout = 53
msoShapeRightBrace = 32
msoShapeRightBracket = 30
msoShapeRightTriangle = 8
msoShapeRound1Rectangle = 151
msoShapeRound2DiagRectangle = 157
msoShapeRound2SameRectangle = 152
msoShapeRoundedRectangle = 5
msoShapeRoundedRectangularCallout = 106
msoShapeSmileyFace = 17
msoShapeSnip1Rectangle = 155
msoShapeSnip2DiagRectangle = 157
msoShapeSnip2SameRectangle = 156
msoShapeSnipRoundRectangle = 154
msoShapeSquareTabs = 170
msoShapeStripedRightArrow = 49
msoShapeSun = 23
msoShapeSwooshArrow = 178
msoShapeTear = 160
msoShapeTrapezoid = 3
msoShapeUpArrow = 35
msoShapeUpArrowCallout = 55
msoShapeUpDownArrow = 38
msoShapeUpDownArrowCallout = 58
msoShapeUpRibbon = 97
msoShapeUTurnArrow = 42
msoShapeVerticalScroll = 101
msoShapeWave = 103

msoAutoShapeTypeToRoleText = {
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape10pointStar: pgettext("shape", "10-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape12pointStar: pgettext("shape", "12-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape16pointStar: pgettext("shape", "16-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape24pointStar: pgettext("shape", "24-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape32pointStar: pgettext("shape", "32-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape4pointStar: pgettext("shape", "4-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape5pointStar: pgettext("shape", "5-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape6pointStar: pgettext("shape", "6-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape7pointStar: pgettext("shape", "7-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShape8pointStar: pgettext("shape", "8-point star"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeArc: pgettext("shape", "Arc"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeBalloon: pgettext("shape", "Balloon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeBentArrow: pgettext("shape", "Bent arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeBentUpArrow: pgettext("shape", "Bent Up Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeBevel: pgettext("shape", "Bevel"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeBlockArc: pgettext("shape", "Block arc"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCan: pgettext("shape", "Can"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeChartPlus: pgettext("shape", "Chart Plus symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeChartStar: pgettext("shape", "Chart Star Symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeChartX: pgettext("shape", "Chart X Symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeChevron: pgettext("shape", "Chevron"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeChord: pgettext("shape", "Circle with line through center"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCircularArrow: pgettext("shape", "Circular Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCloud: pgettext("shape", "Cloud shape"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCloudCallout: pgettext("shape", "Cloud callout"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCorner: pgettext("shape", "Corner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCornerTabs: pgettext("shape", "four snipped corners"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCross: pgettext("shape", "Cross"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCube: pgettext("shape", "Cube"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedDownArrow: pgettext("shape", "Curved Down Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedDownRibbon: pgettext("shape", "Ribbon banner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedLeftArrow: pgettext("shape", "Curved Left Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedRightArrow: pgettext("shape", "Curved Right Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedUpArrow: pgettext("shape", "Curved Up Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeCurvedUpRibbon: pgettext("shape", "Curved Up Ribbon banner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDecagon: pgettext("shape", "Decagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDiagonalStripe: pgettext("shape", "Diagonal stripe"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDiamond: pgettext("shape", "Diamond"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDodecagon: pgettext("shape", "Dodecagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDonut: pgettext("shape", "Donut"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDoubleBrace: pgettext("shape", "Double brace"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDoubleBracket: pgettext("shape", "Double bracket"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDoubleWave: pgettext("shape", "Double wave"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDownArrow: pgettext("shape", "Down Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDownArrowCallout: pgettext("shape", "Callout with Down Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeDownRibbon: pgettext("shape", "Ribbon banner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeExplosion1: pgettext("shape", "Explosion"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeExplosion2: pgettext("shape", "Explosion"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartAlternateProcess: pgettext("shape", "Alternate process flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartCard: pgettext("shape", "Card flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartCollate: pgettext("shape", "Collate flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartConnector: pgettext("shape", "Connector flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartData: pgettext("shape", "Data flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartDecision: pgettext("shape", "Decision flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartDelay: pgettext("shape", "Delay flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartDirectAccessStorage: pgettext("shape", "Direct access storage flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartDisplay: pgettext("shape", "Display flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartDocument: pgettext("shape", "Document flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartExtract: pgettext("shape", "Extract flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartInternalStorage: pgettext("shape", "Internal storage flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartMagneticDisk: pgettext("shape", "Magnetic disk flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartManualInput: pgettext("shape", "Manual input flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartManualOperation: pgettext("shape", "Manual operation flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartMerge: pgettext("shape", "Merge flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartMultidocument: pgettext("shape", "Multi-document flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartOfflineStorage: pgettext("shape", "Offline storage flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartOffpageConnector: pgettext("shape", "Off-page connector flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartOr: pgettext("shape", "'Or' flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartPredefinedProcess: pgettext("shape", "Predefined process flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartPreparation: pgettext("shape", "Preparation flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartProcess: pgettext("shape", "Process flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartPunchedTape: pgettext("shape", "Punched tape flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartSequentialAccessStorage: pgettext("shape", "Sequential access storage flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartSort: pgettext("shape", "Sort flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartStoredData: pgettext("shape", "Stored data flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartSummingJunction: pgettext("shape", "Summing junction flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFlowchartTerminator: pgettext("shape", "Terminator flowchart symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFoldedCorner: pgettext("shape", "Folded corner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFrame: pgettext("shape", "Rectangular picture frame"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeFunnel: pgettext("shape", "Funnel"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeGear6: pgettext("shape", "Gear with six teeth"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeGear9: pgettext("shape", "Gear with nine teeth"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeHalfFrame: pgettext("shape", "Half of rectangular picture frame"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeHeart: pgettext("shape", "Heart"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeHeptagon: pgettext("shape", "Heptagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeHexagon: pgettext("shape", "Hexagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeHorizontalScroll: pgettext("shape", "Horizontal scroll"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeIsoscelesTriangle: pgettext("shape", "Isosceles triangle"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftArrow: pgettext("shape", "Left Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftArrowCallout: pgettext("shape", "Callout with Left Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftBrace: pgettext("shape", "Left brace"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftBracket: pgettext("shape", "Left bracket"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftCircularArrow: pgettext("shape", "Counter-clockwise Circular arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftRightArrow: pgettext("shape", "Double-ended horizontal Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftRightArrowCallout: pgettext("shape", "Callout with Double-ended horizontal Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftRightCircularArrow: pgettext("shape", "Double-ended Circular arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftRightRibbon: pgettext("shape", "Ribbon with left and right arrows"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftRightUpArrow: pgettext("shape", "Left right and up Arrows"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLeftUpArrow: pgettext("shape", "Left and up Arrows"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLightningBolt: pgettext("shape", "Lightning bolt"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout1: pgettext("shape", "Line Callout"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout1AccentBar: pgettext("shape", "Callout with horizontal accent bar"),
	msoShapeLineCallout1BorderandAccentBar: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with border and horizontal accent bar",
	),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout1NoBorder: pgettext("shape", "Callout with horizontal line"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout2: pgettext("shape", "Callout with diagonal straight line"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout2AccentBar: pgettext("shape", "Callout with diagonal callout line and accent bar"),
	msoShapeLineCallout2BorderandAccentBar: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with border, diagonal straight line and accent bar",
	),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout2NoBorder: pgettext("shape", "Callout with no border and diagonal callout line"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout3: pgettext("shape", "Callout with angled line"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout3AccentBar: pgettext("shape", "Callout with angled callout line and accent bar"),
	msoShapeLineCallout3BorderandAccentBar: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with border, angled callout line, and accent bar",
	),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout3NoBorder: pgettext("shape", "Callout with no border and angled callout line"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineCallout4: pgettext("shape", "Callout with callout line segments forming a U-shape"),
	msoShapeLineCallout4AccentBar: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with accent bar and callout line segments forming a U-shape",
	),
	msoShapeLineCallout4BorderandAccentBar: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with border, accent bar, and callout line segments forming a U-shape",
	),
	msoShapeLineCallout4NoBorder: pgettext(
		"shape",
		# Translators: a shape name from Microsoft Office.
		# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
		"Callout with no border and callout line segments forming a U-shape",
	),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeLineInverse: pgettext("shape", "Line inverse"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathDivide: pgettext("shape", "Math Division symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathEqual: pgettext("shape", "Math Equivalence symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathMinus: pgettext("shape", "Math Subtraction symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathMultiply: pgettext("shape", "Math Multiplication symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathNotEqual: pgettext("shape", "Math Non-equivalence symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMathPlus: pgettext("shape", "Math Addition symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeMoon: pgettext("shape", "Moon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeNonIsoscelesTrapezoid: pgettext("shape", "Trapezoid with asymmetrical non-parallel sides"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeNoSymbol: pgettext("shape", "'No' symbol"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeNotchedRightArrow: pgettext("shape", "Notched RightArrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeOctagon: pgettext("shape", "Octagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeOval: pgettext("shape", "Oval"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeOvalCallout: pgettext("shape", "Oval-shaped callout"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeParallelogram: pgettext("shape", "Parallelogram"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapePentagon: pgettext("shape", "Pentagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapePie: pgettext("shape", "Incomplete Pie with wedge missing"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapePieWedge: pgettext("shape", "Quarter Pie Wedge"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapePlaque: pgettext("shape", "Plaque"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapePlaqueTabs: pgettext("shape", "Plaque Tabs"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeQuadArrow: pgettext("shape", "Arrows pointing left right up and down"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeQuadArrowCallout: pgettext("shape", "Callout with Arrows pointing left right up and down"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRectangle: pgettext("shape", "Rectangle"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRectangularCallout: pgettext("shape", "Rectangular callout"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRegularPentagon: pgettext("shape", "Pentagon"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRightArrow: pgettext("shape", "Right Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRightArrowCallout: pgettext("shape", "Callout with Right Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRightBrace: pgettext("shape", "Right brace"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRightBracket: pgettext("shape", "Right bracket"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRightTriangle: pgettext("shape", "Right triangle"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRound1Rectangle: pgettext("shape", "Rectangle with one rounded corner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRound2DiagRectangle: pgettext("shape", "Rectangle with two rounded corners diagonally-opposed"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRound2SameRectangle: pgettext("shape", "Rectangle with two-rounded corners that share a side"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRoundedRectangle: pgettext("shape", "Rounded rectangle"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeRoundedRectangularCallout: pgettext("shape", "Rounded rectangle-shaped callout"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSmileyFace: pgettext("shape", "Smiley face"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSnip1Rectangle: pgettext("shape", "Rectangle with one snipped corner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSnip2DiagRectangle: pgettext("shape", "Rectangle with two snipped corners diagonally-opposed"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSnip2SameRectangle: pgettext("shape", "Rectangle with two snipped corners that share a side"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSnipRoundRectangle: pgettext("shape", "Rectangle with one snipped corner and one rounded corner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSquareTabs: pgettext("shape", "Four small squares that define a rectangular shape"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeStripedRightArrow: pgettext("shape", "Right Arrow with Stripes"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSun: pgettext("shape", "Sun"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeSwooshArrow: pgettext("shape", "Curved arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeTear: pgettext("shape", "Water droplet"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeTrapezoid: pgettext("shape", "Trapezoid"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUpArrow: pgettext("shape", "Up Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUpArrowCallout: pgettext("shape", "Callout with UpArrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUpDownArrow: pgettext("shape", "Double-ended Arrow pointing up and down"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUpDownArrowCallout: pgettext("shape", "Callout with arrows that point up and down"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUpRibbon: pgettext("shape", "Ribbon banner"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeUTurnArrow: pgettext("shape", "U-shaped Arrow"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeVerticalScroll: pgettext("shape", "Vertical scroll"),
	# Translators: a shape name from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeWave: pgettext("shape", "Wave"),
}

msoAutoShapeTypeToActionLabel = {
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonBackorPrevious: pgettext("action", "Back"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonBeginning: pgettext("action", "Beginning"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonDocument: pgettext("action", "Document"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonEnd: pgettext("action", "End"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonForwardorNext: pgettext("action", "Next"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonHelp: pgettext("action", "Help"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonHome: pgettext("action", "Home"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonInformation: pgettext("action", "Information"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonMovie: pgettext("action", "Movie"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonReturn: pgettext("shape", "Return"),
	# Translators: an action button label from Microsoft Office.
	# See MSOAutoShapeType enumeration from https://msdn.microsoft.com/en-us/library/office/ff862770.aspx?f=255&MSPPError=-2147217396
	msoShapeActionButtonSound: pgettext("action", "Sound"),
}

msoAutoShapeTypeToRole = {
	msoShapeActionButtonBackorPrevious: controlTypes.Role.BUTTON,
	msoShapeActionButtonBeginning: controlTypes.Role.BUTTON,
	msoShapeActionButtonCustom: controlTypes.Role.BUTTON,
	msoShapeActionButtonDocument: controlTypes.Role.BUTTON,
	msoShapeActionButtonEnd: controlTypes.Role.BUTTON,
	msoShapeActionButtonForwardorNext: controlTypes.Role.BUTTON,
	msoShapeActionButtonHelp: controlTypes.Role.BUTTON,
	msoShapeActionButtonHome: controlTypes.Role.BUTTON,
	msoShapeActionButtonInformation: controlTypes.Role.BUTTON,
	msoShapeActionButtonMovie: controlTypes.Role.BUTTON,
	msoShapeActionButtonReturn: controlTypes.Role.BUTTON,
	msoShapeActionButtonSound: controlTypes.Role.BUTTON,
}
