# NVDA NVDA_VERSION User Guide

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Commands Quick Reference -->



## Introduction {#Introduction}

Добредојдовте во NVDA!
NonVisual Desktop Access (NVDA) е бесплатен читач за екран со отворен изворен код, за оперативниот систем Microsoft Windows.
Испраќајќи повратни информации до корисниците преку синтетизиран говор и Брајово, им овозможува на лицата со потешкотии во видот да можат да ги користат компјутерите на кои има Windows оперативен систем, за не поголем трошок од оној што ги чини другите лица без потешкотии во видот.
NVDA се развива од невладината организација [NV Access](https://www.nvaccess.org/), заедно со придонесите на заедницата.

### General Features {#GeneralFeatures}

NVDA им овозможува на лицата со потешкотии во видот да пристапат и да имаат интеракција со оперативниот систем Windows, како и многу други апликации создадени од трети лица.

Позабележителни можности кои се вклучуваат се:

* Поддршка за популарни апликации вклучувајќи интернет пребарувачи, клиенти за е-пошта, апликации за разговор преку интернет и канцелариски пакети за работа.
* Вграден говорен синтетизатор со поддршка за над 80 јазици
* Известувања за текстуално форматирање каде што тоа е овозможено, како што се име и големина на фонт, стил на текст, како и правописни грешки
* Автоматско соопштување на текстот под курсорот од глувчето, како и опционално звучнo известување за позицијата на курсорот од глувчето
* Поддршка за голем број на Брајови дисплеи кои синхронизирано се менуваат, вклучувајќи ја можноста за нивното пронаоѓање автоматски, како и Брајов внес на Брајов екран со Брајова тастатура
* Можност за целосно работење вчитувајќи го од Универзален Сериски Контролер, УСБ палец, или некоја друга преносна медиjа, без потреба за негова инсталација
* Едноставна за користење говорна инсталација
* Преведен во 54 јазици
* Со поддршка за современите Windows оперативни системи, вклучувајќи ги двете 32 и 64-битни варијанти
* Со можност за работење на Windows екранот за најава, како и при сигурносни екрани
* Најавувачки контроли како и текст додека се користат допирни гестикулации
* Поддршка за најчестите интерфејси за пристапност како Microsoft Active Accessibility, Java Access Bridge, IAccessible2 и UI Automation 
* Поддршка за пишување на Windows командни линии код и останати конзолни апликации
* Можност за означување на системски фокус

### Internationalization {#Internationalization}

Значајно е луѓето во светот, без разлика на тоа кој јазик го говорат, да добијат еднаков пристап до технологијата.
Покрај Англиски Јазик, NVDA е преведена во 54 јазици вклучувајќи ги: Африкански, Албански, Амхарски, Арапски, Арагонезиски, Бугарски, Бурмански, Каталонски, Кинески (поедноставен и традиционален), Хрватски, Чешки, Дански, Холандски, Фарси, Фински, Француски, Галициски, Грузиски, Германски (Геманија и Швајцарија), Грчки, Еврејски, Хинду, Унгарски, Исландски, Ирски, Италијански, Јапонски, Канадски, Корејски, Киргистански, Литвански, Македонски, Монголски, Непалски, Норвешки, Полски, Португалски (Бразил и Португалија), Панџаби, Романски, Руски, Српски, Словачки, Словенски, Шпански (Колумбија и Шпанија), Шведски, Тамил, Тајландски, Турски, Украински и Виетнамски.

### Speech Synthesizer Support {#SpeechSynthesizerSupport}

Покрај обезбедувањето на пораки како и интерфејс на неколку јазици, NVDA може исто така да му овозможи на корисникот да чита содржина на било кој јазик, сѐ додека имаат говорен синтетизатор кој може да го говори тој јазик.

NVDA е со вграден [eSpeak NG](https://github.com/espeak-ng/espeak-ng), слободен, со отворен изворен код, повеќе-јазичен говорен синтетизатор.

Информации окулу други говорни синтетизатори кои се поддржани од NVDA може да се пронајде во [Supported Speech Synthesizers](#SupportedSpeechSynths) секцијата.

### Braille support {#BrailleSupport}

За корисниците кои поседуваат Брајов екран со освежување на податоци, NVDA може да ги прикажува неговите информации во Брајово.
Двете варијанти на скратено и вообичаено Брајово пишување со помош на Брајова тастатура е исто подржано.
Исто така дополнително, NVDA ќе детектира многу Брајови екрани автоматски како негова вклучена основна опција.
Дознајте повеќе во [Supported Braille Displays](#SupportedBrailleDisplays) секцијата за информации окулу поддржаните Брајови екрани.

NVDA поддржува Брајов код за многу јазици, вклучувајќи ги скратените форми, нескратените форми и компјутерски Брајов код.

### License and Copyright {#LicenseAndCopyright}

NVDA е заштитен ентитет законски од NVDA_COPYRIGHT_YEARS NVDA соработниците.

NVDA е пристапно како дел од GNU General Public License верзија 2, вклучувајќи два специјални исклучоци.
Исклучоците се подетално објаснети во документот за лиценцата под секциите "Не-GPL Компоненти во Додатоци и Драјвери" и "Microsoft Дисгтрибутивен Код".
NVDA исто вклучува и употребува компоненти кои се пристапни како дел од други различни слободни и лиценци за отворен изворен код.
Вие сте слободни да го споделувате или изменувате овој софтвер на било кој начин сѐ додека е придружено со лиценцата и доколку ги правите сите измени во отворениот изворен код достапни на секој кој ги побарува.
Ова се однесува истовремено на оригиналот како и модифицираните копии на овој софтвер, како и секоја дополнителна работа произлезена од претходното.

За дополнителни детали можете да се информирате [view the full license.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)
За детали кои се однесуваат на исклучоци, побарајте во документот со лиценцата од NVDA менито под "помош" секцијата.

## System Requirements {#SystemRequirements}

* Оперативни Системи: сите 32-битни и 64-битни едиции на Windows 7, Windows 8, Windows 8.1, Windows 10, и сите Серверски Оперативни Системи почнувајќи од Windows Server 2008 R2.
 * За Windows 7, NVDA побарува Service Pack 1 или повисоко.
 * За Windows Server 2008 R2, NVDA побарува Service Pack 1 или повисоко.
* најмалку 150 MB на простор за складирање.

## Getting and Setting Up NVDA {#GettingAndSettingUpNVDA}

Доколку сѐ уште немате копија од NVDA, може да ја превземете од [NV Access website](NVDA_URL).

Одете во секцијата за превземања и ќе најдете линк за да ја превземете најновата верзија на NVDA.

Покренувањето на документот кој штотуку сте го превземале ќе започне привремена копија од NVDA.
Потоа ќе Ви биде поставено прашање дали би сакале да се инсталира NVDA, да се креира преносна копија или само сакате да продолжите да користите привремена копија.

Доколку планирате секогаш да користите NVDA на компјутерот на кој работите, тогаш најверојатно би сакале да изберете да инсталирате NVDA.
Инсталирањето на NVDA ќе овозможи за додатни функционалности како автомастко стартирање после логирање, можност да се чита Windows екранот за логирање како и сигурносни екрани (нешто кое не може да биде направено со преносната како и привремената копија) и креација на Старт Менито и Десктоп кратенки.
Инсталираната копија исто така нема тешкотија да креира преносна копија во било кое време.

Доколку сакате да ја понесете NVDA со Вас на USB палец или некоја друга преносна медија на која може да се запишува, тогаш треба да одберете да креирате преносна копија.
Преносната копија исто има можност за инсталација на самата себе на било кој компјутер во идно време.
Во било кој случај, доколку сакате да копирате NVDA на медија само за читање на пример како CD, потребно е само да го копирате пакетот кој сте го превземале.
Работењето со преносната верзија директно од медија само за читање не е поддржана во тековниот момент.

Користење на привремена копија од NVDA е исто така опција (на пример за демонстрациони цели), иако стартувањето на NVDA на овој начин секогаш може да биде повеќе временски долготрајно.

### Portable and Temporary Copy Restrictions {#PortableAndTemporaryCopyRestrictions}

Покрај не можноста да се стартува автоматски за време на екраните за најава, или/и после логирање, преносната и привремената копија од NVDA исто така ги немаат следниве опции:

* Неможноста да се комуницира со апликации кои работат административни привилегии, доколку се разбира NVDA самата не се покрене со овие привилегии (не е препорачано).
* Неможноста да се читаат Корисничка Контрола на Сметки (UAC) екрани истовремено додека се обидува да се стартува апликација со административни привилегии.
* Windows 8 и понови верзии: неможност да се поддржи внес од екран на допир.
* Windows 8 и понови верзии: неможност да се овозможат опции како Мод за Претражување како и изговарање на внесени карактери во Windows апликациите во Продавницата.
* Windows 8 и понови верзии: аудио експресна контрола не е поддржана.

### Installing NVDA {#InstallingNVDA}

Доколку инсталирате NVDA директно од NVDA превземен пакет, притиснете го Инсталирај NVDA копчето.
Доколку го имате веќе затворено овој дијалог или сакате да инсталирате од преносна копија, Ве молам изберете го Инсталирај NVDA Мени опцијата кој се наоѓа под Алатки во NVDA Менито.

Инсталациониот дијалог кој ќе се појави ќе потврди дали сакате да инсталирате NVDA и исто така ќе ве извести дали оваа инсталација ќе се надградува над претходна инсталација.
Притискајќи го копчето Продолжи ќе почне инсталација на NVDA.
Постојат исто така неколку опции во овој дијалог кои се објаснети подолу.
Штом инсталацијата ќе комплетира, ќе се појави порака која ќе извести дека за успехот на инсталацијата.
Притискајќи OK во овој чекор ќе ја рестартира ново инсталираната копија на NVDA.

#### Incompatible add-ons warning {#InstallWithIncompatibleAddons}

Доколку веќе имате Додатоци инсталирано има можност да се појави известување дека некомпатибилните Додатоци ќе бидат оневозможени.
Пред да имате моќност да го притиснете копчето Продолжи Вие треба да го означите Копчето за Согласност за да потврдите дека разбирате дека овие Додатоци ќе бидат оневозможени.
Исто така ќе има копче кое ќе овозможи да се согледа кои Додатоци ќе бидат оневозможени.
Реферирајте на [incompatible add-ons dialog section](#incompatibleAddonsManager) за повеќе помош окулу ова копче.

#### Use NVDA during sign-in {#StartAtWindowsLogon}

Оваа опција Ви дозволува да одберете дали треба или не е потребно NVDA автоматски да стартува додека е екранот за Windows Најава, пред моментот кога се внесува лозинка.
Ова исто вклучува Корисничка Контрола на Сметки како и други сигурносни екрани.
Оваа опција е овозможена како вклучена опција за нови свежи инсталации.

#### Create Desktop Shortcut (ctrl+alt+n) {#CreateDesktopShortcut}

Оваа опција дозволува да се одбере дали треба или не е потребно NVDA да креира кратенка на Десктоп за стартување на NVDA. 
Доколку се креира, оваа кратенка исто така ќе ѝ биде доделена кратка комбинација од копчиња control+alt+n, дозволувајќи да се стартува NVDA во секое време со оваа комбинација на копчиња.

#### Copy Portable Configuration to Current User Account {#CopyPortableConfigurationToCurrentUserAccount}

Оваа опција дозволува да се одбере дали треба или не е потребно NVDA да ги копира конфигурациските поставки од веќе постоечко работната верзија на NVDA во конфигурациските поставки на моментално најавениот корисник, за инсталираната копија на NVDA. 
Наведената опција нема да ги копира конфигурациските поставки за други корисници на системот ниту пак на системските конфигурирања за употреба при Windows екранот за Најава како и останати сигурносни екрани.
Оваа опција е единствено достапна кога се врши инсталација од преносна копија, не кога се инсталира директно од превземениот Лансирачки пакет.

### Creating a Portable Copy {#CreatingAPortableCopy}

Доколку креирате преносна копија дирeктно од NVDA превземан пакет, едноставно притиснете го Креирај Преносна Копија копчето.
Доколку веќе сте го изминале овој дијалог или работите со инсталирана копија од NVDA, изберете Креирај Преносна Копија Мени опцијата кој се наоѓа под Алатки во NVDA менито.

Дијалогот кој се појавува Ви овозможува да одберете на која локација преносната копија ќе се креира.
Ова може да биде папка на Вашата тврда диск меморија или локација на USB палец или друга преносна медија.
Исто така постои опција да се одбере дали NVDA би требало да ги копира конфигурациските поставки на моментално најавениот корисник на NVDA за употреба со новокреираната преносна копија.
Оваа опција е единствено достапна кога се креира преносна копија од инсталираната копија, не кога се креира од превземениот инсталационен пакет.
Притискање на Продолжи ќе ја креира преносната копија.
Штом креацијата е комплетна, ќе се појави порака која ќе соопшти дека креирањето е успешно.
Притиснете Во Ред за да го ослободите овој дијалог.

## Getting started with NVDA {#GettingStartedWithNVDA}
### Launching NVDA {#LaunchingNVDA}

Доколку имате инсталирано NVDA со помош на Инсталатор, тогаш стартувањето на NVDA е едноставно како притискање на control+alt+n, или одбирање NVDA од NVDA Менито под Програми во Старт Менито.
Додатно може да испишете NVDA во Покрени дијалогот и да притиснете Внеси.
Доколку NVDA веќе е во работа, ќе биде рестартирана.
Можете исто така да праќате и некои [command line options](#CommandLineOptions) кои Ви овозможуваат да се Откажете (-q), оневозможат Додатоци (--disable-addons), и.т.натаму. 
За инсталирани копии, NVDA ја зачувува конфигурацијата во Апликациска Папка за Пешачење на програмиски информации од моменталниот корисник кој е стандарден (на пример "C:\Users\<user>\AppData\Roaming").
Постои можност да се смени ова на начин на кој NVDA ги вчитува своите конфигурациски поставки од локалната апликациска папка со информации отколку на претходниот начин.
Консултирајте се со секцијата окулу [system wide parameters](#SystemWideParameters) за повеќе детали.

За да се стартува преносната верзија, потребно е да се отвори директориумот во кој го отпакувавте NVDA, и да се притисне Внеси или двоен клик на nvda.exe документот.
Доколку NVDA веќе е во функција и работи, автоматски ќе стопира пред да се стартува преносната верзија.

Како што NVDA стартува, Вие првично ќе слушнете искачувачки сет на тонови (кои ќе ве известуваат дека NVDA се вчитува).
Во согласност со брзината на вашиот компјутер, или дали е стартувана NVDA од USB палец или некоја бавна медија, можеби ќе треба да измине извесно време за да се стартува.
Доколку е потребно многу долго време за да се стартува, NVDA треба да извести "Се вчитува NVDA. Ве молиме причекајте..."

Доклку не слушнете ништо од наведеното, или слушнете Windows звук за известување за грешка, или опаѓачки сет на тонови, тогаш ова значи дека NVDA има грешка, и Вие ќе треба најверојатно да пријавите Грешкас на развивачите na софтверот.
Ве замолуваме да се консултирате со NVDA веб страната на кој начин се прави пријавувањето.

#### Welcome Dialog {#WelcomeDialog}

За времето кога NVDA стартува за прв пат, Вие ќе бидете поздравени со дијалог кутија која ќе ве запознае со некои основни информации окулу NVDA Изменувачките Копчиња како и NVDA Менито.
(Ве замолуваме да ги погледнете останатите секции окулу овие теми.)
Дијалог кутијата исто така содржи и Мешана кутија како и три Копчиња за Потврдување.
Мешаната кутијата Ви овозможува да го одберете распоредот на тастатурата.
Првото Копче за Потврдување Ви овозможува да контролирате дали NVDA ќе го користи Заклучени Капитални Копчиња во форма на NVDA Изменувачко Копче.
Второто означува дали NVDA треба да се стартува автоматски откако ќе се Најавите на Windows и е единствено достапна за инсталирани копии на NVDA.
Третото Ви дозволува контрола дали овој Добредојдовте дијлаог треба да се појавува при секое стартување на NVDA.

#### Data usage statistics dialog {#UsageStatsDialog}

Почнувајќи од NVDA 2018.3, на корисникот му се поставува прашање дали сака да дозволи да се праќаат податоци од користење до NV Пристап сѐ со цел да се помогне напредокот на NVDA во иднина.
Кога ја стартувате NVDA за прв пат, дијалог ќе се појави кој ќе Ви постави прашање дали дозволувате праќање на податоци од користење на програмата до NV Пристап додека работите со NVDA.
Можете да прочитате повеќе информации окулу податоците кои се праќаат кон/собираат од NV Пристап во секцијата за генералните поставки , [Allow the NVDA project to gather NVDA usage statistics](#GeneralSettingsGatherUsageStats).
Забелешка: притискајќи на "Да" или "Не" ќе ја зачува оваа поставка и дијалогот нема повторно да се појави сѐ доколку не ја реинсталирате NVDA.
Сепак, Вие можете да го овозможите или оневозможите собирањето на податоци од користење рачно во NVDA Секцијата за Генералните Поставки. За измена на оваа поставка рачно, можете да го означите или избришете означеното во Копче за Потврдување наречен [Allow the NVDA project to gather NVDA usage statistics](#GeneralSettingsGatherUsageStats).

### About NVDA keyboard commands {#AboutNVDAKeyboardCommands}
#### The NVDA Modifier Key {#TheNVDAModifierKey}

Повеќето NVDA-специфични команди од тастатура се состојат од притискање на одредено копче наречено NVDA модифицирачко копче во заедничка врска со едно или повеќе други копчиња.
Исклучоци кои би можеле да се позаприметни во ова се Текст Преглед командите за Десктоп распоред на тастатура која користи само копчиња од Тестатура за Броеви како сами засебно, меѓутоа постојат и некои други исклучоци исто така.

NVDA може да биде конфигурирана на тој начин да Тестатурата за Броеви копчиња Вметни, Продолжено Вметни како и/или Заклучени Капитални Копчиња може да биде користено како NVDA копче за модификација.
Стандардна опција, и двете Тестатура за Броеви Вметни како и Продолжено Вметни копчиња се сетирани како NVDA копчиња за модификација.

Доколку сакате да пренамените едно од NVDA копчињата за модификација да се однесува како што би се однесувало во вообичаен случај доколку NVDA не би работела (на пример би сакале да го вклучите Заклучени Капитални Копчиња кога го имате поставено Заклучени Капитални Копчиња да биде NVDA модифицирачко копче), можете да го притиснете копчето двапати во брзо повторување.

#### Keyboard Layouts {#KeyboardLayouts}

NVDA моментално доаѓа со два сета на командни копчиња (познати како распоред на тастатура): Десктоп распоред на тастатура и Лаптоп распоред на тастатура.
Како стандардна опција, NVDA е поставена да го користи Десктоп распоредот на тастатура, иако можете да го замените во Лаптоп распоредот на тастатура во Тестатура категоријата од [NVDA Settings](#NVDASettings) дијалогот, кој се наоѓа под Посакувани Поставки во NVDA менито.

Десктоп распоредот на тастатура во голема количина ја користи Тестатурата за Броеви (со Заклучен Број исклучено).
Иако некои преносни компјутери немаат реална физичка Тестатурата за Броеви, некои преносни компјутери можат да емулираат таков со притискање на Функцикото Копче и притискање на буквите и бројките на десната страна од тастатурата (7, 8, 9, u, i, o, j, k, l, и.т.натаму).
Доколку Вашиот преносен компјутер не може да го овозможи ова или не дозволува да го исклучите Заклучен Број, можеби би сакале да промените кон Laptop распоред на тастатурата.

### NVDA Touch Gestures {#NVDATouchGestures}

Доколку работите со NVDA на уред со допир на екран и работите со Windows 8 оперативен систем или понова верзија, Вие можете исто да ја контролирате NVDA директно со допирни команди.
Истовемено додека NVDA работи, доколку допирната интеракциска подршка не е оневозможена, сите допирни внесови ќе бидат испраќани до NVDA. 
На тој начин, акциите кои можат да бидат одигрувани нормално без NVDA нема да бидат достапни за работа.
<!-- KC:beginInclude -->
Да менувате наизменично вклучување/исклучување интерактивна поддршка, притиснете NVDA+control+alt+t.
<!-- KC:endInclude -->
Можете исто да вклучувате или исклучувате [touch interaction support](#TouchSupportEnable) од Допирна Интеракција категоријата од NVDA поставките.

#### Exploring the Screen {#ExploringTheScreen}

Најосновната акција која можете да ја извршувате со екран на допир е да ја изјавите контролата или текстот во секој момент на екранот.
За да го направите ова, поставете еден прст било каде на екранот.
Можете исто така да го задржите прстот на екранот и да го репозиционирате наокулу екранот за да читате останати контроли и текстот што вашиот прст би ги покажувал, врз кои би бил позициониран.

#### Touch Gestures {#TouchGestures}

Кога NVDA командите се опишани понатаму во овој кориснички водич, тие можат да листаат допирни гестикулации кои может да бидат користени да се активираат тие команди со екран на допир.
Во следново се некои инструкции за како да се одигруваат разни допирни гестикулации.

##### Taps {#toc27}

Брзо допирање на екранот со еден или повеќе прсти.

Едно брзо допирање со еден прст е именувано едноставно како брзо допирање.
Брзо допирање со 2 прсти во исто време е брзо допирање со 2 прсти и.т.натаму.

Доколку истото допирање е изведено еднаш или на повеќе наврати последователно, NVDA ќе го интерпретира ова како повеќе-допирна гестикулација.
Допирање двапати ќе резултира во двоен допир.
Допирање 3 пати ќе резултира во троен допир и.т.натаму.
Подразбирливо овие повеќе-допирни гестикулации исто распознаваат колку прсти се користени, па на тој начин е можно да се има гестикулации како тројно брзо допирање со 2 прсти, или брзо допирање со 4 прсти, и.т.натаму. 

##### Flicks {#toc28}

Брзо лизгање на Ваш прст по должината на екранот.

Постојат 4 возможни гестикулации со движења во зависност од правецот: движење налево, движење надесно, движење нагоре и движење надолу.

На ист начин како и допирањата, повеќе од еден прст може да биде користен за да се одиграат овие гестикулации.
На тој начин, гестикулации како движење нагоре со два прсти како и движење налево со 4 прсти се возможни.

#### Touch Modes {#TouchModes}

Како што постојат многу повеќе NVDA команди отколку што се можни допирни гестикулации, NVDA има неколку модели на допир меѓу кои Вие можете да ги одбирате и менувате и кои овозможуваат одреден подсет од команди возможни.
Двата мода се Текст модел и Објектен модел. 
Одредени NVDA команди кои се опишани и набројани во овој документ можат да имаат Допирен модел набројан во загради после допирната гестикулација.
На пример, движење нагоре (Текст модел) значи дека командата ќе биде одиграна доколку се движите нагоре, но единствено само додека сте во Текст моделот.
Доколку командата нема набројан модел, ќе работи во било кој модел.

<!-- KC:beginInclude -->
За менување и избирање на Допирни модели, одиграјте допир со три прсти.
<!-- KC:endInclude -->

#### Touch keyboard {#TouchKeyboard}

Допирна тастатура се користи за да се внесе текст и команди од екран на допир.
Кога во фокус е поле за менување, едитирање и запишување, можете да ја израснете во фокус допирната тастатура со двоен-допир на иконата односно визуелната кратенка на допирната тастатура на дното од екранот.
За таблети како Microsoft Surface Pro, допирната тастатура е секогаш достапна кога физичката недигитална тастатура не е вклучена.
За да се ослободи допирната тастатура од функција, двојно-допрете на иконата односно визуелната кратенка на допирната тастатура или напуштете го полето за менување, едитирање и запишување.

Додека допирната тастатура е активна, за да лоцирате копчиња на допирната тастатура, придвижете прст до местото каде допирната тастатура е поставена (вообичаено на дното од екранот), тогаш движете окулу тастатурата со еден прст.
Кога ќе го најдете копчето што сакате да го притиснете, двојно-допрете го копчето или поткренете го прстот, во сооднос со опцијата која е одбрана од [Touch Interaction Settings category](#TouchInteraction) од NVDA Поставките.

### Input Help Mode {#InputHelpMode}

Многу NVDA команди се спомнати низ остатокот од овој кориснички водич, меѓутоа лесен начин да се истражат сите различни команди е да се вклучи Помош за Внесување.

За да го вклучите Помош за Внесување, притиснете NVDA+1.
За да го оневозможите, повторно притиснете NVDA+1.
Додека е овозможена Помош за Внесување, одигрување на било какви гестикулации на внес (како притискање на копче или одигрување на допирна гестикулација) ќе ја известува акцијата како и ќе објаснува што таа акција извршува (доколку воопшто извршува).
Вистинските команди нема да се извршуваат додека е активен Помош за Внесување моделот.

### The NVDA menu {#TheNVDAMenu}

NVDA менито Ви дозволува да ги контролирате NVDA поставките, да пристапувате до помош, зачувувате/навраќате на вашите конфигурирани поставки, изменувате говорни речници, пристапувате до додатни алатки како и да ја исклучите NVDA.

Со цел да дојдете до NVDA менито од било каде во Windows истовремено додека NVDA работи, притиснете NVDA+n на тастатурата на или одиграјте дво-прстен двоен-допир на екранот за допир.
Можете исто така да пристапите до NVDA менито преку Windows Системска Лента.
Или притиснете на секундарното копче од глувчето на NVDA иконката односно визуелната кратенка која се наоѓа во Системска Лента, или пристапете во Системска Лента притискајќи го копчето со Windows лого+B, Стрелка Долу до NVDA иконката односно визуелната кратенка и притиснете го апликациското копче кое се наоѓа веднаш до десното Контрола копче на повеќето тастатури.
Кога менито ќе се појави и биде во фокусот, Вие можете да ги користите копчињата со стрелки да се движите низ менито, и да притиснете на Внеси копчето за да активирате некој предмет од менито.

### Basic NVDA commands {#BasicNVDACommands}

<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|Starts or restarts NVDA |Control+alt+n |Control+alt+n |none |Starts or restarts NVDA from the Desktop, if this Windows shortcut is enabled during NVDA's installation process. This is a Windows specific shortcut and therefore it cannot be reassigned in the input gestures dialog.|
|Stop speech |Control |control |2-finger tap |Instantly stops speaking|
|Pause Speech |shift |shift |none |Instantly pauses speech. Pressing it again will continue speaking where it left off (if pausing is supported by the current synthesizer)|
|NVDA Menu |NVDA+n |NVDA+n |2-finger double-tap |Pops up the NVDA menu to allow you to access preferences, tools, help, etc.|
|Toggle Speech Mode |NVDA+s |NVDA+s |none |Toggles speech mode between speech, beeps and off.|
|Toggle Input Help Mode |NVDA+1 |NVDA+1 |none |Pressing any key in this mode will report the key, and the description of any NVDA command associated with it|
|Quit NVDA |NVDA+q |NVDA+q |none |Exits NVDA|
|Pass next key through |NVDA+f2 |NVDA+f2 |none |Tells NVDA to pass the next key press straight through to the active application - even if it is normally treated as an NVDA key command|
|Toggle application sleep mode on and off |NVDA+shift+s |NVDA+shift+z |none |sleep mode disables all NVDA commands and speech/braille output for the current application. This is most useful in applications that provide their own speech or screen reading features. Press this command again to disable sleep mode - note that NVDA will only retain the Sleep Mode setting until it is restarted.|

<!-- KC:endInclude -->

### Reporting System Information {#ReportingSystemInformation}

<!-- KC:beginInclude -->

| Name |key |Description|
|---|---|---|
|Report date/time |NVDA+f12 |Pressing once reports the current time, pressing twice reports the date|
|Report battery status |NVDA+shift+b |Reports the battery status i.e. whether AC power is in use or the current charge percentage.|
|Report clipboard text |NVDA+c |Reports the Text on the clipboard if there is any.|

<!-- KC:endInclude -->

## Navigating with NVDA {#NavigatingWithNVDA}

NVDA Ви дозволва да го истражувате и да навигирате низ системот на неколку начини, вклучувајќи ги и нормална интеракција и Преглед.

### Objects {#Objects}

Секоја апликација како и самиот оперативниот се состојат од многу објекти.
Објект е единечен предмет како парче текст, копче, копче за потврда, Лизгачка Лента, листа или едитирачко поле за внесување на текст.

### Navigating with the System Focus {#SystemFocus}

Системскиот фокус, исто познат еднставно како фокус, е [object](#Objects) кој ги прима притиснатите копчиња на тастатурата.
На пример, доколку Вие пишувате во едитирачно поле за внесување на текст, едитирачкото поле за внесување на текст го има фокусот.

Најчестиот начин за навигација окулу Windows со NVDA е едноставно да се движи системскиот фокус користејќи стандардни Windows команди преку тастатура, како на пример притискање на tab and shift+tab да за придвижување напред и назад помеѓу контролите, притискајќи alt за да се дојде до Лента со Мени и понатаму користејќи ги стралките за навигаација низ менијата, и користење на alt+tab за придвижување помеѓу апликациите.
Истовремено додека го работите ова, NVDA ќе кажува информации за објектот кој го има фокусот, како на пример неговото име, тип, вредност, состојба, опис, кратенка на тастатура и позициона информација.
Кога [Focus Highlight](#VisionFocusHighlight) е вклучен, локацијата на моменталниот системски фокус исто така е откриена визуелно.

Постојат некои командни копчиња кои се корисни при движење со Системскиот фокус:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Report current focus |NVDA+tab |NVDA+tab |announces the current object or control that has the System focus. Pressing twice will spell the information|
|Report title |NVDA+t |NVDA+t |Reports the title of the currently active window. Pressing twice will spell the information. Pressing three times will copy it to the clipboard|
|Read active window |NVDA+b |NVDA+b |reads all the controls in the currently active window (useful for dialogs)|
|Report Status Bar |NVDA+end |NVDA+shift+end |Reports the Status Bar if NVDA finds one. It also moves the navigator object to this location. Pressing twice will spell the information. Pressing three times will copy it to the clipboard|

<!-- KC:endInclude -->

### Navigating with the System Caret {#SystemCaret}

Кога [object](#Objects) што дозволува навигација и/или едитирање на текст е [focused](#SystemFocus), Вие може да се движите низ текстот користејќи го Системскиот Курсор за Текст, исто така познат како Уредѕвачки курсор.

Кога фокусот е на објект кој го има Системскиот Курсор за Текст, може да ги користите копчињаа со стрелки, Страница Нагоре, Страница Удолу, Дома, Крај, и.т.натаму за да се движите низ текстот.
Вие исто така можете да го менувате текстот доколку контролата поддржува едитирање односно измена.
NVDA ќе најавува како што се движите карактер по карактер, по зборови и линија, и исто ќе најавува како што ќе го означувате или деселектирате текстот.

NVDA ги овозможува достапно следниве командни копчиња во релација со Системскиот Курсор за Текст:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Say all |NVDA+downArrow |NVDA+a |Starts reading from the current position of the system caret, moving it along as it goes|
|Read current line |NVDA+upArrow |NVDA+l |Reads the line where the system caret is currently situated. Pressing twice spells the line. Pressing three times spells the line using character descriptions.|
|Read current text selection |NVDA+Shift+upArrow |NVDA+shift+s |Reads any currently selected text|
|Report text formatting |NVDA+f |NVDA+f |Reports the formatting of the text where the caret is currently situated. Pressing twice shows the information in browse mode|
|Next sentence |alt+downArrow |alt+downArrow |Moves the caret to the next sentence and announces it. (only supported in Microsoft Word and Outlook)|
|Previous sentence |alt+upArrow |alt+upArrow |Moves the caret to the previous sentence and announces it. (only supported in Microsoft Word and Outlook)|

Кога во табела, следниве командни копчиња се исто достапни:

| Name |Key |Description|
|---|---|---|
|Move to previous column |control+alt+leftArrow |Moves the system caret to the previous column (staying in the same row)|
|Move to next column |control+alt+rightArrow |Moves the system caret to the next column (staying in the same row)|
|Move to previous row |control+alt+upArrow |Moves the system caret to the previous row (staying in the same column)|
|Move to next row |control+alt+downArrow |Moves the system caret to the next row (staying in the same column)|

<!-- KC:endInclude -->

### Object Navigation {#ObjectNavigation}

Повеќето од времето, Вие ќе работите со апликации користејќи команди кои се движат [focus](#SystemFocus) како и [caret](#SystemCaret).
Меѓутоа, некогаш, можеби би сакале да ги истражувате моменталните апликации или Оперативниот Систем без движење на фокусот или Куросрот за текст.
Вие исто така можеби сакате да работите со [objects](#Objects) кои не можат да бидат достапни нормално користејќи ја тастатурата.
Во овие случаеви, Вие можете да ја користите објектната навигација.

Објектната навигација Ви дозволува да се движите помеѓу како и да добивате информации окулу индивидуални [objects](#Objects).
Кога Вие се придвижувате до објект, NVDA ќе го извести тоа слично на начинот на кој го известува системскиот фокус.
За начин да го прелистате целиот текст како што се појавува на екранот, Вие можете да го користите наместо тоа [screen review](#ScreenReview).

Наместо тоа да треба да се движи назад и напред помеќу секој единечен објект од системот, објектите се организирани хиерархиски.
Ова има значење дека некои објекти содржат во себе други објекти и Вие морате да се придвижите во нов за да имате пристап до објектите кои тие ги содржат.
На пример, листа содржи елементи на листа, па Вие морате да се придвижите внатре во листата со цел да пристапите до нејзините елементи.
Доколку Вие сте се придвижиле до елемент на листата, движење до нареден и претходен ќе ве однесе до други елементи на листата во таа листа.
Движење до Предмет во Листа кој содржи Објект ќе Ве однесе назад до листата.
Тогаш Вие можете да се движите после листата доколку сакате да добиете пристап до други објекти.
Слично, Лента со Алатки содржи контроли, па Вие морате да се движите внатре во Лента со Алатки за да пристапите до контролите на Лента со Алатки.

Објектот кој моментално се прелистува е наречен Навигатор објект.
Штом Вие ќе навигирате до објект, Вие можете да ја разлистате неговата содржина користејќи го [text review commands](#ReviewingText) додека сте во [Object review mode](#ObjectReview).
Кога [Focus Highlight](#VisionFocusHighlight) е вклучен, позицијата на моменталниот Навигатор објект визуелно е изложена.
Како основна селектирана опција, Навигатор објектот се движи заедно со Системскиот фокус, иако ова однесување може да биде вклучувано и исклучувано наизменично.

Забелешка: Брајово кое следи Објект Навигација може да биде конфигурирано преку [Braille Tether](#BrailleTether).

За навигација до објект, користете ги следниве команди:

<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|Report current object |NVDA+numpad5 |NVDA+shift+o |none |Reports the current navigator object. Pressing twice spells the information, and pressing 3 times copies this object's name and value to the clipboard.|
|Move to containing object |NVDA+numpad8 |NVDA+shift+upArrow |flick up (object mode) |Moves to the object containing the current navigator object|
|Move to previous object |NVDA+numpad4 |NVDA+shift+leftArrow |flick left (object mode) |Moves to the object before the current navigator object|
|Move to next object |NVDA+numpad6 |NVDA+shift+rightArrow |flick right (object mode) |Moves to the object after the current navigator object|
|Move to first contained object |NVDA+numpad2 |NVDA+shift+downArrow |flick down (object mode) |Moves to the first object contained by the current navigator object|
|Move to focus object |NVDA+numpadMinus |NVDA+backspace |none |Moves to the object that currently has the system focus, and also places the review cursor at the position of the System caret, if it is showing|
|Activate current navigator object |NVDA+numpadEnter |NVDA+enter |double-tap |Activates the current navigator object (similar to clicking with the mouse or pressing space when it has the system focus)|
|Move System focus or caret to current review position |NVDA+shift+numpadMinus |NVDA+shift+backspace |none |pressed once Moves the System focus to the current navigator object, pressed twice moves the system caret to the position of the review cursor|
|Report review cursor location |NVDA+numpadDelete |NVDA+delete |none |Reports information about the location of the text or object at the review cursor. For example, this might include the percentage through the document, the distance from the edge of the page or the exact screen position. Pressing twice may provide further detail.|

<!-- KC:endInclude -->

Забелешка: Тестатурата за Броеви копчињата побаруваат Заклучен Број да биде исклучено за да работат правилно.

### Reviewing Text {#ReviewingText}

NVDA Ви дозволува да читате содржина од [screen](#ScreenReview), тековниот [document](#DocumentReview) или тековниот [object](#ObjectReview) карактер по карактер, по збор или линија.
Ова е највеќе корисно на места (вклучувајќи ги и Windows командни конзоли) кадешто не постои [system caret](#SystemCaret).
На пример, Вие можете да го користите за да го прелистувате текстот во долга информациона порака во дијалог.

Кога го придвижувате курсорот за прелистување, Системскиот Курсор за Текст не ги следи промените, па така Вие пожете да го прелистувате текстот без губење на едитирачката позиција.
Меѓутоа, како основна селектирана опција, кога Системскиот Курсор за Текст се движи, курсорот за разлистување следи по него.
Ова може да биде вклучено и исклучено наизменично.

Забелешка: Брајово следење на Kурсoрот за Прелистување може да биде конфигурирано преку [Braille Tether](#BrailleTether).

Следниве команди се достапни за ревизија на текст:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|Move to top line in review |shift+numpad7 |NVDA+control+home |none |Moves the review cursor to the top line of the text|
|Move to previous line in review |numpad7 |NVDA+upArrow |flick up (text mode) |Moves the review cursor to the previous line of text|
|Report current line in review |numpad8 |NVDA+shift+. |none |Announces the current line of text where the review cursor is positioned. Pressing twice spells the line. Pressing three times spells the line using character descriptions.|
|Move to next line in review |numpad9 |NVDA+downArrow |flick down (text mode) |Move the review cursor to the next line of text|
|Move to bottom line in review |shift+numpad9 |NVDA+control+end |none |Moves the review cursor to the bottom line of text|
|Move to previous word in review |numpad4 |NVDA+control+leftArrow |2-finger flick left (text mode) |Moves the review cursor to the previous word in the text|
|Report current word in review |numpad5 |NVDA+control+. |none |Announces the current word in the text where the review cursor is positioned. Pressing twice spells the word. Pressing three times spells the word using character descriptions.|
|Move to next word in review |numpad6 |NVDA+control+rightArrow |2-finger flick right (text mode) |Move the review cursor to the next word in the text|
|Move to start of line in review |shift+numpad1 |NVDA+home |none |Moves the review cursor to the start of the current line in the text|
|Move to previous character in review |numpad1 |NVDA+leftArrow |flick left (text mode) |Moves the review cursor to the previous character on the current line in the text|
|Report current character in review |numpad2 |NVDA+. |none |Announces the current character on the line of text where the review cursor is positioned. Pressing twice reports a description or example of that character. Pressing three times reports the numeric value of the character in decimal and hexadecimal.|
|Move to next character in review |numpad3 |NVDA+rightArrow |flick right (text mode) |Move the review cursor to the next character on the current line of text|
|Move to end of line in review |shift+numpad3 |NVDA+end |none |Moves the review cursor to the end of the current line of text|
|Say all with review |numpadPlus |NVDA+shift+a |3-finger flick down (text mode) |Reads from the current position of the review cursor, moving it as it goes|
|Select then Copy from review cursor |NVDA+f9 |NVDA+f9 |none |Starts the select then copy process from the current position of the review cursor. The actual action is not performed until you tell NVDA where the end of the text range is|
|Select then Copy to review cursor |NVDA+f10 |NVDA+f10 |none |On the first press, text is selected from the position previously set as start marker up to and including the review cursor's current position. If the system caret can reach the text, it will be moved to the selected text. After pressing this key stroke a second time, the text will be copied to the Windows clipboard|
|Move to marked start for copy in review |NVDA+shift+f9 |NVDA+shift+f9 |none |Moves the review cursor to the position previously set start marker for copy|
|Report text formatting |NVDA+shift+f |NVDA+shift+f |none |Reports the formatting of the text where the review cursor is currently situated. Pressing twice shows the information in browse mode|
|Report current symbol replacement |None |None |none |Speaks the symbol where the review cursor is positioned. Pressed twice, shows the symbol and the text used to speak it in browse mode.|

<!-- KC:endInclude -->

Забелешка: Тестатурата за Броеви копчињата побаруваат Заклучен Број да биде исклучен за да работат правилно.

Добар начин да се запаметат основните команди за ревизија на текст кога се користи Десктоп распоредот е да се мисли на нив како да се поставени во мрежа од три на три, со од врв до дно да бидат линија, збор, карактер, и лево до десно да бидат претходен, постоечки и следен.
Распоредот е преставен како што следи:

|Previous line |Current line |Next line|
|Previous word |Current word |Next word|
|Previous character |Current character |Next character|

### Review Modes {#ReviewModes}

NVDA's [text review commands](#ReviewingText) може да подобрува содржина во рамките на постојниот Навигатор објект, постојниот документ или екран, во зависност од селектираниот модел на Преглед.
Моделите на Преглед се замена за постарите Рамни Преглед концепти кои се наоѓаат во NVDA.

Следниве команди прават промена помеѓу моделите на Преглед:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|Switch to next review mode |NVDA+numpad7 |NVDA+pageUp |2-finger flick up |switches to the next available review mode|
|Switch to previous review mode |NVDA+numpad1 |NVDA+pageDown |2-finger flick down |switches to the previous available review mode|

<!-- KC:endInclude -->

#### Object Review {#ObjectReview}

Додека се наоѓа во објектен Преглед модел, Вие сте во можност само да ја прегледувате содржината на постојниот [navigator object](#ObjectNavigation).
За објекти како едитирачки текстуални полиња или други основни текстуални контроли, ова генерално ќе биде текстуалната содржина.
За други објекти, ова може да биде име и/или вредност.

#### Document Review {#DocumentReview}

Кога [navigator object](#ObjectNavigation) е внатре во Претражи модел документ (на пример веб страница) или друг комплексен документ (на пример Lotus Symphony документ), можно е да се премине во Документ Преглед модел.
Документ Преглед модел дозволува да го прегледате текстот на целиот документ.

Кога преминувате од Објект Преглед во Документ Преглед, курсорот за прегледување се сместува во документот на позиција од Навигатор Објект.
При движење наокулу во документот со командите за преглед, Навигатор Објект е автоматски надграден во објектот кој се наоѓа на постојната позиција на курсорот за преглед.

Забелешка дека NVDA ќе премине во Документ Преглед од Објект Преглед автоматски кога се придвижува окулу Претражи Модел документи.

#### Screen Review {#ScreenReview}

Екран Преглед моделот Ви дозволува да го прегледувате текстот на екранот како што се појавува визуелно внатре во моменталната апликација.
Ова е слично на Екран Преглед или функционалноста на курсорот на глувчето во многу други Windows читачи на екран.

Кога се преминува во Екран Преглед моделот, курсoрот за преглед е сместен на позицијата на екранот на моменталниот [navigator object](#ObjectNavigation).
Кога се придвижувате наокулу екранот со командите за преглед, Навигатор Објект автоматски е надграден на објектот кој се наоѓа на позицијата на екранот од курсорот за преглед.

Забелешка дека во некои понови апликации, NVDA можеби нема да ги воочи некои или сите текстови прикажани на екранот поради користењето на понови технологии со цртање на екран кои е невозможно да се подржуваат во овој момент.

### Navigating with the Mouse {#NavigatingWithTheMouse}

Кога го движите глувчето, NVDA како основна селектирана опција Извештај текстот кој е директно под курсорот на глувчето како што курсорот се движи над него.
Каде што е подржано, NVDA ќе ги исчитува околните параграфи на текст, иако некои контроли можеби ќе читаат по линија.

NVDA може да биде подредена исто така да ги најавува типовите на [object](#Objects) под покажувачот на глувчето како што се движи (на пример листа, копче, и.т.натаму).
Ова може да биде корисно за луѓе со тотално нарушен вид, што во некои случаи, текстот не е доволен.

NVDA овозможува начин за корисниците да разберат каде глувчето е лоцирано релативно до димезиите на екранот со звучно изговарање на моменталните координати на глувчето како аудио звучни сигнали.
Колку повисоко глувчето се наоѓа на екранот, повисока фрекфенција на звучните сигнали.
Колку подалеку на лево или десно е глувчето лоцирано на екранот, подалеку лево или десно звук ќе биде звучно креиран (претпоставувајќи дека корисникот има стерео звучници или слушалки).

Овие додатни опции за глувче не се вклучени како основна селектирана опција во NVDA.
Доколку сакате да ги користите нивните придобивки, можете да ги подредите од [Mouse settings](#MouseSettings) категоријата на [NVDA Settings](#NVDASettings) диајлогот, кој се наоѓа во NVDA Посакувани Поставки менито.

Иако реално физичко Глувче или Подлога за Допирни Патеки е потребно да се користи за да се придвижува со глувчето, NVDA овозможува некои команди поврзани со глувчето: 
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|Left mouse button click |numpadDivide |NVDA+[ |none |Clicks the left mouse button once. The common double click can be performed by pressing this key twice in quick succession|
|Left mouse button lock |shift+numpadDivide |NVDA+control+[ |none |Locks the left mouse button down. Press again to release it. To drag the mouse, press this key to lock the left button down and then move the mouse either physically or use one of the other mouse routing commands|
|Right mouse click |numpadMultiply |NVDA+] |tap and hold |Clicks the right mouse button once, mostly used to open context menu at the location of the mouse.|
|Right mouse button lock |shift+numpadMultiply |NVDA+control+] |none |Locks the right mouse button down. Press again to release it. To drag the mouse, press this key to lock the right button down and then move the mouse either physically or use one of the other mouse routing commands|
|Move mouse to current navigator object |NVDA+numpadDivide |NVDA+shift+m |none |Moves the mouse to the location of the current navigator object and review cursor|
|Navigate to the object under the mouse |NVDA+numpadMultiply |NVDA+shift+n |none |Set the navigator object to the object located at the position of the mouse|

<!-- KC:endInclude -->

## Browse Mode {#BrowseMode}

Сложени документи кај кои е овозможено само читање како Интернет страници се прелистуваат во NVDA користејќи го Претражи моделот.
Ова вклучува документи во следниве апликации:

* Mozilla Firefox
* Microsoft Internet Explorer
* Mozilla Thunderbird
* HTML пораки во Microsoft Outlook
* Google Chrome
* Microsoft Edge
* Adobe Reader
* Foxit Reader
* Adobe Flash
* Подржани книги во Amazon Kindle за Персонален Компјутер

Претражи моделот е исто опционално достапен за Microsoft Word документи.

Во Претражи моделот, содржината на документот е направена достапна во рамна репрезентација која може да биде Навигирана со курсорските копчиња на ист начин како да е нормален текст документ.
Сите од NVDA's [system caret](#SystemCaret) командни копчиња нема да работат во овој модел; на пример Изговори сѐ, Форматирање на Извештај, Команди за Навигација низ Табели, и.т. натаму.
Кога [Focus Highlight](#VisionFocusHighlight) е овозможен, локацијата на вируелниот Претражи модел Курсор за Текст е исто така визуално достапно откриен.
Информации како што се тие дали текстот е линк, заглавје, и.т. натаму се известува истовремено со текстот како што се движите.

Некогаш, Вие ќе треба да имате интеракција директно со контролите во овие документи.
На пример, Вие ќе треба да го правите ова за едитирачки полиња на текст како и листи така што ќе можете да притискате карактери и да ги користите курсорските копчиња за да работите со контролата.
Вие го правите ова со преминување во Фокус моделот, каде скоро сите копчиња се пренесени на контролата.
Кога сте во Претражи моделот, како основна селектирана опција, NVDA автоматски ќе премине во Фокус моделот доколку притиснете на копчето tab или притиснете на одредена контрола која го побарува тоа.
Обратно, со притискање на tab копчето или со притискање на контрола која не го побарува Фокус моделот ќе се премине назад во Претражи моделот.
Вие можете исто да притиснете Внеси или Простор да преминете во Фокус моделот на контролите кои го побаруваат тоа.
Притискајќи Одбегни ќе се премине назад во Претражи моделот.
Како додатна опција, Вие можете мануелно да нагласите Фокус модел, после кое моделот ќе остане во ефект сѐ додека не одберете да го оневозможите.

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Toggle browse/focus modes |NVDA+space |Toggles between focus mode and browse mode|
|Exit focus mode |escape |Switches back to browse mode if focus mode was previously switched to automatically|
|Refresh browse mode document |NVDA+f5 |Reloads the current document content (useful if certain content seems to be missing from the document. Not available in Microsoft Word and Outlook.)|
|Find |NVDA+control+f |Pops up a dialog in which you can type some text to find in the current document. See [searching for text](#SearchingForText) for more information.|
|Find next |NVDA+f3 |Finds the next occurrence of the text in the document that you previously searched for|
|Find previous |NVDA+shift+f3 |Finds the previous occurrence of the text in the document you previously searched for|
|Open long description |NVDA+d |Opens a new window containing a long description for the element you are on if it has one.|

<!-- KC:endInclude -->

### Single Letter Navigation {#SingleLetterNavigation}

Додека сте во Претражи моделот, за брза навигација, NVDA исто овозможува и копчиња од единствен карактер за да се скокне односно премине до одредени полиња во документот.
Забелешка дека не сите од овие команди се поддржани во секој вид на документ.

<!-- KC:beginInclude -->
Следниве копчиња од единствен карактер како самостојни скокаат на следниот достапен елемент, додека заедно со Подигни копчето ќе направи тие да скокаат на претходниот елемент:

* h: heading
* l: list
* i: list item
* t: table
* k: link
* n: nonLinked text
* f: form field
* u: unvisited link
* v: visited link
* e: edit field
* b: button
* x: checkbox
* c: combo box
* r: radio button
* q: block quote
* s: separator
* m: frame
* g: graphic
* d: landmark
* o: embedded object (audio and video player, application, dialog, etc.)
* 1 to 6: headings at levels 1 to 6 respectively
* a: annotation (comment, editor revision, etc.)
* w: spelling error

За да се преидвижите на почетокот или крајот на содржаните елементи како листи или табели:

| Name |Key |Description|
|---|---|---|
|Move to start of container |shift+comma |Moves to the start of the container (list, table, etc.) where the caret is positioned|
|Move past end of container |comma |Moves past the end of the container (list, table, etc.) where the caret is positioned|

<!-- KC:endInclude -->

Некои апликации како што се Gmail, Twitter и Facebook користат единечни букви како копчиња за брзи наредби.
Доколку Вие саката да ги користите овие копчиња и сеуште да бидете во можност да ги користите вашите Курсор копчиња за да читате во Претражи моделот, можете привремено да го оневозможите NVDA's единечните букви како навигациски копчиња.
<!-- KC:beginInclude -->
За преминување во вклучена и исклучена навигација од единечните букви за тековниот документ, притиснете NVDA+shift+space.
<!-- KC:endInclude -->

### The Elements List {#ElementsList}

Листата од елементи овозможува пристап до листа на различни видови на елементи во документот како соодветни за апликацијата.
На пример, во Интернет прелистувач, листата на елементи може да лисta линкови, заглавја, полиња од форма, копчиња или обележја.
Радио копчињата Ви дозволуваат да преминете помеѓу различни видови на елементи.
Полето Измени е исто така присутно во дијалогот кој Ви дозволува да ја филтрирате листата за да го олесните претражувањето на одреден предмет на страната.
Штом Вие ќе изберете предмет, Вие можете да ги користите присутните копчиња во дијалогот за да се придвижите до или да го активирате тој предмет.
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Browse mode elements list |NVDA+f7 |Lists various types of elements in the current document|

<!-- KC:endInclude -->

### Searching for text {#SearchingForText}

Овој дијалог Ви овозможува да претражувате за зборовни рамки во тековниот документ.
Во "Внесете го текстот кој сакате да го пронајдете" полето, текстот кој треба да се пронајде може да биде внесен.
"Осетливост на Големина" опцијата го прави претражувањето да ги воочува големите и малите букви различно.
На пример, со "Осетливост на Големина" избрано можете да пронајдете "NV Access" но не и "nv access".
Користете ги следниве копчиња за извршување на претражувања:
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Find text |NVDA+control+f |Opens the  search dialog|
|Find next |NVDA+f3 |searches the next occurrence of the current search term|
|Find previous |NVDA+shift+f3 |searches the previous  occurrence of the current search term|

<!-- KC:endInclude -->

### Embedded Objects {#ImbeddedObjects}

Страниците может да вклучуваат богата содржина користејќи технологии како на пример Adobe Flash, Oracle Java и HTML5, исто како и апликации и дијалози.
Каде што овие се сретнати во browse моделот, NVDA ќе ги најави како "embedded object", "application" или "dialog", соодветно.(преведи го претходното)
Вие можете набрзина да се придвиќите до нив користејќи го o како и shift+o embedded object навигациските копчиња со единечна буква.(преведи го претходното)
За да имате комуникација односно интеракција со овие објекти, можете да притиснете enter на нив.(преведи го претходното)
Доколку е достапно, Вие можете да се придвижувате наокулу со притискање на tab и да комуницирате односно да имате интеракција со објектите исто како било која друга апликација.(преведи го претходното)
Команда од копче е достапна за да се вратите на првичната оригинална страна која го содржи embedded object:(преведи го претходното)
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Move to containing browse mode document |NVDA+control+space |Moves the focus out of the current embedded object and into the document that contains it|

<!-- KC:endInclude -->

## Reading Mathematical Content {#ReadingMath}

Кориастејќи MathPlayer 4 од Design Science, NVDA може да чита и интерактивно да се движи помеѓу поддржаните математички содржини.
Оваа опција побарува MathPlayer 4 да е инсталиран на компјутерот.
MathPlayer е достапен како бесплатно превземање од: https://www.dessci.com/en/products/mathplayer/

NVDA ги поддржува следниве типови на математичка содржина:

* MathML во Mozilla Firefox, Microsoft Internet Explorer и Google Chrome.
* Design Science MathType во Microsoft Word и PowerPoint.
MathType е потребно да биде инсталиран со цел ова да работи односно да фунционира.
Пробната верзија е доволна.
Може да биде превземена од https://www.dessci.com/en/products/mathtype/
* MathML во Adobe Reader.
Забелешка дека ова не е официјален стандард сеуште, така да моментално не постои јавно достапен софтвер кој може да ја продуцира оваа содржина.
* Math во Kindle за Персонален Копмјутер за книги со accessible математика.(преведи го претходното)

Кога го читате документот, NVDA ќе ги изговори било кои поддржани математички содржини каде што ќе се појават.
Доколку користите Брајов екран, исто така ќе биде прикажан на Брајово.

### Interactive Navigation {#InteractiveNavigation}

Доколку Вие работите примарно со говор, во најголем број од случаите, Вие најверојатно ќе сакате да ја истражите the expression во помали делови односно сегменти, отколку да ја слушнете целата експресија односно израз наеднаш.

Доколку сте во browse моделот, Вие можете да го направите ова со движење на курсорот до математичката содржина и притискајќи на enter.(преведи го претходното)

Доколку Вие не сте во browse моделот:

1. move the review cursor to the mathematical content.
Како основна селектирана опција, the review курсорот го следи the system caret, за Вие да можете најчесто да го користите system caret да се движите до посакуваната содржина.(преведи го претходното)
1. Then, activate the following command:

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Interact with math content |NVDA+alt+m |Begins interaction with math content.|

<!-- KC:endInclude -->

Во овој момент, Вие можете да користите MathPlayer команди како што се копчињата со стрелки да го истражувате изразот односно експресијата.
На пример, Вие можете да се движите низ експресијата со копчето со лева и десна стрелка и да zoom во порција односно дел од експресијата како што е фракција користејќи го копчето со стрелка надолу.(преведи го претходното)
Ве молиме информирајте се на [MathPlayer documentation about navigation commands](https://www.dessci.com/en/products/mathplayer/navigation_commands.htm) за подетални информации.

Кога сакате да се вратите кон документот, едноставно притиснете го escape копчето.(преведи го претходното)

Понекогаш математичката содржина може да биде прикажана како копче или друг вид на елемент којшто, кога е активиран, може да прикаже дијалог или повеќе информации во релација односно поврзано со формулата.
Да се активира копчето или елементот кој ја содржи формулата, притиснете ctrl+enter.

## Braille {#Braille}

Доколку поседувате Брајов екран, NVDA е во состојба да ги прикажува информациите во Брајово.
Доколку Вашиот Брајов екран има Perkins-модел на тестатура, можете исто да внесувате скратено или целосно(нескратено) Брајово.(преведи го претходното)
Брајово исто може да биде прикажано на екран користејќи [Braille Viewer](#BrailleViewer) наместо, или во исто време со, користење на физички Брајов екран.

Ве молиме информирајте се на [Supported Braille Displays](#SupportedBrailleDisplays) секција за информации окулу поддржаните Брајови екрани.
Оваа секција исто така содржи информации окулу тоа кои екрани го подджуваат NVDA's автоматската позадинска функционалност на детекција односно откривање на Брајов екран.(преведи го претходното односно провери ја точноста)
Вие можете да кофигурирате односно приспособите Брајово користејќи [Braille category](#BrailleSettings) од [NVDA Settings](#NVDASettings) дијалогот.

### Control Type, State and Landmark abbreviations {#BrailleAbbreviations}

Сѐ со цел да прикажете што е можно повеќе информации на Брајов екран, следниве кратенки се веќе дефинирани за да наведете тип на контрола и состојба, како и обележја.(преведи го претходното)

| Abbreviation |Control type|
|---|---|
|app |application|
|art |article|
|bqt |block quote|
|btn |button|
|drbtn |drop down button|
|spnbtn |spin button|
|splbtn |split button|
|tgbtn |toggle button|
|cap |caption|
|cbo |combo box|
|chk |checkbox|
|dlg |dialog|
|doc |document|
|edt |editable text field|
|pwdedt |password edit|
|embedded |embedded object|
|enote |end note|
|fig |figure|
|fnote |foot note|
|gra |graphic|
|grp |grouping|
|hN |heading at level n, e.g. h1, h2.|
|hlp |help balloon|
|lmk |landmark|
|lnk |link|
|vlnk |visited link|
|lst |list|
|mnu |menu|
|mnubar |menu bar|
|mnubtn |menu button|
|mnuitem |menu item|
|pnl |panel|
|prgbar |progress bar|
|rbtn |radio button|
|scrlbar |scroll bar|
|sect |section|
|stbar |status bar|
|tabctl |tab control|
|tbl |table|
|cN |table column number n, e.g. c1, c2.|
|rN |table row number n, e.g. r1, r2.|
|term |terminal|
|tlbar |tool bar|
|tltip |tool tip|
|tv |tree view|
|tvbtn |tree view button|
|tvitem |tree view item|
|lv N |a tree view item has a hierarchical level N||
|wnd |window|
|⠤⠤⠤⠤⠤ |separator|
|mrkd |marked content|

Следниве индикатори односно покажувачи на состојби исто така се дефинирани:

| Abbreviation |Control state|
|---|---|
|... |displayed when an object supports autocompletion|
|⢎⣿⡱ |displayed when an object (e.g. a toggle button) is pressed|
|⢎⣀⡱ |displayed when an object (e.g. a toggle button) is not pressed|
|⣏⣿⣹ |displayed when an object (e.g. a checkbox) is checked|
|⣏⣸⣹ |displayed when an object (e.g. a checkbox) is half checked|
|⣏⣀⣹ |displayed when an object (e.g. a checkbox) is not checked|
|- |displayed when an object (e.g. a tree view item) is collapsible|
|+ |displayed when an object (e.g. a tree view item) is Expandable|
|*** |displayed when a protected control or document is encountered|
|clk |displayed when an object is clickable|
|cmnt |displayed when there is a comment for a spreadsheet cell or piece of text in a document|
|frml |displayed when there is a formula on a spreadsheet cell|
|invalid |displayed when an invalid entry has been made|
|ldesc |displayed when an object (usually a graphic) has a long description|
|mln |displayed when an edit field allows typing multiple lines of text such as comment fields on websites|
|req |displayed when a required form field is encountered|
|ro |displayed when an object (e.g. an editable text field) is read-only|
|sel |displayed when an object is selected|
|nsel |displayed when an object is not selected|
|sorted asc |displayed when an object is sorted ascending|
|sorted desc |displayed when an object is sorted descending|
|submnu |displayed when an object has a popup (usually a sub-menu)|

Конечно, следниве кратенки за одбележја се дефинирани:

| Abbreviation |Landmark|
|---|---|
|bnnr |banner|
|cinf |content info|
|cmpl |complementary|
|form |form|
|main |main|
|navi |navigation|
|srch |search|
|rgn |region|

### Braille Input {#BrailleInput}

NVDA поддржува внес како на uncontracted така и на contracted Брајово преку Брајова тестатура.(преведи го претходното)
Вие можете да ја одберете преводната табела која се користи за преведување на Брајово во текст користејќи го [Input table](#BrailleSettingsInputTable) поставување во Брајова категорија од [NVDA Settings](#NVDASettings) дијалогот.

Кога се користи целосно(нескратено) Брајово, текстот се вметнува истовремено како што се внесува.
Кога се користи скретено Брајово, текстот се вметнува при притискање на space или enter на крајот од секој збор.
Забелешка дека преведувањето може само да рефлектира односно да одрази Брајов збор кој Вие го пишувате и не може да биде разгледан постоечки текст.(преведи го претходното односно провери ја точноста)
На пример, доколку Вие користите Брајов код кој ги започнува броевите со знак за број и Вие притиснете backspace да се движите на крајот од тој број, Вие ќе треба да го притиснете знакот за број повторно за да внесете дополнители броеви.(преведи го претходното односно провери ја точноста)

<!-- KC:beginInclude -->
Притискајќи dot 7 го брише последно внесениот Брајов cell или карактер.(преведи го претходното)
Dot 8 го преведува секој Брајов внес и го притиска enter копчето.(преведи го претходното)
Притискајќи dot 7 + dot 8 го преведува секој Брајов внес, но без додавање на space или притискање на enter.(преведи го претходното)
<!-- KC:endInclude -->

## Vision {#Vision}

Додека NVDA е примарно насочена кон лица со оштетувања во видот кои примарно користат говор и/или Брајово за да користат односно да работат на компјутер, исто така обезбедува вградени facilities да ги менува содржините на екранот.
Внатре во NVDA, таква визуелна помош е наречена провајдер на подобрување на видливоста.

NVDA нуди неколку вградени провајдери на подобрување на видливоста кои се опишани подолу.
Додатни провајдери на подобрување на видливоста можат да бидат пронајдени за употреба односно обезбедени во [NVDA add-ons](#AddonsManager).

NVDA's поставките односно подесувањата за видливост можат да бидат изменети во [vision category](#VisionSettings) од [NVDA Settings](#NVDASettings) дијалогот.

### Focus Highlight {#VisionFocusHighlight}

Одбележувачот на Фокус може да помогне да се идентификува [system focus](#SystemFocus), [navigator object](#ObjectNavigation) и [browse mode](#BrowseMode) позиции.(преведи го претходното)
Овие позиции се одбележани со контура односно облик на правоаголник во боја.

* Потполно плаво одбележува комбиниран navigator објектот и system focus локација (на пример бидејќи [the navigator object follows the system focus](#ReviewCursorFollowFocus)).(преведи го претходното)
* Испрекината односно непотполна блава го одблежува само system focus објектот.(преведи го претходното)
* Потполно розево одбележува само navigator објект.(преведи го претходното)
* Потполно жолто одбележува virtual caret кој се користи во browse mode (таму каде што не постои физички caret како што се наоѓа во web прелистувачите).(преведи го претходното)

Кога Одбележувачот на Фокус е овозможен во [vision category](#VisionSettings) од [NVDA Settings](#NVDASettings) дијалогот, Вие можете [change whether or not to highlight the focus, navigator object or browse mode caret](#VisionSettingsFocusHighlight).

### Screen Curtain {#VisionScreenCurtain}

Како лице кое е со потешкотии во видот а корисник, често не е можно или потребно да се гледаат содржините на екранот.
Понатаму уште повеќе, може да биде тешко да се биде сигурен дека нема некој кој гледа преку вашето рамо.
За оваа ситуација, NVDA содржи feature наречена "screen curtain" која може да биде активирана за да го направи екранот црн.

Вие можете да ја овозможите Screen Curtain во [vision category](#VisionSettings) од [NVDA Settings](#NVDASettings) дијалогот.

## Content Recognition {#ContentRecognition}

Кога авторите не овозможуваат доволно информации за корисникот на читачот на екран да ја одреди содржината на нешто, различни алатки можат да бидат користени за обид да се препознае содржината од слика.
NVDA ја поддржува препознавањето на оптички карактери (OCR) функционалноста вградена во Windows 10 за да препознае текст од слика.
Додатни препознавачи на содржина можат да бидат достапни во форма на NVDA додатоци.

Кога Вие користите команда за препознавање на содржина, NVDA препознава содржина од моменталниот [navigator object](#ObjectNavigation).
Како основна селектирана опција, the navigator објектот ги следи системскиот фокус или browse mode курсорот, за Вие да можете вообичаено само да го движите фокусот или browse mode курсорот каде што посакувате.(преведи го претходното)
На пример, доколку го придвижите browse mode курсорот до графика, препознавањето ќе препознае содржина од графиката како основна селектирана опција.(преведи го претходното)
Меѓутоа сепак, Вие можете да посакате да го користите објект навигацијата директно до, на пример, препознавање на содржината од целосен апликациски прозорец.

Еднаш препознавањето е комплетно, резултатот ќе биде презентиран во документ сличен до browse mode, дозволувајќи Ви Вам да ја читате информацијата со курсор копчињата, и.т. натаму.(преведи го претходното)
Притискајќи enter или space ќе го активирате (normally click) текстот кој се наоѓа кај курсорот доколку тоа е можно.(преведи го претходното)
Притискајќи escape го отпуштате односно ослободувате резултатот од препознавањето.

### Windows 10 OCR {#Win10Ocr}

Windows 10 вклучува OCR за многу јазици.
NVDA може да го користи ова да препознае текст од слики или непристапни апликации.

Вие можете да го поставите јазикот кој го употребувате за текстуално препознавање во [Windows 10 OCR category](#Win10OcrSettings) од [NVDA Settings](#NVDASettings) дијалогот.
Додатни јазици можат да бидат инсталирани односно овозможени со отварање на Start menu, одбирајќи Settings, со селекција на Time & Language -> Region & Language и потоа одбирајќи Add a language.(преведи го претходното)

<!-- KC:beginInclude -->
За да се препознае текст во постојниот navigator object користејќи Windows 10 OCR, притиснете односно одберете NVDA+r.
<!-- KC:endInclude -->

## Application Specific Features {#ApplicationSpecificFeatures}

NVDA овозможува свои сопствени додатни опции односно карактеристики за некои апликации да ги направат одредени задачи полесни или да овозможат пристап до функционалноста која не е поинаку достапна до корисниците на читачите на екран.

### Microsoft Word {#MicrosoftWord}
#### Automatic Column and Row Header Reading {#WordAutomaticColumnAndRowHeaderReading}

NVDA е во можност автоматски да ги најавува соодветните ред и колона заглавија при навигација помеѓу табелите во Microsoft Word.
Ова првично бара да Report Table ред / колона опции за заглавија во NVDA's Document Formatting поставките, кои се наоѓаат во [NVDA Settings](#NVDASettings) дијалогот, да бидат вклучени.(преведи го претходното)
Понатаму како второ, NVDA треба да знае кој ред или колона ги содржи заглавијата во било која дадена односно присутна табела.
После придвижување во првата ќелија во колоната или редот кои ги содржат заглавијата, користете една од следниве команди:
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Set column headers |NVDA+shift+c |Pressing this once tells NVDA this is the first header cell in the row that contains column headers, which should be automatically announced when moving between columns below this row. Pressing twice will clear the setting.|
|Set row headers |NVDA+shift+r |Pressing this once tells NVDA this is the first header cell in the column that contains row headers, which should be automatically announced when moving between rows after  this column. Pressing twice will clear the setting.|

<!-- KC:endInclude -->
Овие поставки ќе бидат зачувани во документот како одбележувачи компатибилни со други читачи на екран како JAWS.
Ова значи дека корисниците на други екрани кои го отвараат овој документ подоцна автоматски ќе ги имаат ред и колона заглавјата веќе поставени.

#### Browse Mode in Microsoft Word {#BrowseModeInMicrosoftWord}

Слично на web, Browse mode може да биде користен во Microsoft Word да Ви дозволи да ги користите карактеристиките односно опциите како Quick Навигација и Elements List.(преведи го претходното)
<!-- KC:beginInclude -->
За да се вклучува/исклучува наизменично Browse mode во Microsoft Word, притиснете NVDA+space.(преведи го претходното)
<!-- KC:endInclude -->
За понатамошни информации окулу Browse mode и Quick Навигација, повеќе дознајте во [Browse Mode section](#BrowseMode).(преведи го претходното)

##### The Elements List {#WordElementsList}

<!-- KC:beginInclude -->
Додека сте во Browse mode во Microsoft Word, Вие можете да пристапувате кон Elements Листата со притискање на NVDA+f7.(преведи го претходното)
<!-- KC:endInclude -->
Elements Листата може да листа заглавја, links, прибелешки (кои вклучуваат коментари како и листа односно патека со промени) и грешки (кои моментално се ограничени на грешки во правописот).(преведи го претходното)

#### Reporting Comments {#WordReportingComments}

<!-- KC:beginInclude -->
За да известите некакви коментари на постојната caret позиција односно локација, притиснете NVDA+alt+c.(преведи го претходното)
<!-- KC:endInclude -->
Сите коментари за документот, заедно со останата забележана патека со промени, може исто да биде наведена односно извлистана во NVDA Elements Листа кога се одбираат Annotations како тип.(преведи го претходното)

### Microsoft Excel {#MicrosoftExcel}
#### Automatic Column and Row Header Reading {#ExcelAutomaticColumnAndRowHeaderReading}

NVDA е во можност автоматски да ги најавува соодветните ред и колона заглавја кога се придвижувате односно навигирате наокулу Excel работните листови.
Ова првично има потреба да Report Табелата ред / колона заглавја опцијата во NVDA's Форматирањето на Документ поставките, кое се наоѓа во [NVDA Settings](#NVDASettings) дојалогот, да биде вклучена.(преведи го претходното)
Понатаму како второ, NVDA има потреба да знае кој ред или колона ги содржи заглавјата.
После придвижување до првата ќелија во колоната или редот кој ги содржи заглавјата, користете една од следниве команди:
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Set column headers |NVDA+shift+c |Pressing this once tells NVDA this is the first header cell in the row that contains column headers, which should be automatically announced when moving between columns below this row. Pressing twice will clear the setting.|
|Set row headers |NVDA+shift+r |Pressing this once tells NVDA this is the first header cell in the column that contains row headers, which should be automatically announced when moving between rows after  this column. Pressing twice will clear the setting.|

<!-- KC:endInclude -->
Овие поставки ќе бидат складирани во работниот лист како дефинирани опцези со имиња компатибилни со останати читачи на екран како JAWS.
Ова значи дека корисниците на други читачи на екран кои ќе го отворат овој работен лист подоцна автоматски ќе ги имаат редот и колона заглавјата веќе поставени. 

#### The Elements List {#ExcelElementsList}

Слично на web, NVDA има Elements Листа за Microsoft Excel која Ви дозволува да наведувате односно листате како и да пристапувате неколку различни видови на информации.
<!-- KC:beginInclude -->
Да пристапите на Elements Листата во Excel, притиснете NVDA+f7.
<!-- KC:endInclude -->
Различните типови на информации кои се достапни во Elements Листата се:

* Charts: This lists all charts in the active worksheet. 
Selecting a chart and pressing enter or the Move to button focuses the chart for navigating and reading with the arrow keys.
* Comments: This lists all cells in the active worksheet containing comments. 
The cell address along with its comments are shown for each cell. 
Pressing enter or the Move To button when on a listed comment will move directly to that cell.
* Formulas: This lists all cells in the worksheet containing a formula. 
The cell address along with its formula are shown for each cell.
Pressing enter or the Move To button on a listed formula will move directly to that cell. 
* Sheets: This lists all sheets in the workbook. 
Pressing f2 when on a listed sheet allows you to rename the sheet. 
Pressing enter or the Move To button while on the listed sheet will switch to that sheet.
* Form fields: This lists all form fields in the active worksheet.
For each form field, the Elements List shows the alternative text of the field along with the addresses of the cells it covers.
Selecting a form field and pressing enter or the Move to button moves to that field in browse mode.

#### Reporting Notes {#ExcelReportingComments}

<!-- KC:beginInclude -->
To report any notes for the currently focused cell, press NVDA+alt+c.
In Microsoft 2016, 365 and newer, the classic comments in Microsoft Excel have been renamed to "notes".
<!-- KC:endInclude -->
All notes for the worksheet can also be listed in the NVDA Elements List after pressing NVDA+f7.

NVDA can also display a specific dialog for adding or editing a certain note.
NVDA overrides the native MS Excel notes editing region due to accessibility constraints, but the key stroke for displaying the dialog is inherited from MS Excel and therefore works also without NVDA running.
<!-- KC:beginInclude -->
To add or edit a certain note, in a focused cell, press shift+f2.
<!-- KC:endInclude -->

This key stroke does not appear and cannot be changed in NVDA's input gesture dialog.

Note: it is possible to open the note editing region in MS Excel also from the context menu of any cell of the work sheet.
However, this will open the inaccessible note editing region and not the NVDA specific note editing dialog.

In Microsoft Office 2016, 365 and newer, a new style comment dialog has been added.
This dialog is accessible and provides more features such as replying to comments, etc.
It can also be opened from the context menu of a certain cell.
The comments added to the cells via the new style comment dialog are not related to "notes".

#### Reading Protected Cells {#ExcelReadingProtectedCells}

If a workbook has been protected, it may not be possible to move focus to particular cells that have been locked for editing.
<!-- KC:beginInclude -->
To allow moving to locked cells, switch to Browse Mode by pressing NVDA+space, and then use standard Excel movement commands such as the arrow keys to move around all cells on the current worksheet.
<!-- KC:endInclude -->

#### Form Fields {#ExcelFormFields}

Excel worksheets can include form fields.
You can access these using the Elements List or the f and shift+f form field single letter navigation keys.
Once you move to a form field in browse mode, you can press enter or space to either activate it or switch to focus mode so you can interact with it, depending on the control.
For further information about Browse mode and single letter navigation, see the [Browse Mode section](#BrowseMode).

### Microsoft PowerPoint {#MicrosoftPowerPoint}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Toggle speaker notes reading |control+shift+s |When in a running slide show, this command will toggle between the speaker notes for the slide and the content for the slide. This only affects what NVDA reads, not what is displayed on screen.|

<!-- KC:endInclude -->

### foobar2000 {#Foobar2000}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Report remaining time |control+shift+r |Reports the remaining time of the currently playing track, if any.|
|Report elapsed time |control+shift+e |Reports the elapsed time of the currently playing track, if any.|
|Report track length |control+shift+t |Reports the length of the currently playing track, if any.|

<!-- KC:endInclude -->

Note: The above shortcuts work only with the default formatting string for foobar's status line.

### Miranda IM {#MirandaIM}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Report recent message |NVDA+control+1-4 |Reports one of the recent messages, depending on the number pressed; e.g. NVDA+control+2 reads the second most recent message.|

<!-- KC:endInclude -->

### Poedit {#Poedit}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Report Comments Window |control+shift+c |Reports any comments in the comments window.|
|Report notes for translators |control+shift+a |Reports any notes for translators.|

<!-- KC:endInclude -->

### Kindle for PC {#Kindle}

NVDA supports reading and navigating books in Amazon Kindle for PC.
This functionality is only available in Kindle books designated with "Screen Reader: Supported" which you can check on the details page for the book.

Browse mode is used to read books.
It is enabled automatically when you open a book or focus the book area.
The page will be turned automatically as appropriate when you move the cursor or use the say all command.
<!-- KC:beginInclude -->
You can manually turn to the next page with the pageDown key and turn to the previous page with the pageUp key.
<!-- KC:endInclude -->

Single letter navigation is supported for links and graphics, but only within the current page.
Navigating by link also includes footnotes.

NVDA provides early support for reading and interactive navigation of mathematical content for books with accessible math.
Please see the [Reading Mathematical Content](#ReadingMath) section for further information.

#### Text Selection {#KindleTextSelection}

Kindle allows you to perform various functions on selected text, including obtaining a dictionary definition, adding notes and highlights, copying the text to the clipboard and searching the web.
To do this, first select text as you normally would in browse mode; e.g. by using shift and the cursor keys.
<!-- KC:beginInclude -->
Once you have selected text, press the applications key or shift+f10 to show the available options for working with the selection.
<!-- KC:endInclude -->
If you do this with no text selected, options will be shown for the word at the cursor.

#### User Notes {#KindleUserNotes}

You can add a note regarding a word or passage of text.
To do this, first select the relevant text and access the selection options as described above.
Then, choose Add Note.

When reading in browse mode, NVDA refers to these notes as comments.

To view, edit or delete a note:

1. Move the cursor to the text containing the note.
1. Access the options for the selection as described above.
1. Choose Edit Note.

### Azardi {#Azardi}

<!-- KC:beginInclude -->
When in the table view of added books:

| Name |Key |Description|
|---|---|---|
|Enter |enter |Opens the selected book.|
|Context menu |applications |Opens the context menu for the selected book.|

<!-- KC:endInclude -->

### Windows Console {#WinConsole}

NVDA provides support for the Windows command console used by Command Prompt, PowerShell, and the Windows Subsystem for Linux.
The console window is of fixed size, typically much smaller than the buffer that holds the output.
As new text is written, the content scroll upwards and previous text is no longer visible. 
Text that is not visibly displayed in the window is not accessible with NVDA's text review commands.
Therefore, it is necessary to scroll the console window to read earlier text.
<!-- KC:beginInclude -->
The following built-in Windows Console keyboard shortcuts may be useful when [reviewing text](#ReviewingText) with NVDA:

| Name |Key |Description|
|---|---|---|
|Scroll up |control+upArrow |Scrolls the console window up, so earlier text can be read.|
|Scroll down |control+downArrow |Scrolls the console window down, so later text can be read.|
|Scroll to start |control+home |Scrolls the console window to the beginning of the buffer.|
|Scroll to end |control+end |Scrolls the console window to the end of the buffer.|

<!-- KC:endInclude -->

## Configuring NVDA {#ConfiguringNVDA}

Most configuration can be performed using dialog boxes accessed through the Preferences sub-menu of the NVDA menu.
Many of these settings can be found in the multi-page [NVDA Settings dialog](#NVDASettings).
In all dialog boxes, press the OK button to accept any changes you have made.
To cancel any changes, press the Cancel button or the escape key.
For certain dialogs, you can press the Apply button to let the settings take effect immediately without closing the dialog.
Some settings can also be changed using shortcut keys, which are listed where relevant in the sections below.

### NVDA Settings {#NVDASettings}

<!-- KC:settingsSection: || Name | Desktop key | Laptop key | Description | -->
The NVDA Settings dialog contains many configuration parameters that can be changed.
This dialog contains a list with several categories of settings to choose from.
When you select a category, several settings related to this category will be shown in this dialog.
These settings can be applied using the apply button, in which case the dialog will stay open.
If you want to save your settings and close the NVDA Settings dialog, you can use the OK button.

Some settings categories have dedicated shortcut keys.
If pressed, the shortcut key will open the NVDA Settings dialog in that particular category.
By default, not all categories can be accessed with keyboard commands.
If you wish to access categories which do not have dedicated shortcut keys, use the [Input Gestures dialog](#InputGestures) to add a custom gesture such as a keyboard command or touch gesture for that category.

The settings categories found in the NVDA Settings dialog will be outlined below.

#### General (NVDA+control+g) {#GeneralSettings}

The General category of the NVDA Settings dialog sets NVDA's overall behaviour such as interface language and whether or not it should check for updates.
This category contains the following options:

##### Language {#GeneralSettingsLanguage}

This is a combo box which allows you to select the language that NVDA's user interface and messages should be shown in.
There are many languages, however the default option is "User Default, Windows".
This option tells NVDA to use the language that Windows is currently set to.

Please note that NVDA must be restarted when changing the language.
When the confirmation dialog appears, select "restart now" or "restart later" if you wish to use the new language now or at a later time, respectively. If "restart later" is selected, the configuration must be saved (either manually or using the save on exit functionality).

##### Save configuration on exit {#GeneralSettingsSaveConfig}

This option is a checkbox that, when checked, tells NVDA to automatically save the current configuration when you exit NVDA.

##### Show exit options when exiting NVDA {#GeneralSettingsShowExitOptions}

This option is a checkbox that allows you to choose whether or not a dialog appears when you exit NVDA that asks what action you want to perform.
When checked, a dialog will appear when you attempt to exit NVDA asking whether you want to exit, restart, restart with add-ons disabled or install pending updates (if any).
When unchecked, NVDA will exit immediately.

##### Play sounds when starting or exiting NVDA {#GeneralSettingsPlaySounds}

This option is a checkbox that, when checked, tells NVDA to play sounds when it starts or exits.

##### Logging level {#GeneralSettingsLogLevel}

This is a combo box that lets you choose how much NVDA will log as it's running.
Generally users should not need to touch this as not too much is logged.
However, if you wish to provide information in a bug report, or enable or disable logging altogether, then it may be a useful option.

The available logging levels are:

* Disabled: Apart from a brief startup message, NVDA will not log anything while it runs.
* Info: NVDA will log basic information such as startup messages and information useful for developers.
* Debug warning: Warning messages that are not caused by severe errors will be logged.
* Input/output: Input from keyboard and braille displays, as well as speech and braille output will be logged.
 * If you are concerned about privacy, do not set the logging level to this option.
* Debug: In addition to info, warning, and input/output messages, additional debug messages will be logged.
 * Just like input/output, if you are concerned about privacy, you should not set the logging level to this option.

##### Start NVDA after I sign in {#GeneralSettingsStartAfterLogOn}

If this option is enabled, NVDA will start automatically as soon as you sign in to Windows.
This option is only available for installed copies of NVDA.

##### Use NVDA during sign-in (requires administrator privileges) {#GeneralSettingsStartOnLogOnScreen}

If you sign in to Windows by providing a user name and password, then enabling this option will make NVDA start automatically at the sign-in screen when Windows starts.
This option is only available for installed copies of NVDA.

##### Use currently saved settings during sign-in and on secure screens (requires administrator privileges) {#GeneralSettingsCopySettings}

Pressing this button copies your currently saved NVDA user configuration to NVDA's system configuration directory, so that NVDA will use it during sign-in and when running on User Account Control (UAC) and other secure Windows screens.
To make sure that all your settings are transferred, make sure to save your configuration first with control+NVDA+c or Save configuration in the NVDA menu.
This option is only available for installed copies of NVDA.

##### Automatically check for updates to NVDA {#GeneralSettingsCheckForUpdates}

If this is enabled, NVDA will automatically check for updated versions and inform you when an update is available.
You can also manually check for updates by selecting Check for updates under Help in the NVDA menu.
When manually or automatically checking for updates, it is necessary for NVDA to send some information to the update server in order to receive the correct update for your system.
The following information is always sent: 

* Current NVDA version
* Operating System version
* Whether the Operating System is 64 or 32 bit

##### Allow the NVDA project to gather NVDA usage statistics {#GeneralSettingsGatherUsageStats}

If this is enabled, NV Access will use the information from update checks in order to track  the number of NVDA users including particular demographics such as Operating system and country of origin.
Note that although your IP address will be used to calculate your country during the update check, the IP address is never kept.
Apart from the mandatory information required to check for updates, the following extra information is also currently sent:

* NVDA interface language
* Whether this copy of NVDA is portable or installed
* Name of the current speech synthesizer in use (including the name of the add-on the driver comes from)
* Name of the current Braille display in use (including the name of the add-on the driver comes from)
* The current output Braille table (if Braille is in use)

This information greatly aides NV Access to prioritize future development of NVDA.

##### Notify for pending updates on startup {#GeneralSettingsNotifyPendingUpdates}

If this is enabled, NVDA will inform you when there is a pending update on startup, offering you the possibility to install it.
You can also manually install the pending update from the Exit NVDA dialog (if enabled),  from the NVDA menu, or when you perform a new check from the Help menu.

#### Speech Settings (NVDA+control+v) {#SpeechSettings}

The Speech category in the NVDA Settings dialog contains options that lets you change the speech synthesizer as well as voice characteristics for the chosen synthesizer.
For a quicker alternative way of controlling speech parameters from anywhere, please see the [Synth Settings Ring](#SynthSettingsRing) section.

The Speech Settings category contains the following options:

##### Change synthesizer {#SpeechSettingsChange}

The first option in the Speech Settings category is the Change... button. This button activates the [Select Synthesizer](#SelectSynthesizer) dialog, which allows you to select the active speech synthesizer and output device.
This dialog opens on top of the NVDA Settings dialog.
Saving or dismissing the settings in the Select Synthesizer dialog will return you to the NVDA Settings dialog.

##### Voice {#SpeechSettingsVoice}

The Voice option is a combo box listing all the voices of the current synthesizer that you have installed.
You can use the arrow keys to listen to all the various choices.
Left and Up arrow take you up in the list, while right and down arrow move you down in the list.

##### Variant {#SpeechSettingsVariant}

If you are using the Espeak NG synthesizer which is packaged with NVDA, this is a combo box that allows you to select the Variant the synthesizer should speak with.
ESpeak NG's Variants are rather like voices, as they provide slightly different attributes to the eSpeak NG voice.
Some variants will sound like a male, some like a female, and some even like a frog.
If using a third-party synthesizer, you may also be able to change this value if your chosen voice supports it.

##### Rate {#SpeechSettingsRate}

This option allows you to change the rate of your voice.
This is a slider that goes from 0 to 100 - 0 being the slowest, 100 being the fastest.

##### Pitch {#SpeechSettingsPitch}

This option allows you to change the pitch of the current voice.
It is a slider which goes from 0 to 100 - 0 being the lowest pitch and 100 being the highest.

##### Volume {#SpeechSettingsVolume}

This option is a slider which goes from 0 to 100 - 0 being the lowest volume and 100 being the highest.

##### Inflection {#SpeechSettingsInflection}

This option is a slider that lets you choose how much inflection (rise and fall in pitch) the synthesizer should use to speak with.

##### Automatic Language switching {#SpeechSettingsLanguageSwitching}

This checkbox allows you to toggle whether NVDA should switch speech synthesizer languages automatically if the text being read specifies its language.
This option is enabled by default.

##### Automatic Dialect switching {#SpeechSettingsDialectSwitching}

This checkbox allows you to toggle whether or not dialect changes should be made, rather than just actual language changes.
For example, if reading in an English U.S. voice but a document specifies that some text is in English U.K., then the synthesizer will switch accents if this option is enabled.
This option is disabled by default.

<!-- KC:setting -->

##### Punctuation/Symbol Level {#SpeechSettingsSymbolLevel}

Key: NVDA+p

This allows you to choose the amount of punctuation and other symbols that should be spoken as words.
For example, when set to all, all symbols will be spoken as words.
This option applies to all synthesizers, not just the currently active synthesizer.

##### Trust voice's language when processing characters and symbols {#SpeechSettingsTrust}

On by default, this option tells NVDA if the current voice's language can be trusted when processing symbols and characters.
If you find that NVDA is reading punctuation in the wrong language for a particular synthesizer or voice, you may wish to turn this off to force NVDA to use its global language setting instead.

##### Include Unicode Consortium data (including emoji) when processing characters and symbols {#SpeechSettingsCLDR}

When this checkbox is checked, NVDA will include additional symbol pronunciation dictionaries when pronouncing characters and symbols.
These dictionaries contain descriptions for symbols (particularly emoji) that are provided by the [Unicode Consortium](https://www.unicode.org/consortium/) as part of their [Common Locale Data Repository](http://cldr.unicode.org/).
If you want NVDA to speak descriptions of emoji characters based on this data, you should enable this option.
However, if you are using a speech synthesizer that supports speaking emoji descriptions natively, you may wish to turn this off.

Note that manually added or edited character descriptions are saved as part of your user settings.
Therefore, if you change the description of a particular emoji, your custom description will be spoken for that emoji regardless of whether this option is enabled.
You can add, edit or remove symbol descriptions in NVDA's [punctuation/symbol pronunciation dialog](#SymbolPronunciation).

To toggle Unicode Consortium data inclusion from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

##### Capital pitch change percentage {#SpeechSettingsCapPitchChange}

This edit field allows you to type the amount that the pitch of the voice will change when speaking a capital letter.
This value is a percentage, where a negative value lowers the pitch and a positive value raises it.
For no pitch change you would use 0.
Usually, NVDA raises the pitch slightly for any capital letter, but some synthesizers may not support this well.
In case pitch change for capitals is not supported, consider [Say "cap" before capitals](#SpeechSettingsSayCapBefore) and/or [ Beep for capitals](#SpeechSettingsBeepForCaps) instead.

##### Say "cap" before capitals {#SpeechSettingsSayCapBefore}

This setting is a checkbox that, when checked, tells NVDA to say the word "cap" before any capital letter when spoken as an individual character such as when spelling.

##### Beep for capitals {#SpeechSettingsBeepForCaps}

If this checkbox is checked, NVDA will make a small beep each time it encounters a capitalized character by itself.

##### Use spelling functionality if supported {#SpeechSettingsUseSpelling}

Some words consist of only one character, but the pronunciation is different depending on whether the character is being spoken as an individual character (such as when spelling) or a word.
For example, in English, "a" is both a letter and a word and is pronounced differently in each case.
This option allows the synthesizer to differentiate between these two cases if the synthesizer supports this.
Most synthesizers do support it.

This option should generally be enabled.
However, some Microsoft Speech API synthesizers do not implement this correctly and behave strangely when it is enabled.
If you are having problems with the pronunciation of individual characters, try disabling this option.

#### Select Synthesizer (NVDA+control+s) {#SelectSynthesizer}

The Synthesizer dialog, which can be opened by activating the Change... button in the speech category of the NVDA settings dialog, allows you to select which Synthesizer NVDA should use to speak with.
Once you have selected your synthesizer of choice, you can press Ok and NVDA will load the selected Synthesizer.
If there is an error loading the synthesizer, NVDA will notify you with a message, and continue using the previous synthesizer.

##### Synthesizer {#SelectSynthesizerSynthesizer}

This option allows you to choose the synthesizer you wish NVDA to use for speech output.

For a list of the Synthesizers that NVDA supports, please see the [Supported Speech Synthesizers](#SupportedSpeechSynths) section.

One special item that will always appear in this list is "No speech", which allows you to use NVDA with no speech output whatsoever.
This may be useful for someone who wishes to only use NVDA with braille, or perhaps to sighted developers who only wish to use the Speech Viewer.

##### Output device {#SelectSynthesizerOutputDevice}

This option allows you to choose the audio device that NVDA should instruct the selected synthesizer to speak through.

<!-- KC:setting -->

##### Audio Ducking Mode {#SelectSynthesizerDuckingMode}

Key: NVDA+shift+d

On Windows 8 and above, this option allows you to choose if NVDA should lower the volume of other applications while NVDA is speaking, or all the time while NVDA is running.

* No Ducking: NVDA will never lower the volume of other audio. 
* Duck when outputting speech and sounds: NVDA will only lower the volume of other audio when NVDA is speaking or playing sounds. This may not work for all synthesizers. 
* Always duck: NVDA will keep the volume of other audio lower the whole time NVDA is running.

This option is only available if NVDA has been installed.
It is not possible to support audio ducking for portable and temporary copies of NVDA.

#### Synth settings ring {#SynthSettingsRing}

If you wish to quickly change speech settings without going to the Speech category of the NVDA settings dialog, there are some NVDA key commands that allow you to move through the most common speech settings from anywhere while running NVDA:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Move to next synth setting |NVDA+control+rightArrow |NVDA+shift+control+rightArrow |Moves to the next available speech setting after the current, wrapping around to the first setting again after the last|
|Move to previous synth setting |NVDA+control+leftArrow |NVDA+shift+control+leftArrow |Moves to the next available speech setting before the current, wrapping around to the last setting after the first|
|Increment current synth setting |NVDA+control+upArrow |NVDA+shift+control+upArrow |increases the current speech setting you are on. E.g. increases the rate, chooses the next voice, increases the volume|
|Decrement current synth setting |NVDA+control+downArrow |NVDA+shift+control+downArrow |decreases the current speech setting you are on. E.g. decreases the rate, chooses the previous voice, decreases the volume|

<!-- KC:endInclude -->

#### Braille {#BrailleSettings}

The Braille category in the NVDA Settings dialog contains options that let you change several aspects of braille input and output.
This category contains the following options:

##### Change braille display {#BrailleSettingsChange}

The Change... button in the Braille category of the NVDA Settings dialog activates the [Select Braille Display](#SelectBrailleDisplay) dialog, which allows you to select the active braille display.
This dialog opens on top of the NVDA Settings dialog.
Saving or dismissing the settings in the Select Braille Display dialog will return you to the NVDA Settings dialog.

##### Output Table {#BrailleSettingsOutputTable}

The next option you will come to in this category is the braille output table combo box.
In this combo box, you will find braille tables for different languages, braille standards and grades.
The chosen table will be used to translate text into braille to be presented on your braille display.
You can move from braille table to braille table in the list by using the arrow keys.

##### Input Table {#BrailleSettingsInputTable}

Complementary to the previous option, the next setting you will find is the braille input table combo box.
The chosen table will be used to translate braille entered on your braille display's Perkins-style keyboard into text.
You can move from braille table to braille table in the list by using the arrow keys.

Note that this option is only useful if your braille display has a Perkins-style keyboard and this feature is supported by the braille display driver.
If input is not supported on a display which does have a braille keyboard, this will be noted in the [Supported Braille Displays](#SupportedBrailleDisplays) section.

##### Expand to computer braille for the word at the cursor {#BrailleSettingsExpandToComputerBraille}

This option allows the word that is under the cursor to be displayed in non-contracted computer braille.

##### Show Cursor {#BrailleSettingsShowCursor}

This option allows the braille cursor to be turned on and off.
It applies to the system caret and review cursor, but not to the selection indicator.

##### Blink Cursor {#BrailleSettingsBlinkCursor}

This option allows the braille cursor to blink.
If blinking is turned off, the braille cursor will constantly be in the "up" position.
The selection indicator is not affected by this option, it is always dots 7 and 8 without blinking.

##### Cursor Blink Rate (ms) {#BrailleSettingsBlinkRate}

This option is a numerical field that allows you to change the blink rate of the cursor in milliseconds.

##### Cursor Shape for Focus {#BrailleSettingsCursorShapeForFocus}

This option allows you to choose the shape (dot pattern) of the braille cursor when braille is tethered to focus.
The selection indicator is not affected by this option, it is always dots 7 and 8 without blinking.

##### Cursor Shape for Review {#BrailleSettingsCursorShapeForReview}

This option allows you to choose the shape (dot pattern) of the braille cursor when braille is tethered to review.
The selection indicator is not affected by this option, it is always dots 7 and 8 without blinking.

##### Message Timeout (sec) {#BrailleSettingsMessageTimeout}

This option is a numerical field that controls how long NVDA messages are displayed on the braille display.
Specifying 0 disables displaying of these messages completely.
The NVDA message is imediately dismissed when pressing a routing key on the braille display, but appears again when pressing a corresponding key which triggers the message.

##### Show Messages Indefinitely {#BrailleSettingsNoMessageTimeout}

This option allows NVDA messages to be displayed on the braille display indefinitely.

<!-- KC:setting -->

##### Tether Braille {#BrailleTether}

Key: NVDA+control+t

This option allows you to choose whether the braille display will follow the system focus / caret, the navigator object / review cursor, or both.
When "automatically" is selected, NVDA will follow the system focus and caret by default.
In this case, when the navigator object or the review cursor position is changed by means of explicit user interaction, NVDA will tether to review temporarily, until the focus or the caret changes.
If you want it to follow the focus and caret only, you need to configure braille to be tethered to focus.
In this case, braille will not follow the NVDA navigator during object navigation or the review cursor during review.
If you want braille to follow object navigation and text review instead, you need to configure braille to be tethered to review.
In this case, Braille  will not follow system focus and system caret.

##### Read by Paragraph {#BrailleSettingsReadByParagraph}

If enabled, braille will be displayed by paragraphs instead of lines.
Also, the next and previous line commands will move by paragraph accordingly.
This means that you do not have to scroll the display at the end of each line even where more text would fit on the display.
This may allow for more fluent reading of large amounts of text.
It is disabled by default.

##### Avoid splitting words when possible {#BrailleSettingsWordWrap}

If this is enabled, a word which is too large to fit at the end of the braille display will not be split.
Instead, there will be some blank space at the end of the display.
When you scroll the display, you will be able to read the entire word.
This is sometimes called "word wrap".
Note that if the word is too large to fit on the display even by itself, the word must still be split.

If this is disabled, as much of the word as possible will be displayed, but the rest will be cut off.
When you scroll the display, you will then be able to read the rest of the word.

Enabling this may allow for more fluent reading, but generally requires you to scroll the display more.

##### Focus context presentation {#BrailleSettingsFocusContextPresentation}

This option allows you to choose what context information NVDA will show on the braille display when an object gets focus.
Context information refers to the hierarchy of objects containing the focus.
For example, when you focus a list item, this list item is part of a list.
This list might be contained by a dialog, etc.
Please consult the section about [object navigation](#ObjectNavigation) for more information about the hierarchy that applies to objects in NVDA.

When set to fill display for context changes, NVDA will try to display as much context information as possible on the braille display, but only for the parts of the context that have changed.
For the example above, this means that when changing focus to the list, NVDA will show the list item on the braille display.
Furthermore, if there is enough space left on the braille display, NVDA will try to show that the list item is part of a list.
If you then start moving through the list with your arrow keys, it is assumed that you are aware that you are still in the list.
Thus, for the remaining list items you focus, NVDA will only show the focused list item on the display.
In order for you to read the context again (i.e. that you are in a list and that the list is part of a dialog), you will have to scroll your braille display back.

When this option is set to always fill the display, NVDA will try to show as much context information as possible on the braille display, regardless of whether you have seen the same context information before.
This has the advantage that NVDA will fit as much information as possible on the display.
However, the downside is that there is always a difference in the position where the focus starts on the braille display.
This can make it difficult to skim a long list of items, for example, as you will need to continually move your finger to find the start of the item.
This was the default behaviour for NVDA 2017.2 and before.

When you set the focus context presentation option to only show the context information when scrolling back, NVDA never shows context information on your braille display by default.
Thus, in the example above, NVDA will display that you focused a list item.
However, in order for you to read the context (i.e. that you are in a list and that the list is part of a dialog), you will have to scroll your braille display back.

To toggle focus context presentation from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

#### Select Braille Display (NVDA+control+a) {#SelectBrailleDisplay}

The Select Braille Display dialog, which can be opened by activating the Change... button in the Braille category of the NVDA settings dialog, allows you to select which Braille display NVDA should use for braille output.
Once you have selected your braille display of choice, you can press Ok and NVDA will load the selected display.
If there is an error loading the display driver, NVDA will notify you with a message, and continue using the previous display, if any.

##### Braille Display {#SelectBrailleDisplayDisplay}

This combo box presents you with several options depending on what braille display drivers are available on your system.
Move between these options with the arrow keys.

The automatic option will allow NVDA to search for many supported braille displays in the background.
When this feature is enabled and you connect a supported display using USB or bluetooth, NVDA will automatically connect with this display.

No braille means that you are not using braille.

Please see the [Supported Braille Displays](#SupportedBrailleDisplays) section for more information about supported braille displays and which of these support automatic detection in the background.

##### Port {#SelectBrailleDisplayPort}

This option, if available, allows you to choose what port or type of connection will be used to communicate with the braille display you have selected.
It is a combo box containing the possible choices for your braille display.

By default, NVDA employs automatic port detection, which means the connection with the braille device will be established automatically by scanning for available USB and bluetooth devices on your system.
However, for some braille displays, you may be able to explicitly choose what port should be used.
Common options are "Automatic" (which tells NVDA to employ the default automatic port selection procedure), "USB", "Bluetooth" and legacy serial communication ports if your braille display supports this type of communication.

This option won't be available if your braille display only supports automatic port detection.

You may consult the documentation for your braille display in the section [Supported Braille Displays](#SupportedBrailleDisplays) to check for more details on the supported types of communication and available ports.

#### Vision {#VisionSettings}

The Vision category in the NVDA Settings dialog allows you to enable, disable and configure [visual aids](#Vision).

Note that the available options in this category could be extended by [NVDA add-ons](#AddonsManager).
By default, this settings category contains the following options:

##### Focus Highlight {#VisionSettingsFocusHighlight}

The check boxes in the Focus Highlight grouping control the behaviour of NVDA's built-in [Focus Highlight](#VisionFocusHighlight) facility.

* Enable Highlighting: Toggles Focus Highlight on and off.
* Highlight system focus: toggles whether the [system focus](#SystemFocus) will be highlighted.
* Highlight navigator object: toggles whether the [navigator object](#ObjectNavigation) will be highlighted.
* Highlight browse mode cursor: Toggles whether the [virtual browse mode cursor](#BrowseMode) will be highlighted.

Note that checking and unchecking the "Enable Highlighting" check box wil also change the state of the tree other check boxes accordingly.
Therefore, if "Enable Highlighting" is off and you check this check box, the other tree check boxes will also be checked automatically.
If you only want to highlight the focus and leave the navigator object and browse mode check boxes unchecked, the state of the "Enable Highlighting" check box will be half checked.

##### Screen Curtain {#VisionSettingsScreenCurtain}

You can enable the [Screen Curtain](#VisionScreenCurtain) by checking the "Make screen black (immediate effect)" check box.
A warning that your screen will become black after activation will be displayed.
Before continuing (selecting "Yes"), ensure you have enabled speech / braille and will be able to control your computer without the use of the screen.
Select "No" if you no longer wish to enable the Screen Curtain.
If you are sure, you can choose the Yes button to enable the screen curtain.
If you no longer want to see this warning message every time, you can change this behaviour in the dialog that displays the message.
You can always restore the warning by checking the "Always show a warning when loading Screen Curtain" check box next to the "Make screen black" check box.

To toggle the Screen Curtain from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

By default, sounds are played when the Screen Curtain is toggled.
When you want to change this behaviour, you can uncheck the "Play sound when toggling Screen Curtain" check box.

##### Settings for third party visual aids {#VisionSettingsThirdPartyVisualAids}

Additional vision enhancement providers can be provided in [NVDA add-ons](#AddonsManager).
When these providers have adjustable settings, they will be shown in this settings category in separate groupings.
For the supported settings per provider, please refer to the documentation for that provider.

#### Keyboard (NVDA+control+k) {#KeyboardSettings}

The Keyboard category in the NVDA Settings dialog contains options that set how NVDA behaves as you use and type on your keyboard.
This settings category contains the following options:

##### Keyboard layout {#KeyboardSettingsLayout}

This combo box lets you choose what type of keyboard layout NVDA should use. Currently the two that come with NVDA are Desktop and Laptop.

##### Select NVDA Modifier Keys {#KeyboardSettingsModifiers}

The checkboxes in this list control what keys can be used as [NVDA modifier keys](#TheNVDAModifierKey). The following keys are available to choose from:

* The Caps Lock key
* The insert key on the number pad
* The extended insert key (usually found above the arrow keys, near home and end)

If no key is chosen as the NVDA key it may be impossible to access certain NVDA commands.
Therefore, The NVDA settings dialog will display an error message if all keys are unselected when pressing Ok or Apply.
After dismissing the error message, you must select at least one before being able to press Ok to dismiss the dialog properly.

<!-- KC:setting -->

##### Speak Typed Characters {#KeyboardSettingsSpeakTypedCharacters}

Key: NVDA+2

When enabled, NVDA will announce all characters you type on the keyboard.

<!-- KC:setting -->

##### Speak Typed Words {#KeyboardSettingsSpeakTypedWords}

Key: NVDA+3

When enabled, NVDA will announce all words you type on the keyboard.

##### Speech interrupt for typed characters {#KeyboardSettingsSpeechInteruptForCharacters}

If on, this option will cause speech to be interrupted each time a character is typed. This is on by default.

##### Speech interrupt for Enter key {#KeyboardSettingsSpeechInteruptForEnter}

If on, this option will cause speech to be interrupted each time the Enter key is pressed. This is on by default.

##### Allow skim reading in Say All {#KeyboardSettingsSkimReading}

If on, certain navigation commands (such as quick navigation in browse mode or moving by line or paragraph) do not stop Say All, rather Say All jumps to the new position and continues reading.

##### Beep if Typing Lowercase Letters when Caps Lock is On {#KeyboardSettingsBeepLowercase}

When enabled, a warning beep will be heard if a letter is typed with the shift key while Caps Lock is on.
Generally, typing shifted letters with Caps Lock is unintentional and is usually due to not realizing that Caps Lock is enabled.
Therefore, it can be quite helpful to be warned about this.

<!-- KC:setting -->

##### Speak Command Keys {#KeyboardSettingsSpeakCommandKeys}

Key: NVDA+4

When enabled, NVDA will announce all non-character keys you type on the keyboard. This includes key combinations such as control plus another letter.

##### Play sound for spelling errors while typing {#KeyboardSettingsAlertForSpellingErrors}

When enabled, a short buzzer sound will be played when a word you type contains a spelling error.
This option is only available if reporting of spelling errors is enabled in NVDA's [Document Formatting Settings](#DocumentFormattingSettings), found in the NVDA Settings dialog.

##### Handle keys from other applications {#KeyboardSettingsHandleKeys}

This option allows the user to control if key presses generated by applications such as on-screen keyboards and speech recognition software should be processed by NVDA. 
This option is on by default, though certain users may wish to turn this off, such as those typing Vietnamese with the UniKey typing software as it will  cause incorrect character input.

#### Mouse (NVDA+control+m) {#MouseSettings}

The Mouse category in the NVDA Settings dialog allows NVDA to track the mouse, play mouse coordinate beeps and sets other mouse usage options.
This category contains the following options:

##### Report Mouse Shape Changes {#MouseSettingsShape}

A checkbox, that when checked means that NVDA will announce the shape of the mouse pointer each time it changes.
The mouse pointer in Windows changes shape to convey certain information such as when something is editable, or when something is loading etc.

<!-- KC:setting -->

##### Enable mouse tracking {#MouseSettingsTracking}

Key: NVDA+m

When enabled, NVDA will announce the text currently under the mouse pointer, as you move it around the screen. This allows you to find things on the screen, by physically moving the mouse, rather than trying to find them through object navigation.

##### Text unit resolution {#MouseSettingsTextUnit}

If NVDA is set to announce the text under the mouse as you move it, this option allows you to choose exactly how much text will be spoken.
The options are character, word, line and paragraph.

To toggle text unit resolution from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

##### Report role when mouse enters object {#MouseSettingsRole}

If this checkbox is checked, NVDA will announce the role (type) of object as the mouse moves inside it.

##### Play audio coordinates when mouse moves {#MouseSettingsAudio}

Checking this checkbox makes NVDA play beeps as the mouse moves, so that the user can work out where the mouse is in regards to the dimensions of the screen.
The higher the mouse is on the screen, the higher the pitch of the beeps.
The further left or right the mouse is located on the screen, the further left or right the sound will be played (assuming the user has stereo speakers or headphones).

##### Brightness controls audio coordinates volume {#MouseSettingsBrightness}

If the "play audio coordinates when mouse moves" checkbox is checked, then checking this checkbox means that the volume of the audio coordinates beeps is controlled by how bright the screen is under the mouse.
This setting is unchecked by default.

##### Ignore mouse input from other applications {#MouseSettingsHandleMouseControl}

This option allows the user to ignore mouse events (including mouse movement and button presses) generated by other applications such as TeamViewer and other remote control software.
This option is unchecked by default.
If you check this option and you have the "Enable mouse tracking" option enabled, NVDA will not announce what is under the mouse if the mouse is moved by another application.

#### Touch Interaction {#TouchInteraction}

This settings category, only available on computers running Windows 8 and later with touch capabilities, allows you to configure how NVDA interacts with touchscreens.
This category contains the following options:

##### Enable touch interaction support {#TouchSupportEnable}

This checkbox enables NVDA's touch interaction support.
If enabled, you can use your fingers to navigate and interact with items on screen using a touchscreen device.
If disabled, touchscreen support will be disabled as though NVDA is not running.
This setting can also be toggled using NVDA+control+alt+t. 

##### Touch typing mode {#TouchTypingMode}

This checkbox allows you to specify the method you wish to use when entering text using the touch keyboard.
If this checkbox is checked, when you locate a key on the touch keyboard, you can lift your finger and the selected key will be pressed.
If this is unchecked, you need to double-tap on the key of the touch keyboard to press the key.

#### Review Cursor {#ReviewCursorSettings}

The Review Cursor category in the NVDA Settings dialog is used to configure NVDA's review cursor behaviour.
This category contains the following options:

<!-- KC:setting -->

##### Follow System Focus {#ReviewCursorFollowFocus}

Key: NVDA+7

When enabled, The review cursor will always be placed in the same object as the current system focus whenever the focus changes.

<!-- KC:setting -->

##### Follow System Caret {#ReviewCursorFollowCaret}

Key: NVDA+6

When enabled, the review cursor will automatically be moved to the position of the System caret each time it moves.

##### Follow mouse cursor {#ReviewCursorFollowMouse}

When enabled, the review cursor will follow the mouse as it moves.

##### Simple Review mode {#ReviewCursorSimple}

When enabled, NVDA will filter the hierarchy of objects that can be navigated to exclude objects that aren't of interest to the user; e.g. invisible objects and objects used only for layout purposes.

To toggle simple review mode from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

#### Object Presentation (NVDA+control+o) {#ObjectPresentationSettings}

The Object Presentation category in the NVDA Settings dialog is used to set how much information NVDA will present about controls such as description, position information and so on.
This category contains the following options:

##### Report tooltips {#ObjectPresentationReportToolTips}

A checkbox that when checked tells NVDA to report tooltips as they appear.
Many Windows and controls show a small message (or tooltip) when you move the mouse pointer over them, or sometimes when you move the focus to them.

##### Report notifications {#ObjectPresentationReportNotifications}

This checkbox, when checked, tells NVDA to report help balloons and toast notifications as they appear.

* Help Balloons are like tooltips, but are usually larger in size, and are associated with system events such as a network cable being unplugged, or perhaps to alert you about Windows security issues.
* Toast notifications have been introduced in Windows 10 and appear in the notification centre in the system tray, informing about several events (i.e. if an update has been downloaded, a new e-mail arrived in your inbox, etc.).

##### Report Object Shortcut Keys {#ObjectPresentationShortcutKeys}

When this checkbox is checked, NVDA will include the shortcut key that is associated with a certain object or control when it is reported.
For example the File menu on a menu bar may have a shortcut key of alt+f.

##### Report object position information {#ObjectPresentationPositionInfo}

This option lets you choose whether you wish to have an object's position (e.g. 1 of 4) reported when moving to the object with the focus or object navigation.

##### Guess Object Position Information when unavailable {#ObjectPresentationGuessPositionInfo}

If reporting of object position information is turned on, this option allows NVDA to guess object position information when it is otherwise unavailable for a particular control.

When on, NVDA will report position information for more controls such as menus and toolbars, however this information may be slightly inaccurate.

##### Report Object descriptions {#ObjectPresentationReportDescriptions}

Uncheck this checkbox if you don't wish to have the description reported along with objects (i.e. search suggestions, reporting of whole dialog window right after the dialog opens, etc.).

<!-- KC:setting -->

##### Progress bar output {#ObjectPresentationProgressBarOutput}

Key: NVDA+u

This option controls how NVDA reports progress bar updates to you.

It has the following options:

* Off: Progress bars will not be reported as they change.
* Speak: This option tells NVDA to speak the progress bar in percentages. Each time the progress bar changes, NVDA will speak the new value.
* Beep: This tells NVDA to beep each time the progress bar changes. The higher the beep, the closer the progress bar is to completion.
* Beep and speak: This option tells NVDA to both beep and speak when a progress bar updates.

##### Report background progress bars {#ObjectPresentationReportBackgroundProgressBars}

This is an option that, when checked, tells NVDA to keep reporting a progress bar, even if it is not physically in the foreground.
If you minimize or switch away from a window that contains a progress bar, NVDA will keep track of it, allowing you to do other things while NVDA tracks the progress bar.

<!-- KC:setting -->

##### Report dynamic content changes {#ObjectPresentationReportDynamicContent}

Key: NVDA+5

Toggles the announcement of new content in particular objects such as terminals and the history control in chat programs.

##### Play a sound when auto-suggestions appear {#ObjectPresentationSuggestionSounds}

Toggles announcement of appearance of auto-suggestions, and if enabled, NVDA will play a sound to indicate this.
Auto-suggestions are lists of suggested entries based on text entered into certain edit fields and documents.
For example, when you enter text into the search box in Start menu in Windows Vista and later, Windows displays a list of suggestions based on what you typed.
For some edit fields such as search fields in various Windows 10 apps, NVDA can notify you that a list of suggestions has appeared when you type text.
The auto-suggestions list will close once you move away from the edit field, and for some fields, NVDA can notify you of this when this happens.

#### Input Composition {#InputCompositionSettings}

The Input Composition category allows you to control how NVDA reports the input of Asian characters, such as with IME or Text Service input methods.
Note that due to the fact that input methods vary greatly by available features and by how they convey information, it will most likely be necessary to configure these options differently for each input method to get the most efficient typing experience.

##### Automatically report all available candidates {#InputCompositionReportAllCandidates}

This option, which is on by default,  allows you to choose whether or not all visible candidates should be reported automatically when a candidate list appears or its page is changed.
Having this option on for pictographic input methods such as Chinese New ChangJie or Boshiami is useful, as you can automatically hear all symbols and their numbers and you can choose one right away.
However, for phonetic input methods such as Chinese New Phonetic, it may be more useful to turn this option off, as all the symbols will sound the same and you will have to use the arrow keys to navigate the list items individually to gain more information  from the character descriptions for each candidate.

##### Announce Selected Candidate {#InputCompositionAnnounceSelectedCandidate}

This option, which is on by default, allows you to choose whether NVDA should announce the selected candidate when a candidate list appears or when the selection is changed.
For input methods where the selection can be changed with the arrow keys  (such as Chinese New Phonetic) this is necessary, but for some input methods it may be more efficient typing with this option turned off.
Note that even with this option off, the review cursor will still be placed on the selected candidate allowing you to use object navigation / review to manually read this or other candidates.

##### Always include short character descriptions for candidates {#InputCompositionCandidateIncludesShortCharacterDescription}

This option, which is on by default, allows you to choose whether or not NVDA should provide a short description for each character in a candidate, either when it's selected or when it's automatically read when the candidate list appears.
Note that for locales such as Chinese, the announcement of extra character descriptions for the selected candidate is not affected by this option.
This option may be useful for Korean and Japanese input methods.

##### Report changes to the reading string {#InputCompositionReadingStringChanges}

Some input methods such as Chinese New Phonetic and New ChangJie have a reading string (sometimes known as a precomposition string).
You can choose whether or not NVDA should announce new characters being typed into this reading string with this option.
This option is on by default.
Note some older input methods such as Chinese ChangJie may not use the reading string to hold precomposition characters, but instead use the composition string directly. Please see the next option for configuring reporting of the composition string.

##### Report changes to the composition string {#InputCompositionCompositionStringChanges}

After reading or precomposition data has been combined into a valid pictographic symbol, most input methods place this symbol into a composition string for temporary storage along with other combined symbols before they are finally inserted into the document.
This option allows you to choose whether or not NVDA should report new symbols as they appear  in the composition string.
This option is on by default.

#### Browse Mode (NVDA+control+b) {#BrowseModeSettings}

The Browse Mode category in the NVDA Settings dialog is used to configure NVDA's behaviour when you read and navigate complex documents such as web pages.
This category contains the following options:

##### Maximum Number of Characters on One Line {#BrowseModeSettingsMaxLength}

This field sets the maximum length of a line in browse mode (in characters).

##### Maximum Lines Per Page {#BrowseModeSettingsPageLines}

This field sets the amount of lines you will move by when pressing page up or page down while in browse mode.

<!-- KC:setting -->

##### Use screen layout {#BrowseModeSettingsScreenLayout}

Key: NVDA+v

This option allows you to specify whether content in browse mode should place content such as links and other fields on their own line, or if it should keep them in the flow of text as it is visually shown.
If the option is enabled then things will stay as they are visually shown, but if it is disabled then fields will be placed on their own line.

##### Enable browse mode on page load {#BrowseModeSettingsEnableOnPageLoad}

This checkbox toggles whether browse mode should be automatically enabled when loading a page.
When this option is disabled, browse mode can still be manually activated on pages or in documents where browse mode is supported.
See the [Browse Mode section](#BrowseMode) for a list of applications supported by browse mode.
Note that this option does not apply to situations where browse mode is always optional, e.g. in Microsoft Word.
This option is enabled by default.

##### Automatic Say All on page load {#BrowseModeSettingsAutoSayAll}

This checkbox toggles the automatic reading of a page after it loads in browse mode.
This option is enabled by default.

##### Include layout tables {#BrowseModeSettingsIncludeLayoutTables}

This option affects how NVDA handles tables used purely for layout purposes.
When on, NVDA will treat these as normal tables, reporting them based on [Document Formatting Settings](#DocumentFormattingSettings) and locating them with quick navigation commands.
When off, they will not be reported nor found with quick navigation.
However, the content of the tables will still be included as normal text.
This option is turned off by default.

To toggle inclusion of layout tables from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

##### Configuring reporting of fields such as links and headings {#BrowseModeLinksAndHeadings}

Please see the options in the [Document Formatting category](#DocumentFormattingSettings) of the [NVDA Settings](#NVDASettings) dialog to configure the fields that are reported when navigating, such as links, headings and tables.

##### Automatic focus mode for focus changes {#BrowseModeSettingsAutoPassThroughOnFocusChange}

This option allows focus mode to be invoked if focus changes.
For example, when on a web page, if you press tab and you land on a form, if this option is checked, focus mode will automatically be invoked.

##### Automatic focus mode for caret movement {#BrowseModeSettingsAutoPassThroughOnCaretMove}

This option, when checked, allows NVDA to enter and leave focus mode when using arrow keys.
For example, if arrowing down a web page and you land on an edit box, NVDA will automatically bring you into focus mode.
If you arrow out of the edit box, NVDA will put you back in browse mode.

##### Audio indication of Focus and Browse modes {#BrowseModeSettingsPassThroughAudioIndication}

If this option is enabled, NVDA will play special sounds when it switches between browse mode and focus mode, rather than speaking the change.

##### Trap non-command gestures from reaching the document {#BrowseModeSettingsTrapNonCommandGestures}

Enabled by default, this option allows you to choose if gestures (such as key presses) that  do not result in an NVDA command and are not considered to be a command key in general, should be trapped from going through to the document you are currently focused on. 
As an example, if enabled and the letter j was pressed, it would be trapped from reaching the document, even though it is not a quick navigation command nor is it likely to be a command in the application itself.
In this case NVDA will tell Windows to play a default sound whenever a key which gets trapped is pressed.

##### Automatically set system focus to focusable elements {#BrowseModeSettingsAutoFocusFocusableElements}

Key: NVDA+8

Disabled by default, this option allows you to choose if the system focus should automatically be set to elements that can take the system focus (links, form fields, etc.) when navigating content with the browse mode caret.
Leaving this option disabled will not automatically focus focusable elements when they are selected with the browse mode caret.
This might result in faster browsing experience and better responsiveness in browse mode.
The focus will yet be updated to the particular element when interacting with it (e.g. pressing a button, checking a check box).
Enabling this option may improve support for some websites at the cost of performance and stability.

#### Document Formatting (NVDA+control+d) {#DocumentFormattingSettings}

Most of the checkboxes in this category are for configuring what type of formatting you wish to have reported as you move the cursor around documents.
For example, if you check the report font name checkbox, each time you arrow onto text with a different font, the name of the font will be announced.

The document formatting options are organized into groups.
You can configure reporting of:

* Font
 * Font name
 * Font size
 * Font attributes
 * Superscripts and subscripts
 * Emphasis
 * Marked (Highlighted text)
 * Style
 * Colours
* Document information
 * Comments
 * Editor revisions
 * Spelling errors
* Pages and spacing
 * Page numbers
 * Line numbers
 * Line indentation reporting [(Off, Speech, Tones, Both Speech and Tones)](#lineIndentationOptions)
 * Paragraph indentation (e.g. hanging indent, first line indent)
 * Line spacing (single, double, etc.)
 * Alignment
* Table information
 * Tables
 * Row/column headers
 * Cell coordinates
 * Cell borders [(Off, Styles, Both Colours and Styles)
* Elements
 * Headings
 * Links
 * Graphics
 * Lists
 * Block quotes
 * Groupings
 * Landmarks
 * Articles
 * Frames
 * Clickable

To toggle these settings from anywhere, please assign custom gestures using the [Input Gestures dialog](#InputGestures).

##### Report formatting changes after the cursor {#DocumentFormattingDetectFormatAfterCursor}

If enabled, this setting tells NVDA to try and detect all the formatting changes on a line as it reports it, even if doing this may slow down NVDA's performance.

By default, NVDA will detect the formatting at the position of the System caret / Review Cursor, and in some instances may detect formatting on the rest of the line, only if it is not going to cause a performance decrease.

Enable this option while proof reading documents in applications such as WordPad, where formatting is important.

##### Line indentation reporting {#DocumentFormattingSettingsLineIndentation}

This option allows you to configure how indentation at the beginning of lines is reported.
The Report line indentation with combo box has four options.

* Off: NVDA will not treat indentation specially.
* Speech: If speech is selected, when the  amount of indentation changes, NVDA will say something like "twelve space" or "four tab."
* Tones: If Tones is selected, when the  amount of  indentation changes, tones indicate the amount of change in indent.
The tone will increase in pitch every space, and for a tab, it will increase in pitch the equivalent of 4 spaces.
* Both Speech and Tones: This option reads indentation using both of the above methods.

#### Windows 10 OCR Settings {#Win10OcrSettings}

The settings in this category allow you to configure [Windows 10 OCR](#Win10Ocr).
This category contains the following options:

##### Recognition language {#Win10OcrSettingsRecognitionLanguage}

This combo box allows you to choose the language to be used for text recognition.

#### Advanced Settings {#AdvancedSettings}

Warning! The settings in this category are for advanced users and may cause NVDA to not function correctly if configured in the wrong way.
Only make changes to these settings if you are sure you know what you are doing or if you have been specifically instructed to by an NVDA developer.

##### Making changes to advanced settings {#AdvancedSettingsMakingChanges}

In order to make changes to the advanced settings, the controls must be enabled by confirming, with the checkbox, that you understand the risks of modifying these settings

##### Restoring the default settings {#AdvancedSettingsRestoringDefaults}

The button restores the default values for the settings, even if the confirmation checkbox is not ticked.
After changing settings you may wish to revert to the default values.
This may also be the case if you are unsure if the settings have been changed.

##### Enable loading custom code from Developer Scratchpad Directory {#AdvancedSettingsEnableScratchpad}

When developing add-ons for NVDA, it is useful to be able to test code as you are writing it.
This option when enabled, allows NVDA to load custom appModules, globalPlugins, brailleDisplayDrivers and synthDrivers, from a special developer scratchpad directory in your NVDA user configuration directory.
Previously NVDA would load custom code directly from the user configuration directory, with no way of disabling this.
This option is off by default, ensuring that no untested code is ever run in NVDA with out the user's explicit knowledge.
If you wish to distribute custom code to others, you should package it as an NVDA add-on.

##### Open Developer Scratchpad Directory {#AdvancedSettingsOpenScratchpadDir}

This button opens the directory where you can place custom code while developing it.
This button is only enabled if NVDA is configured to enable loading custom code from the Developer Scratchpad Directory.

##### Enable selective registration for UI Automation events and property changes {#AdvancedSettingsSelectiveUIAEventRegistration}

This option changes how NVDA registers for events fired by the Microsoft UI Automation accessibility API.
When this option is disabled, NVDA registers for many UIA events that are processed and discarded within NVDA itself.
This has a major negative impact on performance, especially in applications like Microsoft Visual Studio.
Therefore, when this option is enabled, NVDA will limit event registration to the system focus for most events.
If you suffer from performance issues in one or more applications, We recommend you to try this functionality to see whether performance improves.

##### Use UI automation to access Microsoft Word document controls when available {#AdvancedSettingsUseUiaForWord}

When this option is enabled, NVDA will try to use the Microsoft UI Automation accessibility API in order to fetch information from Microsoft Word document controls.
This includes Microsoft Word itself, and also the Microsoft Outlook message viewer and composer.
 For the most recent versions of Microsoft Office 2016/365 running on windows 10, UI Automation support is complete enough to provide access to Microsoft Word documents almost equal to NVDA's existing Microsoft Word support, with the added advantage that responsiveness is majorly increased.
However, There may be some information which is either not exposed, or exposed incorrectly in some versions of Microsoft Office, which means this UI automation support cannot always be relied upon.
We still do not recommend that  the majority of users turn this on by default, though we do welcome users of Office 2016/365 to test this feature and provide feedback.

##### Use UI Automation to access the Windows Console when available {#AdvancedSettingsConsoleUIA}

When this option is enabled, NVDA will use a new, work in progress version of its support for Windows Console which takes advantage of [accessibility improvements made by Microsoft](https://devblogs.microsoft.com/commandline/whats-new-in-windows-console-in-windows-10-fall-creators-update/). This feature is highly experimental and is still incomplete, so its use is not yet recommended. However, once completed, it is anticipated that this new support will become the default, improving NVDA's performance and stability in Windows command consoles.

##### Speak passwords in UIA consoles {#AdvancedSettingsWinConsoleSpeakPasswords}

This setting controls whether characters are spoken by [speak typed characters](#KeyboardSettingsSpeakTypedCharacters) or [speak typed words](#KeyboardSettingsSpeakTypedWords) in situations where the screen does not update (such as password entry) in the Windows Console with UI automation support enabled. For security purposes, this setting should be left disabled. However, you may wish to enable it if you experience performance issues or instability with typed character and/or word reporting while using NVDA's new experimental console support.

##### Use the new typed character support in Windows Console when available {#AdvancedSettingsKeyboardSupportInLegacy}

This option enables an alternative method for detecting typed characters in Windows command consoles.
While it improves performance and prevents some console output from being spelled out, it may be incompatible with some terminal programs.
This feature is available and enabled by default on Windows 10 versions 1607 and later when UI Automation is unavailable or disabled.
Warning: with this option enabled, typed characters that do not appear onscreen, such as passwords, will not be suppressed.
In untrusted environments, you may temporarily disable [speak typed characters](#KeyboardSettingsSpeakTypedCharacters) and [speak typed words](#KeyboardSettingsSpeakTypedWords) when entering passwords.

##### Attempt to cancel speech for expired focus events {#CancelExpiredFocusSpeech}

This option enables behaviour which attempts to cancel speech for expired focus events.
In particular moving quickly through messages in Gmail with Chrome can cause NVDA to speak outdated information.
This functionality is experimental as of NVDA 2020.2.

##### Caret move timeout (in MS) {#AdvancedSettingsCaretMoveTimeout}

This option allows you to configure the number of milliseconds NVDA will wait for the caret (insertion point) to move in editable text controls.
If you find that NVDA seems to be incorrectly tracking the caret E.g. it seems to be always one character behind or is repeating lines, then you may wish to try increasing this value.

##### Debug logging categories {#AdvancedSettingsDebugLoggingCategories}

The checkboxes in this list allow you to enable specific categories of debug messages in NVDA's log.
Logging these messages can resort in decreased performance and large log files.
Only turn one of these on if specifically instructed to by an NVDA developer e.g. when debugging why a braille display driver is not functioning correctly.

### miscellaneous Settings {#MiscSettings}

Besides the [NVDA Settings](#NVDASettings) dialog, The Preferences sub-menu of the NVDA Menu contains several other items which are outlined below.

#### Speech dictionaries {#SpeechDictionaries}

The speech dictionaries menu (found in the Preferences menu) contains dialogs that allow you to manage the way NVDA pronounces particular words or phrases.
There are currently three different types of speech dictionaries.
They are:

* Default: rules in this dictionary affect all speech in NVDA.
* Voice: rules in this dictionary affect speech for the synthesizer voice currently being used.
* Temporary: rules in this dictionary affect all speech in NVDA, but only for the current session. These rules are temporary and will be lost if NVDA is restarted.

You need to assign custom gestures using the [Input Gestures dialog](#InputGestures) if you wish to open any of these dictionary dialogs from anywhere.

All dictionary dialogs contain a list of rules which will be used for processing the speech.
The dialog also contains Add, Edit and Remove buttons.

To add a new rule to the dictionary, press the Add button, and fill in the fields in the dialog box that appears and then press Ok.
You will then see your new rule in the list of rules.
However, to make sure your rule is actually saved, make sure to press Ok to exit the dictionary dialog completely once you have finished adding/editing rules.

The rules for NVDA's speech dictionaries allow you to change one string of characters into another.
For example, you could create a rule which causes NVDA to say the word "frog" instead of "bird" whenever the word "bird" is encountered.
In the Add rule dialog, the easiest way to do this is to type the word bird in the Pattern field, and the word frog in the Replacement field.
You may also want to type a description of the rule in the Comment field (something like: changes bird to frog).

NVDA's speech dictionaries however are much more powerful than simple word replacement.
The Add rule dialog also contains a checkbox to say whether or not you want the rule to be case sensitive (meaning that NVDA should care whether the characters are uppercase or lowercase.
NVDA ignores case by default).

Finally, a set of radio buttons allows you to tell NVDA whether your pattern should match anywhere, should only match if it is a complete word or should be treated as a "Regular expression".
Setting the pattern to match as a whole word means that the replacement will only be made if the pattern does not occur as part of a larger word.
This condition is met if the characters immediately before and after the word are anything other than a letter, a number, or an underscore, or if there are no characters at all.
Thus, using the earlier example of replacing the word "bird" with "frog", if you were to make this a whole word replacement, it would not match "birds" or "bluebird".

A regular expression is a pattern containing special symbols that allow you to match on more than one character at a time, or match on just numbers, or just letters, as a few examples.
Regular expressions are not covered in this user guide.
For an introductory tutorial, please refer to [https://docs.python.org/3.7/howto/regex.html].

#### Punctuation/symbol pronunciation {#SymbolPronunciation}

This dialog allows you to change the way punctuation and other symbols are pronounced, as well as the symbol level at which they are spoken.

The language for which symbol pronunciation is being edited will be shown in the dialog's title.
Note that this dialog respects the "Trust voice's language for processing symbols and characters" option found in the [Speech category](#SpeechSettings) of the [NVDA Settings](#NVDASettings) dialog; i.e. it uses the voice language rather than the NVDA global language setting when this option is enabled.

To change a symbol, first select it in the Symbols list.
You can filter the symbols by entering the symbol or a part of the symbol's replacement into the Filter by edit box.

* The Replacement field allows you to change the text that should be spoken in place of this symbol.
* Using the Level field, you can adjust the lowest symbol level at which this symbol should be spoken.
* The Send actual symbol to synthesizer field specifies when the symbol itself (in contrast to its replacement) should be sent to the synthesizer.
This is useful if the symbol causes the synthesizer to pause or change the inflection of the voice.
For example, a comma causes the synthesizer to pause.
There are three options:
 * never: Never send the actual symbol to the synthesizer.
 * always: Always send the actual symbol to the synthesizer.
 * only below symbols' level: Send the actual symbol only if the configured speech symbol level is lower than the level set for this symbol.
 For example, you might use this so that a symbol will have its replacement spoken at higher levels without pausing, while still being indicated with a pause at lower levels.

You can add new symbols by pressing the Add button.
In the dialog that appears, enter the symbol and press the OK button.
Then, change the fields for the new symbol as you would for other symbols.

You can remove a symbol you previously added by pressing the Remove button.

When you are finished, press the OK button to save your changes or the Cancel button to discard them.

#### Input Gestures {#InputGestures}

In this dialog, you can customize the input gestures (keys on the keyboard, buttons on a braille display, etc.) for NVDA commands.

Only commands that are applicable immediately before the dialog is opened are shown.
For example, if you want to customize commands related to browse mode, you should open the Input Gestures dialog while you are in browse mode.

The tree in this dialog lists all of the applicable NVDA commands grouped by category.
You can filter them by entering one or more words from the command's name into the Filter by edit box in any order.
Any gestures associated with a command are listed beneath the command.

To add an input gesture to a command, select the command and press the Add button.
Then, perform the input gesture you wish to associate; e.g. press a key on the keyboard or a button on a braille display.
Often, a gesture can be interpreted in more than one way.
For example, if you pressed a key on the keyboard, you may wish it to be specific to the current keyboard layout (e.g. desktop or laptop) or you may wish it to apply for all layouts.
In this case, a menu will appear allowing you to select the desired option.

To remove a gesture from a command, select the gesture and press the Remove button.

The Emulated system keyboard keys category contains NVDA commands that emulate keys on the system keyboard.
These emulated system keyboard keys can be used to control a system keyboard right from your braille display.
To add an emulated input gesture, select the Emulated system keyboard keys category and press the Add button.
Then, press the key on the keyboard you wish to emulate.
After that, the key will be available from the Emulated system keyboard keys category and you will be able to assign an input gesture to it as described above.

Note:

 * Emulated keys must have gestures assigned in order to persist when saving / closing the dialog.
 * An input gesture with modifier keys may not be able to be mapped to an emulated gesture without modifier
 keys. For instance, setting the emulated input 'a' and configuring an input gesture of 'ctrl+m', may result
 in the application receiving 'ctrl+a'.

When you are finished making changes, press the OK button to save them or the Cancel button to discard them.

### Saving and Reloading the configuration {#SavingAndReloading}

By default NVDA will automatically save your settings on exit.
Note, however, that this option can be changed under the general options in the preferences menu.
To save the settings manually at any time, choose the Save configuration item in the NVDA menu.

If you ever make a mistake with your settings and need to revert back to the saved settings, choose the "revert to saved configuration" item in the NVDA menu.
You can also reset your settings to their original factory defaults by choosing Reset Configuration To Factory Defaults, which is also found in the NVDA menu.

The following NVDA key commands are also useful:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Save configuration |NVDA+control+c |NVDA+control+c |Saves your current configuration so that it is not lost when you exit NVDA|
|Revert  configuration |NVDA+control+r |NVDA+control+r |Pressing once resets your configuration to when you last saved it. Pressing three times will reset it back to factory defaults.|

<!-- KC:endInclude -->

### Configuration Profiles {#ConfigurationProfiles}

Sometimes, you may wish to have different settings for different situations.
For example, you may wish to have reporting of indentation enabled while you are editing or reporting of font attributes enabled while you are proofreading.
NVDA allows you to do this using configuration profiles.

A configuration profile contains only those settings which are changed while the profile is being edited.
Most settings can be changed in configuration profiles except for those in the General category of the [NVDA Settings](#NVDASettings) dialog, which apply to the entirety of NVDA.

Configuration profiles can be manually activated either from a dialog or using custom added gestures.
They can also be activated automatically due to triggers such as switching to a particular application.

#### Basic Management {#ProfilesBasicManagement}

You manage configuration profiles by selecting "Configuration profiles" in the NVDA menu.
You can also do this using a key command:
<!-- KC:beginInclude -->

* NVDA+control+p: Show the Configuration Profiles dialog.

<!-- KC:endInclude -->

The first control in this dialog is the profile list from which you can select one of the available profiles.
When you open the dialog, the profile you are currently editing is selected.
Additional information is also shown for active profiles, indicating whether they are manually activated, triggered and/or being edited.

To rename or delete a profile, press the Rename or Delete buttons, respectively.

Press the Close button to close the dialog.

#### Creating a Profile {#ProfilesCreating}

To create a profile, press the New button.

In the New Profile dialog, you can enter a name for the profile.
You can also select how this profile should be used.
If you only want to use this profile manually, select Manual activation, which is the default.
Otherwise, select a trigger which should automatically activate this profile.
For convenience, if you haven't entered a name for the profile, selecting a trigger will fill in the name accordingly.
See [below](#ConfigProfileTriggers) for more information about triggers.

Pressing OK will create the profile and close the Configuration Profiles dialog so you can edit it.

#### Manual Activation {#ConfigProfileManual}

You can manually activate a profile by selecting a profile and pressing the Manual activate button.
Once activated, other profiles can still be activated due to triggers, but any settings in the manually activated profile will override them.
For example, if a profile is triggered for the current application and reporting of links is enabled in that profile but disabled it in the manually activated profile, links will not be reported.
However, if you have changed the voice in the triggered profile but have never changed it in the manually activated profile, the voice from the triggered profile will be used.
Any settings you change will be saved in the manually activated profile.
To deactivate a manually activated profile, select it in the Configuration Profiles dialog and press the Manual deactivate button.

#### Triggers {#ConfigProfileTriggers}

Pressing the Triggers button in the Configuration Profiles dialog allows you to change the profiles which should be automatically activated for various triggers.

The Triggers list shows the available triggers, which are as follows:

* Current application: Triggered when you switch to the current application.
* Say all: Triggered while reading with the say all command.

To change the profile which should be automatically activated for a trigger, select the trigger and then select the desired profile from the Profile list.
You can select "(normal configuration)" if you don't want a profile to be used.

Press the Close button to return to the Configuration Profiles dialog.

#### Editing a Profile {#ConfigProfileEditing}

If you have manually activated a profile, any settings you change will be saved to that profile.
Otherwise, any settings you change will be saved to the most recently triggered profile.
For example, if you have associated a profile with the Notepad application and you switch to Notepad, any changed settings will be saved to that profile.
Finally, if there is neither a manually activated nor a triggered profile, any settings you change will be saved to your normal configuration.

To edit the profile associated with say all, you must [manually activate](#ConfigProfileManual) that profile.

#### Temporarily Disabling Triggers {#ConfigProfileDisablingTriggers}

Sometimes, it is useful to temporarily disable all triggers.
For example, you might wish to edit a manually activated profile or your normal configuration without triggered profiles interfering.
You can do this by checking the Temporarily disable all triggers checkbox in the Configuration Profiles dialog.

To toggle disabling triggers from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

#### Activating a profile using input gestures {#ConfigProfileGestures}

For every profile you add, you are able to assign one or more input gestures to activate it.
By default, configuration profiles do not have input gestures assigned.
You can add gestures to activate a profile using the [Input Gestures dialog](#InputGestures).
Every profile has its own entry under the configuration profiles category.
When you rename a profile, any gesture you added previously will still be available.
Removing a profile will automatically delete the gestures associated with it.

### Location of Configuration files {#LocationOfConfigurationFiles}

Portable versions of NVDA store all settings and add-ons in a directory called userConfig, found in the NVDA directory.

Installed versions of NVDA store all settings and add-ons in a special NVDA directory located in your Windows user profile.
This means that each user on the system can have their own NVDA settings.
To open your settings directory from anywhere you can use [Input Gestures dialog](#InputGestures) to add a custom gesture.
In addition for an installed version of NVDA, on the start menu you can go to programs -> NVDA -> explore user configuration directory.

Settings for NVDA when running during sign-in or on UAC screens are stored in the systemConfig directory in NVDA's installation directory.
Usually, this configuration should not be touched.
To change NVDA's configuration during sign-in or on UAC screens, configure NVDA as you wish while signed into Windows, save the configuration, and then press the "use currently saved settings during sign-in and on secure screens" button in the General category of the [NVDA Settings](#NVDASettings) dialog.

## Extra Tools {#ExtraTools}
### Log Viewer {#LogViewer}

The log viewer, found under Tools in the NVDA menu, allows you to view all the logging output that has occurred up until now from when you last started NVDA.
Using NVDA+F1 will open the log viewer and display developer information about the current navigator object.

Apart from reading the content, you can also Save a copy of the log file, or refresh the viewer so that it shows the most recent output since the Log viewer was opened.
These actions are available under the viewer's Log menu.

### Speech Viewer {#SpeechViewer}

For sighted software developers or people demoing NVDA to sighted audiences, a floating window is available that allows you to view all the text that NVDA is currently speaking.

To enable the speech viewer, check the "Speech Viewer" menu item under Tools in the NVDA menu.
Uncheck the menu item to disable it.

The speech viewer window contains a check box labelled "Show speech viewer on startup".
If this is checked, the speech viewer will open when NVDA is started.
The speech viewer window will always attempt to re-open with the same dimensions and location as when it was closed.

While the speech viewer is enabled, it constantly updates to show you the most current text being spoken.
However, if you click or focus inside the viewer, NVDA will temporarily stop updating the text, so that you are able to easily select or copy the existing content.

To toggle the speech viewer from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

### Braille Viewer {#BrailleViewer}

For sighted software developers or people demoing NVDA to sighted audiences, a floating window is available that allows you to view braille output, and the text equivalent for each braille character.
The braille viewer can be used at the same time as a physical braille display, it will match the number of cells on the physical device.
While the braille viewer is enabled, it constantly updates to show you the braille that would be displayed on a physical braille display.

To enable the braille viewer, check the "Braille Viewer" menu item under Tools in the NVDA menu.
Uncheck the menu item to disable it.

Physical braille displays typically have buttons to scroll forwards or backwards, to enable scrolling with the braille viewer tool use the [Input Gestures dialog](#InputGestures) to assign keyboard shortcuts which "Scrolls the braille display back" and "Scrolls the braille display forward"

The braille viewer window contains a check box labelled "Show braille viewer on startup".
If this is checked, the braille viewer will open when NVDA is started.
The braille viewer window will always attempt to re-open with the same dimensions and location as when it was closed.

### Python Console {#PythonConsole}

The NVDA Python console, found under Tools in the NVDA menu, is a development tool which is useful for debugging, general inspection of NVDA internals or inspection of the accessibility hierarchy of an application.
For more information, please see the [NVDA Developer Guide](https://www.nvaccess.org/files/nvda/documentation/developerGuide.html).

### Add-ons Manager {#AddonsManager}

The Add-ons Manager, accessed by selecting Manage add-ons under Tools in the NVDA menu, allows you to install, uninstall, enable and disable add-on packages for NVDA.
These packages are provided by the community and contain custom code that may add or change features in NVDA or even provide support for extra Braille displays or speech synthesizers.

The Add-ons Manager contains a list that displays all the add-ons currently installed in your NVDA user configuration. 
Package name, status, version and author are shown for each add-on, though further information such as a description and URL can be viewed by selecting the add-on and pressing the About add-on button.
If there is help available for the selected add-on, you can access it by pressing the Add-on help button.

To browse and download available add-ons online, press the Get add-ons button.
This button opens the [NVDA Add-ons page](https://addons.nvda-project.org/).
If NVDA is installed and running on your system, you can open the add-on directly from the browser to begin the installation process as described below.
Otherwise, save the add-on package and follow the instructions below.

To install an Add-on you previously obtained, press the Install button.
This will allow you to browse for an add-on package (.nvda-addon file) somewhere on your computer or on a network.
Once you press Open, the installation process will begin.

When an add-on is being installed, NVDA will first ask you to confirm that you really wish to install the add-on.
As the functionality of add-ons is unrestricted inside NVDA, which in theory could include accessing your personal data or even the entire system if NVDA is an installed copy, it is very important to only install add-ons from sources you trust.
Once the add-on is installed, NVDA must be restarted for the add-on to start running. 
Until you do, a status of "install" will show for that add-on in the list.

To remove an add-on, select the add-on from the list and press the Remove button.
NVDA will ask if you really wish to do this.
As with installing, NVDA must be restarted for the add-on to be fully  removed.
Until you do, a status of "remove" will be shown for that add-on in the list.

To disable an add-on, press the "disable" button.
To enable a previously disabled add-on, press the "enable" button.
You can disable an add-on if the add-on status indicates it is  "enabled", or enable it if the add-on is "disabled".
For each press of the enable/disable button, add-on status changes to indicate what will happen when NVDA restarts.
If the add-on was previously "disabled", a status will show "enabled after restart".
If the add-on was previously "enabled", a status will show "disabled after restart".
Just like when you install or remove add-ons, you need to restart NVDA in order for changes to take effect.

The manager also has a Close button to close the dialog.
If you have installed, removed or changed the status of an add-on, NVDA will first ask you if you wish to restart so that your changes can take effect.

Some older add-ons may no longer be compatible with the version of NVDA that you have.
When using an older version of NVDA, some new add-ons may not be compatible either.
Attempting to install an incompatible add-on will result in an error explaining why the add-on is considered incompatible.
To inspect these incompatible add-ons, you can use the "view incompatible add-ons" button to launch the incompatible add-ons manager.

To access the Add-ons Manager from anywhere, please assign a custom gesture using the [Input Gestures dialog](#InputGestures).

#### Incompatible Add-ons Manager {#incompatibleAddonsManager}

The Incompatible Add-ons Manager, which can be accessed via the "view incompatible add-ons" button in the Add-on manager, allows you to inspect any incompatible add-ons, and the reason they are considered incompatible.
Add-ons are considered incompatible when they have not been updated to work with significant changes to NVDA, or when they rely on a feature not available in the version of NVDA you are using.
The Incompatible add-ons manager has a short message to explain its purpose as well as the version of NVDA.
The incompatible add-ons are presented in a list with the following columns:

1. Package, the name of the add-on
1. Version, the version of the add-on
1. Incompatible reason, an explanation of why the add-on is considered incompatible

The Incompatible add-ons manager also has an "About add-on..." button.
This dialog will provide you with the full details of the add-on, which is helpful when contacting the add-on author.

### Create portable copy {#CreatePortableCopy}

This will open a dialog which allows you to create a portable copy of NVDA out of the installed version.
Either way, when running a portable copy of NVDA, in the extra tool sub menu the menu item will be called "install NVDA on this PC" instead of "create portable copy).

The dialog to create a portable copy of NVDA or to install NVDA on this PC will prompt you to choose a folder path in which NVDA should create the portable copy or in which NVDA should be installed.

In this dialog you can enable or disable the following:

* Copy current user configuration (this includes the files in %appdata%\roaming\NVDA or in the user configuration of your portable copy and also includes add-ons and other modules)
* Start the new portable copy after creation or start NVDA after installation (starts NVDA automatically after the portable copy creation or the installation)

### Run COM registration fixing tool... {#RunCOMRegistrationFixingTool}

Installing and uninstalling programs on a computer can, in certain cases, cause COM DLL files to get unregistered.
As COM Interfaces such as IAccessible depend on correct COM DLL registrations, issues can appear in case the correct registration is missing.

This can happen i.e. after installing and uninstalling Adobe Reader, Math Player and other programs.

The missing registration can cause issues in browsers, desktop apps, task bar and other interfaces.

Specifically, following issues can be solved by running this tool:

* NVDA reports "unknown" when navigating in browsers such as Firefox, Thunderbird etc.
* NVDA fails to switch between focus mode and browse mode
* NVDA is very slow when navigating in browsers while using browse mode
* And possibly other issues.

### Reload plugins {#ReloadPlugins}

This item, once activated, reloads app modules and global plugins without restarting NVDA, which can be useful for developers.

## Supported Speech Synthesizers {#SupportedSpeechSynths}

This section contains information about the speech synthesizers supported by NVDA.
For an even more extensive list of  free and commercial synthesizers that you can purchase and download for use with NVDA, please see the [extra voices page](https://github.com/nvaccess/nvda/wiki/ExtraVoices).

### eSpeak NG {#eSpeakNG}

The [eSpeak NG](https://github.com/espeak-ng/espeak-ng) synthesizer is built directly into NVDA and does not require any other special drivers or components to be installed.
On Windows 7, 8 and 8.1, NVDA uses eSpeak NG by default ([Windows OneCore](#OneCore) is used in Windows 10 by default).
As this synthesizer is built into NVDA, this is a great choice for when running NVDA off a USB thumb drive on other systems.

Each voice that comes with eSpeak NG speaks a different language.
There are over 43 different languages supported by eSpeak NG.

There are also many variants which can be chosen to alter the sound of the voice.

### Microsoft Speech API version 4 (SAPI 4) {#SAPI4}

SAPI 4 is an older Microsoft standard for software speech synthesizers.
NVDA still supports this for users who already have SAPI 4 synthesizers installed.
However, Microsoft no longer support this and needed components are no longer available from Microsoft.

When using this synthesizer with NVDA, the available voices (accessed from the [Speech category](#SpeechSettings) of the [NVDA Settings](#NVDASettings) dialog or by the [Synth Settings Ring](#SynthSettingsRing)) will contain all the voices from all the installed SAPI 4 engines found on your system.

### Microsoft Speech API version 5 (SAPI 5) {#SAPI5}

SAPI 5 is a Microsoft standard for software speech synthesizers.
Many speech synthesizers that comply with this standard may be purchased or downloaded for free from various companies and websites, though your system will probably already come with at least one SAPI 5 voice preinstalled.
When using this synthesizer with NVDA, the available voices (accessed from the [Speech category](#SpeechSettings) of the [NVDA Settings](#NVDASettings) dialog or by the [Synth Settings Ring](#SynthSettingsRing)) will contain all the voices from all the installed SAPI 5 engines found on your system.

### Microsoft Speech Platform {#MicrosoftSpeechPlatform}

The Microsoft Speech Platform provides voices for many languages which are normally used in the development of server-based speech applications.
These voices can also be used with NVDA.

To use these voices, you will need to install two components:

* Microsoft Speech Platform - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * This page includes many files for both speech recognition and text-to-speech.
 Choose the files containing the TTS data for the desired languages/voices.
 For example, the file MSSpeech_TTS_en-US_ZiraPro.msi is a U.S. English voice.

### Windows OneCore Voices {#OneCore}

Windows 10 includes new voices known as "OneCore" or "mobile" voices.
Voices are provided for many languages, and they are more responsive than the Microsoft voices available using Microsoft Speech API version 5.
On Windows 10, NVDA uses Windows OneCore voices by default ([eSpeak NG](#eSpeakNG) is used in other releases).

Please see this Microsoft article for a list of available voices and instructions to install them: https://support.microsoft.com/en-us/help/22797/windows-10-narrator-tts-voices

## Supported Braille Displays {#SupportedBrailleDisplays}

This section contains information about the Braille displays supported by NVDA.

### Displays supporting automatic detection in the background {#AutomaticDetection}

NVDA has the ability to detect many braille displays in the background automatically, either via USB or bluetooth.
This behaviour is achieved by selecting the Automatic option as the preferred braille display from NVDA's [Braille Settings dialog](#BrailleSettings).
This option is selected by default.

The following displays support this automatic detection functionality.

* Handy Tech displays
* Baum/Humanware/APH/Orbit braille displays
* HumanWare Brailliant BI/B series
* HumanWare BrailleNote
* SuperBraille
* Optelec ALVA 6 series
* HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille Series
* Eurobraille Esys/Esytime/Iris displays
* Nattiq nBraille displays

### Freedom Scientific Focus/PAC Mate Series {#FreedomScientificFocus}

All Focus and PAC Mate displays from [Freedom Scientific](https://www.freedomscientific.com/) are supported when connected via USB or bluetooth.
You will need the Freedom Scientific braille display drivers installed on your system.
If you do not have them already, you can obtain them from https://support.freedomscientific.com/Downloads/Focus/FocusBlueBrailleDisplayDriver.
Although this page only mentions the Focus Blue display, the drivers support all Freedom Scientific Focus and Pacmate displays.

By default, NVDA can automatically detect and connect to these displays either via USB or bluetooth.
However, when configuring the display, you can explicitly select "USB" or "Bluetooth" ports to restrict the connection type to be used.
This might be useful if you want to connect the focus display to NVDA using bluetooth, but still be able to charge it using USB power from your computer.
NVDA's automatic braille display detection will also recognize the display on USB or Bluetooth.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |topRouting1 (first cell on display)|
|Scroll braille display forward |topRouting20/40/80 (last cell on display)|
|Scroll braille display back |leftAdvanceBar|
|Scroll braille display forward |rightAdvanceBar|
|Toggle braille tethered to |leftGDFButton+rightGDFButton|
|Toggle left wiz wheel action |leftWizWheelPress|
|Move back using left wiz wheel action |leftWizWheelUp|
|Move forward using left wiz wheel action |leftWizWheelDown|
|Toggle right wiz wheel action |rightWizWheelPress|
|Move back using right wiz wheel action |rightWizWheelUp|
|Move forward using right wiz wheel action |rightWizWheelDown|
|Route to braille cell |routing|
|shift+tab key |brailleSpaceBar+dot1+dot2|
|tab key |brailleSpaceBar+dot4+dot5|
|upArrow key |brailleSpaceBar+dot1|
|downArrow key |brailleSpaceBar+dot4|
|control+leftArrow key |brailleSpaceBar+dot2|
|control+rightArrow key |brailleSpaceBar+dot5|
|leftArrow |brailleSpaceBar+dot3|
|rightArrow key |brailleSpaceBar+dot6|
|home key |brailleSpaceBar+dot1+dot3|
|end key |brailleSpaceBar+dot4+dot6|
|control+home key |brailleSpaceBar+dot1+dot2+dot3|
|control+end key |brailleSpaceBar+dot4+dot5+dot6|
|alt key |brailleSpaceBar+dot1+dot3+dot4|
|alt+tab key |brailleSpaceBar+dot2+dot3+dot4+dot5|
|alt+shift+tab key |brailleSpaceBar+dot1+dot2+dot5+dot6|
|windows+tab key |brailleSpaceBar+dot2+dot3+dot4|
|escape key |brailleSpaceBar+dot1+dot5|
|windows key |brailleSpaceBar+dot2+dot4+dot5+dot6|
|space key |brailleSpaceBar|
|windows+d key (minimize all applications) |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|Report Current Line |brailleSpaceBar+dot1+dot4|
|NVDA menu |brailleSpaceBar+dot1+dot3+dot4+dot5|

For newer Focus models that contain rocker bar keys (focus 40, focus 80 and focus blue):

| Name |Key|
|---|---|
|Move braille display to previous line |leftRockerBarUp, rightRockerBarUp|
|Move braille display to next line |leftRockerBarDown, rightRockerBarDown|

For Focus 80 only:

| Name |Key|
|---|---|
|Scroll braille display back |leftBumperBarUp, rightBumperBarUp|
|Scroll braille display forward |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA 6 series/protocol converter {#OptelecALVA}

Both the ALVA BC640 and BC680 displays from [Optelec](https://www.optelec.com/) are supported when connected via USB or bluetooth.
Alternatively, you can connect an older Optelec display, such as a Braille Voyager, using a protocol converter supplied by Optelec.
You do not need any specific drivers to be installed to use these displays.
Just plug in the display and configure NVDA to use it.

Note: NVDA might be unable to use an ALVA BC6 display over Bluetooth when it is paired using the ALVA Bluetooth utility.
When you have paired your device using this utility and NVDA is unable to detect your device, we recommend you to pair your ALVA display the regular way using the Windows Bluetooth settings.

Note: while some of these displays do have a braille keyboard, they handle translation from braille to text themselves by default.
This means that NVDA's braille input system is not in use in the default situation (i.e. the input braille table setting has no effect).
For ALVA displays with recent firmware, it is possible to disable this HID keyboard simulation using an input gesture.

Following are key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |t1, etouch1|
|Move braille display to previous line |t2|
|Move to current focus |t3|
|Move braille display to next line |t4|
|Scroll braille display forward |t5, etouch3|
|Route to braille cell |routing|
|Report text formatting under braille cell |secondary routing|
|Toggle HID keyboard simulation |t1+spEnter|
|Move to top line in review |t1+t2|
|Move to bottom line in review |t4+t5|
|Toggle braille tethered to |t1+t3|
|Report title |etouch2|
|Report status bar |etouch4|
|shift+tab key |sp1|
|alt key |sp2, alt|
|escape key |sp3|
|tab key |sp4|
|upArrow key |spUp|
|downArrow key |spDown|
|leftArrow key |spLeft|
|rightArrow key |spRight|
|enter key |spEnter, enter|
|Report date/time |sp2+sp3|
|NVDA Menu |sp1+sp3|
|windows+d key (minimize all applications) |sp1+sp4|
|windows+b key (focus system tray) |sp3+sp4|
|windows key |sp1+sp2, windows|
|alt+tab key |sp2+sp4|
|control+home key |t3+spUp|
|control+end key |t3+spDown|
|home key |t3+spLeft|
|end key |t3+spRight|
|control key |control|

<!-- KC:endInclude -->

### Handy Tech Displays {#HandyTech}

NVDA supports most displays from [Handy Tech](https://www.handytech.de/) when connected via USB, serial port or bluetooth.
For older USB displays, you will need to install the USB drivers from Handy Tech on your system.

The following displays are not supported out of the box, but can be used via [Handy Tech's universal driver](https://handytech.de/en/service/downloads-and-manuals/handy-tech-software/braille-display-drivers) and NVDA add-on:

* Braillino
* Bookworm
* Modular displays with firmware version 1.13 or lower. Please note that the firmware of this displays can be updated.

Following are the key assignments for Handy Tech displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left, up, b3|
|Scroll braille display forward |right, down, b6|
|Move braille display to previous line |b4|
|Move braille display to next line |b5|
|Route to braille cell |routing|
|shift+tab key |esc, left triple action key up+down|
|alt key |b2+b4+b5|
|escape key |b4+b6|
|tab key |enter, right triple action key up+down|
|enter key |esc+enter, left+right triple action key up+down, joystickAction|
|upArrow key |joystickUp|
|downArrow key |joystickDown|
|leftArrow key |joystickLeft|
|rightArrow key |joystickRight|
|NVDA Menu |b2+b4+b5+b6|
|Toggle braille tethered to |b2|
|Toggle the braille cursor |b1|
|Toggle focus context presentation |b7|
|Toggle braille input |space+b1+b3+b4 (space+capital B)|

<!-- KC:endInclude -->

### MDV Lilli {#MDVLilli}

The Lilli braille display available from [MDV](https://www.mdvbologna.it/) is supported.
You do not need any specific drivers to be installed to use this display.
Just plug in the display and configure NVDA to use it.

This display does not support NVDA's automatic background braille display detection functionality.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display backward |LF|
|Scroll braille display forward |RG|
|Move braille display to previous line |UP|
|Move braille display to next line |DN|
|Route to braille cell |route|
|shift+tab key |SLF|
|tab key |SRG|
|alt+tab key |SDN|
|alt+shift+tab key |SUP|

<!-- KC:endInclude -->

### Baum/Humanware/APH/Orbit Braille Displays {#Baum}

Several [Baum](https://www.visiobraille.de/index.php?article_id=1&clang=2), [HumanWare](https://www.humanware.com/), [APH](https://www.aph.org/) and [Orbit](https://www.orbitresearch.com/) displays are supported when connected via USB, bluetooth or serial.
These include:

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!, SuperVario2, Vario 340
* HumanWare: Brailliant, BrailleConnect, Brailliant2
* APH: Refreshabraille
* Orbit: Orbit Reader 20

Some other displays manufactured by Baum may also work, though this has not been tested.

If connecting via USB to displays which do not use HID, you must first install the USB drivers provided by the manufacturer.
The VarioUltra and Pronto! use HID.
The Refreshabraille and Orbit Reader 20 can use HID if configured appropriately.

The USB serial mode of the Orbit Reader 20 is currently only supported in Windows 10.
USB HID should generally be used instead.

Following are the key assignments for these displays with NVDA.
Please see your display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |d2|
|Scroll braille display forward |d5|
|Move braille display to previous line |d1|
|Move braille display to next line |d3|
|Route to braille cell |routing|

For displays which have a joystick:

| Name |Key|
|---|---|
|upArrow key |up|
|downArrow key |down|
|leftArrow key |left|
|rightArrow key |right|
|enter key |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#HedoProfiLine}

The hedo ProfiLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

This display does not yet support NVDA's automatic background braille display detection functionality.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#HedoMobilLine}

The hedo MobilLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
You must first install the USB drivers provided by the manufacturer.

This display does not yet support NVDA's automatic background braille display detection functionality.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series / BrailleNote Touch {#HumanWareBrailliant}

The Brailliant BI and B series of displays  from [HumanWare](https://www.humanware.com/), including the BI 14, BI 32, BI 40 and B 80, are supported when connected via USB or bluetooth.
If connecting via USB with the protocol set to HumanWare, you must first install the USB drivers provided by the manufacturer.
USB drivers are not required if the protocol is set to OpenBraille.

The following extra devices are also supported (and do not require any special drivers to be installed):

* APH Mantis Q40
* APH Chameleon 20
* Humanware BrailleOne
* NLS eReader

Following are the key assignments for  the Brailliant BI/B and BrailleNote touch displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.

#### Key assignments for All models {#toc257}

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |down|
|Route to braille cell |routing|
|Toggle braille tethered to |up+down|
|upArrow key |space+dot1|
|downArrow key |space+dot4|
|leftArrow key |space+dot3|
|rightArrow key |space+dot6|
|shift+tab key |space+dot1+dot3|
|tab key |space+dot4+dot6|
|alt key |space+dot1+dot3+dot4 (space+m)|
|escape key |space+dot1+dot5 (space+e)|
|enter key |dot8|
|windows key |space+dot3+dot4|
|alt+tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|NVDA Menu |space+dot1+dot3+dot4+dot5 (space+n)|
|windows+d key (minimize all applications) |space+dot1+dot4+dot5 (space+d)|
|Say all |space+dot1+dot2+dot3+dot4+dot5+dot6|

<!-- KC:endInclude -->

#### Key assignments for Brailliant BI 32, BI 40 and B 80 {#toc258}

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|NVDA Menu |c1+c3+c4+c5 (command n)|
|windows+d key (minimize all applications) |c1+c4+c5 (command d)|
|Say all |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

#### Key assignments for Brailliant BI 14 {#toc259}

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|up arrow key |joystick up|
|down arrow key |joystick down|
|left arrow key |joystick left|
|right arrow key |joystick right|
|enter key |joystick action|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille Series {#Hims}

NVDA supports Braille Sense, Braille EDGE, Smart Beetle and Sync Braille displays from [Hims](https://www.hims-inc.com/) when connected via USB or bluetooth. 
If connecting via USB, you will need to install the USB drivers from HIMS on your system.
You can download these from here: http://www.himsintl.com/upload/HIMS_USB_Driver_v25.zip

Following are the key assignments for these displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Route to braille cell |routing|
|Scroll braille display back |leftSideScrollUp, rightSideScrollUp, leftSideScroll|
|Scroll braille display forward |leftSideScrollDown, rightSideScrollDown, rightSideScroll|
|Move braille display to previous line |leftSideScrollUp+rightSideScrollUp|
|Move braille display to next line |leftSideScrollDown+rightSideScrollDown|
|Move to previous line in review |rightSideUpArrow|
|Move to next line in review |rightSideDownArrow|
|Move to previous character in review |rightSideLeftArrow|
|Move to next character in review |rightSideRightArrow|
|Move to current focus |leftSideScrollUp+leftSideScrollDown, rightSideScrollUp+rightSideScrollDown, leftSideScroll+rightSideScroll|
|control key |smartbeetle:f1, brailleedge:f3|
|windows key |f7, smartbeetle:f2|
|alt key |dot1+dot3+dot4+space, f2, smartbeetle:f3, brailleedge:f4|
|shift key |f5|
|insert key |dot2+dot4+space, f6|
|applications key |dot1+dot2+dot3+dot4+space, f8|
|Caps Lock key |dot1+dot3+dot6+space|
|tab key |dot4+dot5+space, f3, brailleedge:f2|
|shift+alt+tab key |f2+f3+f1|
|alt+tab key |f2+f3|
|shift+tab key |dot1+dot2+space|
|end key |dot4+dot6+space|
|control+end key |dot4+dot5+dot6+space|
|home key |dot1+dot3+space, smartbeetle:f4|
|control+home key |dot1+dot2+dot3+space|
|alt+f4 key |dot1+dot3+dot5+dot6+space|
|leftArrow key |dot3+space, leftSideLeftArrow|
|control+shift+leftArrow key |dot2+dot8+space+f1|
|control+leftArrow key |dot2+space|
|shift+alt+leftArrow key |dot2+dot7+f1|
|alt+leftArrow key |dot2+dot7|
|rightArrow key |dot6+space, leftSideRightArrow|
|control+shift+rightArrow key |dot5+dot8+space+f1|
|control+rightArrow key |dot5+space|
|shift+alt+rightArrow key |dot5+dot7+f1|
|alt+rightArrow key |dot5+dot7|
|pageUp key |dot1+dot2+dot6+space|
|control+pageUp key |dot1+dot2+dot6+dot8+space|
|upArrow key |dot1+space, leftSideUpArrow|
|control+shift+upArrow key |dot2+dot3+dot8+space+f1|
|control+upArrow key |dot2+dot3+space|
|shift+alt+upArrow key |dot2+dot3+dot7+f1|
|alt+upArrow key |dot2+dot3+dot7|
|shift+upArrow key |leftSideScrollDown+space|
|pageDown key |dot3+dot4+dot5+space|
|control+pageDown key |dot3+dot4+dot5+dot8+space|
|downArrow key |dot4+space, leftSideDownArrow|
|control+shift+downArrow key |dot5+dot6+dot8+space+f1|
|control+downArrow key |dot5+dot6+space|
|shift+alt+downArrow key |dot5+dot6+dot7+f1|
|alt+downArrow key |dot5+dot6+dot7|
|shift+downArrow key |space+rightSideScrollDown|
|escape key |dot1+dot5+space, f4, brailleedge:f1|
|delete key |dot1+dot3+dot5+space, dot1+dot4+dot5+space|
|f1 key |dot1+dot2+dot5+space|
|f3 key |dot1+dot2+dot4+dot8|
|f4 key |dot7+f3|
|windows+b key |dot1+dot2+f1|
|windows+d key |dot1+dot4+dot5+f1|
|control+insert key |smartbeetle:f1+rightSideScroll|
|alt+insert key |smartbeetle:f3+rightSideScroll|

<!-- KC:endInclude -->

### Seika Braille Displays {#Seika}

The Seika Version 3, 4 and 5 (40 cells) and Seika80 (80 cells) braille displays from [Nippon Telesoft](https://www.nippontelesoft.com/) are supported.
You can find more information about the displays and the required drivers at https://en.seika-braille.com/down/index.html
You must first install the USB drivers provided by the manufacturer.

These displays do not yet support NVDA's automatic background braille display detection functionality.

Following are the key assignments for this display with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |b3|
|Move braille display to next line |b4|
|Toggle braille tethered to |b5|
|Say all |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|NVDA Menu |left+right|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Newer Models {#Papenmeier}

The following Braille displays are supported: 

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB and bluetooth)
* BRAILLEX Live 20, BRAILLEX Live and BRAILLEX Live Plus (USB and bluetooth)

These displays do not support NVDA's automatic background braille display detection functionality.

If BrxCom is installed, NVDA will use BrxCom.
BrxCom is a tool that allows keyboard input from the braille display to function independently from a screen reader.
Keyboard input is possible with the Trio and BRAILLEX Live models.

Most devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
The C and Live series are the only exceptions to this rule.

The c-series and some other displays have two routing rows whereby the upper row is used to report formatting information.
Holding one of the upper routing keys and pressing the EAB on c-series devices emulates the second switch state.
The live series displays have one routing row only and the EAB has one step per direction.
The second step may be emulated by pressing one of the routing keys and pressing the EAB in the corresponding direction.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.

Generally, the following keys are available on these braille displays:

| Name |Key|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report title |l1+up|
|Report Status Bar |l2+down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |left2|
|Move to next object |right2|
|Report text formatting under braille cell |upper routing row|

<!-- KC:endInclude -->

The Trio model has four additional keys which are in front of the braille keyboard.
These are (ordered from left to right):

* left thumb key (lt)
* space
* space
* right thumb key (rt)

Currently, the right thumb key is not in use.
The inner keys are both mapped to space.

| Name |Key|
|---|---|

<!-- KC:beginInclude -->

|escape key |space with dot 7|
|upArrow key |space with dot 2|
|leftArrow key |space with dot 1|
|rightArrow key |space with dot 4|
|downArrow |space with dot 5|
|control key |lt+dot2|
|alt key |lt+dot3|
|control+escape key |space with dot 1 2 3 4 5 6|
|tab key |space with dot 3 7|

<!-- KC:endInclude  -->

### Papenmeier Braille BRAILLEX Older Models {#PapenmeierOld}

The following Braille displays are supported: 

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Note that these displays can only be connected via a serial port.
Due to this, these displays do not support NVDA's automatic background braille display detection functionality.
You should select the port to which the display is connected after you have chosen this driver in the [Select Braille Display](#SelectBrailleDisplay) dialog.

Some of these devices have an Easy Access Bar (EAB) that allows intuitive and fast operation.
The EAB can be moved in four directions where generally each direction has two switches.
Pressing and holding the up, down, right and left keys (or EAB) causes the corresponding action to be repeated.
Older devices do not have an EAB; front keys are used instead.

Generally, the following keys are available on braille displays:

| Name |Key|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

Following are the Papenmeier command assignments for NVDA:

<!-- KC:beginInclude -->
Devices with EAB:

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Report title |l1up|
|Report Status Bar |l2down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to next object |right2|
|Move to previous object |left2|
|Report text formatting under braille cell |upper routing strip|

BRAILLEX Tiny:

| Name |Key|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Toggle braille tethered to |r2|
|Move to containing object |r1+up|
|Move to first contained object |r1+dn|
|Move to previous object |r1+left|
|Move to next object |r1+right|
|Report text formatting under braille cell |upper routing strip|
|Report title |l1+up|
|Report status bar |l2+down|

BRAILLEX 2D Screen:

| Name |Key|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report text formatting under braille cell |upper routing strip|
|Move braille display to previous line |up|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to next line |dn|
|Move to next object |left2|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#HumanWareBrailleNote}

NVDA supports the BrailleNote notetakers from [Humanware](https://www.humanware.com) when acting as a display terminal for a screen reader.
The following models are supported:

* BrailleNote Classic (serial connection only)
* BrailleNote PK (Serial and bluetooth connections)
* BrailleNote MPower (Serial and bluetooth connections)
* BrailleNote Apex (USB and Bluetooth connections)

For BrailleNote Touch, please refer to  the [Brailliant BI Series / BrailleNote Touch](#HumanWareBrailliant) section.

Except for BrailleNote PK, both braille (BT) and QWERTY (QT) keyboards are supported.
For BrailleNote QT, PC keyboard emulation isn't supported.
You can also enter braille dots using the QT keyboard.
Please check the braille terminal section of the BrailleNote manual guide for details.

If your device supports more than one type of connection, when connecting your BrailleNote to NVDA, you must set the braille terminal port in braille terminal options.
Please check the BrailleNote manual for details.
In NVDA, you may also need to set the port in the [Select Braille Display](#SelectBrailleDisplay) dialog.
If you are connecting via USB or bluetooth, you can set the port to "Automatic", "USB" or "Bluetooth", depending on the available choices.
If connecting using a legacy serial port (or a USB to serial converter) or if none of the previous options appear, you must explicitly choose the communication port to be used from the list of hardware ports.

Before connecting your BrailleNote Apex using its USB client interface, you must install the drivers provided by HumanWare.

On the BrailleNote Apex BT, you can use the scroll wheel located between dots 1 and 4 for various NVDA commands.
The wheel consists of four directional dots, a centre click button, and a wheel that spins clockwise or counterclockwise.

Following are the BrailleNote command assignments for NVDA.
Please check your BrailleNote's documentation to find where these keys are located.

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |back|
|Scroll braille display forward |advance|
|Move braille display to previous line |previous|
|Move braille display to next line |next|
|Route to braille cell |routing|
|NVDA menu |space+dot1+dot3+dot4+dot5 (space+n)|
|Toggle braille tethered to |previous+next|
|Up arrow key |space+dot1|
|Down arrow key |space+dot4|
|Left Arrow key |space+dot3|
|Right arrow key |space+dot6|
|Page up key |space+dot1+dot3|
|Page down key |space+dot4+dot6|
|Home key |space+dot1+dot2|
|End key |space+dot4+dot5|
|Control+home keys |space+dot1+dot2+dot3|
|Control+end keys |space+dot4+dot5+dot6|
|Space key |space|
|Enter |space+dot8|
|Backspace |space+dot7|
|Tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Shift+tab keys |space+dot1+dot2+dot5+dot6|
|Windows key |space+dot2+dot4+dot5+dot6 (space+w)|
|Alt key |space+dot1+dot3+dot4 (space+m)|
|Toggle input help |space+dot2+dot3+dot6 (space+lower h)|

Following are commands assigned to BrailleNote QT when it is not in braille input mode.

| Name |Key|
|---|---|
|NVDA menu |read+n|
|Up arrow key |upArrow|
|Down arrow key |downArrow|
|Left Arrow key |leftArrow||
|Right arrow key |rightArrow|
|Page up key |function+upArrow|
|Page down key |function+downArrow|
|Home key |function+leftArrow|
|End key |function+rightArrow|
|Control+home keys |read+t|
|Control+end keys |read+b|
|Enter key |enter|
|Backspace key |backspace|
|Tab key |tab|
|Shift+tab keys |shift+tab|
|Windows key |read+w|
|Alt key |read+m|
|Toggle input help |read+1|

Following are commands assigned to the scroll wheel:

| Name |Key|
|---|---|
|Up arrow key |upArrow|
|Down arrow key |downArrow|
|Left Arrow key |leftArrow|
|Right arrow key |rightArrow|
|Enter key |centre button|
|Tab key |scroll wheel clockwise|
|Shift+tab keys |scroll wheel counterclockwise|

<!-- KC:endInclude -->

### EcoBraille {#EcoBraille}

NVDA supports EcoBraille displays from [ONCE](https://www.once.es/).
The following models are supported:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

In NVDA, you can set the serial port to which the display is connected in the [Select Braille Display](#SelectBrailleDisplay) dialog.
These displays do not support NVDA's automatic background braille display detection functionality.

Following are the key assignments for EcoBraille displays.
Please see the [EcoBraille documentation](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/) for descriptions of where these keys can be found.

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |T2|
|Scroll braille display forward |T4|
|Move braille display to previous line |T1|
|Move braille display to next line |T5|
|Route to braille cell |Routing|
|Activate current navigator object |T3|
|Switch to next review mode |F1|
|Move to containing object |F2|
|Switch to previous review mode |F3|
|Move to previous object |F4|
|Report current object |F5|
|Move to next object |F6|
|Move to focus object |F7|
|Move to first contained object |F8|
|Move System focus or caret to current review position |F9|
|Report review cursor location |F0|
|Toggle braille tethered to |A|

<!-- KC:endInclude -->

### SuperBraille {#SuperBraille}

The SuperBraille device, mostly available in Taiwan, can be connected to by either USB or serial.
As the SuperBraille does not have any physical typing keys or scrolling buttons, all input must be performed via a standard computer keyboard.
Due to this, and to maintain compatibility with other screen readers in Taiwan, two key bindings for scrolling the braille display have been provided:
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |numpadMinus|
|Scroll braille display forward |numpadPlus|

<!-- KC:endInclude -->

### Eurobraille Esys/Esytime/Iris displays {#Eurobraille}

The Esys, Esytime and Iris displays from [Eurobraille](https://www.eurobraille.fr/) are supported by NVDA.
Esys and Esytime-Evo devices are supported when connected via USB or bluetooth.
Older Esytime devices only support USB.
Iris displays can only be connected via a serial port.
Therefore, for these displays, you should select the port to which the display is connected after you have chosen this driver in the Braille Settings dialog.

Iris and Esys displays have a braille keyboard with 10 keys.
Of the two keys placed like a space bar, the left key is corresponding to the backspace key and the right key to the space key.

Following are the key assignments for these displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |switch1-6left, l1|
|Scroll braille display forward |switch1-6Right, l8|
|Move to current focus |switch1-6Left+switch1-6Right, l1+l8|
|Route to braille cell |routing|
|Report text formatting under braille cell |doubleRouting|
|Move to previous line in review |joystick1Up|
|Move to next line in review |joystick1Down|
|Move to previous character in review |joystick1Left|
|Move to next character in review |joystick1Right|
|Switch to previous review mode |joystick1Left+joystick1Up|
|Switch to next review mode |joystick1Right+joystick1Down|
|Erase the last entered braille cell or character |backSpace|
|Translate any braille input and press the enter key |backSpace+space|
|insert key |dot3+dot5+space, l7|
|delete key |dot3+dot6+space|
|home key |dot1+dot2+dot3+space, joystick2Left+joystick2Up|
|end key |dot4+dot5+dot6+space, joystick2Right+joystick2Down|
|leftArrow key |dot2+space, joystick2Left, leftArrow|
|rightArrow key |dot5+space, joystick2Right, rightArrow|
|upArrow key |dot1+space, joystick2Up, upArrow|
|downArrow key |dot6+space, joystick2Down, downArrow|
|enter key |joystick2centre|
|pageUp key |dot1+dot3+space|
|pageDown key |dot4+dot6+space|
|numpad1 key |dot1+dot6+backspace|
|numpad2 key |dot1+dot2+dot6+backspace|
|numpad3 key |dot1+dot4+dot6+backspace|
|numpad4 key |dot1+dot4+dot5+dot6+backspace|
|numpad5 key |dot1+dot5+dot6+backspace|
|numpad6 key |dot1+dot2+dot4+dot6+backspace|
|numpad7 key |dot1+dot2+dot4+dot5+dot6+backspace|
|numpad8 key |dot1+dot2+dot5+dot6+backspace|
|numpad9 key |dot2+dot4+dot6+backspace|
|numpadInsert key |dot3+dot4+dot5+dot6+backspace|
|numpadDecimal key |dot2+backspace|
|numpadDivide key |dot3+dot4+backspace|
|numpadMultiply key |dot3+dot5+backspace|
|numpadMinus key |dot3+dot6+backspace|
|numpadPlus key |dot2+dot3+dot5+backspace|
|numpadEnter key |dot3+dot4+dot5+backspace|
|escape key |dot1+dot2+dot4+dot5+space, l2|
|tab key |dot2+dot5+dot6+space, l3|
|shift+tab key |dot2+dot3+dot5+space|
|printScreen key |dot1+dot3+dot4+dot6+space|
|pause key |dot1+dot4+space|
|applications key |dot5+dot6+backspace|
|f1 key |dot1+backspace|
|f2 key |dot1+dot2+backspace|
|f3 key |dot1+dot4+backspace|
|f4 key |dot1+dot4+dot5+backspace|
|f5 key |dot1+dot5+backspace|
|f6 key |dot1+dot2+dot4+backspace|
|f7 key |dot1+dot2+dot4+dot5+backspace|
|f8 key |dot1+dot2+dot5+backspace|
|f9 key |dot2+dot4+backspace|
|f10 key |dot2+dot4+dot5+backspace|
|f11 key |dot1+dot3+backspace|
|f12 key |dot1+dot2+dot3+backspace|
|windows key |dot1+dot2+dot3+dot4+backspace|
|Caps Lock key |dot7+backspace, dot8+backspace|
|num lock key |dot3+backspace, dot6+backspace|
|shift key |dot7+space, l4|
|Toggle shift key |dot1+dot7+space, dot4+dot7+space|
|control key |dot7+dot8+space, l5|
|Toggle control key |dot1+dot7+dot8+space, dot4+dot7+dot8+space|
|alt key |dot8+space, l6|
|Toggle alt key |dot1+dot8+space, dot4+dot8+space|
|ToggleHID keyboard input simulation |esytime):l1+joystick1Down, esytime):l8+joystick1Down|

<!-- KC:endInclude -->

### Nattiq nBraille Displays {#NattiqTechnologies}

NVDA supports displays from [Nattiq Technologies](https://www.nattiq.com/) when connected via USB.
Windows 10 detects the Braille Displays once connected, you may need to install USB drivers if using older versions of Windows (below Win10).
You can get them from the manufacturer's website.

Following are the key assignments for Nattiq Technologies displays with NVDA.
Please see the display's documentation for descriptions of where these keys can be found.
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |up|
|Scroll braille display forward |down|
|Move braille display to previous line |left|
|Move braille display to next line |right|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### BRLTTY {#BRLTTY}

[BRLTTY](https://www.brltty.com/) is a separate program which can be used to support many more braille displays.
In order to use this, you need to install [BRLTTY for Windows](https://www.brltty.com/download.html).
You should download and install the latest installer package, which will be named, for example, brltty-win-4.2-2.exe.
When configuring the display and port to use, be sure to pay close attention to the instructions, especially if you are using a USB display and already have the manufacturer's drivers installed.

For displays which have a braille keyboard, BRLTTY currently handles braille input itself.
Therefore, NVDA's braille input table setting is not relevant.

BRLTTY is not involved in NVDA's automatic background braille display detection functionality.

Following are the BRLTTY command assignments for NVDA.
Please see the [BRLTTY key binding lists](http://mielke.cc/brltty/doc/KeyBindings/) for information about how BRLTTY commands are mapped to controls on braille displays.
<!-- KC:beginInclude -->

| Name |BRLTTY command|
|---|---|
|Scroll braille display back |fwinlt (go left one window)|
|Scroll braille display forward |fwinrt (go right one window)|
|Move braille display to previous line |lnup (go up one line)|
|Move braille display to next line |lndn (go down one line)|
|Route to braille cell |route (bring cursor to character)|

<!-- KC:endInclude -->

## Advanced Topics {#AdvancedTopics}
### Command Line Options {#CommandLineOptions}

NVDA can accept one or more additional options when it starts which alter its behaviour.
You can pass as many options as you need.
These options can be passed when starting from a shortcut (in the shortcut properties), from the Run dialog (Start Menu -> Run or Windows+r) or from a Windows command console.
Options should be separated from the name of NVDA's executable file and from other options by spaces.
For example, a useful option is --disable-addons, which tells NVDA to suspend all running add-ons.
This allows you to determine whether a problem is caused by an add-on and to recover from serious problems caused by add-ons.

As an example, you can exit the currently running copy of NVDA by entering the following in the Run dialog:

nvda -q

Some of the command line options have a short and a long version, while some of them have only a long version.
For those which have a short version, you can combine them like this:

|nvda -mc CONFIGPATH |This will start NVDA with startup sounds and message disabled, and the specified configuration|
|nvda -mc CONFIGPATH --disable-addons |Same as above, but with add-ons disabled|

Some of the command line options accept additional parameters; e.g. how detailed the logging should be or the path to the user configuration directory.
Those parameters should be placed after the option, separated from the option by a space when using the short version or an equals sign (=) when using the long version; e.g.:

|nvda -l 10 |Tells NVDA to start with log level set to debug|
|nvda --log-file=c:\nvda.log |Tells NVDA to write its log to c:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Tells NVDA to start with log level set to info and to write its log to c:\nvda.log|

Following are the command line options for NVDA:

| Short |Long |Description|
|---|---|---|
|-h |--help |show command line help and exit|
|-q |--quit |Quit already running copy of NVDA|
|-k |--check-running |Report whether NVDA is running via the exit code; 0 if running, 1 if not running|
|-f LOGFILENAME |--log-file=LOGFILENAME |The file where log messages should be written to|
|-l LOGLEVEL |--log-level=LOGLEVEL |The lowest level of message logged (debug 10, input/output 12, debug warning 15, info 20, warning 30, error 40, critical 50, disabled 100), default is warning|
|-c CONFIGPATH |--config-path=CONFIGPATH |The path where all settings for NVDA are stored|
|-m |--minimal |No sounds, no interface, no start message, etc.|
|-s |--secure |Secure mode: disables Python console, profile features such as creation, deletion, renaming profiles etc., update check, some checkboxes in the welcome dialog and in general settings category (e.g. Use NVDA during sign-in, save configuration after exit etc.), as well as logviewer and logging features (used often in secure screens). Note also that this command will disable the possibility to save settings in system config and the gesture map will not be saved on the disk.|
|None |--disable-addons |Add-ons will have no effect|
|None |--debug-logging |Enable debug level logging just for this run. This setting will override any other log level ( --loglevel, -l) argument given, including no logging option.|
|None |--no-logging |Disable logging altogether while using NVDA. This setting can be overridden if a log level ( --loglevel, -l) is specified from command line or if debug logging is turned on.|
|None |--no-sr-flag |Don't change the global system screen reader flag|
|None |--install |Installs NVDA (starting the newly installed copy)|
|None |--install-silent |Silently installs NVDA (does not start the newly installed copy)|
|None |--enable-start-on-logon=True|False |When installing, enable NVDA's [Use NVDA during Windows sign-in](#StartAtWindowsLogon)|
|None |--create-portable |Creates a portable copy of NVDA (starting the newly created copy). Requires --portable-path to be specified|
|None |--create-portable-silent |Creates a portable copy of NVDA (does not start the newly installed copy). Requires --portable-path to be specified|
|None |--portable-path=PORTABLEPATH |The path where a portable copy will be created|

### System Wide Parameters {#SystemWideParameters}

NVDA allows some values to be set in the system registry which alter the system wide behaviour of NVDA.
These values are stored in the registry under one of the following keys:

* 32-bit system: "HKEY_LOCAL_MACHINE\SOFTWARE\nvda"
* 64-bit system: "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\nvda"

The following values can be set under this registry key:

| Name |Type |Possible values |Description|
|---|---|---|---|
|configInLocalAppData |DWORD |0 (default) to disable, 1 to enable |If enabled, stores the NVDA user configuration in the local application data instead of the roaming application data|
|serviceDebug |DWORD |0 (default) to disable, 1 to enable |If enabled, disables secure mode on windows secure desktops, allowing the use of the Python console and Log viewer. Due to several major security implications, the use of this option is strongly discouraged|

## Further Information {#FurtherInformation}

If you require further information or assistance regarding NVDA, please visit the NVDA web site at NVDA_URL.
Here, you can find additional documentation, as well as technical support and community resources.
This site also provides information and resources concerning NVDA development.

