# NVDA NVDA_VERSION User Guide

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Commands Quick Reference -->



## မိတ်ဆက် {#toc2}

အမြင်အာရုံအားနည်းသူများ ကွန်ပျူတာ သုံးနိုင်ရန်ပြုလုပ်ထားသော NVDA သည် အခမဲ့ရရုံသာမက မူရင်းအရင်းမြစ်များကိုလည်း ပြန်လည်ပြင်ဆင်နိုင်သည် ၎င်းသည် Microsoft Windows ပေါ်တွင် အလုပ်လုပ်နိုင်သည်။
NVDA သည် ကွန်ပျူတာအသံထွက်စကားပြောစနစ်မှ မျက်မမြင်စာကိုလဲ ဖော်ပြနိုင်စွမ်းရှိသည်။ ထိုင့်ပြင် ကုန်ကျစရိတ်မရှိပဲ မျက်မမြင်နှင့် အမြင်အာရုံအားနည်းသူများကို မြင်သူတစ်ယောက်က ကူညီသကဲ့သို့ Windowss အလုပ်လုပ်နေသော ကွန်ပျူတာပေါ်တွင် လုပ်ပေးနိုင်စွမ်းရှိသည်။ NV Access အဖွဲ့က NVDA ကို တီထွင်ရေးသားထားခြင်းဖြစ်သည်။
[NV Access](https://www.nvaccess.org/) ပေါ်တွင် ကျွမ်းကျင်သူများနှင့်ပူးပေါင်း၍ဆောင်ရွက်လျက်ရှိသည်။

### အထွေထွေလုပ်ဆောင်ချက်များ {#toc3}

NVDA ဖြင့် မျက်မမြင်နှင့် အမြင်အာရုံအားနည်းသူများသည် Windows တွင်ပါဝင်သော Software များသာမက ထပ်မံထည့်သွင်းသော Software များဖြင့်ပါအသုံးပြုနိုင်သည်။

အဓိကလုပ်ဆောင်ချက်များ:

* အသုံးတွင်ကျယ်သော Web Browsers,email clients,internet chat programs နှင့် office suites ပေါ်တွင် အလုပ်လုပ်နိုင်သည်။
* NVDA ထဲတွင် ထည့်သွင်းထားသော ကွန်ပျူတာအသံထွက်စကားပြောစနစ်သည် ဘာသာစကားပေါင်း ၈၀ ကျော်ကို ဖတ်ပြနိုင်စွမ်းရှိသည်။
* ထို့အပြင် စာလုံးအရွယ်အစား ပုံသဏ္ဍာန်နှင့် mouse များတည်နေရာကိုလဲ အသံဖြင့်ဖော်ပြနိုင်သည်။
* မျက်မမြင်စာဖော်ပြသောစက်အတော်များများကို Program ထည့်သွင်းစရာမလိုပဲ အသုံးပြုနိုင်သည်။
* NVDA တွင် ပါဝင်သော စာများကို ၄၈ ဘာသာဖြင့် ဘာသာပြန်ပေးလျက်ရှိသည်။
* Windows စနစ်များဖြစ်သော 32 bit နှင့် 64 bit နှစ်ခုစလုံးပေါ်တွင် အလုပ်လုပ်သည်။
* ထို့အပြင် Logon မျက်နှာပြင်ပေါ်နှင့် အခြားမျက်နှာပြင်ပေါ်တွင်လဲ အလုပ်လုပ်နိုင်သည်။
* ၎င်းပြင် Microsoft Active Accessibility, Java Access Bridge,IAccessible 2 နှင့် UI Automation(UI Automation များဖြင့်တွဲဖက်လုပ်ဆောင်သည်။) ချွင်းချက်အနေဖြင့် UI Automation ကို Windows 7 မှစပြီး အလုပ်လုပ်သည်။
* Command Prompt နှင့် Command Prompt ဖြင့်ဖန်တီးထားသော Software ပေါ်တွင်လဲ အလုပ်လုပ်သည်။

### ကမ္ဘာတစ်ဝှမ်း {#toc4}

မည်သည့်နေရာတွင်နေနေ မည်သည့်ဘာသာစကားပြောပြော နည်းပညာကိုအလွယ်တကူရရှိနိုင်သည်။
အဓိကအားဖြင့် အင်္ဂလိပ်ဘာသာစကားပေါ်တွင် အခြေခံ၍ ၄၈ ဘာသာပြန်ပြီးလျှက်ရှိသည်။
၎င်းတို့မှာ အာဖရိက, အယ်ဘေးနီးယား, အယ်မရစ်, အာရပ်, အာရာဂိုနီ, ဘရာဇီး ပေါ်တူဂီ, ကိုလမ်ဘီယာ စပိန်, ခရိုတီယမ်, ချက်, ဒိန်းမတ်, ဒတ်ချ်, ဖာဆီ, ဖင်လန်, ပြင်သစ်, ဂလေးရှမ်း, ဂရိ, ဂျော်ဂျီယာ, ဂျာမနီ, ဟီဘရူး, ဟင်ဒီ, ဟန်ဂေရီ, အတ်တလန်တစ်, အိုင်းရစ်, အီတလီ, ဂျပန်, ကိုရီးယား, လီတူနီယမ်, နီပေါ, နော်ဝေး, ပိုလန်, ပေါ်တူဂီ, ပန်ချာပီ, ရိုမေနီးယား,ရုရှား, ဆာဘီယန်, ဆလိုဗတ်, ဆလိုဘေးနီးယန်း, စပိန်, ဆွီဒင်, တာမန်, ထိုင်း, တရုတ်, တူရကီ, ယူကရိန်း နှင့် ဗီယမ်နန် တို့ဖြစ်သည်။

### ကွန်ပျူတာအသံထွက်စကားပြောစနစ်ဖြင့် တွဲဖက်လုပ်ဆောင်မှု {#toc5}

NVDA သည် ဘာသာစကားမျိုးစုံဖြင့် ဖော်ပြထားသော သတင်းအချက်လက်များကို ဖတ်ပြနိုင်သည်။ သို့သော် ထည့်သွင်းထားသော ကွန်ပျူတာစကားပြောစနစ်ပေါ်တွင်မူတည်သည်။

NVDA သည် eSpeak NG ဖြင့်တွဲဖက်လုပ်ဆောင်သည်။ https://github.com/espeak-ng/espeak-ng], အခမဲ့, အများပိုင်အရင်းအမြစ်,ဘာသာစကားအမျိုးမျိုးအတွက် အသံထွက် synthesizer ဖြစ်သည်။ 

အခြားသော Computer အသံထွက်စကားပြောစနစ်များဖြင့်လဲ တွဲဖက်အသုံးပြုနိုင်သည်။

### မျက်မမြင်စာလုပ်ဆောင်ချက် {#toc6}

အသုံးပြုသူသည် မျက်မမြင်စာ ဖော်ပြစက်ရှိပါက NVDA သည် မျက်မမြင်စာဖြင့် သတင်းအချက်လက်များကို ဖော်ပြပေးသည်။
အသေးစိတ်သိရှိလိုပါက [Supported Braille Displays](#SupportedBrailleDisplays) braille display အတွက်ထောက်ပံ့ပေးနိုင်သည့် အခန်းဂဏ္တွတွင် လေ့လာနိုင်ပါသည်။

NVDA သည် ကွန်ပျူတာဖြင့်ရေးသော မျက်မမြင်စာအမျိုးမျိုးကို ဖော်ပြပေးနိုင်စွမ်းရှိသည်။

### လိုင်စင် နှင့် မူပိုင်ခွင့် {#toc7}

NVDA သည် ပြည်သူပိုင်လိုင်စင် ဗားရှင်း 2 ဖြစ်ပြီး မည်သူမဆို ဝေငှနိုင်သည်။ ထို့အပြင် အရင်းမြစ်များကိုလဲ ပြင်ဆင်ခွင့်ရှိသည်။

အသေးစိတ်သိရှိလိုပါက https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

## ကွန်ပျူတာအတွက်လိုအပ်ချက်များ {#toc8}

* Windowss XP, Windowss Vista, Windowss 7, Windowss 8, Windowss 8.1, Windowss 10 နှင့် Windows Server တစ်ခုခုရှိရန်လုံလောက်သည်။
 * Windows စနစ်များဖြစ်သော 32bit နှင့် 64bit အားလုံးပေါ်တွင် အလုပ်လုပ်သည်။
 * Windows XP 32bit, Windows Server 2003, Windows Vista များဖြင့် NVDA ကို အသုံးပြုလိုလျှင် Windows ကို Update လုပ်ပေးရန်လိုအပ်သည်။
* Memory: 256mb သို့မဟုတ် ပို၍များပြားသော Memory
* Processor Speed: 1.0ghz သို့မဟုတ် ပို၍မြန်ဆန်သော CPU
* Hard Disk တွင် 90mb ထိနေရာယူမည်။

## NVDA ရယူခြင်းနှင့် အပြင်အဆင် {#toc9}

သင့်၌ NVDA မရှိသေးလျှင် [www.nvaccess.org](http://www.nvaccess.org) NVDA_URL တွင် Download ဆွဲနိုင်ပါသည်။

Download လုပ်ပြီးထားသော NVDA ကို စတင် Install လုပ်သောအခါ NVDA က မေးပါလိမ့်မည် Create a portable copy သို့မဟုတ် Just continue using the temporary copy သင့်ကွန်ပျူတာတွင် NVDA ကို အမြဲအသုံးပြုလိုလျှင် သင်ရွေးရပါမည် Install NVDA သည် Logon မျက်နှာပြင်နှင့် အခြားမျက်နှာပြင်များပေါ်တွင် အလုပ်လုပ်ရုံသာမက Short Cut များလဲလုပ်နိုင်သည်။ NVDA ဖွင့်သည့် Short Cut ကို Alt+Ctrl+N ထည့်သွင်းပေးထားသည်။
ထို Short Cut သည် Portable နှင့် Temporary Copy ပေါ်တွင် အလုပ်မလုပ်ပါ။
Install NVDA ကို အချိန်မရွေး Portable Version သို့ပြောင်းလဲနိုင်သည်။
သင့်အနေဖြင့် NVDA ကို usb device ထဲထည့်၍ အသုံးပြုလိုလျှင် Create a portable copy ကိုရွေးချယ်ပါ။ သို့သော် Read Only CD ပေါ်တွင် မလုပ်ဆောင်နိုင်ပါ။
သင့် usb drive ထဲတွင် ထည့်သွင်းထားသော Portable Version ကို Windows တင်ထားသော မည်သည့်ကွန်ပျူတာပေါ်တွင်မဆို အသုံးပြုနိုင်သည်။
သင့်အနေဖြင့် Portable Version ကို ပြန်လည် Install လုပ်လိုလျှင်လဲ လုပ်နိုင်သည်။
The Temporary copy of NVDA သည်အသုံးပြုသူကို Install လုပ်နေစဉ်တွင်ဖတ်ပြခြင်းဖြစ်သည်။

### Portable နှင့် ယာယီအသုံးပြုခြင်း ခွင့်ပြုချက် {#toc10}

Portable NVDA ကို Windows စစတက်ချင်းတွင် အလိုအလျောက်ပွင့်ခြင်းကိုအသုံးမပြုနိုင်ပါ။

* Administrative privileges မရရှိခြင်းကြောင့်ဖြစ်သည်။
* Windows 8 နှင့် နောက်ပိုင်း Windows များတွင် Touch မျက်နှာပြင်များပေါ် NVDA ဖြင့်အသုံးပြုနိုင်သည်။
* Windows 8 နှင့် နောက်ပိုင်း Windows များပေါ်တွင် Windows Store app တွင် ရှာဖွေချင်း စာရိုက်ခြင်းများပြုလုပ်နိုင်သည်။
* Windows 8 နှင့် နောက်ပိုင်း Windows များပေါ်တွင် Audio ducking အသုံးမပြုနိုင်ပါ။

### NVDA ထည့်သွင်းခြင်း {#toc11}

NVDA Installer ဖိုင်ကို Enter နှိပ်ပါ ပြီးနောက် Install Button ကိုနှိပ်ပါ။
အကယ်၍ Install လုပ်ခြင်းကိုရပ်ပြီး Portable အသုံးပြုလိုလျှင် NVDA Menu ထဲမှ Tools တွင်ရှာပါ။
NVDA သည် ဖော်ပြပါလိမ့်မည် မည်သည့်နေရာတွင် Install လုပ်မည် အကယ်၍ ထည့်သွင်းထားသော NVDA ရှိပါက ထပ်မံထည့်သွင်းမည်ကို Continue နှိပ်၍ Install လုပ်ပါ။
Install လုပ်ခြင်းပြည့်စုံပါက ဖော်ပြပါလိမ့်မည် That it was successful. Ok ကိုနှိပ်ပါ။ NVDA ပိတ်ပြီး အလိုလိုပြန်လည်ပွင့်လာလိမ့်မည်။

#### Windows Logon တွင် စတင်အသုံးပြုခြင်း {#toc12}

အကယ်၍ NVDA သည် အလိုလျှောက် အလုပ်မလုပ်ပါက သင်၏ Windows Password ကိုရိုက်ပါ။
၎င်းအခြေနေသည် Logon မျက်နှာပြင် နှင့် အခြားမျက်နှာပြင်များနှင့်လဲသက်ဆိုင်သည်။

#### NVDA Short Cut ဖန်တီးခြင်း (Ctrl+Alt+N) {#toc13}

အကယ်၍ Desktop ပေါ်တွင် သင့်အနေဖြင့် NVDA Short Cut လုပ်ထားသည်ဖြစ်စေ မလုပ်ထားသည်ဖြစ်စေ NVDA အနေဖြင့် ပြုလုပ်ပြီးသားဖြစ်သည်။ မည်သည့်အခြေနေမဆို အသုံးပြုနိုင်သည်။

#### ကူးယူထားသော NVDA Portable ပြင်ဆင်ခြင်းနှင့် လက်တလောသုံးဆွဲနေသော User Account {#toc14}

ကူးယူထားသော NVDA Portable နှင့် ပြင်ဆင်ထားသော NVDA Copy သည် အခြားအကောင့် Logon မျက်နှာပြင်များပေါ်တွင် ကူးယူထားခြင်းမဖြစ်ပါ။ထိုအခြေနေသည် Installer ဖိုင်ကို Install လုပ်ထားခြင်းနှင့်မသက်ဆိုင်ပါ။

### NVDA Portable ပြုလုပ်ခြင်း {#toc15}

သင့်အနေဖြင့် Download လုပ်ထားသော NVDA ဖိုင်မှ NVDA Portable ပြုလုပ်လိုလျှင် Create Portable Copy Button ကိုနှိပ်ပါ။
အကယ်၍ Run နေသော NVDA တွင်ပြုလုပ်လိုလျှင် Create Portable Copy ကို NVDA Menu ထဲမှ Tool တွင်ရှာပါ။

NVDA သည် ဖော်ပြပါလိမ့်မည် မည်သည့်နေရာတွင် NVDA Portable ပြုလုပ်နိုင်သည်ကို ၎င်းသည် ပြုလုပ်ပေးနိုင်ပါသည်။
Hard Disk သို့မဟုတ် USB Thumb Drive နှင့် အခြား Media Devices ပေါ်တွင်လုပ်နိုင်သည်။
သင့်အနေဖြင့် ကြိုက်နှစ်သက်ရာတစ်ခုခုကို ရွေးချယ်ပေးရန်လိုအပ်သည်။
 ထပ်မံရွေးချယ်ရမည့်အဆင့်များလဲရှိသေးသည်။လတ်တလောသုံးစွဲနေသည့် NVDA Setting နှင့် အစောဆုံးပြုလုပ်ထားသော Setting သင့်အနေနှင့်ကြိုက်နှစ်သက်ရာကို ရွေးနိုင်ပါသည်။
၎င်းကို NVDA Portable ပေါ်တွင်သာပြုလုပ်နိုင်သည်။Installer ဖိုင်တွင်မပြုလုပ်နိုင်ပါ။ ပြီးနောက် Portable Copy ကိုနှိပ်ပါ။
ပြည့်စုံစွာပြုလုပ်ပြီးပါက Message ပေါ်လာလိမ့်မည်။ It was Successful.
OK ကိုနှိပ်၍ပိတ်လိုက်ပါ။

## NVDA စတင်အသုံးပြုခြင်း {#toc16}
### NVDA ဖွင့်ခြင်း {#toc17}

သင်သည် NVDA ကို Install လုပ်ပြီးဖြစ်ပါက Ctrl + Alt + N နှိပ်ပြီးဖွင့်ပါ။ သို့မဟုတ် Run Box ထဲတွင် NVDA ကိုရိုက်၍လည်းဖွင့်နိုင်သည်။ထို့အပြင် Star Menu ထဲမှ NVDA ကို ရှာ၍လဲဖွင့်နိုင်သည်။
Run Box ထဲတွင် nvda –r ရိုက်၍ NVDA ကို Restart ပြုလုပ်နိုင်သည်။
ပိတ်လိုလျှင် nvda –q ဖြင့်ပိတ်နိုင်သည်။
NVDA ဖွင့်ခြင်း− NVDA Portable ရှိသည့်နေရာကိုသွားပါ ရောက်လျှင် NVDA.exe ကို Enter ခေါက်၍ဖွင့်ပါ။
ဦးစွာကြားရပါလိမ့်မယ် NVDA is Loading. နှေးခြင်း မြန်ဆန်ခြင်းသည် သင့်ကွန်ပျူတာပေါ်တွင်မူတည်သည်။
သင်သည်နှေးကွေးသော usb portable device ကိုသုံးပါက အချိန်များစွာယူပါလိမ့်မည်။
ဖော်ပြပါအသံများမကြားရဘဲ Windows Error အသံများကြားရလျှင် NVDA ဖန်တီးသူများနှင့်ဆက်သွယ်ပါ။
မည်သို့ပြင်ဆင်ရမည်ကို NVDA Website တွင်သွား၍ လေ့လာနိုင်သည်။
NVDA ကိုပထမဦးဆုံးစတင်ဖွင့်ခြင်းတွင် အခြေခံအချက်လက်များကို သဘောတူရန်လိုအပ်သည်။
မည်သည့်ကီးဖြင့် NVDA ကို ကိုယ်စားပြုမည်။
ဒီခေါင်းစဉ်နှင့်ပါတ်သက်၍ အောက်တွင်လေ့လာပါ။
ရွေးချယ်စရာ ၃ ခုပါဝင်သော Box တစ်ခုပေါ်လာလိမ့်မည်။
ပထမအနေဖြင့် Caps Lock ကီးကို NVDA ကီးဖြင့်အသုံးပြုလိုလျှင် အမှန်ခြစ်ပါ။
ဒုတိယအနေဖြင့် Windows တက်သည်နှင့် NVDA ကို ပွင့်စေချင်လျှင် အမှန်ခြစ်ပါ။
တတိယအနေဖြင့် NVDA စတင်ဖွင့်သောအခါ NVDA မိတ်ဆက်ကိုအလိုမရှိပါက အမှန်ခြစ်ထားနိုင်သည်။

### NVDA ၏ keyboard commands များ {#toc18}
#### NVDA ကိုယ်စားပြု key {#toc19}

NVDA အတော်များများတွင် NVDA ကိုယ်စားပြုခလုပ် တစ်ခုမဟုတ် တစ်ခုထပ်ပို၍ပါဝင်သည်။
အချို့လူများသည် Desktop keyboard Layout တွင် Numpad key တွင် NVDA keypad ဖြင့်သတ်မှတ်အသုံးပြုသည်။
NVDA key အနေဖြင့် Numpad Insert, Insert ကီး သို့မဟုတ် Caps Lock ကီးပြောင်းလဲအသုံးပြုနိုင်သည်။
NVDA သည် Numpad Insert key နှင့် Insert key ကို ကြိုတင်သတ်မှတ်ထားသည်။
သင်သည် NVDA key ကို Caps Lock သတ်မှတ်ထားလျှင် NVDA သည် အလုပ်လုပ်သည်ဖြစ်စေ အလုပ်မလုပ်သည်ဖြစ်စေ Caps Lock ကို စာရေးရန်အတွက် အသုံးပြုလိုလျှင် ၂ ချက်နှိပ်ပါ။

#### Keyboard ပုံစံ(layout) {#toc20}

NVDA သည် keyboard Layout ၂ ခုပါဝင်သည်။၎င်းတို့မှာ Desktop keyboard Layout နှင့် Laptop keyboard Layout ပါဝင်သည်။
NVDA သည် Desktop keyboard Layout ကို ထည့်သွင်းပြီးသားဖြစ်သည်။
Laptop keyboard Layout ကို အလိုရှိပါက NVDA Menu ထဲက Preferances ကိုသွား၍ keyboard Setting တွင် ရွေးချယ်နိုင်သည်။
Desktop keyboard Layout တွင် Numpad ကိုပိတ်ထားလျှင် များစွာအလုပ်လုပ်နိုင်သည်။ သို့သော်လည်း Laptop အတော်များများတွင် သီးသန့် Numpad ပါဝင်ခြင်းမရှိပါ။ အချို့ Laptop များတွင် Fn ကီးနှင့် 7,8,9,u,i ,o,j,k,l စသည့်keys များနှင့်တွဲ၍ အသုံးပြုနိုင်သည်။အကယ်၍ သင့် Laptop သည် ထိုသို့ပြုလုပ်၍မရပါက Laptop keyboard Layout ကိုပြောင်း၍ အသုံးပြုပါ။

### NVDA Touch Gestures {#toc21}

သင်အသုံးပြုနေသောကွန်ပျူတာသည် Touch Screen ပါဝင်ပြီး Windows 8 သို့မဟုတ် Windows 8 အထက်ဖြစ်ပါက NVDA ဖြင့် Touch Screen ကိုအသုံးပြုနိုင်သည်။
NVDA အလုပ်လုပ်နေစဉ်အတွင်း Touch Screen သည် NVDA သတ်မှတ်ထားသည့်အတိုင်းလုပ်ဆောင်လိမ့်မည်။
ထို့ကြောင့် Touch Screen သည် ပုံမှန်အတိုင်းအလုပ်မလုပ်ပါ။NVDA အလုပ်မလုပ်သောအခါမှသာ Touch Screen သည် ပုံမှန်အတိုင်းလုပ်ဆောင်လိမ့်မည်။

#### Touch Screen ပေါ်တွင်ရှာဖွေခြင်း {#toc22}

အခြေခံအကျဆုံးလုပ်ဆောင်ချက်သည် လက်တစ်ချောင်းဖြင့် မည်သည့်နေရာကိုထိထိ အသံထွက်ဖတ်ပြခြင်းဖြစ်သည်။

#### Touch Gestures {#toc23}

မည်သို့အသုံးပြုရမည်ကို အောက်တွင်ဖော်ပြသွားမည်။

##### Taps {#toc24}

လက်တစ်ချောင်း သို့မဟုတ် လက်တစ်ချောင်းထပ်ပို၍ မြန်မြန်ထိပါ။
လက်တစ်ချောင်းဖြင့်ထိချင်းကို စမ်းသပ်ခြင်းဟုခေါ်သည်။လက်နှစ်ချောင်းဖြင့်ထိချင်းသည်လည်း အတူတူပင်ဖြစ်သည်။
တစ်ချက်ထပ်ပို၍မြန်မြန်ထိပါက လုပ်ဆောင်ချက်ဖြစ်လာမည်။သုံးချက်ထိရင်လည်း အတူတူပင်ဖြစ်သည်။
Multi Touch Gestures သည် လက်အချောင်းရေမည်မျှဖြင့်ထိချင်းကို သိရှိနိုင်သည်။

##### Flicks {#toc25}

သင့်လက်ချောင်ဖြင့် ကြက်ခြေခတ် ပုံစံ မြန်ဆန်စွာဆွဲပါ။
ထိုနည်းသည် ၄ နည်းဖြစ်နိုင်သည် သင်လက်ထားသည့်နေရာပေါ်တွင်မူတည်သည်။၎င်းတို့မှာ ဘယ် ညာ အပေါ် အောက် တို့ဖြစ်သည်။
လက်တစ်ချောင်းထပ်ပို၍စမ်းသပ်ခြင်းသည် Gestures ဖြစ်သည်။
ထို့ကြောင့် လက်နှစ်ချောင်းဖြင့် အပေါ်ဆွဲခြင်း လက် ၄ ချောင်းဖြင့် အပေါ်ဘက်သို့ဆွဲခြင်းသည်လဲ Gestures ဖြစ်နိုင်သည်။

#### Touch Modes {#toc26}

NVDA တွင် များစွာသော ဖြစ်နိုင်သည့် Touch Gestures များရှိသည်။
Mode ၂ ခုမှာ Test Mode နှင့် Object Mode တို့ဖြစ်သည်။ဥပမာ လက်နှစ်ချောင်းဖြင့်အပေါ်ဆွဲပါက Test Mode ဖက်မည့်စာမရှိပါက အခြား Mode သို့ပြောင်းလဲသွားမည်။
လက်သုံးချောင်းဖြင့်ထိပါ။

<!-- KC:beginInclude -->
Touch modes အနေထားကိုဖွင့်ရန် လက်သုံးချောင်းဖြင့်နိပ်ပါ။
<!-- KC:endInclude -->

### Input Help Mode {#toc27}

များစွာသော NVDA လုပ်ဆောင်ချက်များကို Help Mode ကိုဖွင့်၍လေ့လာနိုင်သည်။
NVDA Help Mode ကိုဖွင့်လိုလျှင် NVDA ကီးနှင့် 1 ကိုနှိပ်၍ဖွင့်ပါ။ပိတ်လိုလျှင် ထိုအတိုင်းပြန်နှိပ်ပါ။
NVDA Help Mode အလုပ်လုပ်နေလျှင် keys များကိုနှိပ်ကြည့်ပါက မည်သည့်အလုပ်လုပ်သည်ကို အလိုလျှောက်ရှင်းပြသည်။ Touch Screen ပေါ်တွင်လဲ လက်များဆွဲပါက မည်သည့်အလုပ်လုပ်သည်ကိုရှင်းပြသည်။
မိမိလက်တလောအသုံးပြုနေသော ပရိုဂရမ် ပေါ်တွင် အကျိုးသက်ရောက်မှုမရှိပါ။

### The NVDA menu {#toc28}

NVDA Menu သည် NVDA Setting များကိုပြင်ဆင်ခြင်း၊ NVDA ကိုပိတ်ခြင်း၊ စာဖတ်သည့်အသံထွက်များကိုပြင်ဆင်ခြင်း၊ အကူညီရယူခြင်းများ ပါဝင်သည်။
NVDA Menu ကိုဖွင့်လိုလျှင် NVDA ကီးနှင့် N ကိုနှိပ်၍သော်လည်းကောင်း၊ Touch Screen ပေါ်တွင် လက်နှစ်ချောင်းဖြင့် နှစ်ခါထိ၍သော်လည်းကောင်း ဖွင့်နိုင်သည်။
ထို့အပြင် Windows ကီးနှင့် B ကိုနှိပ်၍ NVDA ကို Arrow ကီးဖြင့် NVDA ကိုရှာပြီး Application ကီးနှိပ်၍သော်လည်းကောင်း၊Right Click နှိပ်၍သော်လည်းကောင်း၊ Enter ခေါက်၍သော်လည်းကောင်း ဖွင့်နိုင်သည်။

### အခြေခံ NVDA keys များ {#toc29}

<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|စကားပြောရပ်ခြင်း |Control |control |လက်နှစ်ချောင်းဖြင့်ထိ |အမြန်စကားပြောရပ်|
|စကားပြောခေတ္တရပ်ခြင်း |shift |shift |none |အမြန်စကားပြောခေတ္တရပ် ထပ်မံနှိပ်ပါက စကားဆက်၍ပြောမည်။|
|NVDA Menu |NVDA+n |NVDA+n |လက်နှစ်ချောင်းဖြင့်မြန်မြန်ထိ |NVDA Menu ပေါ်လာလိမ့်မည် preferences,tools,helps စသည်ဖြင့်|
|Toggle Speech Mode |NVDA+s |NVDA+s |none |Toggles speech mode သည်စကားပြောခြင်း စကားပြောရပ်ခြင်း စကားမပြောဘဲအသံပဲမြည်ခြင်း|
|Toggle Input Help Mode |NVDA+1 |NVDA+1 |none |၎င်းMode ကို On ထားပြီး မည်သည့်ကီးမဆို နှိပ်ပါက မည်သည့်အလုပ်လုပ်ကြောင်းကိုပြောလိမ့်မည်။NVDA ကွန်မန့်များကိုလည်းပြောသည်။|
|NVDA ပိတ်ခြင်း |NVDA+q |NVDA+q |none |NVDA ပိတ်သွားမည်။|
|Pass next key through |NVDA+f2 |NVDA+f2 |none |Tells NVDA to pass the next key press straight through to the active application, even if it is normally treated as an NVDA key command|
|Toggle application ဖွင့်ခြင်း ပိတ်ခြင်း |NVDA+shift+s |NVDA+shift+z |none |လက်ရှိအသုံးစွဲနေသော အက်ပလီကေးရှင်းပေါ်တွင် စကားပြောရပ်ခြင်းဖြစ်သည်။၎င်းကိုမျက်မမြင်စာဖြင့် ဖက်နေလျှင်အသုံးပြုသည်။|

<!-- KC:endInclude -->

### System ၏အချက်အလက်များကိုဖတ်ခြင်း {#toc30}

<!-- KC:beginInclude -->

| Name |key |Description|
|---|---|---|
|ရက်စွဲနှင့်အချိန် သိလိုလျှင် |NVDA+f12 |တစ်ကြိမ်နှိပ်ပါက လက်ရှိအချိန်ကိုပြောသည်။နှစ်ကြိမ်မြန်မြန်နှိပ်ပါက ယနေ့ရက်စွဲကိုပြောသည်။|
|ဘတ္ထရီအခြေနေ သိလိုလျှင် |NVDA+shift+b |ဘတ္ထရီအားမည်မျှရှိသည် အားသွင်းထားသည် သို့မဟုတ် အားမသွင်းထားခြင်းကို ပြောပေးသည်။|
|မည်သည့်စာသားကို ကူးယူထားသည်ကိုသိလိုလျှင် |NVDA+c |မိမိကူးယူထားသည့် စာကို ဖတ်ပြသည်။|

<!-- KC:endInclude -->

## NVDA {#toc31}

မည်သည့်နေရာတွင်ရောက်ရှိနေသည်ကို NVDA တွင် သိနိုင်စရာနည်းလမ်းများစွာရှိသည်။

### Objects {#Objects}

Windows တွင်များစွာသော Object များရှိသည်။ 
Application တစ်ခုစီပေါ်တွင်မူတည်၍ ဥပမာ Piece of text,Button,Check Box,Slider,List, သို့မဟုတ် editable text field.

### System Focus ဖြင့်တည်နေရာယူခြင်း {#SystemFocus}

ဥပမာ စာရေးသည့်အကွက်တွင် စာရေးပါက ထိုစာရေးသည့်အကွက်သည် Focus ဖြစ်သည်။

Windows တွင်ပါဝင်သည့် Focus keys များရှိသည် Tab ကီး, Alt ကီး, Alt + Tab, Ctrl + Tab, NVDA သည် မည်သည့်နေရာတွင်ရောက်ရှိနေသည်ကိုဖတ်ပြသည်။ဥပမာ ရောက်ရှိနေသည့်နေရာ အက်ပလီကေးရှင်း နာမည် keyboard short cut တို့ကိုဖတ်ပြသည်။

အသုံးဝင်သည့် Short Cut ကီးအချို့:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|လက်ရှိနေရာကိုသိလိုလျှင် |NVDA+tab |NVDA+tab |လက်ရှိရောက်နေသောနေရာကိုပြောပြပြီး ၎င်းကို နှစ်ခါမြန်မြန်နှိပ်ပါက စာလုံးပေါင်းပြသည်။|
|ခေါင်းစဉ်ကိုသိလိုလျှင် |NVDA+t |NVDA+t |လက်ရှိအသုံးပြုနေသော အက်ပလီကေးရှင်း၏ခေါင်းစဉ်ကိုဖတ်ပြသည်။နှစ်ခါမြန်မြန်နှိပ်ပါက စာလုံးပေါင်းပြသည်။သုံးခါမြန်မြန်ိနပါက လက်ရှိရောက်နေသော အက်ပလီကေးရှင်း၏ခေါင်းစဉ်ကို ကူးယူသွားခြင်းဖြစ်သည်။|
|မည်သည့် Windows  active ဖြစ်နေသည်ကိုသိလိုလျှင် |NVDA+b |NVDA+b |Active ဖြစ်နေသော Windows ကိုဖတ်ပြခြင်းဖြစ်ပြီး Dialogs Box များကိုဖတ်ရာတွင်လဲ အသုံးဝင်သည်။|
|Status Bar ကိုဖတ်ပြခြင်း |NVDA+end |NVDA+shift+end |နှစ်ခါနှိပ်ရင်စာလုံးပေါင်းပြသည်။|

<!-- KC:endInclude -->

### စာလုံးများဖြင့် NVDA ရွေ့လျားမှု {#SystemCaret}

သင်ရွှေ့နိုင်သည့် အက္ခရာများဖြင့် Application များကို Edit Cursor ဟုလူသိများသည်။

စာရိုက်သည့်နေရာတွင် Arrow Key, Page up, Page Down, Home , End များဖြင့်ရွှေ့နိုင်သည်။
သင့်စာများကိုပြင်ဆင်လိုလျှင် NVDA သည် စကားလုံးလိုက်သော်လည်းကောင်း စကားစုလိုက်သော်လည်းကောင်း စာကြောင်းလိုက်သော်လည်းကောင်း သင်ရွှေ့သောအခါဖတ်ပြပေးမည်။

NVDA သည် System တွင်ပါသောကီးနှင့် တွဲဖက်အလုပ်လုပ်သည်။:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|အကုန်ဖတ်ပြမည် |NVDA+downArrow |NVDA+a |မိမိရောက်ရှိနေသော ကာစာ မှစ၍ အဆုံးထိဖတ်ပြခြင်းဖြစ်သည်။|
|ရောက်ရှိနေသောစာကြောင်း |NVDA+upArrow |NVDA+l |ရောက်ရှိနေသောစာကြောင်းကိုဖတ်ပြခြင်းဖြစ်ပြီး နှစ်ခါမြန်မြန်နှိပ်ပါက စာလုံးပေါင်းပေးသည်။|
|ရွေးချယ်ထားသောစာစုကိုဖတ်လိုလျှင် |NVDA+Shift+upArrow |NVDA+shift+s |မည်သည့်စာကို ရွေးထား ရွေးထား ဖတ်ပြခြင်းဖြစ်သည်။|
|နောက်ထပ်တစ်ကြောင်း |alt+downArrow |alt+downArrow |နောက်ထပ်စာကြောင်းတစ်ကြောင်းကိုဖတ်ပြခြင်းဖြစ်သည်။(Microsoft Word နှင့် Outlook တွင်သာဖတ်နိုင်သည်။)|
|ပြီးခဲ့သောစာကြောင်း |alt+upArrow |alt+upArrow |ပြီးခဲ့သောစာကြောင်းကိုဖတ်ပြခြင်းဖြစ်သည်။(Microsoft Word နှင့် Outlook တွင်သာဖတ်နိုင်သည်။)|

Table တွင်အသုံးပြုသော keys များ:

| Name |Key |Description|
|---|---|---|
|ဘယ်ဘက် Column သို့ပြန်လည်ရွှေ့ခြင်း |control+alt+leftArrow |Row တူသော Column မှ ဘယ်ဘက် Column သို့ရွှေ့ခြင်းဖြစ်သည်။|
|ညာလက် Column သို့ရွှေ့ခြင်း| control+alt+rightArrow |Row တူသော Column မှ ညာဘက် Column သို့ရွှေ့ခြင်းဖြစ်သည်။|
|အပေါ် Row သို့ပြန်လည်ရွှေ့ခြင်း |control+alt+upArrow |Column တူသော Row မှ အပေါ် Row သို့ရွှေ့ခြင်းဖြစ်သည်။|
|အောက် Row သို့ရွှေ့ခြင်း |control+alt+downArrow |Column တူသော Row မှ အောက် Row သို့ရွှေ့ခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

### Object များသို့ ရွှေ့လျားခြင်း {#ObjectNavigation}

သင်သည် အက်ပလီကေးရှင်း အတော်များများကို အက္ခရာများနှိပ်၍သော်လည်းကောင်း ဂဏာန်းများနှိပ်၍သော်လည်းကောင်း ရှာဖွေနိုင်သော်လည်း အမြဲတမ်းရှာဖွေ၍မရပါ။
၎င်းအခြေနေတွင် Object များသို့ရွှေ့ခြင်းကိုသုံးရပါမည်။
 [objects](#Objects) 

Object navigation ကိုအသုံးပြုသော System Focus နှင့် [objects](#Objects)Review ဟူ၍ NVDA မှ ဖတ်ပြမည်။.
Object တစ်ခုခုကို NVDA ဖြင့်သွားသောအခါ NVDA သည်ထို object ၏အချက်အလက်များအား ဖော်ပြပေးပါသည်။ ဤလုပ်ဆောင်ချက်သည် system focus အားဖော်ပြပေးခြင်းနှင့် အတူတူပင်ဖြစ်သည်။
Screen ပေါ်မှာရှိသော စာများအားဖတ်ရှုရန်အတွက် ပုံမှန်နည်းအစား [screen review](#ScreenReview) ကို အသုံးပြုနိုင်ပါသည်။

System ထဲမှာ object တစ်ခုကနေတစ်ခု ရှေ့နှောက်သွားလာခြင်းအား၊ objects တွေက ကြီးစဉ်ငယ်လိုက်၊ ဝါစဉ်အရစုစီးထားပါသည်။ 
ဆိုလိုသည်မှာ အချို့ objects များ၌ အခြား objects များလည်း ပါဝင်ခြင်းအကြောင့် ထို objects များအားသုံးစွဲလိုပါက သူတို့ရှိရာနေရာထိ သွားရောက်ရမည် ဖြစ်ပါသည်။
ဉပမာအားဖြင့်ဆိုသော် list တစ်ခုတွင် list items များရှိသည်၊ ထိုအကြောင့် list items များအားအသုံးပြုရန် ထို list ထဲသို့ဝင်ရောက်ရမည်ဖြစ်ပါသည်။
List item တစ်ခုကိုရောက်ရှိသွားပြီး ရှေ့နှောက်သွားလာသောအခါ မူရင်း list ထဲမှ အခြား list times များဆီသို့ အရောက်ရှိသွားမည် ဖြစ်ပါသည်။ 
ရောက်ရှိ list item ထဲတွင်ရှိသော object တစ်ခုမှအခြားသို့ရွေ့သောအခါ list ထဲသို့ပြန်လည်ရောက်ရှိသွားမည်ဖြစ်ပါသည်။
အခြား objects တွေအားပြန်လည်အသုံးပြုလိုပါက list နောက်သို့ပြန်လည်သွားရောက်နိုင်ပါသည်။
Toolbar တစ်ခု၌ controls တွေပါဝင်သကဲ့သို့၊ သူ၌ပါဝင်သော controls တွေကိုအသုံးပြုဘို့ရန် toolbar ၏ controls ထဲသို့ဝင်ရောက်ရန်လိုအပ်ပေသည်။

ရောက်ရှိအသုံးပြုနေသော object အား navigator object ဟုခေါ်သည်။
Object တစ်ခုစီသွားရောက်ပြီးပါက ၎င်း၏အချက်အလက်အား [Text ပြန်လည်ဆန်းစစ်ခြင်း command](#ReviewingText)အားအသုံးပြု၍ ဆန်းစစ်နိုင်ပါသည်။ 
Object တွင်မူ  [Object review mode](#ObjectReview) အားအသုံးပြုနိုင်ပါသည်။

ပုံမှန်အားဖြင့် navigator object သည်၎င်း၏လုပ်ဆောင်ချက်အား ပိတ်ဖွင့်ပြုလုပ်နိုင်သော်လည်း System focus နှင့်အတူရွေ့လျှားပြီး အလုပ်လုပ်သည်။

Braille သည် ပုံမှန်အားဖြင့် object navigation နှင့် text review တို့ထက် [focus](#SystemFocus) နှင့် [caret](#SystemCaret) တို့နှင့်အတူ သွားလျက်ရှိသည်။
အကယ်၍ object navigation နှင့် text review တို့နှင့်အတူသွားလိုပါက [braille ဖြင့်ချိပ်ဆက်ချိန်ညိခြင်း](#BrailleTether) အားချိန်ညိရန်လိုအပ်မည်ဖြစ်သည်။

Object ဖြင့် navigate ပြုလုပ်ရန် အောက်ပါ commands များအားအသုံးပြုပါ-
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|ရောက်ရှိနေသော Object ကိုဖတ်ပြခြင်း |NVDA+numpad5 |NVDA+shift+o |none |၎င်းကိုနှစ်ခါနှိပ်ပါက စာလုံးပေါင်းပြသည်။ သုံးခါနှိပ်ပါက စာလုံးပေါင်းပြထားသော စကားစုကို ကူးယူသွားသည်။|
|Object အတွင်းတွင်ရွှေ့ခြင်း |NVDA+numpad8 |NVDA+shift+upArrow |အပေါ်သို့ဆွဲပါ |လက်ရှိရောက်နေသော Object အတွင်းတွင်ရွှေ့ခြင်းဖြစ်သည်။|
|ပြီးခဲ့သည့် Object ကိုရွှေ့ခြင်း |NVDA+numpad4 |NVDA+shift+leftArrow |ဘယ်ဘက်ကိုဆွဲပါ |အရင်ရွှေ့ခဲ့သည့် Object ကိုပြန်ရွှေ့ခြင်းဖြစ်သည်။|
|နောက်ထပ် Object သို့ရွှေ့ခြင်း |NVDA+numpad6 |NVDA+shift+rightArrow |ညာဘက်ကိုဆွဲပါ |ရောက်ရှိနေသော Object မှ နောက်ထပ် Object သို့ရွှေ့ခြင်းဖြစ်သည်။|
|ပထမ Object အတွင်းတွင်ရွှေ့ခြင်း |NVDA+numpad2 |NVDA+shift+downArrow |အောက်ဘက်ကိုဆွဲပါ |လက်ရှိရောက်နေသောနေရာမှ ပထမ Object သို့ပြန်လည်ရွှေ့ခြင်းဖြစ်သည်။|
|မိမိရွှေ့လိုသော Object သို့ရွှေ့ခြင်း |NVDA+numpadMinus |NVDA+backspace |none |မိမိအလုပ်လုပ်လိုသည့် Object ကို ရွေးချယ်၍ Object ကိုအလုပ်လုပ်ခိုင်းခြင်းဖြစ်သည်။|
|လက်ရှိ Object ကိုအလုပ်လုပ်ခိုင်းခြင်း |NVDA+numpadEnter |NVDA+enter |နှစ်ချက်မြန်မြန်နှိပ်ပါ |လက်ရှိရောက်နေသော Object ကို အလုပ်လုပ်ခိုင်းခြင်းသည် Mouse နှိပ်ခြင်း၊ Space Bar ကိုနှိပ်ခြင်းနှင့် အတူတူပင်ဖြစ်သည်။|
|မိမိရောက်ရှိနေသောနေရာ သို့မဟုတ် မိမိမြင်နေရသောနေရာမှရွှေ့ခြင်း |NVDA+shift+numpadMinus |NVDA+shift+backspace |none |နှစ်ခါနှိပ်ပါက လက်ရှိနေရာမှရွှေ့ခြင်းဖြစ်သည်။|
|Cursor ရောက်နေသောနေရာကိုဖော်ပြခြင်း |NVDA+numpadDelete |NVDA+delete |none |Mouse Cursor ရောက်ရှိနေသော စာသားသို့မဟုတ် ရောက်ရှိနေသောနေရာကို ဖော်ပြခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

မှတ်ချက်: Numlock  ကိုပိတ်ထားမှသာ အလုပ်လုပ်မည်။

### စာများကိုအသေးစိတ်ဖတ်ခြင်း {#ReviewingText}

NVDA သည် Screen Review , Object Review နှင့် Document Review များကို စာလုံးတစ်လုံးချင်းစီသော်လည်းကောင်း စကားစုလိုက်သော်လည်းကောင်း စာကြောင်းလိုက်သော်လည်းကောင်း Text Review ကိုသုံး၍ ဖတ်နိုင်သည်။
ဥပမာအားဖြင့် Message Box တွင်ပေါ်လာသော ရှည်လျားသည့်စာကြောင်းများကိုဖတ်နိုင်သည်။

Review ကာစာအား အသုံးပြုချိန်တွင် Mouse ကာစာ ရွေ့လျားခြင်းမရှိသောကြောင့် စာများပြင်ဆင်ထားခြင်းကို အနှောင့်အယှက်မဖြစ်နိုင်ပါ။
ပုံမှန်အားဖြင့် Mouse ကာစာ ရွေ့သောအခါ Review ကာစာပါလိုက်၍ ရွေ့သည်။
Review ကာစာအား အပိတ်အဖွင့်လုပ်နိုင်သည်။

မှတ်ချက် Brail တွင်လဲ Mouse ကာစာ ရွေ့ခြင်းအားဖြင့် Brail ကာစာလဲလိုက်၍ရွေ့သည်။
အကယ်၍ Object Review နှင့် Text Review ကိုသုံးလိုလျှင် Brail Tethered တွင် ပြင်ဆင်ရမည်။

Review Text Short Cut
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|အပေါ်စာကြောင်းသို့ရွေ့လိုလျှင် |shift+numpad7 |NVDA+control+home |none |အပေါ်လိုင်းမှ စာကြောင်းကိုဖတ်ခြင်းဖြစ်သည်။|
|ယခင်စာကြောင်းကိုရွေ့လိုလျှင်| numpad7 |NVDA+upArrow |flick up (text mode) |ယခင်စာကြောင်းကိုဖတ်ခြင်းဖြစ်သည်။||
|လက်ရှိစာကြောင်းကိုဖတ်ခြင်း |numpad8 |NVDA+shift+. |none |လက်ရှိစာကြောင်းကိုဖတ်ခြင်းဖြစ်သည်။ နှစ်ခါနှိပ်ပါက စာလုံးပေါင်းပြမည်။ သုံးခါနှိပ်ပါက စာလုံးအသံထွက်ကို ပြန်လည်ရှင်းပြမည်။|
|နောက်စာကြောင်းကိုရွေ့လိုလျှင် |numpad9 |NVDA+downArrow |flick down (text mode) |နောက်စာကြောင်းကိုဖတ်ပြခြင်းဖြစ်သည်။|
|အောက်စာကြောင်းကိုရွေ့လိုလျှင် |shift+numpad9 |NVDA+control+end |none |အောက်စာကြောင်းကိုဖတ်ပြခြင်းဖြစ်သည်။|
|ယခင်စကားစုကိုရွေ့လိုလျှင် |numpad4 |NVDA+control+leftArrow |2-finger flick left (text mode) |ယခင်စကားစုကိုဖတ်ပြခြင်းဖြစ်သည်။|
|လက်ရှိစကားစုကိုရွေ့လိုလျှင် |numpad5 |NVDA+control+. |none |လက်ရှိစကားစုကိုဖတ်ပြခြင်းဖြစ်သည်။ နှစ်ခါနှိပ်ပါက စာလုံးပေါင်းပြမည်။ သုံးခါနှိပ်ပါက စာလုံးအသံထွက်ကိုပြန်လည်ရှင်းပြမည်။|
|နောက်စကားစုကိုရွေ့လိုလျှင် |numpad6 |NVDA+control+rightArrow |2-finger flick right (text mode) |နောက်စကားစုကိုဖတ်ပြခြင်းဖြစ်သည်။|
|စာကြောင်းအစကိုရွေ့လိုလျှင် |shift+numpad1 |NVDA+home |none |စာကြောင်းအစကိုဖတ်ခြင်းဖြစ်သည်။|
|ယခင်စာလုံးကိုရွေ့လိုလျှင် |numpad1 |NVDA+leftArrow |flick left (text mode) |ယခင်စာလုံးကိုဖတ်ပြခြင်းဖြစ်သည်။|
|ယခုစာလုံးကိုသိလိုလျှင် |numpad2 |NVDA+. |none |ယခုစာလုံးကိုဖတ်ပြခြင်းဖြစ်သည်။ နှစ်ခါနှိပ်ပါက စာလုံးကိုဖတ်ပြသည်။ သုံးခါနှိပ်ပါက စကားလုံး၏တန်ဖိုးကိုဖတ်ပြသည်။|
|နောက်စာလုံးကိုရွေ့လိုလျှင် |numpad3 |NVDA+rightArrow |flick right (text mode) |နောက်စာလုံးကိုဖတ်ပြခြင်းဖြစ်သည်။|
|စာကြောင်းအဆုံးကိုရွေ့လိုလျှင် |shift+numpad3 |NVDA+end |none |လက်ရှိရှိနေသော ကာစာကို စာကြောင်းအဆုံးသို့ ရွေ့ခြင်းဖြစ်သည်။|
|စာကြောင်းအားလုံးကိုပြန်ဖတ်လိုလျှင် |numpadPlus |NVDA+shift+a |3-finger flick down (text mode) |လက်ရှိရောက်နေသောကာစာမှ စာကြောင်းများ၏အဆုံးထိဖတ်ပြခြင်းဖြစ်သည်။|
|ကော်ပီကူးယူထားသောစာကြောင်းအားဖတ်ပြခြင်း |NVDA+f9 |NVDA+f9 |none |ရွေးချယ်၍ကူးယူထားသောစာကြောင်းကိုဖတ်ပြခြင်းဖြစ်သည်။|
|ရွေးချယ်ထားသောစာကြောင်းကိုကူးယူခြင်း |NVDA+f10 |NVDA+f10 |none |ရွေးချယ်ထားသောစာကြောင်းကိုကူးယူခြင်းဖြစ်သည်။|
|Text Format ကိုဖော်ပြခြင်း |NVDA+f |NVDA+f |none |Internet Browser ပေါ်တွင်အသုံးပြုခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

မှတ်ချက်: numpad keys လိုအပ်သည် numlock key ပိတ်ထားရန်လိုအပ်သည်။

မှတ်မိရန်လွယ်ကူသောနည်းလမ်းမှာ Desktop Keyboard Layout တွင် သုံးလုံး တစ်တန်း မှတ်ထားရမည်။
The layout is illustrated as follows:

|Previous line |Current line |Next line|
|Previous word |Current word |Next word|
|Previous character |Current character |Next character|

### Review Modes {#ReviewModes}

Review Modes ရွေးချယ်ထားပေါ်မူတည်၍ လက်ရှိ Document အနေအထားကို ပြောင်းလဲနိုင်သည်။

Review Modes Short Cut များ:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Touch |Description|
|---|---|---|---|---|
|ရှေ့  Review Mode ကိုဖွင့်လိုလျှင် |NVDA+numpad7 |NVDA+pageUp |2-finger flick up |ရှေ့ Review Mode ကိုဖတ်ပြခြင်းဖြစ်သည်။|
|နောက်  Review Mode ကိုဖွင့်လိုလျှင် |NVDA+numpad1 |NVDA+pageDown |2-finger flick down |နောက်  Review Mode ကိုဖတ်ပြခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

#### Object Review {#ObjectReview}

Object Review Mode တွင် လက်ရှိ Object အတွင်းရှိစာများကို ဖတ်နိုင်သည်။ [navigator object](#ObjectNavigation).

#### Document Review {#DocumentReview}

 [navigator object](#ObjectNavigation) 
Document Review Mode ကို Browse Mode တွင်အသုံးပြုသည်။ ဥပမာ Web Page နှင့် အထူးဖန်တီးထားသော Document များတွင် အသုံးပြုခြင်းဖြစ်သည်။

Object review ကနေ document review ကိုပြောင်းသောအခါ၊ review curosr သည် document ၏ navigator object တွင်ရောက်ရှိနေမည်ဖြစ်သည်။
Review commands ဖြင့် document အတွင်းသွားလာသောအခါ navigator object သည် review cursor တည်နေရာတွင် တွေ့ရှိနိုင်သော object အနေထားသို့အလိုအလျှောက်ပြောင်းလဲသွားသည်။

မှတ်ချက် Document Review နှင့် Object Review ကို NVDA သည် အလိုလျှောက်ပြောင်းလဲ​ပေးခြင်းဖြစ်သည်။

#### Screen Review {#ScreenReview}

Screen Review Mode တွင် လက်ရှိရှိနေသော အက်ပလီကေးရှင်းကို ဖတ်ရုံသာမက မိမိရွေ့သည့်နေရာများကိုလဲဖတ်ပြသည်။

Screen review mode ကိုပြောင်းသောအခါ review cursor သည် [navigator object](#ObjectNavigation) ပေါ်တွင် ကျရောက်နေမည်ဖြစ်ပါသည်။
Review commands ဖြင့်ကွန်ပျုတာမျက်နှာပြင်တစ်လျှောက်သွားလာသောအခါ review cursor မှာတွေ့ရသော object သည်အလိုအလျောက် update ဖြစ်သွားမည်ဖြစ်ပါသည်။

မှတ်ချက် အချို့သော ထပ်မံထွက်လာသော အက်ပလီကေးရှင်းအသစ်များ သို့မဟုတ် Drawing Technology  ကိုအသုံးပြုထားသော ဆော့ဝဲများတွင် NVDA သည် လတ်တလောမဖတ်နိုင်သေးပါ။

### Mouse ဖြင့်သွားလားခြင်း {#toc41}

NVDA သည် Mouse ရွေ့သောအခါ Mouse ကာစာရောက်ရှိနေသောနေရာကိုဖတ်ပြသည်။

NVDA တွင်ပြင်ဆင်နိုင်သည်  [object](#Objects) ဥပမာ List နှင့် Button 
၎င်းသည်မျက်မမြင်များအတွက်အသုံးဝင်သည်။သို့သော်လဲ တစ်ခါတစ်ရံလုံလောက်မှုမရှိပါ။

NVDA တွင် Mouse ရွေ့သည့်အခါ ဘယ် ညာ ခွဲနိုင်ရန် အသံထည့်သွင်းနိုင်သည်။ နားကြပ် သို့မဟုတ် ဘယ်သံ ညာသံ ခွဲနိုင်သော စပီကာ တစ်စုံ လိုအပ်သည်။

၎င်း Exter Mouse Features ကို အလိုလျောက် မထည့်သွင်းထားပေးပါ။ အကယ်၍ သင်သုံးလိုလျှင် NVDA ၏[Mouse settings](#MouseSettings) တွင်သွားရောက်ထည့်သွင်းနိုင်သည်။

Mouse ၏ Short Cut keys:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Mouse ၏ ဘယ်လက်ခလုတ်ကိုနှိပ်လိုလျှင် |numpadDivide |NVDA+[ |နှစ်ချက်နှိပ်ပါက ရွေချယ်ထားသော အရာကို အလုပ်လုပ်ခြင်းဖြစ်သည်။|
|Mouse ၏ ဘယ်ဘက်ခလုတ်ကို Lock လုပ်လိုလျှင် |shift+numpadDivide |NVDA+control+[ |တစ်ကြိမ်နှိပ်ပါက Lock လုပ်မည် ၊ နောက်တစ်ကြိမ်နှိပ်ပါက Unlock လုပ်မည်။|
|Mouse ၏ ညာဘက်ခလုတ်ကိုနှိပ်လိုလျှင် |numpadMultiply |NVDA+] |ညာဘက်ခလုတ်ကို တစ်ကြိမ်နှိပ်ပါ။|
|Mouse ၏ ညာဘက်ခလုတ်ကို Lock လုပ်လိုလျှင် |shift+numpadMultiply |NVDA+control+] |တစ်ကြိမ်နှိပ်ပါက Lock လုပ်မည် ၊ နောက်တစ်ကြိမ်နှိပ်ပါက Unlock လုပ်မည်။|
|လက်ရှိရောက်နေသော object ထဲရွေ့လိုလျှင် |NVDA+numpadDivide |NVDA+shift+m |လက်ရှိရောက်နေသော Mouse ကာစာကိုဖတ်ပြခြင်းဖြစ်သည်။|
|Object အတွင်းတွင်ရွေ့လိုလျှင် |NVDA+numpadMultiply |NVDA+shift+n |Mouse ရောက်ရှိနေသောနေရာကို ဖတ်ပြခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

1. Browse Mode +[BrowseMode အနေထား]
ရှုပ်ထွေးသော Document များဖြစ်သော Web Page များတွင် Browse Mode ကိုအသုံးပြုသည်။
၎င်းတွင်ပါဝင်သော Document များမှာ Mozilla Firefox, Microsoft Internet Explorer, Mozilla Thunderbird, HTML Messages, Microsoft Outlook, Google Crome, Adobe Reader နှင့် Adobe Flash တို့ဖြစ်သည်။
Browse Mode သည် Microsoft Word တွင်လဲအလုပ်လုပ်သည်။

ပုံမှန် Document များတွင် ပုံမှန် ကာစာ Key များဖြင့်ရွေ့နိုင်သော်လည်း Browse Mode Document များတွင် NVDA မှသတ်မှတ်ထားသော key များဖြင့်ပါရွေ့နိုင်သည်။ ဥပမာ say all, report formatting, table navigation commands, etc.
All of NVDA's [system caret](#SystemCaret) key commands will work in this mode;
link နှင့် heading တို့ကိုလဲရွေ့နိုင်သည်။

တစ်ခါတစ်ရံတွင် Mode များကို ပြောင်းလဲအသုံးပြုရမည်။

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Toggle browse/focus modes |NVDA+space |Toggles mode နှင့် Browse mode ကိုပြောင်းလဲခြင်းဖြစ်သည်။|
|Focus mode ကိုပိတ်ခြင်း |escape |Focus mode ကိုပိတ်သည်နှင့် Browse mode ပြောင်းလဲသွားသည်။|
|Browse mode document များကို Refresh ပြုလုပ်ခြင်း |NVDA+f5 |လက်ရှိရှိနေသော document များတွင် Link အသစ်များကိုထပ်မံဖော်ပြခြင်းဖြစ်သည်။(Microsoft နှင့်Outlook တွင် အသုံးမပြုနိုင်ပါ။)|
|ရှာဖွေခြင်း |NVDA+control+f |ရှာဖွေသည့် Dialog  Box ပေါ်လာသောအခါ စာလုံးအချို့ရိုက်၍ လက်ရှိ Document အတွင်းရှိ အချက်လက်များကိုရှာဖွေနိုင်သည်။|
|ထပ်မံရှာဖွေခြင်း |NVDA+f3 |လက်ရှိ Document အတွင်းရှိ ရှာဖွေခဲ့သည့်စာသားများအားထပ်မံရှာဖွေခြင်းဖြစ်သည်။|
|ယခင်အချက်လက်များပြန်လည်ရှာဖွေခြင်း |NVDA+shift+f3 |ယခင်ရှာဖွေခဲ့သည့် အချက်လက်များကို ပြန်လည်ရှာဖွေခြင်းဖြစ်သည်။|
|အဓိပ္ပါယ်ဖော်ပြချက်အရှည်ကိုသိလိုလျှင် |NVDA+d |မည်သည့်နေရာတွင်ရောက်ရှိနေသည်အပါအဝင် အချက်လက်အတော်များများကို ဖတ်ပြခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

### အက္ခရာများဖြင့်ရွေ့ခြင်း {#toc42}

Browse Mode တွင် အက္ခများဖြင့်မြန်မြန်ဆန်ဆန်ရွေ့နိုင်သည်။
မှတ်ချက် Document အပိုင်းတွင်မရွေ့နိုင်ပါ။

<!-- KC:beginInclude -->
သတ်မှတ်ထားသော keys များသည် နှိပ်ပါက အရှေ့သို့ရွေ့လျားပြီး Shift ဖြင့်တွဲနှိပ်ပါက ယခင်နေရာများသို့ပြန်လည်ရွေ့မည် :

* h: heading
* l: list
* i: list item
* t: table
* k: link
* n: nonLinked text
* f: form field
* u: unvisited link
* v: visited link
* e: edit field
* b: button
* x: checkbox
* c: combo box
* r: radio button
* q: block quote
* s: separator
* m: frame
* g: graphic
* d: landmark
* o: embedded object
* 1 to 6: headings at levels 1 to 6 respectively
* a: annotation (comment, editor revision, etc.)

lists and tables များကိုအစနှင့်အဆုံးရွေ့လိုလျှင် :

| Name |Key |Description|
|---|---|---|
|ကွန်တိန်နာ၏အစကိုရွေ့ခြင်း |shift+comma |Table သို့မဟုတ် List ၏အစကို ရွေ့ခြင်းဖြစ်သည်။|
|ကွန်တိန်နာ၏အဆုံးသို့ရွေ့ခြင်း |comma |Table သို့မဟုတ် List ၏အဆုံးကို ရွေ့ခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->
အချို့သော အင်တာနက် အက်ပလီကေးရှင်းများဖြစ်သော Gmail, Twitter နှင့် Facebook တွင် အလုပ်မလုပ်လိုလျှင်
<!-- KC:beginInclude -->
အက္ခရာများဖြင့် ရွေ့ခြင်း အဖွင့် နှင့် အပိတ် NVDA+shift+space.
<!-- KC:endInclude -->

### လင့် မျာ့ကို List လုပ်ခြင်း {#toc43}

လင့်များကို List လုပ်ခြင်းတွင် မတူညီသော လင့် အမျိုးမျိုးကို List လုပ်ပေးသည်။
ဥပမာ Web Browser တွင် လင့်များကို List လုပ်ပေးပြီး Heading သို့မဟုတ် Landmarks ခွဲခြားနိုင်သည်။
Radio buttons သည်လဲ Element တစ်ခုဖြစ်သည်။
စာရိုက်သည့်နေရာကိုလဲ မည်မျှပါဝင်သည်ကို ရှာဖွေနိုင်သည်။
သင်သည်တစ်ခုကိုရွေးချယ်၍ အလုပ်လုပ်နိုင်သည်။
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Browse mode elements list |NVDA+f7 |လက်ရှိရောက်နေသော Document အတွင်းရှိ လင့်အမျိုးမျိုးကို List လုပ်နိုင်သည်။|

<!-- KC:endInclude -->

### Embedded Objects {#toc44}

Adobe Flash နှင့် အချို့သော Java applications များတွင် Embedded Object သို့မဟုတ် dialogs 
သင့်အနေဖြင့် Enter ကိုနှိပ်နိုင်သည်။
အကယ်၍ အဆင်ပြေပြေသုံးလို့ရလျှင် အခြား အက်ပလီကေးရှင်းများကဲ့သို့ သုံးနိုင်သည်။
keys များသည် မူလ Page တွင်ဖော်ပြပြီးသားဖြစ်သည် :
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Browse mode document တွင် ရွေ့လိုလျှင် |NVDA+control+space |Document အတွင်းရှိ Embedded Objects မှ တခြား Embedded Objects သို့ရွေ့ခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

## သင်္ချာဖတ်ခြင်းနှင့်ဆိုင်သော {#toc45}

NVDA သည် MathPlayer 4 တွင် ဖတ်လဲဖတ်နိုင်သည် ရွေ့လဲ ရွေ့လျားနိုင်သည်။
လိုအပ်ချက်အနေဖြင့် MathPlayer 4 ထည့်သွင်းထားရန်လိုအပ်သည်။
MathPlayer ကို အခမဲ့ ရယူနိုင်သည် : https://www.dessci.com/en/products/mathplayer/

NVDA သည် ဖော်ပြထားသော သင်္ချာနှင့်ဆိုင်သော ဆော့ဝဲများပေါ်တွင် အလုပ်လုပ်သည် :

* Mozilla Firefox နှင့် Microsoft Internet Explore တွင် MathML
* Microsoft Word နှင့် PowerPoint တွင် Design Science MathType ထည့်သွင်းထားရန်လိုအပ်သည်။
* Adobe Reader တွင် MathML မှတ်ချက်အနေဖြင့် ၎င်းသည် တရားဝင်သုံးနိုင်ခြင်းမရှိပါ။

NVDA သည် သင်္ချာနှင့်ဆိုင်သော သင်္ကေတများကို Document ပေါ်တွင် ဖတ်သည်။
အကယ်၍ Brail Display သုံးလျှင်လဲ Display ပေါ်တွင်ဖော်ပြသည်။

### Navigation အပြန်အလှန်အကျိုးသက်ရောက်စေခြင်း {#toc46}

အကယ်၍သင်သည် speech အားအထူးအသုံးပြုအက စာကြောင်းတစ်ခုလုံးအား အသံထွက်တစ်ညီတည်း ဖတ်ခြင်းထက် စာကြောင်း၏ အဖြတ်အတောက်နှင့်အညီ အသံထွက်ပီသစွာဖတ်ပြခြင်းအား အသုံးပြုလိုပါလိမ့်မည်။

အကယ်၍သင်သည် browse mode အနေထား၌ရှိနေပါက ဤလုပ်ဆောင်ချက်အား mathematical content (သင်္ချာကိန်းဂဏန်းဆိုင်သောအကြောင်းအရာ)ဘက်သို့ cursor အားရွေ့ပြီး enter နိပ်နိုင်ပါသည်။

Browse mode အနေထားဖြင့်မဟုတ်ပါက-

1. Review cursor အား သင်္ချာကိန်းဂဏန်းဆိုင်သောအကြောင်းအရာ များဘက်သို့ရွေ့ပါ။
ပုံမှန်အားဖြင့် review cursor သည် system caret (စာကျကြောင်းပြ အမှတ်အသား)၏နှောက်တို့လိုက်ခြင်းအကြောင်း ကိုယ်သွားလိုသောနေရာများဆီသို့ system caret အသုံးပြု၍ သွားရောက်နိုင်ပါသည်။
1. ထို့နှောက် အောက်ပါ command များအားအသုံးပြုပါ-

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Interact with math content |NVDA+alt+m |Begins interaction with math content.|

<!-- KC:endInclude -->

ဤအခြေအနေ၌ သင် MathPlayer commands (ဉပမာအားဖြင့် arrow keys) များအသုံးပြု၍ expression များအားလေ့လာအသုံပြုနိုင်ပါသည်။
ဉပမာအားဖြင့် သင် expression များကြားတွင် ဘယ်၊ညာ မြားခလုပ်ဖြင့်သွားနိုင်ပြီး အပိုင်းကိန်းများအား down arrow ခလုပ်ဖြင့်မြင်ကွင်းချဲ့ကာ ကြည့်ရှုနိုင်ပါသည်။  
ဆက်စပ်အကြောင်းအရာများအား လေ့လာလိုပါက MathPlayer ၏ documentation ကိုဖတ်ရှုနိုင်ပါသည်။

Document ဆီသို့ ပြန်လည်သွားရောက်လိုပါက escape ကိုနိပ်ပါ။

## Application ၏သီးခြားလုပ်ဆောင်ချက်များ {#toc47}

အချို့သော applicaitons များအားအသုံးပြုရာ၌ screen reader users များအတွက်မိုလွယ်ကူမြန်ဆန်စေရန်အတွက်နှင့်  သီးခြားလုပ်ဆောင်ချက်များအား ထောက်ပံ့ပေးပါသည်။

### Microsoft Word {#toc48}
#### Column နှင့် Row များကို အလိုလျှောက်ဖတ်ခြင်း {#toc49}

NVDA သည် ကာစာများကို ရွေ့သောအခါ Microsoft ပေါ်တွင် Column နှင့် Row များကို အလိုလျှောက်ဖတ်သည်။
ပထမ လိုအပ်ချက်မှာ NVDA Setting ထဲရှိ Document Formatting တွင် Column နှင့် Row များကိုအမှန်ခြစ်ထားပေးရန်လိုအပ်သည်။
ဒုတိယအနေဖြင့် NVDA သည် Table တွင် ပါသော Column နှင့် Row များကို သိရှိသည်။
Tabel အတွက် Short Cut များ:
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Column ထည့်သွင်းခြင်း |NVDA+shift+c |တစ်ကြိမ်နှိပ်ရုံဖြင့် NVDA သည် Column ထည့်ပြီးကြောင်းပြောလိမ့်မည်။ နှိပ်ကြိမ်နှိပ်လျှင် Column ပြန်ဖြုတ်မည်။|
|Row ထည့်သွင်းခြင်း |NVDA+shift+r |တစ်ကြိမ်နှိပ်ရုံဖြင့် NVDA သည် Row ထည့်ပြီးကြောင်းပြောလိမ့်မည်။ နှိပ်ကြိမ်နှိပ်လျှင် Row ပြန်ဖြုတ်မည်။|

<!-- KC:endInclude -->
၎င်း Setting သည် Document ထဲတွင် ထည့်သွင်းပြီးသားဖြစ်ပြီး အခြား Screen Reader များကပါဖတ်နိုင်သည်။

#### Browse Mode in Microsoft Word {#toc50}

Microsoft တွင်ပါဝင်သော Browse mode သည် Web တွင်ပါသော Browse Mode နှင့် အတူတူပင်ဖြစ်သည်။
<!-- KC:beginInclude -->
Browse mode ကို Microsoft Word တွင် အပိတ် အဖွင့် လုပ်လိုလျှင် NVDA+space ကိုနှိပ်ပါ။
<!-- KC:endInclude -->
အသေးစိတ်သိရှိလိုလျှင် [Browse Mode section](#BrowseMode) တွင် သွားရောက်လေ့လာပါ။

##### Elements List အကြောင်း {#toc51}

<!-- KC:beginInclude -->
Microsoft Word Browse mode တွင် List လုပ်လိုလျှင် NVDA+f7 ကိုနှိပ်ပါ။
<!-- KC:endInclude -->
၎င်းသည် Heading Link နှင့်  Annotations များကို တစုတစည်းတည်း ပြုလုပ်ပေးနိုင်သည်။

#### Comments များအားတင်ပြစေခြင်း {#toc52}

<!-- KC:beginInclude -->
Character ရှိနေသည့်အနေထားကို သိလိုလျှင် NVDA+alt+c ကိုနှိပ်ပါ။
<!-- KC:endInclude -->
Document တွေနှင့် အခြားအပြောင်းအလဲများအတွက် comments တွေသည် NVDA ၏ Elements list တွင်ပေါ်လာရန်အတွက် စာရိုက်ရင်းနှင့် မှတ်စုများကိုမှတ်သားနိုင်သည်။

### Microsoft Excel {#toc53}
#### Column နှင့် Row များကို အလိုလျှောက်ဖတ်ခြင်း {#toc54}

NVDA သည် ကာစာများကို ရွေ့သောအခါ Excel Worksheeds ပေါ်တွင် Column နှင့် Row များကို အလိုလျှောက်ဖတ်သည်။
ပထမ လိုအပ်ချက်မှာ NVDA Setting ထဲရှိ Document Formatting တွင် Column နှင့် Row များကိုအမှန်ခြစ်ထားပေးရန်လိုအပ်သည်။
ဒုတိယအနေဖြင့် NVDA သည် Table တွင် ပါသော Column နှင့် Row များကို သိရှိသည်။
Tabel အတွက် Short Cut များ:
<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Column ထည့်သွင်းခြင်း |NVDA+shift+c |တစ်ကြိမ်နှိပ်ရုံဖြင့် NVDA သည် Column ထည့်ပြီးကြောင်းပြောလိမ့်မည်။ နှိပ်ကြိမ်နှိပ်လျှင် Column ပြန်ဖြုတ်မည်။|
|Row ထည့်သွင်းခြင်း |NVDA+shift+r |တစ်ကြိမ်နှိပ်ရုံဖြင့် NVDA သည် Row ထည့်ပြီးကြောင်းပြောလိမ့်မည်။ နှိပ်ကြိမ်နှိပ်လျှင် Row ပြန်ဖြုတ်မည်။|

<!-- KC:endInclude -->
၎င်း Setting သည် Document ထဲတွင် ထည့်သွင်းပြီးသားဖြစ်ပြီး အခြား Screen Reader များကပါဖတ်နိုင်သည်။

#### The Elements List {#toc55}

Microsoft Excel တွင်ပါဝင်သော Browse mode သည် Web တွင်ပါသော Browse Mode နှင့် အတူတူပင်ဖြစ်သည်။
<!-- KC:beginInclude -->
Excel တွင်Elements List  များကို စုစည်းလိုလျှင် NVDA+f7 ကိုနှိပ်ပါ။
<!-- KC:endInclude -->
Elements List တွင် List မျိုးစုံပါဝင်သည် :

* Charts: Charts အားလုံးသည် Worksheet  တွင်အလုပ်လုပ်သည်။
Chart ကို Arrow ဖြင့် ရွေ့နိုင်ပြီး Enter ဖြင့်ရွေးချယ်နိုင်သည်။
* Comments: ၎င်း Cell များသည် Worksheet ပေါ်တွင်အလုပ်လုပ်သည်။ 
Cell တစ်ခုစီတွင် တစ်ခုစီ တစ်ခုစီဖော်ပြသည်။ 
Enter နှိပ်၍ သို့မဟုတ် Cell တစ်ခုစီကိုရွေ့နိုင်သည်။
* Formulas: Cell တိုင်းတွင် Formula ပါဝင်သည်။ 
Cell တစ်ခုစီ တစ်ခုစီ တွင် Formula ပါဝင်သည်။
Enter နှိပ်၍ သို့မဟုတ် Formula ကို Cell များတွင့် ရွေ့နိုင်သည်။ 
* Sheets: Workbook ထဲတွင် Sheet များပါဝင်သည်။ 
F2  ကိုနှိပ်၍ sheet ကို နာမည်ပြောင်းနိုင်သည်။ 
Enter နှိပ်၍ သို့မဟုတ် ရွေ့၍လဲ Sheet များကို ဖွင့်နိုင်သည်။
* Form fields: Active worksheet တွင် Formfield များပါဝင်သည်။
Element List ထဲတွင် Formfield တစ်ခုစီကိုဖော်ပြသည်။
Browse Mode တွင် Formfield ကို ရွေးချယ်နိုင်ပြီး Enter နှိပ်၍ သို့မဟုတ် တစ်ခုစီရွေ့ကြည့်နိုင်သည်။

#### Reporting Comments {#toc56}

<!-- KC:beginInclude -->
လက်ရှိရောက်နေသော Cell ကိုသိလိုလျှင် NVDA+alt+c ကိုနှိပ်ပါ။
<!-- KC:endInclude -->
Worksheet အတွင်းရှိ NVDA Element List တွင် ၎င်းကိုအသုံးပြုနိုင်သည်။

#### Reading Protected Cells {#toc57}

အကယ်၍ Workbook ကို Protected လုပ်ထားလျှင် သက်ဆိုင်ရာ Cell များသို့ရွေ့လို့မရပါ။
<!-- KC:beginInclude -->
Block Cell များကို ရွေ့လိုလျှင် NVDA+space ကိုနှိပ်ပါ ပြီးလျင် ပုံမှန်အတိုင်း ရွေ့နိုင်ပါသည်။
<!-- KC:endInclude -->

#### Form Fields {#toc58}

Excel worksheets တွင် form fields ပါဝင်သည်။
သင့်အနေဖြင့် Elements List လုပ်၍ သို့အဟုတ် f နှင့် shift+f ကိုသုံး၍ ရွေ့နိုင်သည်။
Browse Mode တွင် Formfield ကိုရွေ့သောအခါ Enter နှိပ်၍ သို့မဟုတ် Space နှိပ်ပြီးအလုပ်လုပ်နိုင်သည်။
အသေးစိတ်အချက်လက်များကို [Browse Mode section](#BrowseMode) တွင် လေ့လာနိုင်သည်။

### Microsoft PowerPoint {#toc59}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Toggle speaker notes reading |control+shift+s |Slide Show Run နေစဉ်အတွင်း Effect များကို ဖတ်ပြခြင်းဖြစ်သည်။Screen ပေါ်က စာသားများကိုဖတ်ပြခြင်းမဟုတ်ပါ။|

<!-- KC:endInclude -->

### foobar2000 {#toc60}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Report remaining time |control+shift+r |လက်ရှိ ဖွင့်ထားသော Track ၏ ရောက်နေသည့်အချိန်ကိုဖော်ပြခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

မှတ်ချက်: ၎င်းသည် Foobar ပေါ်တွင်သာအလုပ်လုပ်သည်။

### Miranda IM {#toc61}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Message ကိုသိလိုလျှင်| NVDA+control+1-4 |တွဲနှိပ်သည့် ဂဏာန်းပေါ်မူတည်၍ Message များကိုဖတ်ပြသွားမည်။ ဥပမာ  NVDA+control+2 ဖြင့်နှိပ်ပါက ဒုတိယ Message ကိုဖတ်ပြလိမ့်မည်။|

<!-- KC:endInclude -->

### Poedit {#toc62}

<!-- KC:beginInclude -->

| Name |Key |Description|
|---|---|---|
|Report Comments Windows |control+shift+c |Reports any comments in the comments Windows.|
|Report notes for translators |control+shift+a |Reports any notes for translators.|

<!-- KC:endInclude -->

### Skype {#toc63}

<!-- KC:beginInclude -->
Conversation တွင်:

| Name |Key |Description|
|---|---|---|
|Message ဖတ်ခြင်း |NVDA+control+1-0 |တွဲနှိပ်သည့် ဂဏာန်းပေါ်မူတည်၍ Message များကိုဖတ်ပြသွားမည်။ ဥပမာ  NVDA+control+2 ဖြင့်နှိပ်ပါက ဒုတိယ Message ကိုဖတ်ပြလိမ့်မည်။|

<!-- KC:endInclude -->

### PC အတွက် Kindle {#toc64}

NVDA သည် Kindle for PC  ပေါ်တွင်လဲ အလုပ်လုပ်သည်။
၎င်း Function များသည် Kindle for PC ပေါ်တွင်သာ အလုပ်လုပ်သည်။

စာအုပ်ဖတ်ရန်အတွက် Browse mode ကိုသုံးသည်။
၎င်းသည် ရွေးချယ်ထားသော နေရာပေါ်မူတည်၍ အလိုလျှောက်ဖတ်သည်။
<!-- KC:beginInclude -->
စာရွက်များကို မိမိကိုယ်တိုင် လှန်လိုလျှင် Page Up Page Down Key ကို သုံးပါ။
<!-- KC:endInclude -->

Single letter များကိုသုံး၍လဲ Link နှင့် Graphics များကိုရွေ့နိုင်သည် သို့သော် လက်ရှိရောက်နေသော Page ပေါ်တွင်သာဖြစ်သည်။

#### စာများရွေးချယ်ခြင်း {#toc65}

Kindle တွင် များစွာသော Selecte လုပ်နိုင်သည့် Function များပါဝင်သည်။ Browse Mode တွင် Shift+Cursor(Arrow) Key များ ရွေးချယ်နိုင်သည်။
<!-- KC:beginInclude -->
ရွေးချယ်ထားသောစာများကို အက်ပလီကေးရှင်းကီး သို့မဟုတ် Shift+F10 နှိပ်ပါက လုပ်ဆောင်နိုင်သည့်အလုပ်များကိုတွေ့နိုင်သည်။
<!-- KC:endInclude -->
အကယ်၍ ရွေးချယ်ထားသောစာမရှိဘဲ အက်ပလီကေးရှင်းကီး သို့မဟုတ် Shift+F10 နှိပ်ပါက လုပ်ဆောင်နိုင်သည့် လုပ်ဆောင်ချက်များကိုဖော်ပြထားမည်။

#### User Notes {#toc66}

မှတ်စုနှင့် စာပိုဒ်များကို သင်ရေးမှတ်နိုင်ပါသည်။
ပထမဦးစွာ မိမိနှင့်သက်ဆိုင်သော Text ကိုရွေးချယ်ပါ။
ပြီးနောက် မိမိဖော်ပြလိုသည့်အကြောင်းရာဖော်ပြပါ။

NVDA Browse Mode တွင်၎င်းတို့ကိုဖတ်နိုင်သည်။

မှတ်စုကိုကြည့်ရန် ၊ ပြင်ရန်နှင့်ဖြတ်ရန်:

1. ကာစာကို မှတ်စုထဲတွင်ရွေ့ပါ။
1. Option ထဲတွင် ရွေးချယ်ပါ။
1. ရွေးချယ်ထားတာကိုပြင်ပါ။

## NVDA  ပြင်ဆင်ခြင်း {#toc67}
### ပြင်ဆင်ခြင်း {#toc68}

<!-- KC:settingsSection: || Name | Desktop key | Laptop key | Description | -->
NVDA အတော်များများတွင် settings များကိုပြင်ဆင်နိုင်သည်။ 
Preferences sub-menu ထဲတွင် ပြင်ဆင်ပြီးလျှင် OK နှိပ်ပါ။ 
မပြင်ဆင်လိုလျှင် Escape Key  ဖြင့်ပြန်ထွက်ပါ။
အချို့ Setting များကို Short Cut Key ဖြင့်ပြင်ဆင်နိုင်သည်။

မှတ်ချက် အားလုံးကို Short Cut Key ဖြင့် မပြင်ဆင်နိုင်ပါ။
[Input Gestures dialog](#InputGestures)

#### General Settings (NVDA+control+g) {#toc69}

Preferences menu ထဲတွင် General Settings  ကို ရှာဖွေနိုင်သည်။
ပါဝင်သော options များမှာ:

##### ဘာသာစကား {#toc70}

Combo Box ထဲတွင် Message နှင့် Interface များ ရွေးချယ်နိုင်သည်။
အလိုလျောက်အနေဖြင့် User Default ကိုရွေးချယ်ထားသည်။
မည်သည့် ဘာသာစကားရွေးချယ်ထားခြင်းကို ၎င်း Option က ဖော်ပြပါလိမ့်မည်။

NVDA ကို restart မဖြစ်မနေလုပ်ပေးရမည်။
အကယ်၍ Restart လုပ်မည်ဆိုလျှင် NVDA က ရွေးချယ်ထားတဲ့အရာကို ပြောင်းလဲပေးပါလိမ့်မည်။
OK ကိုနှိပ်ပါ NVDA restart ဖြစ်သွားပါလိမ့်မည်။

##### NVDA ပိတ်သည်နှင့် မိမိ Setting များကို Save ခြင်း {#toc71}

NVDA ကို ပိတ်သည်နှင့် အလိုလျှောက် Save လိုလျှင် Save Configuration on exit ကို အမှန်ခြစ်ပေးရမည်။

##### NVDA ပိတ်သောအခါတွင် {#toc72}

NVDA ပိတ်သောအခါ မည်သည့်အရာမှ မမေးစေလိုလျှင် Show exit options when exiting NVDA ကို အမှန်ခြစ်ဖြုတ်ပေးရမည်။

##### NVDA အဖွင့် နှင့် အပိတ်မှာ အသံမြည်လိုလျှင် {#toc73}

NVDA စတင်သောအခါနှင့် ပိတ်သောအခါအသံထွက်မည်လား(Play sounds when it starts or exits NVDA)ကိုအမှန်ခြစ်ပေးရမည်။

##### Logging level {#toc74}

မိမိလိုချင်သော Logging စနစ်ကို Combo Box တွင်ရွေးရမည်။

##### အလိုလျှောက် NVDA ဖွင့်ခြင်း {#toc75}

Automatically start NVDA after I log on to Windowss ကိုအမှန်ခြစ်ထားခြင်းဖြင့် Windows တက်သည်နှင့်အလုပ်လုပ်သည်။
Install လုပ်ထားသော NVAD တွင်သာအလုပ်လုပ်နိုင်သည်။

##### Windows တက်သည်နှင့် Logon Screen တွင် NVDA ကိုဖတ်လိုလျှင် {#toc76}

Logon အနေထားတွင် NVDA အားအသုံးပြမည်(Use NVDA on the Windows Logon Screen) (require administrator privileges) ကိုအမှန်ခြစ်ထားရမည်။
Install လုပ်ထားသော NVAD တွင်သာအလုပ်လုပ်နိုင်သည်။

##### မိမိပြုလုပ်ထားသော Setting များကို အခြား အကောင့်များတွင်အလုပ်လုပ်လိုလျှင် {#toc77}

ကွန်ပျုတာ logon နှင့် secure screens အနေထားများတွင် လက်ရှိပြင်ဆင်ထားသော settings အားအသုံးပြုမည်(Use currently saved settings on the logon and other secure screens (requires administrator privileges)ကိုနှိပ်ပေးရမည်။
Install လုပ်ထားသော NVAD တွင်သာအလုပ်လုပ်နိုင်သည်။

##### အလိုလျောက် Update စစ်ဆေးပေးခြင်း {#toc78}

Automatically check for updates to NVDA ကိုအမှန်ခြစ်ထားပေးရမည်။
Install လုပ်ထားသော NVAD တွင်သာအလုပ်လုပ်နိုင်သည်။

#### Synthesizer ရွေးချယ်ခြင်း(NVDA+control+s) {#toc79}

Short Cut ကိုနှိပ်သောအခါ ရွေးချယ်နိုင်သော Synthesizer များပေါ်လာမည်။ မိမိကြိုက်နှစ်သက်ရာကိုရွေး၍ OK ကိုနှိပ်ပါ။

##### Synthesizer {#toc80}

Synthesizer ရွေးသည့် Setting ထဲတွင် မိမိထားလိုသည့် Out put ကိုရွေးနိုင်သည်။

NVDA သည် မည်သည့် Synthesizer များဖြင့်တွဲဖက်အလုပ်လုပ်သည်ကို [Supported Speech Synthesizers](#SupportedSpeechSynths) တွင် သွားရောက်လေ့လာနိုင်သည်။

၎င်း Setting တွင် Low Speech ကိုလဲရွေးချယ်နိုင်သည်။
Brail Display အသုံးပြုသူများအတွက် အသုံးဝင်သည်။

##### Output device {#toc81}

မည်သည့် Sound Card ဖြင့် အသုံးပြုမည်ကိုရွေးချယ်နိုင်သည်။

<!-- KC:setting -->

##### Audio Ducking Mode {#toc82}

Key: NVDA+shift+d

NVDA အသံမှလွဲ၍ အခြားအသံများကိုတိုးပေးသည်။
-

Install လုပ်ထားသော NVAD တွင်သာအလုပ်လုပ်နိုင်သည်။
Portable Version တွင် အသုံးမပြုနိုင်ပါ။

#### Voice Settings ကို အသုံးပြုလိုလျှင်(NVDA+control+v) {#VoiceSettings}

Preferences ထဲတွင်လဲရှာဖွေနိုင်သည်။
အသံသွားနူန်းသတ်မှတ်ချက်တွေကို ဘယ်နေရာရောက်ရောက်လွယ်ကူမြန်ဆန်စွထိန်းချုပ်လိုပါက[Synth Settings Ring](#SynthSettingsRing) အခန်းဂဏ္တွတွင်ကြည့်ရှု့နိုင်ပါသည်။ 

Voice Settings ထဲတွင် ပါဝင်သော options များ:

##### Voice {#toc84}

ပထမ Dialog Box ထဲတွင် Arrow ခလုတ်ဖြင့်အသံများရွေးချယ်နိုင်သည်။

##### Variant {#toc85}

အကယ်၍ E speech Engine ကိုအသုံးပြုလျှင် Female နှင့် Male ကိုရွေးချယ်နိုင်သည်။

##### Rate {#toc86}

၀ သည်အနှေးဆုံးဖြစ်၍ ၁၀၀ သည်အမြန်ဆုံးဖြစ်သည်။

##### Pitch {#toc87}

၀ သည်အသံအနှိမ့်ဆုံးဖြစ်၍ ၁၀၀ သည်အသံအမြင့်ဆုံးဖြစ်သည်။

##### Volume {#toc88}

၀ သည်အသံအတိုးဆုံးဖြစ်၍ ၁၀၀ သည်အသံအကျယ်ဆုံးဖြစ်သည်။

##### Inflection {#toc89}

စကားပြောသည့် ပုံစံကို အပြောင်းအလဲ ပြုလုပ်ခြင်းဖြစ်သည်။

##### Language ကိုအလိုအလျောက်ပြောင်းလဲပေးခြင်းဖြစ်သည် {#toc90}

Automatic Language Switching (When Supported) ကို အမှန်ခြစ်ထားလျှင် Language ကိုအလိုလျောက်ပြောင်းလဲပေးသည်။ NVDA Settion တွင် အမှန်ခြစ်ပြီးသားဖြစ်သည်။

##### Automatic Language Switching {#toc91}

Automatic Language Switching (When Supported) ကို အမှန်ခြစ်ထားလျှင် ဘာသာစကားကိုအလိုလျောက်ပြောင်းလဲပေးသည်။
ဥပမာ မိမိအသုံးပြုသော ဘာသာစကားသည် US English ဖြစ်ပါက UK English ကိုဖတ်သောအခါတွင်လဲ US English အသံသို့ အလိုလျောက်ပြောင်းပေးသည်။

<!-- KC:setting -->

##### Punctuation/Symbol Level {#toc92}

Key: NVDA+p

Punctuation များကိုအပြည့်အစုံဖတ်ခြင်း သို့မဟုတ် လိုအပ်သည့် Punctuation များကိုသာဖတ်ခြင်း တို့ကို ရွေးချယ်နိုင်သည်။

##### (punctuation)သင်္ကေတနှင့် အက္ခရာများအတွက် သင့်လျော်သောဘာသာစကား {#toc93}

ပုံမှန်အားဖြင့် ဤလုပ်ဆောင်ချက်သည် NVDA အား လက်ရှိအသုံးပြုနေသောဘာသာစကားသည် သင်္ကေတနှင့် အက္ခရာများအတွက် သင့်လျော်သောဘာသာစကား ဟုတ်မဟုတ်ပြောအသိပေးမည် ဖြစ်ပါသည်။ အကယ်၍ NVDA သည် synthesizer သို့ voice ဖြင့် ပုဒ်ဖြတ်၊ ပုဒ်ရပ်များအား ဘာသာစကားအမှားဖြင့်ဖတ်နေပါက NVD အား အပြည်ပြည်ဆိုင်ရာဘာသာစကားအပြင်အဆင်(global language setting) ဖြင့်အစားထိုးအသုံးပြုနိုင်ပါသည်။

##### Capital pitch change percentage {#toc94}

စာရိုက်သည့် စာလုံးအကြီးများကို အသံပို၍ မြှင့်ထားခြင်းဖြစ်သည်။အသံမြှင့်ထာခြင်းမပြုလုပ်လိုပါက ၀ တွင်ထားရှိရမည်။

##### Say "cap" before capitals {#toc95}

စာရိုက်သည့်အခါ စာလုံးအကြီးများကို အရှေ့မှ Cap ဟူ၍ ထည့်ပြောခြင်းဖြစ်သည်။

##### Beep for capitals {#toc96}

စာရိုက်သည့်အခါ စာလုံးအကြီးများတွင် အသံပါလိုလျှင် Beep for Capitals တွင် အမှန်ခြစ်ပေးရမည်။

##### Use spelling functionality if supported {#VoiceSpellingFunctionality}

အချို့စကားလုံးများကို စာလုံးပေါင်းမှားသည့်အခါ အချက်ပြခြင်းဖြစ်သည်။ အသုံးပြုလိုလျှင် Use spelling functionality if supported ကို အမှန်ခြစ်ထားရမည်။
အသုံးမပြုလိုလျှင် အမှန်ခြစ်ဖြုတ်ထားပါ။

#### Synth settings ring {#SynthSettingsRing}

Voice Setting သို့မသွားဘဲ Short Cut များဖြင့်အသုံးပြုလိုလျှင်:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Synth setting များကိုအပြောင်းလဲလုပ်လိုလျှင် |NVDA+control+rightArrow |NVDA+shift+control+rightArrow |၎င်း short cut ကိုနှိပ်၍ Voice Setting ထဲတွင်ရှိသည့်အရာများကို ရွှေ့နိုင်သည်။|
|Synth setting များကိုအပြောင်းလဲလုပ်လိုလျှင် |NVDA+control+leftArrow |NVDA+shift+control+leftArrow |၎င်း short cut ကိုနှိပ်၍ Voice Setting ထဲတွင်ရှိသည့်အရာများကို ရွှေ့နိုင်သည်။|
|Synth setting များကို မြှင့်လိုလျှင် |NVDA+control+upArrow |NVDA+shift+control+upArrow |ဥပမာ Rate, Voice, Volume တို့ကို မြှင့်ခြင်း ဖြစ်သည်။|
|Synth setting များကို နှိမ့်လိုလျှင် |NVDA+control+downArrow |NVDA+shift+control+downArrow |ဥပမာ Rate, Voice, Volume တို့ကို နှိမ့်ခြင်း ဖြစ်သည်။|

<!-- KC:endInclude -->

#### Braille Settings {#toc99}

Braille Settings ကို preferences ထဲတွင် သွားရောက်ရှာဖွေနိုင်သည်။

##### Braille Display {#toc100}

ပြင်ဆင်နိုင်သော Braille Settings များစွာရှိသည်။ ထည့်သွင်းထားသော Braille Display Driver ပေါ်တွင်မူတည်၍ Arrow Key ဖြင့်ရွေးချယ်ပါ။

သင်အသုံးမပြုလိုလျှင် No braille ကိုရွေးချယ်ရမည်။

အသေးစိတ်သိလိုလျှင် [Supported Braille Displays](#SupportedBrailleDisplays) တွင်သွားရောက်လေ့လာနိုင်ပါသည်။

##### Port {#toc101}

မည်သည့် Port ကို အသုံးပြုမည်ကို ရွေးချယ်ခြင်းဖြစ်သည်။Brail Display ပေါ်တွင်မူတည်သည်။

NVDA အနေဖြင့် "USB"နှင့် "Bluetooth" ကိုရွေးချယ်ပေးသည်။ သို့သော် အချို့ Display များဖြင့်မကိုက်ညီပါ။

အသေးစိတ်သိလိုလျှင်[Supported Braille Displays](#SupportedBrailleDisplays) တွင် သွားရောက်လေ့လာနိုင်ပါသည်။

##### Output Table {#toc102}

Output Table များကိုရွေးချယ်လိုလျှင် output table combo box ထဲတွင် သွားရောက်ရွေးချယ်ရမည်။
ရွေးချယ်ထားသော Table ပေါ်မူတည်၍ Brail Display တွင် ဖော်ပြသွားမည်။

##### Input Table {#toc103}

Input Table များကိုရွေးချယ်လိုလျှင် Input table combo box ထဲတွင် သွားရောက်ရွေးချယ်ရမည်။
မိမိရိုက်ထည့်သည့် Brail စာများကို ကွန်ပျူတာမှ လက်ခံရယူခြင်းဖြစ်သည်။

မှတ်ချက် အသုံးပြုသော Brail Display Driver ပေါ်တွင်မူတည်သည်။
 အကယ်၍ အလုပ်မလုပ်လျှင် [Supported Braille Displays](#SupportedBrailleDisplays) တွင်သွားရောက်လေ့လာနိုင်ပါသည်။

##### Expand to computer braille for the word at the cursor {#toc104}

ဤ option သည် cursor အောက်မှာသောစကားလုံးအား စာချုပ်ချုပ်ဆိုထားခဲ့ခြင်းမရှိသော computer braille ပေါ်တွင်ပြရန်အတွက်ခွင့်ပြုသည်။

##### Show Cursor {#toc105}

ဤ option အား braille curosr အဖွင့်၊ အပိတ်ပြုလုပ်ရန်အတွက် အသုံးပြုနိုင်သည်။
ဤလုပ်ဆောင်ချက်သည် system caret နှင့် review cursor အားအကျိုးသက်ရောက်မှု့ရှိသော်လည်း selection indicator အားသက်ရောက်မှု့မရှိပါ။

##### Blink Cursor {#toc106}

ဤ option ဖြင့် braille cursor အား (blink)မှိတ်တုပ် ပြုလုပ်ရန်အတွက် အသုံးပြုနိုင်သည်။ 
အကယ်၍ blinking အားပိတ်ထားပါက braille cursor သည်အမြဲတန်း အပေါ်တွင်ရှိနေမည်ဖြစ်သည်။

##### Cursor Blink Rate (ms) {#toc107}

ဤ option သည်အမှတ်စဉ်အကွက်ဖြစ်ပြီး cursor ၏ blink ကြိမ်နူန်းအား milliseconds သို့ပြောင်းရန်အတွက်လုပ်ဆောင်နိုင်သည်။

##### Cursor Shape {#toc108}

ဤ option အား braille cursor ၏အရွယ်အစား (dot pattern)အစက်အရွယ်အစား အားရွေးချယ်ရန်အတွက်အသုံးပြုသည်။
ဤ option သည် selection indicator အားထိခိုက်မူမရှိပါ။

##### Message Timeout (sec) {#toc109}

ဤ option သည်အမှတ်စဉ်အကွက်ဖြစ်ပြီး braille display တွင် NVDA မှ messages များမည်မျှအကြာထိဖော်ပြထားမည်ကို ချိန်ညှိရာအတွက်အသုံးပြုသည်။
နံပတ်အား (၀) ရွေးချယ်ထားပါ messages များလုံးဝပေါ်လာမည်မဟုတ်တော့ပါ။

<!-- KC:setting -->

##### Braille Tethered to {#BrailleTether}

Key: NVDA+control+t

ဤ option အား braille display အား system focus သို့မဟုတ် navigator object သို့မဟုတ် review cursor နှောက်လိုက်ရန်ရွေးချယ်နိုင်သည်။

##### စာပိုဒ်အလိုက်ဖတ်လိုလျှင် {#toc111}

Read By Paragraph ကို အမှန်ခြစ်ပေးထားပါက braille သည် စာကြောင်းများအစား စာပိုဒ်များအားဖော်ပြပေးမည်ဖြစ်သည်။ ထို့နှောက် ရှေ့၊နှောက်သွားသည့် commands သည်လည်း စာအပိုဒ်လိုက်အား (move by paragraph)အနေဖြင့် အစဉ်လိုက်ရွေ့သွားမည်ဖြစ်သည်။
ဆိုလိုသည်မှာ သင်သည် စာကြောင်းဆုံးတိုင်း scroll လုပ်စရာမလိုဘဲ အလိုအလျှောက်အောက်သို့ရွေ့သွားမည်ဖြစ်သည်။ ဤနည်းသည် စာအများအပြားအားဖတ်သောအခါ အသုံးဝင်မည်ဖြစ်သည်။ ပုံမှန်အားဖြင့် ဤလုပ်ဆောင်ချက်အား ပိတ်ထားပေးပါသည်။

##### Avoid splitting words when possible {#toc112}

Avoid splitting words when possible ကို အမှန်ခြစ်ထားလျှင် စကားလုံးများကို အလိုလျောက်နေရာတကျ ရွေ့ပေးခြင်းဖြစ်သည်။
မှတ်ချက် စာလုံးရေ အရမ်းများသော်လည်း အလိုလျောက်ပြုလုပ်ပေးနိုင်သည်။

၎င်း ကို Disble ပြုလုပ်ထားလျှင် အချို့စာလုံးများပျောက်နေမည်။
Scroll ဖြင့် ပြန်လည်ဆွဲချသောအခါ ပျောက်နေသောစာလုံးများပြန်လည်ပေါ်လာမည်။

၎င်းကို အမှန်ခြစ်ထားသောအခါ စာဖတ်ခြင်းကိုအထောက်ကူပြုသော်လည်း Scroll ကိုဆွဲချသောအခါ ပို၍ ဖော်ပြနိုင်သည်။

#### Keyboard Settings (NVDA+control+k) {#toc113}

၎င်း Setting ကို Preferences ထဲတွင် ရှာဖွေနိုင်သည်။
ပါဝင်သည့်အရာများကို အောက်တွင်ဖော်ပြထားသည်:

##### Keyboard layout {#toc114}

Bombo box ထဲတွင် keyboardအမျိုးစား ၂ မျိုးကို ရွေးချယ်နိုင်သည်။ ၎င်းတို့မှာ Desktop နှင့် Laptop တို့ဖြစ်သည်။

##### NVDA Key ကို capslock key ဖြင့် အသုံးပြုခြင်း {#toc115}

၎င်းကို အသုံးပြုလိုလျှင် Use Caplock as an NVDA modifier key ကို အမှန်ခြစ်ထားပါ။

##### Use extended insert as an NVDA modifier key {#toc116}

Insert အား NVDA ၏အထူးခလုပ်ဖြင့်အသုံးပြုလိုပါက (Use extended insert as an NVDA modifier key) ကိုအမှန်ခြစ်ထားပါ။ Home Key , End Key , Arrow Key များကို အစားထိုးအသုံးပြုခြင်းဖြစ်သည်။

##### Use numpad insert as an NVDA modifier key {#toc117}

Numpad နှင့် NVDA အား NVDA ၏အထူးခလုပ်ဖြင့်အသုံးပြုလိုပါက (Use numpad insert as an NVDA modifier key)ကိုအမှန်ခြစ်ထားပါ။  

အကယ်၍ Key တစ်ခုမျှ မရွေးချယ်ထားလျှင် NVDA မှ အနည်းဆုံး Key တစ်ခုရွေးချယ်ရန် Message Box ကျလာလိမ့်မည်။

<!-- KC:setting -->

##### စာရိုက်သောအခါ စာလုံးများကို အသံထွက်လိုလျှင် {#toc118}

Key: NVDA+2

၎င်းကို အမှန်ခြစ်ထားပါက သင်စာရိုက်သောအခါ စာရိုက်သည့်စာလုံးများကို အသံထွက်ဖတ်ပြမည်။

<!-- KC:setting -->

##### စာရိုက်သည့်အခါ စကားလုံးများကို အသံထွက်လိုလျှင် {#toc119}

Key: NVDA+3

၎င်းကို အမှန်ခြစ်ထားပါက သင်စာရိုက်သောအခါ စာရိုက်သည့်စကားလုံးများကို အသံထွက်ဖတ်ပြမည်။

##### Speech interrupt for typed characters {#toc120}

အကယ်၍ အမှန်ခြစ်ထားလျှင် စာလုံးများကို ရောက်သည့်နေရာမှ အသံကို ရပ်ထားပေးခြင်းဖြစ်သည်။

##### Speech interrupt for Enter key {#toc121}

အကယ်၍ အမှန်ခြစ်ထားလျှင် Enter Key နှိပ်ပါက အသံများကို ရပ်ပေးခြင်းဖြစ်သည်။

##### Allow skim reading in Say All {#toc122}

အကယ်၍ အမှန်ခြစ်ထားလျှင် စာများကိုဖတ်သည့်အခါ အခြားလိုင်းကို ကာစာ ရွေ့သွားသော်လည်း ကျန်ခဲ့သည့် စာများကို ဖတ်နေခြင်းဖြစ်သည်။

##### Beep if Typing Lowercase Letters when Caps Lock is On {#toc123}

အကယ်၍ အမှန်ခြစ်ထားလျှင် Caps Lock ကိုဖွင့်ပြီး စာလုံးအသေးများရိုက်သောအခါ အချက်ပေးသံမြည်ခြင်းဖြစ်သည်။

<!-- KC:setting -->

##### Speak Command Keys {#toc124}

Key: NVDA+4

အကယ်၍ အမှန်ခြစ်ထားလျှင် Character မဟုတ်သော အခြား Key များဖြစ်သည့် Escape, Arrow Key များကိုဖတ်ပြခြင်းဖြစ်သည်။

##### Play sound for spelling errors while typing {#toc125}

အကယ်၍ အမှန်ခြစ်ထားလျှင် စာရိုက်သည့်အခါ စာလုံးပေါင်းမှားလျှင် အသံဖြင့်အချက်ပြခြင်းဖြစ်သည်။

##### Handle keys from other applications {#toc126}

အကယ်၍ အမှန်ခြစ်ထားလျှင် အခြား Application Short Cut Key များ၏ လုပ်ဆောင်ချက်များဖြင့်သွားတူနေလျှင် အမှန်ခြစ်ဖြုတ်ထားရမည်။

#### Mouse Settings (NVDA+control+m) {#MouseSettings}

Preferences ထဲတွင် Mouse Setting ကိုရှာဖွေနိုင်သည်။
၎င်းတွင် အောက်ပါတို့ပါဝင်သည်:

##### Report Mouse Shape Changes {#toc128}

၎င်းကိုအမှန်ခြစ်ထားလျှင် လက်ရှိရှိနေသည့်နေရာကိုဖတ်သည့်အပြင် အခြား Active ဖြစ်နေသည့်နေရာကိုပါဖတ်ပြသည်။

<!-- KC:setting -->

##### Enable mouse tracking {#toc129}

Key: NVDA+m

၎င်းကိုအမှန်ခြစ်ထားလျှင် လက်ရှိ Mouse Pointer ရှိနေသော စာများကိုဖတ်ရုံသာမက Mouse ရွှေ့သည့်အခါ Object များကိုလဲ စာအဖြစ်ဖော်ပြပေးသည်။

##### Text unit resolution {#toc130}

၎င်း Setting တွင် NVDA ကို စကားလုံးတစ်လုံးစီသော်လည်းကောင်း စကားစုတစ်စုစီသော်လည်းကောင်း စာပိုဒ်တစ်ပိုဒ်စီသော်လည်းကောင်း ဖတ်ပြရန်ရွေးချယ်နိုင်သည်။

##### Report role when mouse enters object {#toc131}

၎င်းကိုအမှန်ခြစ်ထားလျှင် Row နှင့် Column တို့ကို ဖတ်ပြခြင်းဖြစ်သည်။

##### Play audio coordinates when mouse moves {#toc132}

၎င်းကိုအမှန်ခြစ်ထားလျှင် NVDA ရွှေ့သည့်အခါ အသံမြည်ခြင်းဖြစ်သည်။
အပေါ်ကိုရွှေ့သည့်အခါ အသံမြင့်သွားပြီး အောက်သို့နှိပ့်သည့်အခါ အသံနှိမ့်သွားသည်။
ဘယ် နှင့် ညာ ကိုလဲ အသံခွဲထားသည်။ အသုံးပြုသူအနေဖြင့် စပီကာ သို့မဟုတ် နားကြပ် လိုအပ်သည်။

##### Brightness controls audio coordinates volume {#toc133}

၎င်းကိုအမှန်ခြစ်ထားလျှင် Mouse ရွှေ့သည့်အသံကို အတိုး အကျယ် လုပ်ပေးသည်။
၎င်း Setting သည် NVDA တွင် အမှန်မခြစ်ထားပါ။

#### Review Cursor Settings {#toc134}

Preferences Setting ထဲတွင်တွေ့နိုင်သည်။
၎င်း ကို အောက်တွင်ဖော်ပြထားသည်:

<!-- KC:setting -->

##### Follow System Focus {#toc135}

Key: NVDA+7

၎င်းကိုအမှန်ခြစ်ထားလျှင် Review Cursor သည် System Focus နှင့် ဘယ်တော့မျှ သွားမတူပါ။

<!-- KC:setting -->

##### Follow System Caret {#toc136}

Key: NVDA+6

၎င်းကိုအမှန်ခြစ်ထားလျှင် Review Cursor သည် အက္ခရာအတိုင်း အလိုလျောက်ရွေ့ပေးသည်။

##### Follow mouse cursor {#toc137}

၎င်းကိုအမှန်ခြစ်ထားလျှင် Review Cursor သည် Mouse Cursor ရွှေ့သည့်အတိုင်း လိုက်ရွှေ့သည်။

##### Simple Review mode {#toc138}

၎င်းကိုအမှန်ခြစ်ထားလျှင် အရေးကြီးသည့်အရာများကိုသာ ဦးစားပေးဖတ်ပေးသည်။

အဖွင့် အပိတ် လုပ်လိုပါက [Input Gestures dialog](#InputGestures) ထဲတွင် သွားရောက်ထည့်သွင်းနိုင်ပါသည်။

#### Object Presentation Settings (NVDA+control+o) {#toc139}

Preferences Setting တွင် တွေ့နိုင်သည်။
၎င်း ကို အောက်တွင်ဖော်ပြထားသည်:

##### Report Tool Tips {#toc140}

၎င်းကိုအမှန်ခြစ်ထားလျှင် Windows တွင်ပေါ်လာသည့် Message များကို Mouse Cursor ရွှေ့သည့်အခါ ဖတ်ပြခြင်းဖြစ်သည်။

##### Report Help Balloons {#toc141}

၎င်းကိုအမှန်ခြစ်ထားလျှင် Network Unplug ဖြစ်နေခြင်းတို့ကို ဖတ်ပြခြင်းမျိုးဖြစ်သည်။

##### Report Object Shortcut Keys {#toc142}

၎င်းကိုအမှန်ခြစ်ထားလျှင် မိမိ ရောက်ရှိသည့်နေရာတွင် Short Cut Key ရှိပါက Short Cut Key များကို ဖတ်ပြခြင်းဖြစ်သည်။
ဥပမာ File Menu ထဲရောက်နေပါက alt+f

##### Report object position information {#toc143}

၎င်းSetting သည် သင်ရွေးချယ်ထားသောအပေါ်မူတည်၍ အလုပ်လုပ်သည်။ Report object position information ကို အမှန်ခြစ်ထားပါက Object နှင့် ပါတ်သတ်သည့် အကြောင်းအရာများကိုဖတ်ပြခြင်းဖြစ်သည်။

##### Guess Object Position Information when unavailable {#toc144}

Reporting of object ကိုအမှန်ခြစ်ထားလျှင် ၎င်း Function သည် အလုပ်မလုပ်ပါ။

##### Report Object descriptions {#toc145}

အကယ်၍ Report Object descriptions ကို အသုံးမပြုလိုပါက အပိတ် အဖွင့် ပြုလုပ်နိုင်သည်။

<!-- KC:setting -->

##### Progress bar output {#toc146}

Key: NVDA+u

၎င်းသည် Percentages ဖြင့် Loading သွားနေသောအရာများကို ဖတ်ပြခြင်းဖြစ်သည်။

အောက်တွင်ဖော်ပြထားသည်:

* Off: Percentages ဖြင့် Loading သွားနေသောအရာများကို မဖတ်ပြပါ။
* Speak: Percentages ဖြင့် Loading သွားနေသောအရာများကို စာဖြင့် ဖော်ပြခြင်းဖြစ်သည်။
* Beep: Percentages ဖြင့် Loading သွားနေသောအရာများကို အသံဖြင့် ဖော်ပြခြင်းဖြစ်သည်။
* Beep and speak: Percentages ဖြင့် Loading သွားနေသောအရာများကို စာ နှင့် အသံ ဖြင့် ဖော်ပြခြင်းဖြစ်သည်။

##### Report background progress bars {#toc147}

၎င်းကိုအမှန်ခြစ်ထားလျှင် နောက်ကွယ်တွင် Percentages ဖြင့် Loading သွားနေသောအရာများကို ဖတ်ပြခြင်းဖြစ်သည်။

<!-- KC:setting -->

##### Report dynamic content changes {#toc148}

Key: NVDA+5

အလုပ်လုပ်နေစဉ် ထပ်မံပေါ်ထွက်လာသည့် အချက်လက်သစ်များကို ဖတ်ပြခြင်းဖြစ်သည်။ ဥပမာ Chat Program ကိုဖတ်ပြခြင်းမျိုးဖြစ်သည်။

#### Input Composition Settings {#toc149}

၎င်းကို Preferences Setting ထဲတွင် ရှာဖွေနိုင်သည်။
မှတ်ချက် စာရိုက်သည့်အတွေ့အကြုံပေါ်မူတည်၍ ၎င်း Setting များကို အသုံးပြုနိုင်သည်။

##### Automatically report all available candidates {#toc150}

ဤလုပ်ဆောင်ချက်သည် ပုံမှန်အားဖြင့်စာမျက်ပေါ်ရှိ candidate list ပြောင်းသွားသောအခါ အလိုအလျောက်တင်ပြရန် သို့မဟုတ် မတင်ပြရန်အတွက် ရွေးချယ်နိုင်သောလုပ်ဆောင်ချက်ဖြစ်သည်။

ဤ option အား သင်္ကေတထည့်သွင်းခြင်းနည်းလမ်း(pictographic input methods) ဉပမာ တရုတ် New ChangJie သို့ Boshiami များအတွက် on ထားပါက ထိုဘာသာစကားများ၏  သင်္ကေတများနှင့် နံပတ်စဉ်များအား အလိုအလျောက် ဖော်ပြပေးမည်ဖြစ်သောကြောင့် သင့်အတွက်အထောက်အကူဖြစ်ပါမည်။
မည်သို့ပင်ဆိုသော် သင်္ကေတထည့်သွင်းခြင်းနည်းလမ်း၊ ဉပမာ တရုတ်သင်္ကေတအသစ်များအတွက်ကိုမှု ထို option အားပိတ်ထားပါကပိုမိုသင့်လျော်မည်ဖြစ်သည်။ အဘယ့်ကြောင့်ဆိုသော် သင်္ကေတများအတွက်ဖေါ်ပြချက်များမှာ တူညီသွားမည်ဖြစ်သည်။ အက္ခရာစာရင်းက၏အသေးစိတ်သိရှိရန် list items များအား arrow key ဖြင့်သွားရမည်ဖြစ်သည်။

##### Announce Selected Candidate {#toc151}

ဤ option သည်ပုံမှန်အားဖြင့် select လုပ်ထားသော candidate list ထွက်ပေါ်လာသောအခါ သို့မဟုတ် select လုပ်ထားသော candidate ပြောင်းသွားသောအခါ NVDA မှသတိပေးချက်ပေးသော option တစ်ခုဖြစ်သည်။ 
Arrow keys များဖြင့် selection များအားပြောင်းလဲနိုင်သော ထည့်သွင်းနည်းလမ်း (inpute methos)ဉပမာ တရုတ်သင်္ကေတအသစ်များအတွက်အရေးကြီးသော်လည်း၊ အချို့သော inpute methos များအတွက်ကိုမှု ဤ option အား ပိတ်၍ (turned off) ပြုလုပ်ပြီးအသုံးပြုပါက လုံလောက်သည်။
မှတ်ထားရမည့်အချက်မှာ ဤ option အားပိတ်ထားသော်လည်း review cursor သည် select လုပ်ထားသော candidate တွင်ရှိနေမည်ဖြစ်ပြီး object navigation အားထောက်ပံ့ပေးခြင်းနှင့် ၎င်း candidate အားဖတ်ရန် သို့မဟုတ် အခြား candidates များအားဖတ်ရန် ထောက်ပံ့ပေးပါသည်။

##### Always include short character descriptions for candidates {#toc152}

ဤ option သည်ပုံမှန်အားဖြင့် candidate တစ်ခုခြင်းစီ၏အချက်အလက်အား select မှတ်ထားသောအခါတွင်လည်းကောင်း သို့မဟုတ် candidate list ထွက်ပေါ်လာသောအခါ အလိုအလျှောက်ဖတ်သောအခါ NVDA မှ အနည်းအကျဉ်းဖော်ပြပေးရန် သို့မဟုတ် မဖော်ပြပေးရန်အတွက် ရွေးချယ်နိုင်ခြင်းဖြစ်သည်။ 
မူရင်းတရုတ်ဘာသာကဲ့သို့သော candidate သည် character များအတွက် အချက်အလက်ပိုမိုဖော်ပြပေးချင်းလုပ်ဆောင်ချက်သည် ဤ option အတွက်သက်ရောက်မှုမရှိပါ။
ဤ option သည် ကိုရီးယားနှင့် တရုတ်ဘာသာစကားကဲ့သို့သော input methods များအတွက်မှာမူ အသုံးဝင်ပါလိမ့်မည်။

##### Report changes to the reading string {#toc153}

တရုတ်အသံထွက်အသစ်နှင့် ChangJie အသစ်ကဲ့တို့သော အသံထွက်များအတွက် တို့သည် reading string တစ်ခုပါရှိပြီး (တစ်ခါတစ်ရံ precomposition string ဟူ၍လည်းခေါ်သည်)။
ထို reading string တွင် ဤ option ဖြင့် characters အသစ်များရေးသောအခါ NVDA မှဖတ်ပြမည်၊ မဖတ်ပြမည်ဆိုသည်ကို သင်ရွေးချယ်နိုင်သည်။
ဤ option သည် default ဖြစ်သည်။
အချို့သော input methods အဟောင်း ဉပမာ တရုတ်၏ ChangJie သည် ဤ reading string အား precomposition character များအတွက်အသုံးပြုမည်မဟုတ်ပါ။ ထိုအစား composition string အားတိုက်ရိုက်အသုံးပြပါသည်။ Composition string အား ချိန်ညိခြင်းနှင့်တင်ပြခြင်း အပြင်အဆင်ဆိုင်အကြောင်းကို option နှောက်တစ်ခုတွင်ကြည့်ပါ။

##### Report changes to the composition string {#toc154}

စာဖတ်ပြီးနှောက် သို့မဟုတ် စာစီပြီးနှောက်တွင် အချက်အလက်များသည်စုစည်းပြီးနှောက် ခြေမြစ်သောသင်္ကေတ အက္ခရာအဖြစ်ပြောင်းလဲသွားသည်။ ဤထည့်သွင်းပုံစံများသည်  အက္ခရာအနေထားသို့ရောက်ရှိပြီး document ထဲသို့မထဲ့သွင်းခင် ခေတ္တသိမ်းထားရန် composition string နှင့် အခြားပေါင်းစပ် သင်္ကေတအနေထားသို့ရောက်ရှိသည်။

ဤ option သည် composition string တွင်ပေါ်လာသည့် သင်္ကေတအသစ်များအား ဖတ်ပြရန် သို့မဟုတ် မဖတ်ပြရန်အတွက် ရွေးချယ်ပေးနိုင်သည်။
ဤရွေးချယ်မှုသည်မူရင်းအနေထားဖြစ်သည်။

#### Browse Mode Settings (NVDA+control+b) {#toc155}

Preferences Setting တွင်ပါဝင်သည်။

အောက်တွင်ဖော်ပြထားသည်:

##### Maximum Number of Characters on One Line {#toc156}

၎င်းသည် Browse Mode တွင် စာတစ်ကြောင်းလျှင် စာလုံးရေမည်မျှထားသည်ကို သတ်မှတ်ခြင်းဖြစ်သည်။

##### Maximum Lines Per Page {#toc157}

Page Up နှင့် Page Down ရွှေ့သောအခါ လိုင်း မည်မျှ ရွှေ့မည်ကို သတ်မှတ်ခြင်းဖြစ်သည်။

<!-- KC:setting -->

##### Use screen layout {#toc158}

Key: NVDA+v

၎င်းသည် Browse Mode တွင် Link အပါဝင် အခြားသောအရာများကို ခွဲခြားပေးခြင်းဖြစ်သည်။

##### Automatic Say All on page load {#toc159}

၎င်းကို အမှန်ခြစ်ထားလျှင် Browse Mode တွင်အလိုလျောက်ဖတ်ပြခြင်းဖြစ်သည်။
NVDA တွင် အမှန်ခြစ်ပြီးသားဖြစ်သည်။

##### Include layout tables {#toc160}

၎င်း၏အကျိုးသက်ရောက်မှုသည် NVDA ဖြင့် Table များကို ကောင်းမွန်စွာ ရွှေ့နိုင်ခြင်းဖြစ်သည်။
၎င်းကိုဖွင့်သောအခါတွင် Table များကို Navigation command  key များဖြင့်ရွှေ့နိုင်သည်။[Document Formatting Settings](#DocumentFormattingSettings)
၎င်းကိုပိတ်ထားလျှင် ထိုလုပ်ဆောင်ချက်များမလုပ်ပါ။
၎င်းကို NVDA နေဖြင့် မူလတွင်ပိတ်ထားပေးသည်။

##### Configuring reporting of fields such as links and headings {#toc161}

ဤ option အား links, headings နှင့် tables များအား navigate လုပ်ရာတွင်ဖတ်ပြပေးသည့် fields များအား ချိန်ညှိရာတွင်အသုံးပြုပြီး လမ်းညွန်ချက်အား စာတည်းဖြတ်ခြင်းအခန်းကဏ္ဍ [Document Formatting Settings dialog](#DocumentFormattingSettings) တွင်တွေ့ရှိနိုင်ပါသည်။

##### Automatic focus mode for focus changes {#toc162}

Focus Mode အမှန်ခြစ်ထားလျှင် Web Page တွင် Focus Mode ကို အလိုလျောက်ပြောင်းပေးသည်။

##### Automatic focus mode for caret movement {#toc163}

Automatic focus mode for caret movement ကိုအမှန်ခြစ်ထားလျှင် Arrow Key ဖြင့် Web Page ပေါ်တွင် ရွှေ့လျားနိုင်သည်။

##### Audio indication of Focus and Browse modes {#toc164}

Audio indication of Focus and Browse modes ကိုအမှန်ခြစ်ထားလျှင် Browse Mode နှင့် Focus Mode ပြောင်းလျှင် အသံဖြင့် အချက်ပြသည်။

##### Trap non-command gestures from reaching the document {#toc165}

၎င်းကို မူလထဲက NVDA တွင်အမှန်ခြစ်ပြီးသားဖြစ်သည်။ ဥပမာ J ကိုနှိပ်လျှင် Application တွင် သတ်မှတ်ထားသောအလုပ်ကိုလုပ်ခြင်းဖြစ်သည်။ ၎င်းသည် NVDA ၏ Quick Navigation Key များမဟုတ်ပါ။ Application တွင် ထည့်သွင်းထားသော Key များသာဖြစ်သည်။

#### Document Formatting Settings (NVDA+control+d) {#DocumentFormattingSettings}

ဤ setting အား Preferences Setting အောက်တွင်ရှိသော "Document Formatting..." ထဲတွင် ရှာဖွေနိုင်သည်။

၎င်း Dialog Box ထဲတွင် အမှန်ခြစ်ပြုလုပ်နိုင်သည်။ Check Box များစွာပါဝင်သည်။
ဥပမာ သင်သည် Report Font Name ကို အမှန်ခြစ်ထားလျှင် အခြား Font ကို Arrow ဖြင့်ရွှေ့သောအခါ Font Name ကိုဖတ်ပြလိမ့်မည်။

၎င်း Group ထဲတွင် ရှိသည့်အရာများကို ဖတ်ပြနိုင်ရန်ပြင်ဆင်ထား၍ရသည်:

* Font
 * Font name
 * Font size
 * Font attributes
 * Emphasis
 * Style
 * Colors
* Document information
 * Comments
 * Editor revisions
 * Spelling errors
* Pages and spacing
 * Page numbers
 * Line numbers
 * Line indentation reporting [(Off, Speech, Tones, Both Speech and Tones)](#lineIndentationOptions)
 * Paragraph indentation (e.g. hanging indent, first line indent)
 * Line spacing (single, double etc)
 * Alignment
* Table information
 * Tables
 * Row/column headers
 * Cell coordinates
* Elements
 * Headings
 * Links
 * Lists
 * Block quotes
 * Landmarks
 * Frames
 * Clickable

ရောက်နေသည့်နေရာတိုင်းမှ ဤလုပ်ဆောင်ချက်အားအဖွင့်၊အပိတ်ပြုလုပ်လိုပါက [Input Gestures dialog](#InputGestures) အသုံးပြု၍ ကိုယ်ပိုင်အမှတ်အသားအား သတ်မှတ်နိုင်ပါသည်။

##### Report formatting changes after the cursor {#toc167}

၎င်းကိုအမှန်ခြစ်ထားလျှင် စာတစ်ကြောင်းအား ပြင်ဆင်(format) ထားသောအချက်အလက်အသေးစိတ်ကို ဖတ်ပြပေးသည်။ သို့သော်ဤလုပ်ဆောင်ချက်အားအသုံးပြုပါက NVDA ၏လုပ်ဆောင်ချက်မှာ နှေးသွားလိမ့်မည်။

ပုံမှန်အားဖြင့် NVDA သည် System caret / Review Cursor ရှိသောနေရာမှတည်းဖြတ်ထားသောအချက်အလက်များကို မှတ်သားထားသည်။ တစ်ခါတစ်ရံတွင် စွမ်းစောင်ရည်ထိခိုက်နိုင်ခြင်းမရှိပါက စာကြောင်းအားလုံး၏တည်းဖြတ်ထားသောအချက်အလက်များကိုလည်း မှတ်သားထားပါလိမ့်မည်။

ဤ option အား Word Pad ကဲ့သို့သော document applicaitons များ ပေါ်တွင် proof reading ဖတ်ရာတွင်မှုအရေးပါသည့်အတွက် enable ပြုလုပ်ထားရန်အရေးကြီးသည်။

##### Line indentation reporting {#lineIndentationOptions}

ဤ option သည် စာကျောင်းအစ၏နေရာလွတ်ချန်ခြင်း (indentation) အားဖတ်ပြပေးရန် သို့မဟုတ် မဖတ်ပြရန်အတွက်ပြင်ဆင်နိုင်သည် option ဖြစ်သည်။
၎င်းတွင် ရွေးချယ်စရာ ၄ ခုပါဝင်သည်။
ထို line indentation အားတင်ပြခြင်းအဆင်အပြင်သည် option (၄)ခုပါသော combo box ဖြင့်လာသည်။

* Off: NVDA လုံး၀အလုပ်မလုပ်ပါ။
* Speech: အကယ်၍ ၎င်း ကိုရွေးချယ်ထားလျှင် NVDA မှ တစ်ခုခု ပြောပါလိမ့်မည်။ ဥပမာ Twelve Space နှင့် Four Tab။
* Tones: အကယ်၍ ၎င်း ကိုရွေးချယ်ထားလျှင် လိုင်းနှင့် စမေစင် ပေါ်တွင်မူတည်၍ အသံဖြင့်ပြသည်။
* Both Speech and Tones: နှစ်ခုလုံးရွေးထားလျှင် အသံ နှင့် စကားပြော နှစ်ခုလုံးပြသည်။

#### Speech dictionaries {#toc169}

Preferences Setting ထဲတွင် ရှာဖွေနိုင်သည်။
၎င်းတွင် အမျိုးစား ၃ မျိုးရှိသည်။
ယင်းတို့မှာ:

* Default: မှာစကားလုံးများကိုပြင်လျှင် Dictionary အားလုံးတွင် ပြင်ပြီးသားဖြစ်သည်။
* Voice: တွင်ပြင်လျှင် လက်ရှိသုံးနေသည့် Synthesizer တွင်သာပြင်သည်။
* Temporary: မှာပြင်လျှင် Restart မချခင်အထိသာ မိမိပြင်ထားသည့်အတိုင်းရှိသည်။

[Input Gestures dialog](#InputGestures) ထဲတွင် မိမိ နှစ်သက်သည့် Short Cut ထည့်ထားပါက အလွယ်တကူအသုံးပြုနိုင်ပါသည်။

Dictionary တိုင်းတွင် တူညီစွာပါဝင်သည်။
၎င်းတို့မှာ  Add, Edit နှင့် Remove button တို့ဖြစ်သည်။

အကယ်၍ Dictionary ကို စကားလုံးအသစ်ထည့်လိုလျှင် Add ကိုနှိပ်၍ စာရိုက်သည့်နေရာတွင် စာကိုရိုက်ပြီး OK နှိပ်ပါ။
သင်ထည့်ထားသော စကားလုံးကို List အသစ်ထဲတွင်တွေ့ရသည်။
သင့်အနေနှင့် အမှန်တကယ်ထည့်လိုလျှင် OK ကိုနှိပ်ပါ။ လုပ်ဆောင်ချက်ပြီးမြောက်ပါပြီ။

သင့်အနေဖြင့် စကားလုံးတစ်လုံးကို အခြားအဓိပ္ပါယ် ပြောင်း၍လဲ ထည့်နိုင်သည်။
ဥပမာ Pattern ဆိုသည့်အကွက်တွင် Bird ကိုရိုက်၍ Replacement အကွက်တွင် Frog ကိုရိုက်ပါ။
သင့်အနေဖြင့် အမှတ်သားပြုလုပ်ခဲ့၍လဲရသည်။
Comment Field ထဲတွင် Bird မှ Frog ကိုပြောင်းလဲထားသည်။

NVDA's speech dictionary တွင် စကားလုံးများကိုကောင်းမွန်စွာ ပြောင်းလဲနိုင်သည်။
စကားလုံးများကို အသံ အနိမ့်၊ အမြင့်ဖြင့်ပါ သတ်မှတ်နိုင်သည်။

နောက်ဆုံးမှာတော့ radio buttons တစ်စုံကသင့်အား pattern(ပုံစံ)သည် နေရာအားလုံးနှင့်ကိုက်ညီရမည်၊ စကားလုံးအစုံမှသာ ကိုက်ညီပေးမည် သို့မဟုတ် ပုံမှန်အသံထွက်နှင့်သာ "regular expression" ကိုက်ညီပေးပါဟူသော ရွေးချယ်မူ့အားပြုလုပ်နိုင်သည်။
Pattern အား စကားလုံးတစ်ခုလုံးနှင့်ကိုက်ညီရန်ချိန်ညှိခြင်းဆိုသည်မှာ ၎င်းအစားထိုးမှု့သည် စကားအုပ်စုမဟုတ်သောအခါမှအောင်မြင်မည်ဖြစ်သည်။ ဉပမာ အက္ခရာတစ်ခုထက် အက္ခရာစဉ် သို့မဟုတ် underscore (သို့ စကားလုံးတစ်ခုအနေနှင့်မဟုတ်ဘဲ)စသည့်အက္ခရာတို့သည် pattern တစ်ခု၏ ရှေ့နှင့်နှောက်တို့တွင် တစ်ပြိုင်နက်တည်းလာသည်။
အထက်ပါဉပမာအားဖြင့် "bird" ဌက်အား "frog" ဖားဖြင့်အစားထိုးခြင်းသည် word တစ်ခုအားအစားထိုးခြင်းဖြစ်သည့်အတွက် ၎င်းသည် "birds" ဌက်များ သို့မဟုတ် "bluebird" ဌက်ပြာများနှင့် ကိုက်ညီမည်မဟုတ်ပါ။

ပုံမှန် expression တစ်ခုသည် အထူးသင်္ကေတများပါဝင်သော ပုံစံ(pattern)တစ်ခုဖြစ်ပြီး နံပတ်သီးသန့် သို့မဟုတ် အက္ခရာသီးသန့်တို့နှင့် တစ်ချိန်တည်းကိုက်ညီပေးနိုင်သည့် လုပ်ဆောင်ချက်မျိုးပါဝင်သည်။
Regular expressions တို့အား ဤ user guide တွင်ထည့်သွင်းမဖေါ်ပြထားပါ။ သို့သော်လည်း ဤအကြောင်းအရာနှင့် သက်ဆိုင်သော သင်ခန်းစာအများအပြားအား websites များပေါ်တွင်လေ့လာဖတ်ရှု့နိုင်ပါသည်။

#### Punctuation/symbol pronunciation {#SymbolPronunciation}

ပုဒ်ဖြတ် ပုဒ်ရပ် သင်္ကေတ များကို အသံထွက်ပြောင်းလဲခြင်းဖြစ်သည်။

ပြောင်းလဲထားသောအသံထွက်များကို Dialog Title တွင် ဖော်ပြမည်။
မှတ်ချက် Voice Setting ထဲတွင် Punctuation/symbol ရွေးချယ်ထားပုံမူတည်သည်။

ပထမဦးစွာ symbol ပြောင်းလိုပါက Symbols list ထဲတွင် ရွေးပါ။

* အစားထိုးထားသော Symbol ကို အသံပြန်ထွက်ရာတွင် အဆင့် ၃ ဆင့် သတ်မှတ်ထားနိုင်သည်။ဥပမာ ကော်မာ ကိုရွေးပါက မူလအနေဖြင့် Synthesizer က ခေတ္တရပ်သည်။သင့်အနေဖြင့် ခေတ္တမရပ်လိုပါက Level တွင် All ကိုထားပြီး Send actual symbol to synthesizer တွင် Never ကိုထားရမည်။ Never ကိုရွေးထားလျှင် မိမိပြုလုပ်ထားသော Symbol ကို Synthesizer သို့ မပေးပို့ပါ။ Always ရွေးထားလျှင် Synthesizer သို့ တိုက်ရိုက်ပေးပို့သည်။ Only below symbol level ကိုရွေးထားပါက Punctuation နှင့် Symbol Level ပေါ်တွင် မူတည်၍သာအလုပ်လုပ်သည်။
 -

Add ကိုနှိပ်၍ Symbol အသစ်ကိုလဲထည့်သွင်းနိုင်သည်။
Dialog Box ထဲတွင် မိမိ အသစ်ပြုလုပ်လိုသည့် Symbol ကိုရိုက်ထည့်ပြီး OK နှိပ်ပါ။

ဖျက်လိုပါက Remove ကိုနှိပ်၍ ဖျတ်နိုင်ပါသည်။

Save လိုပါက OK ကိုနှိပ်ပြီး Save နိုင်ပါသည်။

#### Input Gestures {#InputGestures}

Gestures အသစ်ပြုလုပ်လိုပါက keyboard ပေါ်ကနှိပ်၍သော်လည်းကောင်း braille display ပေါ်ကလဲလုပ်နိုင်သည်။

မိမိပြုလုပ်ထားသော Command ကိုနှိပ်လိုက်ပါက Dialog Box ကိုဖော်ပြမည်။
ဥပမာ Customize Command ကို Browse Mode တွင်ပြုလုပ်ပါက Browse Mode တွင် Input Gestures ကိုဖွင့်ပါ။

Dialog Box တွင် ခေါင်းစဉ်လိုက်ဖော်ပြလိမ့်မည်။
စကားလုံးတစ်လုံး သို့မဟုတ် တစ်လုံးထက်ပိုသော စကားလုံးများကို သင့်အနေဖြင့် ပြင်ဆင်နိုင်သည်။

Input Gestures တွင် Command ထည့်သွင်းလိုလျှင် Command ကိုရွေးချယ်၍ Add ကိုနှိပ်ပါ။
ဥပမာ keyboardပေါ်မှ ကီးတစ်ခုနှိပ်၍ သို့မဟုတ် Brail Display ပေါ်မှ Button တစ်ခုခုကိုနှိပ်၍ Gestures တစ်ခုပြုလုပ်နိုင်သည်။Gestures ပြုလုပ်ခြင်းနည်းလမ်းသည် တစ်ခုထက်မကရှိသည်။
Desktop Keyboard Layout နှင့် Laptop Keyboard Layout Layout အမျိုးမျိုးအသုံးပြုနိုင်သည်။

Input Gestures ထဲမှ Command ကိုဖျက်လိုလျှင် ဖျက်လိုသည့် Command ကိုရွေး၍ Remove နှိပ်ပါ။

အကယ်၍ ပြင်ဆင်မှုများပြီးလျှင် OK ကိုနှိပ်၍ Save နိုင်သည်။ သို့မဟုတ် Cancle ကိုနှိပ်၍ ပြင်ဆင်မှုများကို ပြန်ဖျတ်နိုင်သည်။

### Save ခြင်းနှင့် Setting များပြန်လည်စတင်ခြင်း {#toc172}

NVDA သည်မူလအနေဖြင့် NVDA ပိတ်သည်နှင့် Setting များကို အလိုလျှောက် Save ခြင်းဖြစ်သည်။
မှတ်ချက် သို့သော် General Setting ထဲတွင် Save configuration on exit ကိုအမှန်ခြစ်ဖြုတ်ထားနိုင်ပြီး NVDA Menu ထဲရှိ Save Configuration နှိပ်၍ မိမိလိုအပ်သည့်အခါ Save နိုင်သည်။

အကယ်၍ သင့်အနေဖြင့် ပြင်ဆင်မှုကို မှား၍ Save မိလျှင် NVDA Menu ရှိ Revert saved Configuration နှိပ်၍ ပြန်ပြင်ဆင်နိုင်သည်။ 
သင့်အနေဖြင့် NVDA ၏ Setting များကို မူလအတိုင်းပြန်လည်ဖြစ်လိုလျှင် NVDA Menu ထဲရှိ Reset configuration to factory defaults ကိုနှိပ်နိုင်သည်။

အသုံးဝင်သော commands keys များ:
<!-- KC:beginInclude -->

| Name |Desktop key |Laptop key |Description|
|---|---|---|---|
|Save configuration |NVDA+control+c |NVDA+control+c |လက်တလောပြင်ဆင်ထားသော Setting များကို Save ခြင်းဖြစ်သည်။|
|Revert  configuration |NVDA+control+r |NVDA+control+r |တစ်ကြိမ်နှိပ်ပါကနောက်ဆုံးပြင်ဆင်ခဲ့သည့်အခြေနေကိုရယူခြင်း သုံးကြိမ်နှိပ်ပါက NVDA ၏ မူလ Setting များကိုပြန်လည်ရယူခြင်းဖြစ်သည်။|

<!-- KC:endInclude -->

### Configuration Profiles {#toc173}

တစ်ခါတစ်ရံတွင် သင့်အနေဖြင့် မတူညီသည့် Setting နှင့် မတူညီသည့်အခြေနေတွင် အသုံးပြုလိုလျှင်
ဥပမာ သင့်အနေဖြင့် စာများကို အသေးစိတ် ဖတ်လိုသည့်အခါ Font Size , Font Colour စသော အသေးစိတ်အချက်လက်များကို NVDA ကဖတ်ပြနိုင်ရန်အတွက် Configuration Profiles ပြုလုပ်နိုင်ပါသည်။

General Setting မှလွဲ၍ Setting အတော်များများကို Profile တစ်ခုအနေဖြင့် အသုံးပြုနိုင်သည်။

Configuration profiles သည် ကိုယ်တိုင်ပြုလုပ်နိုင်သည်။
သက်ဆိုင်သည့် အက်ပလီကေးရှင်းများကို အလိုလျောက် ပြောင်းလဲပေးသည်။

#### Basic Management {#toc174}

NVDA menu ထဲတွင် Configuration Profile များကို ရွေးချယ်ပြုလုပ်နိုင်သည်။
Key command ဖြင့်လဲ ပြုလုပ်နိုင်သည်:
<!-- KC:beginInclude -->

* NVDA+control+p: Configuration Profiles dialog Box ပေါ်လာလိမ့်မည်။

<!-- KC:endInclude -->

ပထမဦးစွာ Profile Dialog Box ထဲတွင် သင်နှစ်သက်ရာတစ်ခုကိုရွေးနိုင်သည်။
Dialog Box ပွင့်လာသောအခါ မိမိလက်တလောသုံးနေသော အက်ပလီကေးရှင်းသည် အလိုလျောက်ရွေးချယ်ပြီးသားဖြစ်သည်။
သင့်အနေဖြင့် ကိုယ်တိုင်ရွေး၍လဲ ပြင်ဆင်နိုင်သည်။

Profile ကို အမည်ပေးလိုလျှင် သို့မဟုတ် ဖျတ်လိုလျှင် Rename Button သို့မဟုတ် Delete Button အသီးသီးကို နှိပ်နိုင်သည်။

ပိတ်လိုလျှင် Close button ကိုနှိပ်ပါ။

#### Creating a Profile {#toc175}

Profile ကို အသစ်ပြုလုပ်လိုလျှင် New button ကိုနှိပ်ပါ။

New Profile dialog box ပေါ်လာလျှင် နာမည်ပေးပြီး မည်သို့အသုံးပြုမည်ကို ရွေးချယ်နိုင်သည်။
အကယ်၍ Profile ကို Manual အတိုင်းအသုံးပြုလိုလျှင် Manual ကို မူလအနေဖြင့်ရွေးပြီးသားဖြစ်သည်။
အသေးစိတ်သိရှိလိုလျှင် [below](#ConfigProfileTriggers) တွင်လေ့လာနိုင်သည်။

Profile ကိုအသစ်ပြုလုပ်ပြီးသောအခါ OK ကိုနှိပ်ပါ။ ပြီးနောက် close ကိုနှိပ်၍ ပိတ်ပါ။

#### Manual Activation {#ConfigProfileManual}

Manual ကိုသုံးလိုလျှင် Manual Activation ကိုရွေးပါ။
သင့်အနေဖြင့် Profile တစ်ခုကို Activate ပြုလုပ်ပါက အခြား Profile များပါ အလိုလျောက်ပြင်ပြီးဖြစ်သည်။
သင့်အနေဖြင့် Deactivate ပြုလုပ်လိုလျှင် Profile Dialog Box ထဲမှ Deactivate Button ကိုနှိပ်ပါ။

#### Triggers {#ConfigProfileTriggers}

Triggers Button ကို Creating Profile ထဲတွင်နှိပ်နိုင်သည်။Triggers အမျိုးစားများစွာရှိသည်။

Triggers List ထဲတွင်:

* Current application: မိမိလတ်တလောအသုံးပြုနေသော အက်ပလီကေးရှင်းကို အလုပ်လုပ်ပေးခြင်းဖြစ်သည်။
* Say all: မိမိပြင်ဆင်ထားသည့်အတိုင်း အက်ပလီကေးရှင်းတွင်ဖတ်သည်။

လက်ရှိပြင်ဆင်ထားသော Profile ကိုအသုံးမပြုလိုလျှင် Normal Configuration ကိုရွေးချယ်ပါ။

Close button ကိုနှိပ်၍ Configuration Profiles dialog box ထဲသို့ပြန်ရောက်သွားမည်။

#### Editing a Profile {#toc178}

အကယ်၍ ပြုလုပ်ပြီးသော Profile များကို ပြင်ဆင်လိုလျှင် ပြန်လည်ပြင်ဆင်နိုင်သည်။
ဥပမာ အကယ်၍ Notepad Application ကိုရွေးလိုက်လျှင် အခြား Setting များတွင်လည်း Notepad ၏Setting အတိုင်းဖြစ်သွားသည်။
Trigger ထဲတွင်လည်း မည်သည့် Setting ကိုရွေးသည်ဖြစ်စေ အခြား Profile များကိုလဲပြောင်းလဲသွားသည်။

အကယ်၍ Profile ထဲတွင် say allကို ရွေးချယ်လိုလျှင် မိမိကိုယ်တိုင် Activate ပြုလုပ်ရမည်။[manually activate](#ConfigProfileManual) 

#### Temporarily Disabling Triggers {#toc179}

တစ်ခါတစ်ရံတွင် Temporarily Disabling Triggers သည်အရေးပါသည်။
ဥပမာ မိမိ ပြုလုပ်ထားသော Trigger နှင့် Profile ကို အသုံးမပြုလိုလျှင် Temporarily disable tirgger ကို အမှန်ခြစ်ထားပါ။

### Location of Configuration files {#toc180}

Custom appModules နှင့် custom drivers များသည် NVDA Portable folder ထဲရှိ userConfig ထဲတွင်တွေ့နိုင်သည်။

Installed versions တွင် custom appModules နှင့် custom drivers ကို Windowss user profile တွင်တွေ့နိုင်သည်။

Logon သို့မဟုတ် UAC screens တွင် လက်ရှိ Settings အတိုင်းအသုံးပြုလိုလျှင် General Setting အတွင်းရှိ Use currently saved settings on the logon and other secure screens ကိုနှိပ်ပါ။

## Extra Tools {#toc181}
### Log Viewer {#toc182}

Log viewer ကို NVDA menu Tool ထဲတွင်ရှာပါ။ Log viewer ထဲတွင် NVDA အသုံးပြုသည့် အသေးစိတ်အချိန်ဇယားများကိုတွေ့နိုင်ပါသည်။

Viewer File ထဲရှိအချက်လက်များကို ကူးယူနိုင်သည်။

### Speech Viewer {#toc183}

NVDA မှ ပြောဆိုသည့်အရာများကို Developer များနှင့် မျက်စိမြင်သူများ သိနိုင်ရန်အတွင် အပေါ် မှ အောက်သို့ စာတန်းဖြင့်ဖော်ပြပေးသည်။

NVDA menu ထဲမှ Tool တွင် နှိပ်၍ ပိတ်နိုင် ဖွင့်နိုင်သည်။

Windows တက်သည်နှင့် Speech Viewer ကိုတက်လိုလျှင် Show speech viewer on startup ကိုအမှန်ခြစ်ထားပါ။

Speech Viewer အလုပ်လုပ်နေလျှင် NVDA မှဖော်ပြလေသောစာများကိုကူးယူနိုင်သည်။

Speech viewer ကို မိမိရောက်နေသည့်နေရာမှ ဖွင့်လိုလျှင်[Input Gestures dialog](#InputGestures) ထဲတွင် gesture ထည့်သွင်းနိုင်သည်။

### Add-ons Manager {#toc184}

 Add-ons Manager ကို NVDA Menu Tool တွင်ရှာဖွေနိုင်သည်။ Install, Uninstall, Anable နှင့် Disable ပြုလုပ်နိုင်သည်။
Community မှပြုလုပ်ထားသော Extra Braille Display  သို့မဟုတ် Speech Synthesizer များလဲထည့်သွင်းနိုင်သည်။

Add-ons Manager list ထဲတွင် Application တစ်ခုကိုရွေး၍ ၎င်း Application နှင့်ပါတ်သတ်သော အသေးစိတ်ကိုသိလိုလျှင် About add-ons ကိုနှိပ်ပါ။
မည်သို့မည်ပုံ အသုံးပြုရမည်ကို help button ကိုနှိပ်ပါ။

အသုံးပြုနိုင်သည့် add-ons များကို download လုပ်လိုလျှင် Get add-ons button ကိုနှိပ်ပါ။
၎င်း button မှဖွင့်ပေးပါလိမ့်မည် NVDA Add-ons Page ဖြစ်သော[NVDA Add-ons page](https://addons.nvda-project.org/)ကိုဖွင့်ပေးပါလိမ့်မည်။

NVDA Add-on Install လုပ်လိုလျှင် Install button ကိုနှိပ်ပါ။
ထို့နောက် add-on package ဖိုင်ကိုရှာ၍  နှိပ်ပါ။ထို့နောက် Installation စတင်မည်။

Installation စတင်သောအခါ ပထမဦးစွာ NVDA ကမေးပါလိမ့်မည်။ Install တကယ်လုပ်မလားဆိုတာကိုမေးပါလိမ့်မည်။
အဘယ်ကြောင့်ဆိုသော် မိမိကိုယ်ရေးကိုယ်တာအချက်လက်များကို ကာကွယ်ရန်ဖြစ်သည်။
Add-on Install လုပ်ပြီးသောအခါ NVDA ကို restart ချပြီးနောက် စတင်အလုပ်လုပ်မည်။
Restart မချမှီ Add-on List ထဲတွင် မိမိထည့်သွင်းထားသော Add-on ကိုဖော်ပြပါလိမ့်မည်။

Add-on ကိုပြန်လည်ဖြုတ်လိုလျှင် Remove button ကိုနှိပ်ပါ။
NVDA က တကယ်ဖျတ်မှာလားဆိုတာကိုမေးပါလိမ့်မည်။
ထို့နောက် Restart ချပြီးသောအခါ ပျက်သွားပါလိမ့်မည်။
Restart မချမှီ Add-on List ထဲတွင် မိမိထည့်သွင်းထားသော Add-on ကိုဖော်ပြပါလိမ့်မည်။

Add-on ကို disable လုပ်လိုလျှင် disable button ကိုနှိပ်ပါ။
Add-on ကို enable လုပ်လိုလျှင် enable button ကိုနှိပ်ပါ။
Enable သို့မဟုတ် Disable ကိုနှိပ်သောအခါ NVDA Restart ဖြစ်သွာလိမ့်မည်။
NVDA ကို install သို့မဟုတ် remove လုပ်သောအခါ restart လုပ်ပေးရန်လိုအပ်သည်။

Add-on manager ကိုဖြုတ်လိုလျှင် Close button ကိုနှိပ်ပါ။

NVDA သည် copying individual plugins နှင့် drivers ကို NVDA user Configuration directory ထဲတွင် ကူးယူထားသည်။သို့သော် Add-on Manager တွင်ဖော်ပြထားခြင်းမရှိပါ။

မိမိရောက်နေသည့်နေရာမှ Add-ons Manager ကိုဖွင့်လိုလျှင်[Input Gestures dialog](#InputGestures)ထဲတွင် Gesture ပြုလုပ်ထားပါ။

### Python Console {#toc185}

NVDA Python console ကို NVDA menu tool ထဲတွင်ရှာဖွေနိုင်သည်။ ၎င်းသည် Developer Tool ဖြစ်ပြီး debugging ပြုလုပ်ရန်နှင့် NVDA ၏တည်စောက်ပုံအတွင်းပိုင်းအားစစ်စေးရန် သို့မဟုတ် NVDA application ၏ accessibility အခြေအနေအဆင့်ဆင့်ကို သိရှိနိုင်သည်။ 
အသေးစိတ်သိလိုပါက [the Development section of the NVDA web site](https://community.nvda-project.org/wiki/Development)တွင်သွားရောက်လေ့လာနိုင်ပါသည်။

### Reload plugins {#toc186}

Reload plugins ကိုနှိပ်လိုက်လျှင် reloads app modules နှင့် global plugins များ restart လုပ်စရာမလိုပဲ အသုံးပြုနိုင်သည်။၎င်း Function သည် Developer များအတွက်ဖြစ်သည်။

## Supported Speech Synthesizers {#SupportedSpeechSynths}

အလကားရယူနိုင်သော synthesizer များနှင့် ဝယ်ယူသုံးစွဲရသော synthesizer များကို လေ့လာပါစို့[https://www.nvda-project.org/wiki/ExtraVoices](https://www.nvda-project.org/wiki/ExtraVoices).

### eSpeak NG {#toc188}

[eSpeak NG](https://github.com/espeak-ng/espeak-ng) eSpeak NG ကို NVDA တွင် မူလတည်းကထည့်သွင်းပြီးသားဖြစ်သည်။ Driver နှင့် အခြား component များ ထည့်သွင်းစရာမလိုပါ။
NVDA ကို USB thumb drive နှင့် အခြားသော System များပေါ်တွင်သုံးနိုင်သည်။

ဘာသာစကားပေါင်း ၄၃ မျိုးကျော် အလုပ်လုပ်နိုင်သည်။

အသံမျိုးစားပေါင်းများစွာ ရွေးချယ်နိုင်သည်။

### Microsoft Speech API version 4 (SAPI 4) {#toc189}

SAPI 4 သည် Microsoft ၏အစောဆုံး speech synthesizer ဖြစ်သည်။
အသုံးပြုသူသည် SAPI 4 ကို install လုပ်ထားလျှင် NVDA သည်အလုပ်လုပ်နေဆဲဖြစ်သည်။
သို့သော် နောက်ထပ်မံထွက်ရှိလာမည့် Windows များတွင် SAPI 4 အတွက်အလုပ်လုပ်တော့မည်မဟုတ်ပါ။

အကယ်၍ ၎င်း synthesizer ကို အသုံးပြုလျှင် Voice Settings ထဲတွင် အသံများပြောင်းလဲနိုင်သည်။(accessed from the [Voice Settings dialog](#VoiceSettings) or by the [Synth Settings Ring](#SynthSettingsRing)) SAPI 4 ကို synthesizer ထဲတွင်ရွေးချယ်နိုင်သည်။

### Microsoft Speech API version 5 (SAPI 5) {#toc190}

SAPI 5 သည် Microsoft ၏standard speech synthesizers ဖြစ်သည်။
အနည်းဆုံး အနေဖြင့် SAPI 5 ၏ Voice တစ်ခုကိုထည့်သွင်းပြီးသားဖြစ်သည်။
အကယ်၍ ၎င်း synthesizer ကို အသုံးပြုလျှင် Voice Settings ထဲတွင် အသံများပြောင်းလဲနိုင်သည်။(accessed from the [Voice Settings dialog](#VoiceSettings) or by the [Synth Settings Ring](#SynthSettingsRing)) SAPI 5 ကို synthesizer ထဲတွင်ရွေးချယ်နိုင်သည်။

### Microsoft Speech Platform {#toc191}

Microsoft Speech Platform သည် အသံများစွာနှင့် languages များစွာအတွက် အထောက်ကူပြုသည်။ ၎င်းအသံများကိုလဲ NVDA တွင်အသုံးပြုသည်။

၎င်းအသံများကို အသုံးပြုလိုလျှင် install လုပ်ရန်လိုအပ်သည်:

* Microsoft Speech Platform - Runtime (Version 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Version 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * ၎င်း page တွင် speech recognition နှင့် text-to-speech များရွေးချယ်နိုင်သည်။
ဥပမာ MSSpeech_TTS_en-US_ZiraPro.msi သည် U.S. English voice ဖြစ်သည်။

### Audiologic Tts3 {#toc192}

၎င်းသည် Italian language အတွက် ဝယ်၍သုံးရသော synthesizer ဖြစ်သည်။
အသေးစိတ်သိရှိလိုပါက [www.audiologic.it](http://www.audiologic.it) တွင်သွားရောက်လေ့လာနိုင်ပါသည်။

၎င်း synthesizer သည်[spelling functionality](#VoiceSpellingFunctionality)အတွက်အလုပ်မလုပ်ပါ။

### Nuance Vocalizer for NVDA {#toc193}

Nuance Vocalizer သည် အရည်အသွေးကောင်းမွန်သော ဝယ်သုံးရသည့် synthesizer ဖြစ်သည်။၎င်းကို Nuance Communications, Inc မှဖန်တီးတီထွင်ထားခြင်းဖြစ်သည်။ 
၎င်းတွင် အသံပေါင်း ၅၀ ကျော်ပါဝင်ပြီး ဘာသာစကားပေါင်း ၃၀ ကျော် Install လုပ်နိုင်သည်။
NVDA portable version တွင်လဲအသုံးပြုနိုင်သည်။

အသေးစိတ်အချက်လက်များနှင့် မည်သို့ဝယ်ယူရမည်ကို သိရှိလိုလျှင်[www.vocalizer-nvda.com](https://www.vocalizer-nvda.com/) တွင် သွားရောက်လေ့လာနိုင်ပါသည်။
ရောင်းရသည့် အမြတ်ငွေ၏ ရာခိုင်နှုန်းအချို့ကို NVDA အတွက်ပြန်လည်လှူဒါန်းသည်။

## Supported Braille Displays {#SupportedBrailleDisplays}

၎င်းနှင့်ပါတ်သတ်သောအချက်လက်များကို Braille displays supported တွင်ဖော်ပြထားသည်။

### Freedom Scientific Focus/PAC Mate Series {#toc195}

All Focus နှင့် PAC Mate displays ကို[Freedom Scientific](https://www.freedomscientific.com/)တွင်။
သင့်အနေဖြင့် Freedom Scientific braille display drivers ကို install လုပ်ထားရန်လိုအပ်သည်။
အကယ်၍သင့်မှာမရှိလျှင် https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp.
၎င်း Page အနေဖြင့် Focus Blue display driver ကိုရည်ညွှန်းသည်။

NVDA အနေဖြင့် USB သို့မဟုတ် bluetooth ဖြင့်အလိုလျောက်ချိတ်ဆက်သည်။
သို့သော် USB သို့မဟုတ် bluetooth ကိုရွေးချယ်ပေးရန်လိုအပ်သည်။
၎င်း Function သည် များစွာအသုံးဝင်သည်။ အကယ်၍ Bluetooth ဖြင့်ချိတ်ထားပါက usb ဖြင့်အားသွင်းနိုင်သည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |topRouting1 (first cell on display)|
|Scroll braille display forward |topRouting20/40/80 (last cell on display)|
|Scroll braille display back |leftAdvanceBar|
|Scroll braille display forward |rightAdvanceBar|
|Toggle braille tethered to |leftGDFButton+rightGDFButton|
|Toggle left wiz wheel action |leftWizWheelPress|
|Move back using left wiz wheel action |leftWizWheelUp|
|Move forward using left wiz wheel action |leftWizWheelDown|
|Toggle right wiz wheel action |rightWizWheelPress|
|Move back using right wiz wheel action |rightWizWheelUp|
|Move forward using right wiz wheel action |rightWizWheelDown|
|Route to braille cell |routing|
|backspace key |dot7|
|enter key |dot8|
|shift+tab key |brailleSpaceBar+dot1+dot2|
|tab key |brailleSpaceBar+dot4+dot5|
|upArrow key |brailleSpaceBar+dot1|
|downArrow key |brailleSpaceBar+dot4|
|control+leftArrow key |brailleSpaceBar+dot2|
|control+rightArrow key |brailleSpaceBar+dot5|
|leftArrow |brailleSpaceBar+dot3|
|rightArrow key |brailleSpaceBar+dot6|
|home key |brailleSpaceBar+dot1+dot3|
|end key |brailleSpaceBar+dot4+dot6|
|control+home key |brailleSpaceBar+dot1+dot2+dot3|
|control+end key |brailleSpaceBar+dot4+dot5+dot6|
|alt key |brailleSpaceBar+dot1+dot3+dot4|
|alt+tab key |brailleSpaceBar+dot2+dot3+dot4+dot5|
|escape key |brailleSpaceBar+dot1+dot5|
|Windowss key |brailleSpaceBar+dot2+dot4+dot5+dot6|
|space key |brailleSpaceBar|
|Windowss+d key (minimize all applications) |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|Report Current Line |brailleSpaceBar+dot1+dot4|
|NVDA menu |brailleSpaceBar+dot1+dot3+dot4+dot5|

Rocker bar keys ပါဝင်သော Focus models အသစ်များအတွက် ဆုံမှတ် ၄၀၊ ဆုံမှတ် ၈၀ နှင့် ဆုံမှတ်အပြာ(focus 40, focus 80 and focus blue):

| Name |Key|
|---|---|
|Braille display ကိုနောက်တစ်လိုင်းသို့ရွေ့ရန် |leftRockerBarUp, rightRockerBarUp|
|Braille display ကိုရှေ့တစ်လိုင်းသို့ရွေ့ရန် |leftRockerBarDown, rightRockerBarDown|

For Focus 80 only:

| Name |Key|
|---|---|
|Scroll braille display back |leftBumperBarUp, rightBumperBarUp|
|Scroll braille display forward |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA BC640/680 {#toc196}

ALVA BC640 နှင့် BC680 displays [Optelec](https://www.optelec.com/) 
၎င်း Display တွင် Driver ထည့်သွင်းစရာမလိုပါ။
အလွယ်တကူချိတ်ဆက်ပြီး NVDA တွင် configure လုပ်၍ သုံးနိုင်သည်။

၎င်း Display မှ Brail Keyboard ကိုသုံးလျှင် Brail to Text ကို အလိုလျှောက်ပြုလုပ်ပေးသည်။
NVDA ၏ braille input table setting နှင့် မသက်ဆိုင်ပါ။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |t1 or etouch1|
|Move braille display to previous line |t2|
|Move to current focus |t3|
|Move braille display to next line |t4|
|Scroll braille display forward |t5 or etouch3|
|Route to braille cell |routing|
|Move to top line in review |t1+t2|
|Move to bottom line in review |t4+t5|
|Toggle braille tethered to |t1+t3|
|Report title |etouch2|
|Report status bar |etouch4|
|shift+tab key |sp1|
|alt key |sp2|
|escape key |sp3|
|tab key |sp4|
|upArrow key |spUp|
|downArrow key |spDown|
|leftArrow key |spLeft|
|rightArrow key |spRight|
|enter key |spEnter|
|Report date/time |sp1+sp2|
|NVDA Menu |sp1+sp3|
|Windowss+d key (minimize all applications) |sp1+sp4|
|Windowss+b key (focus system tray) |sp3+sp4|
|Windowss key |sp2+sp3|
|alt+tab key |sp2+sp4|
|control+home key |t3+spUp|
|control+end key |t3+spDown|
|home key |t3+spLeft|
|end key |t3+spRight|

<!-- KC:endInclude -->

### Handy Tech Displays {#toc197}

NVDA သည် Handy Tech Displays အားလုံးပေါ်တွင်အလုပ်လုပ်သည်။[Handy Tech](https://www.handytech.de/) 
ရှေးကျသော USB displays များကိုသုံးလျှင် Handy Tech USB Displays driver ကိုinstall လုပ်ရန်လိုအပ်သည်။

Braille input အတွက်အလုပ်မလုပ်ပါ။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left, up|
|Scroll braille display forward |right, down|
|Move braille display to previous line |b4|
|Move braille display to next line |b5|
|Route to braille cell |routing|
|shift+tab key |esc|
|alt key |b2+b4+b5|
|escape key |b4+b6|
|tab key |enter|
|enter key |esc+enter|
|upArrow key |leftSpace|
|downArrow key |rightSpace|
|NVDA Menu |b2+b4+b5+b6|
|Handy Tech configuration |b4+b8|

<!-- KC:endInclude -->

### MDV Lilli {#toc198}

Lilli braille display ကို[MDV](https://www.mdvbologna.it/) 
၎င်း Display တွင် Driver ထည့်သွင်းစရာမလိုပါ။
အလွယ်တကူချိတ်ဆက်ပြီး NVDA တွင် configure လုပ်၍ သုံးနိုင်သည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကိုသိရှိရန် display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display backward |LF|
|Scroll braille display forward |RG|
|Move braille display to previous line |UP|
|Move braille display to next line |DN|
|Route to braille cell |route|
|shift+tab key |SLF|
|tab key |SRG|
|alt+tab key |SDN|
|alt+shift+tab key |SUP|

<!-- KC:endInclude -->

### Baum/Humanware/APH/Orbit Braille Displays {#toc199}

Several [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/), [APH](https://www.aph.org/) and [Orbit](https://www.orbitresearch.com/) USB, bluetooth or serial တို့ဖြင့်အလုပ်လုပ်သည်။
These include:

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!, SuperVario2, Vario 340
* HumanWare: Brailliant, BrailleConnect, Brailliant2
* APH: Refreshabraille
* Orbit: Orbit Reader 20

အခြားသော Baum များသည်လည်း အလုပ်လုပ်သည်။ သို့သော် စမ်းသပ်၍မပြီးမြောက်သေးပါ။

စက်ရုံမှထုတ်ထားသော USB driver ကိုထည့်ပြီမှ ချိတ်ဆက်ပြီးအသုံးပြုပါ။

Orbit Reader 20 တွင် USB serial mode သည် Windowss 10 တွင်သာအလုပ်လုပ်သည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကိုသိရှိရန် display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |d2|
|Scroll braille display forward |d5|
|Move braille display to previous line |d1|
|Move braille display to next line |d3|
|Route to braille cell |routing|

Joystick ပါဝင်သော display များအတွက်:

| Name |Key|
|---|---|
|upArrow key |up|
|downArrow key |down|
|leftArrow key |left|
|rightArrow key |right|
|enter key |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#toc200}

The hedo ProfiLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
ပထမဦစွာ စက်ရုံမှထုတ်ထားသော USB driver ကို install လုပ်ရမည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#toc201}

The hedo MobilLine USB from [hedo Reha-Technik](https://www.hedo.de/) is supported.
ပထမဦစွာ စက်ရုံမှထုတ်ထားသော USB driver ကို install လုပ်ရမည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |K1|
|Scroll braille display forward |K3|
|Move braille display to previous line |B2|
|Move braille display to next line |B5|
|Route to braille cell |routing|
|Toggle braille tethered to |K2|
|Say all |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series {#toc202}

HumanWare မှ Brailliant BI နှင့် B display series များသည် [HumanWare](https://www.humanware.com/), မှဖြစ်ပြီး BI 32, BI 40 and B 80 များလည်းပါဝင်ကာ USB သို့ bluetooth ဖြင့်ချိတ်ဆက်၍လည်း အသုံးပြုနိုင်သည်။
USB ဖြင့် သုံးမည်ဆိုပါက USB driver ကို ဦးစွာ install လုပ်ရမည်။
Bluetooth ဖြင့်သုံးမည်ဆိုပါက USB driver Install လုပ်ရန်မလိုအပ်ပါ။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |down|
|Route to braille cell |routing|
|Toggle braille tethered to |up+down|
|upArrow key |space+dot1|
|downArrow key |space+dot4|
|leftArrow key |space+dot3|
|rightArrow key |space+dot6|
|NVDA Menu |c1+c3+c4+c5 (command n)|
|shift+tab key |space+dot1+dot3|
|tab key |space+dot4+dot6|
|alt key |space+dot1+dot3+dot4 (space+m)|
|escape key |space+dot1+dot5 (space+e)|
|enter key |dot8|
|Windowss+d key (minimize all applications) |c1+c4+c5 (command d)|
|Windowss key |space+dot3+dot4|
|alt+tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Say all |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE/Smart Beetle Series {#toc203}

NVDA သည် Hims ၏ထုတ်ကုန်များဖြစ်သော Braille Sense၊ Braille EDGE နှင့် Smart Beetle displays [Hims](https://www.hims-inc.com/) တို့အား USB သို့မဟုတ် bluetooth ဖြင့်ချိတ်ဆက်ကာအသုံးပြုနိုင်သည်။
အကယ်၍ USB ဖြင့်သုံးမည်ဆိုလျှင် USB driver ကို Install လုပ်ထားရန်လိုအပ်သည်။
သင့်အနေဖြင့် Download လုပ်လိုလျှင်: https://www.himsintl.com/?c=2/13&uid=2319

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Move braille display to previous line |left side scroll up|
|Move braille display to next line |right side scroll up|
|Route to braille cell |routing|
|shift+tab key |dot1+dot2+space|
|alt key |dot1+dot3+dot4+Space|
|escape key |dot1+dot5+Space|
|tab key |dot4+dot5+Space|
|enter key |dot8|
|backspace key |dot7|
|upArrow key |dot1+Space|
|downArrow key |dot4+Space|
|capsLock |dot1+dot3+dot6+space|
|shift+alt+tab key |advance2+advance3+advance1|
|alt+tab key |advance2+advance3|
|end key |dot4+dot6+space|
|Control+end key |dot4+dot5+dot6+space|
|home key |dot1+dot3+space|
|control+home key |dot1+dot2+dot3+space|
|leftArrow key |dot3+space|
|control+shift+leftArrow key |dot2+dot8+space+advance1|
|control+leftArrow key |dot2+space|
|shift+alt+leftArrow key |dot2+dot7+advance1|
|alt+leftArrow key |dot2+dot7|
|rightArrow key |dot6+space|
|control+shift+rightArrow key |dot5+dot8+space+advance1|
|control+rightArrow key |dot5+space|
|shift+alt+rightArrow key |dot5+dot7+advance1|
|alt+rightArrow key |dot5+dot7|
|pageUp key |dot1+dot2+dot6+space|
|control+pageUp key |dot1+dot2+dot6+dot8+space|
|control+shift+upArrow key |dot2+dot3+dot8+space+advance1|
|control+upArrow key |dot2+dot3+space|
|shift+alt+upArrow key |dot2+dot3+dot7+advance1|
|alt+upArrow key |dot2+dot3+dot7|
|shift+upArrow key |left side scroll down + space|
|pageDown key |dot3+dot4+dot5+space|
|control+pagedown key |dot3+dot4+dot5+dot8+space|
|control+shift+downArrow key |dot5+dot6+dot8+space+advance1|
|control+downArrow key |dot5+dot6+space|
|shift+alt+downArrow key |dot5+dot6+dot7+advance1|
|alt+downArrow key |dot5+dot6+dot7|
|shift+downArrow key |right side scroll down + space|
|delete key |dot1+dot3+dot5+space|
|f1 key |dot1+dot2+dot5+space|
|f3 key |dot1+dot2+dot4+dot8|
|f4 key |dot7+advance3|
|Windowss+b key |dot1+dot2+advance1|
|Windowss+d key |dot1+dot4+dot5+advance1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc204}

NVDA သည် [HIMS](https://www.hims-inc.com/) မှထုတ်လုပ်ထားသော SyncBraille Display များအားထောက်ပံ့ပေးနိုင်သည်။
အသုံးပြုလိုပါက သင်၏ system တွင် HIMS ၏ USB drivers အားတင်ထားရမည်ဖြစ်သည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left side scroll down|
|Scroll braille display forward |right side scroll down|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Seika Braille Displays {#toc205}

Seika Version ၃, ၄ နှင့် ၅ သည် (40 cells) နှင့် Seika80 (80 cells) တို့သည် braille displays များဖြစ်ကြပြီး [Nippon Telesoft](https://www.nippontelesoft.com/) မှဖြစ်ကာ ၎င်းတို့ကိုလည်းထောက်ပံ့ပေးနိုင်သည်။
များစွာသောအချက်လက်များကို  https://www.seika-braille.com/ တွင်ရှာဖွေနိုင်သည်။
ပထမဦစွာ စက်ရုံမှထုတ်ထားသော USB driver ကို install လုပ်ရမည်။

အောက်ပါ key assignments များသည် NVDA နှင့် display တွဲသုံးရန်ဖြစ်သည်။
ဤ keys များအားမည့်သည့်နေရာတွင်ထားရှိသည်ကို display ၏ documentation တွင်အသေးစိတ်ဖော်ပြထားပါသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |b3|
|Move braille display to next line |b4|
|Toggle braille tethered to |b5|
|Say all |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|NVDA Menu |left+right|
|Route to braille cell |routing|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Newer Models {#toc206}

အောက်ပါ Braille displays များအားထောက်ပံ့ပေးနိုင်သည်: 

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB နှင့် bluetooth)
* BRAILLEX Live 20, BRAILLEX Live နှင့် BRAILLEX Live Plus (USB နှင့် bluetooth)

အကယ်၍ BrxCom install လုပ်ထားလျှင် BrxCom ဖြင့် NVDA အသုံးပြုနိုင်သည်။
BrxCom သည် braille display function နှင့်မတူဘဲ screen reader မှာ လွယ်ကူစွာအသုံးပြုနိုင်သည်။
BrxCom version အသစ်သည် မကြာမီ NVDA အတွင် အလုပ်လုပ်လိမ့်မည်။
Keyboard input သည် Trio နှင့် BRAILLEX Live model များတွင်ပါလာလိမ့်မည်။

ယေဘုအားဖြင့် အောက်ပါ keys များသည် ဤ braille displays များတွင်ပါဝင်သည်။

|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

အောက်တွင်ပေးထားသော အချက်များသည် NVDA အတွက် Papenmeier command assignments များဖြစ်ကြသည်။
<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report title |l1+up|
|Report Status Bar |l2+down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |left2|
|Move to next object |right2|
|Report text formatting |upper routing row|

<!-- KC:endInclude -->

The Trio model သည် keys လေးခုအပိုပါလာပြီး ၎င်းတို့အား braille keyboard ၏အရှ့ဘက်တွင်တွေ့ရှိနိုင်သည်။ 
၎င်းတို့အား ဘယ်မှညာဘက်တို့စီထားသည်။

* left thumb key (lt)
* space
* space
* right thumb key (rt)

ယခုအချိန်တွင် ညာဘက်လက်မှခလုတ်သည် အသုံးပြုခြင်းမရှိသေးပါ။
အတွင်းပိုင်းခလုတ်များအား space ဘက်သို့ဉီးတည်ထားသည်။


| Name |Key|
|---|---|

<!-- KC:beginInclude -->

|backspace key |dot 7|
|enter key |dot 8|
|escape key |space with dot 7|
|upArrow key |space with dot 2|
|leftArrow key |space with dot 1|
|rightArrow key |space with dot 4|
|downArrow |space with dot 5|
|control key |lt+dot2|
|alt key |lt+dot3|
|control+escape key |space with dot 1 2 3 4 5 6|
|tab key |space with dot 3 7|

<!-- KC:endInclude  -->

### Papenmeier Braille BRAILLEX Older Models {#toc207}

အောက်ပါ braille displays များအားထောက်ပံ့ပေးနိုင်ပါသည်: 

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

မှတ်ချက် ၎င်း Display များနှင့် serial port ဖြင့်သာအလုပ်လုပ်သည်။
ထို့ကြောင့် Braille Settings တွင် ချိတ်ဆက်ပြီးနောက်ရွေးချယ်ပေးရန်လိုအပ်သည်။

ယေဘုအားဖြင့် အောက်ပါ keys များသည် ဤ braille displays များတွင်ပါဝင်သည်။

| Name |Key|
|---|---|
|l1 |Left front key|
|l2 |Left rear key|
|r1 |Right front key|
|r2 |Right rear key|
|up |1 Step up|
|up2 |2 Steps up|
|left |1 Step left|
|left2 |2 Steps left|
|right |1 Step right|
|right2 |2 Steps right|
|dn |1 Step down|
|dn2 |2 Steps down|

အောက်တွင်ပေးထားသော အချက်များသည် NVDA အတွက် Papenmeier command assignments များဖြစ်ကြသည်။

<!-- KC:beginInclude -->
Devices with EAB:

| Name |Key|
|---|---|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Route to braille cell |routing|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Report title |l1up|
|Report Status Bar |l2down|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to next object |right2|
|Move to previous object |left2|
|Report text formatting |Upper routing strip|

BRAILLEX Tiny:

| Name |Key|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to previous line |up|
|Move braille display to next line |dn|
|Toggle braille tethered to |r2|
|Move to containing object |r1+up|
|Move to first contained object |r1+dn|
|Move to previous object |r1+left|
|Move to next object |r1+right|
|Report text formatting |reportf|
|Report title |l1+up|
|Report status bar |l2+down|

BRAILLEX 2D Screen:

| Name |Key|
|---|---|
|Report current character in review |l1|
|Activate current navigator object |l2|
|Toggle braille tethered to |r2|
|Report text formatting |reportf|
|Move braille display to previous line |up|
|Scroll braille display back |left|
|Scroll braille display forward |right|
|Move braille display to next line |dn|
|Move to next object |left2|
|Move to containing object |up2|
|Move to first contained object |dn2|
|Move to previous object |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#toc208}

NVDA သည် BrailleNote notetakers ဖြင့်အလုပ်လုပ်သည်။[Humanware](https://www.humanware.com) 
NVDA ဖြင့်အလုပ်လုပ်နိုင်သော models များ:

* BrailleNote Classic (serial ဖြင့်သာဆက်သွယ်ခြင်း)
* BrailleNote PK (Serial နှင့် bluetooth ဆက်သွယ်ခြင်း)
* BrailleNote MPower (Serial နှင့် bluetooth ဆက်သွယ်ခြင်း)
* BrailleNote Apex (USB နှင့် Bluetooth ဆက်သွယ်ခြင်း)

အကယ်၍ သင်၏ device သည် connection type တစ်ခုထက်ပို၍အလုပ်လုပ်ပါက braille terminal options တွင်ရွေးချယ်ရမည်။
ကျေးဇူးပြုပြီး BrailleNote manual အသေးစိတ်လေ့လာပါ။
NVDA တွင် port ထည့်သွင်းရန် Braille Setting တွင်လိုအပ်သည်။
အကယ်၍ သင့်အနေဖြင့် USB သို့မဟုတ် bluetooth အသုံးပြုလိုပါက port to Automatic ကိုရွေးချယ်နိုင်သည်။
အကယ်၍ legacy serial port သို့မဟုတ် USB to serial converter ကိုအသုံးပြုလိုပါက communication port တွင်ရွေးချယ်ရမည်။

BrailleNote Apex ကို အသုံးပြုလိုပါက Driver ကို ဦးစွာထည့်သွင်းရန်လိုအပ်သည်။

အောက်ပါအချက်များသည် NVDA အတွက် BrailleNote command assignments များဖြစ်ကြသည်။
၎င်း keys များမည်သည့်နေရာတွင်ထားရှိသည်ကိုသိရှိရန်ရန်အတွက် BrailleNote's documentation တွင်လေ့လာဖတ်ရှု့ပါ။

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |back|
|Scroll braille display forward |advance|
|Move braille display to previous line |previous|
|Move braille display to next line |next|
|Route to braille cell |routing|
|Toggle braille tethered to |previous+next|
|Up arrow key |space+dot1|
|Down arrow key |space+dot4|
|Left Arrow key |space+dot3|
|Right arrow key |space+dot6|
|Page up key |space+dot1+dot3|
|Page down key |space+dot4+dot6|
|Home key |space+dot1+dot2|
|End key |space+dot4+dot5|
|Control+home keys |space+dot1+dot2+dot3|
|Control+end keys |space+dot4+dot5+dot6|
|Space key |space|
|Enter key |space+dot8|
|Backspace key |space+dot7|
|Tab key |space+dot2+dot3+dot4+dot5 (space+t)|
|Shift+tab keys |space+dot1+dot2+dot5+dot6|
|Windowss key |space+dot2+dot4+dot5+dot6 (space+w)|
|Alt key |space+dot1+dot3+dot4 (space+m)|
|Toggle input help |space+dot2+dot3+dot6 (space+lower h)|

<!-- KC:endInclude -->

### EcoBraille {#toc209}

NVDA သည် [ONCE](https://www.once.es/) မှ EcoBraille displays များအားထောက်ပံ့ပေးနိုင်သည်။ 
NVDA ဖြင့်အလုပ်လုပ်နိုင်သော models များ:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

NVDA Braille Settings ထဲတွင် serial port ဖြင့်ချိတ်ပါ။

အောက်ပါ key assignments များသည် EcoBraille displays များအတွက်ဖြစ်သည်။
၎င်း keys များမည့်သည့်နေရာတွင်တွေ့ရှိနိုင်သည်ကိုသိရှိရန် [EcoBraille documentation](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/) တွင်ဖတ်ရှု့နိုင်ပါသည်။

<!-- KC:beginInclude -->

| Name |Key|
|---|---|
|Scroll braille display back |T2|
|Scroll braille display forward |T4|
|Move braille display to previous line |T1|
|Move braille display to next line |T5|
|Route to braille cell |Routing|
|Activate current navigator object |T3|
|Switch to next review mode |F1|
|Move to containing object |F2|
|Switch to previous review mode |F3|
|Move to previous object |F4|
|Report current object |F5|
|Move to next object |F6|
|Move to focus object |F7|
|Move to first contained object |F8|
|Move System focus or caret to current review position |F9|
|Report review cursor location |F0|
|Toggle braille tethered to |A|

<!-- KC:endInclude -->

### BRLTTY {#toc210}

[BRLTTY](https://www.brltty.com/) သည် braille display အမြောက်အများအားထောက်ပံ့ပေးနိုင်သည့် သီးခြား program တစ်ခုဖြစ်သည်။
BRLTTY  ကို install လုပ်ရန်လိုအပ်သည်။ Windows အတွက်[BRLTTY for Windowss](https://www.brltty.com/download.html).
Latest Version ကို Install လုပ်သင့်သည်။ အမည်အားဖြင့် ဥပမာ brltty-win-4.2-2.exe.
အကယ်၍ USB ဖြင့်အသုံးပြုလျှင် USB Driver ကို Install လုပ်ထားပါ။

Braille keyboard BRLTTY သည် braille input ကိုအလိုလျောက်အလုပ်လုပ်သည်။
ထို့ကြောင့် NVDA table setting နှင့် မသက်ဆိုင်ပါ။

အောက်ပါအချက်များသည် NVDA အတွက် BRLTTY command assignments များဖြစ်သည်။ 
BRLTTY commands များမှ braille displays များထိန်းချုပ်ရန် မည်သို့ပုံစံဆွဲထားသည်ကို [BRLTTY key binding lists](https://mielke.cc/brltty/doc/KeyBindings/) တွင်လေ့လာဖတ်ရှု့နိုင်ပါသည်။

<!-- KC:beginInclude -->

| Name |BRLTTY command|
|---|---|
|Scroll braille display back |fwinlt (ဘယ် Windows တစ်ခုစီသို့ရွှေ့ပါ)|
|Scroll braille display forward |fwinrt (ညာ Windows တစ်ခုစီသို့ရွှေ့ပါ)|
|Move braille display to previous line |lnup (အပေါ်တစ်လိုင်းကိုသွားပါ)|
|Move braille display to next line |lndn (အောက်တစ်လိုင်းကိုသွားပါ)|
|Route to braille cell |route (character ဆီသို့ cursor အားရွှေ့ပါ)|

<!-- KC:endInclude -->

## Braille control type and state abbreviations {#toc211}

ဖြစ်နိုင်သည့် type နှင့် state 

| Abbreviation |Control type|
|---|---|
|btn |button|
|cbo |combo box|
|chk |checkbox|
|dlg |dialog|
|edt |editable text field|
|gra |graphic|
|cN |table column number n, e.g. c1, c2.|
|rN |table row number n, e.g. r1, r2.|
|hN |heading at level n, e.g. h1, h2.|
|lnk |link|
|lst |list|
|vlnk |visited link|
|mnu |menu|
|mnubar |menu bar|
|rbtn |radio button|
|tb |table|
|tv |treeview|
|lv N |a tree view item has a hierarchical level N||
|`-----` |seperator|

The following state indicators are also defined:

| Abbreviation |Control state|
|---|---|
|... |displayed when an object supports autocompletion|
|( ) |displayed when an object (e.g. a checkbox) is not checked|
|(x) |displayed when an object (e.g. a checkbox) is checked|
|(-) |displayed when an object (e.g. a checkbox) is half checked|
|- |displayed when an object (e.g. a tree view item) is collapsible|
|+ |displayed when an object (e.g. a tree view item) is Expandable|
|clk |displayed when an object is clickable|
|ro |displayed when an object (e.g. an editable text field) is read-only|
|sel |displayed when an object is selected|
|submnu |displayed when an object has a popup (usually a sub-menu)|

## Advanced Topics {#toc212}
### Command Line Options {#CommandLineOptions}

NVDA ကို Run Dialog ထဲမှလဲ Command ပေးနိုင်သည်။
လတ်တလော Run နေသော NVDA ကိုပိတ်လိုလျှင်:

nvda -q

အချို့ command line options များသသည် version အတိုနှင့် အရှည်ဟူ၍ရှိပြီး အချို့မှာမှုအလွန်ရှည်သော version များလည်းရှိသည်။
Short version တစ်ခုရှိသူများအတွက် သင်ယခုကဲ့သို့ပေါင်းလိုက်နိုင်သည်:

|nvda -rm |nvda -rm သည် လက်ရှိ Run နေသော NVDA ကိုပိတ်ပြီး NVDA အသစ်စတင်ခြင်းဖြစ်သည်။ထို့ပြင် add-ons ကိုလဲ enable ပြုလုပ်ခြင်းဖြစ်သည်။|
|nvda -rm --disable-addons |nvda -rm --disable-addons သည်အပေါ်နှင့်တူသည်။သို့သော် add-ons ကို disabled ပြုလုပ်ခြင်းဖြစ်သည်။|

အချို့ command line options များသည် parameters များထပ်မံထည့်သွင်းခြင်းကို ခွင့်ပြုသည်။ ဉပမာအားဖြင့် logging မည်မျှထိအသေးစိတ်ရမည် သို့မဟုတ် user အတွက် configuration လမ်းကြောင်းများဖြစ်ပါသည်။
ထို parameters များသည် ဤ option ၏နှောက်တွင်သာ ထားရမည်ဖြစ်ပြီး၊ short version အသုံးပြုသောအခါ ဤ option အား space ဖြင့်ခွါထားနိုင်ပြီး၊ long version အတွက်(=) sign အသုံးပြုနိုင်သည်။

|nvda -l 10 |log level ကိုစတင်သတ်မှတ်ခြင်းဖြစ်သည်။|
|nvda --log-file=c:\nvda.log |NVDA log ဖိုင်ကို c:ထဲတွင်သိမ်းထားခြင်းဖြစ်သည်။|
|nvda --log-level=20 -f c:\nvda.log |NVDA log info ကိုစတင်သတ်မှတ်ခြင်းဖြစ်သည်။|

Following are the command line options for NVDA:

| Short |Long |Description|
|---|---|---|
|-h |--help |အကူညီရယူခြင်းနှင့်ပိတ်ခြင်း|
|-q |--quit |လတ်တလော Run နေသည့် NVDA ကိုပိတ်ခြင်း|
|-r |--replace |လတ်တလော Run နေသည့် NVDA ကိုပိတ်ပြီး အလိုလျောက်ပြန်လည်ဖွင့်ခြင်း|
|-k |--check-running |NVDA အလုပ်လုပ်သည် မလုပ်သည်ကိုစစ်ဆေးခြင်းဖြစ်သည်။0 ဆိုလျှင်အလုပ်လုပ်သည် ၊ 1 ဆိုလျှင်အလုပ်မလုပ်ပါ။|
|-f LOGFILENAME |--log-file=LOGFILENAME |မည်သည့်နေရာတွင် Log File ရွေးမည်ကိုသတ်မှတ်ခြင်း|
|-l LOGLEVEL |--log-level=LOGLEVEL |The lowest level of message logged (debug 10, info 20, warning 30, error 40, critical 50), default is warning|
|-c CONFIGPATH |--config-path=CONFIGPATH |NVDA Setting မည်သည့်နေရာသိမ်းမည်ကိုသတ်မှတ်ခြင်း|
|-m |--minimal |အသံ,interface,message တို့ကိုဖျောက်ထားခြင်း|
|-s |--secure |Python console ကို disable လုပ်ထားခြင်း|
|None |--disable-addons |Addons များအပေါ် အကျိုးသက်ရောက်မှုမရှိအောင်ပြုလုပ်ခြင်း|
|None |--debug-logging |Enable debug level logging just for this run. ဤ setting သည်အခြား log level အားလုံးအားအစားထိုးသွားမည် ( --loglevel, -l) argument ပေးထားသည်.|
|None |--no-sr-flag |Don't change the global system screen reader flag|
|None |--install |Installs NVDA (NVDA အားတင်ပြီးသောအခါ အလုပ်လုပ်ပါ)|
|None |--install-silent |Silently installs NVDA (NVDA အားတင်ပြီးပြီးချင်း မစတင်ပါနှင့်)|

## Further Information {#toc214}

အကယ်၍ လိုအပ်လျှင် ဆက်လက်လေ့လာချင်ပါက ကျေးဇူးပြု၍ NVDA web site သို့ သွာရောက်လေ့လာနိုင်ပါသည်။ at NVDA_URL.

