# Ghidul Utilizatorului NVDA NVDA_VERSION

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Trimitere rapidă la comenzi -->



## Introducere {#Introducere}

Bun venit în NVDA!

NonVisual Desktop Access (NVDA) este un cititor de ecran gratuit și cu sursă disponibilă pentru sistemul de operare Microsoft Windows.
Folosind sintetizarea vocală și Braille pentru a raporta acțiunile, acesta permite nevăzătorilor și persoanelor cu deficiență de vedere să acceseze calculatoarele care rulează Windows fără un cost adițional față de persoanele cu vedere.
NVDA este dezvoltat de [NV Access](https://www.nvaccess.org/), cu contribuții din partea comunității.

### Caracteristici generale {#CaracteristiciGenerale}

NVDA permite nevăzătorilor și persoanelor cu deficiență de vedere să interacționeze și să aibă acces la sistemul de operare Windows și multe alte terțe aplicații.

Puteți găsi O demonstrare video despre ["Ce este NVDA?"](https://www.youtube.com/watch?v=tCFyyqy9mqo) pe canalul de Youtube NV Access.

Trăsăturile importante includ:

* Suport pentru aplicații populare incluzând browsere de internet, clienți de poștă electronică, programe de chat pe internet și pachete office
* Sintetizator de voce încorporat care funcționează cu peste 80 de limbi
* Pronunțarea formatării textului, unde este posibil, cum ar fi numele și dimensiunea fontului, stilul și erorile de ortografie
* Pronunțarea automată a textului de sub cursorul mausului și identificarea audio opțională a poziției mausului
* Suport pentru multe afișaje actualizabile Braille, incluzând abilitatea de detectare automată a multora dintre ele, precum și introducerea de braille pentru afișajele braille care au tastatură braille
* Capacitatea de a rula exclusiv de pe un stick USB sau alte suporturi media portabile fără nevoia instalării
* Interfață de instalare vorbită, ușor de folosit
* Tradus în 54 de limbi
* Suport pentru sistemele de operare Windows moderne, incluzând atât variantele pe 32 cât și pe 64 biți
* Capacitatea de a rula pe ecranul de autentificare în Windows și alte ecrane de siguranță
* Raportare de comenzi și text în timpul folosirii gesturilor de atingere pe ecrane tactile
* Suport pentru interfețe de control cunoscute cum ar fi Microsoft Active Accessibility, Java Access Bridge, IAccessible2 și UI Automation
* Suport pentru Windows Command Prompt și aplicații de consolă
* Capacitatea de a marca vizual focalizarea sistemului

### Internaționalizare {#Internationalizare}

Este important ca oamenii de oriunde din lume, indiferent de ce limbă vorbesc, să aibă același acces la tehnologie.
În afară de engleză, NVDA a fost tradus în 54 de limbi incluzând: afrikaans, albaneză, amharică, arabă, aragoneză, bulgară, birmană, catalană, Chineză (simplificată și tradițională), croată, cehă, daneză, ebraică, finlandeză, franceză, galiciană, greacă, georgiană, germană (Germania și Elveția), hindi, islandeză, irlandeză, italiană, japoneză, kanareză, kirghiză, lituaniană, macedoneană, maghiară, nepaleză, norvegiană, persană, poloneză, portugheză (Portugalia și Brazilia), punjabi, olandeză, română, rusă, sârbă, slovacă, slovenă, spaniolă (Spania și Columbia), suedeză, tamil, thailandeză, turcă, ucraineană și vietnameză.

### Suport pentru sintetizator de voce {#SuportSintVoce}

În afară de furnizarea mesajelor și interfeței în mai multe limbi, NVDA mai poate permite utilizatorilor să citească texte în orice limbă, atâta timp cât au un sintetizator de voce care poate vorbi acea limbă.

NVDA are încorporat [eSpeak NG](https://github.com/espeak-ng/espeak-ng), un sintetizator de voce multilingv, gratuit și cu sursă disponibilă.

Informații despre alte sintetizatoare de voce suportate de NVDA pot fi găsite în secțiunea [Sintetizatoare de voce suportate](#SintetizatoareVorbireCompatibile).

### Suport pentru Braille {#SuportBraille}

Pentru utilizatorii care dețin un afișaj braille actualizabil, NVDA poate comunica informația în braille.
Sunt compatibile tastaturi braille atât cu coduri abreviate cât și neabreviate.
Vă rugăm citiți secțiunea [Afișaje braille compatibile](#AfisBrailleCompatibile) pentru informații despre afișajele braille suportate.

NVDA suportă coduri braille pentru multe limbi, inclusiv coduri abreviate, neabreviate și braille pentru calculatoare, pentru multe limbi.

### Licență și Drept de Autor {#LicentaSiAutor}

NVDA este cu drept de autor NVDA_COPYRIGHT_YEARS pentru colaboratorii NVDA.

NVDA este acoperit de Licența GNU General Public License (Versiunea 2), cu două excepții speciale.
Aceste excepții sunt menționate în documentul licenței, la secțiunile „Non-GPL Components in Plugins and Drivers” și „Microsoft Distributable Code”.
De asemenea, NVDA include și utilizează componente care sunt disponibile sub diferite licențe gratuite și open-source.
Sunteți liberi să distribuiți sau să schimbați acest program în orice mod doriți atâta timp cât distribuiți și licența alături de program și puneți codul sursă la dispoziția oricui îl dorește. 
Acest lucru se aplică atât originalului cât și copiilor modificate ale programului, plus oricărui alt program care folosește codul extras din acest program.
Pentru alte detalii, puteți [vedea licența online.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html) (în engleză)
Pentru detaliile cu privire la excepții, accesați documentul licenței din meniul NVDA, secțiunea „Ajutor”.

## Cerințe de sistem {#CerinteSistem}

* Sisteme de operare: toate versiunile Windows 7, Windows 8, Windows 8.1 și Windows 10 pe 32 biți și 64 biți, precum și versiunile Server ale lor pornind de la Windows Server 2008 R2.
 * Pentru Windows 7, NVDA necesită Service Pack 1 sau o actualizare superioară.
 * Pentru Windows Server 2008 R2, NVDA necesită Service Pack 1 sau o actualizare superioară.
* Memorie: 256 MB de RAM sau mai mult.
* Viteza procesorului: 1.0 GHz sau mai mult
* Aproximativ 90 MB de spațiu de stocare.

## Obținerea și configurarea NVDA {#ObtSiConfigNVDA}

Dacă încă nu ați obținut o copie a NVDA, o puteți descărca de pe [site-ul NV Access](NVDA_URL).

Mergeți la secțiunea Download și veți găsi un link pentru descărcarea ultimei versiuni de NVDA.

Executând fișierul pe care tocmai l-ați descărcat, se va porni o copie temporară a NVDA.
Veți fi, apoi, întrebat dacă doriți să instalați NVDA, să creați o copie portabilă sau doar să continuați utilizarea copiei care rulează.

Dacă vă propuneți să folosiți întotdeauna NVDA pe acest calculator, veți dori să alegeți varianta instalării NVDA.
Instalarea NVDA permite funcționalități suplimentare, cum ar fi: pornire automată după autentificare, capacitatea de a citi ferestrele de Autentificare și de Securitate ale Windows (acțiuni ce nu pot fi făcute cu versiunile portabilă și temporară) și crearea de scurtături în meniul Start și pe Spațiul de Lucru.
Versiunea instalată poate de asemenea să creeze o copie portabilă oricând doriți acest lucru.

Dacă doriți să luați NVDA cu dumneavoastră pe un stick USB sau alte media inscripționabile, atunci ar trebui să alegeți crearea unei copii portabile.
-Copia portabilă are, de asemenea, capacitatea de a se instala, mai târziu, pe orice calculator.
Însă, dacă doriți să copiați NVDA pe un dispozitiv cu mod doar-citire, cum ar fi un CD, ar trebui doar să copiați pachetul descărcat.
În momentul de față, posibilitatea de rularea a versiunii portabile direct de pe un dispozitiv doar-citire nu este dezvoltată. 

Aveți, de asemenea, opțiunea să folosiți copia temporară a NVDA (de ex. în scop demonstrativ), dar pornirea NVDA în acest mod, de fiecare dată, poate deveni o mare consumatoare de timp.

### Restricții pentru copiile Portabilă și Temporară {#RestrictiiPortabilaSiTemporara}

Pe lângă incapacitatea de a porni automat în timpul și/sau după autentificare, copiile portabilă și temporară ale NVDA mai au și următoarele restricții:

* Incapacitatea de interacțiune cu aplicații care se execută cu privilegii de administrator, desigur în afara cazului în care NVDA însuși a fost pornit cu aceste privilegii (nerecomandat)
* Incapacitatea de a citi ferestre de Controlul Contului Utilizatorului (UAC) când se încearcă pornirea unei aplicații cu privilegii de administrator.
* Windows 8 și mai nou: incapacitatea de a primi intrări de la un ecran tactil.
* Windows 8 și mai nou: incapacitatea de a oferi funcționalități precum mod examinare și pronunție a caracterelor tipărite în aplicațiile Magazinului Windows (Windows Store)
* Windows 8 și mai nou: atenuarea audio nu este suportată.

### Instalarea NVDA {#InstalNVDA}

Dacă instalați NVDA direct din pachetul de instalare, apăsați butonul „Instalează NVDA”.
Dacă ați închis deja această fereastră de dialog sau doriți să instalați dintr-o copie portabilă, alegeți opțiunea „Instalează NVDA” care apare în „Instrumente” din meniul NVDA.

Fereastra de dialog a instalării care apare va confirma dacă doriți să instalați NVDA și vă va spune, de asemenea, dacă această instalare va actualiza o versiune anterioară.
Apăsând butonul „Continuă”, va porni instalarea NVDA.
În această fereastră de dialog se mai află câteva opțiuni care sunt explicate mai jos.
Odată finalizată instalarea, va apărea un mesaj care vă va notifica succesul operației.
Apăsând „OK”, în acest moment, se va reporni copia nou instalată a NVDA.

#### Avertismentul suplimentelor incompatibile {#InstallWithIncompatibleAddons}

Dacă aveți suplimente deja instalate, s-ar putea să fiți avertizat că suplimentele care sunt incompatibile vor fi dezactivate.
Înainte de a putea apăsa butonul de continuare, trebuie să bifați caseta pentru a confirma că înțelegeți că aceste suplimente vor fi dezactivate.
De asemenea, va exista și un buton care, odată apăsat, vă va da posibilitatea de a examina suplimentele ce urmează a fi dezactivate.
Consultați secțiunea [suplimentelor incompatibile](#incompatibleAddonsManager) pentru mai multe detalii cu privire la acest buton.

#### Pornirea la autentificarea în Windows {#PornireCuWindows}

Această opțiune vă permite să alegeți dacă NVDA ar trebui să pornească sau nu automat, în timpul afișării ferestrei de autentificare în Windows, înainte de a vă introduce parola.
Opțiunea include și controlul Contului Utilizatorului și alte ecrane securizate.

#### Creează scurtătură pe spațiul de lucru (ctrl+alt+n) {#CreeazaScurtaturaLucru}

Această opțiune vă permite să alegeți dacă NVDA ar trebui să creeze sau nu o scurtătură de pornire NVDA în spațiul de lucru.
Dacă este creată, acestei scurtături i se va asocia combinația control+alt+n, permițându-vă să lansați NVDA în orice moment cu această combinație de taste.

#### Copiere configurare portabilă la Contul utilizatorului curent {#CopyPortableConfigurationToCurrentUserAccount}

Această opțiune vă permite să alegeți dacă NVDA ar trebui să copieze sau nu configurarea de utilizator, din versiunea NVDA care rulează, către configurarea utilizatorului autentificat, din versiunea NVDA instalată.
Această acțiune nu va copia configurarea pentru alți utilizatori ai acestui sistem și nici pentru configurația de sistem a programului, folosită la Autentificare în Windows sau alte ecrane securizate.
Această opțiune este disponibilă doar când se face instalare dintr-o copie portabilă, nu și când se instalează direct din Pachetul de execuție descărcat.

### Crearea unei copii portabile {#CreazaCopiePortabila}

Dacă rulați crearea copiei portabile direct din pachetul NVDA descărcat, doar apăsați butonul „Creează” copie portabilă.
Dacă ați închis deja această fereastră de dialog, sau rulați o versiune instalată a NVDA, alegeți opțiunea „Creează copie portabilă” care se află în meniul „Instrumente” din meniul principal NVDA.

Fereastra de dialog care apare vă dă posibilitatea să alegeți unde va fi creată copia portabilă.
Acesta poate fi un dosar pe unitatea dumneavoastră de stocare, sau o locație pe o unitate USB sau alte media portabile.
Puteți, de asemenea, să alegeți dacă NVDA ar trebui să copieze configurarea NVDA curentă, a utilizatorului autentificat în momentul respectiv, pentru a fi folosită cu copia portabilă nou-creată.
Această opțiune este disponibilă doar când se creează o copie portabilă dintr-o copie instalată, nu și dintr-un pachet descărcat.
Apăsând „Continuă” se va crea copia portabilă.
Odată procesul de creare finalizat, va apărea un mesaj, notificându-vă că a fost realizat cu succes.
Apăsați „OK” pentru a elimina fereastra de dialog. 

## Primii pași în NVDA {#PrimiiPasiNVDA}
### Lansarea NVDA {#LansareNVDA}

Dacă ați instalat NVDA cu interfața de instalare, atunci pornirea NVDA se reduce la apăsarea control+alt+n, sau alegând NVDA din meniul NVDA aflat în meniul Start, Programe.
În plus, puteți scrie NVDA în fereastra de dialog „Executare” și apăsați „Enter”.
Puteți, de asemenea, să specificați niște [opțiuni în linie de comandă](#OptiuniLinieComanda) care vă permit ieșirea (-q), dezactivarea suplimentelor (--disable-addons), etc.

În mod implicit, Pentru copiile instalate NVDA stochează configurația în dosarul de date al aplicației de roaming a utilizatorului curent (ex. „C:\Users\<user>\AppData\Roaming”).
Puteți modifica asta într-un mod în care NVDA își încarcă în schimb configurația din dosarul local de date al aplicației.
Consultați secțiunea despre [parametrii la nivel de sistem](#ParametriGeneraliSistem) pentru mai multe detalii.

Pentru a porni versiunea portabilă, mergeți în dosarul unde ați dezarhivat NVDA și apăsați „Enter” sau faceți dublu clic pe nvda.exe.

Când NVDA pornește, mai întâi veți auzi câteva tonuri ascendente (care vă anunță că NVDA se încarcă).
În funcție de cât de rapid este calculatorul sau dacă rulați NVDA de pe un stick USB sau alt dispozitiv mai lent, poate dura ceva timp până pornește.
Dacă pornirea NVDA-ului necesită timp îndelungat, acesta ar trebui să anunțe „NVDA se încarcă. Vă rugăm așteptați...”.

Dacă nu auziți nimic din toate acestea, sau dacă auziți sunetul de eroare al Windows, sau câteva tonuri descendente, asta înseamnă că NVDA are o eroare și e posibil să trebuiască să raportați un defect dezvoltatorilor.
Vă rugăm verificați site-ul NVDA pentru informații despre cum să faceți asta.

#### Fereastra dialog de întâmpinare {#WelcomeDialog}

Când NVDA pornește pentru prima dată, veți fi întâmpinat de o fereastră de dialog care vă oferă câteva informații de bază despre tasta de modificare NVDA și meniul NVDA.
(Vă rugăm citiți secțiunile următoare în legătură cu aceste subiecte).
Fereastra de dialog conține o casetă combinată și trei  casete de bifat.
Caseta combinată vă va lăsa să selectați aspectul tastaturii.
Prima casetă de bifat vă va lăsa să alegeți dacă NVDA va folosi tasta „Caps Lock” drept tastă de modificare NVDA.
A doua specifică dacă NVDA ar trebui să pornească automat după ce vă autentificați în Windows și este disponibilă doar pentru versiunile instalate.
A treia vă va lăsa să alegeți dacă această fereastră de întâmpinare va apărea la fiecare pornire a NVDA.

#### Dialogul de statistici cu privire la utilizarea datelor {#UsageStatsDialog}

Începând cu NVDA 2018.3, utilizatorul este întrebat dacă vrea sau nu să permită ca datele de utilizare să fie trimise la NV Access pentru a ajuta la îmbunătățirea NVDA în viitor. 
La pornirea pentru prima dată a NVDA, va apărea o fereastră de dialog în care veți fi întrebat dacă acceptați trimiterea datelor către NV Access pe parcursul utilizării.
Puteți citi mai multe despre datele adunate de NV Access în secțiunea setărilor generale, [Permite proiectului NVDA să adune statistici cu privire la utilizarea NVDA](#GeneralSettingsGatherUsageStats).
Notă: Dacă apăsați pe „da” sau pe „nu” setarea va fi salvată, iar dialogul nu va mai apărea până la reinstalarea NVDA.
Cu toate acestea, puteți activa sau dezactiva manual procesul de colectare din panoul setărilor NVDA. Pentru a putea modifica manual această setare, puteți bifa sau debifa caseta numită [Permite proiectului NVDA să adune statistici cu privire la utilizarea NVDA](#GeneralSettingsGatherUsageStats).

### Despre comenzile din taste ale NVDA {#AboutNVDAKeyboardCommands}
#### Tasta de modificare NVDA {#TheNVDAModifierKey}

Majoritatea comenzilor din tastatură specifice NVDA constau, în general, în apăsarea unei anume taste, numite tasta de modificare NVDA, în combinație cu una sau mai multe alte taste.
Excepții notabile sunt comenzile de descriere ale textului pentru formatul tastaturii de birou, care folosesc doar tastele numerice, dar există și alte excepții.

NVDA poate fi configurat astfel încât fie tasta „Insert” de pe tastele numerice, tasta „Insert” secundară și/sau tasta „Caps Lock” să poată fi folosite drept tasta de modificare NVDA.
Implicit, atât „Insert” din blocul numeric cât și „Insert” secundară sunt stabilite drept taste de modificare NVDA.

Dacă doriți să faceți ca una dintre tastele de modificare NVDA să aibă funcția sa originală, dacă NVDA nu ar fi fost pornit (de exemplu doriți să activați „Caps Lock” când ați ales „Caps Lock” să fie tasta de modificare NVDA), puteți apăsa tasta de două ori rapid.

#### Formate de tastatură {#KeyboardLayouts}

În prezent, NVDA vine cu două seturi de taste de comandă (denumite și formate de tastatură): formatul de calculator de birou și cel pentru laptop.
Implicit, NVDA este configurat să folosească formatul de desktop, dar îl puteți schimba cu cel de laptop din categoria „Tastatură”, aflată în [Dialogul setărilor NVDA](#NVDASettings).

Formatul desktop folosește frecvent tastele blocului numeric (cu bloc numeric dezactivat).
Cu toate că majoritatea laptop-urilor nu au un bloc numeric pe tastatură, unele pot simula prezența acestuia prin combinații cu tasta „FN” și apăsând litere și cifre din partea dreaptă a tastaturii (7, 8, 9, u, i, o, j, k, l, etc.).
Dacă laptop-ul dumneavoastră nu poate face acest lucru, sau nu vă permite să dezactivați blocul numeric cu tasta „Num Lock”, cel mai probabil veți dori să schimbați formatul de tastatură pentru NVDA în cel pentru laptop.

### Gesturi NVDA pentru ecrane tactile {#NVDATouchGestures}

Dacă rulați NVDA pe un dispozitiv cu ecran tactil și cu Windows 8 sau mai recent, puteți controla NVDA direct prin atingeri ale ecranului.
În timp ce NVDA funcționează, toate gesturile de atingere sunt preluate de NVDA.
În consecință, acțiunile care ar putea fi făcute în mod normal, fără NVDA, nu vor funcționa.

#### Examinarea ecranului {#ExploringTheScreen}

Cea mai simplă acțiune, pe care o puteți face cu ecranul tactil, este să anunțați comanda sau textul de la orice punct al ecranului.
Pentru a face asta, puneți un deget în orice parte a ecranului.
Puteți, de asemenea, să mențineți degetul pe ecran și să îl mișcați pentru a citi alte comenzi și texte peste care trece degetul.

#### Gesturi de atingere {#TouchGestures}

Când comenzile NVDA vor fi descrise, mai jos în acest ghid, s-ar putea să enumere gesturi de atingere care pot fi folosite pentru comanda respectivă, în cazul unui ecran tactil.
Urmează câteva instrucțiuni despre cum să executați diversele gesturi.

##### Atingeri scurte {#toc27}

Atingeți scurt ecranul folosind unul sau mai multe degete.

Gestul de a atinge o dată cu un deget este cunoscut pur și simplu ca „atingere”.
Dacă folosiți două sau mai multe degete, gesturile sunt denumite „atingere cu două degete” și așa mai departe.

Dacă același tip de gest e folosit în succesiune rapidă, NVDA va trata asta ca un gest de atingere multiplă.
Atingând de două ori, va rezulta o „atingere dublă”.
Atingând de trei ori, va rezulta o „atingere triplă” și așa mai departe.
Desigur, aceste gesturi multiple recunosc și câte degete sunt folosite, deci este posibil să recunoască gesturi ca „atingere triplă cu două degete“, „atingere cu 4 degete”, etc.

##### Glisări bruște {#toc28}

Glisați rapid degetul peste ecran.

Există patru gesturi de glisare bruscă, în funcție de direcție: stânga, dreapta, sus și jos.

La fel ca în cazul atingerilor, pot fi folosite mai multe degete pentru a efectua gestul.
În consecință, sunt posibile gesturi ca „glisare bruscă sus cu două degete” sau „glisare bruscă stânga cu patru degete”.

#### Moduri de atingere {#TouchModes}

Pentru că există mult mai multe comenzi NVDA decât gesturi posibile, NVDA are mai multe moduri de atingere pe care le puteți comuta și care permit folosirea anumitor subcategorii de comenzi.
Cele două moduri sunt: modul text și modul obiect.
Anumite comenzi NVDA descrise în acest document pot avea un mod de atingere, iar acesta va fi indicat între paranteze după gestul de atingere.
Spre exemplu „glisează brusc sus (mod text)” înseamnă că respectiva comandă va fi efectuată dacă glisați rapid sus, dar doar cu modul text activat.
Dacă nu este specificat și modul lângă comandă, înseamnă că aceasta funcționează în orice mod.

<!-- KC:beginInclude -->
Pentru a comuta între modurile de atingere, efectuați o atingere cu trei degete.
<!-- KC:endInclude -->

#### Tastatura tactilă {#TastaturaTactila}

Tastatura tactilă este folosită pentru introducerea de text și comenzi de la un ecran tactil.
Când sunteți focalizat pe un câmp d editare, puteți accesa tastatura tactilă atingând de două ori iconița acesteia din partea de jos a ecranului.
Pentru tabletele precum Microsoft Surface Pro, tastatura tactilă este mereu disponibilă atunci când tastatura fizică este deconectată.
Pentru a renunța la tastatura tactilă, atingeți de două ori iconița tastaturii tactile sau treceți de câmpul de editare.

În timp ce tastatura tactilă este activă, pentru a localiza tastele de pe ea, deplasați-vă degetul acolo unde este tastatura tactilă (de obicei în partea de jos a ecranului), apoi mișcați-vă în zona tastaturii folosind un deget.
Când găsiți tasta pe care doriți să o apăsați, atingeți-o de două ori sau ridicați degetul; asta depinde de opțiunea aleasă  din [Categoria de setări  a tastaturii tactile](#Interactiune_Tactila).

### Modul de ajutor pentru intrări {#InputHelpMode}

Multe comenzi NVDA sunt menționate de-a lungul acestui ghid, dar un mod simplu de a le explora este să activați ajutorul pentru intrări.

Pentru a activa ajutorul pentru intrări, apăsați NVDA+1.
Pentru a-l dezactiva, apăsați NVDA+1 din nou.
Când ajutorul pentru intrări e activat, efectuarea oricărui gest de intrare (cum ar fi apăsarea unei taste sau un gest de atingere) va anunța acțiunea și va descrie ce face (dacă există acțiunea).
Comenzile propriu-zise nu vor funcționa în modul de ajutor pentru intrări.

### Meniul NVDA {#TheNVDAMenu}

Meniul NVDA vă permite să controlați configurația NVDA, să accesați ajutorul pentru program, să salvați preferințele personale sau să reveniți la cele anterioare, să modificați dicționarele de vorbire, să accesați instrumente adiționale sau să închideți NVDA.

Pentru a ajunge în meniul NVDA de oriunde din Windows când rulează NVDA, apăsați „NVDA+n” sau efectuați o atingere dublă cu două degete pe ecranul tactil.
Puteți deschide meniul NVDA și din zona de notificare a Windows.
Fie faceți clic dreapta pe iconița NVDA din zona de notificare a sistemului, fie accesați zona de notificare apăsând „tasta Windows+B”, apoi săgeată în jos până la iconița NVDA și apăsând tasta „Aplicații” aflată lângă tasta Control dreapta pe majoritatea tastaturilor.
Când se deschide meniul, puteți folosi săgețile direcționale pentru navigarea prin meniu și tasta Enter pentru activarea unui element.

### Comenzi NVDA de bază {#BasicNVDACommands}

<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Atingere |Descriere|
|---|---|---|---|---|
|Oprește vorbire |Control |control |atingere cu 2 degete |Oprește imediat vorbirea|
|Pauză pentru vorbire |Shift |Shift |fără |Pune vorbirea pe pauză imediat. Apăsând încă o dată va continua să vorbească de unde a rămas (dacă pauza este suportată de sintetizatorul curent)|
|Meniu NVDA |NVDA+n |NVDA+n |atingere dublă cu 2 degete |Afișează meniul NVDA pentru a vă permite să accesați preferințe, instrumente, ajutor, etc|
|Comută modul vorbire |NVDA+s |NVDA+s |fără |Comută modul vorbire pe una din variantele: vorbire, bipuri și dezactivat.|
|Comută modul de ajutor pentru intrări |NVDA+1 |NVDA+1 |fără |Apăsând orice tastă în acest mod se va anunța tasta și descrierea oricărei comenzi NVDA asociată cu ea|
|Închide NVDA |NVDA+q |NVDA+q |fără |Se iese din NVDA|
|Trimite fără interceptare următoarea tastă |NVDA+f2 |NVDA+f2 |fără |Face ca NVDA să trimită următoarea tastă apăsată direct la aplicația activă, chiar dacă în mod normal este tratată ca o tastă de comandă NVDA|
|Comută aplicația în modul de repaus |NVDA+shift+s |NVDA+shift+z |fără |Modul de repaus dezactivează toate comenzile NVDA și ieșirile de vorbire sau braille pentru aplicația curentă. Modul este foarte folositor pentru aplicații care furnizează funcționalități proprii de vorbire sau citire a ecranului. Apăsați comanda din nou pentru a dezactiva modul de repaus.|

<!-- KC:endInclude -->

### Raportarea informațiilor de sistem {#ReportingSystemInformation}

<!-- KC:beginInclude -->

| Nume |tastă |Descriere|
|---|---|---|
|Anunță dată/oră |NVDA+f12 |Apăsând o dată se anunță ora curentă, apăsând de două ori se va anunța data|
|Anunță starea bateriei |NVDA+shift+b |Anunță starea bateriei, de ex. dacă se folosește sursa de rețea sau procentul curent de încărcare.|
|Anunță textul din planșetă |NVDA+c |Anunță textul salvat în planșetă, dacă există.|

<!-- KC:endInclude -->

## Navigarea cu NVDA {#NavigatingWithNVDA}

NVDA vă permite să  explorați sistemul în mai multe feluri, incluzând atât intereacțiunea normală cât și examinare.

### Obiecte {#Obiecte}

Fiecare aplicație și sistemul de operare însuși sunt constituite din numeroase obiecte.
Un obiect este un element cum ar fi o bucată de text, un buton, o casetă de bifare, un glisor, o listă sau un câmp de text editabil.

### Navigarea cu focalizarea sistemului {#FocalizareSistem}

Focalizarea sistemului, cunoscută mai simplu ca „focus”, este [obiectul](#Obiecte) care primește semnalele tastelor apăsate pe tastatură.
De exemplu, dacă tastați într-un câmp de text editabil, respectivul câmp are focusul.

Modul cel mai obișnuit de a naviga prin Windows cu NVDA este să vă deplasați cu comenzile standard din taste pentru Windows, cum ar fi apăsarea tab și shift+tab pentru a vă deplasa înainte și înapoi între controale, apăsând alt ca să deschideți bara de meniu și apoi folosind săgețile direcționale pentru navigarea prin meniuri și folosind alt+tab pentru mutarea între aplicațiile active.
Când faceți asta, NVDA va raporta informația despre obiectul focalizat, cum ar fi numele, tipul, valoarea, starea, descrierea, scurtătura din tastatură și informații despre poziția sa.
Când este activă [evidențierea focalizării](#VisionFocusHighlight),și  locația sistemului actual al focalizării este expusă vizual
Există câteva comenzi din taste care sunt utile când vă deplasați cu focalizarea sistemului:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Descriere|
|---|---|---|---|
|Raportează focalizarea curentă |NVDA+tab |NVDA+tab |Anunță obiectul sau controlul curent focalizat. Apăsând de două ori va pronunța pe litere informația|
|Raportează titlu |NVDA+t |NVDA+t |Anunță titlul ferestrei active. Apăsând de două ori va pronunța pe litere informația. Apăsând de trei ori o va copia pe planșetă|
|Citește fereastra activă |NVDA+b |NVDA+b |Citește toate controalele din fereastra curent activă (util pentru ferestrele de dialog)|
|Raportează bara de stare |NVDA+end |NVDA+shift+end |Raportează bara de stare, dacă este găsită de NVDA. În plus mută obiectul navigator la această poziție. Apăsând de două ori va pronunța informația pe litere. Apăsând de trei ori o va copia pe planșetă|

<!-- KC:endInclude -->

### Navigarea cu cursorul de scriere al sistemului {#CursorScriereSistem}

Când este [focalizat](#FocalizareSistem) un [obiect](#Obiecte) care permite navigarea și/sau editarea de text, vă puteți mișca prin text folosind cursorul de scriere al sistemului, cunoscut și cu numele de „cursor de editare”.

Când este focalizat obiectul care deține cursorul de scriere, puteți folosi tastele săgeți, pagină sus(page up), pagină jos(page down), acasă(home), sfârșit(end), etc. pentru a vă mișca prin text.
Puteți, de asemenea, să modificați textul, dacă obiectul respectiv permite acest lucru.
NVDA va anunța când vă deplasați cu un caracter, cuvânt sau rând, și va anunța și textul selectat sau deselectat.

NVDA oferă următoarele comenzi din taste în relație cu cursorul de scriere al sistemului:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Descriere|
|---|---|---|---|
|Pronunță tot |NVDA+săgeată jos |NVDA+a |Începe citirea din poziția curentă a cursorului de scriere, deplasându-l pe măsură ce înaintează|
|Citește rândul curent |NVDA+săgeată sus |NVDA+l |Citește rândul unde se află cursorul de scriere. Apăsând de două ori pronunță caracterele rândului. Apăsând de trei ori citește rândul utilizând descrieri de caractere.|
|Citește textul selectat |NVDA+Shift+săgeată sus |NVDA+shift+s |Citește orice text selectat|
|Următoarea propoziție |alt+săgeată jos |alt+săgeată jos |Mută cursorul de scriere la următoare propoziție și o anunță. (disponibil doar în Microsoft Word și Outlook)|
|Propoziția precedentă |alt+săgeată sus |alt+săgeată sus |Mută cursorul de scriere la propoziția precedentă și o anunță. (disponibil doar în Microsoft Word și Outlook)|

Când vă aflați într-un tabel, sunt disponibile următoarele comenzi din taste:

| Nume |Tastă |Descriere|
|---|---|---|
|Mută la coloana anterioară |control+alt+săgeată stânga |Mută cursorul sistemului la coloana anterioară (rămânând pe același rând)|
|Mută la coloana următoare |control+alt+săgeată dreapta |Mută cursorul sistemului la coloana următoare (rămânând pe același rând)|
|Mută la rândul anterior |control+alt+săgeată sus |Mută cursorul sistemului la rândul anterior (rămânând pe aceeași coloană)|
|Mută la rândul următor |control+alt+săgeată jos |Mută cursorul sistemului la rândul următor (rămânând pe aceeași coloană)|

<!-- KC:endInclude -->

### Navigarea prin obiecte {#NavigareObiect}

Majoritatea timpului veți lucra cu aplicațiile, folosind comenzi care mută [focalizarea](#FocalizareSistem) sau [cursorul de editare](#CursorScriereSistem).
În schimb, uneori, veți dori să explorați aplicația curentă sau sistemul de operare fără să mutați focalizarea sau cursorul de editare.
Ați putea, de asemenea, să doriți să lucrați cu [obiecte](#Obiecte) care nu pot fi accesate în mod normal, folosind tastatura.
În aceste cazuri puteți folosi navigarea prin obiecte a NVDA.

Navigarea prin obiecte vă permite să vă deplasați între [obiecte](#Obiecte) individuale și să obțineți informații despre ele.
Când vă deplasați la un obiect, NVDA îl va raporta așa cum raportează și focalizarea sistemului.
Dacă doriți o modalitate de a descrie tot textul în timp ce este afișat pe ecran, puteți folosi, în schimb, [examinarea ecranului](#ExaminareEcran).

În loc să trebuiască să vă deplasați înainte și înapoi între fiecare obiect din sistem, obiectele sunt grupate ierarhic.
Asta înseamnă că anumite obiecte conțin alte obiecte și trebuie să vă mutați în interiorul lor pentru accesa obiectele conținute de ele.
De exemplu, o listă conține elemente de listă, deci va trebui să intrați în listă pentru a avea acces la elementele sale.
Dacă v-ați mutat la un element al listei, mutarea la obiectul anterior sau precedent vă va duce la alte elemente ale aceleiași liste
Mutarea la obiectul conținător al oricărui element al listei, vă va duce înapoi la listă.
Puteți apoi să ieși din listă, dacă doriți să accesați alte obiecte.
La fel, o bară de instrumente conține controale, deci trebuie să intrați în bara de instrumente pentru a accesa controalele din aceasta.

Obiectul descris curent se numește „obiectul navigator”.
Odată ce navigați la un obiect, îi puteți examina conținutul folosind [comenzile pentru examinarea textului](#ExaminareaTextului) când sunteți în [Modul de examinare obiect](#ExaminareObiect).
Când este activă [evidențierea focalizării](#VisionFocusHighlight), și locația obiectului navigator curent este expusă vizual.
Implicit, obiectul navigator se deplasează împreună cu focalizarea sistemului, dar acest comportament poate fi activat sau dezactivat.

De notat faptul că în mod implicit, braille urmărește atât  [focalizarea](#FocalizareSistem) cât și [cursorul de scriere](#CursorScriereSistem), dar și navigarea prin obiecte și descrierea textului.
Dacă doriți să urmărească doar focalizarea și cursorul de scriere al sistemului, trebuie să [configurați braille să se asocieze](#AsociereBraille) la focalizare.
În acest caz, braille nu va urmări navigarea prin obiect și examinarea tectului.
Dacă vreți ca braille să urmărească în schimb navigarea prin obiect și examinarea textului, trebuie să [configurați braille să fie asociat](#AsociereBraille) la examinare.

Pentru a naviga prin obiecte, folosiți următoarele taste:

<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Atingere |Descriere|
|---|---|---|---|---|
|Raportează obiectul curent |NVDA+numpad5 |NVDA+shift+o |fără |Raportează obiectul navigator curent. Apăsând de două ori pronunță pe litere informația și apăsând de trei ori copiază în planșetă numele și valoarea obiectului.|
|Navighează la obiectul conținător |NVDA+numpad8 |NVDA+shift+săgeată sus |glisează brusc sus (mod obiect) |Navighează la obiectul care îl conține pe obiectul navigator curent|
|Navighează la obiectul anterior |NVDA+numpad4 |NVDA+shift+săgeată stânga |glisează brusc stânga (mod obiect) |Navighează la obiectul anterior obiectului navigator curent|
|Navighează la obiectul următor |NVDA+numpad6 |NVDA+shift+săgeată dreapta |glisează brusc dreapta (mod obiect) |Navighează la obiectul aflat imediat după obiectul navigator curent|
|Navighează la primul obiect conținut |NVDA+numpad2 |NVDA+shift+săgeată jos |glisează brusc jos (mod obiect) |Navighează la primul obiect conținut de obiectul navigator curent|
|Navighează la obiectul focalizat |NVDA+numpadMinus |NVDA+backspace |fără |Navighează la obiectul pe care se află focalizarea sistemului, și poziționează cursorul de examinare la poziția cursorului de scriere al sistemului, dacă apare|
|Activează obiectul navigator curent |NVDA+Enter bloc numeric |NVDA+enter |atingere dublă |Activează obiectul navigator curent (similar cu apăsarea butonului mausului sau apăsarea barei de spațiu când este focalizat)|
|Mută focalizarea sistemului  sau cursorul de scriere la poziția de examinare curentă |NVDA+shift+numpadMinus |NVDA+shift+backspace |fără |Apăsat o dată mută focalizarea sistemului la obiectul navigator curent, apăsat de două ori mută cursorul de scriere la poziția cursorului de examinare|
|Raportează locația cursorului de examinare |NVDA+numpadDelete |NVDA+delete |fără |Raportează informații despre locația textului sau a obiectului de la cursorul de examinare. De exemplu aceasta ar putea include procentul de document parcurs, distanța față de marginea paginii sau poziția exactă a ecranului. Apăsând de două ori ar putea furniza și alte detalii.|

<!-- KC:endInclude -->

Notă: pentru ca tastele din blocul numeric să funcționeze corect, tasta „NumLock”, pentru blocul numeric, trebuie dezactivată.

### Examinarea Textului {#ExaminareaTextului}

NVDA vă permite să citiți conținutul [ecranului](#ExaminareEcran), [documentului](#ExaminareDocument) curent sau [obiectului](#ExaminareObiect) curent la nivel de  caracter, cuvânt sau rând.
Acest lucru este foarte util în locuri (incluzând consola de comandă Windows) unde nu există [cursorul de scriere al sistemului](#CursorScriereSistem).
De exemplu, puteți folosi examinarea textului pentru un mesaj lung de informare dintr-o fereastră de dialog.

Când deplasați cursorul de examinare, cursorul de scriere al sistemului nu îl urmează, astfel că puteți citi textul fără să pierdeți poziția de editare curentă.
Totuși, implicit, când cursorul de scriere se deplasează, cursorul de examinare îl urmează.
Asta se poate activa sau dezactiva.

De notat faptul că braille urmărește în mod implicit [focalizarea](#FocalizareSistem) și [cursorul de scriere](#CursorScriereSistem) și nu navigarea prin obiecte și descrierea textului.
Dacă doriți să urmărească navigarea prin obiecte și descrierea textului, trebuie să [configurați braille să se asocieze](#AsociereBraille) la descriere.

Următoarele comenzi din taste sunt disponibile pentru examinarea textului:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Atingere |Descriere|
|---|---|---|---|---|
|Mută la primul rând în descriere |shift+numpad7 |NVDA+control+home |fără |Mută cursorul de examinare la primul rând din text|
|Mută la rândul anterior din descriere |numpad7 |NVDA+săgeată sus |glisează brusc sus (mod text) |Mută cursorul de examinare la rândul anterior din text|
|Raportează rândul curent în descriere |numpad8 |NVDA+shift+. |fără |Anunță rândul curent din text unde se află cursorul de examinare. Apăsând de două ori, pronunță pe cuvinte rândul. Apăsând de trei ori pronunță rândul folosind descrierea caracterelor.|
|Mută la rândul următor din descriere |numpad9 |NVDA+săgeată jos |glisează brusc jos (mod text) |Mută cursorul de examinare la următorul rând din text|
|Mută la ultimul rând din descriere |shift+numpad9 |NVDA+control+end |fără |Mută cursorul de examinare la ultimul rând din text|
|Mută la cuvântul anterior din descriere |numpad4 |NVDA+control+săgeată stânga |glisează brusc stânga cu 2 degete (mod text) |Mută cursorul de examinare la cuvântul anterior din text|
|Raportează cuvântul curent din descriere |numpad5 |NVDA+control+. |fără |Anunță cuvântul curent din text unde se află cursorul de examinare. Apăsând de două ori pronunță pe litere cuvântul. Apăsând de trei ori pronunță cuvântul folosind descrirea caracterelor.|
|Mută la cuvântul următor din descriere |numpad6 |NVDA+control+săgeată dreapta |glisează brusc dreapta cu 2 degete (mod text) |Mută cursorul de examinare la cuvântul următor din text|
|Mută la începutul rândului din descriere |shift+numpad1 |NVDA+home |fără |Mută cursorul de examinare la începutul rândului curent din text|
|Mută la caracterul anterior din descriere |numpad1 |NVDA+săgeată stânga |glisează brusc stânga (mod text) |Mută cursorul de examinare la caracterul anterior de pe rândul curent din text|
|Raportează caracterul curent din descriere |numpad2 |NVDA+. |fără |Anunță caracterul curent de pe rândul unde se află cursorul de examinare. Apăsând de două ori raportează o descriere sau exemplu al acelui caracter. Apăsând de trei ori anunță valoarea numerică a caracterului în zecimale și hexazecimale.|
|Mută la următorul caracter din descriere |numpad3 |NVDA+săgeată dreapta |glisează brusc dreapta (mod text) |Mută cursorul de examinare la următorul caracter de pe rândul curent din text|
|Mută la sfârșitul rândului din descriere |shift+numpad3 |NVDA+end |fără |Mută cursorul de examinare la sfârșitul rândului curent din text|
|Citește tot din descriere |numpadPlus |NVDA+shift+a |glisează brusc jos cu 3 degete (mod text) |Citește din poziția curentă a cursorului de examinare, deplasându-l pe măsură ce înaintează|
|Selectează apoi copiază de la cursorul de examinare |NVDA+f9 |NVDA+f9 |fără |Începe procesul de selectare și copiere de la poziția curentă a cursorului de examinare. Operația propriu-zisă nu este efectuată până nu specificați către NVDA unde se află limita finală a textului|
|Selectează apoi copiază la cursorul de examinare |NVDA+f10 |NVDA+f10 |fără |La prima apăsare, se selectează textul începând cu poziția marcată anterior, până la și inclusiv poziția curentă a cursorului de examinare. După apăsarea a doua oară a acestei taste, textul va fi copiat în planșeta Windows|
|Mută la începutul marcat pentru copia din examinare |NVDA+shift+f9 |NVDA+shift+f9 |fără |Mută cursorul de examinare la poziția setată anterior ca marcaj de început pentru copie|
|Raportează formatul textului |NVDA+f |NVDA+f |fără |Anunță formatul textului unde se află cursorul de examinare|

<!-- KC:endInclude -->

Notă: pentru ca tastele din blocul numeric să funcționeze corect, tasta „NumLock” trebuie dezactivată.

O metodă bună de a vă aminti comenzile de bază pentru examinarea textului, când este folosit formatul de birou pentru comenzi,este să vă imaginați că sunt organizate într-o grilă de trei pe trei, de sus până jos fiind rând, cuvânt și caracter, iar de la stânga la dreapta fiind anterior, curent și următor.
Așezarea este ilustrată după cum urmează:

|Rând anterior |Rând curent |Rând următor|
|Cuvânt anterior |Cuvânt curent |Cuvânt următor|
|Caracter anterior |Caracter curent |Caracter următor|

### Moduri de examinare {#ModuriExaminare}

[Comenzile de examinare text](#ExaminareaTextului) ale NVDA pot examina conținut din interiorul obiectului navigator curent, documentului curent sau ecranului, depinzând de modul de examinare ales.
Modurile de examinare înlocuiesc conceptul mai vechi de „Examinare uniformă” al NVDA.

Următoarele comenzi sunt folosite pentru schimbarea între modurile de examinare:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Atingere |Descriere|
|---|---|---|---|---|
|Comută la următorul mod de examinare |NVDA+numpad7 |NVDA+pageUp |glisează brusc sus cu 2 degete |Comută la următorul mod de examinare disponibil.|
|Comută la modul de examinare anterior |NVDA+numpad1 |NVDA+pageDown |glisează brusc jos cu 2 degete |Comută la anteriorul mod de examinare disponibil.|

<!-- KC:endInclude -->

#### Examinare obiect {#ExaminareObiect}

Cât timp sunteți în modul „Examinare obiect”, puteți doar să examinați conținutul [obiectului navigator](#NavigareObiect) curent.
Pentru obiecte precum câmp text editabil sau alte controale de bază cu text, acesta va fi, în general, conținutul text.
Pentru alte obiecte, acesta poate fi numele și/sau valoarea.

#### Examinare document {#ExaminareDocument}

Când [obiectul navigator](#NavigareObiect) se află într-un document cu mod navigare (de ex. pagină web) sau alt document complex (de ex. un document Lotus Symphony), este posibilă schimbarea în modul „Examinare document”.
Modul „Examinare document” vă permite să examinați textul întregului document.

Când comutați de la „Examinare obiect” la „Examinare document”, cursorul de examinare este poziționat în interiorul documentului la locația obiectului navigator.
Când vă mișcați în interiorul documentului folosind comenzi de examinare, obiectul navigator este actualizat automat ca fiind obiectul de la poziția curentă a cursorului de examinare.

Notați faptul că NVDA va comuta la Examinare document din modul Examinare obiect automat atunci când vă mișcați în interiorul documentelor cu mod navigare.

#### Examinare ecran {#ExaminareEcran}

Modul „Examinare ecran” vă permite analiza textului ecranului pe măsură ce apare, din punct de vedere vizual, în aplicația curentă.
Acesta este similar ca funcționalitate cu multe alte cititoare ecran de Windows care au funcții de examinare ecran sau cursor de maus.

Când se comută la modul Examinare ecran, cursorul de examinare este plasat la poziția pe ecran a [obiectului navigator](#NavigareObiect) curent.
Când vă mișcați în interiorul ecranului cu comenzi de examinare, obiectul navigator este actualizat automat la obiectul găsit la poziția cursorului de examinare de pe ecran.

Notați faptul că în unele aplicații mai noi, NVDA se poate să nu găsească, fie parțial fie în totalitate, textul afișat datorită utilizării de tehnologii grafice pentru desenarea ecranului care nu pot fi susținute de implementare în acest moment.

### Navigarea cu mausul {#NavigatingWithTheMouse}

Când mișcați mausul, NVDA raportează implicit textul aflat direct sub cursorul mausului, pe măsură ce indicatorul e mișcat pe deasupra lui.
Dacă este disponibil, NVDA va citi textul dintr-un paragraf întreg, deși unele controale pot citi doar câte un rând.

NVDA poate fi configurat și să anunțe tipul de [obiect](#Obiecte) pe care se află mausul pe măsură ce se mișcă (de exemplu listă, buton, etc).
Acest lucru poate fi util pentru utilizatorii complet nevăzători, uneori textul nefiind suficient.

NVDA asigură pentru utilizatori o cale să înțeleagă unde se află mausul relativ la dimensiunile ecranului, redând coordonatele curente ale mausului prin semnale sonore.
Cu cât mausul se află mai sus pe ecran, cu atât amplitudinea sunetului va fi mai mare. 
Cu cât mai la stânga sau la dreapta se află pe ecran, cu atât sunetul se va auzi mai la stânga sau mai la dreapta (presupunând că utilizatorul are difuzoare stereo).

Aceste caracteristici adiționale ale mausului nu sunt activate implicit de NVDA.
Dacă doriți să profitați de ele, le puteți configura din categoria [Setărilor maus](#OptiuniMaus), aflată în meniul „Preferințe” din meniul NVDA.

Cu toate că un dispozitiv fizic de maus sau un trackpad ar trebui folosit pentru navigarea cu mausul, NVDA are câteva comenzi din taste asociate mausului:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Descriere|
|---|---|---|---|
|clic pe butonul stânga al mausului |numpad Împărțire |NVDA+[ |face clic o dată pe butonul stânga al mausului. Obișnuitul dublu clic poate fi realizat apăsând această tastă de două ori rapid|
|Blocarea butonului stânga al mausului |shift+numpad Împărțire |NVDA+control+[ |Blochează butonul stânga al mausului pe apăsat. Apăsați încă o dată pentru deblocare. Pentru a trage mausul, apăsați această tastă pentru blocarea butonului stânga al mausului și apoi mișcați mausul fie fizic, fie folosind una dintre celelalte comenzi de emulare a mausului|
|clic pe butonul dreapta al mausului |numpadÎnmulțire |NVDA+] |Face clic o dată pe butonul dreapta al mausului.|
|Blocarea butonului dreapta al mausului |shift+numpad Înmulțire |NVDA+control+] |Blochează butonul dreapta al mausului apăsat. Apăsați încă o dată pentru deblocare. Pentru a trage mausul, apăsați această tastă pentru blocarea butonului dreapta al mausului și apoi mișcați mausul fie fizic, fie folosind una dintre celelalte comenzi de emulare a mausului|
|Mută mausul la obiectul navigator curent |NVDA+numpad Împărțire |NVDA+shift+m |Mută mausul la locația obiectului navigator curent și al cursorului de examinare|
|Navighează la obiectul de sub maus |NVDA+numpad Înmulțire |NVDA+shift+n |Pune obiectul navigator pe obiectul aflat la poziția mausului|

<!-- KC:endInclude -->

## Modul de navigare {#ModNavigare}

Documente complexe ce pot fi doar citite, cum ar fi paginile web, sunt examinate în NVDA folosind „Modul navigare”.
Acesta include documente în următoarele aplicații:

* Mozilla Firefox
* Microsoft Internet Explorer
* Mozilla Thunderbird
* mesaje HTML în Microsoft Outlook
* Google Chrome
* Microsoft Edge
* Foxit Reader
* Cărți suportate în Amazon Kindle pentru PC

Modul navigare este disponibil opțional și pentru documentele Microsoft Word.

În modul navigare, conținutul documentului este disponibili într-o reprezentare uniformă, navigabilă cu tastele pentru cursor ca și cum ar fi un text normal dintr-un document.
Toate comenzile din taste ale NVDA pentru [ cursorul de scriere al sistemului](#CursorScriereSistem) vor funcționa în acest mod; de ex. „rostește tot”, „anunță formatare”, comenzi de navigare în tabel, etc.
Când este activă [evidențierea focalizării](#VisionFocusHighlight), și locația cursorului de scriere al modului virtual de navigare este expusă vizual.
Informații cum ar fi dacă acel text este un link, o rubrică, etc, sunt anunțate alături de text pe măsură ce mișcați cursorul.

Uneori, veți avea nevoie să interacționați direct cu controalele din aceste documente.
De exemplu, veți avea nevoie să faceți asta pentru câmpuri editabile de text și liste astfel încât să tastați caractere și să folosiți tastele de cursor pentru a lucra cu controlul respectiv.
Puteți face asta comutând pe „modul formular”, unde aproape toate tastele sunt trimise controlului.
Când sunteți în „Modul navigare”, NVDA va comuta pe modul formular implicit, dacă navigați cu tasta „tab” sau faceți clic pe un anumit control care are nevoie de modul formular. 
Alternativ, navigarea cu tasta „tab” sau făcând clic pe un control care nu are nevoie de modul formular, va comuta înapoi la modul de navigare.
Puteți, de asemenea, să apăsați „enter” sau „spațiu” pentru a comuta la modul formular pe controale care au nevoie de acesta.
Apăsând „escape” va comuta înapoi la modul navigare.
Adițional, puteți forța modul formular manual, după care va rămâne activat până decideți să îl dezactivați.

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Comută între modurile navigare/formular |NVDA+spațiu |Schimbă între modul formular și modul navigare|
|Iese din modul formular |Escape |schimbă înapoi în modul navigare dacă anterior s-a trecut automat în modul formular|
|Împrospătează document în mod navigare |NVDA+F5 |Reîncarcă documentul curent (util dacă anumite părți par să lipsească din document, Indisponibil în Microsoft Word sau Outlook.)|
|Găsește |NVDA+control+f |Afișează o fereastră de dialog în care puteți scrie un text pentru a fi găsit în documentul curent. Vedeți [căutarea textului](#SearchingForText) pentru mai multe informații.|
|Găsește următor |NVDA+f3 |Găsește apariția următoare în document a textului care a fost căutat anterior|
|Găsește anterior |NVDA+shift+f3 |Găsește apariția anterioară în document a textului care a fost căutat anterior|
|deschide descriere amplă |NVDA+d |Deschide o fereastră nouă ce conține o descriere amplă a elementului pe care sunteți, în caz că acesta are o astfel de descriere.|

<!-- KC:endInclude -->

### Navigarea cu o singură literă {#SingleLetterNavigation}

În modul de navigare, pentru o explorare mai rapidă NVDA asigură și trecerea directă la anumite câmpuri din document apăsând tasta unui singur caracter.
Notați faptul că nu toate aceste comenzi sunt disponibile în toate tipurile de document.

<!-- KC:beginInclude -->
Următoarele taste trec direct la elementul următor disponibil, iar combinându-le cu tasta Shift se face trecerea la elementul anterior:

* h: rubrică (h din englezescul heading)
* l: listă
* i: element din listă (i de la item)
* t: tabel
* k: legătură/link
* n: text fără legături (n de la non-link)
* f: câmp din formular
* u: legătură nevizitată (u de la unvisited)
* v: legătură vizitată
* e: câmp de editare
* b: buton
* x: casetă pentru bifat (x similar cu marcajul unei bife)
* c: listă de selecție (c de la combo box, casetă combinată)
* r: buton rotativ
* q: citat bloc (q de la quote)
* s: separator
* m: cadru/frame
* g: grafic
* d: reper
* o: obiect încorporat
* 1 la 6: rubrici de nivel de la 1 la 6, respectiv
* a: adnotare (comentariu, editor, versiune, etc.)
* w: eroare de ortografie

Pentru mutarea la începutul sau sfârșitul elementelor cu conținut cum ar fi liste sau tabele:

| Nume |Tastă |Descriere|
|---|---|---|
|Mută la începutul obiectului conținător |shift+virgulă |Mută la începutul conținătorului (listă, tabel, etc.) pe care este poziționat cursorul de scriere|
|Mută după capătul obiectului conținător |virgulă |Mută după capătul conținătorului (listă, tabel, etc.) pe care este poziționat cursorul de scriere|

<!-- KC:endInclude -->
Anumite aplicații web cum ar fi Gmail, Twitter și Facebook folosesc litere simple pe post de scurtături din tastă.
Dacă doriți să le folosiți pe acestea și să puteți în continuare să folosiți tastele cursor în mod navigare pentru a citi, puteți să dezactivați temporar tastele pentru navigarea cu o singură literă a NVDA.
<!-- KC:beginInclude -->
Pentru a comuta navigarea cu o singură literă în activat sau dezactivat pentru documentul curent, apăsați NVDA+shift+spațiu.
<!-- KC:endInclude -->

### Lista cu elemente {#ElementsList}

Lista elementelor oferă acces la o listă de diferite tipuri de elemente din document în concordanță cu aplicația.
De exemplu, în Navigatoarele web, lista cu elemente poate afișa legături, rubrici, câmpuri formular, butoane sau repere.
Butoanele rotative vă permit să comutați între diferitele tipuri de elemente.
Este oferit și un câmp de editare în fereastra de dialog, permițându-vă să filtrați lista pentru a vă ajuta să căutați un anumit obiect din pagină.
Odată ce ați ales un element, puteți folosi butoanele din fereastra de dialog pentru a trece la el sau a-l activa.
<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Lista elementelor în modul navigare |NVDA+f7 |Afișează lista diferitelor tipuri de elemente din documentul curent|

<!-- KC:endInclude -->

### Căutarea textului {#SearchingForText}

Această fereastră de dialog vă dă posibilitatea să căutați termeni în documentul curent.
În câmpul „Tastați textul pe care doriți să-l căutați”, textul de căutat poate fi introdus.
Caseta de bifat „Sensibil la majuscule” face ca funcția de căutare să considere diferite literele cu majusculă față de cele fără majusculă.
De exemplu, dacă această casetă de bifat este activă, puteți căuta „NV Access”, nu „nv access”.
Utilizați următoarele combinații de taste pentru a căuta:
<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Caută text |NVDA+control+f |Deschide fereastra de căutare|
|Caută următor |NVDA+f3 |Caută următoarea apariție a termenului căutat|
|Caută anterior |NVDA+shift+f3 |Caută apariția precedentă a termenului căutat|

<!-- KC:endInclude -->

### Obiecte încorporate {#ImbeddedObjects}

Paginile pot include conținut complex folosind tehnologii ca Adobe Flash, Oracle Java și HTML5, precum și aplicații și dialoguri.
Când acestea sunt întâlnite în modul navigare, NVDA va anunța „obiect incorporat”, „aplicație” sau „dialog”, respectiv.
Vă puteți muta rapid la ele, folosind tastele de navigare cu o singură literă „o“ și „shift+o“, pentru obiecte încorporate. 
Puteți apăsa Enter pe aceste obiecte pentru a interacționa cu ele.
Dacă este accesibil, puteți naviga prin el și puteți interacționa cu el la fel cu orice altă aplicație.
Există o tastă de comandă pentru revenirea la pagina originală care conține obiectul încorporat:
<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Trece în mod navigare la documentul care conține obiectul |NVDA+control+spațiu |Mută focalizarea în afară obiectului incorporat curent și în documentul care îl conține|

<!-- KC:endInclude -->

## Citirea conținutului matematic {#CitireMatematica}

 Folosind MathPlayer 4 creat de Design Science, NVDA poate citi și naviga interactiv prin conținutul matematic compatibil.
Pentru acest lucru este nevoie ca MathPlayer 4 să fie instalat pe calculatorul dumneavoastră.
MathPlayer este disponibil ca descărcare gratuită la: https://www.dessci.com/en/products/mathplayer/

NVDA este compatibil cu următoarele tipuri de conținut matematic:

* MathML în Mozilla Firefox, Microsoft Internet Explorer și Google Chrome.
* MathType de la Design Science în Microsoft Word și PowerPoint.
MathType trebuie să fie instalat pentru a avea această funcționalitate. Este suficientă versiunea de probă.
* MathML în AdobeReader.
De notat că acesta nu este un standard oficial încă, deci momentan nu există un software disponibil public care să producă acest conținut.
* Matematică în Kindle pentru PC pentru cărți cu matematică accesibilă.

Când citește un document, NVDA va pronunța orice conținut matematic compatibil atunci când îl întâlnește.
Dacă folosiți un afișaj braille, va fi de asemenea afișat în braille.

### Navigarea interactivă {#InteractiveNavigation}

Dacă lucrați în principal cu vorbirea, în cele mai multe cazuri, veți dori, probabil, să examinați expresia în segmente mai mici, mai degrabă decât să auziți întreaga expresie dintr-o dată.

Dacă vă aflați în mod navigare, puteți face asta prin mutarea cursorului la conținutul matematic și apăsând „Enter”.

Dacă nu vă aflați în mod navigare:

1. mutați cursorul de examinare la conținutul matematic.
Implicit, cursorul de examinare urmează cursorul de scriere al sistemului, deci de obicei puteți folosi cursorul de scriere pentru a vă muta la conținutul dorit.
1. Apoi, activați următoarea comandă:

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Interacțiune cu conținut matematic |NVDA+alt+m |Începe interacțiunea cu conținutul matematic.|

<!-- KC:endInclude -->

În acest moment, puteți folosi comenzi ale MathPlayer, cum ar fi tastele săgeți, pentru a cerceta expresia .
De exemplu, vă puteți mișca prin expresie cu tastele săgeată stânga și dreapta și focaliza pe o porțiune a expresiei cum ar fi o fracție, folosind tasta săgeată jos.
Consultați documentația MathPlayer despre comenzile de navigare pentru informații suplimentare: https://www.dessci.com/en/products/mathplayer/navigation_commands.htm

Când doriți să vă reîntoarceți la document, pur și simplu apăsați tasta „escape”.

## Braille {#BrailleSupport}

Dacă dețineți un afișaj braille, NVDA poate afișa informația în braille.
Dacă afișajul dumneavoastră braille are o tastatură stil Perkins, puteți, de asemenea, să introduceți braille abreviat și neabreviat.
NVDA recunoaște automat multe afișaje braile.
NVDA pune la dispoziție multe coduri braille pentru diferite limbi străine inclizând braille abreviat, neabrevial și computer braille.

Vă rugăm să citiți secțiunea [Afișaje braille suportate](#SupportedBrailleDisplays) pentru informații despre acestea. De asemenea in aceeași secțiune puteți găsi informații despre compatibilitatea afișajului braille cu funcționalitatea de recunoaștere automată a afișajelor braille în NVDA.
Puteți configura afișajul braille în [categoria braille](#BrailleSettings) din dialogul [setări](#NVDASettings).

### Abrevieri pentru tipuri de controale, stări și repere {#BrailleAbbreviations}

Pentru a încăpea cât mai multe informații pe un afișaj braille, au fost definite următoarele abrevieri pentru a indica tipul de controale, stările, precum și reperele.

| Abreviere |tip de control|
|---|---|
|app |aplicație|
|art |articol|
|bqt |citat bloc|
|btn |buton|
|drbtn |buton de extindere|
|spnbtn |buton spin|
|splbtn |buton divizare|
|tgbtn |buton comutare|
|cbo |casetă combinată|
|chk |casetă de bifat|
|dlg |dialog|
|doc |document|
|edt |câmp de text editabil|
|pwdedt |modificare parolă|
|embedded |obiect încorporat|
|enote |notă de sfârșit|
|fig |figură|
|fnote |notă de subsol|
|gra |grafic|
|grp |grupare|
|hN |rubrică de nivel n, e.x. h1, h2.|
|hlp |bulă de ajutor||
|lmk |reper|
|lnk |link|
|vlnk |link vizitat|
|lst |listă|
|mnu |meniu|
|mnubar |bară de meniu|
|mnubtn |buton meniu|
|mnuitem |element de meniu|
|pnl |panou|
|prgbar |bară de progres|
|rbtn |buton rotativ|
|scrlbar |bară derulare|
|sect |secțiune|
|stbar |bară de stare|
|tabctl |control tabulator|
|tbl |tabel|
|cN |numărul n a coloanei din tabel, ex c1, c2.|
|rN |numărul n al rândului din tabel, ex r1, r2.|
|term |terminal|
|tlbar |bară de unelte|
|tltip |indiciu|
|tv |vedere listă extinsă|
|tvbtn |buton vedere listă extinsă|
|tvitem |element listă extinsă|
|lv N |un element din vederea listei extinse  are un nivel erarhic N||
|wnd |fereastră|
|⠤⠤⠤⠤⠤ |separator|

Următorii indicatori de stare sunt definiți:

|Abreviere |Stare de control|
|... |afișat când un obiect suportă autocompletare|
|⢎⣿⡱ |afișat când un obiect (e.x. un buton de comutare) este apăsat|
|⢎⣀⡱ |afișat când un obiect (e.x. un buton de comutare) nu este apăsat|
|⣏⣿⣹ |afișat când un obiect (e.x. o casetă de bifat) este bifat|
|⣏⣸⣹ |afișat când un obiect (e.x. o casetă de bifat) este parțial bifat|
|⣏⣀⣹ |afișat când un obiect (e.x. o casetă de bifat) este nebifat|
|- |afișat când un obiect (e.x. un element dintr-o vedere listă extinsă) poate fi redus|
|+ |afișat când un obiect (e.x. un element dintr-o vedere listă extinsă) poate fi extins|
|*** |afișat când este întâlnită o acțiune sau un document protejat|
|clk |afișat când un obiect este clicabil|
|cmnt |afișat când există un comentariu pentru o celulă dintr-o foaie de calcul sau o parte din textul unui document|
|frml |afișat când există o formulă într-o foaie de calcul|
|invalid |afișat când s-a încercat introducerea unei înregistrări invalide||
|ldesc |afișat când un obiect (de obicei un grafic) are o descriere lungă|
|mln |afișat când un câmp de editare permite linii multiple de text, cum sunt câmpurile de comentarii de pe site-urile web|
|req |afișat când este găsit un câmp obligatoriu de formular|
|ro |afișat când un obiect (e.x. un câmp de text editabil) este doar-citire|
|sel |afișat când un obiect este selectat|
|nsel |afișat când un obiect nu este selectat|
|sorted asc |afișat când un obiect este ordonat crescător|
|sorted desc |afișat când un obiect este ordonat descrescător|
|submnu |afișat când un obiect are un popup (de obicei un sub-meniu)|

În final, următoarele abrevieri pentru repere sunt definite:

| Abreviere |Reper|
|---|---|
|bnnr |banner|
|cinf |informație conținut|
|cmpl |complementar|
|form |formular|
|main |principal|
|navi |navigare|
|srch |căutare|
|rgn |regiune|

### Intrări braille {#BrailleInput}

NVDA suportă atât intrarea braille-ului neabreviat cât și a celui abreviat printr-o tastatură braille.
Puteți selecta tabelul de traducere utilizat pentru a traduce braille-ul în text folosind setarea [Tabelului de intrări](#SetariBrailleTabelIntrari), aflată în categoria „Braille din [Setările NVDA](#NVDASettings).

Atunci când se utilizează braille-ul neabreviat, textul este inserat de îndată ce este introdus.
La utilizarea braille-ului neabreviat, textul este inserat atunci când apăsați  spațiu sau enter la sfârșitul unui cuvânt.
Rețineți faptul că traducerea poate reflecta doar cuvântul braille pe care îl tastați și nu îl poate considerea ca text existent.
De exemplu, dacă utilizați un cod braille care începe numerele cu un semn de cifră și dumneavoastră apăsați backspace pentru a vă deplasa la sfârșitul unui număr, va trebui să tastați semnul de cifră din nou pentru a introduce numere adiționale.

<!-- KC:beginInclude -->
Apăsarea punctului 7 șterge ultima celulă sau ultimul caracter braille introdus.
Punctul 8 traduce orice intrare braille și apasă tasta enter.
Apăsarea punctului 7 plus cea a punctului 8 traduce orice intrare Braille, dar fără să adauge un spațiu sau o apăsare de enter.
<!-- KC:endInclude -->

## Vedere {#Vision}

NVDA a fost conceput pentru a-i ajuta pe nevăzători și pe cei cu deficiențe de vedere să folosească un computer. De asemenea, oferă facilități încorporate pentru schimbarea conținutului ecranului.
În cadrul NVDA, un astfel de ajutor vizual se numește furnizor de îmbunătățire a vederii.

NVDA oferă câțiva furnizori încorporați de îmbunătățire a vederii, care sunt descriși mai jos.
Pot fi configurați în [administratorul de suplimente   NVDA](#AddonsManager) furnizori adiționali de îmbunătățire a vederii.

Setările de vedere ale NVDA pot fi modificate în categoria [vedere](#VisionSettings) din fereastra de dialog a [setărilor NVDA](#NVDASettings).

### Evidențierea focalizării {#VisionFocusHighlight}

Evidențierea focalizării poate ajuta la identificarea poziției [focalizării sistemului](#SystemFocus), a [obiectului navigator](#ObjectNavigation) și a [modului de navigare](#BrowseMode).
Aceste poziții sunt evidențiate cu un contur al unui dreptunghi colorat.

* Albastru solid evidențiază un obiect navigator combinat și localizarea focalizării sistemului, pentru că [obiectul navigator urmărește focalizarea sistemului](#ReviewCursorFollowFocus)).
* Albastru punctat evidențiază numai obiectul focalizării sistemului.
* Roz solid evidențiază doar obiectul navigator.
* Galben solid evidențiază cursorul virtual de scriere folosit în modul de navigare (unde nu există un cursor fizic de scriere precum în navigatoarele web).

Când evidențierea focalizării este activată din categoria [vedere](#VisionSettings) a dialogului [setărilor NVDA](#NVDASettings), puteți [alege dacă focalizarea, obiectul navigator sau cursorul modului de navigare vor mai fi evidențiate sau nu](#VisionSettingsFocusHighlight)

### Cortina ecranului {#VisionScreenCurtain}

Ca utilizator nevăzător sau cu deficiențe de vedere, este adesea imposibil ori nu este necesar să vedeți conținutul ecranului.
În plus, este greu să vă asigurați că cineva nu se uită pe furiș la ecranul dumneavoastră.
Pentru această situație, NVDA conține o caracteristică numită „cortină ecran”, care poate fi activată pentru a face ecranul negru.

Puteți activa cortina ecranului în categoria [vedere](#VisionSettings) a dialogului [setărilor NVDA](#NVDASettings).

## Recunoașterea de conținut {#ContentRecognition}

Atunci când autorii nu furnizează suficiente detalii pentru ca un utilizator de cititor de ecran să poată determina conținutul acelui lucru, pot fi folosite diferite unelte pentru a încerca recunoașterea conținutului dintr-o imagine.
NVDA este compatibil cu funcționalitatea de recunoaștere optică a caracterelor (OCR), integrată în Windows 10, pentru a recunoaște texte dintr-o imagine.
Pot fi oferite și alte suplimente add-on pentru recunoașterea conținutului.

 Când folosiți o comandă de recunoaștere a conținutului, NVDA descoperă alcătuirea [obiectului navigator](#NavigareObiect) curent.
Implicit, obiectul navigator urmărește focalizarea sistemului sau cursorul din modul examinare, pentru ca să puteți cu ușurință muta focalizarea sau cursorul de examinare unde doriți.
De exemplu, dacă mutați cursorul de examinare la un grafic, recunoașterea automată va identifica conținut din graficul respectiv în mod implicit.
Totuși, s-ar putea să vă doriți să folosiți direct navigarea prin obiecte, de exemplu, pentru a recunoaște conținutul unei întregi ferestre de aplicație.

Odată identificarea finalizată, rezultatul va fi prezentat într-un document similar cu modul de examinare, permițându-vă să citiți informația cu tastele cursor, etc.
Apăsând „Enter” sau „Spațiu”, veți activa (în mod normal prin clic) textul de la cursor, dacă este posibil.
Apăsând „Escape”, se va diminua rezultatul identificării.

### Windows 10 OCR {#Win10Ocr}

Windows 10 include OCR pentru multe limbi.
NVDA poate folosi această funcționalitate pentru a recunoaște text din imagini sau aplicații inaccesibile.

Puteți seta limba folosită pentru recunoașterea de text din categoria [Windows 10 OCR](#SetariWin10Ocr), aflată în [Dialogul setărilor NVDA](#NVDASettings).
Pot fi instalate limbi adiționale din meniul de Start, alegând „Setări”, apoi „Timp și Limbi” -> „Regiune și Limbă” și apoi alegând „Adaugă limbă nouă”.

<!-- KC:beginInclude -->
Pentru a recunoaște textul din obiectul navigator curent, folosind Windows 10 OCR, apăsați NVDA+r.
<!-- KC:endInclude -->

## Funcționalități specifice aplicației {#ApplicationSpecificFeatures}

NVDA oferă propriile facilități suplimentare pentru anumite aplicații cu scopul de a ușura anumite activități sau de a oferi acces la funcționalități care, altfel, nu sunt disponibile utilizatorilor de cititoare de ecran.

### Microsoft Word {#MicrosoftWord}
#### Citire automată a anteturilor de rând și coloană {#WordAutomaticColumnAndRowHeaderReading}

NVDA este capabil să anunțe automat anteturile de rând și coloană corespunzătoare când navigați prin tabele în Microsoft Word.
În primul rând, este necesar ca opțiunea „Anunță anteturi de rând sau coloană din tabel” din setările formatării documentului, aflate în dialogul [Setărilor NVDA](#NVDASettings), să fie dezactivată.
În al doilea rând, NVDA are nevoie să știe ce rând sau coloană conține anteturile în orice tabel dat.
După mutarea la prima celulă pe coloana sau rândul care conține anteturile, folosiți una dintre comenzile următoare:
<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Stabilește anteturi coloană |NVDA+shift+c |Apăsând o dată, spune NVDA că aceasta este prima celulă antet din rândul care conține anteturi de coloană, care ar trebui să fie anunțate automat când vă mișcați printre coloanele de sub acest rând. Apăsând de două ori, va anula desemnarea.|
|Stabilește anteturi rând |NVDA+shift+r |Apăsând o dată, spune NVDA că aceasta este prima celulă antet din coloana care conține anteturi de rând, care ar trebui să fie anunțate automat când vă mișcați printre rândurile de după această coloană. Apăsând de două ori, va anula desemnarea.|

<!-- KC:endInclude -->
Aceste opțiuni vor fi salvate în document sub formă de semne de carte, compatibile cu alte cititoare de ecran cum ar fi JAWS.
Aceasta înseamnă că utilizatori ale altor cititoare de ecran care deschid documentul respectiv la un moment ulterior, vor avea automat anteturile de rând și coloană stabilite.

#### Mod navigare în Microsoft Word {#BrowseModeInMicrosoftWord}

În mod similar navigării web, modul navigare poate fi folosit în Microsoft Word pentru a vă permite să folosiți funcționalități ca „Navigare rapidă” și „Lista de elemente”.
<!-- KC:beginInclude -->
Pentru a comuta Modul navigare pentru Microsoft Word în activat sau dezactivat, apăsați NVDA+spațiu.
<!-- KC:endInclude -->
Pentru mai multe informații referitoare la Modul navigare și Navigarea rapidă, consultați [secțiunea Mod Navigare](#ModNavigare)

##### Lista de elemente {#WordElementsList}

<!-- KC:beginInclude -->
Dacă vă aflați în Modul navigare în Microsoft Word, puteți accesa Lista de elemente apăsând NVDA+F7.
<!-- KC:endInclude -->
Lista de elemente poate afișa rubrici, legături și adnotări (care includ comentarii și monitorizează modificările) și erori (în prezent limitate la cele de ortografie).

#### Raportarea comentariilor {#WordReportingComments}

<!-- KC:beginInclude -->
Pentru a anunța toate comentariile de la poziția curentă a cursorului de scriere, apăsați NVDA+alt+c.
<!-- KC:endInclude -->
Toate comentariile documentului, împreună cu alte modificări urmărite, pot fi afișate în Lista de elemente a NVDA când se selectează „Adnotări” ca tip.

### Microsoft Excel {#MicrosoftExcel}
#### Citire automată a antetului de rând și de coloană {#ExcelAutomaticColumnAndRowHeaderReading}

NVDA este capabil să anunțe automat anteturile corespunzătoare de rând și de coloană, când se navighează în foile de lucru Excel.
Această funcționalitate necesită, în primul rând, dezactivarea opțiunii „Anunță anteturi de rând sau coloană din tabel” din categoria de formatare a Documentului, aflată în dialogul [Setărilor NVDA](#NVDASettings).
În al doilea rând, NVDA are nevoie să știe rândul sau coloana care conține anteturile.
După mutarea la prima celulă în coloana sau rândul cu anteturi, folosiți una dintre următoarele comenzi:
<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Stabilește anteturi coloană |NVDA+shift+c |Apăsând o dată, spune NVDA că aceasta este prima celulă antet din rândul care conține anteturi de coloană, care ar trebui să fie anunțate automat când vă mișcați printre coloanele de sub acest rând. Apăsând de două ori, va anula desemnarea.|
|Stabilește anteturi rând |NVDA+shift+r |Apăsând o dată, spune NVDA că aceasta este prima celulă antet din coloana care conține anteturi de rând, care ar trebui să fie anunțate automat când vă mișcați printre rândurile de după această coloană. Apăsând de două ori, va anula desemnarea.|

<!-- KC:endInclude -->
Aceste configurări vor fi păstrate în registrul de lucru sub formă de zone denumite, compatibile cu alte cititoare de ecran cum ar fi Jaws.
Asta înseamnă că utilizatorii altor cititoare de ecran care deschid acest registru de lucru la un moment de timp ulterior, vor avea automat anteturile de rând și coloană deja stabilite.

#### Lista de elemente {#ExcelElementsList}

Similar cu webul, NVDA are o Listă de elemente pentru Microsoft Excel care vă permite să afișați și accesați mai multe tipuri diferite de informație.
<!-- KC:beginInclude -->
Pentru accesarea Listei de elemente în Excel, apăsați NVDA+F7.
<!-- KC:endInclude -->
Diversele tipuri de informație disponibile în Lista de elemente sunt:

* Diagrame: Listează toate diagramele din foaia de lucru activă.
Alegerea unei diagrame și apăsarea tastei „Enter” sau a butonului „Mută la”, focalizează diagrama pentru navigare și citire prin intermediul tastelor săgeată.
* Comentarii: Listează toate celulele foii de lucru active care conțin comentarii.
Pentru fiecare celulă, sunt afișate adresa celulei împreună cu comentariile ei.
Apăsând „Enter” sau butonul „Mută la”, când aveți selectat un comentariu din listă, vă va muta direct la celula respectivă.
* Formule: Listează toate celulele foii de lucru care conțin o formulă.
Pentru fiecare celulă, sunt afișate adresa celulei împreună cu formula ei.
Apăsând „Enter” sau butonul „Mută la”, când aveți selectată o formulă din listă, vă va muta direct la celula respectivă.
* Foi: Listează toate foile din registrul de lucru.
Apăsând F2 pe o foaie selectată din listă, vă permite redenumirea foii respective.
Apăsând „Enter” sau butonul „Mută la”, când aveți selectată o foaie din listă, vă va muta pe foaia respectivă.
* Câmpuri de formular: Listează toate câmpurile formular din foaia de lucru activă.
Pentru fiecare câmp formular, lista de elemente arată versiunea alternativă a textului din câmp, împreună cu adresele celulelor pe care le cuprinde.
Selectând un câmp de formular și apăsând Enter sau butonul „Mută la”, vă veți muta la câmpul respectiv în modul navigare.

#### Raportarea comentariilor {#ExcelReportingComments}

<!-- KC:beginInclude -->
Pentru a anunța toate comentariile pentru celula aflată curent sub focus, apăsați NVDA+alt+c.
<!-- KC:endInclude -->
Toate comentariile pentru foaia de lucru pot fi afișate și în Lista de elemente NVDA.

#### Citirea celulelor protejate {#ExcelReadingProtectedCells}

Dacă un registru de lucru a fost protejat, s-ar putea ca mutarea focalizării la o anumită celulă, care a fost blocată pentru editare, să nu fie posibilă.
<!-- KC:beginInclude -->
Pentru a permite navigarea la celule blocate, comutați pe Modul navigare, apăsând NVDA+spațiu și apoi folosiți comenzi de miscare standard ale Excel cum ar fi tastele săgeată pentru a vă misca printre toate celulele foii de lucru curente.
<!-- KC:endInclude -->

#### Câmpuri formular {#ExcelFormFields}

Foile de lucru Excel pot include câmpuri de formular.
Le puteți accesa, folosind lista de elemente sau tastele de navigare cu o singură literă pentru câmpuri formular „f” și „shift+f”.
Odată ce ați navigat la un câmp formular în modul navigare, puteți apăsa Enter sau Spațiu fie pentru a îl activa, fie pentru a comuta la modul focalizare ca să puteți interacționa cu acesta, în funcție de tipul de control.
Pentru mai multe informații despre Modul navigare și navigarea cu o singură literă, vedeți [secțiunea Mod Navigare](#ModNavigare).

### Microsoft PowerPoint {#MicrosoftPowerPoint}

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Comută citirea notelor de prezentare |control+shift+s |Într-o prezentare de diapozitive care rulează, această comandă va comuta între notele de prezentare ale diapozitivului și conținutul diapozitivului. Aceasta influențează doar ceea ce este citit de NVDA, nu și ceea ce este afișat pe ecran.|

<!-- KC:endInclude -->

### foobar2000 {#Foobar2000}

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Anunță timpul rămas |control+shift+r |Anunță timpul rămas pentru pista redată curent, dacă există.|
|Anunță timpul scurs |control+shift+e |Anunță timpul scurs pentru pista redată curent, dacă există.|
|Anunță Lungimea pistei |control+shift+t |Anunță lungimea pistei redate curent, dacă există.|

<!-- KC:endInclude -->

Notă: Comenzile de mai sus funcționează doar cu formatarea implicită a șirului de caractere din linia de stare a foobar.

### Miranda IM {#MirandaIM}

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Anunță mesajul recent |NVDA+control+1-4 |Anunță unul dintre mesajele recente, în funcție de cifra apăsată; de ex. NVDA+control+2 citește al doilea cel mai recent mesaj.|

<!-- KC:endInclude -->

### Poedit {#Poedit}

<!-- KC:beginInclude -->

| Nume |Tastă |Descriere|
|---|---|---|
|Anunță fereastra de comentarii |control+shift+c |Anunță orice comentariu din fereastra de comentarii.|
|Anunță notele pentru traducători |control+shift+a |Anunță orice notă pentru traducători.|

<!-- KC:endInclude -->

### Skype {#Skype}

<!-- KC:beginInclude -->
Când vă aflați într-o conversație:

| Nume |Tastă |Descriere|
|---|---|---|
|Verificare mesaj |NVDA+control+1-0 |Anunță și mută cursorul de examinare la un mesaj recent, depinzând de cifra apăsată; de ex. NVDA+control+2 citește cel de-al doilea cel mai recent mesaj.|

<!-- KC:endInclude -->

### Kindle pentru PC {#Kindle}

NVDA suportă citirea și navigarea cărților în Amazon Kindle pentru PC.
Această funcționalitate este disponibilă doar pentru cărțile Kindle  desemnate cu „Cititorul de Ecran: Suportat” pe care îl puteți verifica din pagina de detalii a cărții.

Modul navigare este folosit pentru cititul de cărți.
Acesta este activat automat când deschideți o carte sau focalizați zona cărții.
Pagina va fi întoarsă automat în mod adecvat când mutați cursorul sau folosiți comanda „rostește tot”.
<!-- KC:beginInclude -->
Puteți răsfoi la pagina următoare manual cu tasta pageDown și puteți să vă întoarceți la pagina precedentă cu tasta pageUp.
<!-- KC:endInclude -->

Navigarea cu o singură tastă este suportată pentru legături sau grafice, dar doar în cadrul paginii curente.
Navigarea prin legături include, de asemenea, note de subsol.

NVDA furnizează asistență timpurie pentru citire și navigare interactivă a conținutului matematic pentru cărți cu format matematic accesibil.
Vă rugăm consultați secțiunea de [Citire a conținutului matematic](#CitireMatematica) pentru informații adiționale.

#### Selectarea textului {#KindleTextSelection}

Kindle vă permite să executați diferite funcții pe textul selectat, incluzând obținerea unei definiții de dicționar, adăugarea de note sau sublinieri, copierea textului pe planșetă sau căutarea pe Web.
Pentru a face asta, mai întâi selectați textul cum o faceți în mod obișnuit în modul navigare; de ex: folosind shift și tastele cursor.
<!-- KC:beginInclude -->
Odată textul selectat, apăsați tasta pentru aplicații sau shift+F10 pentru a afișa opțiunile disponibile pentru lucrul cu selecția.
<!-- KC:endInclude -->
Dacă faceți asta fără să aveți text selectat, vă vor fi arătate opțiuni pentru cuvântul aflat la poziția cursorului.

#### Note de utilizator {#KindleUserNotes}

Puteți adăuga o notă referitoare la un cuvânt sau un pasaj de text.
Pentru a face asta, mai întâi selectați textul relevant și accesați opțiunile de selecție după cum este descris mai sus.
Alegeți apoi „Adaugă notă”.

Când citiți in mod navigare, NVDA vede aceste note sub formă de comentarii.

Pentru a vizualiza, edita sau șterge o notă:

1. Deplasați cursorul la textul care conține nota.
1. Accesați opțiunile pentru selecție după cum este descris mai sus.
1. Alegeți „Editează notă”.

### Azardi {#Azardi}

<!-- KC:beginInclude -->
În vizualizarea de tabel a cărților adăugate:

| Nume |Tastă |Descriere|
|---|---|---|
|Enter |enter |Deschide cartea selectată.|
|Context meniu |aplicații |Deschide meniul context al cărții selectate.|

<!-- KC:endInclude -->

### Consola Windows {#WinConsole}

NVDA oferă suport pentru consola de comandă Windows folosită de Linia de Comandă, PowerShell și de subsistemul Windows pentru Linux.
Pe măsură ce un nou text este scris, conținutul se deplasează în sus, iar textul precedent nu mai este vizibil.
Textul care nu este vizibil afișat în fereastră nu este accesibil cu comenzile NVDA de examinare a textului.
Prin urmare, este necesar să derulați fereastra consolei pentru a citi texte mai vechi.
<!-- KC:beginInclude -->
Următoarele combinații de taste ale Consolei Windows vă pot fi de folos atunci când [examinați textul](#ExaminareaTextului) cu NVDA:

| Nume |Tastă |Descriere|
|---|---|---|
|Derulează în sus |control+săgeată sus |Derulează fereastra consolei în sus, putând fi citite astfel textele mai vechi.|
|Derulează în jos |control+săgeată jos |Derulează în jos fereastra consolei, putând fi citite astfel textele mai noi.|
|Derulează la început |control+home |Derulează fereastra consolei la începutul buffer-ului.|
|Derulează la sfârșit |control+end |Derulează fereastra consolei la sfârșitul buffer-ului.|

<!-- KC:endInclude -->

## Configurarea NVDA {#ConfiguringNVDA}

Majoritatea setărilor NVDA pot fi schimbate folosind ferestre de dialog accesate prin submeniul „Preferințe” din meniul NVDA.
În toate ferestrele de dialog ale setărilor NVDA, apăsați butonul OK pentru acceptarea oricăror schimbări pe care le-ați făcut.
Pentru anularea oricărei schimbări, apăsați butonul Anulare sau tasta Escape.
Unele setări pot fi schimbate și folosind taste scurtături, care sunt listate în secțiunile următoare, acolo unde sunt relevante.

De notat că, implicit, nu toate dialogurile cu preferințe pot fi accesate prin gesturi de intrare (comenzi de la tastatură, gesturi de atingere, etc.).
Dacă doriți să accesați ferestre dialog care nu au scurtături dedicate, folosiți [fereastra de dialog pentru Gesturi de intrare](#GesturiIntrare) pentru a adăuga gesturi personalizate pentru dialogul respectiv.

### Setările NVDA {#NVDASettings}

<!-- KC:settingsSection: || Nume | Tastă birou| Tastă laptop| Descriere | -->
Dialogul setărilor NVDA conține mulți parametri de configurare care pot fi modificați.
Acest dialog conține o listă cu mai multe categorii de setări de ales.
Atunci când selectați o categorie, mai multe setări corespunzătoare ei vor fi afișate în acest dialog.
Aplicarea acestor setări poate fi realizată utilizând butonul „se aplică”, în cazul în care dialogul va rămâne deschis.
Dacă vreți să vă salvați setările și să închideți acest dialog, puteți folosi butonul „OK”.
Unele categorii de setări au o combinație de taste dedicată.
Dacă-i apăsată, aceasta va deschide dialogul setărilor NVDA în acea categorie particulară.
În mod implicit, nu toate categoriile pot fi accesate folosind comenzi de taste.
Dacă doriți să accesați categorii care n-au combinații de taste dedicate, folosiți [Dialogul gesturilor de intrare](#GesturiIntrare) pentru a adăuga un gest personalizat, cum ar fi o combinație de taste sau un gest de atingere pentru acea categorie

Categoriile de setări, găsite în dialogul setărilor NVDA, vor fi prezentate mai jos.

#### General (NVDA+control+g) {#GeneralSettings}

Categoria „General” a dialogului de setări conține următoarele opțiuni:

##### Limba {#GeneralSettingsLanguage}

O listă de selecție care vă permite să alegeți limba în care va fi prezentată interfața utilizatorului și mesajele din NVDA.
Sunt definite multe limbi, dar opțiunea implicită este „Implicită pentru utilizator, Windows”. 
Această opțiune instruiește NVDA să folosească limba curentă stabilită în Windows.

Trebuie să știți că NVDA trebuie repornit când se schimbă limba.
NVDA vă va întreba dacă doriți să-l reporniți dacă schimbați alegerea și salvați modificările.
Apăsați OK și NVDA va reporni.

##### Salvează configurația la ieșire {#GeneralSettingsSaveConfig}

Această opțiune este o casetă de bifat care, când este bifată, instruiește NVDA să salveze automat configurarea curentă când închideți NVDA.

##### Arată opțiunile de ieșire când se părăsește NVDA {#GeneralSettingsShowExitOptions}

Această opțiune este o casetă de bifat care vă permite să alegeți dacă apare sau nu o fereastră de dialog la ieșirea din NVDA care întreabă ce acțiune ați vrea să faceți.
Când este bifată, va apărea o fereastră de dialog când încercați să ieșiți din NVDA, care vă întreabă dacă doriți să ieșiți, reporniți, reporniți cu extensiile add-on dezactivate sau să instalați actualizările aflate în așteptare (dacă există).
Când nu este bifată, NVDA se va închide imediat.

##### Redă sunete când se pornește sau se părăsește NVDA {#GeneralSettingsPlaySounds}

Această opțiune este o casetă de bifat care, când este bifată, instruiește NVDA să redea sunete când pornește sau se oprește.

##### Nivel înregistrări din jurnal {#GeneralSettingsLogLevel}

Aceasta este o listă de selecție care vă permite să alegeți cât va înregistra NVDA în jurnal când rulează.
În general, utilizatorii nu trebuie să modifice această opțiune, nefiind înregistrat prea mult în jurnal.
Dar dacă doriți să oferiți informații în raportarea unui defect sau să activați ori să dezactivați complet nivelul de înregistrare, atunci poate fi o opțiune utilă.

Nivelele de înregistrare disponibile sunt:
Dezactivat: În afară de un scurt mesaj de pornire, NVDA nu va înregistra nimic cât timp rulează.

* Info: NVDA va înregistra informații de bază precum mesaje de pornire și informații utile pentru dezvoltatori.
* Avertisment la diagnosticare: Mesajele de avertisment care nu sunt cauzate de erori grave vor fi înregistrate.
* Intrare/ieșire: Intrare de la tastatură și de la afișajele braille, dar și ieșirea și vorbirea braille vor fi înregistrate.
 * Dacă sunteți preocupat de confidențialitate, nu setați nivelul de înregistrare la această opțiune.
* Diagnosticare: În plus față de info, avertisment și mesajele de intrare/ieșire, mesajele suplimentare de diagnosticare vor fi înregistrate.
 * Ca și în cazul opțiunii intrare/ieșire, dacă sunteți preocupat de confidențialitate, nu activați această opțiune.
-

==== Pornește NVDA automat după ce mă autentific în Windows ====[GeneralSettingsStartAfterLogOn]
Dacă această opțiune este activată, NVDA va porni automat imediat ce v-ați autentificat în Windows.
Această opțiune este disponibilă doar pentru copiile instalate ale NVDA.

==== Folosește NVDA în ecranul de autentificare Windows (cere privilegii de administrator) ====[GeneralSettingsStartOnLogOnScreen]
Dacă vă autentificați în Windows cu un nume de utilizator și o parolă, atunci activarea acestei opțiuni va face NVDA să pornească automat la ecranul de autentificare, când pornește Windows.
Această opțiune este disponibilă doar pentru copiile instalate ale NVDA.

==== Folosește preferințele curent salvate asupra ecranului de autentificare și a altor ecrane securizate (cere privilegii de administrator) ====[GeneralSettingsCopySettings]
Apăsând acest buton copiază configurarea de utilizator NVDA curent salvată în dosarul de configurație a sistemului NVDA, astfel încât NVDA o va folosi când rulează în ecranul de autentificare, Controlul Contului Utilizatorului (UAC) și alte ecrane de siguranță Windows.
Pentru a vă asigura că sunt transferate toate setările dumneavoastră, aveți grijă ca mai întâi să salvați configurarea cu control+NVDA+c sau opțiunea „Salvează configurare” din meniul NVDA. 
Această opțiune este disponibilă doar pentru copiile instalate ale NVDA.

==== Verifică automat existența actualizărilor NVDA ====[GeneralSettingsCheckForUpdates]
Dacă opțiunea este activată, NVDA va verifica automat dacă există versiuni mai noi ale programului și va informa când acestea sunt disponibile.
Puteți, de asemenea, să verificați manual apariția noilor versiuni prin selectarea opțiunii „Verifică actualizări...” din meniul de „Ajutor” al NVDA.
Când verificați manual sau automat actualizările, este necesar ca NVDA să trimită anumite informații serverului de actualizare pentru a primi actualizarea corectă conform sistemului folosit.
Următoarele informații sunt trimise actual către server:
* Versiunea NVDA actuală
* Versiunea sistemului de operare
* Arhitectura sistemului de operare (64 sau 32 de biți).

##### Acceptarea trimiterii statisticilor de folosire către NV Access {#GeneralSettingsGatherUsageStats}

Dacă acceptați ca, în timpul verificării automate pentru actualizări noi, NVDA să trimită statisticile către NV Access, aceste informații vor fi folosite pentru a descoperi numărul de utilizatori și aspectele tipice precum țara și versiunea  sistemului de operare.
Adresa de IP nu va fi salvată în niciun caz. Dar, notați că adresa de IP va fi folosită temporar pentru a se afla țara în care se folosește NVDA în acel moment.
În afara informațiilor obligatorii pentru a face posibilă verificarea automată pentru actualizări noi, NVDA va trimite următoarele informații suplimentare:

* Limba de interfață
* Tipul instanței de NVDA (copie portabilă sau versiune instalată)
* Numele sintetizatorului actual și numele suplimentului de la care provine driverul pentru sintetizator
* Numele afișajului braille conectat și numele suplimentului de la care provine driverul afișajului
* Dacă ieșirea braille este activă, se trimite tabelul actual de ieșire braille

Aceste informații sunt de un ajutor enorm pentru NV Access pentru a putea prioriza dezvoltarea cititorului de ecran NVDA în viitor.

##### Notifică actualizările în așteptare la pornire {#GeneralSettingsNotifyPendingUpdates}

Dacă e activată, NVDA vă va informa atunci când există o actualizare în așteptare la pornire, oferindu-vă posibilitatea de a o instala.
De asemenea, puteți instala manual actualizarea în așteptare din dialogul de ieșire al NVDA-ului (dacă-i activat), din meniul NVDA sau când efectuați o căutare de actualizări din meniul ajutor.

#### Setări Vorbire (NVDA+control+v) {#SpeechSettings}

Categoria „Vorbire, găsită în meniul „Preferințe”, conține opțiuni care vă lasă să schimbați sintetizatorul, precum și sunetul vorbirii.
Pentru un mod alternativ mai rapid de control al parametrilor de vorbire de oriunde, vă rugăm citiți secțiunea [Inelul setărilor sintetizatorului](#InelSetariSintetizator).

Categoria „Setări vorbire” conține următoarele opțiuni:

##### Modificare sintetizator {#SpeechSettingsChange}

Prima opțiune din categoria „Setări Vorbire” este butonul „Modifică...”. Acesta activează [Dialogul selectării sintetizatorului](#SynthesizerSelection), care vă permite să selectați sintetizatorul de vorbire activ și dispozitivul de ieșire.
Acest dialog se deschide în partea de sus a celui de setări.
Salvarea sau renunțarea la setările din dialogul „Selectare sintetizator” vă va întoarce la dialogul setărilor NVDA.

##### Voce {#SpeechSettingsVoice}

Opțiunea „Voce” este o casetă combinată care prezintă toate vocile sintetizatorului curent instalat.
Puteți folosi săgețile direcționale pentru ascultarea tuturor opțiunilor.
Săgețile stânga și sus vă duc spre partea de sus a listei, iar săgețile dreapta și jos vă duc spre partea de jos a listei.

##### Variantă {#SpeechSettingsVariant}

Dacă folosiți sintetizatorul eSpeak NG, integrat în NVDA, aceasta este o listă de selecție care vă lasă să alegeți varianta cu care să vorbească sintetizatorul.
Variantele eSpeak NG sunt mai degrabă variante de voci, deoarece oferă atribute ușor diferite vocii eSpeak NG.
Unele variante sună ca voci bărbătești, unele ca voci feminine, iar unele sună chiar ca o broască.

##### Viteză {#SpeechSettingsRate}

Această opțiune vă permite să schimbați viteza vocii.
Acesta este un glisor cu valori de la 0 la 100 (0 fiind cel mai lent, 100 fiind cel mai rapid).

##### Amplitudine {#SpeechSettingsPitch}

Această opțiune vă permite să alegeți amplitudinea vocii curente.
Este un glisor cu valori de la 0 la 100 (0 fiind amplitudinea cea mai joasă, 100 fiind amplitudinea cea mai înaltă).

##### Volum {#SpeechSettingsVolume}

Această opțiune este un glisor cu valori de la 0 la 100 (0 fiind volumul cel mai mic și 100 fiind maximul).

##### Intonație {#SpeechSettingsInflection}

Această opțiune este un glisor care vă permite să alegeți câtă intonație (creștere și scădere a amplitudinii) ar trebui să folosească sintetizatorul în vorbire. (Singurul sintetizator care oferă această opțiune în prezent este eSpeak NG).

##### Comutare automată a limbii {#SpeechSettingsLanguageSwitching}

Această casetă de bifat vă permite să alegeți dacă NVDA ar trebui să schimbe limbile sintetizatorului de vorbire în mod automat, dacă textul citit specifică limba în care a fost scris.
Opțiunea este activată implicit.
În momentul de față, doar sintetizatorul eSpeak NG este compatibil cu schimbarea limbii automat.

##### Comutare automată a dialectului {#SpeechSettingsDialectSwitching}

Această casetă de bifat vă permite să alegeți dacă sau nu ar trebui făcute schimbări de dialect, mai degrabă decât doar schimbări de limbă.
De exemplu, dacă se citește cu o voce în engleză americană, dar documentul specifică faptul că o parte a textului este în engleză britanică, atunci sintetizatorul va comuta accentele dacă această opțiune este activată.
Opțiunea este dezactivată implicit.

<!-- KC:setting -->

##### Nivel punctuație/simbol {#SpeechSettingsSymbolLevel}

Tastă: NVDA+p

Aceasta vă permite să alegeți nivelul de punctuație și alte simboluri care ar trebui pronunțate ca și cuvinte.
De exemplu, când este pus pe „toate”, toate simbolurile vor fi pronunțate precum cuvinte.
Această opțiune se aplică tuturor sintetizatoarelor, nu doar celui activ curent.

##### Bazează-te pe limba vocii când se procesează caractere și simboluri {#SpeechSettingsTrust}

Activată implicit, această opțiune indică NVDA dacă limba vocii curente poate fi de încredere atunci când se procesează simboluri și caractere.
Dacă descoperiți că NVDA citește punctuația în limba greșită pentru un anumit sintetizator sau o anumită voce, veți dori să dezactivați această opțiune pentru a forța NVDA să folosească, în schimb, configurația generală de limbă.

##### Include datele Unicode Consortium (inclusiv emoji) atunci când se procesează caractere și simboluri {#SpeechSettingsCLDR}

Atunci când această casetă este bifată, NVDA va include dicționare adiționale de pronunțare a simbolurilor când se pronunță caractere și simboluri.
Dicționarele conțin descrieri pentru simboluri (particular emoji) care sunt furnizate de [Unicode Consortium](https://www.unicode.org/consortium/) ca parte a [depozitului lor de date locale comune](https://cldr.unicode.org/).
Dacă vreți ca NVDA să rostească descrieri ale caracterelor emoji bazate pe aceste date, trebuie să activați această opțiune.
Totuși, dacă folosiți o sinteză vocală care are suport nativ pentru rostirea descrierilor emoji, puteți dori să opriți asta.

Rețineți că descrierile caracterelor adăugate manual sau editate sunt salvate ca parte a setărilor dumneavoastră de utilizator.
Prin urmare, dacă modificați descrierea unui emoji particular, acea descriere personalizată va fi rostită pentru acel emoji, indiferent dacă această opțiune este activată.
Puteți adăuga, edita sau șterge descrieri de simboluri din [dialogul rostirii punctuației/simbolurilor](#SymbolPronunciation).

##### Procent schimbare amplitudine la citirea majusculelor {#SpeechSettingsCapPitchChange}

Acest câmp editabil vă permite să tastați valoarea cu care amplitudinea vocii se va schimba când se pronunță majuscule.
Valoarea este în procente, unde o valoare negativă scade amplitudinea, iar una pozitivă o crește.
Folosiți 0 pentru a nu avea schimbări de amplitudine.

##### Spune „mare” după majuscule {#SpeechSettingsSayCapBefore}

Această setare este o casetă de bifat care, când este bifată, instruiește NVDA să spună cuvântul „mare” după oricare majusculă, când cursorul mausului se află deasupra ei sau când o pronunță atunci când e scrisă.
De obicei, NVDA crește ușor amplitudinea pentru orice literă majusculă, dar unele sintetizatoare nu pot suporta asta, deci poate că această opțiune poate fi de ajutor.

##### Emite bip pentru majuscule {#SpeechSettingsBeepForCaps}

Dacă această casetă este bifată, NVDA va emite un scurt semnal sonor de fiecare dată când întâlnește o majusculă.
La fel ca opțiunea „spune «mare» pentru majuscule”, aceasta este utilă pentru sintetizatoare care nu pot schimba amplitudinea pentru majuscule.

##### Folosește funcționalitatea de silabisire dacă este suportată {#SpeechSettingsUseSpelling}

Anumite cuvinte au un singur caracter, dar pronunția este diferită dacă respectivul caracter este pronunțat ca un caracter individual (la fel ca pronunția pe litere) sau ca un cuvânt.
De exemplu, în engleză, „a” este atât o literă cât și un cuvânt și este pronunțat diferit în fiecare caz. 
Această opțiune permite sintetizatorului să distingă între aceste două cazuri, dacă sintetizatorul suportă asta.
Majoritatea sintetizatoarelor suportă funcționalitatea.

Această opțiune ar trebui, în general, să fie activată.
Cu toate acestea, anumite sintetizatoare Microsoft Speech API nu implementează această opțiune corect și se comportă ciudat când este activată.
Dacă aveți probleme cu pronunția caracterelor individuale, încercați să dezactivați această opțiune.

#### Selectarea sintetizatorului (NVDA+control+s) {#SelectSynthesizer}

Fereastra de dialog pentru sintetizator, care se găsește în submeniul „Sintetizator...” în meniul Preferințe, vă permite să alegeți ce sintetizator să folosească NVDA pentru vorbire.
Odată ce ați ales sintetizatorul dorit, puteți apăsa OK și NVDA va încărca sintetizatorul ales.
Dacă apare o eroare la încărcarea sintetizatorului, NVDA vă va anunța cu un mesaj și va continua să folosească sintetizatorul anterior.

##### Sintetizator {#SynthesizerSelectSynthesizer}

Această opțiune vă permite să alegeți sintetizatorul pe care doriți să-l folosească NVDA pentru vorbire.

Pentru o listă de sintetizatoare suportate de NVDA, vă rugăm citiți secțiunea [Sintetizatoare de vorbire suportate](#SintetizatoareVorbireCompatibile).

Un element special care va apărea întotdeauna în această listă este „Fără vorbire”, care vă permite să folosiți NVDA fără niciun fel de vorbire.
Această opțiune poate fi utilă pentru cineva care dorește să folosească NVDA doar cu Braille sau poate programatorii cu vedere care doresc să folosească doar ecranul de vorbire.

##### Dispozitiv de ieșire {#SynthesizerSelectionOutputDevice}

Această opțiune vă permite să alegeți placa de sunet, iar NVDA va instrui sintetizatorul ales să o folosească.

<!-- KC:setting -->

##### Mod atenuare audio {#SynthesizerSelectionDuckingMode}

Tastă: NVDA+shift+d

În Windows 8 sau mai nou, această opțiune vă permite să alegeți dacă NVDA ar trebui să scadă volumul altor aplicații atunci când vorbește, sau tot timpul cât NVDA rulează.

* Fără atenuare: NVDA nu va scădea niciodată volumul altor surse audio.
* Atenuează când la ieșire sunt sunete sau voce: NVDA va scădea volumul altor surse audio când NVDA vorbește sau redă sunete. Opțiunea ar putea să nu fie disponibilă pentru toate sintetizatoarele.
* Atenuează totdeauna: NVDA va menține volumul altor surse audio scăzut tot timpul cât va rula.

Această opțiune este disponibilă doar dacă NVDA a fost instalată.
Atenuarea audio nu este suportată pentru copiile portabile sau temporare ale NVDA.

#### Inelul setărilor sintetizatorului {#InelSetariSintetizator}

Dacă doriți să schimbați rapid setările vocii fără să intrați în fereastra de dialog pentru setările vocii, există câteva comenzi NVDA din taste care vă permit să accesați cele mai comune setări pentru vorbire de oriunde, când rulați NVDA:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Descriere|
|---|---|---|---|
|Trece la setarea următoare a sintetizatorului |NVDA+control+săgeată dreapta |NVDA+shift+control+săgeată dreapta |Trece la următoare setare disponibilă pentru vorbire după cea curentă, selectând din nou prima setare după ce trece de ultima|
|Trece la setarea anterioară a sintetizatorului |NVDA+control+săgeată stânga |NVDA+shift+control+săgeată stânga |Trece la următoarea setare disponibilă pentru vorbire înainte de cea curentă, selectând ultima setare după ce trece de prima|
|Crește setarea curentă a sintetizatorului |NVDA+control+săgeată sus |NVDA+shift+control+săgeată sus |Crește setarea curentă a vorbirii. De exemplu crește viteza, alege vocea următoare, crește volumul|
|Scade setarea curentă a sintetizatorului |NVDA+control+săgeată jos |NVDA+shift+control+săgeată jos |Scade setarea curentă a vorbirii. De exemplu scade viteza, alege vocea anterioară, scade volumul|

<!-- KC:endInclude -->

#### Braille {#SetariBraille}

Categoria „Braille” din dialogul setărilor NVDA conține
opțiuni care vă lasă să schimbați mai multe aspecte ale intrării și ieșirii braille.
Aceasta conține următoarele opțiuni:

##### Modificare afișaj Braille {#BrailleSettingsChange}

Butonul „Modificare...” din categoria „Braille” activează [dialogul de selectare a afișajului Braille](#SelectBrailleDisplay), care vă permite să selectați afișajul braille activ.
Acest dialog se deschide în partea de sus a celui de setări.
Salvarea sau renunțarea la setările din dialogul selectării afișajului braille vă va întoarce la dialogul de setări.

##### Tabel ieșiri {#BrailleSettingsOutputTable}

Următoarea opțiune întâlnită în această categorie este caseta combinată a tabelului braille. 
În această casetă combinată, veți găsi tabele braille pentru diferite limbi, braille standard și grade. 
Tabelul ales va fi folosit pentru traducerea textului în braille pentru a fi prezentat pe afișajul dumneavoastră braille.
Vă puteți deplasa de la un tabel braille la altul din listă folosind tastele direcționale.

##### Tabel intrări {#BrailleSettingsInputTable}

Complementar opțiunii anterioare, următoarea setare pe care o veți găsi este caseta combinată pentru tabelul de intrări.
Tabelul ales va fi folosit pentru traducerea braille, introdus cu tastatura dumneavoastră în format Perkins, de la afișajul dumneavoastră braille în text.
Vă puteți deplasa de la un tabel braille la altul din listă folosind tastele săgeată.

De notat faptul că această opțiune este utilizabilă doar dacă afișajul dumneavoastră braille are o tastatură în format Perkins și această funcționalitate este suportată de driverul afișajului braille.
Dacă intrările nu sunt suportate pe un afișaj care are o tastatură braille, acest lucru va fi notat în secțiunea [Afișaje Braille suportate](#AfisBrailleCompatibile).

##### Dezvoltă cuvântul de la cursor în braille pentru calculator {#BrailleSettingsExpandToComputerBraille}

Această opțiune permite cuvântului de sub cursor să fie afișat în braille pentru computere necontractat.

##### Arată cursor {#BrailleSettingsShowCursor}

Această opțiune permite activarea sau dezactivarea cursorului braille.
Se aplică cursorului de scriere al sistemului și cursorului de examinare, dar nu și indicatorului de selecție.

##### Cursor intermitent {#BrailleSettingsBlinkCursor}

Această opțiune permite cursorului braille să clipească (să apară intermitent).
Dacă opțiunea de intermitență este dezactivată, cursorul braille va rămâne constant pe poziția „pornit”.
Indicatorul de selecție nu este afectat de această opțiune; acesta este întotdeauna punctele 7 și 8 fără intermitență.

##### Frecvența intermitenței cursorului (ms) {#BrailleSettingsBlinkRate}

Această opțiune este un câmp numeric care permite schimbarea ratei de clipire a cursorului în milisecunde.

##### Formă cursor pentru focalizare {#BrailleSettingsCursorShapeForFocus}

Opțiunea vă permite să alegeți forma (tiparul din puncte a) cursorului braille atunci când braille este asociat la focalizare.
Indicatorul de selecție nu este influențat de această opțiune; acesta este întotdeauna punctele 7 și 8 fără intermitență.

##### Formă cursor pentru examinare {#BrailleSettingsCursorShapeForReview}

Această opțiune vă permite să alegeți forma (tiparul din puncte a) cursorului braille atunci când braille este asociat la examinare
Indicatorul de selecție nu este influențat de această opțiune; acesta este întotdeauna punctele 7 și 8 fără intermitență.

##### Timp expirare mesaj (sec) {#BrailleSettingsMessageTimeout}

Această opțiune este un câmp numeric care controlează cât timp sunt afișate mesajele NVDA pe afișajul braille.
Specificând 0 dezactivează complet afișajul acestor mesaje.

##### Arată mesajele pe termen nelimitat {#BrailleSettingsNoMessageTimeout}

Această opțiune le permite mesajelor NVDA-ului  să fie afișate pe afișajul braille pe termen nelimitat.

<!-- KC:setting -->

##### Braille asociat la {#AsociereBraille}

Tastă: NVDA+control+t

Această opțiune vă permite să alegeți dacă afișajul braille va urma focalizarea sistemului, va urma obiectul navigator / cursorul de examinare sau ambele.
Când e selectat „automat”, NVDA va urmări focalizarea sistemului și cursorul de scriere al acestuia în mod implicit.
În acest caz, dacă poziția obiectului navigator sau cea a cursorului de examinare este modificată de interacțiunea explicită a utilizatorului, NVDA va asocia la examinare temporar, până când focalizarea sau cursorul de scriere se modifică.

##### Citire paragraf cu paragraf {#BrailleSettingsReadByParagraph}

Dacă este activat, braille va fi afișat per paragraf în loc de per linie.
De asemenea, comenzile pentru linia următoare și anterioară, vor muta la nivel de paragraf, în mod corespunzător.
Asta înseamnă că nu trebuie să derulați afișajul la sfârșitul fiecărei linii chiar și acolo unde ar încăpea mai mult text pe afișaj.
Opțiunea ar putea permite o citire mai cursivă pentru texte de lungime mare. 
Este dezactivată implicit.

##### Evită despărțirea cuvintelor când e posibil {#BrailleSettingsWordWrap}

Dacă opțiunea este activată, un cuvânt care este prea lung pentru a încăpea la capătul afișajului braille, nu va fi despărțit.
În schimb, va exista niște spațiu gol la capătul afișajului.
Dacă derulați afișajul, veți putea citi cuvântul complet.
Aceasta, uneori, poartă numele de „împachetare a cuvintelor”.
De notat că dacă acel cuvânt este prea lung pentru a încăpea pe afișaj, chiar și de unul singur, va trebui să fie, în final, despărțit.

Dacă opțiunea este dezactivată, se va afișa din cuvânt cât de mult este posibil, dar restul va fi tăiat.
După ce derulați afișajul, veți putea citi și restul cuvântului.

Activarea acestei opțiuni ar putea permite un citit mai cursiv, dar în general este nevoie să derulați afișajul mai mult.

##### Focalizare pe contextul prezentării {#BrailleSettingsFocusContextPresentation}

Această opțiune vă perite să alegeți ce  informație de context va prezenta NVDA pe afișajul braille, când un obiect primește focalizarea.
Informația de context se referă la ierarhia obiectelor care conțin focalizarea.
De exemplu, când focalizați un element din listă, acest obiect este parte a unei liste.
La rândul ei, această listă poate fi conținută de un dialog, etc.
Vă rugăm consultați secțiunea despre [navigarea prin obiecte](#NavigareObiect) pentru mai multe informații despre ierarhia care se aplică obiectelor în NVDA.

Când trebuie să umple afișajul cu schimbări ale contextului, NVDA va încerca să afișeze cât mai multă informație pe afișajul braille, dar doar pentru părțile din context care s-au schimbat.
Pentru exeplul de mai sus, acest lucru înseamnă că la schimbarea focalizării către listă, NVDA vă prezenta elementul din listă pe afișajul braille.
Mai mult, dacă rămâne suficient spațiu pe afișajul braille, NVDA va încerca să arate că elementul face parte dintr-o listă.
Dacă veți începe, după aceea, să vă mișcați prin listă cu tastele săgeată, se presupune că știți deja că sunteți în acea listă.
Astfel, pentru elementele din listă, rămase, pe care le focalizați, NVDA va prezenta doar elementul de listă focalizat pe afișaj.
Pentru ca să puteți citi contextul din nou (adică faptul că sunteți într-o listă și aceasta este parte dintr-un dialog), va trebui să derulați înapoi afișajul braille.

Când această opțiune este configurată să încarce afișajul de fiecare dată, NVDA va încerca să prezinte pe afișajul braille cât mai multă informație de context posibil, indiferent dacă v-a mai fost afișată aceeași informație de context înainte.
Avantajul acestei opțiuni este că NVDA va pune, pe cât posibil, cât mai multă informație pe afișaj.
Cu toate acestea, dezavantajul este că întotdeauna există o diferență a poziției la care începe focalizarea pe afișajul braille.
Acest lucru poate face dificilă, de exemplu, răsfoirea unei liste lungi de elemente, pentru că va trebui să vă mutați degetul constant pentru a găsi începutul elementului.
Acesta era comportamentul implicit pentru NVDA 2017.2 și versiunile anterioare.

Când puneți focalizarea pe contextul prezentării pe opțiunea de a vă prezenta contextul doar când derulați înapoi, NVDA nu va arăta informații de context in mod implicit, pe afișajul dumneavoastră braille.
Astfel, în exemplul de mai sus, NVDA vă arăta că ați focalizat un element de listă.
Totuși, pentru ca să puteți citi contextul (adică faptul că sunteți într-o listă și aceasta este parte dintr-un dialog), va trebui să derulați înapoi afișajul dumneavoastră braille.

Pentru a activa focalizarea pe contextul prezentării de oriunde, puteți atribui un gest personalizat, folosind [fereastra dialog pentru Gesturi de intrare](#GesturiIntrare)

#### Selectare afișaj braille (NVDA+control+a) {#SelectBrailleDisplay}

Dialogul de selectare a afișajului braille, care poate fi deschis apăsând butonul „Modificare...” din categoria „Braille” a dialogului setărilor NVDA, vă permite să selectați ce afișaj braille ar trebui să utilizeze NVDA pentru ieșirea braille.
Odată ce ați selectat afișajul braille, NVDA va încărca afișajul braille selectat.
Dacă există o eroare la încărcarea driver-ului afișajului, NVDA vă va notifica cu un mesaj și va continua să folosească afișajul precedent dacă există.

##### Afișaj braille {#SelectBrailleDisplayDisplay}

Această casetă combinată vă prezintă mai multe opțiuni, depinzând de ce drivere de afișaje braille sunt disponibile pe sistemul dumneavoastră.
Deplasați-vă printre ele cu săgețile.
Opțiunea „automat” caută orice afișaj braille suportat care este conectat și îl activează în fundal.
Dacă alegeți această opțiune și conectați un afișaj braille suportat prin Bluetooth sau USB, NVDA se va conecta automat cu acel afișaj.

Fără braille înseamnă că nu folosiți braille.

Citiți secțiunea [Afișaje braille suportate](#SupportedBrailleDisplays) pentru mai multe informații despre acestea și care dintre ele suportă detectarea automată în fundal.

##### Port {#SelectBrailleDisplayPort}

Această opțiune, dacă este disponibilă, vă permite să alegeți ce port sau tip de conexiune vor fi utilizate pentru a comunica cu afișajul braille pe care l-ați ales.
E o casetă combinată care conține potențialele alegeri pentru afișajul dumneavoastră braille.
În mod implicit, NVDA utilizează detectarea automată a porturilor, ceea ce înseamnă că conexiunea cu dispozitivul braille va fi stabilită automat prin scanarea dispozitivelor USB și Bluetooth disponibile pe sistem.
Cu toate acestea, pentru unele afișaje  braille, este posibil să alegeți în mod explicit ce port ar trebui să fie utilizat.
Opțiunile comune sunt "Automat" (care indică NVDA să utilizeze procedura implicită de selectare automată a portului), "USB", "Bluetooth" și porturi de comunicații seriale vechi, dacă afișajul dvs. braille acceptă acest tip de comunicare.

Această opțiune nu va fi disponibilă dacă afișajul dvs. braille acceptă numai detectarea automată a porturilor.

Ați putea consulta documentația pentru afișajul dumneavoastră braille în secțiunea [afișaje braille suportate](#SupportedBrailleDisplays)

#### Vedere {#VisionSettings}

Categoria Vedere din setările NVDA vă permite să activați, să dezactivați și să configurați [ajutorul vizual](#Vision).

Rețineți că opțiunile disponibile în această categorie ar putea fi extinse de [suplimentele NVDA](#AddonsManager).
În mod implicit, această categorie de setări conține următoarele opțiuni:

##### Evidențiere focalizare {#VisionSettingsFocusHighlight}

Casetele de bifat din această grupare controlează comportamentul [evidențierii focalizării](#VisionFocusHighlight).

* Activează evidențierea: Activează sau dezactivează evidențierea focalizării.
* Evidențiază focalizarea sistemului: Activează sau dezactivează [evidențierea focalizării sistemului](#SystemFocus).
* Evidențiază obiectul navigator: activează sau dezactivează [evidențierea obiectului navigator](#ObjectNavigation).
* Activează cursorul modului de navigare: Activează sau dezactivează [evidențierea cursorului virtual al modului de navigare](#BrowseMode)

Rețineți că bifând sau debifând caseta „Activare evidențiere” veți modifica și starea celorlalte trei.
Așadar, dacă bifați această casetă, și celelalte vor fi bifate automat.
Dacă vreți doar să evidențiați focalizarea și să lăsați nebifate casetele atribuite evidențierii modului de navigare și a obiectului navigator, caseta „Activare evidențiere” va fi parțial bifată.

##### Cortină Ecran {#VisionSettingsScreenCurtain}

Puteți activa [cortina ecranului](#VisionScreenCurtain) bifând caseta „Fă ecranul negru (efect imediat)”.
Veți fi avertizat că ecranul se va face negru după activare.
Înainte de a continua apăsând butonul „Da”, asigurați-vă că vorbirea sau braille-ul sunt active, ca să puteți controla calculatorul fără să utilizați ecranul.
Apăsați butonul „Nu” dacă nu mai doriți să activați cortina.
Dacă sunteți sigur, puteți apăsa butonul „Da” pentru a o activa.
Dacă nu mai  vreți să vedeți acest mesaj de avertizare de fiecare dată, puteți modifica acest comportament dinn dialogul care îl afișează.
Puteți oricând să faceți ca mesajul să se afișeze bifând caseta „Afișează întotdeauna un mesaj de avertizare la încărcarea cortinei ecranului”, care se află după caseta „Fă ecranul negru”.

Pentru a activa cortina ecranului de oriunde, atribuiți un gest personalizat în [dialogul gesturilor de intrare](#InputGestures).

##### Setări pentru ajutoarele vizuale ale unor terțe părți {#VisionSettingsThirdPartyVisualAids}

Furnizorii adiționali de îmbunătățire a vederii pot fi furnizați în [suplimentele NVDA](#AddonsManager).
Dacă acești furnizori au setări ajustabile, vor fi afișați în această categorie de setări în grupuri separate.
Pentru setările suportate per furnizor, vă rugăm să consultați documentația acelui furnizor.

#### Tastatură (NVDA+control+k) {#KeyboardSettings}

Această categorie de setări conține următoarele opțiuni:

##### Schemă tastatură {#KeyboardSettingsLayout}

Această listă de selecție vă lasă să alegeți ce tip de așezare a tastaturii ar trebui să folosească NVDA. În prezent, cele două care vin cu NVDA sunt schema pentru calculatoare de birou și schema pentru laptopuri.

##### Selectează tastele modificatoare ale NVDA {#KeyboardSettingsModifiers}

Casetele de bifat din această listă controlează tastele care pot fi folosite ca [taste modificatoare NVDA](#TheNVDAModifierKey). Mai jos vă sunt prezentate tastele disponibile din care puteți alege:

* Tasta caps lock
* Tasta insert de pe blocul numeric
* Tasta suplimentară de insert, găsită de obicei deasupra tastelor săgeată, lângă home și end

Dacă nicio tastă nu este aleasă ca tastă NVDA, accesarea anumitor comenzi NVDA poate fi cu neputință.
În consecință, dialogul NVDA va afișa un mesaj de eroare dacă toate tastele sunt neselectate la apăsarea butoanelor OK sau Se aplică.
După închiderea mesajului de eroare, trebuie să selectați cel puțin una înainte de a putea să apăsați OK ca să închideți dialogul cum trebuie.

<!-- KC:setting -->

##### Pronunță caracterele tastate {#KeyboardSettingsSpeakTypedCharacters}

Tastă: NVDA+2

Când e activat, NVDA va pronunța toate caracterele tastate.

<!-- KC:setting -->

##### Pronunță cuvintele tastate {#KeyboardSettingsSpeakTypedWords}

Tasta: NVDA+3

Când e activat, NVDA va pronunța toate cuvintele tastate.

##### Întrerupe vorbirea la tastarea de caractere {#KeyboardSettingsSpeechInteruptForCharacters}

Dacă e activată, această opțiune va face ca rostirea să fie întreruptă de fiecare dată când este tastat un caracter. Implicit este activată.

##### Întrerupe vorbirea la apăsarea Enter {#KeyboardSettingsSpeechInteruptForEnter}

Dacă e activată, această opțiune va face ca rostirea să fie întreruptă de fiecare dată când este apăsată tasta „Enter”. Implicit este activată.

##### Permite răsfoirea în modul de rostire completă {#KeyboardSettingsSkimReading}

Dacă e activată, anumite comenzi de navigare (cum ar fi navigare rapidă în mod navigare sau mutarea linie cu linie sau per paragraf) nu vor opri modul „Rostește tot”, ci va face ca modul „Rostește tot” să sară la noua poziție și să continue citirea.

##### Emite un bip la tastarea literelor mici dacă blocarea pe majuscule este activată {#VoiceSettingsBeepLowercase}

Când este activată, se va auzi un semnal sonor de avertizare dacă este tastată o combinație a tastei „Shift” cu o literă, iar blocarea pe majuscule („Caps Lock”) este activată.
În general, tastarea literelor cu shift și caps lock este neintenționată și, de obicei, motivul este nerealizarea faptului că tasta „Caps Lock” este activă.
De aceea, este destul de util să fiți avertizați în acest caz.

<!-- KC:setting -->

##### Pronunță tastele de comandă {#KeyboardSettingsSpeakCommandKeys}

Tastă: NVDA+4

Când e activat, NVDA va pronunța toate tastele necaractere tastate pe tastatură. Asta include combinații de taste cum ar fi Control plus altă literă.

##### Redare sunete pentru erorile de ortografie în timpul tastării {#KeyboardSettingsAlertForSpellingErrors}

Când este activată opțiunea, se emite un scurt sunet de alertă atunci când cuvântul tastat conține o eroare de ortografie. 
Această opțiune este disponibilă doar dacă raportarea erorilor de ortografie este activată în fereastra de dialog NVDA pentru [setările formatării documentului](#FormatareDocument), găsite în dialogul setărilor NVDA.

##### Tratează taste din alte aplicații {#KeyboardSettingsHandleKeys}

Această opțiune permite utilizatorului să controleze dacă apăsările de tastă generate de aplicații, cum ar fi tastaturi pe ecran și aplicații de recunoaștere a vorbirii, ar trebui să fie procesate de NVDA. 
Opțiunea este activată implcit, deși anumiți utilizatori vor dori să o dezactiveze, cum ar fi cei care tastează în Vietnameză cu software-ul de tastare UniKey, pentru care se vor produce intrări de caractere incorecte.

#### Maus (NVDA+control+m) {#OptiuniMaus}

Categoria „Maus„ din dialogul setărilor NVDA conține următoarele opțiuni:

##### Anunță schimbările formei cursorului {#MouseSettingsShape}

O casetă de bifat, care, atunci când este bifată înseamnă că NVDA va anunța forma cursorului mausului de fiecare dată când se schimbă.
Cursorul mausului în Windows își schimbă forma pentru a transmite informații ca de exemplu că ceva este editabil sau când ceva se încarcă, etc.

<!-- KC:setting -->

##### Activează urmărirea mausului {#MouseSettingsTracking}

Tastă: NVDA+m

Când e activat, NVDA va anunța textul aflat curent sub cursorul mausului, pe măsură ce îl mișcați pe ecran. Asta vă permite să găsiți obiecte pe ecran mișcând fizic mausul în loc să încercați să le găsiți navigând prin obiecte.

##### Rezoluția unității de text {#MouseSettingsTextUnit}

Dacă NVDA este setat să anunțe textul de sub cursorul mausului pe măsură ce îl mișcați, această opțiune vă permite să alegeți exact cât din text va fi pronunțat.
Opțiunile sunt caracter, cuvânt, rând sau paragraf.

##### Anunță rolul obiectului când mausul intră în el {#MouseSettingsRole}

Dacă este bifată această casetă, NVDA va anunța rolul (tipul) obiectului când cursorul mausului intră în el.

##### Redă audio coordonatele mausului când se mișcă {#MouseSettingsAudio}

Bifând această casetă, NVDA va emite semnale sonore la mișcarea mausului, pentru ca utilizatorul să-și dea seama unde se află cursorul mausului raportat la dimensiunile ecranului.
Cu cât cursorul mausului se află mai sus pe ecran, cu atât amplitudinea semnalelor sonore va fi mai mare.
Cu cât cursorul se află mai în extremitățile ecranului (stânga sau dreapta), cu atât sunetul va fi redat mai la stânga sau mai la dreapta (presupunând că utilizatorul are boxe stereo sau căști audio).

##### Luminozitatea controlează volumul coordonatelor audio {#MouseSettingsBrightness}

Dacă este bifată caseta „Redă audio coordonatele mausului când se mișcă”, atunci bifarea acestei casete înseamnă că volumul semnalelor audio pentru coordonate este controlat de cât de luminos este ecranul sub cursorul mausului.
Aceasta este dezactivată implicit.

#### interacțiune tactilă {#Interactiune_Tactila}

Această categorie de setări, disponibilă doar pentru calculatoarele care rulează Windows 8 sau mai nou cu capabilități de atingere, vă permite să configurați modul în care NVDA interacționează cu ecranele tactile.

##### Modul de scriere tactilă {#TouchTypingMode}

Această casetă de bifat vă permite să specificați metoda pe care doriți să o utilizați la inserarea textului folosind tastatura tactilă.
Dacă e bifată, când localizați o tastă pe tastatură, puteți ridica degetul și tasta selectată va fi apăsată.
Dacă e nebifată, atunci va trebui să atingeți de două ori tasta pentru a o apăsa.

#### Cursor de examinare {#ReviewCursorSettings}

Această categorie conține următoarele opțiuni:

<!-- KC:setting -->

##### Urmărește focalizarea sistemului {#ReviewCursorFollowFocus}

Tastă: NVDA+7

Când este activată, cursorul de examinare va fi poziționat întotdeauna în același obiect ca focalizarea curentă a sistemului, pe măsură ce aceasta se schimbă.

<!-- KC:setting -->

##### Urmărește cursorul de scriere {#ReviewCursorFollowCaret}

Tastă: NVDA+6

Când este activată, cursorul de examinare va fi mutat automat la poziția cursorului de scriere al sistemului, de fiecare dată când se mișcă.

##### Urmărește cursorul mausului {#ReviewCursorFollowMouse}

Când este activată, cursorul de examinare va urmări mausul pe măsură ce se mișcă.

##### Mod de examinare simplă {#ReviewCursorSimple}

Când este activată, NVDA va filtra ierarhia obiectelor care pot fi navigate, pentru a exclude orice obiecte ce nu sunt interesante pentru utilizator; de ex. obiecte invizibile și obiecte folosite doar pentru aspect.

Pentru a activa modul de examinare simplă de oriunde, definiți un gest personalizat, folosind [dialogul cu Gesturi de Intrare](#GesturiIntrare).

#### Prezentare obiect (NVDA+control+o) {#ObjectPresentationSettings}

Această categorie conține următoarele opțiuni:

##### Anunță informații instrument {#ObjectPresentationReportToolTips}

O casetă care, când este bifată, instruiește NVDA să anunțe indiciile pentru instrumente când apar. 
Multe controale pentru Windows afișează un mic mesaj (sau indiciu pentru instrument) când mișcați mausul deasupra lor, sau uneori când mutați focalizarea pe ele.

##### Anunță baloane de ajutor {#ObjectPresentationReportBalloons}

Această casetă, când este bifată, instruiește NVDA să anunțe baloanele de ajutor când apar. 
Baloanele de ajutor sunt ca indiciile pentru instrumente, dar de obicei au dimensiuni mai mari și sunt asociate cu evenimente de sistem cum ar fi un cablu de rețea deconectat sau poate o alertă despre probleme de securitate ale Windows.

##### Anunță tastele scurtătură ale obiectului {#ObjectPresentationShortcutKeys}

Când este bifată această casetă, NVDA va include și scurtătura din taste asociată cu un anumit obiect sau control când acesta este anunțat.
De exemplu, meniul Fișier dintr-o bară de meniu poate avea o scurtătură din taste pe Alt+f.

##### Raportează informația despre poziția obiectului {#ObjectPresentationPositionInfo}

Această opțiune vă lasă să alegeți dacă doriți ca poziția unui obiect (de exemplu 1 din 4) să fie raportată când treceți la obiect cu navigarea prin focalizare sau obiect.

##### Intuiește informația despre poziția obiectului când este indisponibilă {#ObjectPresentationGuessPositionInfo}

Dacă anunțul poziției obiectului este activat, această opțiune permite NVDA să ghicească/intuiască informația despre poziția obiectului, pentru un anumit control, când este indisponibilă altfel.

Când este activă, NVDA va anunța informații despre poziție pentru mai multe obiecte control, cum ar fi meniuri și bare de instrumente; cu toate acestea informația poate fi ușor inexactă.

##### Anunță descrierile obiectului {#ObjectPresentationReportDescriptions}

Debifați această casetă dacă considerați că nu aveți nevoie să auziți descrierea anunțată alături de obiecte (e.x. sugestiile căutării, raportarea întregii ferestre de dialog chiar după ce dialogul se deschide, etc.).

<!-- KC:setting -->

##### Tip de anunț pentru bara de progres {#ObjectPresentationProgressBarOutput}

Tastă: NVDA+u

Această opțiune controlează cum raportează NVDA modificările barei de progres.

Are următoarele opțiuni:

* dezactivat: Modificările barelor de progres nu vor fi anunțate.
* Vorbește: Această opțiune instruiește NVDA să pronunțe procentajul barei de progres. La fiecare modificare a barei de progres, NVDA va anunța noua valoare.
* Bip: Instruiește NVDA să emită un semnal sonor de fiecare dată când bara de progres se modifică. Cu cât mai înalt este semnalul sonor, cu atât mai aproape de completare se află bara de progres.
* Vorbește și emite bip: Această opțiune instruiește NVDA să emită și semnal sonor și să pronunțe modificările barei de progres.

##### Anunță barele de progres din fundal {#ObjectPresentationReportBackgroundProgressBars}

Aceasta este o opțiune care, când este bifată, instruiește NVDA să continue să raporteze o bară de progres chiar dacă nu se află în prim-plan.
Dacă minimizați o fereastră care conține bara de progres sau mutați focalizarea pe alta, NVDA va urmări în continuare progresul barei, permințându-vă să faceți alte lucruri în timp ce NVDA monitorizează o monitorizează.

<!-- KC:setting -->

##### Anunță schimbările dinamice de conținut {#ObjectPresentationReportDynamicContent}

Tastă: NVDA+5

Activează anunțurile de conținut nou în obiecte specifice cum ar fi ferestre terminal de comandă și controlul istoricului în programele de conversație.

##### Redă un sunet când apar autosugestiile {#ObjectPresentationSuggestionSounds}

Activează anunțarea aspectului autosugestiilor, iar dacă e activat, NVDA va reda un sunet pentru a indica asta.
Autosugestiile sunt liste ale intrărilor sugerate bazate pe text introdus în anumite câmpuri de editare și documente.
De exemplu, când introduceți un text în caseta de căutare a meniului Start din Windows Vista sau mai nou, Windows-ul afișează o listă a sugestiilor bazate pe ce ați tastat.
Pentru unele câmpuri de editare, cum ar fi câmpuri de căutare în diferite aplicații pentru Windows 10, NVDA vă poate notifica că a apărut o listă a sugestiilor când tastați un text.
Lista de autosugestii se va închide odată ce vă deplasați din câmpul de editare, iar pentru unele câmpuri, NVDA vă poate notifica când se întâmplă acest lucru.

#### Compunere intrări {#InputCompositionSettings}

Această categorie de setări vă permite să controlați modul în care NVDA anunță intrările de caractere asiatice, cum ar fi folosind IME sau metode de scriere „Text Service”.
De notat că, datorită faptului că metodele de introducere variază foarte mult în ceea ce privește funcționalitățile disponibile sau cum este prezentată informația, va fi necesar, cel mai probabil, să configurați diferit aceste opțiuni pentru fiecare metodă de introducere, pentru a obține cea mai eficientă formă de tastat.

##### Anunță automat toți candidații disponibili {#InputCompositionReportAllCandidates}

Această opțiune, care este implicit activată, vă permite să alegeți dacă toți candidații disponibili ar trebui sau nu să fie anunțați automat la apariția unei liste de candidați sau când pagina listei s-a modificat.
Este utilă activarea acestei opțiuni pentru metode de introducere pictografice precum Noul ChangJie sau Boshiami chinezești, deoarece puteți auzi automat toate simbolurile și numărul lor și puteți alege unul imediat. 
Cu toate acestea, pentru metode de intrare fonetice cum ar fi Fonetica nouă chinezească, s-ar putea să fie mai util să dezactivați această opțiune, deoarece toate simbolurile vor suna la fel și va trebui să folosiți tastele săgeată pentru a explora elementele listei, în mod individual, pentru a găsi mai multe informații din descrierile de caracter pentru fiecare candidat.

##### Anunță candidatul selectat {#InputCompositionAnnounceSelectedCandidate}

Această opțiune, care este implicit activată, vă permite să alegeți dacă NVDA ar trebui să anunțe candidatul selectat la apariția unei liste de candidați sau când selecția s-a modificat.
Pentru metode de introducere unde selecția poate fi schimbată prin tastele săgeată (cum ar fi Noua fonetică chinezească) aceasta este necesară, dar pentru anumite metode de introducere ar putea fi mai eficient să tastați cu această opțiune dezactivată.
De notat că și cu opțiunea dezactivată, cursorul de examinare va fi plasat în continuare pe candidatul selectat, permițându-vă să folosiți navigarea cu obiecte sau examinare pentru a citi manual candidatul curent sau alți candidați.

##### Include întotdeauna scurte descrieri de caracter când se anunță candidații {#InputCompositionCandidateIncludesShortCharacterDescription}

Această opțiune, care este implicit activată, vă permite să alegeți dacă NVDA ar trebui să furnizeze o scurtă descriere pentru fiecare caracter al candidatului, fie când este selectat fie când este citit automat când apare lista cu candidați.
De notat că pentru localizări precum chineză, anunțul descrierilor suplimentare de caracter pentru candidatul selectat nu este influențat de această opțiune.
Această opțiune poate fi folositoare pentru metodele de introducere coreeană și japoneză.

##### Raportează schimbări ale șirului de citire {#InputCompositionReadingStringChanges}

Anumite metode de introducere ca Noul Fonetic și ChangJie chinezești au un șir de citire (cunoscut uneori ca sir de precompoziție).
Puteți alege dacă NVDA ar trebui sau nu să anunțe caractere noi care sunt tastate în acest șir de citire, folosind această opțiune.
Opțiunea este activă implicit.
De notat că anumite metode de introducere mai vechi, cum ar fi ChangJie chinezesc, ar putea să nu folosească șirul de citire pentru a ține caractere de precompoziție, ci, în schimb să folosească direct șirul de compoziție. Vă rugăm să inspectați următoarea opțiune pentru configurarea anunțurilor pentru șirul de compoziție.

##### Raportează schimbări ale șirului de compoziție {#InputCompositionCompositionStringChanges}

După ce informațiile de citire sau precompoziție au fost combinate într-un simbol pictografic, majoritatea metodelor de introducere pun acest simbol într-un șir de compoziție pentru stocare temporară împreună cu alte simboluri combinate, înainte de a fi introduse în document.
Această opțiune vă permite să alegeți dacă NVDA ar trebui sau nu să raporteze simboluri noi pe măsură ce apar în șirul de compoziție.
Opțiunea este activată implicit. 

#### Mod de navigare (NVDA+control+b) {#BrowseModeSettings}

Această categorie conține următoarele opțiuni:

##### Număr maxim de caractere pe un singur rând {#BrowseModeSettingsMaxLength}

Acest câmp stabilește lungimea maximă a unui rând în modul navigare (în număr de caractere).

##### Număr maxim de rânduri per pagină {#BrowseModeSettingsPageLines}

Acest câmp stabilește numărul de rânduri deplasate când apăsați Page Up sau Page Down când vă aflați în mod navigare.

<!-- KC:setting -->

##### Folosește aspectul ecranului {#BrowseModeSettingsScreenLayout}

Tastă: NVDA+v

Această opțiune vă permite să specificați dacă conținutul din modul navigare ar trebui să pună câmpuri de tip legătură și alte câmpuri pe un rând propriu, sau dacă să le păstreze în corpul textului așa cum este prezentat vizual.
Dacă opțiunea aceasta este activată, atunci obiectele vor rămâne așa cum sunt prezentate, dar dacă este dezactivată, câmpurile vor fi puse pe propriul lor rând.

##### Activează modul de navigare la încărcarea paginii {#BrowseModeSettingsEnableOnPageLoad}

Această casetă de bifat reprezintă setarea prin care modul de navigare se activează automat sau nu la încărcarea unei pagini.
Dacă setarea este inactivă, modul de nabigare poate fi activat manual în pagini sau în documente în care acesta este suportat.
Consultați [secțiunea modului de navigare](#BrowseMode) pentru o listă a aplicațiilor suportate de acesta.
Țineți cont de faptul că această opțiune nu se aplică în situația în care modul de navigare este întotdeauna opțional, un bun exemplu fiind Microsoft Word.
Această setare este activă în mod implicit

##### „Rostește tot” automat la încărcarea paginii {#BrowseModeSettingsAutoSayAll}

Această casetă de bifat activează citirea automată a întregii pagini după ce a fost încărcată în modul navigare.
Opțiunea este activată implicit.

##### Include tabelele de aspect {#BrowseModeSettingsIncludeLayoutTables}

Această opțiune influențează modul cum tratează NVDA tabelele folosite doar pentru prezentare.
Când e activată, NVDA le va trata ca pe niște tabele normale, anunțându-le în funcție de [setările formatării documentului](#FormatareDocument) și le va localiza cu comenzi de navigare rapidă.
Când este dezactivată, nu vor fi anunțate și nici descoperite cu navigarea rapidă.
Cu toate acestea, conținutul tabelelor va fi inclus în continuare ca text normal.
Opțiunea este dezactivată implicit.

+Pentru a comuta la includerea tabelelor de aspect de oriunde, vă rugăm să atribuiți un gest personalizat folosind [dialogul gesturilor de intrare](#GesturiIntrare).

##### Configurarea anunțării câmpurilor de tipul legăturilor sau rubricilor {#BrowseModeLinksAndHeadings}

Vă rugăm citiți opțiunea din categoria [Setărilor formatării documentului](#DocumentFormattingSettings) din [Dialogul setărilor NVDA](#NVDASettings) pentru a configura câmpurile anunțate în timpul navigării, precum legături, rubrici sau tabele.

##### Mod formular automat pentru schimbările de focalizare {#BrowseModeSettingsAutoPassThroughOnFocusChange}

Această opțiune permite invocarea modului formular dacă se schimbă focalizarea.
De exemplu, când sunteți într-o pagină web, dacă apăsați Tab și ajungeți la un formular, dacă această opțiune este activată, modul formular va fi invocat automat.

##### Mod formular automat pentru mișcarea cursorului de scriere {#BrowseModeSettingsAutoPassThroughOnCaretMove}

Această opțiune, când este bifată, permite NVDA să intre și să iasă din modul formular când se folosesc tastele direcționale.
De exemplu, dacă coborâți cu săgeată jos pe o pagină web și ajungeți la o casetă de editare, NVDA vă va trece automat în modul formular. Dacă ieșiți din caseta de editare cu o tastă direcțională, NVDA vă va trece înapoi în modul de căutare.

##### Semnal audio pentru modurile formular și navigare {#BrowseModeSettingsPassThroughAudioIndication}

Dacă este activată această opțiune, NVDA va emite sunete speciale când mută între modul de căutare și modul formular, în loc să pronunțe schimbarea.

##### Împiedică trimiterea către document a tuturor gesturilor neatribuite unei comenzi {#BrowseModeSettingsTrapNonCommandGestures}

Activată implicit, această opțiune vă permite să alegeți dacă gesturile (cum ar fi apăsări de tastă) care nu rezultă într-o comandă NVDA și nici nu sunt considerate o tastă de comandă generică, ar trebui împiedicate să ajungă la documentul pe care vă aflați momentan.
Spre exemplu, dacă opțiunea este activată și dacă litera j ar fi apăsată, aceasta ar fi blocată de a ajunge la document, chiar dacă nu este o comandă de navigarea rapidă și nici nu e probabil să fie o comandă pentru aplicația însăși.

#### Formatare document (NVDA+control+d) {#DocumentFormattingSettings}

Majoritatea casetelor de bifat din această categorie sunt pentru a configura ce tip de formatare doriți să auziți automat când mișcați cursorul prin documente.
De exemplu, dacă bifați caseta pentru raportarea numelui fontului, de fiecare dată când ajungeți la un text cu un font diferit, numele fontului va fi anunțat.

Opțiunile de formatare a documentului sunt organizate pe grupuri.
Puteți configura anunțarea pentru:

* Font
 * Nume font
 * Dimensiune font
 * Atribute font
 * Superscripturi și subscripturi
 * Accentuare
 * Stil
 * Culori
* Informații document
 * Comentarii
 * Revizii de editor
 * Greșeli de ortografie
* Pagini și spațiere
 * Număr de pagină
 * Număr de rând
 * Raportarea indentației de rând [(dezactivat, vorbire, tonuri, atât vorbire cât și tonuri)](#FormatDocumentSetariIndentatieRand)
 * Indentație paragraf (de ex. negativă, a primului rând)
 * Spațiere între linii (simplă, dublă, etc)
 * Aliniere
* Informații despre tabele
 * Tabele
 * Anteturi rânduri/coloane
 * Coordonatele celulei
 * Marginile celulei (dezactivate, stiluri, atât culori cât și stiluri)
* Elemente
 * Rubrici
 * Legături
 * Liste
 * Citate bloc
 * Repere
 * Cadre
 * Când se poate face clic pe ceva

Pentru activarea acestor opțiuni de oriunde, vă rugăm să atribuiți gesturi personalizate din [fereastra de dialog pentru Gesturi de intrare](#GesturiIntrare).

##### Raportează schimbări de formatare după cursor {#DocumentFormattingDetectFormatAfterCursor}

Dacă este activată, această setare va instrui NVDA să încerce să detecteze toate schimbările de formatare de pe un rând pe măsură ce-l anunță, chiar dacă făcând asta ar putea slăbi performanța NVDA.

Implicit, NVDA va detecta formatarea de la poziția cursorului sistemului sau a cursorului de examinare, și în unele situații poate detecta formatarea de pe restul rândului, doar dacă nu va provoca o încetinire în rularea NVDA.

Activând această opțiune, NVDA va corecta documentele din aplicații precum WordPad, unde formatarea este importantă.

##### Anunță indentație rând {#FormatDocumentSetariIndentatieRand}

Această opțiune vă permite să configurați cum se face raportarea indentației la început de rând.
Caseta combinată pentru opțiunea de anunț a indentației are patru variante.

* Dezactivat: NVDA nu va trata în mod special indentația.
* Vorbire: Dacă este selectată opțiunea, când indentația se modifică, NVDA va anunța dimensiunea în genul „douăsprezece spații” sau „patru taburi”.
* Tonuri: Dacă este selectată această opțiune, când indentația se modifică, va fi anunțată prin sunete graduale.
Sunetul își va mări amplitudinea cu fiecare spațiu adăugat, iar pentru un tab își va mări amplitudinea cu echivalentul a 4 caractere spațiu.
* Atât vorbire cât și tonuri: Această opțiune semnalează indentația folosind ambele metode de mai sus.

#### Setări Windows 10 OCR {#SetariWin10Ocr}

 Setările din această categorie vă permit configurarea [Windows 10 OCR](#Win10Ocr).

##### Limba de recunoaștere {#Win10OcrSettingsRecognitionLanguage}

Această casetă combinată vă permite alegerea limbii care va fi folosită pentru recunoașterea de text.

#### Setări Avansate {#AdvancedSettings}

Atenție! Setările din această categorie sunt pentru utilizatorii experimentați și pot face ca NVDA să nu meargă cum trebuie dacă este configurat greșit.
Faceți modificări la aceste setări numai dacă sunteți sigur că știți ceea ce faceți sau dacă ați fost îndrumat de un dezvoltator NVDA.

##### Efectuarea modificărilor la setările avansate {#AdvancedSettingsMakingChanges}

Ca să faceți modificări la setările avansate, controalele trebuie să fie activate prin confirmarea, cu caseta de bifat, a faptului că înțelegeți riscurile modificării acestor setări.

##### Restaurarea setărilor implicite {#AdvancedSettingsRestoringDefaults}

Butonul restaurează valorile implicite ale setărilor, chiar dacă caseta de confirmare nu este activată.
După modificarea setărilor, s-ar putea să vă doriți să reveniți la valorile implicite.
De asemenea, acesta poate fi cazul în care nu sunteți sigur că setările au fost modificate.

##### Activează încărcarea codului personalizat din directorul Scratchpad pentru Dezvoltatori {#AdvancedSettingsEnableScratchpad}

Când dezvoltați suplimente pentru NVDA, vă este util să testați codul, întrucât îl scrieți.
Când e activată, această opțiune îi permite NVDA-ului să încarce appModule-uri personalizate, globalPlugin-uri, brailleDisplayDrivere și synthDrivere, dintr-un folder special Scratchpad pentru dezvoltatori în cel al configurației de utilizator NVDA.
Înainte, NVDA încărca codul personalizat direct din dosarul configurației utilizatorului NVDA fără niciun mod în care asta să poată fi dezactivată.
Această opțiune este inactivă în mod implicit pentru siguranța faptului că niciun cod netestat nu rulează în NVDA fără înștiințarea utilizatorului.
Dacă doriți să distribuiți cod personalizat altora, trebuie să-l împachetați într-un supliment NVDA.

##### Deschide dosarul Scratchpad pentru Dezvoltatori {#AdvancedSettingsOpenScratchpadDir}

Acest buton deschide dosarul în care vă puteți pune codul personalizat cât timp lucrați la el.
El este activat doar dacă NVDA este setat să activeze încărcarea codului personalizat din directorul Scratchpad pentru Dezvoltatori.

##### Utilizează UI automation pentru a accesa controalele de document Microsoft Word când sunt disponibile {#AdvancedSettingsUseUiaForWord}

Când această opțiune este activată, NVDA va încerca să utilizeze API-ul de accesibilitate Microsoft UI Automation pentru a obține informații de la controalele de document Microsoft Word.
Este inclus însuși Microsoft Word, vizualizatorul și compozitorul de mesaje Microsoft Outlook.
Pentru versiunile cele mai recente ale Microsoft Office 2016/365 care rulează pe Windows 10, suportul UI Automation este suficient de capabil încât să ofere accesul la documentele Microsoft Word în mod aproape egal în care o face suportul NVDA pentru Microsoft Word, adăugând avantajul capacității de reacție, îmbunătățită semnificativ.
Cu toate acestea, pot exista informații care să nu fie expuse sau expuse incorect, în cel mai bun caz, în unele versiuni ale Microsoft Office, ceea ce înseamnă că acest suport UI automation nu poate fi întotdeauna fiabil.
Încă nu recomandăm majorității utilizatorilor s-o activeze în mod implicit, deși îi invităm pe cei ai Office 2016/365 să o testeze și să ne ofere o recenzie.

##### Suport pentru Consola Windows {#AdvancedSettingsConsoleUIA}

Această opțiune alege cum interacționează NVDA cu Consola Windows folosită de Linia de Comandă, PowerShell și de subsistemul Windows pentru Linux.
Nu afectează Terminalul modern Windows.
În Windows 10 versiunea 1709, [Microsoft a adăugat suportul pentru API-ul creat pentru Interfața Utilizatorului la consolă](https://devblogs.microsoft.com/commandline/whats-new-in-windows-console-in-windows-10-fall-creators-update/), îmbunătățind astfel într-un mod remarcabil performanța și stabilitatea pentru cititoarele de ecran care îl suportă.
Caseta combinată a suportului pentru Consola Windows are trei opțiuni:

* Automat: Utilizează UI Automation în consolele din Windows 10 (versiunea 1809 sau mai nouă).
* Prefer UIA: Utilizează UI Automation în console dacă sunt disponibile, chiar și pe versiuni de Windows cu implementări incomplete sau cu probleme. Cât timp această funcționalitate limitată poate fi de folos (și chiar suficientă pentru utilizarea dumneavoastră), prin utilizarea acesteia vă asumați eventualele riscuri și nu vi se va oferi suport pentru ea.
* Tradițional: Interfața Automată a Utilizatorului din Consola Windows va fi dezactivată complet și va fi utilizat în schimb și pentru totdeauna fallback-ul tradițional.

##### Spune parolele în Consola Windows {#AdvancedSettingsWinConsoleSpeakPasswords}

Această setare controlează dacă caracterele sunt pronunțate prin [pronunțarea caracterelor tastate](#KeyboardSettingsSpeakTypedCharacters) sau prin [pronunțarea cuvintelor tastate](#KeyboardSettingsSpeakTypedWords) în situația în care ecranul nu se actualizează (un bun exemplu fiind cazul în care se interacționează cu un câmp de parolă) în niște programe terminale precum Consola Windows cu suportul activat pentru UI Automation și pentru Mintty.
Din motive de securitate, această setare ar trebui să fie lăsată dezactivată.
Totuși, s-ar putea să vreți să o activați dacă întâmpinați probleme de performanță sau de instabilitate cu raportarea caracterului și/sau cuvântului tastat în console sau lucrați într-un mediu de încredere și preferați anunțarea parolei.

##### Utilizează suportul nou pentru caracterele tastate în Consola Windows dacă este disponibil {#AdvancedSettingsKeyboardSupportInLegacy}

Această opțiune activează o metodă alternativă pentru detectarea caracterelor tastate în consolele de comandă Windows.
Cât timp îmbunătățește performanța și împiedică niște ieșiri de consolă să fie silabisite, poate fi incompatibilă cu unele programe terminale.
Această caracteristică este disponibilă și activă în mod implicit în versiunea 1607  și în versiunile mai noi de Windows 10 atunci când UI Automation nu este disponibil sau este inactiv.
Atenție! Cu această opțiune activă, caracterele tastate care nu apar pe ecran precum parolele nu vor fi suprimate.
Într-un mediu de neîncredere, puteți dezactiva temporar [pronunțarea caracterelor tastate](#KeyboardSettingsSpeakTypedCharacters) și a [cuvintelor tastate](#KeyboardSettingsSpeakTypedWords) la tastarea de parole.

##### Setează automat focalizarea sistemului la elementele focalizabile din modul de navigare {#BrowseModeSettingsAutoFocusFocusableElements}

Tastă: NVDA+8

Activă în mod implicit, această opțiune vă dă posibilitatea de a decide dacă focalizarea sistemului ar trebui să fie setată automat la elemente care pot avea efecte asupra ei (link-uri, câmpuri formular, etcetera) la navigarea prin conținut cu cursorul modului de navigare. 
Dacă este activă, aceasta va reprezenta comportamentul implicit al NVDA din versiunea 2019.1 și din cele anterioare.
Dezactivarea acestei opțiuni nu va avea drept consecință focalizarea automată a elementelor focalizabile atunci când acestea sunt selectate cu cursorul modului de navigare.
Aceasta poate avea drept consecință o experiență de navigare mai rapidă și o reacție mai bună în modul de navigare.
Focalizarea va continua să se actualizeze la elementul particular atunci când se interacționează cu el (apăsarea unui buton și activarea unei casete de bifat pot fi luate ca exemplu).
Această funcționalitate este experimentală ca și NVDA 2019.2.

##### Timpul de expirare a deplasării cursorului de scriere al sistemului )în milisecunde) {#AdvancedSettingsCaretMoveTimeout}

Această opțiune vă permite să configurați numărul de milisecunde în care NVDA să aștepte ca cursorul de scriere (punct de inserare) să se deplaseze în câmpurile de editare.
Dacă observați că NVDA tinde să nu urmărească cum trebuie cursorul de scriere, de exemplu atunci când acesta rămâne mereu cu un caracter în urmă sau când repetă rânduri, este posibil să vreți să-i modificați valoarea.

##### Categoriile de diagnosticare la înregistrare {#AdvancedSettingsDebugLoggingCategories}

Casetele de bifat din această listă vă permit să activați categorii specifice ale mesajelor de diagnosticare din jurnalul NVDA.
Înregistrarea acestor mesaje poate duce la scăderea performanței și a fișierelor jurnal mari.
Activați una dintre aceste categorii numai dacă sunteți îndrumat de un dezvoltator NVDA atunci când, de exemplu, căutați răspunsul la întrebarea de ce un driver al unui afișaj braille nu merge cum trebuie.

### Setări diverse {#MiscSettings}

În afară de [Dialogul setărilor NVDA](#NVDASettings), submeniul Preferințe mai conține și alte câteva elemente care sunt prezentate mai jos.

#### Dicționare de vorbire {#SpeechDictionaries}

Meniul dicționarelor de vorbire (găsit în meniul „Preferințe”), conține ferestre de dialog care vă permit să alegeți modul în care NVDA pronunță anumite cuvinte sau fraze.
În prezent sunt trei tipuri diferite de dicționare de vorbire.
Acestea sunt:

* Implicit: regulile din acest dicționar afectează toate modurile de vorbire din NVDA.
* Vocal: regulile din acest dicționar afectează vorbirea pentru sintetizatorul de voce curent.
* Temporar: regulile din acest dicționar afectează toate modurile de vorbire din NVDA, dar numai pentru sesiunea curentă. Aceste reguli sunt temporare și vor fi pierdute dacă NVDA este repornit.

Dacă doriți să deschideți de oriunde aceste dialoguri pentru dicționare trebuie să-i atribuiți un gest personalizat folosind [fereastra de dialog pentru Gesturi de intrare](#GesturiIntrare).

Toate ferestrele de dialog pentru dicționare conțin o listă de reguli care vor fi folosite pentru procesarea vorbirii.
Fereastra de dialog conține și butoane pentru adăugare, editare și eliminare.

Pentru a adăuga o regulă nou în dicționar, apăsați butonul „Adaugă” și scrieți în câmpurile din fereastra de dialog care apare iar apoi apăsați OK.
Apoi veți vedea noua regulă în lista de reguli.
Totuși, pentru a vă asigura că lista este salvată, aveți grijă să apăsați OK pentru a ieși complet din fereastra de dialog pentru dicționar, odată ce ați terminat de adăugat/editat reguli.

Regulile pentru dicționarele de vorbire NVDA vă permit să schimbați un șir de caractere cu altul.
Un exemplu simplu ar fi să doriți ca NVDA să spună cuvântul „lucrat” de fiecare dată când ar trebui să spună „muncit”.
În fereastra de dialog pentru adăugarea unei reguli, modul cel mai simplu de a face asta este să scrieți cuvântul „muncit” în câmpul „Șablon”, și cuvântul „lucrat” în câmpul „Înlocuire”.
Ar fi bine să scrieți o descriere a regulii în câmpul „Comentariu” (ceva de genul: schimbă muncit în lucrat).

Dicționarele de vorbire NVDA sunt, însă, mult mai capabile decât  înlocuitoare de cuvinte.
Fereastra de dialog pentru adăugarea unei reguli conține și o casetă de bifat pentru a alege dacă doriți ca regula să aprecieze majusculele (adică NVDA să țină cont dacă literele sunt majuscule sau minuscule. 
NVDA ignoră implicit acest lucru).

În cele din urmă, un set de butoane rotative vă permite să specificați NVDA dacă șablonul dumneavoastră ar trebui să fie verificat peste tot, ar trebui să fie verificat doar dacă formează un cuvânt complet sau trebuie tratat ca o „Expresie regulată”.
Stabilirea șablonului să fie verificat în formă de cuvânt complet înseamnă că înlocuirea va fi făcută doar dacă șablonul nu este conținut într-un cuvânt mai mare; de exemplu: șablonul este încadrat de cele două caractere altele decât orice caracter alfanumeric (cifră sau literă), un caracter „liniuță joasă”, sau niciun caracter.
Astfel, folosind exemplul anterior de înlocuire a cuvântului „muncit” cu „lucrat”, dacă ar fi să faceți această înlocuire de cuvânt complet, regula nu ar verifica niciunul dintre cuvintele „muncitori” sau „nemuncit”.

O expresie regulată este un șablon care conține simboluri speciale care vă permit să faceți potrivirea mai generică decât caracter cu caracter, sau să verifice doar numere, sau doar litere, pentru a da niște exemple de bază.
Expresiile regulate nu sunt explicate în acest ghid, dar există multe documente de instruire disponibile pe internet care vă pot da mai multe informații.

#### Rostirea punctuației/simbolurilor {#SymbolPronunciation}

Această fereastră de dialog vă permite schimbarea modului de rostire a punctuației și a altor simboluri, precum și nivelul de simbol la care sunt rostite.

Limba, pentru care pronunția simbolurilor este editată, va fi pusă în titlul ferestrei de dialog.
De notat că această fereastră de dialog respectă opțiunea „Bazează-te pe limba vocii când se procesează caractere și simboluri” definită în [ Categoria vorbirii](#SpeechSettings), a [Dialogului de setări al NVDA #NVDASettings[. Adică folosește mai degrabă limba vocii decât configurația globală a NVDA privind limba, când această opțiune este activată.

Pentru a modifica un simbol, mai întâi selectați-l din Lista de simboluri.

* Câmpul „Înlocuire” vă permite să schimbați textul care va fi pronunțat în locul acestui simbol.
* Folosind câmpul „Nivel”, puteți ajusta cel mai scăzut nivel al simbolului la care acesta va fi pronunțat
* „Trimite simbolul efectiv la sintetizator” definește când va fi trimis la sintetizator simbolul în sine (în contrast cu textul ce îl înlocuiește).
Opțiunea este folositoare dacă simbolul face ca sintetizatorul să se întrerupă sau schimbă inflexiunea vocii.
De exemplu, o virgulă care provoacă o pauză a sintetizatorului.
Există trei variante:
 * niciodată: nu trimite niciodată simbolul propriu-zis la sintetizator. 
 * totdeauna: trimite de fiecare dată simbolul efectiv la sintetizator.
 * numai sub valoarea nivelului (simbolului): Trimite simbolul efectiv doar dacă nivelul de pronunție configurat aici pentru simbol este mai jos decât nivelul stabilit pentru simbol.
 De exemplu, ați putea folosi această opțiune astfel încât înlocuitorul său să fie pronunțat la niveluri mai înalte, fără pauză, iar simbolul efectiv să fie indicat printr-o pauză la niveluri mai joase.

Puteți adăuga simboluri noi prin apăsarea butonului „Adaugă”.
În fereastra de dialog care apare, introduceți simbolul și apăsați butonul OK.
Apoi modificați câmpurile noului simbol la fel cum ați face-o pentru alte simboluri.

Puteți elimina un simbol pe care l-ați adăugat anterior, apăsând butonul „Eliminare”.

Când ați terminat, apăsați butonul „OK” pentru a salva modificările sau butonul „Anulează” pentru a renunța la ele.

#### Gesturi de intrare {#GesturiIntrare}

În această fereastră de dialog puteți personaliza gesturile de intrare pentru comenzi NVDA (taste pe tastatură, butoane pe afișajul braille, etc.). 

Sunt afișate doar comenzile care se aplicau imediat înainte de deschiderea ferestrei.
De exemplu, dacă doriți să personalizați comenzi legate de modul navigare, ar trebui să deschideți dialogul pentru Gesturi de intrare cât sunteți în modul navigare.

Arborele de opțiuni din această fereastră afișează toate comenzile NVDA aplicabile, grupate pe categorie.
Le puteți filtra prin tastarea a unuia sau mai multor cuvinte corespunzătoare numelui comenzii, indiferent de ordine, în caseta de editare „Filtrează după”.
Orice gest asociat unei comenzi este afișat imediat sub comandă.

Pentru a adăuga un gest de intrare unei comenzi, selectați comanda și apăsați butonul „Adaugă”.
După aceasta, executați gestul de intrare pe care doriți să-l asociați; de ex apăsați o tastă pe tastatură sau un buton pe afișajul braille.
De multe ori, un gest poate fi interpretat în mai multe moduri.
De exemplu, dacă ați apăsat o tastă pe tastatură, poate veți dori să fie specifică formatului curent de tastatură (de ex de birou sau laptop) sau v-ați dori să fie aceeași pentru toate formatele.
În acest caz, va apărea un meniu care vă va permite să selectați opțiunea dorită.

Pentru a elimina un gest asociat unei comenzi, selectați gestul și apăsați butonul „Elimină”

Când ați terminat de făcut modificări, apăsați butonul „OK” pentru a le salva sau „Anulează” pentru a renunța la ele.

### Salvarea și reîncărcarea configurației {#SavingAndReloading}

Implicit, NVDA vă va salva automat preferințele la ieșire.
De notat, însă, că această opțiune poate fi schimbată din „Setări generale” ale meniului „Preferințe”
Pentru salvarea manuală a configurației în orice moment, alegeți elementul „Salvează configurare” din meniul NVDA.

Dacă faceți vreodată o greșeală cu setările dv. și aveți nevoie să reveniți la preferințele salvate, alegeți elementul „Revino la configurația salvată” din meniul NVDA.
De asemenea, puteți să reveniți la configurația inițială a aplicației, alegând opțiunea „Resetează la configurația inițială”, de asemenea din meniul NVDA.

Și următoarele comenzi NVDA din taste sunt utile:
<!-- KC:beginInclude -->

| Nume |Tastă desktop |Tastă laptop |Descriere|
|---|---|---|---|
|Salvează configurație |NVDA+control+c |NVDA+control+c |Salvează configurația dv. curentă pentru a nu fi pierdută când închideți NVDA|
|Revino la configurația salvată |NVDA+control+r |NVDA+control+r |Apăsând o dată, reface setările NVDA care existau când ați salvat ultima dată configurația NVDA. Apăsând de trei, va reveni la configurația inițială a aplicației.|

<!-- KC:endInclude -->

### Configurarea profilurilor {#ConfigurationProfiles}

Vă veți dori, uneori, să aveți configurări diferite în diverse situații.
De exemplu se poate să vă doriți să aveți activat anunțul indentațiilor când editați, sau anunțul atributelor de font când faceți o citire de verificare.
NVDA vă permite asta prin folosirea configurării de profiluri.

Un profil de configurare conține doar acele opțiuni care sunt schimbate în timp ce profilul este modificat.
Majoritatea opțiunilor pot fi modificate în configurarea profilurilor, mai puțin cele din categoria „General” a [dialogului setărilor NVDA](#NVDASettings), care sunt aplicate pentru întreaga aplicație NVDA.

Profilurile configurate pot fi activate manual și dintr-o fereastră de dialog, și folosindu-se gesturi personalizate adăugate.
De asemenea, pot fi și activate automat pentru acțiuni ca schimbarea la o aplicație anume.

#### Idei fundamentale de administrare {#ProfilesBasicManagement}

Gestionați profilurile configurate prin selectarea opțiunii „Configurarea profilurilor...” din meniul NVDA.
Puteți folosi, de asemenea și o tastă de comandă:
<!-- KC:beginInclude -->

* NVDA+control+p: Arată fereastra de dialog a Configurării profilurilor

<!-- KC:endInclude -->

Primul element de selecție în această fereastră este lista de profiluri din care puteți selecta unul dintre profilurile disponibile.
Când deschideți fereastra, profilul selectat este cel pe care îl modificați în acel moment.
Sunt arătate și informații adiționale pentru profilurile active, indicând dacă sunt activate manual, declanșate și/sau în curs de editare.

Pentru a redenumi sau șterge un profil, apăsați butonul „Redenumește” respectiv „Șterge”.

Apăsați butonul „Închide” pentru a închide fereastra.

#### Crearea unui profil {#ProfilesCreating}

Pentru a crea un profil apăsați butonul „Nou”.

În fereastra „Profil nou” puteți introduce un nume pentru profil.
Puteți, de asemenea, să alegeți cum va fi folosit acest profil.
Dacă doriți să folosiți acest profil doar manual, alegeți „Activare manuală” care este și selecția implicită.
Altfel, alegeți un declanșator care ar trebui să activeze automat acest profil.
Pentru comoditate, dacă nu ați introdus un nume pentru acest profil, selectarea unui declanșator va adăuga un nume corespunzător.
Vedeți [mai jos](#ConfigDeclansatoareProfil) pentru mai multe informații despre declanșatoare.

Apăsarea butonului „OK” va crea acest profil și va închide fereastra Profile de configurare pentru ca să îl puteți edita.

#### Activarea manuală {#ConfigProfilManual}

Puteți activa manual un profil, selectându-l și apăsând butonul „Activează manual”.
Odată activat, și alte profile pot fi activate datorită declanșatoarelor, dar orice opțiune a profilului activat manual va prevala.
De exemplu, dacă un profil este declanșat de aplicația curentă și raportarea legăturilor este activată în acel profil dar dezactivată în profilul activat manual, atunci legăturile nu vor fi anunțate.
Cu toate acestea, dacă ați schimbat vocea în profilul declanșat dar nu ați schimbat-o în cel activat manual, vocea din profilul declanșat va fi folosită.
Orice preferință schimbată de dumneavoastră va fi salvată în profilul activat manual. 
Pentru a dezactiva un profil activat manual, selectați-l din fereastra „Configurarea profilurilor” și apăsați butonul „Dezactivează manual”.

#### Declanșatoare {#ConfigDeclansatoareProfil}

Apăsând butonul „Declanșatoare...” din fereastra „Configurarea profilurilor” vă permite să schimbați profilurile care ar trebui să fie activate automat de diferite declanșatoare.

Lista declanșatoarelor le prezintă pe cele disponibile, care sunt după cum urmează:

* Aplicația curentă: Declanșat când schimbați pe aplicația curentă.
* Rostește tot: Declanșat în timpul citirii cu comanda „Rostește tot”.

Pentru a schimba profilul care ar trebui activat automat de un declanșator, selectați declanșatorul și apoi profilul dorit din Lista de profiluri.
Puteți alege „(configurație normală)” dacă nu doriți folosirea unui profil.

Apăsați butonul „Închide” pentru a reveni la fereastra „Configurarea profilurilor”.

#### Modificarea unui profil {#ConfigProfileEditing}

Dacă ați activat manual un profil, orice opțiune pe care o modificați va fi salvată în acel profil.
Altfel orice opțiune pe care o modificați va fi salvată în cel mai recent profil declanșat.
De exemplu, dacă ați asociat un profil cu aplicația „Notepad” și deschideți Notepad, orice opțiune schimbată va fi salvată în acle profil.
În cele din urmă, dacă nu există nici profil activat manual, nici profil declanșat, orice opțiune pe care o modificați va fi salvată în configurația normală.

Pentru a edita profilul asociat cu Rostește tot, trebuie să [activați manual](#ConfigProfilManual) acel profil.

#### Dezactivarea temporară a declanșatoarelor {#ConfigProfileDisablingTriggers}

Uneori este util să dezactivați temporar declanșatoarele.
De exemplu, v-ati putea dori să modificați un profil activat manual sau configurația normală fără ca profilurile declanșate să intervină.
Puteți face asta bifând opțiunea „Dezactivează temporar toate declanșatoarele” din fereastra Profilelor de configurare.

#### Activarea unui profil cu ajutorul utilizării gesturilor de intrare {#ConfigProfileGestures}

Puteți să atribuiți fiecărui profil pe care îl adăugați unul sau mai multe gesturi de intrare pentru a-l activa.
Configurarea profilurilor nu are gesturi atribuite în mod implicit.
Puteți adăuga gesturi pentru a activa un profil din dialogul [Gesturi de intrare](#InputGestures).
Fiecare profil are propria intrare sub categoria de configurare a profilurilor.
Dacă veți redenumi un profil, orice gest pe care l-ați adăugat înainte va fi disponibil.
Ștergerea unui profil va duce evident și la ștergerea gestului asociat cu el.

### Locația fișierelor de configurație {#LocationOfConfigurationFiles}

Versiunile portabile NVDA păstrează toate setările și suplimentele specifice într-un dosar numit „userConfig” din dosarul de bază al NVDA.

Versiunile instalate ale NVDA păstrează toate setările specifice și suplimentele într-un dosar special al NVDA localizat în profilul dumneavoastră de Windows.
Semnificația este aceea că fiecare utilizator al sistemului dumneavoastră poate avea propria configurație a NVDA.
Pentru a ajunge la dosarul dumneavoastră cu setări pentru o versiune instalată a NVDA, din meniul de Start accesați Programe -> NVDA -> Explorează dosarul NVDA pentru configurație utilizator.

Setările NVDA pentru rularea pe ecranul de autentificare sau ecrane UAC sunt păstrate în dosarul „systemConfig” din dosarul de instalare NVDA.
De obicei, această configurație nu trebuie atinsă.
Pentru a schimba configurația NVDA la ecranul de autentificare sau alte ecrane UAC, configurați NVDA după cum doriți cât sunteți autentificat în Windows, salvați configurația și apăsați butonul „Folosește preferințele curent salvate asupra ecranului de autentificare și a altor ecrane securizate” din categoria „General” a [Dialogului setărilor NVDA](#NVDASettings).

## Alte instrumente {#ExtraTools}
### Afișarea jurnalului {#LogViewer}

Afișarea jurnalului, opțiune aflată la lista de „Instrumente”, în meniul NVDA, vă permite să vedeți toate informațiile salvate în jurnal, de când ați pornit ultima dată NVDA până acum.

În afară de citirea conținutului, puteți să și salvați o copie a fișierului jurnalului, sau împrospătați afișarea jurnalului pentru a arăta cea mai recentă informație de când a fost deschis jurnalul.
Aceste acțiuni sunt disponibile din meniul ferestrei Monitorului de jurnale.

### Monitorul de vorbire {#SpeechViewer}

Pentru programatorii văzători sau persoanele care prezintă NVDA unui public văzător, este disponibilă o fereastră mobilă care vă permite să vedeți tot textul vorbit de NVDA în momentul respectiv.

Pentru a activa monitorul de vorbire, bifați elementul „Monitor vorbire” din Instrumente, în meniul NVDA.
Debifați acest element pentru a-l dezactiva.

Fereastra monitorului de vorbire conține o căsuță de bifat cu eticheta „Arată monitorul de vorbire la pornire”.
Dacă aceasta este bifată, monitorul de vorbire se va deschide la pornirea NVDA.
Fereastra monitorului de vorbire va încerca întotdeauna să se redeschidă cu aceleași dimensiuni și la aceeași locație ca la pornirea anterioară.

Cât timp monitorul de vorbire este activ, se actualizează constant pentru a vă arăta cât mai mult text vorbit în momentul respectiv.
Totuși, dacă faceți clic sau focalizați în ecranul de vorbire, NVDA va opri temporar actualizarea textului, pentru ca dv. să puteți selecta sau copia cu ușurință conținutul existent.

Pentru a activa monitorul de vorbire de oriunde, trebuie să-i atribuiți un gest personalizat folosind [fereastra de dialog pentru Gesturi de intrare](#GesturiIntrare).

### Monitorul Braille {#BrailleViewer}

Pentru programatorii văzători sau persoanele care prezintă NVDA unui public văzător, este disponibilă o fereastră mobilă care vă permite să vedeți ieșirea braille și textul echivalent pentru fiecare caracter braille.
Monitorul braille poate fi folosit în același timp pe post de afișaj braille fizic, el va potrivi numărul de celule cu cel care s-ar afla pe un dispozitiv fizic.
Atâta timp cât monitorul braille este în funcțiune, se actualizează constant pentru a vă afișa conținutul braille care ar fi afișat pe un afișaj braille fizic.

Pentru a activa monitorul braille, activați elementul de meniu „Monitor Braille”, aflat în submeniul Instrumente din meniul NVDA.
Debifați elementul de meniu pentru a-l dezactiva.

În mod obișnuit, afișajele braille fizice au butoane pentru derularea înainte și înapoi, însă pentru activarea derulării cu monitorul braille trebuie să folosiți [fereastra de dialog a gesturilor de intrare](#InputGestures), pentru a atribui combinații de taste care să deruleze afișajul braille înainte sau înapoi.

Fereastra monitorului braille conține o casetă de bifat numită „Afișează monitorul braille la pornire”.
Dacă e bifată, monitorul braille va porni odată cu NVDA.
Fereastra monitorului braille va încerca întotdeauna să se redeschidă cu aceeași locație și cu aceleași dimensiuni pe care le avea setate atunci când s-a închis.

### Administratorul suplimentelor {#AddonsManager}

Administratorul suplimentelor, accesat din meniul de „Instrumente”, elementul „Administrare suplimente”, vă permite instalarea, dezinstalarea, activarea și dezactivarea de pachete cu suplimente pentru NVDA.
Aceste pachete sunt furnizate de comunitate și conțin cod specific care poate adăuga sau schimba funcționalități ale NVDA, sau chiar pot furniza compatibilitate pentru afișaje Braille adiționale sau sintetizatoare de vorbire.

Administratorul suplimentelor conține o listă care afișează toate suplimentele curent instalate în configurația dumneavoastră de utilizator a NVDA.
Sunt afișate un nume pentru pachet, stare, versiune și autor pentru fiecare supliment, iar informații suplimentare cum ar fi o descriere sau un URL pot fi văzute prin selectarea suplimentului și apăsarea butonului „Despre supliment”.
Dacă pentru suplimentul selectat este disponibilă asistența, o puteți accesa apăsând butonul „Ajutorul suplimentului”.

Pentru a alege și descărca suplimente disponibile online, apăsați butonul „Obținere suplimente...”.
Butonul deschide [pagina NVDA cu suplimente](https://addons.nvda-project.org/).
Dacă NVDA este instalat și rulează pe sistemul dumneavoastră, puteți deschide suplimentul direct din Navigator pentru a porni procesul de instalare descris mai jos.
Altfel, salvați pachetul cu suplimentul și urmați instrucțiunile de mai jos.

Pentru a instala un supliment obținută anterior, apăsați butonul „Instalează...”
Acțiunea vă va permită să explorați calculatorul propriu sau una din rețelele definite pe sistemul dumneavoastră pentru a găsi pachetul suplimentului (fișier cu numele suplimentului.nvda-addon).
Odată ce apăsați „Deschidere”, procesul de instalare va începe.

Când este instalat un pachet add-on, pentru început NVDA va cere confirmarea dumneavoastră că într-adevăr doriți să instalați pachetul add-on.
Pentru că funcționalitatea suplimentelor nu este restricționată în NVDA, ceea ce, teoretic, include capacitatea de a accesa date personale sau chiar întregul sistem, dacă NVDA este versiunea instalată, este important să instalați suplimente doar din surse în care aveți încredere.
Odată instalat pachetul add-on, NVDA trebuie repornit pentru ca suplimentul să înceapă să ruleze.
Până când executați repornirea, în lista  de suplimente va apărea indicatorul de stare „instalat” în dreptul pachetului add-on respectiv.

Pentru a elimina un supliment, selectați-l din listă și apăsați butonul „Elimină”.
NVDA vă va cere confirmarea acestei acțiuni.
La fel ca pentru instalare, NVDA trebuie repornit pentru ca suplimentul să fie înlăturat complet.
Până când faceți asta, în lista de suplimente va apărea indicatorul de stare „eliminat” în dreptul pachetului add-on respectiv.

Pentru a dezactiva un supliment, apăsați butonul de dezactivare.
Pentru a activa un supliment anterior dezactivat, apăsați butonul de activare.
Puteți dezactiva un supliment dacă starea acestuia este „rulează” sau „activat”, sau îl puteți activa dacă acesta este „suspendat” sau „dezactivat”.
Pentru fiecare apăsare a butonului activează/dezactivează, starea suplimentului se schimbă pentru a indica ce se va întâmpla când NVDA repornește.
Dacă suplimentul a fost dezactivat anterior, starea acestuia va arăta „activat după repornire”. Dacă a fost activat, aceeași stare va arăta „dezactivat după repornire”
La fel ca atunci când instalați sau înlăturați suplimente, trebuie să reporniți NVDA pentru ca modificările să fie luate în considerare.

Administratorul are și un buton „Închide” pentru închiderea ferestrei.
Dacă ați instalat, înlăturat sau modificat starea unui supliment, NVDA vă va întreba mai întâi dacă doriți să îl reporniți pentru ca schimbările să fie aplicate.

În trecut funcționalitatea NVDA putea fi extinsă prin copierea de extensii sau drivere individuale în dosarul cu configurația utilizatorului a NVDA.
Deși este posibil ca această versiune de NVDA să continue să le încarce, acestea nu vor fi afișate în Administratorul de suplimente.
Cel mai bine este să înlăturați aceste fișiere din configurația dumneavoastră și să instalați suplimentul corespunzător, dacă este disponibil.

Unele suplimente mai vechi pot să nu mai fie compatibile cu versiunea de NVDA pe care o aveți.
La utilizarea unei versiuni mai vechi de NVDA, unele suplimente noi ar putea să nu fie nici ele compatibile cu versiunea respectivă.
Încercarea de a instala un supliment incompatibil va rezulta o eroare care va explica de ce acel supliment este considerat incompatibil.
Pentru a vedea care sunt suplimentele incompatibile, puteți folosi butonul „Vizualizare suplimente incompatibile” ca să lansați administratorul de suplimente incompatibile.

Pentru a accesa Managerul de suplimente de oriunde, trebuie să-i atribuiți un gest personalizat folosind [fereastra de dialog pentru Gesturi de intrare](#GesturiIntrare).

#### Administratorul suplimentelor incompatibile {#incompatibleAddonsManager}

Administratorul suplimentelor, care poate fi accesat prin apăsarea butonului „Vizualizare suplimente incompatibile” din administratorul de suplimente, vă permite să vedeți orice supliment incompatibil și motivul pentru care este considerat incompatibil.
Suplimentele sunt considerate incompatibile atunci când nu au fost actualizate ca să lucreze cu modificări semnificative aduse NVDA-ului, sau atunci când se bazează pe o caracteristică inexistentă în versiunea de NVDA pe care o utilizați.
Acest manager are un mesaj scurt în care își explică obiectivul, la fel ca și versiunea de NVDA.
Suplimentele incompatibile sunt prezentate într-o listă cu următoarele coloane:

1. Pachet, numele suplimentului
1. Versiune, versiunea acestuia
1. Motiv de incompatibilitate, o explicație din care reiese motivul pentru care suplimentul este considerat incompatibil

Administratorul are și un buton numit „Despre supliment”.
Apăsându-l veți afla informații relevante despre supliment, care pot fi utile atunci când vreți să-l contactați pe cel care l-a creat.

### Consola Python {#PythonConsole}

Consola Python NVDA, aflată în meniul „Instrumente”, este un instrument pentru dezvoltare folositor pentru depanare, inspecția generală a elementelor interne ale NVDA sau inspecția ierarhiei disponibilității unei aplicații.
Pentru mai multe informații, vă rugăm citiți [Ghidul Dezvoltatorului](https://www.nvaccess.org/files/nvda/documentation/developerGuide.html)

### Reîncărcare extensii plugin {#ReloadPlugins}

Această opțiune, odată activată, reîncarcă module de aplicație și extensii plugin globale fără repornirea NVDA, acțiune utilă pentru dezvoltatori.

## Sintetizatoarele de vorbire compatibile {#SintetizatoareVorbireCompatibile}

Această secțiune conține informații despre sintetizatoarele de vorbire compatibile cu NVDA.
Pentru o listă extinsă cu sintetizatoare gratuite și comerciale care pot fi achiziționate și descărcate pentru a fi folosite cu NVDA, accesați [pagina extravocilor](https://github.com/nvaccess/nvda/wiki/ExtraVoices).

### eSpeak NG {#eSpeakNG}

Sintetizatorul [eSpeak NG](https://github.com/espeak-ng/espeak-ng) este integrat direct în NVDA și nu necesită instalarea unor drivere sau componente speciale.
NVDA pornește folosind eSpeak NG implicit.
Acest sintetizator fiind integrat în NVDA, e o alegere excelentă când rulați NVDA de pe un stick USB sau CD pe alte sisteme.

Fiecare voce din eSpeak vorbește o limbă diferită.
Peste 43 de voci diferite sunt suportate de eSpeak NG.

Există și multe variante care pot fi alese pentru a modifica sunetul vocii.

### Microsoft Speech API versiunea 4 (SAPI 4) {#SAPI4}

SAPI 4 este un standard Microsoft mai vechi pentru sintetizatoare de vorbire software.
NVDA încă suportă standardul pentru utilizatori care au în continuare instalate sintetizatoare pentru SAPI 4.
Cu toate acestea, standardul nu mai este suportat de Microsoft, iar componentele necesare nu mai sunt disponibile de la Microsoft.

Când folosiți acest sintetizator cu NVDA, vocile disponibile (accesate din [ categoria vorbirii](#SpeechSettings) sau din [Inelul setărilor sintetizatorului](#InelSetariSintetizator)) vor conține toate vocile din toate motoarele SAPI 4 instalate în sistemul dv.

### Microsoft Speech API versiunea 5 (SAPI 5) {#SAPI5}

SAPI 5 este un standard Microsoft pentru sintetizatoare de vorbire software. 
Multe sintetizatoare de vorbire care se supun acestui standard pot fi cumpărate sau descărcate gratuit de la mai multe companii sau siteuri web, deși sistemul dv. probabil a venit cu cel puțin o voce SAPI 5 preinstalată.
Când folosiți acest sintetizator cu NVDA, vocile disponibile (accesate din [ categoria vorbirii](#SpeechSettings) sau de [Inelul setărilor sintetizatorului](#InelSetariSintetizator)) vor conține toate vocile din toate motoarele SAPI 5 instalate în sistemul dv.

### Platforma de vorbire Microsoft (Microsoft Speech Platform) {#MicrosoftSpeechPlatform}

Microsoft Speech Platform oferă voci pentru multe dintre limbile care sunt folosite în mod normal la dezvoltarea aplicațiilor de vorbire pe server.
Aceste voci pot fi folosite și cu NVDA.

Pentru a folosi aceste voci, va trebui să instalați două componente:

* Microsoft Speech Platform - Runtime (Versiunea 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Versiunea 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * Această pagină include mai multe fișiere atât pentru recunoașterea vorbirii cât și pentru transformarea textului în vorbire (text-to speech sau TTS).
 Alegeți fișierele care conțin datele pentru limbile/vocile dorite.
 De exemplu, fișierul MSSpeech_TTS_en-US_ZiraPro.msi este o voce de engleză americană.

### Vocile Windows OneCore {#OneCore}

Windows 10 include noi voci cunoscute ca „OneCore” sau voci „mobile”. 
Vocile sunt făcute pentru multe limbi și sunt mai receptive decât vocile Microsoft disponibile prin intermediul Microsoft Speech API versiunea 5.

Vă rugăm să citiți [acest articol Microsoft în limba română](https://support.microsoft.com/ro-ro/help/22797/windows-10-narrator-tts-voices) pentru o listă a vocilor disponibile și instrucțiuni cu privire la instalarea lor.

Vă rugăm să rețineți că vitezele mai mari de vorbire a sintezelor vocale disponibile prin intermediul Narrator-ului nu funcționează momentan cu NVDA.
De asemenea, viteza pe care o selectați din setările Windows-ului afectează viteza setată în NVDA.
Acestea sunt probleme pe care nu le putem rezolva fără modificări aduse în Windows.
Sperăm că acestea vor fi abordate într-o viitoare actualizare de Windows.

### Audiologic Tts3 {#Audiologic}

Acesta este un sintetizator de voce comercial specific pentru limba italiană. 
Trebuie să aveți acest sintetizator instalat în sistemul dv. pentru a putea fi folosit cu NVDA.
Pentru mai multe informații, vă rugăm vizitați site-ul Audiologic la [www.audiologic.it](http://www.audiologic.it).

Acest sintetizator nu suportă [funcționalitatea de silabisire](#SpeechSettingsUseSpelling).

## Afișajele Braille compatibile {#SupportedBrailleDisplays}

Această secțiune conține informații despre afișajele Braille suportate de NVDA.

### Afișaje care suportă detectarea automată în fundal {#AutomaticDetection}

NVDA are abilitatea de a detecta multe afișaje braille în fundal și prin USB sau bluetooth.
Pentru ca NVDA să se comporte astfel, trebuie să selectați opțiunea „Automat” ca afișaj braille preferat din [Setările braille ale NVDA](#BrailleSettings).
Această opțiune este selectată în mod implicit.

Următoarele afișaje braille suportă această funcționalitate de detectare automată.

* Afișajele Handy Tech
* Afișajele Baum/Humanware/APH/Orbit
* Seriile HumanWare Brailliant BI/B
* HumanWare BrailleNote
* SuperBraille
* Seriile Optelec ALVA 6
* Seriile HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille
* Afișajele Eurobraille Esys/Esytime/Iris
* Afișajele Nattiq nBraille

### Freedom Scientific gamele Focus/PAC Mate {#FreedomScientificFocus}

Toate afișajele Focus și PAC Mate de la [Freedom Scientific](https://www.freedomscientific.com/) sunt suportate dacă sunt conectate prin USB sau bluetooth.
Veți avea nevoie ca driverele pentru afișajele Braille de la Freedom Scientific să fie instalate în sistemul dumneavoastră.
Dacă nu le aveți deja, le puteți obține de la https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp .
Cu toate că această pagină menționează doar afișajul Focus Blue, driverele suportă toate afișajele Focus și Pacmate ale Freedom Scientific.
Dacă sistemul dumneavoastră funcționează cu Windows pe 64 de biți iar driverele au fost deja instalate de un alt cititor de ecran, probabil tot va trebui să instalați driverele de la această legătură, deoarece fișierele cerute de NVDA probabil că nu au fost instalate de celălalt cititor de ecran.

Implicit, NVDA poate detecta automat și se conecta la aceste afișaje fie prin USB fie prin bluetooth.
Totuși, când configurați afișajul, puteți selecta explicit porturile „USB” sau „bluetooth” pentru a restricționa tipul de conexiune folosit.
Acest lucru ar putea fi util dacă doriți să conectați afișajul de focalizare la NVDA, folosind bluetooth-ul, dar să puteți in continuare să-l încărcați folosind curent de la portul USB al calculatorului dumneavoastră.

Aceste afișaje nu suportă încă funcționalitatea NVDA-ului  de detectare automată în fundal a afișajelor braille.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |topRouting1 (prima celulă a afișajului)|
|Derulează afișajul braille înainte |topRouting20/40/80 (ultima celulă a afișajului)|
|Derulează afișajul braille înapoi |bară avans stânga|
|Derulează afișajul braille înainte |bară avans dreapta|
|Comută braille asociat la |leftGDFButton+rightGDFButton|
|Comută "left wiz wheel action" |leftWizWheelPress|
|Mergi înapoi folosind left wiz wheel action |leftWizWheelUp|
|Mergi înainte folosind left wiz wheel action |leftWizWheelDown|
|Comută "right wiz wheel action" |rightWizWheelPress|
|Mergi înapoi folosind right wiz wheel action |rightWizWheelUp|
|Mergi înainte folosind right wiz wheel action |rightWizWheelDown|
|Mută la celula braille |routing|
|tasta shift+tab |bară spațiu braille+punct 1+punct 2|
|tasta tab |bară spațiu braille+punct 4+punct 5|
|tasta săgeată sus |bară spațiu braille+punct 1|
|tasta săgeată jos |bară spațiu braille+punct 4|
|tasta control+săgeată stânga |bară spațiu braille+punct 2|
|tasta control+săgeată dreapta |bară spațiu braille+punct 5|
|săgeată stânga |bară spațiu braille+punct 3|
|tasta săgeată dreapta |bară spațiu braille+punct 6|
|tasta acasă (home) |bară spațiu braille+punct 1+punct 3|
|tasta sfârșit (end) |bară spațiu braille+punct 4+punct 6|
|tasta control+acasă |bară spațiu braille+punct 1+punct 2+punct 3|
|tasta control+sfârșit |bară spațiu braille+punct 4+punct 5+punct 6|
|tasta alt |bară spațiu braille+punct 1+punct 3+punct 4|
|tasta alt+tab |bară spațiu braille+punct 2+punct 3+punct 4+punct 5|
|tasta alt+shift+tab |bară spațiu braille+punct1+punct2+punct5+punct6|
|tasta windows+tab |bară spațiu braille+punct2+punct3+punct4|
|tasta escape |bară spațiu braille+punct 1+punct 5|
|tasta windows |bară spațiu braille+punct 2+punct 4+punct 5+punct 6|
|tasta spațiu |bară spațiu braille|
|tasta windows+d (minimizează toate aplicațiile ) |bară spațiu braille+punct 1+punct 2+punct 3+punct 4+punct 5+punct 6|
|Anunță rândul curent |bară spațiu braille+punct 1+punct 4|
|meniul NVDA |bară spațiu braille+punct 1+punct 3+punct 4+punct 5|

Pentru modele Focus mai noi, care conțin taste „rocker bar” (focus 40, focus 80 și focus blue):

| Nume |Tastă|
|---|---|
|Mută afișajul braille la rândul anterior |leftRockerBarUp, rightRockerBarUp|
|Mută afișajul braille la rândul următor |leftRockerBarDown, rightRockerBarDown|

Doar pentru Focus 80:

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |leftBumperBarUp, rightBumperBarUp|
|Derulează afișajul braille înainte |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA seria 6/convertor de protocol {#OptelecALVA}

Atât afișajele ALVA BC640 cât și BC680 de la [Optelec](https://www.optelec.com/) sunt suportate dacă sunt conectate prin USB sau bluetooth.
Alternativ, puteți conecta un afișaj Optelec mai vechi, cum ar fi Braille Voyager, folosind un convertor de protocol furnizat de Optelec.
Nu aveți nevoie de un driver specific instalat pentru a folosi aceste afișaje. 
Doar conectați afișajul și configurați NVDA să-l folosească.

Notă: NVDA s-ar putea să nu fie capabil să folosească un afișaj ALVA BC6 prin bluetooth, atunci când este împerecheat folosind utilitarul ALVA Bluetooth
Când ați împerecheat dispozitivul, folosind acest utilitar și NVDA nu vă poate detecta dispozitivul, vă recomandăm să împerecheați afișajul dumneavoastră ALVA prin metoda tradițională, folosind opțiunile Windows pentru Bluetooth.

Notă: în timp ce unele dintre aceste afișaje au tastatură braille, tratează traducerea din braille în text chiar ele, în mod implicit
Asta înseamnă că sistemul de intrări braille al NVDA nu este folosit în acest mod implicit (de ex. opțiunile tabelului de intrări braille nu au niciun efect)
Pentru afișajele ALVA de model recent, este posibil să dezactivați simularea HID a tastaturii, folosind un gest de intrare.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |t1, etouch1|
|Mută afișajul braille la rândul anterior |t2|
|Mută la focalizarea curentă |t3|
|Mută afișajul braille la rândul următor |t4|
|Derulează afișajul braille înainte |t5, etouch3|
|Mută la celula braille |routing|
|Raportează formatul textului de sub celula braille |routing secundară|
|Comută simularea HID a tastaturii |t1+spEnter|
|Mută la linia de sus în examinare |t1+t2|
|Mută la linia de jos în examinare |t4+t5|
|Comută braille asociat la |t1+t3|
|Raportează titlu |etouch2|
|Raportează bara de stare |etouch4|
|tasta shift+tab |sp1|
|tasta alt |sp2, alt||
|tasta escape |sp3|
|tasta tab |sp4|
|tasta săgeată sus |spUp|
|tasta săgeată jos |spDown|
|tasta săgeată stânga |spLeft|
|tasta săgeată dreapta |spRight|
|tasta enter |spEnter, enter||
|Raportează data/timp |sp2+sp3|
|Meniu NVDA |sp1+sp3|
|tasta windows+d (minimizează toate aplicațiile) |sp1+sp4|
|tasta windows+b (focalizează pe zona de notificare a sistemului) |sp3+sp4|
|tasta windows |sp1+sp2, windows|
|tasta alt+tab |sp2+sp4|
|tasta control+home |t3+spUp|
|tasta control+end |t3+spDown|
|tasta home |t3+spLeft|
|tasta end |t3+spRight|
|tasta control |control|

<!-- KC:endInclude -->

### Afișajele Handy Tech {#HandyTech}

NVDA suportă majoritatea afișajelor de la [Handy Tech](https://www.handytech.de/) când sunt conectate prin USB sau bluetooth.
Pentru afișajele USB mai vechi, veți avea nevoie să instalați în sistemul dv. driverele USB de la Handy Tech.

Următoarele afișaje nu sunt suportate, dar pot fi utilizate prin [driver-ul universal Handy Tech](https://handytech.de/en/service/downloads-and-manuals/handy-tech-software/braille-display-drivers) și prin suplimentul NVDA pentru el:

* Braillino
* Bookworm
* Afișajele Modular cu versiunea firmware 1.13 sau mai veche. Vă rugăm să rețineți faptul că firmware-ul acestor afișaje poate fi actualizat.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |stânga, sus, b3||
|Derulează afișajul braille înainte |dreapta, jos, b6||
|Mută afișajul braille la rândul anterior |b4|
|Mută afișajul braille la rândul următor |b5|
|Mută la celula braille |routing|
|tasta shift+tab |esc, tasta acțiunii triple la stânga sus+jos|
|tasta alt |b2+b4+b5|
|tasta escape |b4+b6|
|tasta tab |enter, tasta acțiunii triple la dreapta sus+jos|
|tasta enter |esc+enter, tasta acțiunii triple la dreapta sus+jos, joystickAction||
|tasta săgeată sus |joystickUp|
|tasta săgeată jos |joystickDown|
|tasta săgeată stânga |joystickLeft|
|tasta săgeată dreapta |joystickRight|
|meniul NVDA |b2+b4+b5+b6|
|Comută la Braille legat la |b2|
|Comută la cursorul braille |b1|
|Comută la prezentarea contextului focalizării |b7|
|Comută la intrarea braille |spațiu+b1+b3+b4 (spațiu+capital B)|

<!-- KC:endInclude -->

### MDV Lilli {#MDVLilli}

Afișajul braille Lilli disponibil de la [MDV](https://www.mdvbologna.it/) este suportat.
Nu aveți nevoie de un driver specific instalat pentru a folosi acest afișaj.
Doar conectați afișajul și configurați NVDA să-l folosească.

Acest afișaj nu suportă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |LF|
|Derulează afișajul braille înainte |RG|
|Mută afișajul braille la rândul anterior |UP|
|Mută afișajul braille la rândul următor |DN|
|Mută la celula braille |route|
|tasta shift+tab |SLF|
|tasta tab |SRG|
|tasta alt+tab |SDN|
|tasta alt+shift+tab |SUP|

<!-- KC:endInclude -->

### Afișaje braille Baum/Humanware/APH/Orbit {#Baum}

Mai multe ecrane [Baum](https://www.baum.de/cms/en/), [HumanWare](https://www.humanware.com/), [APH](https://www.aph.org/) și [Orbit](https://www.orbitresearch.com/) sunt suportate atunci când sunt conectate prin USB, bluetooth sau port serial.
Acestea includ:

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!, SuperVario2, Vario 340
* HumanWare: Brailliant, BrailleConnect, Brailliant2
* APH: Refreshabraille
* Orbit: Orbit Reader 20

S-ar putea să funcționeze și alte afișaje produse de Baum, deși nu s-a testat acest aspect.

Dacă vă conectați prin USB la afișaje care nu folosesc HID, va trebui să instalați mai întâi driverele USB puse la dispoziție de producător.
Afișajele VarioUltra și Pronto! folosesc HID.
Refreshabraille și Orbit Reader 20 pot folosi HID dacă sunt configurate corespunzător.

Modul USB serial pentru Orbit Reader 20 este compatibil doar în Windows 10 momentan.
În general ar trebui folosit modul USB HID.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |d2|
|Derulează afișajul braille înainte |d5|
|Mută afișajul braille la rândul anterior |d1|
|Mută afișajul braille la rândul următor |d3|
|Mută la celula braille |routing|

Pentru afișaje care au joystick:

| Nume |Tastă|
|---|---|
|tasta săgeată sus |sus|
|tasta săgeată jos |jos|
|tasta săgeată stânga |stânga|
|tasta săgeată dreapta |dreapta|
|tasta enter |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#HedoProfiLine}

Dispozitivul hedo ProfiLine USB de la [hedo Reha-Technik](https://www.hedo.de/) este suportat.
Trebuie, mai întâi, să instalați driverele USB puse la dispoziție de producător.

Acest afișaj nu suportă încă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |K1|
|Derulează afișajul braille înainte |K3|
|Mută afișajul braille la rândul anterior |B2|
|Mută afișajul braille la rândul următor |B5|
|Mută la celula braille |routing|
|Comută braille asociat la |K2|
|Rostește tot |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#HedoMobilLine}

Dispozitivul hedo MobilLine USB de la [hedo Reha-Technik](https://www.hedo.de/) este suportat.
Trebuie, mai întâi, să instalați driverele USB puse la dispoziție de producător.

Acest afișaj nu suportă încă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |K1|
|Derulează afișajul braille înainte |K3|
|Mută afișajul braille la rândul anterior |B2|
|Mută afișajul braille la rândul următor |B5|
|Mută la celula braille |routing|
|Comută braille asociat la |K2|
|Rostește tot |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant seriile BI/B / BrailleNote Touch {#HumanWareBrailliant}

Afișajele Brailliant din gamele BI și B de la [HumanWare](https://www.humanware.com/), incluzând BI 14, BI 32, BI 40 și B 80, sunt suportate când sunt conectate prin USB sau bluetooth.
Dacă sunt conectate prin USB cu protocolul setat pe HumanWare, va trebui mai întâi să instalați driverele USB puse la dispoziție de producător.
Nu sunt necesare drivere USB, dacă protocolul este setat pe OpenBraille.
Pentru Braillenote Touch nu mai este necesară instalarea unui driver.

Sunt suportate și dispozitivele adiționale menționate mai jos. Ele nu necesită instalarea vreunui driver special. Acestea sunt:

* APH Mantis Q40
* APH Chameleon 20
* Humanware BrailleOne
* NLS eReader

Urmează asocierile de taste în NVDA pentru display-urile Brailliant BI/B și BrailleNote touch.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.

#### Asocieri de taste pentru toate  modelele {#toc249}

<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul anterior |sus|
|Mută afișajul braille la rândul următor |jos|
|Mută la celula braille |routing|
|Comută braille asociat la |sus+jos|
|tasta săgeată sus |spațiu+punct 1|
|tasta săgeată jos |spațiu+punct 4|
|tasta săgeată stânga |spațiu+punct 3|
|tasta săgeată dreapta |spațiu+punct 6|
|tasta shift+tab |spațiu+punct 1+punct 3|
|tasta tab |spațiu+punct 4+punct 6|
|tasta alt |spațiu+punct 1+punct 3+punct 4 (spațiu+m)|
|tasta escape |spațiu+punct 1+punct 5 (spațiu+e)|
|tasta enter |punct 8|
|tasta windows |spațiu+punct 3+punct 4|
|tasta alt+tab |spațiu+punct 2+punct 3+punct 4+punct 5 (spațiu+t)|
|Meniul NVDA |spațiu+punct1+punct3+punct4+punct5 (spațiu+n)|
|Tastele windows+d (minimizeaza toate aplicațiile) |spațiu+punct1+punct4+punct5 (spațiu+d)|
|Rostește tot |spațiu+punct1+punct2+punct3+punct4+punct5+punct6|

<!-- KC:endInclude -->

#### Asocieri de taste pentru Brailliant BI 32, BI 40 și B 80 {#toc250}

<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Meniul NVDA |c1+c3+c4+c5 (commandă n)|
|Tastele windows+d (minimizeaza toate aplicațiile) |c1+c4+c5 (commandă d)|
|Rostește tot |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

#### Asocieri de taste pentru Brailliant BI 14 {#toc251}

<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Săgeată sus |joystick sus|
|Săgeată jos |joystick jos|
|Săgeată stânga |joystick stânga|
|Săgeată dreapta |joystick dreapta|
|Tasta enter |joystick acțiune (mijloc)|

<!-- KC:endInclude -->

### HIMS gamele Braille Sense/Braille EDGE/Smart Beetle Sync Braille {#Hims}

NVDA suportă afișajele Braille Sense, Braille EDGE și Smart Beetle de la [Hims](https://www.hims-inc.com/) când sunt conectate via USB sau bluetooth.
Dacă sunt conectate prin USB, va trebui să instalați driverele USB de la HIMS pe sistemul dumneavoastră.
Le puteți descărca de aici: https://www.himsintl.com/?c=2/13&uid=2319

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |derulator stânga în jos|
|Derulează afișajul braille înainte |derulator dreapta în jos|
|Mută afișajul braille la rândul anterior |derulator stânga în sus|
|Mută afișajul braille la rândul următor |derulator dreapta în sus|
|Mută la celula braille |routing|
|tasta shift+tab |punct 1+punct 2+spațiu|
|tasta alt |punct 1+punct 3+punct 4+spațiu|
|tasta escape |punct 1+punct 5+spațiu|
|tasta tab |punct 4+punct 5+spațiu|
|tasta săgeată sus |punct 1+spațiu|
|tasta săgeată jos |punct 4+spațiu|
|blochează majuscule (capsLock) |punct 1+punct 3+punct 6+spațiu|
|tasta shift+alt+tab |avansează 2+avansează 3+avansează 1|
|tasta alt+tab |avansează 2+avansează 3|
|tasta sfârșit (end) |punct 4+punct 6+spațiu|
|tasta Control+sfârșit |punct 4+punct 5+punct 6+spațiu|
|tasta acasă (home) |punct 1+punct 3+spațiu|
|tasta control+acasă |punct 1+punct 2+punct 3+spațiu|
|tasta săgeată stânga |punct 3+spațiu|
|tasta control+shift+săgeată stânga |punct 2+punct 8+spațiu+avansează 1|
|tasta control+săgeată stânga |punct 2+spațiu|
|tasta shift+alt+săgeată stânga |punct 2+punct 7+avansează 1|
|tasta alt+săgeată stânga |punct 2+punct 7|
|tasta săgeată dreapta |punct 6+spațiu|
|tasta control+shift+săgeată dreapta |punct 5+punct 8+spațiu+avansează 1|
|tasta control+săgeată dreapta |punct 5+spațiu|
|tasta shift+alt+săgeată dreapta |punct 5+punct 7+avansează 1|
|tasta alt+săgeată dreapta |punct 5+punct 7|
|tasta pagină în sus (pageUp) |punct 1+punct 2+punct 6+spațiu|
|tasta control+pagină în sus |punct 1+punct 2+punct 6+punct 8+spațiu|
|tasta control+shift+săgeată sus |punct 2+punct 3+punct 8+spațiu+avansează 1|
|tasta control+săgeată sus |punct 2+punct 3+spațiu|
|tasta shift+alt+săgeată sus |punct 2+punct 3+punct 7+avansează 1|
|tasta alt+săgeată sus |punct 2+punct 3+punct 7|
|tasta shift+săgeată sus |derulator stânga în jos + spațiu|
|tasta pagină în jos (pageDown) |punct 3+punct 4+punct 5+spațiu|
|tasta control+pagină în jos |punct 3+punct 4+punct 5+punct 8+spațiu|
|tasta control+shift+săgeată jos |punct 5+punct 6+punct 8+spațiu+avansează 1|
|tasta control+săgeată jos |punct 5+punct 6+spațiu|
|tasta shift+alt+săgeată jos |punct 5+punct 6+punct 7+avansează 1|
|tasta alt+săgeată jos |punct 5+punct 6+punct 7|
|tasta shift+săgeată jos |derulator dreapta în jos + spațiu|
|tasta șterge (delete) |punct 1+punct 3+punct 5+spațiu|
|tasta F1 |punct 1+punct 2+punct 5+spațiu|
|tasta F3 |punct 1+punct 2+punct 4+punct 8|
|tasta F4 |punct 7+avansează 3|
|tasta windows+b |punct 1+punct 2+avansează 1|
|tasta windows+d |punct 1+punct 4+punct 5+avansează 1|

<!-- KC:endInclude -->

### HIMS SyncBraille {#toc253}

NVDA suportă afișajul SyncBraille de la [Hims](https://www.hims-inc.com/).
Va trebui să instalați driverele USB de la HIMS pe sistemul dumneavoastră.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |derulator stânga în jos|
|Derulează afișajul braille înainte |derulator dreapta în jos|
|Mută la celula braille |routing|

<!-- KC:endInclude -->

### Afișaje Braille Seika {#Seika}

Versiunile de afișaje braille Seika 3, 4 și 5 (cu 40 de celule) și Seika80 (cu 80 de celule) de la [Nippon Telesoft](https://www.nippontelesoft.com/) sunt suportate.
Puteți găsi mai multe informații despre aceste afișaje la https://www.seika-braille.com/ .
Trebuie, mai întâi, să instalați driverele USB puse la dispoziție de producător.

Aceste afișaje nu suportă încă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de taste pentru acest afișaj și NVDA.
Vă rugăm să consultați Documentația afișajului pentru informații despre localizarea tastelor pe dispozitiv.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul anterior |b3|
|Mută afișajul braille la rândul următor |b4|
|Comută braille asociat la |b5|
|Rostește tot |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|Meniul NVDA |stânga+dreapta|
|Mută la celula braille |routing|

<!-- KC:endInclude -->

### Modelele mai noi Papenmeier BRAILLEX {#Papenmeier}

Următoarele afișaje braille sunt suportate:

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB și bluetooth)
* BRAILLEX Live 20, BRAILLEX Live și BRAILLEX Live Plus (USB și bluetooth)

Aceste afișaje nu suportă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Dacă BrxCom este instalat, NVDA va folosi BrxCom.
BrxCom este un instrument care permite intrărilor de tastatură de la afișajul braille să funcționeze independent de cititorul de ecran.
Papenmeier va lansa curând o nouă versiune a BrxCom care funcționează cu NVDA.
Intrările de tastatură sunt disponibile cu modelele Trio și BRAILLEX Live.

Majoritatea dispozitivelor au o Bară de acces facil (Easy Access Bar - EAB) care permite o operare rapidă și intuitivă.
EAB poate fi mutată în patru direcții și, în general, fiecare direcție are două comutatoare.
Gamele „C” și „Live” sunt singurele excepții de la această regulă.

Gama „C” și câteva alte afișaje au două rânduri de transfer (routing rows), unde rândul de sus este folosit pentru raportarea informațiilor despre format.
Ținând una dintre tastele de transfer (routing key) superioare și apăsând EAB pe dispozitivele din seria C, este emulată cea de-a doua stare comutată. 
Afișajele din gama „Live” au doar un rând pentru transfer, iar EAB are un pas per direcție.
Cel de-al doilea pas poate fi emulat prin apăsarea uneia dintre tastele de transfer și apăsarea EAB în direcția corespunzătoare.
Apăsând și menținând tastele sus, jos, dreapta și stânga (sau EAB) provoacă repetarea acțiunii corespunzătoare.

În general, următoarele taste sunt disponibile pe aceste afișaje braille:

| Nume |Tastă|
|---|---|
|l1 |Tasta stânga-față|
|l2 |Tasta stânga-spate|
|r1 |Tasta dreapta-față|
|r2 |Tasta dreapta-spate|
|sus |un pas în sus|
|sus2 |doi pași în sus|
|stânga |un pas la stânga|
|stânga2 |doi pași la stânga|
|dreapta |un pas la dreapta|
|dreapta2 |doi pași la dreapta|
|dn |un pas în jos|
|dn2 |doi pași în jos|

Urmează asocierile de comenzi pentru Papenmeier și NVDA:
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul anterior |sus|
|Mută afișajul braille la rândul următor |dn|
|Mută la celula braille |routing|
|Anunță caracterul analizat curent |l1|
|Activează obiectul navigator curent |l2|
|Comută braille asociat la |r2|
|Anunță titlu |l1+sus|
|Anunță bara de stare |l2+jos|
|Mută la obiectul conținător |sus2|
|Mută la primul obiect conținut |dn2|
|Mută la obiectul anterior |stânga2|
|Mută la următorul obiect |dreapta2|
|Anunță formatarea textului de sub celula braille |upper routing row|

<!-- KC:endInclude -->

Modelul Trio are patru taste adiționale care se află în partea din față a tastaturii braille.
Acestea sunt (în ordine de la stânga la dreapta):

* tasta police stânga (lt)
* spațiu
* spațiu
* tasta police dreapta (rt)

Momentan, tasta police dreapta nu este folosită.
Ambele taste din mijloc sunt mapate la spațiu.

| Nume |Tastă|
|---|---|

<!-- KC:beginInclude -->

|tasta escape |spațiu cu punct  7|
|tasta săgeată sus |spațiu cu punct  2|
|tasta săgeată stânga |spațiu cu punct  1|
|tasta săgeată dreapta |spațiu cu punct  4|
|tasta săgeată jos |spațiu cu punct  5|
|tasta control |lt+punct 2|
|tasta alt |lt+punct 3|
|tasta control+escape |spațiu cu punct  1 2 3 4 5 6|
|tasta tab |spațiu cu punct  3 7|

<!-- KC:endInclude  -->

### Modele mai vechi Papenmeier Braille BRAILLEX {#PapenmeierOld}

Următoarele afișaje Braille sunt suportate:

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

De notat că aceste afișaje pot fi conectate doar printr-un port serial.
Din această cauză, aceste afișaje nu suportă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.
În consecință, ar trebui să alegeți portul la care este conectat afișajul după ce ați ales acest driver în [Dialogul de selectare al afișajului braille](#SelectBrailleDisplay).

Unele dintre aceste dispozitive au o Bară de acces facil (Easy Access Bar - EAB) care permite o operare rapidă și intuitivă.
EAB poate fi mutată în patru direcții și, în general, fiecare direcție are două comutatoare.
Apăsând și menținând tastele sus, jos, dreapta și stânga (sau EAB) provoacă repetarea acțiunii corespunzătoare.
Dispozitivele mai vechi nu au o EAB; sunt folosite tastele frontale, în schimb.

În general, următoarele taste sunt disponibile pe afișajele braille:

| Nume |Tastă|
|---|---|
|l1 |Tasta stânga-față|
|l2 |Tasta stânga-spate|
|r1 |Tasta dreapta-față|
|r2 |Tasta dreapta-spate|
|sus |un pas în sus|
|sus2 |doi pași în sus|
|stânga |un pas la stânga|
|stânga2 |doi pași la stânga|
|dreapta |un pas la dreapta|
|dreapta2 |doi pași la dreapta|
|dn |un pas în jos|
|dn2 |doi pași în jos|

Urmează asocierile de comenzi pentru Papenmeier și NVDA:

<!-- KC:beginInclude -->
Dispozitive cu EAB:

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul anterior |sus|
|Mută afișajul braille la rândul următor |dn|
|Mută la celula braille |routing|
|Anunță caracterul analizat curent |l1|
|Activează obiectul navigator curent |l2|
|Anunță titlu |l1up|
|Anunță bara de stare |l2down|
|Mută la obiectul conținător |sus2|
|Mută la primul obiect conținut |dn2|
|Mută la următorul obiect |dreapta2|
|Mută la obiectul anterior |stânga2|
|Anunță formatarea textului de sub celula braille |upper routing strip|

BRAILLEX Tiny:

| Nume |Tastă|
|---|---|
|Anunță caracterul analizat curent |l1|
|Activează obiectul navigator curent |l2|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul anterior |sus|
|Mută afișajul braille la rândul următor |dn|
|Comută braille asociat la |r2|
|Mută la obiectul conținător |r1+sus|
|Mută la primul obiect conținut |r1+dn|
|Mută la obiectul anterior |r1+stânga|
|Mută la următorul obiect |r1+dreapta|
|Anunță formatarea textului de sub celula braille |upper routing strip|
|Anunță titlu |l1+sus|
|Anunță bara de stare |l2+jos|

BRAILLEX 2D Screen:

| Nume |Tastă|
|---|---|
|Anunță caracterul analizat curent |l1|
|Activează obiectul navigator curent |l2|
|Comută braille asociat la |r2|
|Anunță formatarea textului de sub celula braille |upper routing strip|
|Mută afișajul braille la rândul anterior |sus|
|Derulează afișajul braille înapoi |stânga|
|Derulează afișajul braille înainte |dreapta|
|Mută afișajul braille la rândul următor |dn|
|Mută la următorul obiect |stânga2|
|Mută la obiectul conținător |sus2|
|Mută la primul obiect conținut |dn2|
|Mută la obiectul anterior |dreapta2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#HumanWareBrailleNote}

NVDA suportă dispozitivul de luat notițe BrailleNote de la [Humanware](https://www.humanware.com) când este folosit ca terminal de afișare pentru un cititor de ecran.
Următoarele modele sunt suportate:

* BrailleNote Classic (doar conexiune serială)
* BrailleNote PK (conexiuni serială și prin bluetooth)
* BrailleNote MPower (conexiuni serială și prin bluetooth)
* BrailleNote Apex (conexiuni USB și prin bluetooth)

Pentru BrailleNote Touch, vă rugăm citiți pasajul [Brailliant seriile BI/B / BrailleNote Touch](HumanWareBrailliant).

In afară de Braillenote PK, NVDA este compatibil cu tastaturile Braillenote BT și Braillenote Quertz (QT).
Braillenote QT deocamdată nu poate fi comutat la modul de tastatura PC.
Puteți introduce puncte Braille cu tastatura Braillenote QT.
Pentru mai multe detalii vă rugăm să consultați manualul afișajului  braille, mai exact secțiunea ”terminal Braille”.

Dacă, după ce conectați BrailleNote la NVDA, dispozitivul dumneavoastră este compatibil cu mai mult de un tip de conexiune, trebuie să stabiliți portul terminalului braille în opțiunile terminalului braille.
Consultați manualul BrailleNote pentru detalii.
În NVDA, s-ar putea să fie necesară stabilirea portului în [Dialogul selectării afișajului braille](#SelectBrailleDisplay).
Dacă vă conectați prin USB sau bluetooth, puteți stabili portul la una din valorile: „Automat”, „USB” sau „Bluetooth”, în funcție de opțiunile disponibile.
Dacă faceți conexiunea folosind unul dintre porturile seriale moștenite (sau un adaptor USB la serial) sau dacă nu apare niciuna dintre opțiunile precedente, trebuie să alegeți în mod explicit portul de comunicații ce va fi folosit, din lista porturilor hardware.

Înainte de conectarea lui BrailleNote Apex, folosindu-i interfața de client USB, trebuie să instalați driverele puse la dispoziție de HumanWare.

Cu Braillenote Apex BT puteți introduce comenzi NVDA folosind joysticul de rulare dintre punctele 1 și 4.
Joysticul este compus din 4 puncte direcționale, un buton central și dintr-o rotiță care se poate  învârti in sensul de ceasornic sau in sens opus.

Urmează asocierile de comenzi pentru BrailleNote și NVDA.
Vă rugăm să consultați documentația dispozitivului dumneavoastră BrailleNote pentru informații despre localizarea tastelor pe dispozitiv.

<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |back|
|Derulează afișajul braille înainte |avansează|
|Mută afișajul braille la rândul anterior |previous|
|Mută afișajul braille la rândul următor |next|
|Mută la celula braille |routing|
|Comută braille asociat la |previous+next|
|Meniul NVDA |spațiu+punct 1 + punct 3 + punct 4 + Punct 5 (spațiu+n)|
|tasta săgeată sus |spațiu+punct 1|
|tasta săgeată jos |spațiu+punct 4|
|tasta săgeată stânga |spațiu+punct 3|
|tasta săgeată dreapta |spațiu+punct 6|
|tasta pagină în sus (Page up) |spațiu+punct 1+punct 3|
|tasta pagină în jos (Page down) |spațiu+punct 4+punct 6|
|tasta acasă (Home) |spațiu+punct 1+punct 2|
|tasta sfârșit (End) |spațiu+punct 4+punct 5|
|tasta Control+acasă |spațiu+punct 1+punct 2+punct 3|
|tasta Control+sfârșit |spațiu+punct 4+punct 5+punct 6|
|tasta Spațiu |spațiu|
|Enter |spațiu+punct 8|
|șterge înapoi (Backspace) |spațiu+punct 7|
|tasta Tab |spațiu+punct 2+punct 3+punct 4+punct 5 (spațiu+t)|
|tasta Shift+tab |spațiu+punct 1+punct 2+punct 5+punct 6|
|tasta Windows |spațiu+punct 2+punct 4+punct 5+punct 6 (spațiu+w)|
|tasta Alt |spațiu+punct 1+punct 3+punct 4 (spațiu+m)|
|Comută ajutor pentru intrări |spațiu+punct 2+punct 3+punct 6 (spațiu+ h mic)|

Urmează comenzi atributate la Braillenote QT când această tastatură nu este în modul de intrare braille:

| Nume |Tastă|
|---|---|
|Meniu NvDA |citește+n|
|săgeată sus |Săgeată sus|
|Săgeată jos |Săgeată jos|
|Săgeată stânga |Săgeată stânga|
|Săgeată dreapta |Săgeată dreapta|
|Pagină sus |Tasta funcție  î săgeată sus|
|Pagină jos |Tasta funcție + săgeată jos|
|Tasta acasă |Tasta funcție + Săgeată stânga|
|Tasta Sfârșit |Tasta funcție + săgeată dreapta|
|Control+acasă |citește + t|
|Control + sfârșit |citește + b|
|Tasta Enter |enter|
|Tasta șterge înapoi |backspace|
|Tasta Tab |tab|
|Shift+tab |shift+tab|
|Tasta Windows |citește + w|
|Tasta Alt |citește + m|
|Comută ajutor pentru intrări |citește + 1|

Urmează comenzi pentru joysticul de rulare:

| Nume |Tastă|
|---|---|
|Săgeată sus |Săgeată sus|
|Săgeată jos |Săgeată jos|
|Săgeată stânga |Săgeată stânga|
|Săgeată dreapta |Săgeată dreapta|
|Tasta Enter |Butonul central|
|Tasta Tab |Învârtiți rotița  in sens de ceasornic|
|Shift+tab |Învârtiți rotița contra sensului de ceasornic|

<!-- KC:endInclude -->

### EcoBraille {#EcoBraille}

NVDA este compatibil cu afișajele EcoBraille de la [ONCE](https://www.once.es/).
Următoarele modele sunt suportate:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

În NVDA, puteți stabili portul serial la care este conectat afișajul din [Dialogul de selectare a afișajului braille](#SelectBrailleDisplay).
Aceste afișaje nu suportă funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de comenzi pentru BrailleNote și NVDA.
Vă rugăm să consultați [documentația EcoBraille](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/)  pentru informații despre localizarea tastelor pe dispozitiv.

<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișajul braille înapoi |T2|
|Derulează afișajul braille înainte |T4|
|Mută afișajul braille la rândul anterior |T1|
|Mută afișajul braille la rândul următor |T5|
|Mută la celula braille |Routing|
|Activează obiectul navigator curent |T3|
|Comută la următorul mod de examinare |F1|
|Mută la obiectul conținător |F2|
|Comută la anteriorul mod de examinare |F3|
|Mută la obiectul anterior |F4|
|Anunță obiectul curent |F5|
|Mută la următorul obiect |F6|
|Mută la obiectul focalizat |F7|
|Mută la primul obiect conținut |F8|
|Mută focalizarea sistemului sau cursorul de scriere la poziția de examinare curentă |F9|
|Anunță locația cursorului de examinare |F0|
|Comută braille asociat la |A|

<!-- KC:endInclude -->

### SuperBraille {#SuperBraille}

Dispozitivul Superbraille, disponibil mai ales în Taiwan, poate fi conectat prin USB sau serial.
Având în vedere faptul că SuperBraille nu are taste fizice sau butoane de derulare, toate intrările trebuie efectuate printr-o tastatură standard de calculator.
Datorită acestui fapt, dar și pentru a menține compatibilitatea cu alte cititoare de ecran din Taiwan, au fost furnizate două taste de legătură pentru derularea afișării braille:
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|Derulează afișarea braille înapoi |minus de pe blocul numeric|
|Derulează afișarea braille înainte |plus de pe blocul numeric|

<!-- KC:endInclude -->

### Afișajele Eurobraille Esys/Esytime/Iris {#Eurobraille}

Afișajele Esys, Esytime și Iris de la [Eurobraille](https://www.eurobraille.fr/) sunt suportate de NVDA.
Dispozitivele Esys and Esytime-Evo sunt suportate atunci când sunt conectate prin USB sau prin bluetooth.
Dispozitivele Esytime mai vechi suportă doar USB.
Afișajele Iris pot fi conectate printr-un port serial.
Prin urmare, pentru aceste afișaje, trebuie să selectați portul la care este conectat afișajul după ce ați ales driver-ul din dialogul setărilor braille.

Afișajele Iris și Esys au o tastatură braille cu 10 taste.
Sunt două taste puse ca o bară de spațiu, tasta din stânga fiind corespondenta lui backspace, iar tasta din dreapta corespondenta tastei spațiu.

Urmează asocierile de taste pentru aceste afișaje cu NVDA.
Vă rugăm să citiți documentația afișajului pentru descrierile locului în care pot fi găsite aceste taste.
<!-- KC:beginInclude -->

| Nume |tastă|
|---|---|
|Derulează înapoi afișajul braille |switch1-6stânga, l1|
|Derulează înainte afișajul braille |switch1-6dreapta, l8|
|Mută la focalizarea curentă |switch1-6stânga+switch1-6dreapta, l1+l8|
|Comută la celula braille |routing|
|Raportează formatul textului de sub celula braille |doubleRouting|
|Mută la linia precedentă din examinare |joystick1Sus|
|Mută la linia următoare din examinare |joystick1Jos|
|Mută la caracterul anterior din examinare |joystick1Stânga|
|Mută la caracterul următor din examinare |joystick1Dreapta|
|Comută la modul de examinare anterior |joystick1Stânga+joystick1Sus|
|Comută la modul de examinare următor |joystick1Dreapta+joystick1Jos|
|Șterge ultima celulă sau ultimul caracter braille introdus |backspace|
|Traduce orice intrare braille și apasă tasta enter |backSpace+spațiu|
|insert |punct3+punct5+spațiu, l7|
|șterge |punct3+punct6+spațiu|
|home |punct1+punct2+punct3+spațiu, joystick2Stânga+joystick2Sus|
|end |punct4+punct5+punct6+spațiu, joystick2Dreapta+joystick2Jos|
|săgeată jos |punct2+spațiu, joystick2Stânga, săgeată jos|
|săgeată dreapta |punct5+spațiu, joystick2Dreapta, săgeată dreapta|
|săgeată sus |punct1+spațiu, joystick2Sus, săgeată sus|
|săgeată jos |punct6+spațiu, joystick2Jos, săgeată jos|
|enter |joystick2Centru|
|pagină sus |punct1+punct3+spațiu|
|pagină jos |punct4+punct6+spațiu|
|1 bloc numeric |punct1+punct6+backspace|
|2 bloc numeric |punct1+punct2+punct6+backspace|
|3 bloc numeric |punct1+punct4+punct6+backspace|
|4 bloc numeric |punct1+punct4+punct5+punct6+backspace|
|5 bloc numeric |punct1+punct5+punct6+backspace|
|6 bloc numeric |punct1+punct2+punct4+punct6+backspace|
|7 bloc numeric |punct1+punct2+punct3+punct4+punct5+punct6+backspace|
|8 bloc numeric |punct1+punct2+punct5+punct6+backspace|
|9 bloc numeric |punct2+punct4+punct6+backspace|
|insert bloc numeric |punct3+punct4+punct5+punct6+backspace|
|decimală bloc numeric |punct2+backspace|
|împărțire bloc numeric |punct3+punct4+backspace|
|înmulțire bloc numeric |punct3+punct5+backspace|
|minus bloc numeric |punct3+punct6+backspace|
|plus bloc numeric |punct2+punct3+punct5+backspace|
|enter bloc numeric |punct3+punct4+punct5+backspace|
|escape bloc numeric |punct1+punct2+punct4+punct5+spațiu, l2|
|tab |punct2+punct5+punct6+spațiu|
|shift+tab |punct2+punct3+punct5+spațiu|
|captură de ecran |punct1+punct3+punct4+punct6+spațiu|
|pauză |punct1+punct4+spațiu|
|aplicații |punct5+punct6+backspace|
|f1 |punct1+backspace|
|f2 |punct1+punct2+backspace|
|f3 |punct1+punct4+backspace|
|f4 |punct1+punct4+punct5+backspace|
|f5 |punct1+punct5+backspace|
|f6 |punct1+punct2+punct4+backspace|
|f7 |punct1+punct2+punct4+punct5+backspace|
|f8 |punct1+punct2+punct5+backspace|
|f9 |punct2+punct4+backspace|
|f10 |punct2+punct4+punct5+backspace|
|f11 |punct1+punct3+backspace|
|f12 |punct1+punct2+punct3+backspace|
|windows |punct1+punct2+punct3+punct4+backspace|
|capslock |punct7+backspace, punct8+backspace|
|bloc numeric |punct3+backspace, punct6+backspace|
|shift |punct7+spațiu, l4|
|Comută la Shift |punct1+punct7+spațiu, punct+4+punct7+spațiu|
|control |punct7+punct8+spațiu, punct1+punct7+punct8+spațiu, punct4+punct7+punct8+spațiu, l5|
|Comută la control |punct1+punct7+punct8+spațiu, punct4+punct7+punct8+spațiu|
|alt |punct8+spațiu, punct1+punct8+spațiu, punct4+punct8+spațiu, l6|
|Comută la alt |punct1+punct8+spațiu, punct4+punct8+spațiu|
|Activează sau dezactivează intrarea simulării tastaturii HID |esytime):l1+joystick1Jos, esytime):l8+joystick1Jos|

<!-- KC:endInclude -->

### Nattiq nBraille Displays {#NattiqTechnologies}

NVDA suportă afișajele de la [Nattiq Technologies](https://www.nattiq.com/) atunci când sunt conectate prin USB.
Windows 10 detectează afișajele braille după conectare, însă poate fi necesară instalarea unor drivere USB dacă utilizați versiuni mai vechi decât Windows 10.
Le puteți descărca de pe site-ul producătorului.

În tabelul de mai jos sunt listate combinațiile de taste atribuite afișajelor Nattiq Technologies pentru NVDA.
Vă rugăm să consultați și documentația acestor afișaje.
<!-- KC:beginInclude -->

| Nume |Tastă|
|---|---|
|derulează afișajul braille înapoi |sus|
|Derulează afișajul braille înainte |jos|
|Mută afișajul braille la rândul precedent |stânga|
|Mută afișajul braille la rândul următor |dreapta|
|Mută la celula braille |mutare|

<!-- KC:endInclude -->

### BRLTTY {#BRLTTY}

[BRLTTY](https://www.brltty.com/) este un program separat care poate fi folosit pentru a suporta multe alte afișaje braille.
Pentru a-l folosi, trebuie să instalați [BRLTTY pentru Windows](https://www.brltty.com/download.html).
Trebuie să descărcați și să instalați ultimul pachet de instalare, care ar trebui să se numească de exemplu, brltty-win-4.2-2.exe.
Când configurați afișajul și portul pe care să-l folosească, aveți grijă să fiți foarte atent la instrucțiuni, în special dacă folosiți un afișaj USB și aveți deja instalat driverul producătorului.

Pentru afișaje care au o tastatură braille, BRLTTY procesează independent intrările braille.
În aceste condiții, configurarea NVDA cu tabelul de intrări braille este irelevantă.

BRLTYY nu este implicat în funcționalitatea NVDA-ului de detectare automată în fundal a afișajelor braille.

Urmează asocierile de comenzi pentru BRLTTY și NVDA.
Vă rugăm să consultați [lista de asocieri de taste BRLTTY](https://mielke.cc/brltty/doc/KeyBindings/) pentru informații despre cum sunt mapate comenzile BRLTTY pe controale ale afișajelor braille.
<!-- KC:beginInclude -->

| Nume |Comandă BRLTTY|
|---|---|
|Derulează afișajul braille înapoi |fwinlt (du-te cu o fereastră la stânga)|
|Derulează afișajul braille înainte |fwinrt (du-te cu o fereastră la dreapta)|
|Mută afișajul braille la rândul anterior |lnup (du-te un rând în sus)|
|Mută afișajul braille la rândul următor |lndn (du-te un rând în jos)|
|Mută la celula braille |route (adu cursorul la caracter)|

<!-- KC:endInclude -->

## Subiecte avansate {#AdvancedTopics}
### Opțiuni în Linie de comandă {#OptiuniLinieComanda}

NVDA poate accepta una sau mai multe opțiuni adiționale, atunci când pornește, care îi pot modifica execuția.
Puteți trimite oricâte opțiuni aveți nevoie.
Aceste opțiuni pot fi trimise atunci când pornirea se face printr-o scurtătură (în proprietățile scurtăturii), din dialogul de Execuție (Meniul Start -> Execută, sau Windows+r) sau dintr-o consolă de comandă Windows.
Opțiunile trebuie separate prin spații de numele fișierului executabil al NVDA și de celelate opțiuni.
De exemplu, o opțiune folositoare este „--disable-addons”, care spune NVDA să suspende toate extensiile add-on care rulează.
Aceasta vă permite să determinați dacă o problemă e cauzată de o extensie add-on și să recuperați sistemul dintr-o problemă serioasă cauzată de un add-on.

Pentru un exemplu, puteți să închideți instanța NVDA care rulează, introducând următoarea linie în fereastra de Execuție:

nvda -q

Unele opțiuni în linie de comandă au atât o variantă scurtă cât și una lungă, iar unele au doar varianta lungă.
Pentru cele care au o variantă scurtă, le puteți combina astfel:

|nvda -mc CONFIGPATH |Aceasta va porni NVDA cu sunetele de pornire dezactivate, cu mesajul dezactivat și cu configurația specificată|
|nvda -mc CONFIGPATH --disable-addons |La fel ca mai sus, dar cu extensiile add-on dezactivate|

Unele opțiuni în linie de comandă acceptă parametrii adiționali; de ex. cât de detaliată să fie scrierea în fișierele jurnal sau calea către dosarul cu configurația utilizatorului.
Acești parametri ar trebui puși după opțiune, separați de opțiune printr-un spațiu atunci când se folosește forma scurtă sau un semn de egalitate (=) când se folosește versiunea lungă; de ex:

|nvda -l 10 |Instruiește NVDA să pornească cu nivelul de scriere în jurnal setat pe „depanare”|
|nvda --log-file=c:\nvda.log |Instruiește NVDA să-și scrie jurnalele la locația C:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Instruiește NVDA să pornească cu nivelul de scriere jurnal  setat pe „info” și să scrie jurnalele în c:\nvda.log|

Urmează opțiunile în linie de comandă ale NVDA:

| Scurtă |Lungă |Descriere|
|---|---|---|
|-h |--help |arată ajutorul pentru linia de comandă și iese|
|-q |--quit |Ieșire din copia NVDA care rulează|
|-r |--replace |Ieșire din copia NVDA care rulează și pornire a acesteia|
|-k |--check-running |Raportează dacă NVDA este pornită prin cod de ieșire; 0 dacă rulează, 1 dacă nu rulează|
|-f LOGFILENAME |--log-file=LOGFILENAME |Fișierul jurnal unde ar trebui scrise mesajele|
|-l LOGLEVEL |--log-level=LOGLEVEL |Nivelul minim pentru mesajele scrise în jurnal (depanare 10, info 20, avertisment 30, eroare 40, critic 50), implicit este avertisment|
|-c CONFIGPATH |--config-path=CONFIGPATH |Locația la care sunt stocate toate configurările pentru NVDA|
|-m |--minimal |Fără sunete, fără interfață, fără mesaje la pornire|
|-s |--secure |Mod securizat (dezactivează consola Python)|
|None |--disable-addons |Extensiile add-on nu vor avea niciun efect|
|None |--debug-logging |Activează diagnosticarea doar pentru această executare. Această setare va suprascrie orice alt nivel de jurnal ( --loglevel, -l) argument dat.|
|None |--no-sr-flag |Indicator „Nu schimba cititorul de ecran la nivel global pentru sistem”|
|None |--install |Instalează NVDA (pornind copia nou instalată)|
|None |--install-silent |Instalează NVDA în mod discret (nu pornește copia nou-instalată)|
|None |--enable-start-on-logon=True|False |La instalare, activează [pornirea în ecranul de autentificare](#StartAtWindowsLogon)|
|None |--create-portable |Creează o copie portabilă a NVDA-ului (pornind copia nou creată). Necesită --portable-path pentru a fi specificată|
|None |--create-portable-silent |Creează o copie portabilă a NVDA-ului (nu pornește copia nou instalată). Necesită --portable-path pentru a fi specificată|
|None |--portable-path=PORTABLEPATH |Calea în care va fi creată o copie portabilă|

### Parametri la nivel de sistem {#ParametriGeneraliSistem}

NVDA permite setarea unor valori în regiștrii de sistem care modifică comportamentul la nivel de sistem al acestuia.
Aceste valori sunt stocate în regiștrii, sub una din următoarele chei:

* Sistem pe 32 de biți: "HKEY_LOCAL_MACHINE\SOFTWARE\nvda"
* Sistem pe 64 de biți: "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\nvda"

Următoarele valori pot fi setate sub această cheie de regiștri:

| Nume |Tip |Valori posibile |Descriere|
|---|---|---|---|
|configInLocalAppData |DWORD |0 (implicit) pentru dezactivare, 1 pentru activare |Dacă e activată, stochează configurația de utilizator a NVDA-ului în datele aplicațiilor locale în locul datelor aplicațiilor de roaming|
|serviceDebug |DWORD |0 (implicit) pentru dezactivare, 1 pentru activare |Dacă este activată, dezactivează modul securizat pe desktop-urile Windows securizate, permițând utilizarea consolei Python și a monnitorului de jurnale. Datorită mai multor implicații majore în materie de securitate, utilizarea acestei opțiuni este puternic descurajată|

## Informații suplimentare {#FurtherInformation}

Dacă aveți nevoie de informații suplimentare sau asistență în privința NVDA, vizitați site-ul internațional în limba engleză la NVDA_URL. 
Aici puteți găsi documentație adițională, precum și asistență tehnică și resurse ale comunității. 
De asemenea, el furnizează informații și resurse privind dezvoltarea NVDA.

Puteți vizita și site-ul comunității românești NVDA la [www.nvda.ro](http://www.nvda.ro). Acest site le oferă vizitatorilor săi tutoriale audio, text,  voci pentru NVDA puse la dispoziția acestora de membrii comunității, dar și modalitatea de a-i contacta pe cei ce se ocupă cu traducerea NVDA-ului și a suplimentelor sale în limba română. De asemenea, comunitatea mai pune la dispoziția utilizatorilor vorbitori de română și o listă de mailing unde aceștia pot să discute și să pună întrebări în legătură cu NVDA și suplimentele sale. Aceasta este <NVDA-romanian-comunity@googlegroups.com>.

