# NVDA NVDA_VERSION Uporabniški Vodič

[TOC]

<!-- KC:title: NVDA NVDA_VERSION Hitra Referenca po Ukazih -->



## Uvod {#Introduction}

Dobrodošli v NVDA!

Non Visual Desktop Access (NVDA) je prost in odprtokoden bralnik zaslona za operacijski sistem Microsoft Windows.
Z opremljanjem povratnih informacij z govorno sintezo in brajico omogoča slepim in slabovidnim, da imajo dostop do računalnika, kjer teče operacijski sistem MS Windows, za isto ceno kot videče osebe.
NVDA razvija [NV Access](https://www.nvaccess.org/) s sodelovanjem skupnosti.

### Splošne Značilnosti {#GeneralFeatures}

NVDA omogoča slepim in osebam s preostankom vida dostop in interakcijo z operacijskim sistemom Windows in veliko programi tretjih izdelovalcev.

Glavni poudarki so:

* Podpora za pogosto uporabljene programe vključno s spletnimi brskalniki, programi za e-pošto, programi za neposredno klepetanje in pisarniškimi zbirkami
* Vgrajena govorna sinteza, ki podpira več kot 80 jezikov
* Poročanje o postavitvi besedila, kjer je to mogoče; na primer velikost in ime pisave, slogovne in črkovne nepravilnosti
* Samodejno obvestilo o besedilu pod miško in zvočna indikacija o položaju miške, če to želite
* Podpora za precejšnje število brajevih vrstic vključno s podporo vnosa v brajici za vrstice, ki vsebujejo brajevo tipkovnico ter samodejno zaznavo večine izmed njih
* Možno uporabljati preko USB ključka ali drugega prenosljivega medija brez potrebe po namestitvi v računalnik
* Govorna podpora ob namestitvi v sistem
* Prevedeno v 54 jezikov
* Podpora za aktualne Windows operacijske sisteme tako 32-bitne kot 64-bitne
* Možno poganjati med vpisom v Windows in na "varnih" namizjih
* Naznanjanje kontrolnikov in besedila med uporabo kretenj dotika
* Podpora za več vmesnikov za prilagoditev na primer Microsoft Active Accessibility, Java Access Bridge, IAccessible2 in UI (UV) Automation
* Podpora Windows Ukaznemu pozivu in programom v konzoli
* Zmožnost poudariti sistemsko žarišče

### Internacionalizacija {#Internationalization}

Pomembno je, da imajo ljudje neglede na to, kateri jezik govorijo, enak dostop do tehnologije.
Poleg Angleščine, je NVDA prevedena v 54 jezikov vključno z: Afrikanščino, Albanščino, Amhariščino, Arabščino, Aragonščino, Bolgarščino, Burmanščino, Češčino, Danščino, Finščino, Francoščino, Galicijščino, Grščino, Gruzinščino, Hebrejščino, Hindijščino, Hrvaščino, Islandščino, Irščino, Italijanščino, Japonščino, jezik Kannada, Katalonščino, Kirgizijščino, Kitajščino (poenostavljeno in tradicionalno) Korejščino, Letonščino, Madžarščino, Makedonščino, Nepalščino, Nemščino (Nemčija in Švica), Nizozemščino, Norveščino, Perziščino, Poljščino, Portugalščino (Brazilija in Portugalska), Punjabi, Romunščino, Ruščino, Slovaščino, Slovenščino, Srbščino, Španščino (Kolumbija in Španija), Švedščino, Tamilščino, Tajščino, Turščino, Ukrajinščino in Vietnamščino.

### Podpora Govorni sintezi {#SpeechSynthesizerSupport}

Ločeno od podajanja sporočil in vmesnika v naštetih jezikih, NVDA omogoča uporabnici/ku, da bere vsebino v kateremkoli jeziku tako dolgo, dokler ima na računalniku nameščeno govorno sintezo za izbran jezik.

NVDA prihaja skupaj z govorno sintezo [ESpeak NG](https://github.com/espeak-ng/espeak-ng), prosto in odprtokodno, večjezično, govorno sintezo.

Informacije o drugih govornih sintezah, ki jih podpira NVDA, lahko najdete v razdelku [Podprte Govorne Sinteze](#SupportedSpeechSynths) tega vodiča.

### Podpora Brajici {#BrailleSupport}

Za tiste, ki posedujejo brajevo vrstico, NVDA lahko prikazuje sporočila in druge aktivnosti tudi na njih.
Podprt je tudi vnos prek brajeve tipkovnice in sicer tako način tipkanja s krajšavami kot normalen vnos.
Še več, NVDA bo privzeto samodejno prepoznala večino od njih.
Prosimo, oglejte si razdelek [Podprte Brajeve Vrstice](#SupportedBrailleDisplays) za več informacij o podprtih brajevih vrsticah.

NVDA podpira precej brajevih kodnih tabel vključno z računalniškimi, kratkopisnimi in normalnimi za veliko jezikov.

### Licenca in Avtorske Pravice {#LicenseAndCopyright}

Avtorske pravice NVDA_COPYRIGHT_YEARS nad NVDA pripadajo NVDA sodelujočim.

NVDA je na voljo pod pogoji GNU Splošne Javne Licence (druga različica) z dvema posebnima izjemama.
Izjemi sta orisani v dokumentu z licenco v razdelkih "Non-GPL Components in Plugins and Drivers" in "Microsoft Distributable Code".
NVDA vključuje in uporablja tudi komponente, ki jih dajejo izdajatelji na voljo pod drugimi prostimi in odprtokodnimi licencami.
Ta program lahko spreminjate ali delite na okoli, na kakršenkoli način želite,vse dokler ga spremlja omenjena licenca in dajete izvorno kodo na voljo vsakomur, ki to želi.
To se nanaša tako na pristno izdajo, kot spremenjene kopije tega programa in tudi na izpeljanke.

Več podrobnosti je na voljo [na strani z besedilom licence.](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html)
Za podrobnosti glede izjem dostopite do dokumenta z licenco iz menija NVDA v razdelku "pomoč".

## Sistemske Zahteve {#SystemRequirements}

* Operacijski Sistemi: vse 32-bitne in 64-bitne različice sistema Windows 7, 8, 8.1 in 10 in vse Strežniške različice od Windows Server 2008 R2 naprej.
 * V sistemu Windows 7 mora biti nameščen prvi paket popravkov ali novejši, da bo NVDA lahko delovala.
 * V sistemu Windows Server 2008 R2 mora biti nameščen prvi paket popravkov ali novejši, da bo NVDA lahko delovala.
* Pomnilnik: 256 MB RAMa ali več
* Procesorska hitrost: 1,0  GHz ali hitrejši
* Približno 90 MB prostora na disku

## Kako Dobiti in Postaviti NVDA {#GettingAndSettingUpNVDA}

Če še nimate svoje kopije NVDA, jo lahko snamete s: [spletišča NV Access](NVDA_URL).

Pojdite na razdelek download in tam boste našli povezavo za prenos najnovejše različice NVDA.

Ko boste preneseno datoteko prvič zagnali, se bo namestila začasna kopija NVDA.
Potem vas bomo vprašali, če želite NVDA namestiti na vaš računalnik, izdelati prenosljivo kopijo na vaš USB ključ ali želite zgolj uporabljati to začasno kopijo.

Če želite NVDA vedno uporabljati na izbranem računalniku, potem boste želeli izbrati Namesti NVDA na ta računalnik.
Namestitev NVDA na računalnik vam omogoča med drugim interakcijo med vpisom in na varnih namizjih ter samodejni zagon po vpisu, kar ni možno, če imate prenosljivo ali začasno kopijo. Poleg tega omogoča tudi ustvarjanje programskega sklopa v začetnem meniju (meniju Start) in bližnjice na namizju.
Nameščena kopija NVDA omogoča, da si sami iz nje kadarkoli izdelate prenosljivo kopijo. 

Če želite s seboj vzeti NVDA na USB ključku ali drugem zapisljivem mediju, potem morate izbrati ustvari prenosljivo kopijo.
Prenosljiva kopija omogoča kasnejšo samonamestitev na izbranem računalniku.
Kakorkoli, če želite NVDA preslikati na medij, ki je samo za branje (CD ali drug), potem na medij zapišite samo paket, ki ste ga prenesli.
Poganjanje z medija, ki je samo za branje, trenutno ni podprto.

Možno je uporabiti tudi začasno kopijo (na primer za demonstracijske prikaze), čeprav je pot zagona NVDA v tem načinu precej dolga.

### Omejitve Začasne in Prenosljive Kopije {#PortableAndTemporaryCopyRestrictions}

Ločeno od tega, da se NVDA ne more samodejno zagnati pred in/ali po prijavi, imata prenosljiva in začasna kopija še naslednje omejitve:

* Nezmožnost biti v interakciji s programi, ki tečejo s skrbniškimi pravicami, dokler seveda tudi NVDA sama ne teče z istimi pravicami (ni priporočljivo).
* Nezmožnost branja zaslonov Nadzora Uporabniškega računa (NURR), ko se poskuša zagnati program s skrbniškimi pravicami.
* Windows 8 in kasnejši: nezmožnost podpirati vnos preko zaslona na dotik.
* Windows 8 in kasnejši: nezmožnost oskrbeti značilnosti, kot so, recimo, Brskalniško delovanje in izgovor natipkanih znakov v Trgovini Windows programčkov.
* Windows 8 in kasnejši: Stišanje ostalih zvokov, ko NVDA govori, ni podprto.

### Namestitev NVDA {#InstallingNVDA}

Če nameščate NVDA neposredno s paketa, ki ste ga prenesli na sistem, potem pritisnite gumb Namesti NVDA.
Če ste že zaprli to pogovorno okno ali pa želite namestiti NVDA iz prenosljive kopije, potem izberite menijsko postavko Namesti NVDA, ki jo najdete pod Orodji v meniju NVDA.

Pogovorno okno namestitve, ki se prikaže, potrdi, ali želite namestiti NVDA in pove tudi ali bo ta namestitev posodobila prejšnjo namestitev.
S pritiskom na gumb Nadaljuj, boste sprožili nameščanje NVDA.
V tem pogovornem oknu je še nekaj možnosti, ki jih ta priročnik razloži v nadaljevanju.
Ko se namestitev zaključi, se prikaže sporočilo o tem, da je namestitev uspešna.
Pritisk na gumb V redu na tej točki bo ponovno zagnal na novo nameščeno kopijo NVDA.

#### Opozorilo o nezdružljivih dodatkih {#InstallWithIncompatibleAddons}

Če imate že nameščene dodatke, se vam lahko pokaže opozorilo, da se bodo nezdružljivi dodatki onemogočili.
Preden boste lahko pritisnili gumb Nadaljuj, boste morali uporabiti izbirnik za potrditev, da razumete, da se bodo ti dodatki onemogočili.
Tukaj je tudi gumb, ki vam omogoči pregled dodatkov, ki se bodo onemogočili.
Oglejte si [razdelek s pogovornim oknom nezdružljivih dodatkov](#incompatibleAddonsManager) za več pomoči za ta gumb.

#### Uporabi NVDA ob Vpisu v Windows {#StartAtWindowsLogon}

Ta možnost omogoča, da se lahko NVDA samodejno zažene medtem, ko se vam ponudi okno za vpis, še pred vnosom gesla.
To vključuje tudi Nadzor Uporabniških Računov in druga "varna" namizja.
Ta možnost je privzeto omogočena za sveže namestitve.

#### Ustvari Bližnjico na Namizju (ctrl+alt+a) {#CreateDesktopShortcut}

Ta možnost omogoča izbiro, če želite, da mora NVDA ustvariti bližnjico na namizju za zagon NVDA.
Ta bližnjica, če jo boste ustvarili, bo ustvarila tudi kombinacijo bližnjičnih tipk za zagon control+alt+a. S to kombinacijo tipk boste potem lahko NVDA zagnali, kadarkoli boste želeli.

#### Preslikaj Prenosljivo Konfiguracijo na Trenuten Uporabniški Račun {#CopyPortableConfigurationToCurrentUserAccount}

Ta možnost vam omogoča izbiro, ali mora ali pa ne, NVDA preslikati trenutno uporabniško konfiguracijo v uporabi v konfiguracijo trenutno vpisanega uporabnika za nameščeno kopijo NVDA.
To ne bo preslikalo konfiguracije k ostalim uporabnikom tega sistema in niti ne bo preslikalo konfiguracije, ki se uporablja ob vpisu v Okna in drugih varnih namizjih.
Ta možnost je na voljo samo ob namestitvi  s prenosljive kopije in ni na voljo ob namestitvi s pomočjo namestitvenega paketa, ki ste ga prenesli.

### Ustvarjanje Prenosljive Kopije {#CreatingAPortableCopy}

Če ustvarjate prenosljivo kopijo neposredno iz prenesenega paketa, preprosto pritisnite gumb Ustvari Prenosljivo Kopijo.
Če ste že zaprli to pogovorno okno ali pa delate z že nameščeno kopijo NVDA, izberite menijsko postavko Ustvari Prenosljivo kopijo, ki jo najdete v podmeniju Orodja NVDA menija.

Pogovorno okno, ki se prikaže, vam omogoča, da izberete, kje naj se prenosljiva kopija ustvari.
To je lahko  imenik na vašem trdem disku, mesto na USB Ključku ali na drugem prenosljivem mediju.
Tukaj je tudi možnost izbire,ali bi  NVDA morala ali pa ne,preslikati konfiguracijo trenutno prijavljenega uporabnika za uporabo v novo ustvarjeni prenosljivi kopiji.
Ta možnost je na voljo samo v nameščeni kopiji. Ta ni na voljo v prenesenem paketu.
Pritisk gumba Nadaljuj bo začel proces ustvarjanja prenosljive kopije.
Ko je ustvarjanje končano, se bo prikazalo sporočilo, ki bo povedalo, da je bilo ustvarjanje uspešno.
Pritisnite V redu, da zaprete to pogovorno okno.

## Kako začeti z NVDA {#GettingStartedWithNVDA}
### Zagon NVDA {#LaunchingNVDA}

Če ste namestili NVDA iz namestitvenega paketa, potem je zagon NVDA preprost. Zaženete jo lahko s pritiskom kombinacije tipk control+alt+a ali pa z izbiro menija NVDA v Začetnem meniju, kjer razprete seznam vseh nameščenih programov.
Kot dodatno možnost lahko uporabite pogovorno okno Zaženi, kjer vnesete NVDA in pritisnete Enter.
Če je NVDA v pogonu, se bo ponovno zagnala.
Lahko podate tudi nekaj [možnosti v ukazni vrstici,](#CommandLineOptions) ki vam omogočajo izhod iz NVDA (-q), onemogočanje dodatkov (--disable-addons) in drugo.

Za nameščene kopije, NVDA privzeto hrani konfiguracijo v mapi sleddenja programskih datotek trenutnega uporabnika (npr. "C:\Users\<uporabnik>\AppData\Roaming").
To je možno spremeniti na način, da NVDA naloži svojo konfiguracijo iz mape z lokalnimi programskimi podatki.
Oglejte si razdelek o [splošnih sistemskih parametrih](#SystemWideParameters) za več podrobnosti.

Za zagon prenosljive kopije pojdite v imenik, kjer ste ustvarili prenosljivo kopijo NVDA in pritisnite Enter nad NVDA.exe ali to ikono dvakrat kliknite.
Če je bila NVDA že v pogonu, se bo samodejno zaustavila pred zagonom prenosljive različice.

Ko se bo NVDA zagnala, boste slišali višajoč skupek tonov,  (ki povedo, da se NVDA nalaga).
Odvisno od tega, kako hiter je vaš računalnik, ali teče NVDA preko USB ključka ali drugega počasnejšega medija, lahko mine nekaj trenutkov, da se NVDA zažene.
Če zaganjanje traja izjemno dolgo, potem bi morala NVDA sporočiti: "Nalaganje NVDA. Prosimo, počakajte..."

Če ne slišite nič od tega, ali slišite Windows Zvok  "Napaka", ali nižajočo kombinacijo tonov, potem to pomeni, da je v NVDA napaka. To pomeni, da boste morda morali sporočiti "hrošča" razvijalcem.
Prosimo, preglejte spletno mesto NVDA, da izveste, kako to narediti.

#### Pogovorno okno Dobrodošlice {#WelcomeDialog}

Ko se NVDA zažene prvič, vas bo pozdravilo pogovorno okno, ki vas bo oskrbelo z nekaj osnovnimi informacijami o NVDA prikrojevalni tipki in o NVDA meniju.
(Prosimo, glejte nadaljne razdelke o teh temah.)
Pogovorno okno vsebuje tudi spustni seznam in tri izbirnike.
Na spustnem seznamu lahko določite, katero obliko tipkovnice boste uporabljali.
Prvi izbirnik sprašuje, če naj NVDA obravnava Caps Lock kot NVDA prikrojevalno tipko.
Drugi določa ali naj se NVDA po prijavi v Windows zažene samodejno in je na voljo samo za namestitvene kopije NVDA.
Tretji sprašuje, če naj se to pogovorno okno pokaže vedno, ko se NVDA zažene.

#### Pogovorno okno uporabe statističnih podatkov {#UsageStatsDialog}

Od različice NVDA 2018.3, se uporabnike naproša, če  bi želeli dovoliti poslati podatke o uporabi organizaciji NV Access kot pomoč za izboljšanje NVDA v prihodnosti. 
Ob prvem zagonu  NVDA se bo prikazalo pogovorno okno, ki vas bo zaprosilo za vaše soglasje k pošiljanju podatkov NV Access med uporabo NVDA.
Več o zbiranju podatkov s strani NV Access lahko preberete in dobite informacije v razdelku Splošno v [Dovoli projektu NVDA zbiranje statistike rabe NVDA](#GeneralSettingsGatherUsageStats).
Pomnite: pritisk na "da" ali "ne" bo shranil to nastavitev in pogovorno okno se ne bo prikazalo nikdar več razen, če boste NVDA ponovno namestili.
Toda vi lahko ročno omogočite ali onemogočite potek zbiranja podatkov na plošči splošnih nastavitev za NVDA. Za ročno spremembo te nastavitve lahko izberete ali odznačite izbirnik, ki se imenuje [Dovoli projektu NVDA zbiranje statistike rabe NVDA](#GeneralSettingsGatherUsageStats).

### O NVDA tipkovničnih ukazih {#AboutNVDAKeyboardCommands}
#### NVDA Prikrojevalna Tipka {#TheNVDAModifierKey}

Večina NVDA-posebnih tipkovničnih ukazov sestoji iz pritiska posebne tipke imenovane prikrojevalna tipka NVDA v kombinaciji z eno ali več ostalimi tipkami.
Posebna izjema pri tem so ukazi za pregledovanje besedila na običajni razporeditvi tipk, ki uporabljajo samo tipke na številskem delu tipkovnice, Obstajajo pa tudi druge izjeme.

NVDA se lahko nastavi tako, da se uporablja Glavni Insert, številski Insert, lahko pa tudi Caps Lock kot prikrojevalna NVDA tipka.
Privzeto velja, da sta tako številski kot Glavni Insert prikrojevalni NVDA tipki.

Če želite, da se ena od prikrojevalnih NVDA tipk obnaša kot je prvotno predvideno (npr. želite vključiti tipko Caps Lock, ko je Capslock nastavljena kot prikrojevalna tipka NVDA), potem izbrano tipko pritisnite dvakrat v hitrem zaporedju.

#### Postavitve Tipkovnice {#KeyboardLayouts}

Trenutno NVDA prihaja z dvema paketoma tipkovničnih ukazov, ki jih poznamo pod pojmom postavitve tipkovnice, kjer obstaja postavitev za običajne tipkovnice (s številskim delom) in postavitev za prenosnike.
Privzeto je NVDA nastavljena tako, da uporablja običajno postavitev tipk. Vedno pa lahko zamenjate postavitev tipk v zvrsti Tipkovnica v pogovornem oknu [Nastavitve NVDA](#NVDASettings), ki jo najdete pod Izbirami v NVDA meniju.

Običajna postavitev se močno zanaša na številski del tipkovnice, kjer je Num Lock izključen.
Čeprav večina prenosnikov nima fizičnega številskega dela, nekateri prenosniki lahko tega oponašajo tako, da držite tipko FN in pritiskate črke in številke na desnem delu tipkovnice (7, 8, 9, u, i, o, j, k, l, itn).
Če vaš prenosnik ne more tega narediti ali vam ne omogoča izklopa številk na številskem delu, potem boste morda želeli preklopiti na postavitev prenosnik namesto običajne postavitve.

### NVDA Kretnje Dotika {#NVDATouchGestures}

Če poganjate NVDA na napravi z zaslonom na dotik na operacijskem sistemu Windows 8 ali novejšem, lahko NVDA nadzirate tudi neposredno preko zaslona na dotik.
Medtem, ko je NVDA vključena, bodo vsi dotiki zaslona šli neposredno na NVDA.
Torej dejavnosti, ki se izvajajo normalno brez NVDA, ne bodo delovale.

#### Raziskovanje Zaslona {#ExploringTheScreen}

Najbolj osnovna dejavnost, ki jo lahko izvedete z zaslonom na dotik, je naznanilo nadzora ali besedila na katerikoli točki zaslona.
Če želite to narediti, postavite prst kamorkoli na zaslon.
Lahko pa tudi obdržite prst na zaslonu in ga pomikate naokoli, da prebirate ostale možnosti nadzora ali besedilo , ki se nahaja pod prstom, ko se sprehajate nad njim.

#### Kretnje Dotika {#TouchGestures}

Ko bodo NVDA ukazi opisani pozneje v tem vodiču, le ti lahko vsebujejo tudi kretnjo dotika, ki se lahko uporabi za sprožitev tega ukaza z zaslonom na dotik.
Sledi nekaj napotkov, kako ravnati z različnimi kretnjami dotika.

##### Tapi {#toc27}

Hitro se dotaknite zaslona z eno ali več prstnimi konicami.

Dotiku z enim prstom se preprosto pravi tap.
Dotiku z dvema prstoma istočasno se pravi dvoprstni tap in podobno.

Če se enak tap izvede enkrat ali večkrat znova v hitrem zaporedju, bo NVDA obravnavala namesto tega to kot več-dotikabilno kretnjo.
Če se boste zaslona dotaknili dvakrat, bo to rezultiralo v dvojnem tapu ali dotiku.
Trikratni dotik zaslona bo rezultiral v trojnem dotiku in podobno.
Seveda, te večprstne kretnje zaznavajo tudi, koliko prstov uporabljate. Tako je možno, da imamo kretnje kot je dvoprstni trojni dotik (tap), štiriprstni dotik, itn.

##### Švigi {#toc28}

Hitro potegnite s prstom po zaslonu.

Obstajajo štiri kretnje s švigi odvisno od smeri: švig levo, švig desno, švig gor in švig dol.

Tako kot pri dotikih, lahko kretnjo izvedemo z enim ali več prsti.
Torej kretnji, kot sta dvoprstni švig gor ali štiriprstni švig gor, sta možni poleg drugih.

#### Delovanja Dotika {#TouchModes}

Ker je precej več ukazov, kot mogočih kretenj dotika, ima NVDA več možnih načinov delovanj dotika, med katerimi lahko preklapljate, kar prinaša določene podvrste ukazov, ki so navolja za upravljanje na dotik.
Dve delovanji sta delovanje besedila in predmetno delovanje.
Določeni NVDA ukazi, ki so razvrščeni v tem dokumentu, lahko imajo delovanje dotika zapisano v oklepajih za kretnjo dotika.
Na primer švig gor (delovanje besedila) pomeni, da se bo ukaz izvedel toda samo, ko bo NVDA v delovanju besedila.
Če ukaz ne vsebuje podatka o delovanju, potem velja, da deluje v kateremkoli načinu delovanja.

<!-- KC:beginInclude -->
Za preklop med delovanji dotika izvedite troprstni dotik.
<!-- KC:endInclude -->

#### Tipkovnica na dotik {#TouchKeyboard}

Tipkovnica na dotik se uporablja za vnos besedila in ukazov prek zaslona na dotik.
Ko je v žarišču vnosno polje, lahko tipkovnico na dotik prikličete z dvojnim tapom na ikono tipkovnice na dotik na dnu zaslona.
Na tablicah, kot je Microsoft Surface Pro, je tipkovnica na dotik vedno na voljo, ko je navadna tipkovnica izpeta.
Ko boste želeli, da tipkovnica na dotik izgine, izvedite dvojni tap na ikoni tipkovnice na dotik ali se pomaknite izven polja za urejanje.

Ko je tipkovnica na dotik dejavna, za lociranje tipk na tipkovnici na dotik pomaknite vaš prst na mesto, kjer je postavljena tipkovnica na dotik (običajno na dnu ekrana), potem pa pomikajte en prst naokoli po tipkovnici.
Ko boste našli tipko, ki jo želite pritisniti, izvedite dvojni tap nad tipko ali dvignite prst, odvisno od izbranih možnosti v zvrsti [Nastavitev Interakcije z Dotikom](#TouchInteraction).

### Delovanje Pomoči za Vnose {#InputHelpMode}

Veliko NVDA ukazov je opisanih skozi ta uporabniški vodič, vendar je še lažja pot za raziskovanje teh ukazov ta, da se vključi delovanje pomoči za vnose.

Če želite vključiti delovanje pomoči za vnose, pritisnite NVDA+1.
Če to delovanje želite izključiti, ponovno pritisnite NVDA+1.
Ko ste v delovanju pomoči za vnose, bo vsak vnos ali kretnja, kot sta pritisk na tipko na tipkovnici ali gesta po zaslonu na dotik, povzročila povratni odziv v obliki sporočila, kateri vnos se je naredil in kaj dotična kretnja pomeni, če kaj.
Aktualni ukazi se ne bodo izvedli, ko ste v delovanju pomoči za vnose.

### NVDA Meni {#TheNVDAMenu}

NVDA meni omogoča nadzor nad nastavitvami NVDA, dostop do pomoči, shranjevanje in obnavljanje vaše konfiguracije, spreminjanje slovarjev govora, dostop do dodatnih orodij in izhod iz NVDA.

Če želite dobiti NVDA meni na zaslon od kjerkoli v sistemu, medtem, ko NVDA teče, Pritisnite NVDA+n na tipkovnici ali izvedite dvoprstni dvojni tap na zaslonu na dotik.
Do menija NVDA lahko dostopate tudi skozi Območje za obvestila.
Neglede na to ali do NVDA menija dostopate preko desnega miškinega klika na sistemskem pladnju Oken ali pa dostopate do sistemskega pladnja s pomočjo pritiska Windows logo tipke+b, pritiskajte puščico dol do ikone NVDA in pritisnite tipko Applications, ki se nahaja zraven tipke desni control na večini tipkovnic.
Ko se meni dvigne, lahko uporabljate puščice za premikanje med menijskimi postavkami in tipko Enter za potrditve in prožitve izbranih možnosti.

### NVDA Osnovni ukazi {#BasicNVDACommands}

<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Dotik |Opis|
|---|---|---|---|---|
|Ustavi Govor |Control |control |dvoprstni enojni tap |Takoj ustavi govorjenje|
|Začasno ustavi Govor |shift |shift |brez |Takoj začasno zaustavi govorjenje. Ponovni pritisk bo sprožil pripovedovanje od mesta, kjer se je začasno ustavilo, če trenutna sinteza to podpira.|
|NVDA Meni |NVDA+n |NVDA+n |dvoprstni dvojni tap |Dvigne meni NVDA, kar vam omogoči dostop do nastavitev, orodij, pomoči in drugih elementov.|
|Stikalo Delovanj Govora |NVDA+s |NVDA+s |brez |Preklaplja med različnimi delovanji govora. To so govor, zvočni signali ali izključitev.|
|Stikalo Delovanja Pomoči za Vnose |NVDA+1 |NVDA+1 |brez |Pritisk katerekoli tipke v tem načinu delovanja bo sprožil poročanje o tem, katero tipko se je pritisnilo in opis kateregakoli NVDA ukaza, ki je povezan s tipko, ki ste jo pritisnili.|
|Izhod iz NVDA |NVDA+q |NVDA+q |brez |Zapre NVDA.|
|Pusti naslednjo tipko skozi |NVDA+f2 |NVDA+f2 |brez |Pove NVDA naj naslednji pritisk spusti skozi naravnost k aplikaciji, ki je sedaj odprta, čeprav se to običajno obravnava kot NVDA ukaz.|
|Stikalo za vklop/izklop Delovanja Spanja Programa |NVDA+shift+s |NVDA+shift+z |brez |Delovanje spanja onemogoči vse NVDA ukaze in podajanje sporočil v govoru ali brajici za sedanjo aplikacijo. To je zelo uporabno v aplikacijah, ki same oskrbijo govorne ali zmožnosti branja zaslona. Pritisnite ta ukaz znova, da onemogočite delovanje spanja. Pomnite, da bo NVDA obdržala Nastavitev Spanja samo do naslednjega zagona NVDA.|

<!-- KC:endInclude -->

### Poročanje o Sistemskih Informacijah {#ReportingSystemInformation}

<!-- KC:beginInclude -->

| Ime |tipka |Opis|
|---|---|---|
|Sporoči Datum in Čas |NVDA+f12 |Enojni pritisk sporoči trenutni čas, dvojni pa trenutni datum.|
|Sporoči stanje baterije |NVDA+shift+b |Poroča o stanju baterije t.j. ali se računalnik napaja iz električnega napajanja ali koliko odstotkov baterije je še na voljo|
|Poročaj o Besedilu v Odložišču |NVDA+c |Poroča o besedilu v odložišču, če ga je kaj.|

<!-- KC:endInclude -->

## krmiljenje z NVDA {#NavigatingWithNVDA}

NVDA vam omogoča, da raziskujete in krmilite po sistemu na različne načine vključno z normalno interakcijo in pregledom.

### Predmeti {#Objects}

Vsako aplikacijo in operacijski sistem sam sestavlja veliko predmetov. 
Predmet je samostojna postavka, kot je del besedila, gumb, izbirnik, drsnik, seznam ali polje za urejanje ali vnos besedila.

### krmiljenje s Sistemskim Žariščem {#SystemFocus}

Sistemsko žarišče poznano tudi kot žarišče (fokus) je [predmet](#Objects), ki sprejema vnose iz tipkovnice.
Na primer, če tipkate v vnosno polje za urejanje besedila, je to vnosno polje v žarišču.

Najbolj običajne poti krmiljenja po oknih z NVDA so preprost premik sistemskega žarišča z uporabo standardnih tipkovničnih ukazov, kot so tab in shift+ tab za premik naprej in nazaj med kontrolniki, pritisk tipke alt za postavitev v menijsko vrstico, puščice za premik v menijih in uporaba  alt+tab za premikanje med trenutnimi odprtimi aplikacijami. 
Ko to izvajate, vam NVDA sporoča informacije o predmetu v žarišču, kot je njegovo ime, tip, vrednost, stanje, opis, bližnjična tipka in informacija o položaju.
Ko boste omogočili še [Poudarek Žarišča,](#VisionFocusHighlight) se bo položaj sistemskega žarišča osvetljil in ga bo mogoče videti na ekranu.

Tu je nekaj ukazov, ki so uporabni pri krmiljenju sistemskega žarišča:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Opis|
|---|---|---|---|
|Sporoči trenutni položaj žarišča |NVDA+tab |NVDA+tab |naznani trenutni predmet ali kontrolnik, ki je v žarišču. Dvojni pritisk bo informacijo črkoval|
|Sporoči naslov |NVDA+t |NVDA+t |Poroča o naslovu trenutno aktivnega okna. Dvojni pritisk bo črkoval to informacijo. Trojni pritisk bo informacijo preslikal v odložišče|
|Beri aktivno okno |NVDA+b |NVDA+b |prebere kontrolnike v trenutno aktivnem oknu(uporabno pri obrazcih)|
|Poročaj o Vrstici Stanja |NVDA+end |NVDA+shift+end |Poroča o vrstici stanja, če jo NVDA najde. Ta ukaz tudi premakne predmet krmiljenja na ta položaj. Dvojni pritisk informacijo črkuje, trojni pritisk pa vsebino vrstice preslika v odložišče|

<!-- KC:endInclude -->

### krmiljenje s Sistemsko Kazalko {#SystemCaret}

Ko je [predmet](#Objects), ki omogoča krmiljenje in/ali urejanje besedila, v [žarišču](#SystemFocus), se lahko premikate po besedilu z uporabo sistemske kazalke poznano tudi kot urejevalno utripalko.

Ko je žarišče na predmetu, ki vsebuje sistemsko kazalko, lahko uporabljate smerne tipke, stran gor/stran dol, (PGUP/PGDN), Začetek (home), Konec (end) in druge možnosti za pomikanje po besedilu.
Lahko tudi spreminjate besedilo, če kontrolnik podpira urejanje.
NVDA bo sporočila, ko se boste premikali po besedilu znak po znak, besedo po besedo ali vrstico po vrstico. Sporočeno bo tudi, če je besedilo označeno ali ne.

NVDA vas oskrbuje z naslednjimi ukazi glede na sistemsko kazalko:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Opis|
|---|---|---|---|
|Izgovori vse |NVDA+Puščica dol |NVDA+a |Začne brati od trenutnega položaja sistemske kazalke, se premikajoč tako kot sistemska kazalka|
|Preberi trenutno vrstico |NVDA+Puščica gor |NVDA+l |Prebere vrstico, kjer je trenutno postavljena sistemska kazalka. Dvojni pritisk vrstico črkuje in trojni pritisk jo črkuje s pomočjo opisov znakov.|
|Preberi trenutno besedilno označbo |NVDA+Shift+Puščica gor |NVDA+shift+s |Prebere vsako besedilo, ki je trenutno označeno|
|Naslednji stavek |alt+puščica dol |alt+puščica dol |Premakne kazalko na naslednji stavek in ga izgovori. (trenutno na voljo samo v Microsoft Wordu in Outlooku)|
|Predhodni stavek |alt+puščica gor |alt+puščica gor |Premakne kazalko na predhodni stavek in ga izgovori. (trenutno na voljo samo v Microsoft Wordu in Outlooku)|

Ko se nahajate v tabeli, so na voljo tudi sledeči ukazi:

| Ime |Tipka |Opis|
|---|---|---|
|Premik v predhodni stolpec |control+alt+Puščica levo |Premakne sistemsko kazalko v predhodni stolpec (vrstica ostaja ista)|
|Premik v naslednji stolpec |control+alt+Puščica desno |Premakne sistemsko kazalko v naslednji stolpec (vrstica ostaja ista)|
|Premik v predhodno vrstico |control+alt+Puščica gor |Premakne sistemsko kazalko v prejšnjo vrstico (stolpec ostaja isti)|
|Premik v naslednjo vrstico |control+alt+Puščica dol |Premakne sistemsko kazalko v naslednjo vrstico (stolpec ostaja isti)|

<!-- KC:endInclude -->

### krmiljenje po Predmetih {#ObjectNavigation}

Največ časa boste delali s programi z uporabo ukazov, ki premikajo [žarišče](#SystemFocus) in [kazalko](#SystemCaret).
Kakorkoli, včasih želite raziskati program ali operacijski sistem brez premika kazalke ali žarišča.
Lahko si zaželite tudi delati s [predmeti](#Objects), ki po navadi niso dostopni z uporabo tipkovnice.
V takih primerih lahko uporabite krmiljenje po predmetih.

krmiljenje po predmetih vam omogoča premikanje med in zajemanje informacij o posameznih [predmetih](#Objects).
Ko se premaknete na predmet, bo NVDA to poročala tako, kot to dela ob sistemskem žarišču.
Za pregled vsega besedila, kot izgleda na zaslonu, lahko namesto tega uporabite [pregled zaslona](#ScreenReview).

Vsakič, ko se premikate nazaj in naprej med predmeti, se pomikate med predmeti na isti ravni, ker so predmeti v sistemu organizirani v hierarhiji.
To pomeni, da nekateri predmeti vsebujejo druge predmete in tako morate vstopiti v prve predmete, da dobite dostop do drugih.
Na primer, seznam vsebuje postavke, kar pomeni, da morate vstopiti na seznam, da lahko vidite njegovo vsebino.
Če ste vstopili na seznam, premik naprej ali nazaj pomeni pomik naprej in nazaj med postavkami tega seznama.
Premik na postavko na seznamu, ki vsebuje nov predmet, vas bo postavil nazaj na seznam.
Tako se potem lahko pomikate po prejšnjem seznamu, če želite dostopiti do drugih predmetov.
Podobno je z orodno vrstico, ki vsebuje kontrolnike. Tako morate vstopiti na orodno vrstico za dostop do kontrolnikov.

Predmet, ki ga pravkar pregledujete, nosi ime predmet krmiljenja.
Ko se enkrat premaknete na predmet, njegovo vsebino lahko pregledujete z uporabo [ukazov za pregled besedila](#ReviewingText) medtem, ko ste v [Delovanju pregleda predmeta](#ObjectReview).
Ko boste omogočili še [Poudarek Žarišča,](#VisionFocusHighlight) se bo položaj predmeta krmiljenja osvetljil in ga bo mogoče videti na ekranu.
Privzeto vedenje je nastavljeno tako, da sistemsko žarišče potuje vzdolž predmeta krmiljenja, to stikalo pa lahko vključite ali izključite.

+Pomnite: Sledenje braajice Krmiljenju Predmeta se lahko nastavi prek [Navezave Brajice](#BrailleTether).

Za pomik po predmetih, uporabite naslednje ukaze:

<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Dotik |Opis|
|---|---|---|---|---|
|Poročaj o trenutnem predmetu |NVDA+številski del5 |NVDA+shift+o |brez |Sporoča kateri predmet je trenutno predmet krmiljenja. Dvojni pritisk informacijo črkuje in trojni pritisk ime predmeta ter njegovo vrednost preslika v odložišče.|
|Premakni se na predmet z vsebino |NVDA+številski del8 |NVDA+shift+Puščica gor |švig gor (delovanje predmeta) |Premik na predmet, ki vsebuje trenutni predmet krmiljenja|
|Premakni se na predhodni predmet |NVDA+številski del4 |NVDA+shift+Puščica levo |švig levo (delovanje predmeta) |Premik pred trenuten predmet krmiljenja|
|Premakni se na naslednji predmet |NVDA+številski del6 |NVDA+shift+Puščica desno |švig desno (delovanje predmeta) |Premik na predmet za  trenutnim predmetom krmiljenja|
|Premakni se na prvi predmet z vsebino |NVDA+številski del2 |NVDA+shift+Puščica dol |švig dol (delovanje predmeta) |Premik na prvi predmet, ki je del vsebine trenutnega predmeta krmiljenja|
|Premakni se na predmet v žarišču |NVDA+številski delMinus |NVDA+vračalka |brez |Premik na predmet, ki vsebuje trenutno sistemsko žarišče ter postavi pregledno utripalko na položaj sistemske kazalke, če se prikazuje|
|Sproži trenutni predmet krmiljenja |NVDA+številski delEnter |NVDA+enter |dvojni tap |Sproži trenuten predmet krmiljenja (podobno kot pri klikih z miško ali pritisku preslednice, ko vsebuje sistemsko žarišče)|
|Premakni Sistemsko žarišče ali kazalko na trenuten položaj pregleda |NVDA+shift+številski delMinus |NVDA+shift+vračalka |brez |enojni pritisk Premakne Sistemsko žarišče na trenutni predmet krmiljenja, dvojni pritisk premakne sistemsko kazalko na položaj pregledne utripalke|
|Sporoči položaj pregledne utripalke |NVDA+številski delBriši |NVDA+Briši |brez |Sporoča položaj besedila ali predmeta nad pregledno utripalko. To lahko vključuje na primer odstotke preostanka dokumenta (odstotke razdalje od trenutnega položaja utripalke do konca dokumenta), razdaljo od roba strani ali točen položaj na zaslonu. Dvojni pritisk lahko oskrbi dodatne podrobnosti.|

<!-- KC:endInclude -->

Pomnite: številski del mora biti izključen za pravilno delovanje tipk na tem delu.

### Pregledovanje Besedila {#ReviewingText}

NVDA vam omogoča prebiranje vsebine [zaslona](#ScreenReview), trenutnega [dokumenta](#DocumentReview) ali trenutnega [predmeta](#ObjectReview) znak po znak, besedo po besedo ali vrstico po vrstico.
To je uporabno predvsem na prostorih (vključno z ukaznimi konzolami Oken), kjer ni na voljo [sistemska kazalka](#SystemCaret).
To lahko uporabljate na primer pri pregledu daljšega besedila v sporočilu z informacijami, ki ga prikaže pogovorno okno.

Ko premikate pregledno utripalko, vam sistemska kazalka ne sledi vzdolž besedila, tako da lahko besedilo pregledujete brez, da bi izgubili položaj, kjer ste začeli urejanje.
Kakorkoli, privzeto pregledna utripalka sledi sistemski kazalki vzdolž njene poti.
Ta možnost se lahko izključi ali vključi.

Pomnite: Sledenje brajice pregledni utripalki se lahko nastavi prek [Navezave Brajice](#BrailleTether).

Za pregled besedila so na voljo naslednji ukazi:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Dotik |Opis|
|---|---|---|---|---|
|Pomik v zgornjo vrstico pregleda |shift+številski del7 |NVDA+control+začetek |brez |Premakne pregledno utripalko v zgornjo vrstico z besedilom|
|Pomik v predhodno vrstico pregleda |številski del7 |NVDA+Puščica gor |švig gor(delovanje besedila) |Premakne pregledno utripalko v predhodno vrstico z besedilom|
|Poročaj o trenutni vrstici pregleda |številski del8 |NVDA+shift+. |brez |Naznani vrstico z besedilom, kjer je trenutno postavljena pregledna utripalka. Dvojni pritisk to vrstico črkuje  in trojni pritisk to vrstico črkuje z uporabo znakovnih opisov.|
|Pomik v naslednjo vrstico pregleda |številski del9 |NVDA+Puščica dol |švig dol (delovanje besedila) |Premakne pregledno utripalko v naslednjo vrstico z besedilom|
|Pomik v spodnjo vrstico pregleda |shift+številski del9 |NVDA+control+konec |brez |Premakne pregledno utripalko v spodnjo vrstico z besedilom|
|Pomik na predhodno besedo v pregledu |številski del4 |NVDA+control+Puščica levo |dvoprstni švig levo (delovanje besedila) |Premakne pregledno utripalko na predhodno besedo v besedilu|
|Poročaj o trenutni besedi v pregledu |številski del5 |NVDA+control+. |brez |Naznani besedo v besedilu, kjer je trenutno postavljena pregledna utripalka. Dvojni pritisk informacijo črkuje in trojni pritisk to informacijo črkuje s pomočjo opisov znakov.|
|Pomik na naslednjo besedo v pregledu |številski del6 |NVDA+control+Puščica desno |dvoprstni švig desno (delovanje besedila) |Premakne pregledno utripalko na naslednjo besedo v besedilu|
|Pomik na začetek vrstice v pregledu |shift+številski del1 |NVDA+začetek |brez |Premakne pregledno utripalko na začetek trenutne vrstice z besedilom|
|Pomik na predhodni znak v pregledu |številski del1 |NVDA+Puščica levo |švig levo (delovanje besedila) |Premakne pregledno utripalko na predhodni znak v trenutni vrstici z besedilom|
|Poročaj o trenutnem znaku v pregledu |številski del2 |NVDA+. |brez |Naznani trenutni znak v vrstici z besedilom, kjer je trenutno postavljena pregledna utripalka. Dvojni pritisk sporoči opis tega znaka ali primer njegove uporabe, trojni pritisk pa sporoči številsko vrednost tega znaka v desetiški in šestnajstiški obliki.|
|Pomik na naslednji znak v pregledu |številski del3 |NVDA+Puščica desno |švig desno (delovanje besedila) |Premakne pregledno utripalko na naslednji znak v vrstici z besedilom|
|Pomik na konec vrstice v pregledu |shift+številski del3 |NVDA+konec |brez |Premakne pregledno utripalko na konec trenutne vrstice z besedilom|
|Govori vse s pregledom |številski delPlus |NVDA+shift+a |troprstni švig dol (delovanje besedila) |Začetek branja od trenutnega položaja pregledne utripalke in se pri tem premikajoč tako, kot se giblje utripalka|
|Izbor in preslikava od pregledne utripalke |NVDA+f9 |NVDA+f9 |brez |začetek izbora in preslikave besedila od trenutnega položaja pregledne utripalke. Aktualno dejanje se ne bo izvedlo, dokler ne boste NVDA sporočili, kje se konča območje besedila|
|Izbor in preslikava do pregledne utripalke |NVDA+f10 |NVDA+f10 |brez |Ob prvem pritisku se označi območje od zaznamka, ki zaznamuje začetek besedila do vključno trenutnega položaja pregledne utripalke. Če sistemska kazalka lahko doseže besedilo, se bo premaknila na označeno besedilo.  Ob drugem hitrem zaporednem pritisku te kombinacije tipk se bo vsebina preslikala v odložišče Oken|
|Premakni se na zaznamovan začetek za preslikavo v pregledu |NVDA+shift+f9 |NVDA+shift+f9 |brez |Premakne pregledno utripalko na položaj, kjer se je že prej postavil zaznačevalec za preslikavo|
|Sporoči oblikovanje besedila |NVDA+f |NVDA+f |brez |Poroča o oblikovanju besedila, nad katerim je trenutno postavljena pregledna utripalka. Dvojni pritisk informacijo predstavi v brskalniškem delovanju.|
|Sporoči zamenjavo trenutnega simbola |Ni določeno |Ni določeno |ni določeno |Izgovori simbol, kjer je postavljena pregledna utripalka. Dvojni pritisk pokaže simbol in besedilo za izgovorjavo tega v brskalniškem delovanju.|

<!-- KC:endInclude -->

Pomnite: številski del mora biti izključen, da bodo številke na tem delu pravilno delovale.

Dober način za pomnenje osnovnih ukazov za pomik po besedilu ob uporabi Običajne razporeditve tipk (s številskim delom) je ta, da si predstavljate te kot mrežo tri krat tri, ki od zgoraj navzdol prikazuje vrstico, besedo in znak in od leve proti desni predhodni, trenutni in naslednji.

|Predhodna vrstica |Trenutna vrstica |Naslednja vrstica|
|Predhodna beseda |Trenutna beseda |Naslednja beseda|
|Predhodni znak |Trenutni znak |Naslednji znak|

### Delovanja Pregleda {#ReviewModes}

NVDA ukazi [za pregled besedila](#ReviewingText) lahko pregledujejo vsebino znotraj trenutnega predmeta krmiljenja, trenutnega dokumenta ali zaslona odvisno od tega, kateri pregled je trenutno izbran.
Delovanja pregleda so zamenjava za starejši koncept nestrukturiranega pregleda, obstajajočega v NVDA že prej.

Sledeči ukazi preklapljajo med delovanji pregleda:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Dotik |Opis|
|---|---|---|---|---|
|Preklop na naslednje delovanje pregleda |NVDA+številski del7 |NVDA+stranGor |dvoprsti švig gor |preklopi na naslednje delovanje pregleda na voljo.|
|Preklop na predhodno delovanje pregleda |NVDA+številski del1 |NVDA+stranDol |dvoprsti švig dol |preklopi na predhodno delovanje pregleda na voljo.|

<!-- KC:endInclude -->

#### Pregled Predmeta {#ObjectReview}

Ko ste v delovanju pregledovanja predmetov, lahko pregledujete samo vsebino trenutnega  [predmeta krmiljenja](#ObjectNavigation).
Za predmete, kot so polja za urejanje ali drugi osnovni kontrolniki dokumenta, bo običajna vsebina besedilo.
Za druge predmete je to ime predmeta ali njegova vrednost.

#### Pregled Dokumenta {#DocumentReview}

Ko je [predmet krmiljenja](#ObjectNavigation) del dokumenta, ki se pregleduje skozi brskalniško delovanje, (kot je spletna stran) ali drug zahtevnejši dokument, (kot so Lotus Symphony dokumenti), je mogoče preklopiti v delovanje pregleda dokumenta.
Delovanje pregleda dokumenta vam omogoča pregled besedila znotraj celotnega dokumenta.

Ko se preklaplja iz pregleda predmeta v pregled dokumenta, se pregledna utripalka postavi na položaj predmeta krmiljenja v dokumentu.
Ko se premikate po dokumentu z uporabo ukazov za pregled, se predmet krmiljenja samodejno zlije s predmetom, ki je trenutno na položaju pregledne utripalke.

Opozarjamo, da NVDA samodejno preklopi v pregled dokumenta iz pregleda predmeta, ko se pregledujejo dokumenti v brskalniškem delovanju.

#### Pregled Zaslona {#ScreenReview}

Delovanje pregleda zaslona vam omogoča pregled vidnega besedila na zaslonu, kot izgleda v trenutnem programu.
To je podobno pregledovanju zaslona ali funkciji miškine kazalke v mnogih drugih okenskih bralnikih zaslona.

 Ko se preklaplja v delovanje pregleda zaslona, se pregledna utripalka postavi na zaslonski položaj trenutnega [predmeta krmiljenja](#ObjectNavigation).
Ko se premikate po zaslonu z uporabo ukazov za pregled, se predmet krmiljenja samodejno zlije s predmetom, ki obstaja na zaslonskem položaju pregledne utripalke.

Opozarjamo, da NVDA v nekaterih novejših programih mogoče ne bo videla nekaj ali pa celo celotnega besedila, ki je lahko na zaslonu, zaradi uporabe novejših tehnologij za izrisovanje po zaslonu, kar trenutno ni možno podpreti.

### krmiljenje z Miško {#NavigatingWithTheMouse}

Ko premikate miško, NVDA privzeto poroča o besedilu, ki je neposredno pod miškinim kazalcem, ko se kazalec pomika nad njim.
Kjer je to podprto, bo NVDA prebrala pripadajoč odstavek z besedilom, čeprav se lahko nekateri kontrolniki preberejo samo v načinu vrstica za vrstico.

NVDA se lahko nastavi tudi tako, da naznani tip [predmeta](#Objects) pod miško, ko se zapelje nad njim (npr. seznam, gumb, in druge.).
To zna biti uporabno za popolnoma slepe uporabnice-ke, ko včasih samo besedilo ni dovolj.

NVDA uporabnicam-kom oskrbuje informacijo o položaju miške relativno glede na dimenzije zaslona skozi igranje trenutnih miškinih koordinat preko zvočnega podajanja.
Višje, ko je miška na zaslonu, višji je zvok piska.
Bolj levo, ko je miška na zaslonu, bolj levo se bo slišal pisk ob predpostavki, da imate stereo zvočnike ali slušalke.

Te dodatne značilnosti NVDA so privzeto izključene.
Če želite uporabljati te prednosti, jih lahko nastavite v zvrsti [Nastavitve miške](#MouseSettings), ki se nahaja v [Nastavitvah NVDA](#NVDASettings) v meniju NVDA Izbir.

Čeprav se mora za delo z miško uporabljati fizična miška ali drsna ploščica, NVDA lahko ponudi nekaj tipkovničnih ukazov, ki se nanašajo na delo z miško:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Dotik |Opis|
|---|---|---|---|---|
|Enojni klik z levim miškinim gumbom |številski delDeli |NVDA+š |brez |enako kot, če enkrat pritisneš na levi miškin gumb. Vsak dvojni klik se izvede tako, da dvakrat pritisnete isti gumb v hitrem zaporedju|
|Zakleni levi miškin gumb |shift+številski delDeli |NVDA+control+š |brez |Blokira levi miškin gumb. Ponovni pritisk ga spusti. Ob vlečenju miške pritisnite ta ukaz in premikajte fizično miško ali uporabite druge ukaze za premik miške|
|Desni miškin klik |številski delMnoži |NVDA+đ |tapni in zadrži |Enako kot pri enkratnem pritisku desnega miškinega gumba.|
|Zakleni desni miškin gumb |shift+številski delMnoži |NVDA+control+đ |brez |Zaklene desni miškin gumb. Ponovni pritisk ga spusti. Ob vlečenju miške pritisnite ta ukaz in premikajte fizično miško ali uporabite druge ukaze za premik miške|
|Pomik miške na trenutni predmet krmiljenja |NVDA+številski delDeli |NVDA+shift+m |brez |Pomakne miško na položaj trenutnega predmeta krmiljenja in pregledne utripalke|
|Pomik na predmet pod miško |NVDA+številski delMnoži |NVDA+shift+n |brez |Kot predmet krmiljenja nastavi predmet, ki je trenutno pod miško|

<!-- KC:endInclude -->

## Brskalniško Delovanje {#BrowseMode}

Kompleksne dokumente samo za branje, kot so spletne strani, v NVDA obravnavamo s pomočjo Brskalniškega delovanja.
To vključuje dokumente v naslednjih programih:

* Mozilla Firefox
* Microsoft Internet Explorer
* Mozilla Thunderbird
* HTML sporočila v programu Microsoft Outlook
* Google Chrome
* Microsoft Edge
* Adobe Reader
* Foxit Reader
* Adobe Flash
* Podprte knjige v Amazon Kindle za osebni računalnik

Brskalniško delovanje je opcijsko na voljo tudi v Microsoftovem Wordu.

V brskalniškem delovanju je vsebina dokumenta na voljo v ravninski predstavitvi, tako da lahko uporabljate tipke za krmiljenje z utripalko podobno, kot če bi bili v navadnem besedilnem dokumentu.
Vsi NVDA ukazi za [sistemsko kazalko](#SystemCaret) bodo delovali v tem delovanju; npr. izgovori vse, sporoči oblikovanje, ukazi za pomikanje po tabeli, in drugi.
Ko boste omogočili še [Poudarek Žarišča,](#VisionFocusHighlight) se bo položaj kazalke v navideznem brskalniškem delovanju osvetljil in ga bo mogoče videti na ekranu.
Informacija o tem ali je besedilo povezava, naslov ali drugo, se poda zraven ustreznega besedila, ko se pomikate preko njega.

Včasih bo potrebno s kontrolniki v dokumentih neposredno upravljati.
Na primer, to bo potrebno storiti v besedilnih poljih, kjer je možno urejati besedilo in seznamih. Tako lahko tipkate besedilo in uporabljate tipke za delo z utripalko, da lahko delate s tem kontrolnikom.
To storite s preklopom v delovanje žarišča, kjer se več ali manj vse tipke pošljejo neposredno na kontrolnik.
Ko ste v brskalniškem delovanju, NVDA privzeto samodejno preklopi v delovanje žarišča, če se premaknete na ali pa kliknete ustrezen kontrolnik, ki zahteva tako obravnavo.
Enako velja tudi za kontrolnike, ki ne potrebujejo delovanja žarišča, kar pomeni, da bo NVDA samodejno preklopila v brskalniško delovanje, ko se boste premaknili na tak kontrolnik.
Delovanje žarišča na kontrolnikih, ki tako delovanje potrebujejo, vključite lahko tudi s pritiskom preslednice ali tipke Enter.
Pritisk tipke Escape bo preklopil nazaj v brskalniško delovanje.
Vedno lahko vsilite delovanje žarišča, tako bo na voljo in bo učinkoval, dokler ga ne izključite.

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Stikalo za preklop med brskalniškim delovanjem in delovanjem žarišča |NVDA+preslednica |Preklaplja med brskalniškim delovanjem in delovanjem žarišča|
|Izhod iz delovanja žarišča |escape |Preklopi nazaj v brskalniško delovanje, če se je prej samodejno vklopilo delovanje žarišča|
|Osveži dokument v brskalniškem delovanju |NVDA+f5 |Ponovno naloži vsebino trenutnega dokumenta (uporabno, ko izgleda, da se del vsebine dokumenta ne prikazuje; v Microsoft Outlooku in Microsoft Wordu ni uporabno)|
|Najdi |NVDA+control+f |Dvigne pogovorno okno v katerem lahko natipkate besedilo, ki ga želite najti v dokumentu. Glejte [iskanje po besedilou](#SearchingForText) za več informacij.|
|Najdi naslednje |NVDA+f3 |Najde naslednji kos besedila v dokumentu, ki ste ga že iskali|
|Najdi predhodno |NVDA+shift+f3 |Najde predhodni kos besedila v dokumentu, ki ste ga že iskali|
|Odpri daljši opis |NVDA+d |Odpre novo okno, ki vsebuje daljši opis elementa na katerem ste, če ga vsebuje.|

<!-- KC:endInclude -->

### Enočrkovno krmiljenje {#SingleLetterNavigation}

Ko ste v brskalniškem delovanju, vas lahko NVDA oskrbi za hitrejše krmiljenje z enoznakovnimi ukazi za preskoke na različna polja v dokumentu.
Opozorilo: Ni nujno, da vsi našteti ukazi delujejo v vseh programih, saj niso podprti.

<!-- KC:beginInclude -->
Sledeče tipke samostojno preskakujejo na naslednji mogoč element medtem, ko z dodatkom tipke Shift pritisk teh tipk povzroči preskok na predhodni mogoč element:

* h: naslov
* l: seznam
* i: postavka na seznamu
* t: tabela
* k: povezava
* n: besedilo brez Povezave
* f: polje v obrazcu
* u: še neobiskana povezava
* v: že obiskana povezava
* e: polje za urejanje (besedila)
* b: gumb
* x: izbirnik
* c: spustni seznam
* r: radijski gumb
* q: blok z navedkom
* s: ločnica
* m: okvir
* g: grafika
* d: mejnik
* o: vdelan predmet (zvokovni in video predvajalnik, programček, pogovorno okno ipd.)
* 1 to 6: naslovi od 1 do 6 (vsak zase)
* a: zabeležka (komentar, uredniški popravek itd.)
* w: napaka črkovanja

Za premik na začetek ali konec vsebinskih elementov, kot so seznami in tabele:

| Ime |Tipka |Opis|
|---|---|---|
|Pomik na začetek vsebnika |shift+comma |Pomakne se na začetek vsebine (v tabeli, na seznamu in drugo) z ozirom na to, kje je trenutni položaj kazalke|
|Pomik na konec vsebnika |comma |Premakne se na konec vsebine (v tabeli, na seznamu in drugo) z ozirom na to, kje je trenutni položaj kazalke|

<!-- KC:endInclude -->

Nekatere spletne aplikacije, kot so Gmail, Facebook in Twitter, uporabljajo posamezne črke kot bližnjične tipke.
Če to želite uporabljati medtem, ko so tipke za premik utripalke še vedno na voljo za branje v brskalniškem delovanju, lahko začasno onemogočite NVDA posamezne črke za krmiljenje.
<!-- KC:beginInclude -->
Pritisnite NVDA+Shift+Preslednico, če želite vključiti in/ali izključiti enočrkovno krmiljenje v trenutnem dokumentu.
<!-- KC:endInclude -->

### Seznam Elementov {#ElementsList}

Seznam elementov vam oskrbuje dostop do seznama različnih tipov elementov, ki so del dokumenta določenega programa.
V brskalniku na primer, se v tem seznamu razvrstijo povezave, naslovi, polja obrazcev, gumbi in mejniki.
Radijski gumbi vam omogočajo preklapljanje med različnimi tipi elementov.
Pogovorno okno je opremljeno tudi s poljem za urejanje, kar vam omogoča filtracijo postavk v seznamu, da lažje najdete željen element na strani.
Ko enkrat najdete pravo postavko, lahko izbirate med gumboma v pogovornem oknu, s katerima se premaknete na izbrano postavko ali pa jo sprožite, odvisno od izbire gumba.
<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|seznam elementov v brskalniškem delovanju |NVDA+f7 |V ospredje postavi Seznam elementov, ki so del trenutnega dokumenta|

<!-- KC:endInclude -->

### Iskanje po besedilu {#SearchingForText}

To pogovorno okno vam omogoča iskanje po besedilu za pomeni v trenutnem dokumentu.
V polju"Natipkajte besedilo, ki ga želite najti", se lahko vnese besedilo, ki se lahko nahaja v dokumentu.
Izbirnik "Občutljivost na male in velike črke" obravnava iskanje z velikimi in malimi črkami drugače.
Na primer, z izbranim izbirnikom "Občutljivost na male in velike črke" lahko najdete "NV Access" toda ne "nv access".
Uporabite sledeče tipke za izvedbo iskanj:
<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Najdi besedilo |NVDA+control+f |Odpre pogovorno okno iskanja|
|Najdi naslednje |NVDA+f3 |išče naslednji primerek trenutnega iskalnega pomena|
|Najdi predhodne |NVDA+shift+f3 |išče predhodni primerek trenutnega iskalnega pomena|

<!-- KC:endInclude -->

### Vdelani Predmeti {#ImbeddedObjects}

Strani lahko vključujejo obogateno vsebino z uporabo tehnologij, kot so Adobe Flash, Oracle Java in HTML5 tako kot programčke in pogovorna okna.
Kjerkoli se z njimi srečate v brskalniškem delovanju, bo NVDA sporočila "vdelan predmet", oziroma "program" ali "pogovorno okno".
Na te predmete se lahko hitro premaknete z uporabo hitrih tipk za vdelani predmet o and shift+o enočrkovnega krmiljenja.
Za interakcijo z njimi, nad njimi lahko pritisnete Enter.
Če je predmet dostopen (ga je možno upravljati tudi z bralnikom zaslona), lahko zaookrožite po njem in z njim delate tako kot v vsaki drugi aplikaciji.
Za vrnitev na stran, ki vsebuje ta predmet, je na voljo naslednji ukaz:
<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Pomik v dokument z brskalniškim delovanjem |NVDA+control+preslednica |Premakne žarišče iz predmeta v dokument, ki ga vsebuje|

<!-- KC:endInclude -->

## Branje Matematične Vsebine {#ReadingMath}

Z uporabo MathPlayerja 4 iz podjetja Design Science NVDA lahko prebira in interaktivno krmili po podprti matematični vsebini.
To pomeni, da mora biti MathPlayer 4 nameščen na vaš računalnik.
MathPlayer je na voljo kot brezplačen prenos s: https://www.dessci.com/en/products/mathplayer/

NVDA podpira naslednje tipe matematične vsebine:

* MathML v Mozilli Firefox, Internet Explorerju in Google Chromu.
* Design Science MathType v Microsoftovem Wordu and PowerPointu.
Da bo ta funkcija pravilno delovala, morate v sistem namestiti tudi MathType.
Omejena različica bo zadostovala.
Lahko si program prenesete s strani https://www.dessci.com/en/products/mathtype/
* MathML V Adobovem Readerju.
Opozarjamo, da to še ni uraden standard, tako trenutno ni na voljo nobenega primernega programa, kjer bi se lahko ustvarila taka vsebina.
* Matematična vsebina v programu Kindle za osebne računalnike za knjige z dostopno matematično vsebino.

Ko boste prebirali dokument, bo NVDA izgovorila vsako podprto matematično vsebino, kjer se bo prikazala.
Če uporabljate brajevo vrstico, se bo ta vsebina pokazala tudi na vrstici.

### Interaktivno krmiljenje {#InteractiveNavigation}

Če v glavnem delate z zvokom, boste v večini primerov želeli preučiti izraz v manjših kosih namesto, da bi ga slišali v celoti naenkrat.

Če ste v brskalniškem delovanju, lahko to naredite tako, da premaknete utripalko na matematično vsebino in pritisnete Enter.

Če niste v brskalniškem delovanju:

1. premaknite pregledno utripalko na matematično vsebino
Privzeto pregledna utripalka sledi sistemski kazalki tako, da boste običajno lahko uporabili sistemsko kazalko za premik na želeno vsebino.
1. Nato izvedite naslednji ukaz:

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Interakcija z matematično vsebino |NVDA+alt+m |Začne interakcijo z matematično vsebino.|

<!-- KC:endInclude -->

V tem trenutku lahko uporabljate ukaze MathPlayerja, kot so puščice za raziskovanje izraza.
Na primer, lahko se premikate po izrazu s puščicama levo in desno, del izraza, kot je, recimo, ulomek, pa lahko približate s puščico dol.	
Prosimo, da nadaljne informacije za [krmiljenje s tipkami poiščete v dokumentaciji MathPlayerja:](https://www.dessci.com/en/products/mathplayer/navigation_commands.htm)

Ko se boste želeli vrniti v dokument, preprosto pritisnite tipko Escape.

Vačasih se lahko matematična vsebina prikaže na način gumba ali drugega tipa elementa, ki, ko se aktivira, lahko prikaže pogovorno okno ali več informacij vezanih na formulo.
Za sprožitev gumba ali elementa, ki vsebuje formulo, pritisnite ctrl+enter.

## Brajica {#Braille}

Če posedujete brajevo vrstico, vam na njo NVDA lahko posreduje informacije.
In če je na vaši vrstici tipkovnica v Perkinsovem slogu, lahko tudi vnašate normalno in skrajšano brajico.
Brajica se lahko prikazuje tudi na ekranu z uporabo [Prikazovalnika Brajice](#BrailleViewer) namesto ali pa ob istem času, ko se uporablja fizična brajeva vrstica.

Prosimo, oglejte si razdelek [Podprtih Brajevih Vrstic](#SupportedBrailleDisplays) za več informacij o podprtih brajevih vrsticah.
Ta razdelek vsebuje tudi informacije o tem, katere vrstice podpirajo funkcijo samodejne zaznave brajeve v vrstice v ozadju prek NVDA.
Brajico lahko nastavite v [zvrsti Brajica](#BrailleSettings)  pogovornega okna [Nastavitve NVDA](#NVDASettings).

### Brajeve okrajšave mejnikov, stanja in tipov kontrolnika {#BrailleAbbreviations}

Zaradi posredovanja največjega možnega števila informacij na brajevo vrstico naenkrat, so v NVDA definirane okrajšave za indikacijo različnih tipov kontrolnikov in njihovih stanj, tako kot mejnikov.

| Okrajšava |Tip kontrolnika|
|---|---|
|prg |program|
|čln |članek|
|nvd |navedek|
|gmb |gumb|
|spgmb |spustni gumb|
|vrtgmb |vrtilni gumb|
|rzdgmb |razdelitveni gumb|
|stgmb |stikalni gumb|
|pdn |podnapis|
|sps |spustni seznam|
|izb |izbirnik|
|pok |pogovorno okno|
|dok |dokument|
|pub |polje za urejanje besedila|
|gslpub |urejanje gesla|
|vdelano |vdelano|
|zopmb |končna opomba|
|lik |lik|
|popmb |opomba pod črto|
|gra |grafika|
|rsk |razvrščanje v skupino|
|nN |naslov na nivoju n, npr. n1, n2.|
|pmč |oblaček pomoči|
|mjn |mejnik|
|pvz |povezava|
|opvz |obiskana povezava|
|szm |seznam|
|mni |meni|
|mnivrs |menijska vrstica|
|mnigmb |menijski gumb|
|mnipst |menijska postavka|
|plš |plošča|
|nprvrs |vrstica napredka|
|rgmb |radijski gumb|
|vrtnvrs |vrstica vrtenja|
|odsk |odsek|
|stvrs |vrstica stanja|
|ndzzvh |nadzor zavihkov|
|tbl |tabela|
|sN |številka stolpca v tabeli (n), npr. s1, s2.|
|vN |številka vrstice v tabeli (n), npr. v1, v2.|
|trmn |terminal|
|orvrs |orodna vrstica|
|zsnmg |zaslonski namig|
|dp |drevesni pogled|
|dpgmb |gumb v drevesnem pogledu|
|dppst |postavka v drevesnem pogledu|
|nv N |postavka v hierarhiji drevesnega pogleda na nivoju N|
|okn |okno|
|⠤⠤⠤⠤⠤ |ločnica|

Definirani so tudi sledeči indikatorji stanj kontrolnikov:

| Okrajšava |Stanje kontrolnika|
|---|---|
|... |se prikaže, ko predmet podpira samodokončanje|
|⢎⣿⡱ |prikazano, ko je predmet (npr. stikalni gumb) pritisnjen|
|⢎⣀⡱ |prikazano, ko predmet (npr. stikalni gumb) ni pritisnjen|
|⣏⣿⣹ |se prikaže ob predmetu (npr. izbirniku), ko je ta izbran|
|⣏⣸⣹ |se prikaže ob predmetu (npr. izbirniku), ki je delno izbran|
|⣏⣀⣹ |se prikaže ob predmetu (npr. izbirniku), ki ni izbran|
|- |se prikaže, ko je predmet (npr. postavko v drevesnem pogledu) možno stisniti|
|+ |se prikaže, ko je predmet (npr. postavko v drevesnem pogledu) možno razpreti|
|*** |se prikaže, ko naletite na zaščiten dokument ali nadzor|
|klk |se prikaže ob predmetu, na katerega je možno klikniti|
|kmnt |prikazano, ko je vrstica na komentarju za celico v preglednici ali na kosu besedila v dokumentu|
|frml |prikazano, ko je vrstica na formuli v celici preglednice|
|neveljavno |prikazano, ko se je izvršil neveljaven vnos|
|dopis |se prikaže, ko predmet (običajno slika) vsebuje daljši opis|
|vvr |se prikaže, ko polje za urejanje besedila dovoljuje vnos večih vrstic besedila, kot so polja za komentiranje na spletiščih|
|obv |se prikaže, ko naletite na polje v obrazcu, ki ga morate obvezno izpolniti|
|sb |se prikaže, ko je predmet (npr. polje za urejanje besedila) samo za branje|
|ozn |se prikaže, ko je predmet označen|
|nozn |se prikaže, ko predmet ni označen|
|vrsta gor |se prikaže, ko se predmet razvršča naraščajoče|
|vrsta dol |se prikaže, ko se predmet razvršča padajoče|
|podmni |se prikaže ob predmetu s pojavnim oknom (običajno podmeni)|

Na koncu so definirane še sledeče okrajšave za mejnike:

| Okrajšava |Mejnik|
|---|---|
|psc |pasica|
|vsbn |vsebinski|
|dpln |dopolnilni|
|izpl |izpolnjevalni|
|glvn |glavni|
|krml |krmilni|
|iskl |iskalni|
|obmč |območje|

### Brajev Vnos {#BrailleInput}

NVDA podpira tako skrajšano brajevo vnašanje kot normalno prek brajeve tipkovnice.
Tabelo za prevod brajice v normalno besedilo lahko določite z izborom tabele s spustnega seznama [Tabel za vnos znakov](#BrailleSettingsInputTable)  v zvrsti Brajica pogovornega okna [Nastavitve NVDA](#NVDASettings).

Ko se uporablja normalen vnos, se besedilo prevede takoj, ko je natipkano.
Ko se uporablja skrajšan vnos, se besedilo prevede na koncu besede po pritisku tipke enter ali preslednice.
Pomnite, da prevod upošteva samo trenutno besedo in ne celotnega besedila okoli nje.
Na primer, ko boste uporabljali kodno tabelo, ki definira številke z znakom za število in boste pritisnili vračalko (backspace), da boste prišli na konec te številke, boste znak za število morali pritisniti še enkrat, da boste lahko vpisali dodatne števke k obstoječi številki.

<!-- KC:beginInclude -->
Pritisk tipke 7 zradira zadnjo brajevo celico ali znak.
Pika 8 prevede katerikoli brajev vnos in pritisne tipko enter.
 pritisk pike 7 + pike 8 prevede katerikoli brajev vnos, vendar brez dodajanja presledka ali pritiska tipke enter.
<!-- KC:endInclude -->

## Vidnost {#Vision}

Čeprav je NVDA  namenjena predvsem slepim in ljudem z okvaro vida, ki prvotno uporabljajo govor in/ali brajico pri delu z računalnikom, ta oskrbuje tudi vgrajene zmožnosti, ki zmorejo zamenjati vsebino ekrana.
Znotraj NVDA se tak pripomoček imenuje oskrba izboljšave vidnosti.

NVDA ponuja nekaj oskrb izboljšav vidnosti, ki so opisane v nadaljevanju.
Dodatne oskrbe izboljšave vidnosti se lahko doda preko [dodatkov za NVDA](#AddonsManager).

NVDA nastavitve vidnosti se lahko spremenijo v [zvrsti vidnost](#VisionSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings).

### Poudarek Žarišča {#VisionFocusHighlight}

Poudarek Žarišča lahko pomaga identificirati pozicije [sistemskega žarišča](#SystemFocus), [predmeta krmiljenja](#ObjectNavigation) in [brskalniškega delovanja](#BrowseMode).
Te pozicije so poudarjene z obarvanim pravokotnikom v orisu.

* Trdno modra poudarja združena položaja predmeta krmiljenja in sistemskega žarišča (npr., ker [predmet krmiljenja sledi sistemskemu žarišču](#ReviewCursorFollowFocus)).
-  Prekinjeno modra poudarja samo predmet sistemskega žarišča.
* Trdno roza poudarja samo predmet krmiljenja.
* Trdno rumena poudarja navidezno kazalko, ki se uporablja v brskalniškem delovanju, (kjer ni nobene fizične kazalke, kot je to v spletnih brskalnikih).

Ko je Poudarek Žarišča omogočen v [zvrsti vidnost](#VisionSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings), lahko [spreminjate, ali ja ali ne, poudariti žarišče, predmet krmiljenja ali kazalko brskalniškega delovanja](#VisionSettingsFocusHighlight).

### Preveza čez Ekran {#VisionScreenCurtain}

Pri slepem uporabniku/ci ali uporabniku/ci z okvaro vida je pogosto tako, da nima možnosti ali pa ni potrebno, da vidi vsebino ekrana.
Še več, lahko je precej težko zagotoviti, da tam ni nikogar, ki bi kukal čez vašo ramo.
Za tako situacijo NVDA vsebuje zmožnost, ki se imenuje "preveza čez ekran", ki se lahko omogoči za to, da ekran počrni.

 Prevezo čez Ekran lahko omogočite v [zvrsti vidnost](#VisionSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings).

## Prepoznava Vsebine {#ContentRecognition}

Ko avtorji ne poskrbijo za pravšnjo količino informacij za uporabnika bralnika zaslona, da bi lahko ugotovil, kaj je vsebina nečesa, lahko uporabnik poskusi uporabiti različna orodja za prepoznavo vsebine s slike.
NVDA podpira funkcijo optične prepoznave znakov (z angleško kratico OCR), ki je že vgrajena v Windows 10 s pomočjo katere prepoznava besedilo s slik.
Dodatni prepoznavalniki vsebine se lahko dodajo v NVDA prek dodatkov.

Ko uporabite ukaz za prepoznavo, NVDA prepozna vsebino, ki je del trenutnega [predmeta krmiljenja](#ObjectNavigation).
Privzeto predmet krmiljenja sledi sistemskemu žarišču ali utripalki brskalniškega delovanja, tako lahko običajno samo pomaknete žarišče oziroma utripalko brskalniškega delovanja na ustrezno mesto.
Na primer, če premaknete utripalko brskalniškega delovanja na sliko, bo privzeto funkcija prepoznave prepoznala vsebino te slike.
Vendar lahko po želji uporabite krmiljenje predmeta neposredno za, na primer, prepoznavo celotnega programskega okna.

Ko je enkrat prepoznava končana, se rezultat izpiše v dokumentu, ki je podoben dokumentom v brskalniškem delovanju. Tako lahko preberete informacijo s smernimi tipkami ipd.
Pritisk preslednice ali tipke enter bo sprožil (običajno s klikom) besedilo na utripalki, če je mogoče.
Pritisk tipke escape zavrže rezultat prepoznave.

### Prepoznava (OCR) v Windows 10 {#Win10Ocr}

Sistem Windows 10 vključuje možnost prepoznave za številne jezike.
To lahko uporabi NVDA, da lahko prepozna besedilo s slik ali nedostopnih programov.

Jezik, ki se bo uporabil za prepoznavo besedila, lahko nastavite v [zvrsti Windows 10 OCR](#Win10OcrSettings) pogovornega okna [Nastavitev NVDA](#NVDASettings).
Dodatni jeziki se lahko namestijo tako, da odprete Začetni meni, izberete Nastavitve, nato Ura in jezik -> Regija in jezik in potem izberete Dodaj jezik.

<!-- KC:beginInclude -->
Za prepoznavo besedila znotraj trenutnega predmeta krmiljenja z uporabo Windows 10 OCR, pritisnite NVDA+r.
<!-- KC:endInclude -->

## Posebne Zmožnosti v Programih {#ApplicationSpecificFeatures}

NVDA vsebuje posebej prirejene zmožnosti za nekatere programe, da omogoči lažjo izvedbo nekaterih opravil ali pa za oskrbo dostopa do funkcionalnosti, ki drugače niso dostopne uporabnikom bralnikov zaslona.

### Microsoft Word {#MicrosoftWord}
#### Samodejno prebiranje Glav Vrstic in Stolpcev {#WordAutomaticColumnAndRowHeaderReading}

NVDA lahko samodejno naznanja ustrezne glave vrstic in stolpcev, ko se pomikate po tabelah v Microsoft Wordu.
Ob tem mora biti izpolnjen predpogoj, da je izbrana zmožnost Sporočanja Glav Vrstic in Stolpcev v Tabelah v nastavitvah NVDA Oblikovanje Dokumentov, ki se nahaja v pogovornem oknu [Nastavitev NVDA](#NVDASettings).
Prav tako mora NVDA vedeti, katera vrstica ali stolpec vsebuje glavo ali čelo tabele.
Po pomiku v prvo celico stolpca ali vrstice z glavo, uporabite naslednje ukaze:
<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Postavi glave stolpca |NVDA+shift+c |Enojni pritisk pove NVDA, da je to prva celica z glavo v vrstici, ki vsebuje glave stolpca; ta bi morala biti samodejno naznanjena, ko se bomo premikali po stolpcih pod to vrstico. Dvojni pritisk bo zbrisal to nastavitev.|
|Postavi glave vrstice |NVDA+shift+r |Enojni pritisk pove NVDA, da je to prva celica z glavo v stolpcu, ki vsebuje glave vrstice; ta bi morala biti samodejno naznanjena, ko se bomo premikali po vrsticah za tem stolpcem. Dvojni pritisk bo zbrisal to nastavitev.|

<!-- KC:endInclude -->
Te nastavitve se bodo v dokumentu hranile kot zaznamki, tako da jih bodo lahko uporabljali tudi drugi bralniki zaslonske slike, kot je na primer JAWS.
To pomeni, da bodo uporabniki drugih bralnikov vedeli, ko bodo odprli ta dokument ob kasnejšem datumu, kje so glave vrstic in stolpcev.

#### Brskalniško Delovanje v Microsoft Wordu {#BrowseModeInMicrosoftWord}

Tako kot v spletu, se Brskalniško delovanje lahko uporablja tudi v Microsoft Wordu, zaradi dostopa do zmožnosti, kot je Hitro krmiljenje in Seznam Elementov.
<!-- KC:beginInclude -->
Za vklop in izklop Brskalniškega delovanja v Microsoft Wordu, pritisnite NVDA+preslednica.
<!-- KC:endInclude -->
Za več informacij o Brskalniškem delovanju in Hitrem krmiljenju, si oglejte [razdelek Brskalniško Delovanje](#BrowseMode).

##### Seznam Elementov {#WordElementsList}

<!-- KC:beginInclude -->
Medtem, ko uporabljate Brskalniško delovanje v Microsoft Wordu, lahko do Seznama Elementov dostopate z ukazom NVDA+f7.
<!-- KC:endInclude -->
Seznam Elementov lahko razvrsti naslove, povezave, zabeležke, kar vključuje komentarje in sledenje spremembam in napake (trenutno omejeno na napake črkovanja).

#### Sporočanje Komentarjev {#WordReportingComments}

<!-- KC:beginInclude -->
Za sporočanje katerihkoli komentarjev na trenutnem položaju kazalke, pritisnite NVDA+alt+c.
<!-- KC:endInclude -->
Vsi komentarji v dokumentu se lahko vzporedno z ostalimi sledenji spremembam razvrstijo tudi v NVDA Seznamu Elementov.

### Microsoft Excel {#MicrosoftExcel}
#### Samodejno prebiranje Glav Vrstic in Stolpcev {#ExcelAutomaticColumnAndRowHeaderReading}

NVDA lahko samodejno naznanja ustrezne glave stolpcev in vrstic medtem, ko se premikate po Excelovih preglednicah.
Ob tem mora biti izpolnjen predpogoj, da je izbrana zmožnost Sporočanja Glav Vrstic in Stolpcev v Tabelah v nastavitvah NVDA Oblikovanje Dokumentov, ki se nahaja v pogovornem oknu [Nastavitev NVDA](#NVDASettings).
Prav tako mora NVDA vedeti, katera vrstica ali stolpec vsebuje glavo ali čelo tabele.
Po pomiku v prvo celico stolpca ali vrstice z glavo, uporabite naslednje ukaze:
<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Postavi glave stolpca |NVDA+shift+c |Enojni pritisk pove NVDA, da je to prva celica z glavo v vrstici, ki vsebuje glave stolpca; ta bi morala biti samodejno naznanjena, ko se bomo premikali po stolpcih pod to vrstico. Dvojni pritisk bo zbrisal to nastavitev.|
|Postavi glave vrstice |NVDA+shift+r |Enojni pritisk pove NVDA, da je to prva celica z glavo v stolpcu, ki vsebuje glave vrstice; ta bi morala biti samodejno naznanjena, ko se bomo premikali po vrsticah za tem stolpcem. Dvojni pritisk bo zbrisal to nastavitev.|

<!-- KC:endInclude -->
Te nastavitve se bodo v delovnem zvezku hranile kot določeni imenski odseki, tako da jih bodo lahko uporabljali tudi drugi bralniki zaslonske slike, kot je na primer JAWS.
To pomeni, da bodo uporabniki drugih bralnikov vedeli, ko bodo odprli ta delovni zvezek ob kasnejšem datumu, kje so glave vrstic in stolpcev.

#### Seznam Elementov {#ExcelElementsList}

Tako kot na spletu, ima NVDA Seznam Elementov tudi za Microsoft Excel, kar vam omogoča razvrstitev in lažji dostop do več različnih tipov informacij.
<!-- KC:beginInclude -->
Za dostop do Seznama Elementov v Excelu, pritisnite NVDA+f7.
<!-- KC:endInclude -->
V Seznamu Elementov lahko pridete do teh informacij:

* Grafikoni: Ta razvrsti vse grafikone na aktivnem delovnem listu.
Izbira grafikona in pritisk tipke Enter ali gumba Premakni se na, v ospredje postavi grafikon, da se lahko pomikate po njem in ga berete s puščicami. 
* Komentarji: Ta izbor razvrsti vse celice na aktivnem delovnem listu s komentarji.
Naslov celice skupaj s komentarjem se prikazuje za vsako celico.
Pritisk tipke enter ali gumba Premakni se na nad izbranim komentarjem, vas bo premaknil na natančno to celico.
* Formule: Ta izbor razvrsti vse celice na delovnem listu, ki vsebujejo formule.
Naslov celice se prikazuje skupaj s formulo in to velja za vsako celico.
Pritisk tipke enter ali gumba Premakni se na nad izbrano formulo, vas bo pomaknil neposredno v celico s to vsebino.
* Delovni listi: Ta izbor razvrsti vse delovne liste v delovnem zvezku.
Izbrani list lahko s pritiskom tipke f2 preimenujete.
Pritisk tipke enter ali gumba Premakni se na, vas bo pomaknil na ta list.
* Polja v obrazcu: Ta možnost razvrsti vsa polja, ki so del obrazca na aktivnem delovnem listu.
Ob vsakem polju obrazca Seznam elementov prikaže njegovo alternativno besedilo skupaj z naslovi celic, ki jih polje pokriva.
Izbor polja v obrazcu in pritisk tipke enter ali gumba Premakni se na, sproži premik na to polje v načinu brskalniškega delovanja.

#### Sporočanje Komentarjev {#ExcelReportingComments}

<!-- KC:beginInclude -->
Za sporočanje katerihkoli komentarjev za celico, ki je v središču, pritisnite NVDA+alt+c.
<!-- KC:endInclude -->
Vsi komentarji za delovni list se lahko razvrstijo tudi v NVDA Seznamu Elementov po pritisku NVDA+f7.

NVDA lahko prikaže tudi posebno pogovorno okno za dodajanje ali urejanje določenega komentarja.
NVDA preglasi domače MS Excelovo območje za urejanje komentarja zaradi omejitev dostopnosti, toda kombinacija tipk za prikaz pogovornega okna se podeduje iz MS Excela, torej je enaka in tako deluje tudi, če NVDA ne teče.
<!-- KC:beginInclude -->
Za dodajjanje ali urejanje določenega komentarja v celici v žarišču pritisnite shift+f2.
<!-- KC:endInclude -->

Ta kombinacija tipk ni na spregled in se ne more spremeniti v pogovornem oknu NVDA kretenj vnosa.

Pomnite: mogoče je odpreti območje za urejanje komentarja v MS Excelu tudi iz kontekstualnega menija katerekoli celice delovnega lista.
+Toda, to bo odprlo nedostopno območje za urejanje komentarja in ne posebnega pogovornega okna NVDA za urejanje komentarja.

#### Prebiranje Zaščitenih Celic {#ExcelReadingProtectedCells}

Če prebirate zaščiten delovni zvezek, ne bo mogoče premikati žarišča na izbrane celice, kjer je zaklep onemogočil urejanje.
<!-- KC:beginInclude -->
Za omogočanje premika v zaklenjene celice, preklopite v Brskalniško delovanje s pritiskom kombinacije NVDA+preslednica in potem uporabljajte standardne Excelove ukaze za premikanje, kot so puščice, ki jih uporabljate za premike med vsemi celicami v trenutnem delovnem listu.
<!-- KC:endInclude -->

#### Polja Obrazca {#ExcelFormFields}

Excelovi delovni listi lahko vključujejo tudi polja v obrazcih.
Do njih lahko dostopate z uporabo Seznama Elementov ali f in shift+f enočrkovne tipke za krmiljenje po poljih obrazca.
Ko se premaknete na polje v obrazcu v načinu brskalniškega delovanja, lahko to polje s pritiskom preslednice ali tipke enter bodisi aktivirate ali preklopite v delovanje žarišča; tako, da lahko spreminjate vrednosti v njem, to je odvisno od tipa polja.
Več informacij o Brskalniškem delovanju in enočrkovnem krmiljenju poiščite v razdelku [Brskalniško Delovanje](#BrowseMode).

### Microsoft PowerPoint {#MicrosoftPowerPoint}

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Stikalo branja sporočil govorca |control+shift+s |Ko teče diaprojekcija, ta ukaz preklaplja med komentarji govorca za trenutni diapozitiv in vsebino diapozitiva. Ta ukaz ima učinek samo na to, kaj NVDA bere in ne na to, kaj je prikazano na zaslonu.|

<!-- KC:endInclude -->

### foobar2000 {#Foobar2000}

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Sporoči preostanek časa |control+shift+r |Sporoča preostanek časa do konca predvajanja trenutne skladbe, če se katera.|
|Sporoči pretekli čas |control+shift+e |Sporoča pretečeni čas skladbe, ki se trenutno predvaja, če se katera.|
|Sporoči dolžino skladbe |control+shift+t |Sporoča dolžino trenutne skladbe v predvajanju, če se katera.|

<!-- KC:endInclude -->

Pomnite: Zgornje bližnjice  delajo samo s privzetim oblikovanjem niza za foobar vrstico stanja.

### Miranda IM {#MirandaIM}

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Sporoči zadnje sporočilo |NVDA+control+1-4 |Posreduje eno od zadnjih sporočil, odvisno od tega, katero številko pritisnete; npr. NVDA+control+2 prebere predzadnje sporočilo.|

<!-- KC:endInclude -->

### Poedit {#Poedit}

<!-- KC:beginInclude -->

| Ime |Tipka |Opis|
|---|---|---|
|Poročaj o vsebini okna z opombami |control+shift+c |Poroča o kateremkoli komentarju v oknu z opombami.|
|Sporočaj opombe za prevajalce |control+shift+a |Sporoča katerokoli sporočilo namenjeno prevajalcem.|

<!-- KC:endInclude -->

### Kindle za Osebni Računalnik {#Kindle}

NVDA podpira branje knjig in premikanje po njih v aplikaciji Amazon Kindle za osebne računalnike.
Ta funkcionalnost je na voljo samo v knjigah Kindle, ki so zaznamovane z oznako "Screen Reader: Supported", (aplikacija je samo v Angleščini), kar lahko preverite na strani, ki prikazuje podrobne informacije o lastnostih knjige.

Za branje se uporablja Brskalniško delovanje.
To se vključi samodejno, ko knjigo odprete ali pa se žarišče postavi na njeno območje.
Prav tako se bodo strani ustrezno obračale samodejno, ko se boste premikali z utripalko ali pa uporabljali ukaz "Preberi Vse".
<!-- KC:beginInclude -->
Ročno se lahko na naslednjo ali predhodno stran premaknete z uporabo tipke pageDown ali pageUp.
<!-- KC:endInclude -->

Enočrkovno krmiljenje je podprto za povezave in grafike, vendar samo znotraj trenutne strani.
Krmiljenje po povezavah vključuje tudi opombe pod črto.

V NVDA je vgrajena zgodnja podpora (se še razvija) za branje in interaktivno krmiljenje po matematični vsebini v knjigah z dostopno matematiko.
Prosimo, oglejte si razdelek [Branje Matematične Vsebine](#ReadingMath) za več informacij.

#### Izbiranje Besedila {#KindleTextSelection}

Kindle vam omogoča, da nad izbranim besedilom izvedete različna dejanja, vključno s pridobivanjem slovarske deifinicije, dodajanjem zabeležk in poudarkov, preslikavo besedila v odložišče in iskanjem po spletu.
Za izvedbo dejanja, najprej označite besedilo, kot se to naredi v brskalniškem delovanju; na primer, lahko uporabite tipko shift skupaj s smernimi tipkami za manipulacijo z utripalko (puščicami).
<!-- KC:beginInclude -->
Ko boste enkrat besedilo označili, pritisnite  tipko applications ali shift+f10, da se vam bodo prikazale možnosti, ki so na voljo za delo z izbranim odsekom.
<!-- KC:endInclude -->
Če boste to storili, brez, da bi prej označili ustrezno besedilo, se bodo te možnosti pokazale samo za besedo, nad katero trenutno stoji utripalka.

#### Uporabniške Zabeležke {#KindleUserNotes}

Ob branju knjige lahko vanjo dodate lastne zabeležke. Lahko so besede pa tudi krajše besedilo.
Če želite to narediti, najprej označite željeno besedilo, nato pa za dostop do možnosti nad to izbiro izvedite korake, ki so opisani zgoraj.
Nato izberite "Add Note" Dodaj zabeležko.

Med branjem v brskalniškem delovanju, NVDA te zabeležke obravnava kot komentarje.

Za pregled, urejanje ali izbris zabeležke:

1. Premaknite utripalko na besedilo, ki vsebuje zabeležko.
1. Izvedite korake za dostop do možnosti nad izbiro, kot je opisano zgoraj.
1. Izberite Uredi zabeležko "Edit Note".

### Azardi {#Azardi}

<!-- KC:beginInclude -->
Ko ste v tabelaričnem pogledu dodanih knjig:

| Ime |Tipka |Opis|
|---|---|---|
|Vstop |enter |Odpre izbrano knjigo.|
|Kontekstni meni |applications |Odpre kontekstni meni za izbrano knjigo.|

<!-- KC:endInclude -->

### Windows Konzola {#WinConsole}

NVDA oskrbuje podporo za Windows ukazno konzolo, ki se uporablja v Ukaznem Pozivu, konzoli PowerShell in Windows Podsistemu za Linux.
Konzolsko okno ima nespremenljivo velikost, običajno precej manjšo, kot je predpomnilnik, ki ohranja iznos.
Ko je napisano novo besedilo, se vsebina odvrti navzgor in predhodno besedilo ni več vidno. 
Besedilo, ki ni vidno prikazano v oknu, ni dostopno z NVDA ukazi za pregled besedila.
Tako je potrebno vrteti to konzolsko okno za branje zgodnejšega besedila.
<!-- KC:beginInclude -->
Sledeče vgrajene bližnjične tipke Windows Konzole bodo morda uporabne ob [pregledu besedila](#ReviewingText) z NVDA:

| Ime |Tipka |Opis|
|---|---|---|
|Zavrti gor |control+puščicaGor |Zavrti konzolsko okno navzgor, da se lahko prebere zgodnejše besedilo.|
|Zavrti dol |control+puščicaDol |Zavrti konzolsko okno navzdol, da se lahko prebere kasnejše besedilo.|
|Zavrti na začetek |control+home |Zavrti konzolsko okno na začetek medpomnilnika.|
|Zavrti na konec |control+end |Zavrti konzolsko okno na konec medpomnilnika.|

<!-- KC:endInclude -->

## Konfiguracija NVDA {#ConfiguringNVDA}

Večino konfiguracije se lahko opravi v pogovornih oknih, ki so dostopna prek podmenija Izbire v meniju NVDA.
Večje število teh nastavitev se lahko najde v mnogostranskem pogovornem oknu imenovanem [pogovorno okno NVDA Nastavitev](#NVDASettings).
V vseh pogovornih oknih pritisnite gumb V redu za sprejetje vseh sprememb, ki ste jih naredili.
Za zavrzitev katerekoli spremembe pritisnite gumb Prekliči ali tipko escape.
V nekaterih pogovornih oknih lahko pritisnete gumb Uporabi, da bodo nastavitve učinkovale nemudoma brez zaprtja pogovornega okna.
Nekatere nastavitve se lahko spremenijo tudi z uporabo bližnjičnih tipk, ki so razvrščene po relevantnih odsekih spodaj.

### NVDA Nastavitve {#NVDASettings}

<!-- KC:settingsSection: || Ime | Običajna razporeditev | razporeditev Prenosnik | Opis | -->
Pogovorno okno NVDA Nastavitev vsebuje precej konfiguracijskih parametrov, ki se lahko spreminjajo.
To pogovorno okno vsebuje seznam z nekaj zvrstmi nastavitev, med katerimi lahko izbirate.
Ko boste izbrali zvrst, se bo pokazalo več nastavitev, ki so povezane s to zvrstjo.
Te nastavitve se lahko uporabijo z uporabo gumba Uporabi in v tem primeru bo pogovorno okno ostalo odprto.
Če želite shraniti vaše nastavitve in zapreti pogovorno okno NVDA Nastavitev, lahko uporabite gumb V redu.

Nekaj zvrsti nastavitev ima dodeljene bližnjične tipke.
Če jih pritisnete, bodo te bližnjične tipke odprle pogovorno okno NVDA Nastavitev v tej nadrobni zvrsti.
Privzeto niso vse zvrsti dostopne prek tipkovničnih ukazov.
Če želite dostopati do zvrsti, ki nima določenih bližnjičnih tipk, uporabite [pogovorno okno Kretenj Vnosa,](#InputGestures) da boste lahko določili bližnjico po meri taki zvrsti, kot je tipkovnični ukaz ali dotikabilna kretnja.

Zzvrsti nastavitev, ki se nahajajo v pogovornem oknu NVDA Nastavitev, so orisane v nadaljevanju.

#### Splošno (NVDA+control+g) {#GeneralSettings}

Zvrst Splošno iz pogovornega okna NVDA Nastavitev postavlja vedenje NVDA v celoti, kot je jezik vmesnika in ali naj ali ne NVDA samodejno preverja, če obstajajo posodobitve.
Ta zvrst vsebuje naslednje možnosti:

##### Jezik {#GeneralSettingsLanguage}

To je spustni seznam, kjer izbirate jezik, v katerem naj se prikazuje NVDA uporabniški vmesnik in sporočila.
Na voljo je veliko jezikov, privzeto pa NVDA upošteva sistemski jezik "Windows".
Možnost Privzeto pove NVDA, da naj uporabi jezik operacijskega sistema, ki je trenutno nastavljen.

Prosimo, pomnite, Za uveljavitev spremembe jezika, morate NVDA znova zagnati.
Ko se pokaže pogovorno okno za potrditev, izberite "zaženi zdaj" ali "zaženi kasneje", če  želite uporabljati nov jezik zdaj ali ob ustrezno kasnejšem času. Če boste izbrali "zaženi kasneje", boste morali shraniti konfiguracijo, (ali ročno ali z uporabo funkcije shrani ob izhodu).

##### Shrani konfiguracijo ob izhodu {#GeneralSettingsSaveConfig}

Ta možnost v obliki izbirnika, ko je izbrana, pove NVDA, da naj ob izhodu trenutno konfiguracijo samodejno shrani.

##### Prikaži izhodne možnosti ob izhodu iz NVDA {#GeneralSettingsShowExitOptions}

Ta možnost je izbirnik, ki vam omogoča izbiro prikaza pogovornega okna ob izhodu iz NVDA, ki vas sprašuje, katero dejanje naj se izvede.
Če boste to možnost izbrali, se bo ob izhodu prikazalo pogovorno okno z vprašanjem, kaj želite storiti; ali želite zapreti NVDA, jo želite ponovno zagnati, jo želite ponovno zagnati z onemogočenimi dodatki ali namestiti čakajoče posodobitve, če so kakšne.
Ko ta možnost ni izbrana, se bo NVDA po ukazu nemudoma izključila.

##### Predvajaj zvok ob zagonu in izhodu iz NVDA {#GeneralSettingsPlaySounds}

Ta možnost je izbirnik, ki pove NVDA, naj, ali pa ne, predvaja zvok ob zagonu NVDA in izhodu iz nje.

##### Nivo beleženja {#GeneralSettingsLogLevel}

To je spustni meni, ki vas spodbuja k izbiri, koliko bo NVDA beležila medtem, ko bo v uporabi.
V splošnem se uporabnikom tega ni potrebno dotikati, ker se ne beleži preveč.
Toda, če želite oskrbeti poročilo o napaki z informacijami ali popolnoma omogočiti ali onemogočiti beleženje v dnevnik, potem je to uporabna možnost.

Na voljo so tile nivoji beleženja:

* Onemogočeno: Razen kratkega sporočila o zagonu, NVDA ne bo beležila ničesar medtem, ko bo v pogonu.
* Info: NVDA bo beležila osnovne informacije, kot so sporočila ob zagonu in informacije uporabne za razvijalce.
* Opozorilo razhroščevanja: Sporočila z opozorili, ki jih niso povzročile resne napake, se bodo zabeležila.
* Vhod/izhod: Vnos prek tipkovnice in brajevih vrstic, kot seveda povratna govorna informacija in informacija v brajici se bo beležila.
 * Če vas skrbi zasebnost, nivo beleženja ne nastavite na to možnost.
* Razhroščevanje: Poleg info, opozorila in sporočil vhoda/izhoda, se bodo beležila dodatna sporočila za razhroščevanje.
 * Kot velja za vhod/izhod, ravno tako tudi tu velja, če vas skrbi zasebnost, ne smete nastaviti ravni beleženja na to možnost.

##### Samodejno zaženi NVDA po vpisu v Okna {#GeneralSettingsStartAfterLogOn}

Če boste izbrali to možnost, se bo NVDA zagnala takoj po vpisu v Okna.
Ta možnost je na voljo samo v nameščenih kopijah NVDA.

##### Uporabi NVDA med vpisom v Okna (potrebujete skrbniške pravice) {#GeneralSettingsStartOnLogOnScreen}

Če se v Okna vpisujete z uporabniškim imenom in geslom, se ob vključitvi te možnosti NVDA zaganja samodejno ob vpisu.
Ta možnost je na voljo samo v nameščenih kopijah NVDA.

##### Uporabljaj trenutno shranjene nastavitve med vpisom in na drugih "varnih" namizjih (potrebujete skrbniške pravice) {#GeneralSettingsCopySettings}

Pritisk tega gumba preslika trenutno shranjene uporabniške nastavitve v imenik sistemskih nastavitev za NVDA. Tako bo NVDA uporabljala te nastavitve, ko bo tekla ob vpisu, ob NUR Nadzoru uporabniških računov in drugih varnih namizjih v Oknih.
Da se bodo zagotovo preslikale vse vaše nastavitve, najprej shranite vaše nastavitve s control+NVDA+c ali shranite konfiguracijo v meniju NVDA z ukazom Shrani konfiguracijo.
Ta možnost je na voljo samo v nameščenih kopijah NVDA.

##### Samodejno preveri, če obstajajo posodobitve za NVDA {#GeneralSettingsCheckForUpdates}

Če je ta možnost izbrana, bo NVDA samodejno preverjala, če obstajajo posodobitv in vas bo obvestila, ko bodo na voljo.
Lahko pa obstoj posodobitev preverite tudi ročno z ukazom Preveri, če obstaja posodobitev v razdelku Pomoč NVDA menija.
Neglede na to, ali ročno preverjate, če obstaja posodobitev ali pa to NVDA počne samodejno, je nujno, da NVDA pošlje nekaj informacij strežniku za nadgraditve zaradi tega, da lahko prejmete ustrezno posodobitev za vaš sistem.
Vedno se pošiljajo te informacije:

* Trenutna različica NVDA
* različica Operacijskega Sistema
* Ali je Operacijski Sistem 64 ali 32 biten

##### Dovoli projektu NVDA zbiranje statistike rabe NVDA {#GeneralSettingsGatherUsageStats}

Če je to omogočeno, bo NV Access uporabila informacije pridobljene ob preverjanju za posodobitve tako, da bo z njihovo pomočjo lažje ugotavljala število uporabnikov NVDA vključno z nekaterimi demografskimi podatki, kot so Operacijski sistem in država izvora.
Pomnite, čeprav se bo s pomočjo vašega IP naslova izračunala vaša država med preverjanjem za posodobitev, se IP naslov ne bo hranil nikoli.
Razen obveznih informacij, ki so potrebne za preverbo posodobitve, se trenutno pošiljajo tudi dodatne informacije:

* jezik NVDA vmesnika
* Ali je ta kopija prenosljiva ali nameščena
* Ime trenutne govorne sinteze v uporabi (vključno z imenom dodatka, s katerim prihaja)
* Ime trenotne brajeve vrstice v uporabi (vključno z imenom dodatka, s katerim prihaja)
* Trenutna brajeva tabela za prikaz znakov, (če se brajica uporablja)

Te informacije bodo močno pomagale NV Access določiti prioritete pri razvoju NVDA v prihodnosti.

##### Obvesti za čakajoče posodobitve ob zagonu {#GeneralSettingsNotifyPendingUpdates}

Če je to izbrano, vas bo NVDA imformirala, ko je ob zagonu na voljo čakajoča posodobitev in vam ponudila možnost, da jo namestite.
Lahko pa tudi ročno namestite čakajočo posodobitev prek pogovornega okna za izhod iz NVDA (če je omogočeno), iz menija NVDA ali, ko boste izvedli novo preverbo iz menija Pomoči.

#### Nastavitve Govora (NVDA+control+v) {#SpeechSettings}

Zvrst Govor, ki se nahaja v pogovornem oknu NVDA Nastavitev, vsebuje možnosti, ki vam omogočajo spreminjanje govorne sinteze kot tudi značilnosti glasu izbrane sinteze.
Obstaja pa tudi še hitrejša pot za spreminjanje nastavitev glasu od kjerkoli. Prosimo, oglejte si razdelek [Krog Nastavitev Sinteze](#SynthSettingsRing).

Zvrst Nastavitev Govora vsebuje naslednje možnosti:

##### Zamenjaj Sintezo {#SpeechSettingsChange}

Prva možnost v zvrsti Nastavitev Govora je gumb Spremeni... Ta gumb vzpostavi pogovorno okno [Izberi Sintezo](#SelectSynthesizer), ki vam omogoča izbiro dejavne govorne sinteze in izhodne naprave.
To pogovorno okno se odpre nad pogovornim oknom Nastavitev NVDA.
Shranitev ali zavrzitev nastavitev v pogovornem oknu Izbire Sinteze vas bo vrnila v pogovorno okno NVDA Nastavitev.

##### Glas {#SpeechSettingsVoice}

Možnost Glas je spustni seznam z vsemi glasovi, ki pripadajo izbrani govorni sintezi in jih imate nameščene na računalniku.
Lahko uporabljate puščice za poslušanje različnih izbir.
Puščici gor in levo vas pomikata navzgor po seznamu ter puščici dol in desno navzdol po seznamu.

##### Oseba {#SpeechSettingsVariant}

Če uporabljate govorno sintezo ESpeak NG, ki je vključena v namestitveni paket NVDA, ta spustni seznam omogoči izbiro, s kakšno barvo glasu bi ESpeak NG morala delovati.
Osebe sinteze ESpeak NG so kot glasovi, saj vsebujejo različne karakteristike glede na značilnosti osnovne postavitve.
Nekatere osebe zvenijo kot moški, druge kot ženske in tretje kot "žabe".
Ko pa boste uporabljali sintezo tretjega proizvajalca, boste verjetno prav tako lahko spremenili to vrednost, če vaš izbrani glas podpira to funkcijo.

##### Hitrost {#SpeechSettingsRate}

Ta možnost omogoča spreminjanje hitrosti govora vašega glasu.
Deluje preko drsnika od 0 do 100, kjer 0 pomeni najpočasnejšo govorico in 100 najhitrejšo.

##### Višina {#SpeechSettingsPitch}

Ta možnost vam omogoča spreminjanje višine trenutnega glasu.
Deluje preko drsnika od 0 do 100, kjer 0 pomeni najnižji ton in 100 najvišji.

##### Glasnost {#SpeechSettingsVolume}

To je drsnik od 0 do 100, kjer je 0 najtišje govorjenje in 100 najglasnejše.

##### Glasovna modulacija {#SpeechSettingsInflection}

Ta možnost je v obliki drsnika od 0 do 100, kjer 0 pomeni najmanjšo možno modulacijo (spreminjanje višine med govorom) in 100 najvišjo možno modulacijo.

##### Samodejna menjava Jezika {#SpeechSettingsLanguageSwitching}

Ta izbirnik vklaplja stikalo samodejne zamenjave jezika govorne sinteze med branjem, če je v besedilu, ki ga prebirate, jezikovna zastavica, ki označuje jezik besedila.
Ta možnost je privzeto vključena.

##### Samodejna menjava Narečja {#SpeechSettingsDialectSwitching}

Ta možnost omogoča, če je izbrana, da sinteza menja tudi narečje, ne samo jezika.
To pomeni sledeče, da bo govorna sinteza dokument prebrala z britanskim naglasom, čeprav je prednastavljen jezik Ameriška Angleščina. Vse to seveda zavisi od zastavic, s katerimi je opremljen dokument.
Ta možnost je privzeto izključena.

<!-- KC:setting -->

##### Nivo Naglaševanja/Simbolov {#SpeechSettingsSymbolLevel}

Tipka: NVDA+p

To vam omogoča izbiro vrednosti naglaševanja in izgovorjave drugih simbolov, ki morajo biti brani kot besede.
Ko je vrednost v tem spustnem meniju nastavljena na vse, potem se bodo vsi simboli brali z besedami.
Ta možnost vpliva na vse sinteze in ne samo na tisto, ki je trenutno v uporabi.

##### Zaupaj jeziku osebe med obdelovanjem simbolov in znakov {#SpeechSettingsTrust}

Ta možnost, ki je privzeto vključena, pove NVDA, naj se pri obdelovanju znakov in simbolov zanaša na jezik osebe (slovar govorne sinteze preglasi slovar vgrajen v NVDA).
Če ugotovite, da NVDA napačno izgovarja posamezno ločilo v nekem jeziku ob nastavitvi glasu ali govorne sinteze v celoti, potem lahko to možnost izključite, da NVDA vsilite uporabo globalnih jezikovnih nastavitev.

##### Vključi podatke konzorcija Unicode (vključno z emojii) ko se obdeluje znake in simbole {#SpeechSettingsCLDR}

Ko bo ta izbirnik izbran, bo NVDA vključila dodatne slovarje za izgovorjavo simbolov, ko bo izgovarjala znake in simbole.
Ti slovarji vsebujejo opise simbolov (predvsem emojiev), ki jih je oskrbel [Unicode konzorcij](https://www.unicode.org/consortium/) kot del njihovega [Enotnega Lokalnega Podatkovnega Repozitorija](http://cldr.unicode.org/).
Če želite, da bo NVDA izgovarjala opise znakov za emojie, ki bazirajo na teh podatkih, morate to možnost omogočiti.
Vendar, če uporabljate govorno sintezo, ki že sama podpira izgovorjavo opisov emojiev, boste morda želeli to izključiti.

Pomnite, da so ročno dodani ali urejeni opisi znakov shranjeni kot del vaših osebnih nastavitev.
Torej, če boste spremenili opis določenega emojia, se bo vaš opis po meri tega emojia izgovoril neglede na to ali je ta možnost izbrana.
Vi lahko dodajate, urejate ali odstranite opise simbolov v NVDA [pogovornem oknu izgovorjave ločil/simbolov](#SymbolPronunciation).

Za vklop ali izklop  vključitve podatkov konzorcija Unicode od kjerkoli, prosimo, dodelite kretnjo po meri z uporabo pogovornega okna [Kretenj Vnosa](#InputGestures).

##### Sprememba višine glasu ob velikih črkah v odstotkih {#SpeechSettingsCapPitchChange}

To vnosno polje omogoča vnos vrednosti razlike v tonu glasu, za katero se bo glas zvišal, ko bo sinteza izgovarjala veliko črko.
Ta vrednost je v odstotkih, kjer negativna vrednost zniža odstotke od osnove in pozitivna vrednost te zviša.
Če želite, da se višine ne spreminja, vnesite 0.
Običajno, NVDA malenkostno dvigne višino glasu za vsako veliko črko, toda nekatere sinteze ne podpirajo te funkcije korektno.
V slučaju, da sprememba višine ni podprta za velike črke, razmislite namesto tega o vključitvi možnosti [Reci "velika" pred velikimi črkami](#SpeechSettingsSayCapBefore) in/ali [Oddaj pisk ob velikih črkah](#SpeechSettingsBeepForCaps).

##### Reci "velika" pred velikimi črkami {#SpeechSettingsSayCapBefore}

Ta nastavitev je izbirnik in ko je izbran, pove NVDA, naj pred velikimi črkami reče "velika", ko črke izgovarja posamezno kot je črkovanje.

##### Oddaj pisk ob velikih črkah {#SpeechSettingsBeepForCaps}

Če je ta izbirnik izbran, bo NVDA oddala kratek pisk vedno, ko bo zaznala veliki znak.

##### Uporabljaj funkcijo črkovanja, če je podprta {#SpeechSettingsUseSpelling}

Nekatere besede sestavlja samo ena črka, toda njihova izgovorjava je različna glede na to ali se znak izgovarja kot samostojna enota (kot pri črkovanju) ali izgovorjavi besede.
Na primer v Angleščini je "a" tako znak kot beseda. Ker je tako, se to tudi različno izgovarja.
Ta možnost omogoča govorni sintezi ločevanje med tema dvema dogodkoma, če to govorna sinteza podpira.
Večina sintez to podpira.

Ta možnost bi običajno morala biti omogočena.
Kakorkoli, v nekatere govorne sinteze, ki uporabljajo tehnologijo Microsoft speech API, niso te funkcije pravilno vgradili v sistem in se tako obnašajo tuje, ko je ta možnost vključena.
Če imate težave pri izgovorjavi posameznih znakov, poskusite z izklopom te možnosti.

#### Izbira Sinteze (NVDA+control+s) {#SelectSynthesizer}

Pogovorno okno Sinteze, ki se lahko odpre prek sprožitve Gumba Spremeni..., v zvrsti Govor pogovornega okna NVDA Nastavitev, vam omogoča izbiro, s katero govorno sintezo naj NVDA govori.
Ko izberete sintezo, pritisnite V redu in NVDA bo naložila izbrano sintezo.
Če pri nalaganju pride do napake, vas bo NVDA o tem obvestila in nadaljevala z uporabo prej izbrane sinteze.

##### Sinteza {#SelectSynthesizerSynthesizer}

Ta možnost vam omogoča izbiro sinteze, s katero želite, da NVDA govori.

Seznam podprtih govornih sintez se nahaja v razdelku [Podprte govorne sinteze](#SupportedSpeechSynths), prosimo, oglejte si ga.

Posebna postavka, ki se bo vedno prikazala, je "Brez govora", z izbiro katere NVDA ne govori več.
To je uporabno za tiste, ki želijo NVDA uporabljati samo z brajico ali za videčega razvijalca, ki bo uporabljal samo prikazovalnik govora.

##### Izhodna naprava {#SelectSynthesizerOutputDevice}

Ta možnost vam omogoča izbiro zvočne naprave, preko katere naj NVDA napoti zvok govorne sinteze.

<!-- KC:setting -->

##### Delovanje Stišanja Zvokov {#SelectSynthesizerDuckingMode}

Tipka: NVDA+shift+d

V sistemu Windows 8 in novejših vam ta možnost omogoča, da NVDA zniža glasnost ostalih zvokov, ko NVDA govori ali stalno, ko NVDA teče.

* Brez Stišanja: NVDA ne bo nikoli stišala (znižala glasnosti) ostalih zvokov.
* Stišaj, ko NVDA govori ali oddaja lastne zvoke: NVDA bo znižala glasnost ostalih zvokov samo takratk, ko bo sama govorila ali oddajala lastne zvoke.
* Vedno stišaj: Ostali zvoki se bodo predvajali na naižji glasnosti ves čas medtem, ko bo NVDA v pogonu.

Ta možnost je na voljo samo takrat, ko je NVDA nameščena v sistemu.
Stišanja zvokov v prenosljivi in začasni kopiji NVDA ni mogoče podpreti.

#### Krog nastavitev sinteze {#SynthSettingsRing}

Če želite hitro spreminjati nekatere govorne nastavitve brez, da bi morali odpreti zvrst Nastavitev Govora v pogovornem oknu NVDA Nastavitev, imate na voljo nekaj NVDA ukazov, ki vam omogočajo spreminjanje najbolj uporabnih nastavitev od kjerkoli, ko je NVDA vključena:
<!-- KC:beginInclude -->

| Ime |Običajna razporeditev |razporeditev Prenosnik |Opis|
|---|---|---|---|
|Pomik na naslednjo nastavitev glasu |NVDA+control+Puščica desno |NVDA+shift+control+Puščica desno |Se pomakne na naslednjo nastavitev govora na voljo za trenutno, s preskokom na prvo, če smo na zadnji|
|Pomik na predhodno nastavitev glasu |NVDA+control+Puščica levo |NVDA+shift+control+Puščica levow |Se pomakne na predhodno nastavitev govora na voljo pred trenutno, s preskokom na zadnjo, če smo na prvi|
|Poveča trenutno glasovno nastavitev |NVDA+control+Puščica gor |NVDA+shift+control+Puščica gor |Poveča vrednost govorne nastavitve, kjer trenutno stojite. Npr. poveča hitrost, se premakne na naslednji glas ali poviša glasnost|
|Pomanjša trenutno glasovno nastavitev |NVDA+control+Puščica dol |NVDA+shift+control+Puščica dol |Pomanjša vrednost govorne nastavitve, kjer trenutno stojite. Npr. pomanjša hitrost, se premakne na predhodni glas ali zniža glasnost|

<!-- KC:endInclude -->

#### Nastavitve Brajice {#BrailleSettings}

Zvrst Brajica v pogovornem oknu NVDA Nastavitev vsebuje možnosti, ki vam omogočajo spremembo večih vidikov prikaza v brajici in vnosa v njej.
Ta zvrst vsebuje naslednje možnosti:

##### Zamenjaj brajevo vrstico {#BrailleSettingsChange}

Gumb Spremeni... v zvrsti Brajica v pogovornem oknu NVDA Nastavitev vzpostavi pogovorno okno [Izberi Brajevo Vrstico](#SelectBrailleDisplay), ki vam omogoča izbiro dejavne brajeve vrstice.
To pogovorno okno se odpre nad pogovornim oknom NVDA Nastavitev.
Shranitev ali zavrzitev nastavitev v pogovornem oknu Izbire Brajeve Vrstice vas bo vrnila nazaj v pogovorno okno NVDA Nastavitev.

##### Tabela za Prikaz {#BrailleSettingsOutputTable}

Naslednja možnost, na katero boste naleteli v tej zvrsti, je spustni seznam tabel za prikaz.
V tem spustnem seznamu boste našli brajeve tabele za različne jezike, brajeve standarde in krajšave.
Tabela, ki jo izberete, se uporablja za prenos besedila v brajico za prikaz na vaši brajevi vrstici.
Med tabelami v seznamu se premikate s puščicami.

##### Tabela za Vnos {#BrailleSettingsInputTable}

Nasprotno od prejšnje možnosti, je naslednja nastavitev, ki jo boste našli, spustni seznam tabel za vnos.
Tabela, ki jo izberete, se uporablja za prevod brajevih vnosov vnešenih preko tipkovnice tipa Perkins v besedilo.
Med tabelami v seznamu se pomikate s puščicami.

Opozarjamo, da je ta možnost uporabna samo, če imate na vaši brajevi vrstici tipkovnico tipa Perkins in da gonilnik te brajeve vrstice to možnost podpira.
Če vrstica, ki vsebuje brajevo tipkovnico, vnosov ne podpira, bo to zapisano v razdelku [Podprte Brajeve Vrstice](#SupportedBrailleDisplays).

##### Razširi v računalniško brajico za besedo pod utripalko {#BrailleSettingsExpandToComputerBraille}

Ta možnost omogoča prikaz besede, ki se nahaja pod utripalko, v pravi računalniški brajici.

##### Prikaži Utripalko {#BrailleSettingsShowCursor}

Ta možnost omogoča vključitev in izključitev brajeve utripalke.
To velja za sistemsko kazalko in pregledno utripalko, ne velja pa za indikator izbire.

##### Pulz Utripalke {#BrailleSettingsBlinkCursor}

Ta možnost omogoča nadzor nad pulzom (utripom) utripalke na brajevi vrstici.
Če je pulz izklopljen, potem je utripalka na vrstici vedno v položaju "gor".
To ne vpliva na naznačevalca izbire. Ta je vedno določen s pikama 7 in 8, ki ne utripata.

##### Hitrost Utripalkinega pulza (ms) {#BrailleSettingsBlinkRate}

Ta možnost je številčno polje, ki vam omogoča spremembo hitrosti utripalkinega pulza v milisekundah.

##### Oblika Utripalke za Žarišče {#BrailleSettingsCursorShapeForFocus}

Ta možnost vam omogoča izbiro oblike (vzorca pik), ki bo prikazoval položaj brajeve utripalke, ko bo spremljanje nastavljeno na žarišče.
To ne vpliva na naznačevalca izbire. Ta je vedno določen s pikama 7 in 8, ki ne utripata.

##### Oblika Utripalke za Pregled {#BrailleSettingsCursorShapeForReview}

Ta možnost vam omogoča izbiro oblike (vzorca pik), ki bo prikazoval položaj brajeve utripalke, ko bo spremljanje nastavljeno na pregled.
To ne vpliva na naznačevalca izbire. Ta je vedno določen s pikama 7 in 8, ki ne utripata.

##### Prikaz Sporočila (v sekundah) {#BrailleSettingsMessageTimeout}

Ta možnost je številčno polje, ki nadzira, koliko dolgo bodo sporočila NVDA prikazana na brajevi vrstici.
Nastavitev tega polja na 0 onemogoči prikaz teh sporočil.

##### Kaži Sporočila v Nedogled {#BrailleSettingsNoMessageTimeout}

Ta možnost omogoča sporočilom NVDA, da bodo prikazana na brajevi vrstici, toliko časa, dokler jih ne boste ročno zavrgli v obliki drugega sporočila s premikom žarišča ipd.

##### Navezava Brajice {#BrailleTether}

Tipka: NVDA+control+t

Ta možnost vam omogoča, da določite, ali naj brajeva vrstica sledi sistemskemu žarišču/sistemski kazalki, predmetu krmiljenja/pregledni utripalki, ali obema.
Ko je "Samodejno" izbrano, bo privzeto NVDA sledila sistemskemu žarišču in kazalki.
V tem primeru, ko je predmet krmiljenja ali položaj pregledne utripalke spremenjen zaradi določne uporabnikove interakcije, se bo NVDA začasno navezala na pregled do naslednje spremembe žarišča ali kazalke.
Če želite, da se sledi samo žarišču in kazalki , morate nastaviti navezavo brajice na žarišče.
V tem primeru brajica ne bo sledila NVDA krmiljenju med krmiljenjem predmeta ali pregledni utripalki med pregledom.
Če želite, da brajjica sledi samo krmiljenju predmeta in pregledu besedila namesto tega, morate nastaviti navezavo brajice na pregled.
V tem primeru Brajica ne bo sledila sistemskemu žarišču in sistemski kazalki.

##### Beri po Odstavku {#BrailleSettingsReadByParagraph}

Če to možnost omogočite, bo brajeva vrstica prikazovala odstavke namesto vrstic.
Prav tako bosta ukaza za premik v naslednjo in v prejšnjo vrstico pomikala napravo po odstavkih.
To pomeni, da vam ni potrebno pomikati naprave vsakič v novo vrstico, če tudi bo na vrstici več besedila.
To zna olajšati branje večjih količin besedila.
Ta možnost je privzeto onemogočena.

##### Prepreči deljenje besed, ko je to mogoče {#BrailleSettingsWordWrap}

Če je ta možnost vključena, se beseda, ki sega čez meje brajeve vrstice, ne bo presekala.
Namesto tega bo na koncu vrstice nekaj praznega prostora.
Ko se boste po besedilu sprehajali z vrstico, boste tako lahko imeli možnost prebrati celotno besedo.
To se včasih v Angleščini imenuje tudi "Word wrap".
Opozarjamo, da se mora beseda vseeno prelomiti, če je sama po sebi daljša (če obsega več znakov), kot pa je število vseh celic na vrstici.

Če je ta možnost izključena, se bo na vrstici prikazalo toliko besede, kot je mogoče, ostalo se bo odrezalo.
Ko se boste z vrstico premaknili, boste lahko prebrali ostanek besede.

Vključitev te možnosti vam bo verjetno olajšala branje, vendar boste na splošno morali vrstico večkrat premikati.

##### Žarišče predstavitve konteksta {#BrailleSettingsFocusContextPresentation}

Ta možnost vam omogoča izbiro, kaj od  informacije o kontekstu vam bo NVDA pokazala tudi na vaši brajevi vrstici, ko se predmet postavi v žarišče.
Informacija o kontekstu se nanaša na hierarhijo predmeta, ki vsebuje žarišče.
Na primer, ko postavite v žarišče postavko na seznamu, je ta postavka del seznama.
Nato bi lahko bil ta seznam del pogovornega okna ipd.
Prosimo, oglejte si razdelek o [predmetu krmiljenja](#ObjectNavigation) za več informacij o hierarhiji, ki se nanaša na predmete v NVDA.

Ko je izbrana možnost Zapolni vrstico s spremembami konteksta, bo NVDA poskušala prikazati toliko informacij, kot bo le mogoče na brajevi vrstici, vendar to velja samo za dele konteksta, ki so se spremenili.
Za zgornji primer to pomeni, ko se bo žarišče postavilo na seznam, bo NVDA na brajevi vrstici pokazala postavko na seznamu.
Poleg tega, če bo ostalo dovolj prostora na brajevi vrstici, bo NVDA skušala pokazati tudi, da je ta postavka na seznamu del seznama.
Če se potem začnete s puščicami pomikati po seznamu, se predpostavlja, da veste, da ste še vedno na seznamu.
Tako bo, ob preostalih postavkah na seznamu, ki jih boste postavili v žarišče, NVDA na vrstici pokazala samo postavko na seznamu, ki je v žarišču.
Če in ko boste znova želeli prebrati kontekst, (npr., da ste na seznamu in da je ta seznam del pogovornega okna), boste svojo brajevo vrstico morali zavrteti nazaj.

Ko je možnost nastavljena na Vedno zapolni vrstico, NVDA poskuša pokazati toliko kontekstnih informacij, kot je možno na brajevi vrstici; neglede na to, kje ste videli enako kontekstno informacijo prej.
Prednost tega je, da bo NVDA dobavila na vrstico toliko informacij, kot je mogoče.
Vendar je slabost tega ta, da je položaj, kjer se začenja vsebina žarišča, vedno drugje kot prej na vrstici.
To tako lahko precej oteži prelet daljšega seznama. Na primer, zato boste morali vaš prst ves čas pomikati, da boste našli začetek postavke.
To je bilo privzeto vedenje v različicah NVDA 2017.2 in prejšnjih.

Ko nastavite možnost žarišča informacije konteksta na "Samo ob pomiku nazaj", vam NVDA privzeto ne bo nikoli pokazala informacije o kontekstu na vaši brajevi vrstici.
Tako vam bo v zgornjem primeru NVDA pokazala samo, da je v žarišču postavka na seznamu.
Kko boste želeli prebrati kontekst, (npr., da ste na seznamu in da je ta seznam del pogovornega okna), boste svojo brajevo vrstico morali zavrteti nazaj.

Za preklop žarišča informacije o kontekstu od kjerkoli, prosimo, določite vašo izbrano kretnjo z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).

#### Izberi Brajevo Vrstico (NVDA+control+a) {#SelectBrailleDisplay}

Pogovorno okno Izbire Brajeve Vrstice, ki se lahko odpre prek sprožitve gumba Spremeni... v zvrsti Brajica pogovornega okna NVDA Nastavitev, vam omogoča izbiro vrstice, ki jo mora NVDA uporabljati  za prikaz brajice.
Ko ste enkrat izbrali vašo željeno brajevo vrstico, lahko pritisnete gumb V redu in NVDA bo potem naložila izbrano vrstico.
Če se pojavi napaka pri poskusu naložitve gonilnika brajeve vrstice, vas bo NVDA o tem obvestila s sporočilom ter nadaljevala z uporabo prejšnje vrstice, če se je uporabljala.

##### Brajeva Vrstica {#SelectBrailleDisplayDisplay}

Ta spustni seznam vam predstavlja več možnosti, ki so odvisne od tega, kateri gonilniki brajevih vrstic so na voljo v vašem sistemu.
Med temi možnostmi se premikate s puščicami.

Možnost samodejne prepoznave bo dovolila NVDA, da bo iskala med večjim številom podprtih brajevih vrstic v ozadju.
Ko je ta značilnost izbrana in priključite podprto vrstico z uporabo USB ali Bluetooth povezave, se NVDA samodejno poveže s to vrstico.

Brez brajice pomeni, da ne uporabljate brajice.

Prosimo, glejte razdelek [Podprte Brajeve Vrstice](#SupportedBrailleDisplays) za več informacij o podprtih brajevih vrsticah in katere od njih podpirajo samodejno zaznavo v ozadju .

##### Vrata {#SelectBrailleDisplayPort}

Ta možnost, če je na voljo, omogoča izbiro vrat ali tip povezave, ki se bo uporabljala za komunikacijo z brajevo vrstico, ki ste jo izbrali.
To je spustni seznam, ki vsebuje mogoče možnosti za vašo brajevo vrstico.

Privzeto NVDA izbere samodejno zaznavo vrat, kar pomeni, da bo povezava z brajevo napravo vzpostavljena samodejno z iskanjem USB in bluetooth naprav na vašem sistemu.
Kakorkoli, za nekatere brajeve vrstice boste verjetno morali sami jasno določiti, katera vrata naj se uporabljajo.
Možnosti, ki so na voljo, so "Samodejno", (kar pove NVDA naj uporabi privzeto proceduro samodejne izbire), "USB", "Bluetooth" in običajna serijska vrata, če vaša brajeva vrstica podpira ta tip komunikacije.

Ta možnost ni na voljo, če vaša brajeva vrstica podpira samo samodejno izbiro vrat.

Priporočamo ogled dokumentacije za vašo brajevo vrstico v razdelku [Podprte Brajeve Vrstice](#SupportedBrailleDisplays) za preverbo več podrobnosti o podprtih tipih komunikacije in vratih, ki so na voljo.

#### Vidnost {#VisionSettings}

Zvrst Vidnost v pogovornem oknu NVDA Nastavitev vam dovoljuje omogočiti, onemogočiti in nastaviti [pripomočke za vidnost](#Vision).

Pomnite, da se lahko možnosti, ki so na voljo v tej zvrsti, razširijo z [NVDA dodatki](#AddonsManager).
Privzeto ta zvrst nastavitev vsebuje sledeče možnosti:

##### Poudarek Žarišča {#VisionSettingsFocusHighlight}

Izbirniki v skupini Poudarka Žarišča nadzirajo vedenje v NVDA vgrajene zmožnosti [Poudarka Žarišča](#VisionFocusHighlight).

* Omogoči Poudarjanje: Vklaplja in izklaplja Poudarek Žarišča.
* Poudari sistemsko žarišče: stikalo za to, da bodisi bo ali ne bo [sistemsko žarišče](#SystemFocus) poudarjeno.
* Poudari predmet krmiljenja: stikalo za to, da bodisi bo ali ne bo [predmet krmiljenja](#ObjectNavigation) poudarjen.
* Poudari utripalko v brskalniškem delovanju: stikalo za to, da bodisi bo ali ne bo [navidezna utripalka v brskalniškem delovanju](#BrowseMode) poudarjena.

Pomnite, da izbor izbirnika "Omogoči Poudarjanje" in njegov preklic glede na to spremeni tudi stanje drevesa ostalih izbirnikov.
Tako, če je "Omogoči Poudarjanje" izključen, in vi izberete ta izbirnik, bo ostalo drevo izbirnikov prav tako samodejno izbrano.
Če želite poudariti samo žarišče in pustiti izbirnik predmeta krmiljenja in izbirnik brskalniškega delovanja neizbrana, bo stanje izbirnika "Omogoči Poudarjanje" polovično izbrano.

##### Preveza čez ekran {#VisionSettingsScreenCurtain}

[Prevezo čez ekran](#VisionScreenCurtain) lahko omogočite z izborom izbirnika "Naredi ekran črn" (učinkuje takoj).
Opozorilo, vaš ekran bo postal črn po prikazu sprožitve.
Pred nadaljevanjem (pritiskom "Da"), se prepričajte, da imate omogočen govor / brajico in da boste lahko nadzirali vaš računalnik brez uporabe ekrana.
Pritisnite "Ne", če ne želite več omogočiti Preveze čez Ekran.
Če ste prepričani, lahko izberete "Da" gumb za omogočitev Preveze čez Ekran.
Če ne želite več videti tega sporočila z opozorilom vsakič, lahko spremenite to vedenje v pogovornem oknu, ki prikazuje to sporočilo.
Vedno pa lahko obnovite opozorilo z izborom izbirnika "Vedno pokaži opozorilo, ko se nalaga Preveza čez Ekran" zraven izbirnika "Naredi ekran črn".

Za pretik Preveze čez ekran od kjerkoli, prosimo, določite kretnjo po meri z uporabo  [pogovornega okna Kretenj Vnosa](#InputGestures).

Privzeto se zaigra zvok, ko se pretakne Preveza čez Ekran.
Ko boste želeli spremeniti to vedenje, lahko odznačite izbirnik "Zaigraj zvok, ko se pretika Preveza čez Ekran".

##### Nastavitve za pripomočke za vidnost iz tretjih strani {#VisionSettingsThirdPartyVisualAids}

Dodatne oskrbe izboljšave vidnosti se lahko oskrbijo v [dodatkih za NVDA](#AddonsManager).
Ko bodo te oskrbe imele prilagodljive nastavitve, se bodo te pokazale v tej zvrsti nastavitev v ločenih skupinah.
Za podprte nastavitve glede na oskrbo, si prosimo, oglejte  dokumentacijo za to oskrbo.

#### Tipkovnica (NVDA+control+k) {#KeyboardSettings}

Zvrst Tipkovnica v pogovornem oknu NVDA Nastavitev vsebuje možnosti, ki določajo, kako se obnaša NVDA, ko uporabljate in tipkate na tipkovnico.
Ta zvrst nastavitev vsebuje naslednje možnosti:

##### Razporeditev tipk {#KeyboardSettingsLayout}

Na tem spustnem seznamu se nahajajo razporeditve tipk, po katerih mora delati NVDA. Izbirate lahko med večimi razporeditvami. Trenutno sta na voljo razporeditvi "Običajna" in Prenosnik.

##### Določi NVDA Prikrojevalne Tipke {#KeyboardSettingsModifiers}

Izbirnik na tem seznamu nadzira, katere tipke se lahko uporabijo kot [NVDA prikrojevalne tipke](#TheNVDAModifierKey).

* Tipka Caps Lock
* Tipka insert na številskem delu
* Tipka insert (običajno postavljena nad puščicami, zraven tipk home in end)

Če nobena tipka ni izbrana kot NVDA prikrojevalna tipka, potem se ne mora izvesti cela kopica ukazov nad NVDA.
Zaradi tega bo pogovorno okno NVDA Nastavitev prikazalo sporočilo o napaki, če ob pritisku gumba V redu ne bo izbrana nobena tipka.
Po odstranitvi sporočila o napaki, morate izbrati vsaj eno tipko, da se pogovorno okno po pritisku gumba V redu, pravilno zapre.

##### Izgovori Natipkane Znake {#KeyboardSettingsSpeakTypedCharacters}

Tipka: NVDA+2

Ko je ta zmožnost omogočena, bo NVDA naznanila vse znake, ki jih boste tipkali na tipkovnici.

##### Izgovori Natipkane Besede {#KeyboardSettingsSpeakTypedWords}

Tipka: NVDA+3

Ko je ta zmožnost omogočena, bo NVDA naznanila vse besede, ki jih boste tipkali na tipkovnici.

##### Prekini govor ob pritisku znakov {#KeyboardSettingsSpeechInteruptForCharacters}

Če je omogočeno, ta funkcionalnost povzroči prekinitev govora ob vsakem pritisku na znak. Privzeto je ta zmožnost vključena.

##### Prekini govor ob pritisku tipke Enter {#KeyboardSettingsSpeechInteruptForEnter}

Če je ta funkcionalnost vključena, se govor zaustavi vsakič, ko pritisnete tipko Enter. Ta zmožnost je privzeto vključena.

##### Omogoči hitro branje v načinu Izgovori Vse {#KeyboardSettingsSkimReading}

Če je vključeno, precej ukazov za krmiljenje, (kot so hitre tipke za krmiljenje v brskalniškem delovanju ali premik po vrstici in odstavku), ne bodo zaustavile branja celotnega besedila, na mesto tega bo NVDA preskočila na nov položaj in od tam nadaljevala z branjem.

##### Oddaj Zvočni Signal, ko se Pišejo Male Črke  in je Caps Lock Vključen {#KeyboardSettingsBeepLowercase}

Če je to omogočeno, se bo zaslišal opozorilni zvočni signal, ko boste tipkali s pritiskom tipke Shift ob tem, ko bo Caps Lock vključen.
V splošnem je tipkanje besed z veliko začetnico, ko je Caps Lock vključen, nenamerno in se običajno zgodi zaradi tega, ker se spregleda, da je Caps Lock vključen.
Tako nam opozorilo velikokrat pomaga in prepreči morebitno napačno črkovanje.

##### Izgovarjaj Tipke ob Prožitvi Ukazov {#KeyboardSettingsSpeakCommandKeys}

Tipka: NVDA+4

Ko je to omogočeno, NVDA naznani vse pritiske na tipkovnici, ki niso nujno povezani s pisanjem črk. To vključuje pritiske kombinacij tipk, na primer Control+črka.

##### Oddaj zvok ob napaki v črkovanju med tipkanjem {#KeyboardSettingsAlertForSpellingErrors}

Ko bo ta možnost vključena, bo NVDA predvajala kratek praskajoč zvok ob besedi, pri kateri bo zaznana napaka črkovanja.
Ta možnost bo na voljo samo takrat, ko bo Sporočanje napak črkovanja omogočeno v [Nastavitvah Oblikovanja Dokumentov](#DocumentFormattingSettings), ki se nahajajo v pogovornem oknu NVDA Nastavitev.

##### Obravnavaj pritiske tipk s strani drugih programov {#KeyboardSettingsHandleKeys}

Ta možnost omogoča uporabniku nadzor nad tem, kako NVDA obravnava pritiske tipk, ki jih prožijo drugi programi, kot so tipkovnice na zaslonu ali programi za prepoznavo govora. Če je možnost vključena, potem to vpliva na delovanje NVDA.
Ta možnost je ob namestitvi NVDA privzeto vključena, toda nekateri uporabniki jo bodo morda morali izključiti. Taki so uporabniki, ki tipkajo v Vietnamščini, saj ta možnost povzroča napačne vnose v programu UniKey typing.

#### Miška (NVDA+control+m) {#MouseSettings}

Zvrst Miška v pogovornem oknu NVDA Nastavitev dovoljuje NVDA, da sledi miško, igra miškine koordinate s piski in določa druge možnosti za miško.
Ta zvrst vsebuje naslednje možnosti:

##### Poročaj o Spremembi Oblike Miške {#MouseSettingsShape}

Je izbirnik in ko je izbran, bo NVDA naznanila spremembo oblike miškinega kazalca vedno, ko se bo ta spremenila.
V Oknih miškin kazalec spremeni obliko, ko nakaže, da je naprimer nekaj možno urejati, ko se nekaj nalaga in drugo.

<!-- KC:setting -->

##### Omogoči sledenje miške {#MouseSettingsTracking}

Tipka: NVDA+m

Ko je ta možnost izbrana, bo NVDA naznanjala besedilo, ki je v tem trenutku pod miškinim kazalcem, ko miško premikate po zaslonu. To vam omogoča, da najdete predmete na zaslonu s premikanjem prave miške namesto uporabe skozi krmiljenje predmeta.

##### Resolucija enote besedila {#MouseSettingsTracking}

Če ste NVDA nastavili tako, da pove, kaj je pod miško, ko jo premikate, vam ta možnost ponuja izbiro, koliko besedila naj se prebere.
Možnosti so znak, beseda, vrstica in odstavek.

Za preklop enote resolucije besedila od kjerkoli, prosimo, določite kretnjo po meri z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).

##### Poročaj o vlogi predmeta, ko miška vstopi nanj {#MouseSettingsRole}

Če je ta možnost izbrana, bo NVDA naznanila vlogo (tip) predmeta, ko se miška pomika po njem.

##### Zaigraj avdio koordinate, ko se miška premika {#MouseSettingsAudio}

Izbira te možnosti naroča NVDA, naj oddaja piske, ko se miška premika, tako da uporabnik lahko ugotavlja kje je miška v odnosu na zaslonski položaj.
Višji ton pomeni, da je miška višje na zaslonu.
Bolj, kot je miška na levi ali desni strani zaslona, bolj izrazit bo zvok na levi ali desni strani ob predpostavki, da ima uporabnik stereo zvočnike ali slušalke.

##### Svetloba nadzira jakost zvočnih piskov {#MouseSettingsBrightness}

Če je možnost "Zaigraj avdio koordinate, ko se miška premika" izbrana, potem to pomeni, da se jakost zvoka piskov nadzira. Jakost zvoka je odvisna od svetlosti zaslona pod miškinim kazalcem.
Ta nastavitev je privzeto izključena.

##### Prezri vnos miške iz drugih programov {#MouseSettingsHandleMouseControl}

Ta možnost dovoljuje uporabniku, da prezre dogodke povezane z miško (vključno s premikom miške in pritiski gumba), ki jih povzročijo drugi programi, kot je TeamViewer in drugi programi za oddaljen nadzor.
Ta možnost je privzeto odznačena.
Če izberete to možnost in hkrati imate izbrano tudi možnost "Omogoči sledenje miške", vam NVDA ne bo naznanila, kaj je pod miško, ko se bo miška premikala zaradi drugega programa.

#### Interakcija z Dotikom {#TouchInteraction}

Ta zvrst nastavitev, ki je na voljo samo na računalnikih, kjer tečejo Windows 8 ali novejši in z zaznavami dotika, vam omogoča nastaviti, kako seNVDA obnaša na zaslonih na dotik.
Ta zvrst vsebuje naslednje možnosti:

##### Delovanje tipkanja z dotikom {#TouchTypingMode}

Ta izbirnik vam omogoča, da določite metodo, ki jo želite uporabljati, ko boste vnašali besedilo z uporabo tipkovnice na dotik.
Če je ta izbirnik izbran, se bo tipka na tipkovnici na dotik pritisnila, ko boste to tipko locirali in potem prst dvignili.
Če izbirnik ni izbran, boste morali izvesti dvojni tap na tipki s tipkovnice na dotik, da jo boste pritisnili.

#### Pregledna Utripalka {#ReviewCursorSettings}

Zvrst Pregledna Utripalka v pogovornem oknu NVDA Nastavitev se uporablja za nastavitev vedenja pregledne utripalke NVDA.
Ta zvrst vsebuje sledeče možnosti:

<!-- KC:setting -->

##### Sledi Sistemskemu Žarišču {#ReviewCursorFollowFocus}

Tipka: NVDA+7

Ko je možnost vključena, se pregledna utripalka vedno postavi na isti predmet kot sistemsko žarišče, kadarkoli se žarišče spremeni.

<!-- KC:setting -->

##### Sledi Sistemski Kazalki {#ReviewCursorFollowCaret}

Tipka: NVDA+6

Ko je možnost vključena, se bo pregledna utripalka samodejno premaknila na položaj sistemske kazalke vsakič, ko se bo kazalka premaknila.

##### Sledi miškini utripalki {#ReviewCursorFollowCaret}

Ko možnost vključite, bo pregledna utripalka sledila vsem premikom miške.

##### Delovanje Enostavnega Pregleda {#ReviewCursorSimple}

Ko boste možnost vključili, bo NVDA izvedla filtracijo v hierarhiji predmetov, po katerih se lahko premikamo, z izključitvijo predmetov, ki niso za uporabnika. To so na primer navidezni predmeti in predmeti, ki so tu predvsem zaradi oblikovanja.

Za preklapljanje delovanja enostavnega pregleda od kjerkoli, prosimo, določite kretnjo po meri z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).

#### Predstavitev Predmeta (NVDA+control+o) {#ObjectPresentationSettings}

Zvrst Predstavitev Predmeta v pogovornem oknu NVDA Nastavitev se uporablja za določitev, koliko informacij vam bo NVDA predstavila o kontrolnikih, kot je opis, informacija o položaju in tako naprej.
Ta zvrst nastavitev vsebuje naslednje možnosti:

##### Sporočaj Zaslonske Namige {#ObjectPresentationReportToolTips}

To je izbirnik, ki NVDA sporoča, naj pove, kaj vsebujejo zaslonski namigi, ko je izbran.
Veliko oken in kontrolnikov prikazuje majhna sporočila (ali zaslonske namige), ko pomaknete miškin kazalec prek njih ali ko včasih pomaknete žarišče nad njih.

##### Sporočaj obvestila {#ObjectPresentationReportNotifications}

Ko je ta izbirnik izbran, pove NVDA, naj sporoča vsebino oblačkov pomoči in pojavnih obvestil, ko se pokažejo.

* Oblački pomoči so kot zaslonski namigi samo, da so običajno večji in se povezujejo s sistemskimi dogodki, kot je obvestilo o izključitvi omrežnega kabla ali opozorilo o varnostni pomanjkljivosti sistema.
* Pojavna obvestila so se predstavila v Oknih 10 in se prikazujejo v središču za obvestila na sistemskem pladnju ter vas informirajo o večih dogodkih (npr., če se je posodobitev prenesla, v vašo mapo Prejeto je prispelo novo epoštno sporočilo ipd.).

##### Sporočaj Bližnjične Tipke Predmeta {#ObjectPresentationShortcutKeys}

Ko je ta izbirnik izbran, NVDA poleg vseh predmetov in kontrolnikov sporoča tudi bližnjične tipke, ki so z njimi povezane.
Tak primer je recimo Datoteka v menijski vrstici, kjer je bližnjična tipka običajno kombinacija alt+d.

##### Sporočaj informacije o položaju predmeta {#ObjectPresentationPositionInfo}

Ta možnost vam omogoča izbiro poznavanja položaja predmeta (1 od 44), ko se pomikate na predmet z žariščem ali predmetom krmiljenja.

##### Ugibaj Informacijo o Položaju Predmeta, ko ta ni na voljo {#ObjectPresentationGuessPositionInfo}

Če je poročanje o informaciji položaja predmeta vključeno, ta možnost omogoča NVDA ugibanje o informaciji položaja predmeta, če je drugače nedosegljiva za dan kontrolnik.

Ko je možnost vključena, NVDA sporoča informacijo o položaju večih kontrolnikov, kot so meniji in orodne vrstice, čeprav dejansko stanje lahko malenkostno odstopa od sporočene informacije.

##### Sporočaj opise Predmeta {#ObjectPresentationReportDescriptions}

Odstranite kljukico iz tega izbirnika, če ne želite poleg predmetov prejemati tudi njihovih opisov, kot so iskalni predlogi, sporočanje celotnega pogovornega okna v nadrejenem oknu takoj, ko se pogovorno okno odpre ipd .

<!-- KC:setting -->

##### Način predstavljanja poteka napredka {#ObjectPresentationProgressBarOutput}

Tipka: NVDA+u

Ta možnost nadzira način poročanja o poteku napredka.

Na voljo imate naslednje izbire:

* izključeno - NVDA stanja napredka ne bo sporočala.
* govori - NVDA bo sporočala potek napredka v odstotkih. Vedno, ko bo prejela informacijo o poteku napredka, bo to sporočila.
* oddaj pisk - Izbor te možnosti pove NVDA, naj odda pisk vedno, ko se posodobi informacija o poteku napredka. Višji, kot je pisk, bližje je konec operacije v teku.
* Oddaj pisk in govori - Ta možnost naroča NVDA, da posodobitve napredka oznani tako s piskom kot z govorno informacijo.

##### Sporočaj napredek v ozadju {#ObjectPresentationReportBackgroundProgressBars}

To je možnost, ki, ko je izbrana, pove NVDA, naj podaja informacijo o poteku napredka tudi, če se dogaja v ozadju.
Če minimirate ali se premaknete iz trenutnega okna, ki vsebuje črto poteka napredka, bo NVDA vseeno poročala o napredku in to vam bo omogočilo, da boste lahko delali druge stvari medtem, ko bo NVDA spremljala napredek.

<!-- KC:setting -->

##### Sporočaj dinamične spremembe vsebine {#ObjectPresentationReportDynamicContent}

Tipka: NVDA+5

Vklaplja možnost naznanila nove vsebine v posameznih predmetih, kot so terminali in kontrolnik zgodovine v programih za klepetanje.

##### Zaigraj zvok, ko se pokažejo samodejni predlogi {#ObjectPresentationSuggestionSounds}

Preklaplja možnost naznanitve prikaza samodejnih predlogov in če je stikalo vključeno, bo NVDA zaigrala zvok in tako nakazala pojavitev predlogov.
Samodejni predlogi so seznami predlaganih vnosov, ki temeljijo na predhodno vnešenem besedilu v ta polja za urejanje in dokumente.
Na primer, ko vnašate besedilo v iskalno polje v začetnem meniju sistema Windows Vista in novejših, Okna prikažejo seznam predlogov temelječih na tem, kar ste natipkali.
V nekaterih poljih za urejanje, kot so iskalna polja v različnih Windows 10 aplikacijah, vas lahko NVDA obvesti, da se je prikazal seznam predlogov medtem, ko ste vnašali besedilo.
Seznam samodejnih predlogov bo izginil, ko se boste enkrat premaknili iz polja za urejanje in za nekatera polja, vas lahko NVDA obvesti o tem, ko se to zgodi.

#### Vnos Večznakovnih Znakov {#InputCompositionSettings}

Zvrst Vnos Večznakovnih Znakov vam omogoča nadzor nad načinom poročanja NVDA o vnosu azijskih znakov kot na primer z UMV (urejevalnikom metode vnosa) ali s storitvijo metod vnosa besedila.
Opozarjamo, da zaradi tega, ker se metode vnosa zelo razlikujejo po značilnostih na voljo in kako prenašajo informacije, je zelo verjetno, da bo potrebno nastaviti te možnosti drugače za vsako metodo za najboljšo izkušnjo tipkanja.

##### Samodejno sporoči vse kandidate na voljo {#InputCompositionReportAllCandidates}

Ta možnost, ki je privzeto vključena, vam omogoča izbiro, ali naj NVDA samodejno sporoča vse vidne kandidate na seznamu kandidatov, ko se prikaže ali na strani, ki je bila spremenjena.
Uporabno je, če imamo to možnost vključeno za slikovne metode vnosov, kot je nova kitajska ChangJie ali Boshiami, saj lahko samodejno slišimo vse simbole in njihove številke in tako lahko izberemo pravega.
Vendar za fonetične metode vnosov, kot je nova kitajska fonetika, je verjetno NVDA bolj uporabna, ko je ta možnost izključena,saj bodo vsi simboli zveneli enako. Tako bo treba uporabljati puščice za krmiljenje po seznamu simbolov in njihovih opisih, da bomo dobili več informacij o posameznem kandidatu.

##### Naznani Izbranega Kandidata {#InputCompositionAnnounceSelectedCandidate}

Ta možnost, ki je privzeto vključena, vam omogoča izbiro, ali naj NVDA naznani kandidata, ko se pojavi seznam kandidatov ali takrat, ko se spremeni izbira.
Za metode vnosa, kjer se izbira lahko spremeni s puščicami, kot je nova kitajska fonetika, je to potrebno, ampak za druge metode vnosa je bolje, da je ta možnost izključena.
Opozarjamo, čeprav je ta možnost izključena, se bo pregledna utripalka še vedno postavila na izbranega kandidata, kar vam bo omogočilo, da uporabite krmiljenje predmeta ali pregleda da boste ročno prebrali tega kandidata ali pa ostale na seznamu.

##### Vedno vključi kratek opis kandidatov {#InputCompositionCandidateIncludesShortCharacterDescription}

Ta možnost, ki je privzeto vključena, vam omogoča izbiro, ali vas mora NVDA oskrbeti s kratkim opisom vsakega znaka v kandidatu, ko je izbran ali pa naj bo samodejno prebran, ko se pojavi seznam kandidatov.
Opozarjamo, da na prevode, kot je kitajski, ta možnost ne vpliva na naznanitev dodatnih opisov znaka. 
Ta možnost je uporabna predvsem pri korejskih in japonskih metodah vnosa.

##### Poročaj o spremembah na nizu branja {#InputCompositionReadingStringChanges}

Nekatere metode vnosa, kot je nova kitajska fonetika in nova ChangJie, imajo niz branja (včasih poznan kot predskladenjski niz).
S to možnostjo lahko izbirate med tem ali mora NVDA naznaniti nove znake, ki jih tipkate v ta niz branja.
Ta možnost je privzeto vključena.
Opozarjamo, da nekatere starejše metode vnosa, kot je kitajska ChangJie, verjetno ne uporabljajo niza branja za zadržanje predskladenjskih znakov. na mesto tega uporabljajo skladnjo niza neposredno.

##### Poročaj o spremembah v skladnji niza {#InputCompositionCompositionStringChanges}

Po branju ali ko so bili predskladenjski podatki združeni v ustrezen slikovni simbol, večina metod vnosa postavi ta simbol v skladnjo niza kot začasen prostor skupaj z ostalimi združenimi simboli preden se končno vstavijo v dokument.
Ta možnost vam omogoča izbiro ali mora NVDA poročati o novih simbolih, ko se pojavijo v skladnji niza.
Ta možnost je privzeto vključena.

#### Brskalniško Delovanje (NVDA+control+b) {#BrowseModeSettings}

Zvrst Brskalniško Delovanje v pogovornem oknu NVDA Nastavitev se uporablja za nastavitev vedenja NVDA, ko prebirate in se premikate po kompleksnih dokumentih, kot so spletne strani.
Ta zvrst vsebuje naslednje možnosti:

##### Največje Število Znakov na Eno Vrstico {#BrowseModeSettingsMaxLength}

To polje določa največjo možno dolžino vrstice v brskalniškem delovanju (v znakih).

##### Največje Število Vrstic na Stran {#BrowseModeSettingsPageLines}

To polje nastavi število vrstic, ki jih boste s pritiskom tipk stran gor ali stran dol preskočili, ko boste v brskalniškem delovanju.

<!-- KC:setting -->

##### Uporabljaj oblikovanje po zaslonu {#BrowseModeSettingsScreenLayout}

Tipka: NVDA+v

Ta možnost vam omogoča, da se odločite, naj se postavitev vsebine, kot so povezave in druga polja, v brskalniškem delovanju zgleduje po postavitvi na zaslonu ali naj se elementi postavijo vsak v svojo vrsto.
Če je možnost izbrana, potem NVDA prikazuje elemente tako, kot so na zaslonu; če ni izbrana, potem polja postavlja vsakega v novo vrsto.

##### Omogoči brskalniško delovanje ob naložitvi strani {#BrowseModeSettingsEnableOnPageLoad}

Ta izbirnik preklaplja med tem ali naj bo brskalniško delovanje omogočeno ob naložitvi strani.
Ko je ta možnost onemogočena, se lahko brskalniško delovanje ročno aktivira na straneh ali v dokumentih, kjer je brskalniško delovanje podprto.
Glejte [razdelek Brskalniško Delovanje](#BrowseMode) za seznam programov, kjer je podprto brskalniško delovanje.
Pomnite, da ta možnost ne zajema situacij, kjer je brskalniško delovanje vedno izbirno.
Ta možnost je privzeto omogočena.

##### Samodejno Izgovori Vse ob končanju nalaganja strani {#BrowseModeSettingsAutoSayAll}

Ta možnost vklaplja samodejno branje, ko se stran naloži v brskalniško delovanje.
Privzeto je ta možnost vključena.

##### Vključi tabele namenjene oblikovanju {#BrowseModeSettingsIncludeLayoutTables}

Ta možnost določa, kako NVDA obravnava tabele, ki so namenjene predvsem postavitvi oblikovanja.
Ko jo vključite, bo NVDA obravnavala te tabele kot normalne tabele na način, kot je določeno v [Nastavitvah Oblikovanja Dokumenta](#DocumentFormattingSettings) in se na nje umesti s pomočjo hitrih tipk za krmiljenje.
Ko je izključena, NVDA o teh tabelah niti ne bo poročala, niti se na nje ne bo umeščala s hitrim krmiljenjem.
Vseeno pa bo vsebina tabel še vedno na voljo kot normalno besedilo.
Ta možnost je privzeto izključena.

Za preklapljanje vključitve tabel namenjenih oblikovanju od kjerkoli, prosimo, določite kretnjo po meri z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).

##### Nastavljanje poročanja o poljih, kot so povezave in naslovi {#BrowseModeLinksAndHeadings}

Prosimo, oglejte si možnosti v [zvrsti Oblikovanja Dokumentov](#DocumentFormattingSettings), ki je del pogovornega okna [NVDA Nastavitev](#NVDASettings) za nastavljanje poročanja o elementih ob navigaciji, kot so povezave, naslovi in tabele.

##### Samodejno delovanje žarišča ob spremembah žarišča {#BrowseModeSettingsAutoPassThroughOnFocusChange}

Ta možnost omogoča klic delovanja žarišča, če se žarišče spremeni.
Na primer, ko ste na spletni strani in pritisnete tipko tab in pristanete v obrazcu, ko je ta možnost izbrana, se bo delovanje žarišča samodejno vključilo.

##### Samodejno delovanje žarišča ob premiku kazalke {#BrowseModeSettingsAutoPassThroughOnCaretMove}

Ta možnost, ko je izbrana, omogoča NVDA, da vstopa in zapušča delovanje žarišča tudi s puščicami.
Na primer, ko se premikate s puščicami po spletni strani in vstopite na polje za urejanje, bo NVDA samodejno vklopila delovanje žarišča.
Ko s puščicami izstopite iz polja za urejanje, bo NVDA preklopila nazaj v brskalniško delovanje. 

##### Zvočna indikacija delovanja Žarišča in Brskalniškega delovanja {#BrowseModeSettingsPassThroughAudioIndication}

Če je ta možnost izbrana, bo NVDA oddajala posebne zvoke ob preklopu med brskalniškim delovanjem in delovanjem žarišča namesto govornega obvestila o spremembi.

##### Onemogoči vpliv kretenj, ki niso ukazi, na dokument {#BrowseModeSettingsTrapNonCommandGestures}

Ta možnost, ki je privzeto vključena, vam omogoča izbiro ali naj kretnje (pritiski tipk), ki niso ukazi NVDA, niti to niso splošni ukazi, ne vplivajo na dokument.
Na primer, v primeru, ko je možnost vključena, pritisk črke j ali druge tipke,  ne bo vplival na dokument, čeprav to niti ni ukaz NVDA, niti ni to splošen ukaz v programu.
v tem slučaju bo NVDA naročila sistemu Windows, da naj zaigra privzeti zvok, kadarkoli se bo pritisnila tipka, ki se blokira.

#### Oblikovanje Dokumentov (NVDA+control+d) {#DocumentFormattingSettings}

Večina izbirnikov v tej zvrsti določa, kako poročati o tipih oblikovanja, ko se z utripalko sprehajate po dokumentih.
Na primer, ko izberete izbirnik ime pisave, bo vedno, ko se boste premaknili na besedilo z drugačno pisavo od prejšnje, NVDA sporočila ime pisave v uporabi.

Možnosti oblikovanja dokumenta so razvrščene v skupine.
V NVDA lahko nastavite poročanje za:

* Pisava
 * Ime Pisave
 * Velikost Pisave
 * Lastnosti Pisave
 * Nadpisane in podpisane
 * Poudarke
 * Slog
 * Barve
* Informacije dokumenta
 * Komentarje
 * Uredniške popravke
 * Napake črkovanja
* Strani in razmiki
 * Številke Strani
 * Številke Vrstice
 * Sporočanje zamika Vrstice [(Izključeno, Govor, Toni, tako Govor kot Toni)](#lineIndentationOptions)
 * Zamike odstavka (viseči zamik, zamik prve vrstice...)
 * Razmik med vrsticami (enojni, dvojni ipd.)
 * Poravnavo
* Informacije tabele
 * Tabele
 * Glave in čela Tabel (glave vrstic in stolpcev)
 * Koordinate celic v tabelah
 * Obrobe celice (Izključeno, Slogi, Tako Barve kot Slogi)
* Elementi
 * Naslove
 * Povezave
 * Sezname
 * Navedke
 * Skupine
 * Mejnike
 * Članke
 * Okvirje
 * Ko je nekaj klikljivo

Za preklapljanje stanja teh nastavitev od kjerkoli, prosimo, dodelite lastne kretnje vnosa prek [pogovornega okna Kretenj Vnosa.](#InputGestures)

##### Sporočaj spremembe oblikovanja za utripalko {#DocumentFormattingDetectFormatAfterCursor}

Če je izbrana, ta nastavitev pove NVDA, naj poskuša zaznati vse spremembe v oblikovanju v vrstici, ki jo trenutno predstavlja in te podrobnosti sporočiti, čeprav to lahko zniža učinkovitost NVDA.

Privzeto bo NVDA zaznavala spremembe na položaju pregledne utripalke/sistemske kazalke in včasih bo zaznavala oblikovanje v drugih delih vrstice samo, če to ne bo upočasnilo njenega delovanja.

Omogočite to možnost v programih, kot je WordPad, med postopkom postavitve besedila, kjer je oblikovanje pomembno.

##### Sporočanje zamika vrstice {#DocumentFormattingSettingsLineIndentation}

Ta možnost vam omogoča nastavitev, kako naj NVDA sporoča zamik vrstice na njenem začetku.
Spustni seznam Sporočaj zamik vrstice prek ima 4 možnosti.

* Izključeno: NVDA zamika ne bo posebej sporočala.
* Govora: Če je ta možnost izbrana, bo, ko se bo zamik vrstice spremenil, NVDA povedala nekaj takega kot "12 presledek" ali "4 tabulator."
* Tonov: Ko bo izbrana ta možnost, bo NVDA oddala ton, ko se bo zamik vrstice spremenil.
Višina tona se bo spreminjala z vsakim presledkom, medtem, ko bo tabulator zvišal ton za vrednost štirih presledkov.
* Govora in Tonov: Ta možnost vključi obe prej opisani metodi.

#### Nastavitve Windows 10 OCR {#Win10OcrSettings}

Nastavitve v tej zvrsti vam omogočajo nastaviti [Prepoznavo (OCR) v Windows 10](#Win10Ocr).
Ta zvrst vsebuje naslednje možnosti:

##### Jezik prepoznave {#Win10OcrSettingsRecognitionLanguage}

Ta spustni seznam vam omogoča izbiro jezika, ki se bo uporabil za prepoznavo besedila.

#### Napredne Nastavitve {#AdvancedSettings}

Opozorilo! Nastavitve v tej zvrsti so namenjene naprednim uporabnikom in lahko povzročijo, da  NVDA ne bo delovala pravilno, če jo boste napačno nastavili.
Te nastavitve spreminjajte samo, če ste popolnoma gotovi, da veste, kaj delate ali če so vam izretsno tako naročili razvijalci NVDA.

##### Spreminjanje naprednih nastavitev {#AdvancedSettingsMakingChanges}

Da bi izvedli spremembe v naprednih nastavitvah, morate omogočiti kontrolnike s potrditvijo izbirnika, ki označuje, da razumete tveganja, ki so povezana s spreminjanjem teh nastavitev.

##### Obnavljanje privzetih nastavitev {#AdvancedSettingsRestoringDefaults}

Gumb obnovi privzete vrednosti za nastavitve, tudi, če izbirnik o potrditvi ni izbran.
Po spremembi nastavitev boste morda želeli povrniti le-te na privzete vrednosti.
To je lahko tudi rešitev, ko ne boste gotovi ali so se nastavitve spremenile.

##### Omogoči nalaganje kode po meri iz Scratchpad Imenika za Razvijalce {#AdvancedSettingsEnableScratchpad}

Ko se razvija dodatke za NVDA, je uporabno, da ima razvijalec priložnost testiranja kode že medtem, ko se jo piše.
Ta možnost, ko je omogočena, dovoljuje NVDA nalaganje kode po meri (programske Module, globalne Vtičnike, Gonilnike za brajeve Vrstice in Gonilnike za sinteze, iz posebnega imenika za razvijalce scratchpad v vašem NVDA uporabniškem konfiguracijskem imeniku.
Pred tem bi NVDA lahko naložila kodo po meri neposredno iz imenika namenjenega uporabniški konfiguraciji, brez možnosti onemogočenja kode.
Ta možnost je privzeto izključena, zaradi zagotovitve, da nobena koda, ki se ni testirala, se nikoli ne izvaja v NVDA brez uporabnikove izrecne vednosti.
Če boste želeli razširiti kodo po meri med druge, jo boste morali zapakirati kot NVDA dodatek.

##### Odpri Scratchpad Imenik za Razvijalce {#AdvancedSettingsOpenScratchpadDir}

Ta gumb odpre imenik kjer lahko odložite vašo kodo po meri, ki je še v razvoju.
Ta gumb je na voljo samo takrat, ko je NVDA nastavljena tako, da dovoli kodo po meri iz Imenika Scratchpad za Razvijalce.

##### Uporabi UI (UV) automation za dostop do kontrolnikov Microsoft Word dokumenta, ko so na voljo {#AdvancedSettingsUseUiaForWord}

Ko je ta možnost vključena, bo NVDA poskušala uporabiti Microsoft UI (UV) Automation accessibility API (API za dostopnost), da bi pridobila informacije iz kontrolnikov v Microsoft Word dokumentu.
To vključuje kontrolnike znotraj Microsoft Worda, samega in tudi pregledovalnik sporočil Microsoft Outlook in urejevalnik.
Za najbolj posodobljene različice Microsoft Offica 2016/365, ki tečejo v windows 10, je podpora za UI (UV) Automation dodelana dovolj,da  lahko NVDA oskrbi dostop do Microsoft Word dokumentov skoraj tako dobro kot s trenutno podporo NVDA za Microsoft Word, z dodatno vrednostjo precej izboljšane odzivnosti.
Toda, lahko obstaja tudi nekaj informacij, ki bodisi se ne morejo osvetljiti ali so osvetljene napačno v nekaj različicah Microsoft Offica, kar pomeni, da se na to UI (UV) automation podporo ne moremo vselej zanesti.
Tako mi še ne priporočamo, da bi večina uporabnikov to možnost imela privzeto vklopljeno, čeprav s hvaležnostjo pozdravljamo uporabnike Offica 2016/365, da testirajo to zmožnost in sporočijo povratne informacije.

##### Uporabi UI (UV) Automation za dostop do  Windows Konzole, ko je na voljo {#AdvancedSettingsConsoleUIA}

Ko je ta možnost omogočena, bo NVDA uporabljala novo različico podpore (še v izdelavi) za Windows Konzolo, ki izkorišča prednosti [izboljšav dostopnosti, narejenih s strani  Microsofta](https://devblogs.microsoft.com/commandline/whats-new-in-windows-console-in-windows-10-fall-creators-update/). Ta zmožnost je še globoko v preizkusni fazi in je še vedno nepopolna, tako se njeno uporabo za zdaj odsvetuje. Toda, ko bo enkrat popolna, se pričakuje, da bo ta nova podpora postala privzeta pri izboljšavi učinkovitosti in stabilnosti NVDA v Windows ukaznih konzolah.

##### Izgovori gesla v UIA konzolah {#AdvancedSettingsWinConsoleSpeakPasswords}

Ta nastavitev nadzira, kako se izgovarjajo znaki ob dejavnih možnostih [izgovori natipkane znake](#KeyboardSettingsSpeakTypedCharacters) ali [izgovori natipkane besede](#KeyboardSettingsSpeakTypedWords) v situacijah, ko se ekran ne osvežuje samodejno (kot je vnos gesla) v Windows Konzoli z UI (UV) automation podporo omogočeno. Zaradi varnostnih razlogov bi morala biti ta nastavitev onemogočena. Toda, mogoče jo boste želeli omogočiti, če boste imeli težave z učinkovitostjo ali s stabilnostjo ob sporočanju natipkanega znaka in/ali besede med uporabo nove poskusne podpore konzolam s strani NVDA.

##### Uporabi novo podporo za natipkane znake v Windows Konzoli, ko je na voljo {#AdvancedSettingsKeyboardSupportInLegacy}

Ta možnost omogoči alternativno metodo za zaznavo natipkanih znakov v Windows ukaznih konzolah.
Čeprav izboljša učinkovitost in prepreči nekaj konzolskega iznosa, da se ne bi izgovoril, je to lahko nezdružljivo z nekaj terminalskimi programi.
Ta zmožnost je na voljo in je privzeto omogočena v različicah Windows 10 1607 in novejših, ko UI (UV) Automation ni na voljo ali je onemogočena.
Opozorilo: ko je ta možnost omogočena, natipkani znaki, ki niso vidni na ekranu, kot so gesla, ne bodo odušeni.
V okoljih, ki niso vredna zaupanja, boste morda začasno onemogočili [izgovori natipkane znake](#KeyboardSettingsSpeakTypedCharacters) in [izgovori natipkane besede](#KeyboardSettingsSpeakTypedWords), ko boste vnašali gesla.

##### Poskušaj preklicati govor ob poteklih dogodkih v žarišču {#CancelExpiredFocusSpeech}

Ta možnost omogoči vedenje, ki poskuša preklicati govor ob poteklih dogodkih v žarišču.
Bolj določno, hitro premikanje skozi sporočila v pošti Gmail z brskalnikom  Chrome lahko povzroči, da NVDA izgovarja zastarele informacije.
Ta funkcionalnost je preizkusni fazi v različici NVDA 2020.2 in naprej do preklica.

##### Samodejno postavi sistemsko žarišče na elemente, ki so lahko v žarišču v Brskalniškem Delovanju {#BrowseModeSettingsAutoFocusFocusableElements}

Tipka: NVDA+8

Prevzeto omogočena, vam ta možnost dovoljuje izbiro, če naj bi moralo biti sistemsko žarišče samodejno postavljeno na elemente, ki lahko prevzamejo sistemsko žarišče (povezave, polja v obrazcih, itd.), ko se krmili po vsebini z brskalniškim delovanjem.
Ko je omogočeno, to predstavlja privzeto delovanje NVDA od različice 2019.1 nazaj.
Onemogočitev te možnosti ne bo samodejno postavilo v žarišče elementov, ki so lahko v žarišču, ko bodo izbrani s kazalko brskalniškega delovanja.
To se lahko odrazi v hitrejši izkušnji brskanja in boljši odzivnosti v brskalniškem delovanju.
Žarišče se bo še vedno posodobilo na ta določen element ob interakciji z njim (t.j. pritisk gumba, izbor izbirnika).
Ta zmožnost je v preizkušanju od različice NVDA 2019.2.

##### Zakasnitev premika kazalke (v MS) {#AdvancedSettingsCaretMoveTimeout}

Ta možnost vam omogoča nastavitev števila milisekund, v katerih bo NVDA čakala na premik kazalke (točke vnosa) v kontrolnikih, kjer se lahko ureja besedilo.
Če boste ugotovili, da izgleda, da NVDA neustrezno sledi kazalko, npr. izgleda, da je zmeraj znak zadaj ali ponavlja vrstice, boste morda želeli poskusiti s povečanjem te vrednosti.

##### Zvrsti beleženja hroščev {#AdvancedSettingsDebugLoggingCategories}

Izbirniki na tem seznamu vam dovoljujejo omogočiti točno določene zvrsti sporočil o hroščih v NVDA dnevniku.
Beleženje teh sporočil se lahko odrazi v zmanjšani učinkovitosti in velikih dnevniških ddatotekah.
Eno od njih vključite samo, če vam je tako izrecno naročeno s strani razvijalca NVDA; npr., ko se ugotavlja, zakaj gonilnik brajeve vrstice ne dela pravilno.

### Raznotere Nastavitve {#MiscSettings}

Razen pogovornega okna [NVDA Nastavitev](#NVDASettings), podmeni Izbire menija NVDA vsebuje več drugih postavk, ki so orisane v nadaljevanju.

#### Slovarji govora {#SpeechDictionaries}

Meni slovarjev govora, ki se nahaja v Nastavitvah, vsebuje pogovorna okna, ki vam omogočajo upravljanje, kako NVDA izgovarja različne besede ali fraze.
Trenutno obstajajo trije različni slovarji govora.
Ti so:

* Privzet: Pravila v tem slovarju vplivajo na vsak izgovor v NVDA.
* Glas: Pravila v tem slovarju vplivajo na govorno sintezo, ki je trenutno v uporabi.
* Začasen: Pravila v tem slovarju vplivajo na ves govor v NVDA, toda to velja samo za trenutno sejo. Ta pravila so začasna in bodo izgubljena, ko se NVDA ponovno zažene.

 Z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures) morate dodeliti lastne kretnje, če želite odpreti katerokoli pogovorno okno teh slovarjev od kjerkoli.

Vsa pogovorna okna slovarjev vsebujejo seznam pravil, ki se uporabljajo procesiranje govora.
Pogovorno okno vsebuje tudi gumbe Dodaj, Uredi in Odstrani.

Če želite dodati novo pravilo v slovar, pritisnite gumb Dodaj, izpolnite polja, ki se prikažejo v pogovornem oknu, nato pritisnite V redu.
Tako boste svoje pravilo videli v seznamu pravil.
Toda zaradi zavarovanja, da se je pravilo resnično shranilo, se prepričajte, da ste pritisnili V redu za izhod iz vseh pogovornih oken slovarjev, ko ste končali z dodajanjem in urejanjem pravil.

Pravila NVDA govornega slovarja vam omogočajo spreminjanje enega niza znakov v drugega.
Na primer, lahko bi ustvarili pravilo, ki naroča NVDA, da namesto besede "žaba" izgovori "ptič", vedno, ko naleti na to besedo.
V pogovornem oknu dodajanja pravila je najlažja pot, da to storite tako, da vnesete ptič v polje vzorca in v polje zanenjave vnesete besedo žaba.
Kadar želite vnesti opis pravila, lahko storite tudi to tako, da vnesete opis v polje komentarja (nekaj takega kot: menja ptiča v žabo).

Toda Slovarji govora v NVDA zmorejo še več kot preprosto zamenjavo besed.
Pogovorno okno dodajanja pravila vsebuje tudi izbirnik, s katerim lahko izbirate ali naj bo vaše pravilo občutljivo na velike črke ali ne. To pomeni, da NVDA pravilo obravnava drugače takrat, ko je beseda zapisana z velikimi črkami kot takrat, ko je beseda zapisana z malimi.
Privzeto NVDA ni občutljiva na velike črke.

Na koncu vam set radijskih gumbov omogoča, da NVDA sporočite ali naj se vzorec uporablja kjerkoli, ali naj se vzorec uporablja samo takrat, ko je to cela beseda ali naj se vzorec obravnava kot "regularen izraz".
Nastavitev cele besede pomeni, da bo vzorec kot zamenjava v uporabi samo takrat, ko vzorec ne bo del daljše besede.
Ta pogoj se izpolni, ko so znaki povsem pred in za besedo vse drugo razen črka, cifra ali podčrtaj ali, če tam ni popolnoma nobenih znakov.
Tako prejšnji primer zamenjave vzorca "ptič" v besedo "žaba" ne bo pokazal nobenih rezultatov ob določitvi, da se vzorec nanaša na celotno besedo, če bomo govorili o "ptičjem" ali "pticah".

Regularni izraz je vzorec, ki vsebuje posebne simbole, ki omogočajo zapis več kot enega znaka istočasno, ali zapis samo števil, črk in podobno. To je samo nekaj primerov.
Regularnih izrazov ta uporabniški vodič ne pokriva, ker obstaja precej vodičev v spletu, kjer je na voljo več informacij.

#### Izgovorjava ločil/simbolov {#SymbolPronunciation}

To pogovorno okno vam omogoča menjavo zgovornosti, kar pomeni, kdaj se določen simbol izgovori. Lahko pa določite tudi, kaj naj se izgovori namesto imena simbola.

Jezik, čigar izgovorjavo se trenutna ureja, je prikazan v naslovu pogovornega okna.
Opozarjamo, da se to pogovorno okno zanaša na "Zaupaj jeziku osebe za procesiranje simbolov in znakov", možnost, ki se nahaja v [zvrsti Nastavitev Govora](#SpeechSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings); tako NVDA uporablja jezik osebe namesto globalne nastavitve za jezik, ko to možnost omogočite.

Za menjavo simbola, ga najprej izberite s seznama simbolov.
Vi lahko filtrirate simbole z vnosom simbola ali delom simbolove zamenjave v polje za urejanje Preseji med.

* Polje zamenjave vam omogoča spremembo besedila, ki naj se izgovori ob simbolu.
* Z uporabo polja za nivoje določite najnižji nivo, kjer se mora simbol izgovoriti.
* Spustni seznam "Pošlji aktualen simbol na sintezo" določa, kdaj bo NVDA obravnavo izgovorjave dotičnega simbola prepustila izbrani govorni sintezi (namesto podatkov iz polja Zamenjave.)
To je uporabno takrat, ko je simbol vzrok premora, ki ga naredi sinteza, ali spremembe modulacije glasu pri osebi.
Na primer vejica (,) je vzrok, za premor, ki ga naredi sinteza.
Na voljo so 3 možnosti:
 * nikoli: Nikoli ne pošlji trenutnega simbola na sintezo.
 * vedno: Vedno pošlji aktualen simbol na sintezo.
 * samo pod nivojem simbola: Pošlji aktualen simbol samo, ko je nivo simbola postavljen niže kot je nastavljen nivo posameznega simbola.
 Na primer, to lahko uporabite tako, da se bo simbol izgovoril na višjih nivojih brez premorov, medtem, ko se bodo s premorom naznanili na nižjih nivojih.

Če želite dodati nov simbol, pritisnite gumb Dodaj.
V pogovorno okno, ki se prikaže, vnesite željeni simbol in pritisnite gumb V redu.
Nato, kot velja za druge simbole, izpolnite polja tega simbola.

Simbol, ki ste ga prej dodali, lahko odstranite tako, da pritisnete gumb Odstrani.

Ko zaključite z delom, pritisnite V redu, da spremembe shranite ali Prekliči, če želite spremembe zavreči.

#### Kretnje Vnosa {#InputGestures}

V tem pogovornem oknu lahko prilagajate kretnje vnosa, kot so tipke na tipkovnici, gumbi na brajevi vrstici, in podobno ukazom za NVDA.

Pokažejo se samo tisti ukazi, ki so bili na voljo tik preden ste odprli to pogovorno okno.
Na primer, če želite spremeniti kretnje vnosa, ki se nanašajo na brskalniško delovanje, morate odpreti pogovorno okno kretenj vnosa med tem, ko ste v brskalniškem delovanju.

To pogovorno okno vsebuje drevo, kjer so razvrščeni NVDA ukazi, ki so na voljo ločeni po kategorijah.
Ukaze lahko presejete (filtrirate) tudi tako, da vnesete eno ali več besed imena ukaza v za to namenjeno vnosno polje. Vrstni red besed ni pomemben.
Vsaka kretnja, ki se nanaša na ukaz je razvrščena pod ukazom.

Če želite dodati kretnjo vnosa posameznemu ukazu, izberite ukaz in pritisnite gumb Dodaj.
Nato izvedite kretnjo, za katero želite, da je povezana s tem ukazom; npr. pritisk tipke na tipkovnici ali gumba na brajevi vrstici.
Pogosto se kretnja lahko interpretira na več načinov.
Na primer, ko pritisnete tipko na tipkovnici, lahko določite, da se določi samo za to obliko tipkovnice npr. Prenosnik ali Namizje (običajna razporeditev), lahko pa določite, da kretnja velja za vse postavitve tipkovnice.
V takem primeru se bo prikazal meni, kjer boste lahko izbrali ustrezno možnost.

Za odstranitev kretnje vnosa s posameznega ukaza, izberite kretnjo in pritisnite gumb Odstrani.

Ko zaključite z delom, pritisnite gumb V redu, da shranite spremembe ali gumb Prekliči, če spremembe želite zavreči.

### Shranjevanje in ponovno Nalaganje konfiguracije {#SavingAndReloading}

Privzeto bo NVDA samodejno shranila vaše nastavitve ob izhodu.
Vendar to lahko spremenite v splošnih možnostih pod Nastavitvami.
Če želite kadarkoli ročno shraniti nastavitve, izberite postavko Shrani konfiguracijo v glavnem meniju NVDA (Nastavitve)

Če kadarkoli naredite napako pri vaših nastavitvah in želite, da se NVDA povrne na zadnje shranjeno stanje, izberite postavko "Vrni na zadnjo shranjeno konfiguracijo" v glavnem meniju NVDA.
Lahko pa vedno ponastavite NVDA na tovarniške nastavitve z izbiro postavke Ponastavi na tovarniško konfiguracijo, ki se prav tako nahaja v meniju NVDA.

Naslednji NVDA ukazi so tudi na voljo:
<!-- KC:beginInclude -->

| ime |Običajna razporeditev |razporeditev Prenosnik |Opis|
|---|---|---|---|
|Shrani konfiguracijo |NVDA+control+c |NVDA+control+c |Shrani vašo zadnjo konfiguracijo tako, da ni izgubljena, ko zapustite NVDA.|
|Povrni konfiguracijo |NVDA+control+r |NVDA+control+r |Enojni pritisk povrne na stanje zadnje shranjene konfiguracije. Trojni pritisk povrne stanje konfiguracije na tovarniško.|

<!-- KC:endInclude -->

### Profili Konfiguracije {#ConfigurationProfiles}

Včasih želite različne nastavitve za različne situacije.
Na primer, da želite, da NVDA poroča o zamikih (imate to možnost vključeno) medtem, ko urejate ali da je vključeno poročanje o lastnostih pisave, ko dokument oblikujete.
To vam NVDA omogoča skozi uporabo Profilov Konfiguracije.

Profil konfiguracije vsebuje samo tiste nastavitve, ki so se spremenile med tem, ko je bil profil v urejanju.
V profilih konfiguracije se lahko spremenijo skoraj vse nastavitve razen tistih v zvrsti  Splošno v pogovornem oknu [NVDA Nastavitev](#NVDASettings), ki vplivajo na delovanje NVDA v celoti.

Profili konfiguracije se lahko aktivirajo ročno preko pogovornega okna ali z uporabo dodanih kretenj po meri.
Lahko pa se aktivirajo tudi samodejno glede na prožilec. Prožilec je lahko prehod v izbran program.

#### Osnovno Upravljanje {#ProfilesBasicManagement}

S profili konfiguracije lahko upravljate z izbiro Profilov Konfiguracije v meniju NVDA.
To lahko storite tudi z uporabo sledečega ukaza na tipkovnici:
<!-- KC:beginInclude -->

* NVDA+control+p: Pokaži pogovorno okno Profilov Konfiguracije.

<!-- KC:endInclude -->

Prva možnost nadzora je seznam profilov na voljo, med katerimi lahko izbirate.
Ko odprete pogovorno okno, je izbran profil, ki ga pravkar urejate.
Dodatne informacije se pokažejo ob aktivnem profilu. Tako lahko ugotovimo, ali je profil aktiviran ročno, preko prožilca in/ali je v stanju urejanja.

Če želite preimenovati ali izbrisati profil, Izberite ustrezen gumb (Odstrani/Preimenuj).

Pritisnite gumb Zapri, da zaprete to pogovorno okno.

#### Ustvarjanje Profila {#ProfilesCreating}

Če želite ustvariti nov profil, pritisnite gumb Novo.

V pogovornem oknu za nov profil, lahko določite ime novega profila.
Lahko izberete tudi, kako naj se ta profil uporablja.
Če ta profil želite aktivirati ročno, izberite ročna aktivacija (privzeta možnost).
Drugače izberite prožilec, ki bo samodejno aktiviral izbran profil.
Zaradi udobnejšega delovanja, če polje z imenom pustite prazno, ga bo izpolnil izbran prožilec, ki aktivira profil.
Glejte [spodaj](#ConfigProfileTriggers), če želite dobiti več informacij o prožilcih profilov.

Pritisk gumba V redu bo zaprl pogovorno okno profilov konfiguracije in ustvaril profil z izbranimi značilnostmi.

#### Ročna aktivacija {#ConfigProfileManual}

Profil ročno aktivirate tako, da ga izberete in pritisnete gumb Sproži.
Ko je profil enkrat aktiviran, ga še vedno lahko preglasijo profili s prožilci, vendar bodo nastavitve tega profila prevladale nad tistimi iz profila s prožilcem.
Na primer, če profil sproži trenuten program in je poročanje povezav omogočeno v tem profilu, vendar je ista nastavitev v profilu, ki se ročno aktivira izključena, NVDA ne bo sporočala povezav.
Toda, če zamenjate glas v profilu na prožilec in tega niste nikoli storili v profilu, ki se aktivira ročno, bo NVDA upoštevala nastavitev profila na prožilec.
Vsaka nastavitev, ki jo boste spremenili, se bo shranila v profilu, ki ga aktivirate ročno.
Za deaktivacijo ročno aktiviranega profila, ga izberite v seznamu pogovornega okna Konfiguracije profilov in pritisnite gumb Ročno deaktiviraj.

#### Prožilci {#ConfigProfileTriggers}

Pritisk gumba Prožilci v pogovornem oknu Konfiguracije profilov vam omogoča spreminjanje profilov, ki se morajo aktivirati ob različnih dogodkih. To pomeni, da se aktivirajo različni prožilci.

Seznam prožilcev prikazuje seznam prožilcev, ki so trenutno na voljo. Večinoma so to sledeči:

* Trenuten program: Ta prožilec aktivira profil, ko se odpre program, ki teče takoj za NVDA nastavitvami. To pomeni, da se prožilec veže na program, s katerega ste odprli nastavitve NVDA. Pozor, Če želite nastaviti prožilec za izbran program, mora program teči v ospredju.
* Preberi vse: Ta prožilec je vezan na ukaz Preberi vse.

Za spremembo profila, ki naj se navezuje na posamezen prožilec, ki ga samodejno aktivira, izberite prožilec in potem izberite še odgovarjajoč profil iz seznama.
Lahko izberete tudi (Normalno konfiguracijo), če želite, naj profili ne bodo v uporabi.

Pritisnite gumb Zapri, da se vrnete v glavno pogovorno okno Konfiguracije profilov.

#### Urejanje Profila {#ConfigProfileEditing}

Če uporabljate ročno aktiviran profil, bo vsaka nastavitev, ki jo boste spremenili, v ta profil.
Drugače bo nastavitev shranjena v zadnji samodejno aktiviran profil.
Na primer, če ste profil povezali s prožilcem Beležnice, in potem Beležnico odprete ali se premaknete vanjo, se bo vsaka sprememba nastavitev shranila v ta profil.
Če za posamezno situacijo ne obstaja niti profil z ročno aktivacijo niti profil s prožilcem, se bo vsaka sprememba nastavitev shranila v Normalno konfiguracijo.

Za urejanje profila, ki je povezan s prožilcem "Preberi vse", morate [ročno aktivirati](#ConfigProfileManual) ta profil.

#### Začasno Onemogočanje Prožilcev {#ConfigProfileDisablingTriggers}

Včasih je uporabno, če lahko začasno onemogočimo vse prožilce.
Tak primer se pojavi, ko želite urejati profil, ki se aktivira ročno ali Normalno konfiguracijo brez motenj profilov na prožilcu.
To storite s potrditvijo izbirnika Začasno onemogoči vse prožilce v pogovornem oknu Konfiguracije profilov.

Za preklop stikala na onemogočitev prožilcev od kjerkoli, prosimo, določite kretnjo po meri z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).

#### Aktiviranje profila z uporabo kretenj vnosa {#ConfigProfileGestures}

Ob dodajanju vsakega profila mu lahko dodelite eno ali več kretenj vnosa za njegovo aktivacijo.
Privzeto profili konfiguracije nimajo dodeljene kretenj vnosa.
Kretnje za aktivacijo profila lahko dodate z uporabo [pogovornega okna Kretenj Vnosa](#InputGestures).
Vsak profil ima svoje vnosno mesto v zvrsti profilov konfiguracije.
Ko boste profil preimenovali, bodo vse morebitne kretnje, ki ste jih predhodno dodali, še vedno na voljo.
Odstranitev profila bo samodejno izbrisala kretnje povezane z njim.

### Mesta datotek z Nastavitvami {#LocationOfConfigurationFiles}

Prenosljive različice NVDA hranijo vse nastavitve in dodatke v imeniku z imenom userConfig, ki se nahaja v imeniku NVDA.

Nameščene različice NVDA hranijo vse nastavitve in dodatke v posebnem imeniku, ki se nahaja v vašem uporabniškem profilu.
To pomeni, da ima lahko vsak uporabnik svoj set nastavitev v NVDA.
Za odpiranje vašega imenika z nastavitvami od kjerkoli lahko uporabite [Pogovorno okno Kretenj Vnosa,](#InputGestures)  če boste dodajali kretnjo po meri.
Poleg tega lahko v nameščeni različici NVDA, lahko greste v začetnem meniju prek programov -> NVDA -> razišči imenik uporabniške konfiguracije.

Nastavitve NVDA, ko deluje med vpisom ali na NUR namizjih, se hranijo v imeniku systemConfig v namestitvenem imeniku NVDA.
Običajno se teh nastavitev ne bi smelo dotikati.
Za spremembo delovanja NVDA med vpisom ali na NUR namizjih nastavite NVDA, kot želite, da deluje medtem, ko ste vpisani v Okna, shranite to konfiguracijo in potem pritisnite gumb "Uporabljaj trenutno shranjene nastavitve med vpisom in drugih "varnih" namizjih" v zvrsti Splošno pogovornega okna [NVDA Nastavitev](#NVDASettings).

## Dodatna Orodja {#ExtraTools}
### Preglej Dnevnik {#LogViewer}

Pregledovalnik dnevnika, ki se nahaja v Orodjih v meniju NVDA, vam omogoča ogled vseh zabeleženih dogodkov v dnevnik od zadnjega zagona NVDA pa do trenutka, ko ste začeli pregledovati dnevnik.
Uporaba ukaza NVDA+F1 bo odprla pregledovalnik dnevnika in prikazala informacije za razvijalce o trenutnem predmetu krmiljenja.

Poleg branja vsebine, lahko kopijo dnevnika lahko tudi shranite ali osvežite dnevnik, tako da vam prikaže zadnje vnose od tedaj, ko ste dnevnik odprli.
Ukazi so na voljo v meniju Pregledovalnika dnevnika.

### Prikazovalnik Govora {#SpeechViewer}

Za videče razvijalce programov ali za ljudi, ki predstavljajo NVDA videči publiki, je na voljo plavajoče okno, ki vam omogoča spremljanje vsega besedila, ki ga NVDA trenutno izgovarja.

Če želite omogočiti prikazovalnik govora, označite menijsko postavko "Prikazovalnik Govora" v Orodjih menija NVDA.
Če ga želite izključiti, menijsko postavko odznačite.

Okno prikazovalnika govora vsebuje izbirnik, ki je naznačen kot "Pokaži prikazovalnik govora ob zagonu".
Če ga izberete, se bo prikazovalnik govora pokazal takoj ob zagonu NVDA.
Prikazovalnik govora se bo vedno poskušal odpreti na enaki lokaciji in v enakih dimenzijah, kot jih je zavzemal ob času zadnjega zaprtja.

Ko je prikazovalnik govora omogočen, se stalno posodablja, da vam pokaže besedilo, ki se pravkar izgovarja.
Kakorkoli, če kliknete ali postavite žarišče znotraj prikazovalnika, bo NVDA začasno prenehala posodabljati besedilo, tako da ga boste lažje izbrali ali preslikali.

Za vklapljanje in izklapljanje Prikazovalnika Govora od kjer koli, prosimo, dodelite lastno kretnjo z uporabo [pogovornega okna Kretenj Vnosa.](#InputGestures)

### Prikazovalnik Brajice {#BrailleViewer}

Za videče razvijalce programov ali za ljudi, ki predstavljajo NVDA videči publiki, je na voljo plavajoče okno, ki vam dovoljuje prikaz brajevega iznosa in besedilo, ki je enako vsakemu brajevemu znaku.
Prikazovalnik brajice se lahko uporablja vzporedno s fizično brajevo vrstico; ita bo prikazal enako število celic, kot jih ima fizična naprava.
Ko je prikazovalnik brajice omogočen, se stalno posodablja, da vam pokaže brajico, ki naj bi se pokazala na fizični brajevi vrstici.

Za omogočitev prikazovalnika brajice izberite menijsko postavko "Prikazovalnik Brajice" v Orodjih v meniju NVDA.
Odznačite menijsko postavko za njegovo onemogočitev.

Fizične brajeve vrstice imajo običajno gumbe, s katerimi uporabniki vrtijo vrstico nazaj ali naprej; za omogočitev vrtenja z orodjem prikazovalnik brajice uporabite [pogovorno okno Kretenj Vnosa](#InputGestures) za določitev bližnjičnih tipk, ki bodo "Vrtele brajevo vrstico nazaj" in "vrtele brajevo vrstico naprej".

Prikazovalnik brajice vsebuje izbirnik imenovan "Pokaži Prikazovalnik brajice ob zagonu".
Če je izbran, se bo prikazovalnik brajice odprl, ko se bo NVDA zagnala.
Okno prikazovalnika brajice se bo vedno poskušalo ponovno odpreti po isti širini in višini ter na istem položaju, kjer se je zaprlo.

### Python Konzola {#PythonConsole}

NVDA Python konzola, ki se nahaja v Orodjih menija NVDA, je orodje za razvijalce, ki je uporabno za razhroščevanje, splošno inšpekcijo NVDA notranjosti ali inšpekcijo hierarhije dostopnosti v programu.
Več informacij, prosimo, poiščite v [Vodiču za Razvijalce  NVDA (v Angleščini)](https://www.nvaccess.org/files/nvda/documentation/developerGuide.html).

### Upravitelj Dodatkov {#AddonsManager}

Upravitelj dodatkov, dostopen preko izbire Orodij v meniju NVDA, vam omogoča namestitev in odstranitev paketov z dodatki za NVDA ter njihovo začasno izključitev ali vključitev.
Te dodatke je oskrbela skupnost in vsebujejo prilagojeno kodo, ki lahko doda ali spremeni značilnosti v NVDA ali celo doda podporo večim brajevim vrsticam ali govornim sintezam.

Upravitelj dodatkov vsebuje seznam, ki prikazuje vse dodatke trenutno nameščene v vaši NVDA uporabniški konfiguraciji.
Ime paketa, njegovo stanje, njegova različica in avtorji se pokažejo ob vsakem paketu, ostale informacije, kot je opis in URL pa so vidne ob izbiri dodatka in pritisku gumba O dodatku.
Če je pomoč za izbran dodatek na voljo, lahko do nje dostopate tako, da pritisnete gumb Pomoč ob izbranem dodatku.

Za brskanje in prenos dodatkov, ki so na voljo na spletu, pritisnite gumb Pridobi dodatke.
Ta gumb odpre [stran z dodatki za NVDA](https://addons.nvda-project.org/).
Če je NVDA nameščena v vaš računalnik in v njem tudi teče v času nameščanja dodatka, lahko dodatek odprete neposredno iz brskalnika za začetek poteka namestitve, kot je opisano spodaj.
V nasprotnem primeru shranite paket z dodatkom in sledite spodnjim navodilom.

Za dodatek, ki ste ga že prej posedovali, pritisnite gumb Namesti.
To vam bo omogočilo brskanje za paketom dodatka (nvda-addon datoteko) nekje na vašem računalniku ali mreži.
Ko enkrat pritisnete Odpri, se bo začel potek namestitve.

Ko se namešča dodatek, vas bo NVDA najprej zaprosila za potrditev, da  res želite namestiti dodatek.
Ker je funkcionalnost dodatka znotraj NVDA brez omejitev, kar v teoriji vključuje tudi dostop do vaših osebnih podatkov ali lahko tudi do samega jedra sistema, če je NVDA na sistemu nameščena; je zelo pomembno, da nameščate dodatke samo iz virov, ki jim zaupate.
Ko se dodatek namesti, morate NVDA ponovno zagnati, da se dodatek spravi v pogon.
Dokler tega ne naredite, bo stanje dodatka v seznamu prikazano kot "Namesti".

Če dodatek želite odstraniti, ga izberite na seznamu z dodatki in pritisnite gumb Odstrani.
NVDA vas bo vprašala, če res želite to storiti.
Tako kot pri namestitvi, se mora NVDA znova zagnati, da se dodatek popolnoma odstrani.
Dokler tega ne naredite, bo stanje dodatka v seznamu prikazano kot "odstrani".

Če želite dodatek samo izključiti, pritisnite gumb "onemogoči."
Ko boste želeli izključeni dodatek znova vključiti, pritisnite gumb "omogoči".
Izključite lahko tiste dodatke, katerih stanje kaže, da tečejo ali pa da so "omogočeni", ravno tako pa lahko znova vključite tiste dodatke, katerih stanje kaže, da so "onemogočeni".
Ob vsakem pritisku gumba Omogoči/onemogoči, se stanje dodatka spremeni, tako da boste lahko vedeli, v kakšnem stanju bo deloval dodatek, ko boste NVDA ponovno zagnali.
Če je bil dodatek prej onemogočen, je njegovo stanje prikazano kot "omogočeno po ponovnem zagonu.
Če je bil dodatek prej "omogočen", je njegovo stanje prikazano kot "onemogočeno po ponovnem zagonu".
Tako kot ob namestitvi ali odstranitvi dodatka, je tudi tu potreben ponovni zagon NVDA, da bodo spremembe stopile v veljavo.

Upravitelj dodatkov vsebuje tudi gumb Zapri, s katerim lahko zaprete pogovorno okno.
Neglede na to, če ste namestili, spremenili ali odstranili dodatek, vas bo NVDA vprašala, če jo želite ponovno zagnati, da se bodo lahko spremembe, ki ste jih naredili, uveljavile.

Nekateri starejši dodatki verjetno ne bodo več združljivi s to različico NVDA, ki jo imate.
Ob uporabi starejše različice NVDA prav tako nekateri novejši dodatki ne bodo združljivi.
Poskus namestitve nezdružljivega dodatka bo rezultiral v napaki z razlago, zakaj je dodatek ocenjen kot nezdružljiv.
Za pregled teh nezdružljivih dodatkov , lahko uporabite gumb "poglejte nezdružljive dodatke" za zagon upravitelja nezdružljivih dodatkov.

Za dostop do Upravitelja dodatkov od kjerkoli, prosimo, dodelite lastno kretnjo z uporabo [pogovornega okna Kretenj Vnosa.](#InputGestures)

#### Upravitelj Nezdružljivih Dodatkov {#incompatibleAddonsManager}

Upravitelj Nezdružljivih Dodatkov, do katerega se lahko dostopa prek gumba "preglej nezdružljive dodatke" v Upravitelju dodatkov, vam dovoljuje pregled kateregakoli nezdružljivega dodatka in razlog, zakaj je bil ocenjen kot nezdružljiv.
Dodatki se ocenijo kot nezdružljivi takrat, ko se niso posodobili tako, da bi delovali skladno z večjimi spremembami v NVDA ali, ko se zanašajo na zmožnost, ki ni na voljo v različici NVDA, katera se uporablja.
Upravitelj nezdružljivih dodatkov vsebuje kratko sporočilo o njegovem namenu kot tudi različico NVDA.
Nezdružljivi dodatki so predstavljeni na seznamu z naslednjimi stolpci:

1. Paket, ime dodatka
1. Različica, različica dodatka
1. Razlog nezdružljivosti, razlaga, zakaj je dodatek ocenjen kot nezdružljiv

Upravitelj nezdružljivih dodatkov ima tudi gumb "O dodatku...".
To pogovorno okno vas bo oskrbelo s podrobnimi informacijami o dodatku, kar vam bo v pomoč, ko boste skušali stopiti v stik z avtorjem dodatka.

### Ustvari prenosljivo kopijo {#CreatePortableCopy}

To bo odprlo pogovorno okno, ki vam dovoljuje ustvarjanje prenosljive kopije NVDA iz nameščene različice.
Po drugi strani, ko bo tekla prenosljiva kopija NVDA, se bo v dodatnem podmeniju Orodij pokazala menijska postavka "namesti NVDA na ta PC" namesto "ustvari prenosljivo kopijo".

Pogovorno okno za ustvarjanje prenosljive kopije NVDA ali za namestitev NVDA na ta PC vasbo pozval k izbiri poti za mapo, kjer bi morala NVDA ustvariti prenosljivo kopijo ali v katero bi se morala NVDA namestiti.

V tem pogovornem oknu lahko omogočite ali onemogočite sledeče:

* Preslikaj trenutno uporabniško konfiguracijo  (to vključuje datoteke v %appdata%\roaming\NVDA ali v uporabniški konfiguraciji vaše prenosljive kopije in vključuje tudi dodatke in druge module)
* Zaženi novo prenosljivo kopijo po njeni stvaritvi ali zaženi NVDA po namestitvi (samodejno zažene NVDA po stvaritvi prenosljive kopije ali po namestitvi)

### Zaženi orodje za odpravljanje težav z registracijo COM knjižnic... {#RunCOMRegistrationFixingTool}

Nameščanje in odstranjevanje programov v računalnik lahko v nekaterih slučajih povzroči deregistracijo COM DLL datotek.
Ker se COM Vmesniki, kot je IAccessible, zanašajo na pravilne COM DLL registracije, se težave lahko pojavijo v slučajih, ko manjka pravilna registracija.

To se lahko zgodi NPR. po namestitvi in odstranitvi Adobe Readerja, Math Playerja in drugih programov.

Manjkajoča registracija lahko povzroči težave v brskalnikih, namiznih aplikacijah, opravilni vrstici in v drugih vmesnikih.

Bolj natančno, z zagonom tega orodja se lahko rešijo naslednje težave:

* NVDA sporoča "neznano", ko se krmili v brskalnikih, kot so Firefox, Thunderbird in drugi.
* NVDA ne uspe pretikati med delovanjem žarišča in brskalniškim delovanjem
* NVDA je zelo počasna, ko se krmili v brskalnikih ob uporabi brskalniškega delovanja
* In verjetno tudi druge težave.

### Ponovno Naloži vtičnike {#ReloadPlugins}

Ta postavka, ko jo sprožite, ponovno naloži aplikacijske module in globalne vtičnike brez potrebe po ponovnem zagonu NVDA, kar je lahko uporabno za razvijalce.

## Podprte Govorne Sinteze {#SupportedSpeechSynths}

Ta razdelek vsebuje informacije o govornih sintezah, ki jih podpira NVDA.
Za bolj razširjen seznam tako brezplačnih kot plačljivih govornih sintez, ki jih lahko kupite in prenesete za uporabo z NVDA, si, prosimo, oglejte [stran z dodatnimi glasovi za NVDA](https://github.com/nvaccess/nvda/wiki/ExtraVoices).

### eSpeak NG {#eSpeakNG}

Govorna sinteza [eSpeak NG](https://github.com/espeak-ng/espeak-ng) je vgrajena neposredno v NVDA in ne potrebuje namestitve posebnih gonilnikov ali drugih komponent.
NVDA privzeto začne uporabljati eSpeak NG v operacijskih sistemih Windos 7, 8 in 8.1, v operacijskem sistemu Windows 10 pa privzeto uporablja [Windows OneCore](#OneCore).
Ker je ta sinteza vgrajena v NVDA, je to čudovita izbira, ko NVDA poganjamo z USB ključka na drugih sistemih.

Vsak glas, ki prihaja z eSpeakom NG, govori svoj jezik.
Sinteza eSpeak NG podpira več kot 43 različnih jezikov.

Na voljo je tudi precej oseb, med katerimi lahko izbirate, da imitirajo zvoke različnih glasov.

### Microsoft Speech API različice 4 (SAPI 4) {#SAPI4}

SAPI 4 je starejši Microsoftov standard za programske govorne sinteze.
NVDA še vedno podpira to možnost, če imajo uporabniki sinteze temelječe na SAPI 4, že nameščene.
Toda Microsoft te možnosti ne podpira več in tudi potrebnih komponent Microsoft ne ponuja več.

Ko boste uporabljali take sinteze z NVDA, bodo prikazani vsi možni glasovi (dostopni v [zvrsti  Govor](#SpeechSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings) ali prek [Kroga Nastavitev Sinteze](#SynthSettingsRing)), iz vseh SAPI 4 pogonov, ki so se našli v vašem sistemu.

### Microsoft Speech API različice 5 (SAPI 5) {#SAPI5}

SAPI 5 je trenuten Microsoftov standard za programske govorne sinteze.
Veliko govornih sintez, ki je združljivih s tem standardom, je na voljo brezplačno za posedovanje ali prenos prek različnih družb ali spletnih mest, čeprav bo vaš sistem verjetno že imel prednameščeno vsaj eno tako sintezo.
Ko uporabljate to sintezo z NVDA, bodo na voljo vsi glasovi (dostopni prek [zvrsti Govor](#SpeechSettings) pogovornega okna [NVDA Nastavitev](#NVDASettings) ali prek [Kroga Nastavitev Sinteze](#SynthSettingsRing)) iz vseh pogonov, ki jih je NVDA našla na vašem sistemu.

### Microsoft Speech Platform {#MicrosoftSpeechPlatform}

Microsoft Speech Platform (Microsoftova govorna platforma) oskrbuje glasove za precejšnje število jezikov, ki se običajno uporabljajo tekom razvoja govornih aplikacij, ki temeljijo na strežniški podpori.
Ti glasovi pa se lahko uporabljajo tudi z NVDA.

Za uporabo teh glasov boste morali v sistem namestiti ti dve komponenti:

* Microsoft Speech Platform - Runtime (Različica 11) , x86: https://www.microsoft.com/download/en/details.aspx?id=27225
* Microsoft Speech Platform - Runtime Languages (Različica 11): https://www.microsoft.com/download/en/details.aspx?id=27224
 * Ta stran vsebuje veliko število datotek, ki se dotikajo tako govorne prepoznave (speech recognition), kot pretvorbe besedila v govor - BVG (Text to Speech).
 Izberite datoteke, ki vsebujejo podatke za BVG, ki ustrezajo vašim izbranim jezikom/glasovom.
 Na primer, datoteka MSSpeech_TTS_en-US_ZiraPro.msi je glas, ki govori ameriško Angleščino.

### Glasovi Windows OneCore {#OneCore}

Operacijski sistem Windows 10 vključuje nove glasove, poznane kot "OneCore" ali "mobile" glasove.
Glasovi so na voljo za razzlične jezike in ti so bolj odzivni kot so Microsoftovi glasovi, ki so na voljo z uporabo Microsoft Speech API različice 5.
V Windows 10 NVDA privzeto uporablja glasove Windows OneCore ([eSpeak NG](#eSpeakNG) se uporablja v drugih izdajah).

Prosimo, oglejte si Microsoftov članek (verjetno v Angleščini) za seznam trenutno podprtih jezikov z govornimi Microsoftovimi sintezami in navodili, kako te glasove namestiti: https://support.microsoft.com/en-us/help/22797/windows-10-narrator-tts-voices

## Podprte Brajeve Vrstice {#SupportedBrailleDisplays}

Ta razdelek vsebuje informacije o brajevih vrsticah, ki jih podpira NVDA.

### Vrstice, ki podpirajo samodejno zaznavo v ozadju {#AutomaticDetection}

NVDA je zmožna zaznati precejšnje število brajevih vrstic v ozadju samodejno tako prek USB povezave kot prek Bluetooth povezave.
To vedenje se doseže z izbiro možnosti Samodejno kot prednostne brajeve vrstice iz NVDA [pogovornega okna Nastavitev Brajice](#BrailleSettings).
Privzeto je ta možnost izbrana.

Sledeče vrstice podpirajo funkcijo samodejne zaznave.

* Handy Tech vrstice
* Baum/Humanware/APH/Orbit brajeve vrstice
* HumanWare Brailliant BI/B serija
* HumanWare BrailleNote
* SuperBraille
* Optelec ALVA 6 serija
* HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille Serije
* Eurobraille Esys/Esytime/Iris vrstice
* Nattiq nBrajeve vrstice

### Freedom Scientific Focus/PAC Mate Series {#FreedomScientificFocus}

Vse Focus in PAC Mate vrstice iz [podjetja Freedom Scientific,](https://www.freedomscientific.com/) so podprte, ko so na računalnik priključene prek USB ali bluetooth povezave.
V sistemu boste morali imeti nameščene gonilnike za Freedom Scientific rajeve vrstice.
Če jih še nimate, jih lahko pridobite s https://www2.freedomscientific.com/downloads/focus-40-blue/focus-40-14-blue-downloads.asp.
Čeprav ta stran omenja samo Focus Blue vrstico, gonilniki podpirajo vse Freedom Scientific Focus in Pacmate vrstice.

Privzeto NVDA zna samodejno zaznati in se s temi vrsticami tudi povezati prek USB ali bluetooth povezave.
Vseeno pa lahko ob konfiguraciji vrstice eksplicitno določite "USB" ali "bluetooth" vrata, da omejite tip povezave v uporabi.
To je lahko uporabno ob tem, ko želite Focus vrstico priključiti na računalnik in jo povezati z NVDA prek bluetooth povezave, vseeno pa jo želite polniti prek USB vhoda, ko je tako priključena v sistem.
Funkcija Samodejne zaznave brajevih vrstic v NVDA bo zaznala tudi vrstico na vratih USB ali povezavi Bluetooth.

Sledeče prirejene tipke predstavljajo naslednje NVDA ukaze za to vrstico.
Prosimo, poglejte si dokumentacijo vrstice za točen opis posamezne tipke in njenega položaja.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |topRouting1 (prva celica na vrstici)|
|Pomakni brajevo vrstico naprej |topRouting20/40/80 (zadnja celica na vrstici)|
|pomakni brajevo vrstico nazaj |leftAdvanceBar|
|Pomakni brajevo vrstico naprej |rightAdvanceBar|
|stikalo brajeve navezave na |leftGDFButton+rightGDFButton|
|Stikalo leve wiz wheel action |leftWizWheelPress|
|Pomik nazaj z uporabo leve wiz wheel action |leftWizWheelUp|
|Pomik naprej z uporabo leve wiz wheel action |leftWizWheelDown|
|Stikalo desne wiz wheel action |rightWizWheelPress|
|Pomik nazaj z uporabo desne wiz wheel action |rightWizWheelUp|
|Pomik naprej z uporabo desne wiz wheel action |rightWizWheelDown|
|Usmeri na brajevo celico |routing|
|tipka shift+tab |brailleSpaceBar+dot1+dot2|
|tipka tab |brailleSpaceBar+dot4+dot5|
|tipka puščicaGor |brailleSpaceBar+dot1|
|tipka puščicaDol |brailleSpaceBar+dot4|
|tipka control+puščicaLevo |brailleSpaceBar+dot2|
|tipka control+puščicaDesno |brailleSpaceBar+dot5|
|tipka puščicaLevo |brailleSpaceBar+dot3|
|tipka puščicaDesno |brailleSpaceBar+dot6|
|tipka home |brailleSpaceBar+dot1+dot3|
|tipka end |brailleSpaceBar+dot4+dot6|
|tipka control+home |brailleSpaceBar+dot1+dot2+dot3|
|tipka control+end |brailleSpaceBar+dot4+dot5+dot6|
|tipka alt |brailleSpaceBar+dot1+dot3+dot4|
|tipka alt+tab |brailleSpaceBar+dot2+dot3+dot4+dot5|
|tipka alt+shift+tab |brailleSpaceBar+dot1+dot2+dot5+dot6|
|tipka windows+tab |brailleSpaceBar+dot2+dot3+dot4|
|tipka escape |brailleSpaceBar+dot1+dot5|
|tipka windows |brailleSpaceBar+dot2+dot4+dot5+dot6|
|tipka space |brailleSpaceBar|
|tipka windows+d (minimiranje vseh programov) |brailleSpaceBar+dot1+dot2+dot3+dot4+dot5+dot6|
|Sporoči Trenutno Vrstico |brailleSpaceBar+dot1+dot4|
|meni NVDA |brailleSpaceBar+dot1+dot3+dot4+dot5|

Za novejše modele Focus, ki posedujejo rocker bar tipke (focus 40, focus 80 and focus blue):

| Ime |Tipka|
|---|---|
|Premakni brajevo vrstico v prejšnjo vrstico |leftRockerBarUp, rightRockerBarUp|
|Premakni brajevo vrstico v naslednjo vrstico |leftRockerBarDown, rightRockerBarDown|

Samo za Focus 80:

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |leftBumperBarUp, rightBumperBarUp|
|Pomakni brajevo vrstico naprej |leftBumperBarDown, rightBumperBarDown|

<!-- KC:endInclude -->

### Optelec ALVA serija 6/protocol converter {#OptelecALVA}

Tako brajeva vrstica ALVA BC640 kot BC680 iz [podjetja Optelec](https://www.optelec.com/) sta podprti, ko se na računalnik priključita prek USB ali bluetooth povezave.
Namesto teh lahko priključite starejšo vrstico znamke Optelec, kot je Braille Voyager z uporabo protocol converterja, ki ga je dobavil Optelec.
Za uporabo teh vrstic ne potrebujete nobenih posebnih gonilnikov, ki bi morali biti nameščeni v sistem.
Potrebno je samo, da se vrstica priključi in nastavi NVDA.

Pomnite: NVDA verjetno ne bo mogla uporabljati vrstico ALVA BC6 prek povezave Bluetooth, ko bo sparjena z uporabo orodja ALVA Bluetooth.
Ko ste sparili svojo napravo z uporabo tega orodja in NVDA ne zaznava vaše naprave, vam priporočamo, da sparite vašo vrstico ALVA po navadni poti z uporabo nastavitev Windows Bluetooth.

Pomnite: čeprav ima nekaj od teh vrstic brajevo tipkovnico, te privzeto same upravljajo s prevodom iz brajice v besedilo.
To pomeni, da sistem brajevega vnosa, ki ga uporablja NVDA, ni v uporabi v privzeti situaciji (t.j. nastavitev za tabelo brajevega vnosa nima nobenega učinka).
Pri vrsticah ALVA z zadnjo strojno kodo (firmware) je možno onemogočiti to HID simulacijo tipkovnice z uporabo kretnje vnosa.

Sledeče tipke so pripete k naslednjim ukazom v NVDA za to vrstico.
Prosimo, preglejte dokumentacijo vrstice, da boste vedeli, kje se posamezna tipka nahaja.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |t1,etouch1|
|Premakni brajevo vrstico v prejšnjo vrstico |t2|
|Premakni na trenutni položaj žarišča |t3|
|Premakni brajevo vrstico v naslednjo vrstico |t4|
|Pomakni brajevo vrstico naprej |t5, etouch3|
|Usmeri na brajevo celico |routing|
|Sporočaj oblikovanje besedila pod brajevo celico |secondary routing|
|Stikalo HID simulacije tipkovnice |t1+spEnter|
|Premakni v zgornjo vrstico pregleda |t1+t2|
|Premakni v spodnjo vrstico pregleda |t4+t5|
|Preklopi način delovanja v brajevi metodi |t1+t3|
|Sporoči naslov |etouch2|
|Sporoči vrstico stanja |etouch4|
|tipka shift+tab |sp1|
|tipka alt |sp2, alt|
|tipka escape |sp3|
|tipka tab |sp4|
|tipka puščicaGor |spUp|
|tipka puščicaDol |spDown|
|tipka puščicaLevo |spLeft|
|tipka puščicaDesno |spRight|
|tipka enter |spEnter, enter|
|Sporoči datum/čas |sp2+sp3|
|Meni NVDA |sp1+sp3|
|tipka windows+d (minimiranje vseh programov) |sp1+sp4|
|tipka windows+b (postavi se v sistemski pladenj) |sp3+sp4|
|tipka windows |sp1+sp2, windows|
|tipka alt+tab |sp2+sp4|
|tipka control+home |t3+spUp|
|tipka control+end |t3+spDown|
|tipka home |t3+spLeft|
|tipka end |t3+spRight|
|tipka control |control|

<!-- KC:endInclude -->

### Vrstice Handy Tech {#HandyTech}

NVDA podpira večino vrstice [podjetja Handy Tech,](https://www.handytech.de/) ko so priključene na računalnik prek vrat USB, serijskih vrat ali bluetooth povezave.
V primeru uporabe starejših vrstic, boste morali gonilnike zanje prenesti in namestiti v sistem s spletnega mesta Handy Tech.

Sledeče vrstice niso podprte "iz škatle" vendar se jih lahko uporablja s pomočjo [handy Techovega univerzalnega gonilnika](https://handytech.de/en/service/downloads-and-manuals/handy-tech-software/braille-display-drivers) in NVDA dodatka:

* Braillino
* Bookworm
* Modularne vrstice z  različico strojne kode (firmware) 1.13 ali nižjo. Prosimo, pribeležite si, da se strojna koda teh vrstic lahko posodobi.

Sledeče tipke so ukazi za vrstice Handy Tech ob uporabi z NVDA.
Prosimo, glejte dokumentacijo vrstice, da boste vedeli, kje senahaja katera tipka.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |levo, gor, b3|
|Pomakni brajevo vrstico naprej |desno, dol , b6|
|Premakni brajevo vrstico v prejšnjo vrstico |b4|
|Premakni brajevo vrstico v naslednjo vrstico |b5|
|Usmeri na brajevo celico |routing|
|tipka shift+tab |esc, leva tipka s trojno funkcijo gor+dol|
|tipka alt |b2+b4+b5|
|tipka escape |b4+b6|
|tipka tab |enter, desna tipka s trojno funkcijo gor+dol|
|tipka enter |esc+enter, leva+desna  tipka s trojno funkcijo gor+dol, pritisk smerne paličice|
|tipka puščicaGor |smerna paličica gor|
|tipka puščicaDol |smerna paličica dol|
|tipka puščicaLevo |smerna paličica levo|
|tipka puščicaDesno |smerna paličica desno|
|Meni NVDA |b2+b4+b5+b6|
|Stikalo za preklop brajeve navezave na |b2|
|Stikalo za preklop brajeve utripalke |b1|
|Stikalo za preklop predstavitve kontekstne informacije v žarišču |b7|
|Stikalo za preklop brajevega vnosa |space+b1+b3+b4 (space+capital B)|

<!-- KC:endInclude -->

### MDV Lilli {#MDVLilli}

Brajeva vrstica Lilli na voljo z [MDV](https://www.mdvbologna.it/) je podprta.
Za uporabo te vrstice vam ni potrebno namestiti posebnih gonilnikov.
Vrstico je potrebno samo priključiti in konfigurirati NVDA.

Ta vrstica ne podpira funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledeče tipke so prirejene za uporabo te vrstice z NVDA.
Prosimo, poglejte si dokumentacijo za opis položaja tipk.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |LF|
|Pomakni brajevo vrstico naprej |RG|
|Premakni brajevo vrstico v prejšnjo vrstico |UP|
|Premakni brajevo vrstico v naslednjo vrstico |DN|
|Usmeri na brajevo celico |route|
|tipka shift+tab |SLF|
|tipka tab |SRG|
|tipka alt+tab |SDN|
|tipka alt+shift+tab |SUP|

<!-- KC:endInclude -->

### Brajeve Vrstice Baum/Humanware/APH/Orbit {#Baum}

Precej [Baumovih](https://www.visiobraille.de/index.php?article_id=1&clang=2), [HumanWarovih](https://www.humanware.com/), [APH](https://www.aph.org/) in vrstic [Orbit](https://www.orbitresearch.com/) je podprtih, ko jih priključimo prek USB, bluetooth ali serijske povezave.
To vključuje:

* Baum: SuperVario, PocketVario, VarioUltra, Pronto!, SuperVario2, Vario 340
* HumanWare: Brailliant, BrailleConnect, Brailliant2
* APH: Refreshabraille
* Orbit: Orbit Reader 20

Verjetno dela še nekaj drugih vrstic izdelovalca Baum, vendar niso bile testirane.

Če boste priključili vrstice prek USB povezave in te ne bodo uporabljale "HID", boste morali najprej namestiti gonilnik, ki ga je oskrbel izdelovalec.
Za VarioUltra, Pronto! uporabite HID.
Refreshabraille in Orbit Reader 20 lahko uporabljata HID če bosta pravilno nastavljeni.

USB serial delovanje vrstice Orbit Reader 20 je trenutno podprto samo v sistemu Windows 10.
V drugih primerih namesto tega raje uporabite USB HID.

Sledeče tipke teh vrstic so prirejene za delovanje skupaj z NVDA.
Prosimo, poglejte si dokumentacijo vrstice za točen opis položaja posamezne tipke.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |d2|
|Pomakni brajevo vrstico naprej |d5|
|Premakni brajevo vrstico v prejšnjo vrstico |d1|
|Premakni brajevo vrstico v naslednjo vrstico |d3|
|Usmeri na brajevo celico |routing|

Velja za vrstice, ki imajo krmilno palčko:

| Ime |Tipka|
|---|---|
|Tipka puščicaGor |up|
|tipka puščicaDol |down|
|tipka puščicaLevo |left|
|tipka puščicaDesno |right|
|tipka enter |select|

<!-- KC:endInclude -->

### hedo ProfiLine USB {#HedoProfiLine}

Hedo ProfiLine USB iz [podjetja hedo Reha-Technik](https://www.hedo.de/) je podprta.
Najprej morate za uporabo te vrstice namestiti USB gonilnik, ki ga je oskrbel izdelovalec.

Ta vrstica ne podpira funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledeče tipke so prirejene za delovanje z NVDA.
Prosimo, poglejte si dokumentacijo vrstice, za opis položaja posamezne tipke.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |K1|
|Pomakni brajevo vrstico naprej |K3|
|Premakni brajevo vrstico v prejšnjo vrstico |B2|
|Premakni brajevo vrstico v naslednjo vrstico |B5|
|Usmeri na brajevo celico |routing|
|Stikalo zamenjave brajevega načina |K2|
|Preberi vse |B6|

<!-- KC:endInclude -->

### hedo MobilLine USB {#HedoMobilLine}

Hedo MobilLine USB iz [podjetja hedo Reha-Technik](https://www.hedo.de/) je podprta.
Najprej morate za uporabo te vrstice namestiti gonilnik, ki ga je oskrbel izdelovalec.

Ta vrstica ne podpira funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledeče tipke so prirejene za delovanje z NVDA.
Prosimo, oglejte si dokumentacijo za točen opis položaja posamezne tipke.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |K1|
|Pomakni brajevo vrstico naprej |K3|
|Premakni brajevo vrstico v prejšnjo vrstico |B2|
|Premakni brajevo vrstico v naslednjo vrstico |B5|
|Usmeri na brajevo celico |routing|
|Stikalo zamenjave brajevega načina |K2|
|Preberi vse |B6|

<!-- KC:endInclude -->

### HumanWare Brailliant BI/B Series/ BrailleNote Touch {#HumanWareBrailliant}

Brailliant BI in B seriji vrstic iz podjetja [HumanWare](https://www.humanware.com/), vključno z BI 14, BI 32, BI 40 in B 80, sta podprti, ko jih priključimo prek USB ali bluetooth povezave.
Če jih v sistem želite priključiti prek USB povezave in protokola HumanWare, morate najprej namestiti gonilnik, ki ga je oskrbel izdelovalec.
USB gonilnikov ne potrebujete, če bo vrstica delala prek protokola OpenBraille.

Sledeče posebne naprave so tudi podprte (in ne potrebujejo nobenih dodatnih gonilnikov za namestitev):

* APH Mantis Q40
* APH Chameleon 20
* Humanware BrailleOne
* NLS eBralnik

Sledeče tipke na vrsticah Brailliant BI/B and BrailleNote touch so prirejene za delovanje z NVDA.
Prosimo, poglejte si dokumentacijo vrstice za opis točnega položaja posamezne tipke.

#### Povezane Tipke za Vse modele {#toc255}

<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Pomakni brajevo vrstico nazaj |left|
|Pomakni brajevo vrstico naprej |right|
|Premakni brajevo vrstico v prejšnjo vrstico |up|
|Premakni brajevo vrstico v naslednjo vrstico |down|
|Usmeri na brajevo celico |routing|
|stikalo brajeve navezave z |up+down|
|tipka puščicaGor |space+dot1|
|tipka puščicaDol |space+dot4|
|tipka puščicaLevo |space+dot3|
|tipka puščicaDesno |space+dot6|
|tipka shift+tab |space+dot1+dot3|
|tipka tab |space+dot4+dot6|
|tipka alt |space+dot1+dot3+dot4 (space+m)|
|tipka escape |space+dot1+dot5 (space+e)|
|tipka enter |dot8|
|tipka windows |space+dot3+dot4|
|tipka alt+tab |space+dot2+dot3+dot4+dot5 (space+t)|
|Meni NVDA |space+dot1+dot3+dot4+dot5 (space+n)|
|tipka windows+d (minimiranje vseh programov) |space+dot1+dot4+dot5 (space+d)|
|Preberi vse |space+dot1+dot2+dot3+dot4+dot5+dot6|

<!-- KC:endInclude -->

#### Povezane tipke za Brailliant BI 32, BI 40 and B 80 {#toc256}

<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Meni NVDA |c1+c3+c4+c5 (ukaz n)|
|tipka windows+d (minimiranje vseh programov) |c1+c4+c5 (ukaz d)|
|Preberi vse |c1+c2+c3+c4+c5+c6|

<!-- KC:endInclude -->

#### Povezane tipke za Brailliant BI 14 {#toc257}

<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|tipka puščica gor |joystick up|
|tipka puščica dol |joystick down|
|tipka puščica levo |joystick left|
|tipka puščica desno |joystick right|
|tipka enter |joystick action|

<!-- KC:endInclude -->

### HIMS Braille Sense/Braille EDGE/Smart Beetle/Sync Braille Serija {#Hims}

NVDA podpira Braille Sense, Braille EDGE, Smart Beetle in vrstice Sync Braille iz podjetja [Hims,](https://www.hims-inc.com/) ko jih priključite prek USB ali bluetooth. 
Če jih priključujete prek USB, boste morali v sistem namestiti USB gonilnike, ki jih je dobavilo podjetje HIMS.
Te lahko prenesete od tod: http://www.himsintl.com/upload/HIMS_USB_Driver_v25.zip

Sledijo tipke, ki so pripete k posameznim NVDA ukazom.
Prosimo, oglejte si dokumentacijo posamezne vrstice, za točno lokacijo posamezne tipke.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Usmeri na brajevo celico |routing|
|Zavrti brajevo vrstico nazaj |leftSideScrollUp, rightSideScrollUp, leftSideScroll|
|Zavrti brajevo vrstico naprej |leftSideScrollDown, rightSideScrollDown, rightSideScroll|
|Pomakni brajevo vrstico v predhodno vrstico |leftSideScrollUp+rightSideScrollUp|
|Pomakni brajevo vrstico v naslednjo vrstico |leftSideScrollDown+rightSideScrollDown|
|Pomakni se v predhodno vrstico v pregledu |rightSideUpArrow|
|Pomakni se v naslednjo vrstico v pregledu |rightSideDownArrow|
|Pomakni se na predhodni znak v pregledu |rightSideLeftArrow|
|Pomakni se na naslednji znak v pregledu |rightSideRightArrow|
|Pomakni se na trenutno žarišče |leftSideScrollUp+leftSideScrollDown, rightSideScrollUp+rightSideScrollDown, leftSideScroll+rightSideScroll|
|tipka control |smartbeetle:f1, brailleedge:f3|
|tipka windows |f7, smartbeetle:f2|
|tipka alt |dot1+dot3+dot4+space, f2, smartbeetle:f3, brailleedge:f4|
|tipka shift |f5|
|tipka insert |dot2+dot4+space, f6|
|tipka applications |dot1+dot2+dot3+dot4+space, f8|
|tipka Caps Lock |dot1+dot3+dot6+space|
|tipka tab |dot4+dot5+space, f3, brailleedge:f2|
|tipka shift+alt+tab |f2+f3+f1|
|tipka alt+tab |f2+f3|
|tipka shift+tab |dot1+dot2+space|
|tipka end |dot4+dot6+space|
|tipka control+end |dot4+dot5+dot6+space|
|tipka home |dot1+dot3+space, smartbeetle:f4|
|tipka control+home |dot1+dot2+dot3+space|
|tipka alt+f4 |dot1+dot3+dot5+dot6+space|
|tipka puščicaLevo |dot3+space, leftSideLeftArrow|
|tipka control+shift+puščicaLevo |dot2+dot8+space+f1|
|tipka control+puščicaLevo |dot2+space|
|tipka shift+alt+puščicaLevo |dot2+dot7+f1|
|tipka alt+puščicaLevo |dot2+dot7|
|tipka puščicaDesno |dot6+space, leftSideRightArrow|
|tipka control+shift+puščicaDesno |dot5+dot8+space+f1|
|tipka control+puščicaDesno |dot5+space|
|tipka shift+alt+puščicaDesno |dot5+dot7+f1|
|tipka alt+puščicaDesno |dot5+dot7|
|tipka pageUp |dot1+dot2+dot6+space|
|tipka control+pageUp |dot1+dot2+dot6+dot8+space|
|tipka upArrow |dot1+space, leftSideUpArrow|
|tipka control+shift+puščicaGor |dot2+dot3+dot8+space+f1|
|tipka control+puščicaGor |dot2+dot3+space|
|tipka shift+alt+puščicaGor |dot2+dot3+dot7+f1|
|tipka alt+puščicaGor |dot2+dot3+dot7|
|tipka shift+puščicaGor |leftSideScrollDown+space|
|tipka pageDown |dot3+dot4+dot5+space|
|tipka control+pageDown |dot3+dot4+dot5+dot8+space|
|tipka puščicaDol |dot4+space, leftSideDownArrow|
|tipka control+shift+puščicaDol |dot5+dot6+dot8+space+f1|
|tipka control+puščicaDol |dot5+dot6+space|
|tipka shift+alt+puščicaDol |dot5+dot6+dot7+f1|
|tipka alt+puščicaDol |dot5+dot6+dot7|
|tipka shift+puščicaDol |space+rightSideScrollDown|
|tipka escape |dot1+dot5+space, f4, brailleedge:f1|
|tipka delete |dot1+dot3+dot5+space, dot1+dot4+dot5+space|
|tipka f1 |dot1+dot2+dot5+space|
|tipka f3 |dot1+dot2+dot4+dot8|
|tipka f4 |dot7+f3|
|tipka windows+b |dot1+dot2+f1|
|tipka windows+d |dot1+dot4+dot5+f1|
|tipka control+insert |smartbeetle:f1+rightSideScroll|
|tipka alt+insert |smartbeetle:f3+rightSideScroll|

<!-- KC:endInclude -->

### Brajeve Vrstice Seika {#Seika}

Brajeve vrstice Seika v različici 3, 4 in 5 (40 celic) in Seika80 (80 celic) iz podjetja [Nippon Telesoft](https://www.nippontelesoft.com/) NVDA podpira.
Več informacij o teh vrsticah in potrebne gonilnike lahko najdete na https://en.seika-braille.com/down/index.html
Obvezno morate najprej namestiti USB gonilnike, ki ste jih prejeli s strani proizvajalca.

Ta vrstica ne podpira funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledijo tipke, ki so pripete k NVDA ukazom.
Prosimo, oglejte si dokumentacijo vrstic za opis točne lokacije, kjer lahko posamezne tipke najdete.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |left|
|Zavrti brajevo vrstico naprej |right|
|Pomakni brajevo vrstico v predhodno vrstico |b3|
|Pomakni brajevo vrstico v naslednjo vrstico |b4|
|Preklapljaj zvezanost braja na |b5|
|Izgovori vse |b6|
|tab |b1|
|shift+tab |b2|
|alt+tab |b1+b2|
|NVDA Meni |left+right|
|Usmeri na brajevo celico |routing|

<!-- KC:endInclude -->

### Papenmeier BRAILLEX Novejši Modeli {#Papenmeier}

Podprte so naslednje Brajeve vrstice:

* BRAILLEX EL 40c, EL 80c, EL 20c, EL 60c (USB)
* BRAILLEX EL 40s, EL 80s, EL 2d80s, EL 70s, EL 66s (USB)
* BRAILLEX Trio (USB and bluetooth)
* BRAILLEX Live 20, BRAILLEX Live and BRAILLEX Live Plus (USB and bluetooth)

Te vrstice ne podpirajo funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Če je bil BrxCom nameščen, bo NVDA BrxCom uporabila.
BrxCom je orodje, ki omogoča neodvisno uporabo tipkovnice brajeve vrstice od bralnika zaslona.
Vnašanje prek tipkovnice je mogoče z vrsticami Trio in BRAILLEX Live.

Večina vrstic ima t.i. lahko dostopni trak (v angleščini Easy Access Bar - EAB), ki omogoča hitro in intuitivno izvajanje operacij.
Trak se lahko premakne v štiri smeri in vsaka smer ima v splošnem dve stikali.
Seriji C in Live sta edini izjemi tega pravila.

Serija c in nekaj drugih vrstic ima dvojno vrsto napotitvenih tipk, pri čemer zgornja vrsta igra vlogo sporočevalke informacij o oblikovanju izbrane celice.
Držanje ene od zgornjih napotitvenih tipk in pritisk EAB na napravah serije c, oponaša drugo stanje stikala.
Serija Live ima samo eno vrsto napotitvenih tipk in EAB se lahko premakne samo za en korak v izbrani smeri.
Drugo stanje lahko dosežete tako, da pritisnete eno od napotitvenih tipk in trak potisnete v izbrani smeri.
Pritisk in držanje tipk gor, dol, levo in desno, ali pritisk EAB, povzroči ponavljanje odgovarjajočega dejanja posamezni tipki.

V splošnem so na voljo naslednje tipke za te vrstice:

| Ime |Tipka|
|---|---|
|l1 |tipka Levo spredaj|
|l2 |tipka Levo zadaj|
|r1 |tipka Desno spredaj|
|r2 |tipka Desno zadaj|
|up |1 korak navzgor|
|up2 |2 koraka navzgor|
|left |1 korak levo|
|left2 |2 koraka levo|
|right |1 korak desno|
|right2 |2 koraka desno|
|dn |1 korak navzdol|
|dn2 |2 Koraka navzdol|

Sledijo s strani proizvajalca Papenmeier določeni ukazi za NVDA:
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |left|
|Zavrti brajevo vrstico naprej |right|
|Premakni brajevo vrstico v predhodno vrstico |up|
|Premakni brajevo vrstico v naslednjo vrstico |dn|
|Usmeri na brajevo celico |routing|
|Sporoči trenutni znak v pogledu |l1|
|Sproži trenutni predmet krmiljenja |l2|
|preklapljaj brajevo navezavo |r2|
|Sporoči naslov |l1+up|
|Sporoči Vrstico Stanja |l2+down|
|Premakni se na predmet z vsebino |up2|
|Premakni se na prvi predmet znotraj vsebine |dn2|
|Premakni se na predhodni predmet |left2|
|Premakni se na naslednji predmet |right2|
|Sporoči oblikovanje besedila pod brajevo celico |upper routing row|

<!-- KC:endInclude -->

Model Trio ima štiri dodatne tipke, ki se nahajajo na sprednji strani tipkovnice.
Te so (od leve proti desni):

* leva palčna tipka (lt)
* preslednica
* preslednica
* desna palčna tipka (rt)

Trenutno NVDA desne palčne tipke ne uporablja.
Notranji tipki obe služita kot presledek.

| Ime |Tipka|
|---|---|

<!-- KC:beginInclude -->

|tipka escape |space z dot 7|
|tipka Puščica gor |space z dot 2|
|tipka Puščica levo |space z dot 1|
|tipka Puščica desno |space z dot 4|
|tipka Puščica dol |space z dot 5|
|tipka control |lt+dot2|
|tipka alt |lt+dot3|
|tipka control+escape |space with dot 1 2 3 4 5 6|
|tipka tabulator |space z dot 3 7|

<!-- KC:endInclude  -->

### Papenmeier Braille BRAILLEX Starejši Modeli {#PapenmeierOld}

Podprte so naslednje Brajeve vrstice: 

* BRAILLEX EL 80, EL 2D-80, EL 40 P
* BRAILLEX Tiny, 2D Screen

Opozarjamo, da te vrstice lahko priključite samo prek serijskih vrat.
Zaradi tega te vrstice ne podpirajo funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.
Izbrati morate vrata, prek katerih se vrstica povezuje potem, ko ste izbrali ta gonilnik v pogovornem oknu [Izberi Brajevo Vrstico](#SelectBrailleDisplay).

Nekaj teh vrstic ima lahko dostopni trak (v Angleščini Easy Access Bar - EAB), ki omogoča hitro in intuitivno izvajanje operacij.
Trak se lahko premakne v štiri smeri in vsaka smer ima v splošnem dve stikali.
Pritisk in držanje tipk gor, dol, levo in desno, ali pritisk EAB, povzroči ponavljanje odgovarjajočega dejanja posamezni tipki.
Starejši modeli nimajo EAB, zato se uporabljajo tipke na sprenji plošči.

V splošnem so na voljo naslednje tipke:

| Ime |Tipka|
|---|---|
|l1 |tipka Levo spredaj|
|l2 |tipka Levo zadaj|
|r1 |tipka Desno spredaj|
|r2 |tipka Desno zadaj|
|up |1 Korak navzgor|
|up2 |2 Koraka navzgor|
|left |1 Korak levo|
|left2 |2 Koraka levo|
|right |1 Korak desno|
|right2 |2 Koraka desno|
|dn |1 Korak navzdol|
|dn2 |2 Koraka navzdol|

Sledijo s strani proizvajalca Papenmeier določeni ukazi za NVDA:

<!-- KC:beginInclude -->
Naprave z EAB:

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |left|
|Zavrti brajevo vrstico naprej |right|
|Premakni brajevo vrstico v predhodno vrstico |up|
|Premakni brajevo vrstico v naslednjo vrstico |dn|
|Usmeri na brajevo celico |routing|
|Sporoči trenutni znak v pogledu |l1|
|Sproži trenutni predmet krmiljenja |l2|
|Sporoči naslov |l1up|
|Sporoči Vrstico Stanja |l2down|
|Premakni se na predmet z vsebino |up2|
|Premakni se na prvi predmet znotraj vsebine |dn2|
|Premakni se na naslednji predmet |right2|
|Premakni se na predhodni predmet |left2|
|Sporoči oblikovanje besedila pod brajevo celico |Zgornja usmerjevalna vrsta|

BRAILLEX Tiny:

| Ime |Tipka|
|---|---|
|Sporoči trenutni znak v pogledu |l1|
|Sproži trenutni predmet krmiljenja |l2|
|Zavrti brajevo vrstico nazaj |left|
|Zavrti brajevo vrstico naprej |right|
|Premakni brajevo vrstico v predhodno vrstico |up|
|Premakni brajevo vrstico v naslednjo vrstico |dn|
|Preklapljaj brajevo navezavo na |r2|
|Premakni se na predmet z vsebino |r1+up|
|Premakni se na prvi predmet znotraj vsebine |r1+dn|
|Premakni se na predhodni predmet |r1+left|
|Premakni se na naslednji predmet |r1+right|
|Sporoči oblikovanje besedila pod brajevo celico |zgornja usmerjevalna vrsta|
|Sporoči naslov |l1+up|
|Sporoči Vrstico Stanja |l2+down|

BRAILLEX 2D Screen:

| Ime |Tipka|
|---|---|
|Sporoči trenutni znak v pogledu |l1|
|Sproži trenutni predmet krmiljenja |l2|
|Preklapljaj brajevo navezavo na |r2|
|Sporoči oblikovanje besedila pod brajevo celico |zgornja usmerjevalna vrsta|
|Premakni brajevo vrstico v predhodno vrstico |up|
|Zavrti brajevo vrstico nazaj |left|
|Zavrti brajevo vrstico naprej |right|
|Premakni brajevo vrstico v naslednjo vrstico |dn|
|Premakni se na naslednji predmet |left2|
|Premakni se na predmet z vsebino |up2|
|Premakni se na prvi predmet znotraj vsebine |dn2|
|Premakni se na predhodni predmet |right2|

<!-- KC:endInclude -->

### HumanWare BrailleNote {#HumanWareBrailleNote}

NVDA podpira beležnice iz podjetja [Humanware](https://www.humanware.com), ko se obnašajo kot prikazni terminali za bralnik zaslona.
Podprti so naslednji modeli:

* BrailleNote Classic (samo serijski priključek)
* BrailleNote PK (Serijski in bluetooth priključki)
* BrailleNote MPower (Serijski in bluetooth priključki)
* BrailleNote Apex (možno priključiti prek USB in Bluetooth)

Za BrailleNote Touch glejte odsek [Brailliant BI Series / BrailleNote Touch](#HumanWareBrailliant).

Z izjemo BrailleNote PK, sta obe brajevi (BT) in QWERTY (QT) tipkovnici podprti.
Za BrailleNote QT velja, da oponašanje računalniške tipkovnice ni podprto.
Brajeve pike lahko vnašate tudi prek QT tipkovnice.
Prosimo, preverite odsek brajevega terminala v vodiču beležnice BrailleNote za podrobnosti.

Če vaša naprava podpira več vrst povezave, ko vašo beležnico BrailleNote priključujete v NVDA, boste morali določiti vrata brajevega terminala v možnosteh brajevega terminala.
Prosimo, podrobnosti preverite v priročniku za uporabo, ki ste ga prejeli zraven vaše beležnice BrailleNote.
Verjetno boste morali vrata določiti tudi v meniju NVDA v pogovornem oknu [Izberi Brajevo Vrstico](#SelectBrailleDisplay).
Če beležnico priključujete prek vrat USB ali protokola Blootooth, lahko vrata nastavite na "Samodejno", "USB" ali "Bluetooth"; vse je odvisno od izbir, ki so na voljo.
Če se priključujete prek starih serijskih vrat, (ali uporabljate pretvornik USB v Serijska vrata) ali nič od tega, morate obvezno določiti komunikacijska vrata za uporabo is seznama strojnih vrat.

Preden boste priključili vašo beležnico BrailleNote Apex z uporabo njenega lastnega USB vmesnega odjemalca, morate namestiti gonilnike, ki jih je priskrbel HumanWare.

Na BrailleNote Apex BT lahko uporabite vrteče se kolesce, ki je nameščeno med pikama 1 in 4 za različne ukaze za NVDA.
Kolesce sestoji iz štirih smernih pik, sredinskega gumba in kolesca, ki se vrti v smeri in tudi v nasprotni smeri urinega kazalca (ure).

Sledijo BrailleNote ukazi, ki so zvezani na NVDA.
Prosimo, preverite dokumentacijo naprave, da boste vedeli, kje se posamezna tipka nahaja.

<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |back|
|Zavrti brajevo vrstico naprej |advance|
|Pomakni brajevo vrstico v predhodno vrstico |previous|
|Pomakni brajevo vrstico v naslednjo vrstico |next|
|Usmeri na brajevo celico |routing|
|meni NVDA |space+dot1+dot3+dot4+dot5 (space+n)|
|Preklapljanje navezovanja brajice |previous+next|
|tipka Puščica Gor |space+dot1|
|tipka Puščica Dol |space+dot4|
|tipka Puščica Levo |space+dot3|
|tipka Puščica Desno |space+dot6|
|tipka stran Gor |space+dot1+dot3|
|tipka stran Dol |space+dot4+dot6|
|tipka Začetek |space+dot1+dot2|
|tipka Konec |space+dot4+dot5|
|tipki Control+začetek |space+dot1+dot2+dot3|
|tipki Control+konec |space+dot4+dot5+dot6|
|tipka Preslednica |space|
|Enter |space+dot8|
|Vračalka |space+dot7|
|tipka Tab |space+dot2+dot3+dot4+dot5 (space+t)|
|tipki Shift+tab |space+dot1+dot2+dot5+dot6|
|tipka Windows |space+dot2+dot4+dot5+dot6 (space+w)|
|tipka Alt |space+dot1+dot3+dot4 (space+m)|
|Preklop v delovanju vnosne pomoči |space+dot2+dot3+dot6 (space+spodnji h)|

Sledeči ukazi so pripeti k BrailleNote QT, ko ta ni v načinu vnašanja brajice.
+

| Ime |Tipka|
|---|---|
|meni NVDA |read+n|
|tipka puščica Gor |upArrow|
|tipka puščica Dol |downArrow|
|tipka puščica Levo |leftArrow||
|tipka puščica Desno |rightArrow|
|Tipka Stran gor |function+upArrow|
|tipka Stran dol |function+downArrow|
|tipka Home |function+leftArrow|
|tipka End |function+rightArrow|
|tipki Control+home |read+t|
|tipki Control+end |read+b|
|tipki Enter |enter|
|tipka Backspace |backspace|
|tipka Tab |tab|
|tipki Shift+tab |shift+tab|
|tipka Windows |read+w|
|tipka Alt |read+m|
|Stikalo pomoči za vnos |read+1|

Sledeči ukazi so pripeti k vrtečemu se kolescu:

| Ime |Tipka|
|---|---|
|tipka puščica gor |upArrow|
|tipka puščica Dol |downArrow|
|tipka puščica Levo |leftArrow|
|tipka puščica Desno |rightArrow|
|tipka Enter |centre button (sredinski gumb)|
|tipka Tab |scroll wheel clockwise (kolesce v smeri ure)|
|tipki Shift+tab |scroll wheel counterclockwise (kolesce v nasprotni smeri ure)|

<!-- KC:endInclude -->

### EcoBraille {#EcoBraille}

NVDA podpira EcoBraille vrstice iz ustanove [ONCE](https://www.once.es/).
Podprti so naslednji modeli:

* EcoBraille 20
* EcoBraille 40
* EcoBraille 80
* EcoBraille Plus

Serijska vrata, prek katerih je vrstica priključena v sistem, v NVDA lahko izberete v pogovornem oknu [Izberi Brajevo Vrstico #SelectBrailleDisplay.
Te vrstice ne podpirajo funkcije samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledijo ukazi v NVDA s posameznimi tipkami z vrstice.
Prosimo, poglejte [EcoBraille dokumentacijo](ftp://ftp.once.es/pub/utt/bibliotecnia/Lineas_Braille/ECO/) za podrobnosti o položaju posamezne tipke.

<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |T2|
|Zavrti brajevo vrstico naprej |T4|
|Pomakni brajevo vrstico v predhodno vrstico |T1|
|Pomakni brajevo vrstico v naslednjo vrstico |T5|
|Usmeri v brajevo celico |Routing|
|Sproži trenutni predmet krmiljenja |T3|
|Preklopi v naslednje delovanje pregleda |F1|
|Pomakni se na predmet z vsebino |F2|
|Preklopi na predhodno delovanje pregleda |F3|
|Pomakni se na prejšnji predmet |F4|
|Sporoči trenutni predmet |F5|
|Pomakni se na naslednji predmet |F6|
|Pomakni se na predmet v žarišču |F7|
|Pomakni se na prvi predmet znotraj vsebine |F8|
|Pomakni sistemsko žarišče ali kazalko na trenutni položaj v pregledu |F9|
|Sporoči položaj pregledne utripalke |F0|
|Stikalo navezovanja brajice na |A|

<!-- KC:endInclude -->

### SuperBraille {#SuperBraille}

Naprava SuperBraille, na voljo predvsem na Tajvanu, se lahko priklopi tako na USB kot serijska vrata.
Ker SuperBraille nima nobenih fizičnih tipk ali vrtečih se gumbov, se morajo vsi vnosi vršiti prek standardne računalniške tipkovnice.
Zaradi tega in zaradi vzdrževanja združljivosti z ostalimi bralniki zaslona, ki se uporabljajo na Tajvanu, je v NVDA na voljo dvoje  tipkovničnih ukazov, s katerima lahko pomikate brajevo vrstico:
+<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |številski del Minus|
|Zavrti brajevo vrstico naprej |številski del Plus|

<!-- KC:endInclude -->

### vrstice Eurobraille Esys/Esytime/Iris {#Eurobraille}

Vrstice Esys, Esytime in Iris iz [Eurobraille](https://www.eurobraille.fr/) so podprte v NVDA.
Naprave Esys in Esytime-Evo so podprte, ko so priključene prek USB ali bluetooth.
Starejše naprave Esytime podpirajo samo USB.
Vrstice Iris se lahko priključijo samo prek serijskih vrat.
Zaradi tega morate za te vrstice določiti vrata, preko katerih je priključena vrstica, ko ste izbrali ta gonilnik v pogovornem oknu Nastavitev Brajice.

Iris in Esys vrstice imajo brajevo tipkovnico z 10 tipkami.
Od dveh tipk, ki sta postavljeni kot preslednica, leva tipka odgovarja tipki backspace in desna tipka preslednici.

Sledijo tipke, ki so pripete k NVDA ukazom.
Prosimo, oglejte si dokumentacijo vrstic za opis točne lokacije, kjer lahko posamezne tipke najdete.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavrti brajevo vrstico nazaj |switch1-6left, l1|
|Zavrti brajevo vrstico naprej |switch1-6Right, l8|
|Premakni se na trenutno žarišče |switch1-6Left+switch1-6Right, l1+l8|
|Usmeri na brajevo celico |routing|
|Sporoči oblikovanje besedila pod brajevo celico |doubleRouting|
|Premakni se v predhodno vrstico v pregledu |joystick1Up|
|Premakni se v naslednjo vrstico v pregledu |joystick1Down|
|Premakni se na predhodni znak v pregledu |joystick1Left|
|Premakni se na naslednji znak v pregledu |joystick1Right|
|Preklopi v predhodno delovanje pregleeda |joystick1Left+joystick1Up|
|Preklopi v naslednje delovanje pregleeda |joystick1Right+joystick1Down|
|Zradiraj zadnji vnos v brajevo celico ali znak |backSpace|
|Prevedi katerikoli brajev vnos in pritisni tipko enter |backSpace+space|
|tipka insert |dot3+dot5+space, l7|
|tipka delete |dot3+dot6+space|
|tipka home |dot1+dot2+dot3+space, joystick2Left+joystick2Up|
|tipka end |dot4+dot5+dot6+space, joystick2Right+joystick2Down|
|tipka puščicaLevo |dot2+space, joystick2Left, leftArrow|
|tipka puščicaDesno |dot5+space, joystick2Right, rightArrow|
|tipka puščicaGor |dot1+space, joystick2Up, upArrow|
|tipka puščicaDol |dot6+space, joystick2Down, downArrow|
|tipka enter |joystick2Centre|
|tipka pageUp |dot1+dot3+space|
|tipka pageDown |dot4+dot6+space|
|tipka številski del1 |dot1+dot6+backspace|
|tipka številski del2 |dot1+dot2+dot6+backspace|
|tipka številski del3 |dot1+dot4+dot6+backspace|
|tipka številski del4 |dot1+dot4+dot5+dot6+backspace|
|tipka številski del5 |dot1+dot5+dot6+backspace|
|tipka številski del6 |dot1+dot2+dot4+dot6+backspace|
|tipka številski del7 |dot1+dot2+dot4+dot5+dot6+backspace|
|tipka številski del8 |dot1+dot2+dot5+dot6+backspace|
|tipka številski del9 |dot2+dot4+dot6+backspace|
|tipka številski delInsert |dot3+dot4+dot5+dot6+backspace|
|tipka številski delDecimal |dot2+backspace|
|tipka številski delDivide |dot3+dot4+backspace|
|tipka številski delMultiply |dot3+dot5+backspace|
|tipka številski delMinus |dot3+dot6+backspace|
|tipka številski delPlus |dot2+dot3+dot5+backspace|
|tipka številski delEnter |dot3+dot4+dot5+backspace|
|tipka escape |dot1+dot2+dot4+dot5+space, l2|
|tipka tab |dot2+dot5+dot6+space, l3|
|tipka shift+tab |dot2+dot3+dot5+space|
|tipka printScreen |dot1+dot3+dot4+dot6+space|
|tipka pause |dot1+dot4+space|
|tipka applications |dot5+dot6+backspace|
|tipka f1 |dot1+backspace|
|tipka f2 |dot1+dot2+backspace|
|tipka f3 |dot1+dot4+backspace|
|tipka f4 |dot1+dot4+dot5+backspace|
|tipka f5 |dot1+dot5+backspace|
|tipka f6 |dot1+dot2+dot4+backspace|
|tipka f7 |dot1+dot2+dot4+dot5+backspace|
|tipka f8 |dot1+dot2+dot5+backspace|
|tipka f9 |dot2+dot4+backspace|
|tipka f10 |dot2+dot4+dot5+backspace|
|tipka f11 |dot1+dot3+backspace|
|tipka f12 |dot1+dot2+dot3+backspace|
|tipka windows |dot1+dot2+dot3+dot4+backspace|
|tipka Caps Lock |dot7+backspace, dot8+backspace|
|tipka num lock |dot3+backspace, dot6+backspace|
|tipka shift |dot7+space, l4|
|Preklop tipke shift |dot1+dot7+space, dot4+dot7+space|
|tipka control |dot7+dot8+space, l5|
|Preklop tipke control |dot1+dot7+dot8+space, dot4+dot7+dot8+space|
|tipka alt |dot8+space, l6|
|Preklop tipke alt key |dot1+dot8+space, dot4+dot8+space|
|StikaloHID simulacija vnosa prek tipkovnice |esytime):l1+joystick1Down, esytime):l8+joystick1Down|

<!-- KC:endInclude -->

### Nattiq nBrajeve Vrstice {#NattiqTechnologies}

NVDA podpira vrstice iz [Nattiq Technologies,](https://www.nattiq.com/) ko jih priključite prek USB.
Windows 10 zazna Brajeve Vrstice, ko so prvič priključene; verjetno pa boste morali namestiti USB gonilnike, če jih boste uporabljali s starejšimi različicami Windows (starejše od Win10).
Te lahko pridobite s proizvajalčevega spletišča.

Sledijo tipkovne navezave za vrstice Nattiq Technologies z NVDA.
Prosimo, oglejte si dokumentacijo vrstice za opis, kje se nahajajo posamezne tipke.
<!-- KC:beginInclude -->

| Ime |Tipka|
|---|---|
|Zavvrti brajevo vrstico nazaj |gor|
|Zavrti brajevo vrstico naprej |dol|
|Premakni brajevo vrstico v predhodno vrstico |levo|
|Premakni brajevo vrstico v naslednjo vrstico |desno|
|Usmeri na brajevo celico |routing|

<!-- KC:endInclude -->

### BRLTTY {#BRLTTY}

[BRLTTY](https://www.brltty.com/) je program neodvisen od NVDA, ki pa ga vseeno lahko uporabimo zaradi podpore večjega števila brajevih vrstic.
Če ga želite uporabljati, morate namestiti [BRLTTY za Windows](https://www.brltty.com/download.html).
K sebi morate prenesti in namestiti zadnji namestitveni paket, ki se imenuje nekako tako brltty-win-4.2-2.exe. Številke so lahko različne.
Ko boste nastavljali vrstico in vrata, ki jih boste uporabljali, posebno pozornost namenite navodilom še posebej, če uporabljate vrstico na USB vratih, hkrati pa so gonilniki proizvajalca te vrstice že nameščeni v sistem.

Za vrstice, ki imajo brajevo tipkovnico, BRLTTY sam upravlja brajev vnos.
Tako nastavitev vnosne brajeve tabele v NVDA ni relevantna.

BRLTTY ni vključen v funkcijo samodejne zaznave brajeve vrstice v ozadju v NVDA.

Sledeči ukazi so BRLTTY ukazi, ki jih razume NVDA.
Prosimo, poglejte [BRLTTY dokumentacijo tabele povezanih tipk](http://mielke.cc/brltty/doc/KeyBindings/) for information about how BRLTTY commands are mapped to controls on braille displays.
<!-- KC:beginInclude -->

| Ime |BRLTTY command|
|---|---|
|Pomakni brajevo vrstico nazaj |fwinlt (go left one window)|
|Pomakni brajevo vrstico naprej |fwinrt (go right one window)|
|Premakni brajevo vrstico eno vrstico nazaj (v prejšnjo vrstico) |lnup (go up one line)|
|Premakni brajevo vrstico eno vrstico naprej (v naslednjo vrstico) |lndn (go down one line)|
|usmeri na brajevo celico |route (bring cursor to character)|

<!-- KC:endInclude -->

## Napredne Vsebine {#BRLTTY}
### Možnosti Ukazne Vrstice {#CommandLineOptions}

NVDA lahko sprejme več dodatnih možnosti ob zagonu, ki potem vplivajo na njeno delovanje.
Uporabite lahko toliko možnosti, kot jih potrebujete.
Te možnosti se lahko uporabijo ob zagonu NVDA prek bližnjice (v lastnostih bližnjice), v pogovornem oknu Zaženi (v začetnem meniju -> Zaženi ali Windows+r) ali v ukazni konzoli Oken.
Možnosti morajo biti ločene od imena izvršljive datoteke NVDA in drugih možnosti s presledki.
Na primer,  uporabna možnost je --disable-addons, ki naroča NVDA, naj zaustavi vse dodatke, ki so v uporabi.
To vam omogoči, da ugotovite, če je težavo povzročil dodatek in da se program obnovi po resni težavi, ki jo je dodatek povzročil.

Kot primer uporabe teh možnosti lahko v pogovornem oknu Zaženi zaprete trenutno kopijo NVDA z vnosom naslednje vsebine v polje pogovornega okna:

nvda -q

Nekatere možnosti ukazne vrstice (stikala) poznajo tako kratko kot dolgo obliko, druga pa imajo samo dolgo obliko poimenovanja.
Tiste, ki imajo tudi kratko obliko, lahko med sebojno kombinirate na naslednji način

|nvda -mc CONFIGPATH |To bo zagnalo NVDA z onemogočenimi zvočnimi signali in sporočilom ob zagonu in določeno konfiguracijo|
|nvda -mc CONFIGPATH --disable-addons |Enako kot zgoraj, vendar bodo zraven onemogočeni tudi dodatki.|

Nekatere možnosti ukazne vrstice sprejemajo tudi dodatne parametre; npr. kako podrobno naj se piše dnevnik, ali pot do uporabnikove konfiguracijske mape ali imenika.
Ti parametri se morajo nahajati za možnostjo in morajo biti ločeni od možnosti s presledkom, ko se uporablja kratka različica možnosti ali s simbolom = (enačajem), ko se uporablja daljša različica; npr.:

|nvda -l 10 |Pove naj se NVDA zažene z nastavitvijo zapisovanja v dnevnik na nivoju razhroščevanja.|
|nvda --log-file=c:\nvda.log |Pove NVDA, naj dnevnik zapiše v  c:\nvda.log|
|nvda --log-level=20 -f c:\nvda.log |Pove NVDA, naj se zažene tako, da bo nivo zapisovanja v dnevnik na nivoju informacij in naj dnevnik zapiše v c:\nvda.log|

NVDA pozna naslednje možnosti ukazne vrstice:

| Kratka |Dolga |Opis|
|---|---|---|
|-h |--help |Pokaže pomoč ukazne vrstice in Izhod|
|-q |--quit |Zapre kopijo NVDA v pomnilniku (zaključi z izvajanjem trenutne kopije NVDA).|
|-k |--check-running |Sporoča, če je NVDA v pogonu. To sporoča z uporabo izhodne kode. Nič (0) pomeni, da teče in ena (1) pomeni, da NVDA ni v pogonu.|
|-f LOGFILENAME |--log-file=LOGFILENAME |Datoteka, kjer se morajo beležiti dogodki, ki se zapisujejo v dnevnik.|
|-l LOGLEVEL |--log-level=LOGLEVEL |Najnižji nivo beleženja sporočil v dnevnik (razhroščevanje 10, vhod/izhod 12, opozorilo razhroščevanja 15, info 20, opozorilo, 30, napaka 40, kritično 50 , onemogočeno 100). Privzeta vrednost je nastavljena na opozorilo.|
|-c CONFIGPATH |--config-path=CONFIGPATH |Prostor, kjer so shranjene vse nastavitve za NVDA.|
|-m |--minimal |Brez zvokov, brez vmesnika, brez sporočila po zagonu ipd.|
|-s |--secure |Varni način: onemogoči Python konzolo, zmožnosti profilov, kot so ustvarjanje, izbris, preimenovanje profilov ipd., preverjanje posodobitve, nekaj izbirnikov v pogovornem oknu dobrodošlice  in v zvrsti splošnih nastavitev (npr. Uporabi NVDA med vpisom v Okna, Shrani konfiguracijo ob izhodu ipd.), kot tudi pregledovalnik dnevnika in zmožnosti beleženja (pogosto v uporabi na varnih namizjih). Pomnite, da bo ta ukaz onemogočil tudi  možnost shranitve nastavitev v sistemsko konfiguracijo in mapa kretenj ne bo shranjena na disk.|
|None |--disable-addons |Dodatki nimajo vpliva na NVDA. Isto, kot če v NVDA dodatkov ne bi bilo.|
|None |--debug-logging |Nastavi nivo beleženja na Razhroščevanje samo za naslednji zagon NVDA. Ta nastavitev bo preglasila katerikoli drug dan argument nivoja beleženja ( --loglevel, -l), ki definira nivo beleženja vključno z možnostjo brez beleženja.|
|None |--no-logging |Popolnoma onemogoči beleženje med uporabo NVDA. Ta nastavitev se lahko preglasi, če je nivo beleženja ( --loglevel, -l) definirano prek ukazne vrstice ali, če je vključeno beleženje razhroščevanja.|
|None |--no-sr-flag |Ne zamenjaj stanja globalne sistemske zastavice za bralnik zaslona.|
|None |--install |Namesti NVDA (na novo nameščeno kopijo NVDA tudi zažene).|
|None |--install-silent |Tiho namesti NVDA (na novo nameščene kopije NVDA ne zažene).|
|None |--enable-start-on-logon=True|False |Ob namestitvi omogoči možnost v NVDA [Uporabi NVDA med vpisom v Okna](#StartAtWindowsLogon)|
|None |--create-portable |Ustvari prenosljivo kopijo NVDA (to novo kopijo potem tudi nemudoma zažene). Obvezno je treba določiti parameter --portable-path|
|None |--create-portable-silent |Ustvari prenosljivo kopijo NVDA (te nove kopije potem ne zažene). Obvezno je treba določiti parameter --portable-path|
|None |--portable-path=PORTABLEPATH |Cilj, kjer se bo prenosljiva kopija ustvarila|

### Splošni Sistemski Parametri {#SystemWideParameters}

NVDA dovoli, da se nekatere vrednosti lahko nastavijo v sistemskem registru, ki določa vedenje NVDA na ravni splošnega sistema.
Te vrednosti se hranijo v registru pod enim izmed teh ključev:

* 32-bitni sistem: "HKEY_LOCAL_MACHINE\SOFTWARE\nvda"
* 64-bitni sistem: "HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\nvda"

Sledeče vrednosti se torej lahko nastavijo v tem registerskem ključu:

| Ime |Tip |Možne vrednosti |Opis|
|---|---|---|---|
|configInLocalAppData |DWORD |0 (privzeto) za izključitev, 1 to vključitev |Če je omogočeno, hrani NVDA uporabniško konfiguracijo kot lokalne programske podatke namesto the kot programske podatke, ki sledijo uporabniku|
|serviceDebug |DWORD |0 (privzeto) za izključitev, 1 za vključitev |Če je omogočeno, onemogoči varni način delovanja na windows varnih namizjih, tako dovoljujoč uporabo Python konzole in Pregledovalnika dnevnika. Zaradi nekaterih večjih varnostnih posledic, uporabo te možnosti strogo odsvetujemo|

## Druge Informacije {#FurtherInformation}

Če potrebujete več informacij ali pomoč pri uporabi NVDA, prosimo, obiščite spletno mesto NVDA na NVDA_URL.
Tu boste našli drugo dokumentacijo, tako kot tehnično podporo in vire, ki jih je prispevala skupnost.
Na spletnem mestu so tudi informacije in viri, ki se dotikajo razvoja za NVDA.

