// regexps from https://github.com/shockie/node-iniparser
const INI_SECTION = /^\s*\[\s*([^\]]*)\s*\]\s*$/
const INI_COMMENT = /^\s*;.*$/
const INI_PARAM   = /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/
const SEPARATOR   = /\r\n|\r|\n/

function parseGitmodules(data) {
  if (!data) return

  const submodules = {}
  const lines = data.split(SEPARATOR)
  let lastPath

  lines.forEach((line) => {
    let match
    if (INI_SECTION.test(line) ||
        INI_COMMENT.test(line) ||
        !(match = line.match(INI_PARAM))) {
      return
    }

    if (match[1] === 'path') lastPath = match[2]
    else if (match[1] === 'url') submodules[lastPath] = match[2]
  })

  return submodules
}
