import { h } from 'vue'
export const iconMap: any = {
  'app-404': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 1024 1024',
            version: '1.1',
            style: 'height:14px;width:14px',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M260.266667 789.333333c-21.333333 0-38.4-17.066667-38.4-38.4v-59.733333H38.4c-12.8 0-29.866667-8.533333-34.133333-21.333333-4.266667-17.066667-4.266667-29.866667 4.266666-42.666667l221.866667-294.4c8.533333-12.8 25.6-17.066667 42.666667-12.8 17.066667 4.266667 25.6 21.333333 25.6 38.4v256h34.133333c21.333333 0 38.4 17.066667 38.4 38.4s-17.066667 38.4-38.4 38.4H298.666667v59.733333c0 21.333333-17.066667 38.4-38.4 38.4z m-145.066667-179.2h106.666667V469.333333l-106.666667 140.8zM913.066667 742.4c-21.333333 0-38.4-17.066667-38.4-38.4v-59.733333h-183.466667c-12.8 0-29.866667-8.533333-34.133333-21.333334-8.533333-12.8-4.266667-29.866667 4.266666-38.4l221.866667-294.4c8.533333-12.8 25.6-17.066667 42.666667-12.8 17.066667 4.266667 25.6 21.333333 25.6 38.4v256h34.133333c21.333333 0 38.4 17.066667 38.4 38.4s-17.066667 38.4-38.4 38.4h-34.133333v59.733334c0 17.066667-17.066667 34.133333-38.4 34.133333zM768 567.466667h106.666667V426.666667L768 567.466667zM533.333333 597.333333c-46.933333 0-85.333333-25.6-119.466666-68.266666-29.866667-38.4-42.666667-93.866667-42.666667-145.066667 0-55.466667 17.066667-106.666667 42.666667-145.066667 29.866667-42.666667 72.533333-68.266667 119.466666-68.266666 46.933333 0 85.333333 25.6 119.466667 68.266666 29.866667 38.4 42.666667 93.866667 42.666667 145.066667 0 55.466667-17.066667 106.666667-42.666667 145.066667-34.133333 46.933333-76.8 68.266667-119.466667 68.266666z m0-362.666666c-55.466667 0-98.133333 68.266667-98.133333 149.333333s46.933333 149.333333 98.133333 149.333333c55.466667 0 98.133333-68.266667 98.133334-149.333333s-46.933333-149.333333-98.133334-149.333333z',
              fill: '#978CFF'
            }),
            h('path', {
              d: 'M354.133333 691.2a162.133333 21.333333 0 1 0 324.266667 0 162.133333 21.333333 0 1 0-324.266667 0Z',
              fill: '#E3E5FC'
            }),
            h('path', {
              d: 'M8.533333 832a162.133333 21.333333 0 1 0 324.266667 0 162.133333 21.333333 0 1 0-324.266667 0Z',
              fill: '#E3E5FC'
            }),
            h('path', {
              d: 'M661.333333 797.866667a162.133333 21.333333 0 1 0 324.266667 0 162.133333 21.333333 0 1 0-324.266667 0Z',
              fill: '#E3E5FC'
            })
          ]
        )
      ])
    }
  },

  'app-add-users': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M6.24984 5.41667C6.24984 6.7975 7.37067 7.91667 8.74984 7.91667C10.129 7.91667 11.2498 6.7975 11.2498 5.41667C11.2498 4.03583 10.129 2.91667 8.74984 2.91667C7.37067 2.91667 6.24984 4.03583 6.24984 5.41667ZM8.74984 1.25C11.0498 1.25 12.9165 3.11542 12.9165 5.41667C12.9165 7.71792 11.0498 9.58333 8.74984 9.58333C6.44984 9.58333 4.58317 7.71792 4.58317 5.41667C4.58317 3.11542 6.44984 1.25 8.74984 1.25ZM3.43734 15C3.37067 15.2663 3.33317 15.5454 3.33317 15.8333V16.6667H10.854C11.0841 16.6667 11.2706 16.8532 11.2706 17.0833V17.9167C11.2706 18.1468 11.0841 18.3333 10.854 18.3333H2.49984C2.0415 18.3333 1.6665 17.9604 1.6665 17.5V15.8333C1.6665 13.0721 3.904 10.8333 6.6665 10.8333H10.854C11.0841 10.8333 11.2706 11.0199 11.2706 11.25V12.0833C11.2706 12.3135 11.0841 12.5 10.854 12.5H6.6665C5.11234 12.5 3.80817 13.5625 3.43734 15ZM15.4165 11.6667C15.6466 11.6667 15.8332 11.8532 15.8332 12.0833V14.1667H17.9165C18.1466 14.1667 18.3332 14.3532 18.3332 14.5833V15.4167C18.3332 15.6468 18.1466 15.8333 17.9165 15.8333H15.8332V17.9167C15.8332 18.1468 15.6466 18.3333 15.4165 18.3333H14.5832C14.3531 18.3333 14.1665 18.1468 14.1665 17.9167V15.8333H12.0832C11.8531 15.8333 11.6665 15.6468 11.6665 15.4167V14.5833C11.6665 14.3532 11.8531 14.1667 12.0832 14.1667H14.1665V12.0833C14.1665 11.8532 14.3531 11.6667 14.5832 11.6667H15.4165Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },

  'app-exit': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M874.666667 855.744a19.093333 19.093333 0 0 1-19.136 18.922667H168.469333A19.2 19.2 0 0 1 149.333333 855.530667V168.469333A19.2 19.2 0 0 1 168.469333 149.333333h687.061334c10.581333 0 19.136 8.533333 19.136 18.922667V320h42.666666V168.256A61.717333 61.717333 0 0 0 855.530667 106.666667H168.469333A61.866667 61.866667 0 0 0 106.666667 168.469333v687.061334A61.866667 61.866667 0 0 0 168.469333 917.333333h687.061334A61.76 61.76 0 0 0 917.333333 855.744V704h-42.666666v151.744zM851.84 533.333333l-131.797333 131.754667a21.141333 21.141333 0 0 0 0.213333 29.973333 21.141333 21.141333 0 0 0 29.973333 0.192l165.589334-165.589333a20.821333 20.821333 0 0 0 6.122666-14.976 21.44 21.44 0 0 0-6.314666-14.997333l-168.533334-168.533334a21.141333 21.141333 0 0 0-29.952-0.213333 21.141333 21.141333 0 0 0 0.213334 29.973333L847.296 490.666667H469.333333v42.666666h382.506667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },

  'app-team': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M7.08317 4.16667C5.93317 4.16667 4.99984 5.09958 4.99984 6.25C4.99984 7.40042 5.93317 8.33333 7.08317 8.33333C8.23317 8.33333 9.1665 7.40042 9.1665 6.25C9.1665 5.09958 8.23317 4.16667 7.08317 4.16667ZM3.33317 6.25C3.33317 4.17875 5.01234 2.5 7.08317 2.5C9.154 2.5 10.8332 4.17875 10.8332 6.25C10.8332 8.32125 9.154 10 7.08317 10C5.01234 10 3.33317 8.32125 3.33317 6.25ZM4.86234 12.5C3.34567 12.5 2.08317 13.7488 2.08317 15.3333V16.6667H12.0832V15.3333C12.0832 13.7488 10.8207 12.5 9.304 12.5H4.86234ZM0.416504 15.3333C0.416504 12.8479 2.40817 10.8333 4.86234 10.8333H9.304C11.7582 10.8333 13.7498 12.8479 13.7498 15.3333V17.5833C13.7498 17.9975 13.4165 18.3333 13.0082 18.3333H1.15817C0.749837 18.3333 0.416504 17.9975 0.416504 17.5833V15.3333ZM19.029 17.5H15.304V17.1592V15.8333H17.9165V15.3333C17.9165 14.4983 17.2123 13.75 16.2498 13.75H15.1582C14.9998 13.1342 14.7165 12.5692 14.3373 12.0833H16.2498C18.0915 12.0833 19.5832 13.5383 19.5832 15.3333V16.9583C19.5832 17.2575 19.3332 17.5 19.029 17.5ZM13.7498 8.33333C13.7498 7.87292 14.1248 7.5 14.5832 7.5C15.0415 7.5 15.4165 7.87292 15.4165 8.33333C15.4165 8.79375 15.0415 9.16667 14.5832 9.16667C14.1248 9.16667 13.7498 8.79375 13.7498 8.33333ZM14.5832 5.83333C13.204 5.83333 12.0832 6.9525 12.0832 8.33333C12.0832 9.71417 13.204 10.8333 14.5832 10.8333C15.9623 10.8333 17.0832 9.71417 17.0832 8.33333C17.0832 6.9525 15.9623 5.83333 14.5832 5.83333Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-team-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M7.08317 10C9.15424 10 10.8332 8.32107 10.8332 6.25C10.8332 4.17893 9.15424 2.5 7.08317 2.5C5.0121 2.5 3.33317 4.17893 3.33317 6.25C3.33317 8.32107 5.0121 10 7.08317 10Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M1.24984 18.3333C0.7896 18.3333 0.416504 17.9602 0.416504 17.5V15.8889C0.416504 13.0968 2.76035 10.8333 5.47333 10.8333H8.70065C11.4136 10.8333 13.7498 13.0968 13.7498 15.8889V17.5C13.7498 17.9602 13.3767 18.3333 12.9165 18.3333H1.24984Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M15.4165 17.5V17.2535C15.4165 15.3267 15.4165 13.3333 13.7498 12.0833C13.8196 12.0773 13.9366 12.0794 14.0491 12.0814C14.1036 12.0824 14.157 12.0833 14.2034 12.0833H15.8332C17.8679 12.0833 19.5832 13.3643 19.5832 15.4583V16.875C19.5832 17.2202 19.3033 17.5 18.9582 17.5H15.4165Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M14.5832 10.8333C15.9639 10.8333 17.0832 9.71405 17.0832 8.33333C17.0832 6.95262 15.9639 5.83333 14.5832 5.83333C13.2025 5.83333 12.0832 6.95262 12.0832 8.33333C12.0832 9.71405 13.2025 10.8333 14.5832 10.8333Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-template': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M0.833496 6.36987C0.833496 6.04308 1.0245 5.74646 1.32199 5.61123L9.65533 1.82335C9.87443 1.72376 10.1259 1.72376 10.345 1.82335L18.6783 5.61123C18.9758 5.74646 19.1668 6.04308 19.1668 6.36987V14.4849C19.1668 14.8006 18.9885 15.0891 18.7062 15.2303L10.3728 19.3969C10.1382 19.5142 9.86209 19.5142 9.62748 19.3969L1.29415 15.2303C1.01183 15.0891 0.833496 14.8006 0.833496 14.4849V6.36987ZM16.015 6.2314L10.0002 3.49737L3.95283 6.24616L9.9668 8.83681L16.015 6.2314ZM10.8335 10.2782V17.3032L17.5002 13.9699V7.40638L10.8335 10.2782ZM2.50016 7.43512V13.9699L9.16683 17.3032V10.3069L2.50016 7.43512Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-template-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M0.833496 7.40037C0.833496 7.04018 1.20284 6.79815 1.53309 6.94194L8.77383 10.0945C8.95625 10.1739 9.07423 10.3539 9.07423 10.5529V18.339C9.07423 18.7151 8.67454 18.9566 8.34159 18.7816L1.1439 14.9982C1.05114 14.9474 0.973682 14.8737 0.919239 14.7847C0.864795 14.6956 0.835262 14.5943 0.833578 14.4907L0.833496 14.4814V7.40037ZM18.4646 6.9322C18.7952 6.78604 19.1668 7.02807 19.1668 7.38949V14.4814C19.1668 14.5866 19.1381 14.6899 19.0835 14.7807C19.029 14.8715 18.9506 14.9466 18.8564 14.9982L11.6587 18.7816C11.3258 18.9566 10.9261 18.7151 10.9261 18.339L10.9261 10.5912C10.9261 10.3932 11.0429 10.2139 11.2239 10.1339L18.4646 6.9322ZM9.70006 1.74337C9.79165 1.69312 9.89502 1.66672 10.0002 1.66672C10.1053 1.66672 10.2087 1.69312 10.3003 1.74337L17.1982 4.80724C17.5964 4.9841 17.5936 5.55021 17.1937 5.72313L10.1986 8.74754C10.072 8.80229 9.92836 8.80229 9.80173 8.74754L2.80663 5.72313C2.4067 5.55021 2.40389 4.9841 2.80209 4.80724L9.70006 1.74337Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-setting': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M3.60734 16.4448L3.34807 16.1624C2.44036 15.1737 1.75935 13.9944 1.36011 12.7066L1.24756 12.3435L2.95427 10.0001L1.24756 7.65668L1.36011 7.29361C1.75935 6.00574 2.44036 4.82649 3.34807 3.83779L3.60734 3.55539L6.47552 3.86889L7.64049 1.21319L8.01405 1.12909C8.66134 0.983366 9.32633 0.90918 10.0004 0.90918C10.6744 0.90918 11.3394 0.983366 11.9867 1.12909L12.3603 1.21319L13.5252 3.86889L16.3934 3.55539L16.6527 3.83779C17.5604 4.82649 18.2414 6.00574 18.6406 7.29361L18.7532 7.65668L17.0465 10.0001L18.7532 12.3435L18.6406 12.7066C18.2414 13.9944 17.5604 15.1737 16.6527 16.1624L16.3934 16.4448L13.5252 16.1313L12.3603 18.787L11.9867 18.8711C11.3394 19.0168 10.6744 19.091 10.0004 19.091C9.32633 19.091 8.66134 19.0168 8.01405 18.8711L7.64049 18.787L6.47552 16.1313L3.60734 16.4448ZM6.51159 14.6031C7.05002 14.5443 7.56436 14.8417 7.78194 15.3377L8.71565 17.4662C9.13677 17.5389 9.56603 17.5758 10.0004 17.5758C10.4347 17.5758 10.864 17.5389 11.2851 17.4662L12.2188 15.3377C12.4364 14.8417 12.9507 14.5443 13.4892 14.6031L15.7844 14.854C16.3387 14.1868 16.7757 13.4286 17.0741 12.6116L15.7038 10.7301C15.3869 10.295 15.3869 9.70511 15.7038 9.26999L17.0741 7.38847C16.7757 6.57146 16.3387 5.81331 15.7844 5.14609L13.4892 5.39696C12.9507 5.45581 12.4364 5.1584 12.2188 4.66238L11.2851 2.53389C10.864 2.46117 10.4347 2.42429 10.0004 2.42429C9.56603 2.42429 9.13677 2.46117 8.71565 2.53389L7.78194 4.66238C7.56436 5.1584 7.05002 5.45581 6.51159 5.39696L4.21641 5.14609C3.66208 5.81331 3.22502 6.57146 2.92666 7.38847L4.29697 9.26999C4.61387 9.70511 4.61387 10.295 4.29697 10.7301L2.92666 12.6116C3.22502 13.4286 3.66208 14.1868 4.21641 14.854L6.51159 14.6031ZM10.0004 13.788C7.91555 13.788 6.22693 12.0913 6.22693 10.0001C6.22693 7.9089 7.91555 6.2122 10.0004 6.2122C12.0852 6.2122 13.7738 7.9089 13.7738 10.0001C13.7738 12.0913 12.0852 13.788 10.0004 13.788ZM10.0004 12.2729C11.2468 12.2729 12.2587 11.2561 12.2587 10.0001C12.2587 8.74413 11.2468 7.72741 10.0004 7.72741C8.75397 7.72741 7.74208 8.74413 7.74208 10.0001C7.74208 11.2561 8.75397 12.2729 10.0004 12.2729Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-setting-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M3.26425 16.2151C2.35478 15.2292 1.65887 14.0432 1.25 12.7305L2.70785 10.7384C3.02952 10.2988 3.02952 9.70154 2.70785 9.26197L1.25 7.26979C1.65887 5.95714 2.35478 4.77112 3.26425 3.78522L5.71416 4.05172C6.25589 4.11065 6.77338 3.81185 6.99316 3.31321L7.98848 1.05505C8.63579 0.910018 9.30896 0.833496 10 0.833496C10.691 0.833496 11.3642 0.910018 12.0115 1.05505L13.0068 3.31321C13.2266 3.81185 13.7441 4.11065 14.2858 4.05172L16.7357 3.78522C17.6452 4.77112 18.3411 5.95714 18.75 7.26979L17.2921 9.26197C16.9705 9.70154 16.9705 10.2988 17.2921 10.7384L18.75 12.7305C18.3411 14.0432 17.6452 15.2292 16.7357 16.2151L14.2858 15.9486C13.7441 15.8897 13.2266 16.1885 13.0068 16.6871L12.0115 18.9453C11.3642 19.0903 10.691 19.1668 10 19.1668C9.30896 19.1668 8.63579 19.0903 7.98848 18.9453L6.99316 16.6871C6.77338 16.1885 6.25589 15.8897 5.71416 15.9486L3.26425 16.2151ZM10 13.3335C11.8409 13.3335 13.3333 11.8411 13.3333 10.0002C13.3333 8.15921 11.8409 6.66683 10 6.66683C8.15905 6.66683 6.66667 8.15921 6.66667 10.0002C6.66667 11.8411 8.15905 13.3335 10 13.3335Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-document': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M13.3333 2.50016H4.16667V17.5002H15.8333V5.01641H13.75C13.6395 5.01641 13.5335 4.97251 13.4554 4.89437C13.3772 4.81623 13.3333 4.71025 13.3333 4.59975V2.50016ZM3.33333 0.833496H14.2379C14.3474 0.833465 14.4558 0.855013 14.557 0.896908C14.6582 0.938804 14.7501 1.00023 14.8275 1.07766L17.2563 3.50725C17.4124 3.66356 17.5001 3.87548 17.5 4.09641V18.3335C17.5 18.5545 17.4122 18.7665 17.2559 18.9228C17.0996 19.079 16.8877 19.1668 16.6667 19.1668H3.33333C3.11232 19.1668 2.90036 19.079 2.74408 18.9228C2.5878 18.7665 2.5 18.5545 2.5 18.3335V1.66683C2.5 1.44582 2.5878 1.23385 2.74408 1.07757C2.90036 0.921293 3.11232 0.833496 3.33333 0.833496ZM6.66667 8.3335H13.3333C13.4438 8.3335 13.5498 8.3774 13.628 8.45554C13.7061 8.53368 13.75 8.63966 13.75 8.75016V9.5835C13.75 9.694 13.7061 9.79998 13.628 9.87812C13.5498 9.95626 13.4438 10.0002 13.3333 10.0002H6.66667C6.55616 10.0002 6.45018 9.95626 6.37204 9.87812C6.2939 9.79998 6.25 9.694 6.25 9.5835V8.75016C6.25 8.63966 6.2939 8.53368 6.37204 8.45554C6.45018 8.3774 6.55616 8.3335 6.66667 8.3335ZM6.66667 12.5002H10.4167C10.4714 12.5002 10.5256 12.5109 10.5761 12.5319C10.6267 12.5528 10.6726 12.5835 10.7113 12.6222C10.75 12.6609 10.7807 12.7068 10.8016 12.7574C10.8226 12.8079 10.8333 12.8621 10.8333 12.9168V13.7502C10.8333 13.8049 10.8226 13.8591 10.8016 13.9096C10.7807 13.9602 10.75 14.0061 10.7113 14.0448C10.6726 14.0835 10.6267 14.1142 10.5761 14.1351C10.5256 14.1561 10.4714 14.1668 10.4167 14.1668H6.66667C6.55616 14.1668 6.45018 14.1229 6.37204 14.0448C6.2939 13.9667 6.25 13.8607 6.25 13.7502V12.9168C6.25 12.8063 6.2939 12.7003 6.37204 12.6222C6.45018 12.5441 6.55616 12.5002 6.66667 12.5002Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-document-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M3.3335 2.08333C3.3335 1.6231 3.70659 1.25 4.16683 1.25H12.3842C12.4959 1.25 12.603 1.29489 12.6813 1.37459L16.5473 5.30784C16.6239 5.38576 16.6668 5.49065 16.6668 5.59992V17.9167C16.6668 18.3769 16.2937 18.75 15.8335 18.75H4.16683C3.70659 18.75 3.3335 18.3769 3.3335 17.9167V2.08333Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M12.5 1.2666C12.568 1.28633 12.6306 1.32327 12.6812 1.37472L16.5472 5.30797C16.5788 5.34017 16.6047 5.37698 16.6242 5.4168H13.4459C12.9235 5.4168 12.5 4.99328 12.5 4.47085V1.2666Z',
              fill: '#2B5FD9'
            }),
            h('path', {
              d: 'M6.71305 7.72705C6.48293 7.72705 6.29639 7.9136 6.29639 8.14372V8.82554C6.29639 9.05565 6.48294 9.2422 6.71305 9.2422H13.2871C13.5172 9.2422 13.7038 9.05565 13.7038 8.82554V8.14372C13.7038 7.9136 13.5172 7.72705 13.2871 7.72705H6.71305Z',
              fill: 'white'
            }),
            h('path', {
              d: 'M6.71305 11.5149C6.48293 11.5149 6.29639 11.7015 6.29639 11.9316V12.6134C6.29639 12.8435 6.48294 13.0301 6.71305 13.0301H9.58342C9.81354 13.0301 10.0001 12.8435 10.0001 12.6134V11.9316C10.0001 11.7015 9.81354 11.5149 9.58342 11.5149H6.71305Z',
              fill: 'white'
            })
          ]
        )
      ])
    }
  },
  'app-view': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            viewBox: '0 0 16 12',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M6.9649 8.5176L10.8075 6.59629C10.9365 6.53178 11.0412 6.42717 11.1057 6.29815C11.2703 5.96883 11.1368 5.56838 10.8075 5.40372L6.9649 3.48241C6.87233 3.43612 6.77025 3.41203 6.66675 3.41203C6.29856 3.41203 6.00009 3.71051 6.00009 4.07869V7.92132C6.00009 8.02481 6.02418 8.12689 6.07047 8.21946C6.23513 8.54878 6.63558 8.68226 6.9649 8.5176Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M15.3334 0.75C15.3334 0.335786 15.0349 0 14.6667 0H1.33341C0.965225 0 0.666748 0.335786 0.666748 0.75V11.25C0.666748 11.6642 0.965225 12 1.33341 12H14.6667C15.0349 12 15.3334 11.6642 15.3334 11.25V0.75ZM2.00008 1.5H14.0001V10.5H2.00008V1.5Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-all-menu': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M2.91683 2.0835H8.3335C8.79373 2.0835 9.16683 2.45659 9.16683 2.91683V8.3335C9.16683 8.79373 8.79373 9.16683 8.3335 9.16683H2.91683C2.45659 9.16683 2.0835 8.79373 2.0835 8.3335V2.91683C2.0835 2.45659 2.45659 2.0835 2.91683 2.0835ZM3.75016 3.75016V7.50016H7.50016V3.75016H3.75016Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M2.91683 10.8335H8.3335C8.79373 10.8335 9.16683 11.2066 9.16683 11.6668V17.0835C9.16683 17.5437 8.79373 17.9168 8.3335 17.9168H2.91683C2.45659 17.9168 2.0835 17.5437 2.0835 17.0835V11.6668C2.0835 11.2066 2.45659 10.8335 2.91683 10.8335ZM3.75016 16.2502H7.50016V12.5002H3.75016V16.2502Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M11.6668 2.0835H17.0835C17.5437 2.0835 17.9168 2.45659 17.9168 2.91683V8.3335C17.9168 8.79373 17.5437 9.16683 17.0835 9.16683H11.6668C11.2066 9.16683 10.8335 8.79373 10.8335 8.3335V2.91683C10.8335 2.45659 11.2066 2.0835 11.6668 2.0835ZM12.5002 7.50016H16.2502V3.75016H12.5002V7.50016Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M11.6668 10.8335H17.0835C17.5437 10.8335 17.9168 11.2066 17.9168 11.6668V17.0835C17.9168 17.5437 17.5437 17.9168 17.0835 17.9168H11.6668C11.2066 17.9168 10.8335 17.5437 10.8335 17.0835V11.6668C10.8335 11.2066 11.2066 10.8335 11.6668 10.8335ZM12.5002 12.5002V16.2502H16.2502V12.5002H12.5002Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-all-menu-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M8.33317 1.6665H2.49984C2.0396 1.6665 1.6665 2.0396 1.6665 2.49984V8.33317C1.6665 8.79341 2.0396 9.1665 2.49984 9.1665H8.33317C8.79341 9.1665 9.1665 8.79341 9.1665 8.33317V2.49984C9.1665 2.0396 8.79341 1.6665 8.33317 1.6665Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M8.33317 10.8332H2.49984C2.0396 10.8332 1.6665 11.2063 1.6665 11.6665V17.4998C1.6665 17.9601 2.0396 18.3332 2.49984 18.3332H8.33317C8.79341 18.3332 9.1665 17.9601 9.1665 17.4998V11.6665C9.1665 11.2063 8.79341 10.8332 8.33317 10.8332Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M17.4998 1.6665H11.6665C11.2063 1.6665 10.8332 2.0396 10.8332 2.49984V8.33317C10.8332 8.79341 11.2063 9.1665 11.6665 9.1665H17.4998C17.9601 9.1665 18.3332 8.79341 18.3332 8.33317V2.49984C18.3332 2.0396 17.9601 1.6665 17.4998 1.6665Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M17.4508 10.8332H11.7155C11.2282 10.8332 10.8332 11.2282 10.8332 11.7155V17.4508C10.8332 17.9381 11.2282 18.3332 11.7155 18.3332H17.4508C17.9381 18.3332 18.3332 17.9381 18.3332 17.4508V11.7155C18.3332 11.2282 17.9381 10.8332 17.4508 10.8332Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-restore': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M3.33333 5.3335V13.3335H10V5.3335H3.33333ZM11.3333 4.66683V14.0742C11.3333 14.4015 11.0548 14.6668 10.7111 14.6668H2.62222C2.27858 14.6668 2 14.4015 2 14.0742V4.59276C2 4.26548 2.27858 4.00016 2.62222 4.00016H10.6667C11.0349 4.00016 11.3333 4.29864 11.3333 4.66683ZM13.8047 1.52876C13.9254 1.6494 14 1.81607 14 2.00016V10.3335C14 10.5176 13.8508 10.6668 13.6667 10.6668H13C12.8159 10.6668 12.6667 10.5176 12.6667 10.3335V2.66683H6.33333C6.14924 2.66683 6 2.51759 6 2.3335V1.66683C6 1.48273 6.14924 1.3335 6.33333 1.3335H13.3333C13.5174 1.3335 13.6841 1.40812 13.8047 1.52876Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-copy': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M213.333333 341.333333v512h426.666667V341.333333H213.333333z m512-42.666666v602.069333c0 20.949333-17.834667 37.930667-39.808 37.930667H167.808C145.834667 938.666667 128 921.685333 128 900.736V293.973333C128 272.981333 145.834667 256 167.808 256H682.666667a42.666667 42.666667 0 0 1 42.666666 42.666667z m158.165334-200.832A42.538667 42.538667 0 0 1 896 128v533.333333a21.333333 21.333333 0 0 1-21.333333 21.333334h-42.666667a21.333333 21.333333 0 0 1-21.333333-21.333334V170.666667H405.333333a21.333333 21.333333 0 0 1-21.333333-21.333334v-42.666666a21.333333 21.333333 0 0 1 21.333333-21.333334H853.333333c11.776 0 22.442667 4.778667 30.165334 12.501334z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-like': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M2.00518 14.6608H0.666612C0.666097 14.6874 0.666707 5.33317 0.666612 5.29087H2.00518C2.00004 5.33317 1.98014 14.6874 2.00518 14.6608ZM9.70096 5.28984H12.5717C14.5687 5.28984 15.0274 7.05264 14.5687 8.37353L12.5717 13.6308C12.4029 14.2423 11.8409 14.6665 11.1995 14.6665H3.33882C3.154 14.6665 3.00418 14.5167 3.00418 14.3319V5.62448C3.00418 5.43966 3.154 5.28984 3.33882 5.28984H4.02656C4.24449 5.28984 4.44877 5.18374 4.5741 5.00545L7.35254 1.05296C7.5406 0.753754 8.04824 0.52438 8.5893 0.770777C9.40089 1.14037 10.3724 1.94718 10.3724 3.28394C10.3724 3.78809 10.1486 4.45673 9.70096 5.28984ZM12.5717 6.62841H7.46215L8.52183 4.65626C8.87422 4.00045 9.03388 3.52351 9.03388 3.28394C9.03388 2.89556 8.9524 2.45627 8.25544 2.09612L5.26934 6.34402C5.14401 6.5223 4.93973 6.62841 4.72181 6.62841H4.34275V13.3279H11.1995C11.2411 13.3279 11.2734 13.3035 11.2813 13.2747L11.298 13.2142L13.3098 7.91815C13.5743 7.13902 13.3105 6.62841 12.5717 6.62841Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-like-color': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M2.00497 14.6608H2.00518C2.00511 14.6609 2.00504 14.6609 2.00497 14.6608H0.666612C0.666097 14.6874 0.666707 5.33317 0.666612 5.29087H2.00518C2.00006 5.33305 1.98026 14.6344 2.00497 14.6608Z',
              fill: '#FFC60A'
            }),
            h('path', {
              d: 'M12.5717 5.28984H9.70096C10.1486 4.45673 10.3724 3.78809 10.3724 3.28394C10.3724 1.94718 9.40089 1.14037 8.5893 0.770777C8.04824 0.52438 7.5406 0.753754 7.35254 1.05296L4.5741 5.00545C4.44877 5.18374 4.24449 5.28984 4.02656 5.28984H3.33882C3.154 5.28984 3.00418 5.43966 3.00418 5.62448V14.3319C3.00418 14.5167 3.154 14.6665 3.33882 14.6665H11.1995C11.8409 14.6665 12.4029 14.2423 12.5717 13.6308L14.5687 8.37353C15.0274 7.05264 14.5687 5.28984 12.5717 5.28984Z',
              fill: '#FFC60A'
            })
          ]
        )
      ])
    }
  },
  'app-oppose': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M2.00518 1.28008H0.666616C0.666616 1.33341 0.666504 10.6667 0.666616 10.65H2.00518C1.99984 10.6667 1.99984 1.33341 2.00518 1.28008ZM9.70097 10.6511H12.5717C14.5687 10.6511 15.0274 8.88828 14.5687 7.56739L12.5717 2.3101C12.4029 1.69862 11.8409 1.27441 11.1996 1.27441H3.33883C3.15401 1.27441 3.00418 1.42424 3.00418 1.60906V10.3164C3.00418 10.5013 3.15401 10.6511 3.33883 10.6511H4.02656C4.24449 10.6511 4.44877 10.7572 4.5741 10.9355L7.35254 14.888C7.5406 15.1872 8.04825 15.4165 8.58931 15.1701C9.40089 14.8005 10.3724 13.9937 10.3724 12.657C10.3724 12.1528 10.1486 11.4842 9.70097 10.6511ZM12.5717 9.31251H7.46216L8.52184 11.2847C8.87422 11.9405 9.03388 12.4174 9.03388 12.657C9.03388 13.0454 8.95241 13.4846 8.25545 13.8448L5.26935 9.5969C5.14402 9.41861 4.93974 9.31251 4.72181 9.31251H4.34275V2.61298H11.1996C11.2411 2.61298 11.2734 2.63737 11.2813 2.6662L11.298 2.72673L13.3098 8.02277C13.5743 8.8019 13.3105 9.31251 12.5717 9.31251Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-oppose-color': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M9.70106 10.7102H12.5718C14.5688 10.7102 15.0275 8.94736 14.5688 7.62647L12.5718 2.36918C12.403 1.7577 11.841 1.3335 11.1996 1.3335H3.33891C3.1541 1.3335 3.00427 1.48332 3.00427 1.66814V10.3755C3.00427 10.5603 3.1541 10.7102 3.33891 10.7102H4.02665C4.24458 10.7102 4.44886 10.8163 4.57419 10.9945L7.35263 14.947C7.54069 15.2462 8.04834 15.4756 8.58939 15.2292C9.40098 14.8596 10.3725 14.0528 10.3725 12.7161C10.3725 12.2119 10.1487 11.5433 9.70106 10.7102Z',
              fill: '#F54A45'
            }),
            h('path', {
              d: 'M2.00004 1.3335H0.661473C0.661473 1.3335 0.660982 10.7764 0.661473 10.7035H2.00001C1.99469 10.6868 1.9947 1.38674 2.00004 1.3335Z',
              fill: '#F54A45'
            })
          ]
        )
      ])
    }
  },
  'app-hit-test': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },

          [
            h('path', {
              d: 'M1.6665 9.99986C1.6665 5.3975 5.39748 1.66653 9.99984 1.66653H10.8332V3.3332H9.99984C6.31795 3.3332 3.33317 6.31797 3.33317 9.99986C3.33317 13.6818 6.31795 16.6665 9.99984 16.6665C13.6817 16.6665 16.6665 13.6818 16.6665 9.99986V9.16653H18.3332V9.99986C18.3332 14.6022 14.6022 18.3332 9.99984 18.3332C5.39748 18.3332 1.6665 14.6022 1.6665 9.99986Z',
              fill: 'currentColor',
              fillRule: 'evenodd',
              clipRule: 'evenodd'
            }),
            h('path', {
              d: 'M5.4165 9.99986C5.4165 7.46854 7.46852 5.41653 9.99984 5.41653H10.8332V7.0832H9.99984C8.38899 7.0832 7.08317 8.38902 7.08317 9.99986C7.08317 11.6107 8.38899 12.9165 9.99984 12.9165C11.6107 12.9165 12.9165 11.6107 12.9165 9.99986V9.16653H14.5832V9.99986C14.5832 12.5312 12.5312 14.5832 9.99984 14.5832C7.46852 14.5832 5.4165 12.5312 5.4165 9.99986Z',
              fill: 'currentColor',
              fillRule: 'evenodd',
              clipRule: 'evenodd'
            }),
            h('path', {
              d: 'M13.2138 6.78296C13.5394 7.10825 13.5397 7.63588 13.2144 7.96147L10.5894 10.5889C10.2641 10.9145 9.73644 10.9147 9.41085 10.5894C9.08527 10.2641 9.08502 9.73651 9.41031 9.41092L12.0353 6.7835C12.3606 6.45792 12.8882 6.45767 13.2138 6.78296Z',
              fill: 'currentColor',
              fillRule: 'evenodd',
              clipRule: 'evenodd'
            }),
            h('path', {
              d: 'M15.1942 1.72962C15.506 1.8584 15.7095 2.16249 15.7095 2.49986V4.29161H17.4998C17.8365 4.29161 18.1401 4.49423 18.2693 4.80516C18.3985 5.11608 18.3279 5.47421 18.0904 5.71284L15.8508 7.96276C15.6944 8.11987 15.4819 8.2082 15.2602 8.2082H12.6248C12.1645 8.2082 11.7914 7.8351 11.7914 7.37486V4.76086C11.7914 4.54046 11.8787 4.32904 12.0342 4.17287L14.2856 1.91186C14.5237 1.6728 14.8824 1.60085 15.1942 1.72962ZM13.4581 5.105V6.54153H14.9139L15.4945 5.95828H14.8761C14.4159 5.95828 14.0428 5.58518 14.0428 5.12495V4.51779L13.4581 5.105Z',
              fill: 'currentColor',
              fillRule: 'evenodd',
              clipRule: 'evenodd'
            })
          ]
        )
      ])
    }
  },
  'app-warning': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 234.666667A53.333333 53.333333 0 1 1 512 341.333333a53.333333 53.333333 0 0 1 0-106.666666zM522.666667 384h-64a21.333333 21.333333 0 0 0-21.333334 21.333333v42.666667a21.333333 21.333333 0 0 0 21.333334 21.333333h21.333333v213.333334H426.666667a21.333333 21.333333 0 0 0-21.333334 21.333333v42.666667a21.333333 21.333333 0 0 0 21.333334 21.333333h192a21.333333 21.333333 0 0 0 21.333333-21.333333v-42.666667a21.333333 21.333333 0 0 0-21.333333-21.333333h-53.333334v-256a42.666667 42.666667 0 0 0-42.666666-42.666667z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M512 981.333333C252.8 981.333333 42.666667 771.2 42.666667 512S252.8 42.666667 512 42.666667s469.333333 210.133333 469.333333 469.333333-210.133333 469.333333-469.333333 469.333333z m0-85.333333a384 384 0 1 0 0-768 384 384 0 0 0 0 768z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-warning-colorful': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M42.666667 512c0 259.2 210.133333 469.333333 469.333333 469.333333s469.333333-210.133333 469.333333-469.333333S771.2 42.666667 512 42.666667 42.666667 252.8 42.666667 512z m469.333333-277.333333A53.333333 53.333333 0 1 1 512 341.333333a53.333333 53.333333 0 0 1 0-106.666666zM458.666667 384h64a42.666667 42.666667 0 0 1 42.666666 42.666667v256h53.333334a21.333333 21.333333 0 0 1 21.333333 21.333333v42.666667a21.333333 21.333333 0 0 1-21.333333 21.333333H426.666667a21.333333 21.333333 0 0 1-21.333334-21.333333v-42.666667a21.333333 21.333333 0 0 1 21.333334-21.333333h53.333333v-213.333334h-21.333333a21.333333 21.333333 0 0 1-21.333334-21.333333v-42.666667a21.333333 21.333333 0 0 1 21.333334-21.333333z',
              fill: '#3370FF'
            })
          ]
        )
      ])
    }
  },
  'app-operation': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M11.0002 11.3333H14.2395C14.3881 11.3333 14.442 11.3487 14.4963 11.3778C14.5506 11.4068 14.5933 11.4495 14.6223 11.5038C14.6514 11.5581 14.6668 11.612 14.6668 11.7606V12.2393C14.6668 12.3879 14.6514 12.4417 14.6223 12.4961C14.5933 12.5504 14.5506 12.593 14.4963 12.6221C14.442 12.6511 14.3881 12.6666 14.2395 12.6666H11.0002V14.2393C11.0002 14.3879 10.9847 14.4417 10.9556 14.4961C10.9266 14.5504 10.884 14.593 10.8296 14.6221C10.7753 14.6511 10.7214 14.6666 10.5728 14.6666H10.0941C9.94556 14.6666 9.89168 14.6511 9.83736 14.6221C9.78304 14.593 9.7404 14.5504 9.71135 14.4961C9.6823 14.4417 9.66683 14.3879 9.66683 14.2393V12.6666H1.76081C1.61222 12.6666 1.55834 12.6511 1.50402 12.6221C1.4497 12.593 1.40707 12.5504 1.37802 12.4961C1.34897 12.4417 1.3335 12.3879 1.3335 12.2393V11.7606C1.3335 11.612 1.34897 11.5581 1.37802 11.5038C1.40707 11.4495 1.4497 11.4068 1.50402 11.3778C1.55834 11.3487 1.61222 11.3333 1.76081 11.3333H9.66683V9.76057C9.66683 9.61198 9.6823 9.5581 9.71135 9.50378C9.7404 9.44946 9.78304 9.40683 9.83736 9.37778C9.89168 9.34872 9.94556 9.33325 10.0941 9.33325H10.5728C10.7214 9.33325 10.7753 9.34872 10.8296 9.37778C10.884 9.40683 10.9266 9.44946 10.9556 9.50378C10.9847 9.5581 11.0002 9.61198 11.0002 9.76057V11.3333ZM5.00016 3.33325V1.76057C5.00016 1.61198 5.01563 1.5581 5.04469 1.50378C5.07374 1.44946 5.11637 1.40683 5.17069 1.37777C5.22501 1.34872 5.27889 1.33325 5.42748 1.33325H5.90618C6.05477 1.33325 6.10865 1.34872 6.16297 1.37777C6.21729 1.40683 6.25992 1.44946 6.28897 1.50378C6.31803 1.5581 6.3335 1.61198 6.3335 1.76057V3.33325H14.2395C14.3881 3.33325 14.442 3.34872 14.4963 3.37777C14.5506 3.40683 14.5933 3.44946 14.6223 3.50378C14.6514 3.5581 14.6668 3.61198 14.6668 3.76057V4.23927C14.6668 4.38786 14.6514 4.44174 14.6223 4.49606C14.5933 4.55038 14.5506 4.59301 14.4963 4.62206C14.442 4.65111 14.3881 4.66659 14.2395 4.66659H6.3335V6.23927C6.3335 6.38786 6.31803 6.44174 6.28897 6.49606C6.25992 6.55038 6.21729 6.59301 6.16297 6.62206C6.10865 6.65111 6.05477 6.66659 5.90618 6.66659H5.42748C5.27889 6.66659 5.22501 6.65111 5.17069 6.62206C5.11637 6.59301 5.07374 6.55038 5.04469 6.49606C5.01563 6.44174 5.00016 6.38786 5.00016 6.23927V4.66659H1.76081C1.61222 4.66659 1.55834 4.65111 1.50402 4.62206C1.4497 4.59301 1.40707 4.55038 1.37802 4.49606C1.34897 4.44174 1.3335 4.38786 1.3335 4.23927V3.76057C1.3335 3.61198 1.34897 3.5581 1.37802 3.50378C1.40707 3.44946 1.4497 3.40683 1.50402 3.37777C1.55834 3.34872 1.61222 3.33325 1.76081 3.33325H5.00016Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-reading': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M768 128H256a85.333333 85.333333 0 0 0-85.333333 85.333333v426.666667h512V64h85.333333v640a21.333333 21.333333 0 0 1-21.333333 21.333333H256a85.333333 85.333333 0 0 0-0.128 170.666667H832a21.333333 21.333333 0 0 0 21.333333-21.333333V341.333333h85.333334v597.333334a42.666667 42.666667 0 0 1-42.666667 42.666666H256c-94.293333 0-170.666667-76.16-170.666667-170.410666V213.248C85.333333 119.04 161.706667 42.666667 256 42.666667h469.333333a42.666667 42.666667 0 0 1 42.666667 42.666666v42.666667z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M277.333333 768a21.333333 21.333333 0 0 0-21.333333 21.333333v42.666667a21.333333 21.333333 0 0 0 21.333333 21.333333h469.333334a21.333333 21.333333 0 0 0 21.333333-21.333333v-42.666667a21.333333 21.333333 0 0 0-21.333333-21.333333h-469.333334z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-github': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M511.6 76.3C264.3 76.2 64 276.4 64 523.5 64 718.9 189.3 885 363.8 946c23.5 5.9 19.9-10.8 19.9-22.2v-77.5c-135.7 15.9-141.2-73.9-150.3-88.9C215 726 171.5 718 184.5 703c30.9-15.9 62.4 4 98.9 57.9 26.4 39.1 77.9 32.5 104 26 5.7-23.5 17.9-44.5 34.7-60.8-140.6-25.2-199.2-111-199.2-213 0-49.5 16.3-95 48.3-131.7-20.4-60.5 1.9-112.3 4.9-120 58.1-5.2 118.5 41.6 123.2 45.3 33-8.9 70.7-13.6 112.9-13.6 42.4 0 80.2 4.9 113.5 13.9 11.3-8.6 67.3-48.8 121.3-43.9 2.9 7.7 24.7 58.3 5.5 118 32.4 36.8 48.9 82.7 48.9 132.3 0 102.2-59 188.1-200 212.9 23.5 23.2 38.1 55.4 38.1 91v112.5c0.8 9 0 17.9 15 17.9 177.1-59.7 304.6-227 304.6-424.1 0-247.2-200.4-447.3-447.5-447.3z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-help': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 896a384 384 0 1 0 0-768 384 384 0 0 0 0 768z m0 85.333333C252.8 981.333333 42.666667 771.2 42.666667 512S252.8 42.666667 512 42.666667s469.333333 210.133333 469.333333 469.333333-210.133333 469.333333-469.333333 469.333333z m-21.333333-298.666666h42.666666a21.333333 21.333333 0 0 1 21.333334 21.333333v42.666667a21.333333 21.333333 0 0 1-21.333334 21.333333h-42.666666a21.333333 21.333333 0 0 1-21.333334-21.333333v-42.666667a21.333333 21.333333 0 0 1 21.333334-21.333333zM343.466667 396.032c0.554667-4.778667 1.109333-8.746667 1.664-11.946667 8.32-46.293333 29.397333-80.341333 63.189333-102.144 26.453333-17.28 59.008-25.941333 97.621333-25.941333 50.730667 0 92.842667 12.288 126.378667 36.864 33.578667 24.533333 50.346667 60.928 50.346667 109.141333 0 29.568-7.253333 54.485333-21.888 74.752-8.533333 12.245333-24.917333 27.946667-49.152 47.061334l-23.893334 18.773333c-13.013333 10.24-21.632 22.186667-25.898666 35.84-1.152 3.712-2.176 10.624-3.072 20.736a21.333333 21.333333 0 0 1-21.248 19.498667h-47.786667a21.333333 21.333333 0 0 1-21.248-23.296c2.773333-29.696 5.717333-48.469333 8.832-56.362667 5.845333-14.677333 20.906667-31.573333 45.141333-50.688l24.533334-19.413333c8.106667-6.144 49.749333-35.456 49.749333-61.44 0-25.941333-4.522667-35.498667-17.578667-49.749334-13.013333-14.208-42.368-18.773333-68.864-18.773333-26.026667 0-48.256 6.869333-59.136 24.405333-5.034667 8.106667-9.173333 16.768-12.117333 25.6a89.472 89.472 0 0 0-3.114667 13.098667 21.333333 21.333333 0 0 1-21.034666 17.706667H364.672a21.333333 21.333333 0 0 1-21.205333-23.722667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-pricing': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M723.584 128c24.618667 0 48.213333 10.112 64.768 28.074667l170.965333 185.472c28.288 30.72 29.226667 76.373333 4.48 106.837333l-403.797333 457.685333a64 64 0 0 1-96 0l-397.824-450.986666a82.090667 82.090667 0 0 1-1.493333-113.493334l170.965333-185.514666C252.16 138.154667 275.754667 128 300.373333 128h423.168z m0 85.333333H300.373333c-1.024 0-1.834667 0.341333-2.048 0.597334L129.152 397.482667 512 831.488l382.848-433.92-169.216-183.637333a2.304 2.304 0 0 0-1.109333-0.512L723.584 213.333333z m-12.586667 202.794667a42.666667 42.666667 0 0 1 3.541334 60.202667l-170.666667 192a42.666667 42.666667 0 0 1-63.744 0l-170.666667-192a42.666667 42.666667 0 1 1 63.744-56.661334L512 575.744l138.794667-156.074667a42.666667 42.666667 0 0 1 60.202666-3.541333z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-translate': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            xmlns: 'http://www.w3.org/2000/svg',
            viewBox: '0 0 20 20',
            fill: 'currentColor'
          },
          [
            h('path', {
              d: 'M7.75 2.75a.75.75 0 0 0-1.5 0v1.258a32.987 32.987 0 0 0-3.599.278.75.75 0 1 0 .198 1.487A31.545 31.545 0 0 1 8.7 5.545 19.381 19.381 0 0 1 7 9.56a19.418 19.418 0 0 1-1.002-2.05.75.75 0 0 0-1.384.577 20.935 20.935 0 0 0 1.492 2.91 19.613 19.613 0 0 1-3.828 4.154.75.75 0 1 0 .945 1.164A21.116 21.116 0 0 0 7 12.331c.095.132.192.262.29.391a.75.75 0 0 0 1.194-.91c-.204-.266-.4-.538-.59-.815a20.888 20.888 0 0 0 2.333-5.332c.31.031.618.068.924.108a.75.75 0 0 0 .198-1.487 32.832 32.832 0 0 0-3.599-.278V2.75Z'
            }),
            h('path', {
              'fill-rule': 'evenodd',
              d: 'M13 8a.75.75 0 0 1 .671.415l4.25 8.5a.75.75 0 1 1-1.342.67L15.787 16h-5.573l-.793 1.585a.75.75 0 1 1-1.342-.67l4.25-8.5A.75.75 0 0 1 13 8Zm2.037 6.5L13 10.427 10.964 14.5h4.073Z',
              'clip-rule': 'evenodd'
            })
          ]
        )
      ])
    }
  },
  'app-user': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 24 24',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M15 13H9C6.23858 13 3 14.9314 3 18.4V21.1C3 21.597 3.44772 22 4 22H20C20.5523 22 21 21.597 21 21.1V18.4C21 14.9285 17.7614 13 15 13Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M7 6.99997C7 9.76139 9.23858 12 12 12C14.7614 12 17 9.76139 17 6.99997C17 4.23855 14.7614 1.99997 12 1.99997C9.23858 1.99997 7 4.23855 7 6.99997Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-question': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 24 24',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M12.7071 22.2009L17 18.5111H21.5C22.0523 18.5111 22.5 18.0539 22.5 17.4899V2.52112C22.5 1.95715 22.0523 1.49997 21.5 1.49997H2C1.44772 1.49997 1 1.95715 1 2.52112V17.4899C1 18.0539 1.44772 18.5111 2 18.5111H7L11.2929 22.2009C11.6834 22.5997 12.3166 22.5997 12.7071 22.2009ZM6.5 8.49997H7.5C8.05228 8.49997 8.5 8.94768 8.5 9.49997V10.5C8.5 11.0523 8.05228 11.5 7.5 11.5H6.5C5.94772 11.5 5.5 11.0523 5.5 10.5V9.49997C5.5 8.94768 5.94772 8.49997 6.5 8.49997ZM10.5 9.49997C10.5 8.94768 10.9477 8.49997 11.5 8.49997H12.5C13.0523 8.49997 13.5 8.94768 13.5 9.49997V10.5C13.5 11.0523 13.0523 11.5 12.5 11.5H11.5C10.9477 11.5 10.5 11.0523 10.5 10.5V9.49997ZM16.5 8.49997H17.5C18.0523 8.49997 18.5 8.94768 18.5 9.49997V10.5C18.5 11.0523 18.0523 11.5 17.5 11.5H16.5C15.9477 11.5 15.5 11.0523 15.5 10.5V9.49997C15.5 8.94768 15.9477 8.49997 16.5 8.49997Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-tokens': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 24 24',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M15.6 2.39996C12.288 2.39996 9.60002 5.08796 9.60002 8.39996C9.60002 9.11996 9.74402 9.79196 9.97202 10.428L2.47325 17.9267C2.42636 17.9736 2.40002 18.0372 2.40002 18.1035V21.1C2.40002 21.3761 2.62388 21.6 2.90002 21.6H4.30002C4.57617 21.6 4.80002 21.3761 4.80002 21.1V20.4H6.70003C6.97617 20.4 7.20002 20.1761 7.20002 19.9V18H8.40002L10.8 15.6H12L13.572 14.028C14.208 14.256 14.88 14.4 15.6 14.4C18.912 14.4 21.6 11.712 21.6 8.39996C21.6 5.08796 18.912 2.39996 15.6 2.39996ZM17.4 8.39996C16.404 8.39996 15.6 7.59596 15.6 6.59996C15.6 5.60396 16.404 4.79996 17.4 4.79996C18.396 4.79996 19.2 5.60396 19.2 6.59996C19.2 7.59596 18.396 8.39996 17.4 8.39996Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-user-stars': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 24 24',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M12 23C18.0751 23 23 18.0751 23 12C23 5.92484 18.0751 0.999969 12 0.999969C5.92487 0.999969 1 5.92484 1 12C1 18.0751 5.92487 23 12 23ZM8.5 10.5C7.67157 10.5 7 9.8284 7 8.99997C7 8.17154 7.67157 7.49997 8.5 7.49997C9.32843 7.49997 10 8.17154 10 8.99997C10 9.8284 9.32843 10.5 8.5 10.5ZM17 8.99997C17 9.8284 16.3284 10.5 15.5 10.5C14.6716 10.5 14 9.8284 14 8.99997C14 8.17154 14.6716 7.49997 15.5 7.49997C16.3284 7.49997 17 8.17154 17 8.99997ZM16.9779 13.4994C16.7521 16.0264 14.8169 18 12 18C9.18312 18 7.24789 16.0264 7.02213 13.4994C6.99756 13.2244 7.22386 13 7.5 13H16.5C16.7761 13 17.0024 13.2244 16.9779 13.4994Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-problems': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 896a384 384 0 1 0 0-768 384 384 0 0 0 0 768z m0 85.333333C252.8 981.333333 42.666667 771.2 42.666667 512S252.8 42.666667 512 42.666667s469.333333 210.133333 469.333333 469.333333-210.133333 469.333333-469.333333 469.333333z m-21.333333-298.666666h42.666666a21.333333 21.333333 0 0 1 21.333334 21.333333v42.666667a21.333333 21.333333 0 0 1-21.333334 21.333333h-42.666666a21.333333 21.333333 0 0 1-21.333334-21.333333v-42.666667a21.333333 21.333333 0 0 1 21.333334-21.333333zM343.466667 396.032c0.554667-4.778667 1.109333-8.746667 1.664-11.946667 8.32-46.293333 29.397333-80.341333 63.189333-102.144 26.453333-17.28 59.008-25.941333 97.621333-25.941333 50.730667 0 92.842667 12.288 126.378667 36.864 33.578667 24.533333 50.346667 60.928 50.346667 109.141333 0 29.568-7.253333 54.485333-21.888 74.752-8.533333 12.245333-24.917333 27.946667-49.152 47.061334l-23.893334 18.773333c-13.013333 10.24-21.632 22.186667-25.898666 35.84-1.152 3.712-2.176 10.624-3.072 20.736a21.333333 21.333333 0 0 1-21.248 19.498667h-47.786667a21.333333 21.333333 0 0 1-21.248-23.296c2.773333-29.696 5.717333-48.469333 8.832-56.362667 5.845333-14.677333 20.906667-31.573333 45.141333-50.688l24.533334-19.413333c8.106667-6.144 49.749333-35.456 49.749333-61.44 0-25.941333-4.522667-35.498667-17.578667-49.749334-13.013333-14.208-42.368-18.773333-68.864-18.773333-26.026667 0-48.256 6.869333-59.136 24.405333-5.034667 8.106667-9.173333 16.768-12.117333 25.6a89.472 89.472 0 0 0-3.114667 13.098667 21.333333 21.333333 0 0 1-21.034666 17.706667H364.672a21.333333 21.333333 0 0 1-21.205333-23.722667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-quxiaoguanlian': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M544 298.688a32 32 0 0 1 32-32h320c41.216 0 74.688 33.408 74.688 74.624V640c0 41.216-33.472 74.688-74.688 74.688h-85.312a32 32 0 1 1 0-64H896a10.688 10.688 0 0 0 10.688-10.688V341.312A10.688 10.688 0 0 0 896 330.688H576a32 32 0 0 1-32-32zM53.312 341.312c0-41.216 33.472-74.624 74.688-74.624h106.688a32 32 0 1 1 0 64H128a10.688 10.688 0 0 0-10.688 10.624V640c0 5.888 4.8 10.688 10.688 10.688h320a32 32 0 1 1 0 64H128A74.688 74.688 0 0 1 53.312 640V341.312zM282.432 100.416a32 32 0 0 1 43.84 11.392l426.624 725.312a32 32 0 0 1-55.168 32.448L271.104 144.256a32 32 0 0 1 11.328-43.84zM650.688 490.688a32 32 0 0 1 32-32H768a32 32 0 1 1 0 64h-85.312a32 32 0 0 1-32-32zM224 490.688a32 32 0 0 1 32-32h85.312a32 32 0 1 1 0 64H256a32 32 0 0 1-32-32z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-migrate': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M896.128 113.792a42.666667 42.666667 0 0 1 42.24 36.864l0.426667 5.802667v711.509333a42.666667 42.666667 0 0 1-36.906667 42.24l-5.76 0.426667h-263.082667a21.333333 21.333333 0 0 1-20.906666-17.066667l-0.426667-4.266667v-42.666666a21.333333 21.333333 0 0 1 17.066667-20.906667l4.266666-0.426667h220.416V199.125333H281.941333l0.042667 192.170667a21.333333 21.333333 0 0 1-21.333333 21.333333h-42.666667a21.333333 21.333333 0 0 1-21.333333-21.333333V135.125333a21.333333 21.333333 0 0 1 17.066666-20.906666l4.266667-0.426667h678.144zM424.96 485.973333c6.272 0 12.373333 2.218667 17.152 6.272l178.858667 151.338667a26.538667 26.538667 0 0 1 0 40.533333l-178.858667 151.381334a26.538667 26.538667 0 0 1-43.690667-20.266667v-103.765333H135.168a21.333333 21.333333 0 0 1-21.333333-21.333334v-42.666666a21.333333 21.333333 0 0 1 21.333333-21.333334H398.506667l-0.042667-113.621333c0-14.677333 11.904-26.538667 26.538667-26.538667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-chat-record': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M11.3333 7.33334C11.3333 6.96515 11.6318 6.66667 12 6.66667H14.6667C15.0349 6.66667 15.3333 6.96515 15.3333 7.33334V12.6667C15.3333 13.0349 15.0349 13.3333 14.6667 13.3333H13.2761L12.4714 14.1381C12.2111 14.3984 11.7889 14.3984 11.5286 14.1381L10.7239 13.3333H7.33334C6.96515 13.3333 6.66667 13.0349 6.66667 12.6667V10C6.66667 9.63182 6.96515 9.33334 7.33334 9.33334H11.3333V7.33334ZM12.6667 8.00001V10C12.6667 10.3682 12.3682 10.6667 12 10.6667H8.00001V12H11C11.1768 12 11.3464 12.0702 11.4714 12.1953L12 12.7239L12.5286 12.1953C12.6536 12.0702 12.8232 12 13 12H14V8.00001H12.6667Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M1.33334 1.33333C0.965149 1.33333 0.666672 1.63181 0.666672 1.99999V10C0.666672 10.3682 0.965149 10.6667 1.33334 10.6667H2.72386L3.86193 11.8047C4.12228 12.0651 4.54439 12.0651 4.80474 11.8047L5.94281 10.6667H12C12.3682 10.6667 12.6667 10.3682 12.6667 10V1.99999C12.6667 1.63181 12.3682 1.33333 12 1.33333H1.33334ZM4.66667 5.99999C4.66667 6.36818 4.36819 6.66666 4.00001 6.66666C3.63182 6.66666 3.33334 6.36818 3.33334 5.99999C3.33334 5.6318 3.63182 5.33333 4.00001 5.33333C4.36819 5.33333 4.66667 5.6318 4.66667 5.99999ZM7.33334 5.99999C7.33334 6.36818 7.03486 6.66666 6.66667 6.66666C6.29848 6.66666 6 6.36818 6 5.99999C6 5.6318 6.29848 5.33333 6.66667 5.33333C7.03486 5.33333 7.33334 5.6318 7.33334 5.99999ZM10 5.99999C10 6.36818 9.70153 6.66666 9.33334 6.66666C8.96515 6.66666 8.66667 6.36818 8.66667 5.99999C8.66667 5.6318 8.96515 5.33333 9.33334 5.33333C9.70153 5.33333 10 5.6318 10 5.99999Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-history-outlined': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 20 20',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M18.6667 10.0001C18.6667 14.6025 14.9358 18.3334 10.3334 18.3334C7.68359 18.3334 5.32266 17.0967 3.79633 15.1689L5.12054 14.1563C6.3421 15.6864 8.22325 16.6667 10.3334 16.6667C14.0153 16.6667 17 13.682 17 10.0001C17 6.31818 14.0153 3.33341 10.3334 3.33341C7.03005 3.33341 4.28786 5.73596 3.75889 8.88897H4.3469C4.70187 8.88897 4.9136 9.28459 4.7167 9.57995L3.32493 11.6676C3.14901 11.9315 2.76125 11.9315 2.58533 11.6676L1.19356 9.57995C0.996651 9.28459 1.20838 8.88897 1.56336 8.88897H2.07347C2.61669 4.8119 6.10774 1.66675 10.3334 1.66675C14.9358 1.66675 18.6667 5.39771 18.6667 10.0001Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M10.8334 9.7223V7.11119C10.8334 6.86573 10.6344 6.66675 10.3889 6.66675H9.61115C9.36569 6.66675 9.16671 6.86573 9.16671 7.11119V10.9445C9.16671 11.19 9.36569 11.389 9.61115 11.389H13.1667C13.4122 11.389 13.6112 11.19 13.6112 10.9445V10.1667C13.6112 9.92129 13.4122 9.7223 13.1667 9.7223H10.8334Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-document-refresh': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 170.666667a85.333333 85.333333 0 0 1 85.333333-85.333334h256a85.333333 85.333333 0 0 1 85.333334 85.333334v256a85.333333 85.333333 0 0 1-85.333334 85.333333h-256a85.333333 85.333333 0 0 1-85.333333-85.333333V170.666667z m85.333333 0v256h256V170.666667h-256zM85.333333 597.333333a85.333333 85.333333 0 0 1 85.333334-85.333333h256a85.333333 85.333333 0 0 1 85.333333 85.333333v256a85.333333 85.333333 0 0 1-85.333333 85.333334H170.666667a85.333333 85.333333 0 0 1-85.333334-85.333334v-256z m85.333334 0v256h256v-256H170.666667zM128 298.666667a213.333333 213.333333 0 0 1 213.333333-213.333334h85.333334v85.333334H341.333333a128 128 0 0 0-128 128h57.514667a12.8 12.8 0 0 1 9.728 21.12l-100.181333 116.906666a12.8 12.8 0 0 1-19.456 0l-100.181334-116.906666A12.8 12.8 0 0 1 70.485333 298.666667H128zM896 725.333333a213.333333 213.333333 0 0 1-213.333333 213.333334h-85.333334v-85.333334h85.333334a128 128 0 0 0 128-128v-21.333333h-57.514667a12.8 12.8 0 0 1-9.728-21.12l100.181333-116.906667a12.8 12.8 0 0 1 19.456 0l100.181334 116.906667a12.8 12.8 0 0 1-9.728 21.12H896v21.333333z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-export': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M791.04 554.24l-386.432-1.728a21.248 21.248 0 0 1-21.12-21.248L383.36 490.88c-0.064-11.776 9.408-21.376 21.12-21.44h0.192l394.112 1.728-97.664-98.112a21.44 21.44 0 0 1 0-30.208l30.08-30.144a21.12 21.12 0 0 1 29.952 0l165.12 165.952a42.88 42.88 0 0 1 0 60.288l-165.12 165.952a21.12 21.12 0 0 1-30.016 0l-30.016-30.144a21.44 21.44 0 0 1 0-30.208L791.04 554.24z m-132.672-383.552H170.24v682.624h488.128c11.712 0 21.184 9.6 21.184 21.376v42.624a21.248 21.248 0 0 1-21.248 21.376h-530.56A42.56 42.56 0 0 1 85.376 896V128c0-23.552 19.008-42.688 42.496-42.688h530.56c11.712 0 21.184 9.6 21.184 21.376v42.624a21.248 21.248 0 0 1-21.248 21.376z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-fitview': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M128 85.333333h192a21.333333 21.333333 0 0 1 21.333333 21.333334v42.666666a21.333333 21.333333 0 0 1-21.333333 21.333334H170.666667v149.333333a21.333333 21.333333 0 0 1-21.333334 21.333333h-42.666666a21.333333 21.333333 0 0 1-21.333334-21.333333V128a42.666667 42.666667 0 0 1 42.666667-42.666667z m768 853.333334h-192a21.333333 21.333333 0 0 1-21.333333-21.333334v-42.666666a21.333333 21.333333 0 0 1 21.333333-21.333334H853.333333v-149.333333a21.333333 21.333333 0 0 1 21.333334-21.333333h42.666666a21.333333 21.333333 0 0 1 21.333334 21.333333V896a42.666667 42.666667 0 0 1-42.666667 42.666667zM85.333333 896v-192a21.333333 21.333333 0 0 1 21.333334-21.333333h42.666666a21.333333 21.333333 0 0 1 21.333334 21.333333V853.333333h149.333333a21.333333 21.333333 0 0 1 21.333333 21.333334v42.666666a21.333333 21.333333 0 0 1-21.333333 21.333334H128a42.666667 42.666667 0 0 1-42.666667-42.666667zM938.666667 128v192a21.333333 21.333333 0 0 1-21.333334 21.333333h-42.666666a21.333333 21.333333 0 0 1-21.333334-21.333333V170.666667h-149.333333a21.333333 21.333333 0 0 1-21.333333-21.333334v-42.666666a21.333333 21.333333 0 0 1 21.333333-21.333334H896a42.666667 42.666667 0 0 1 42.666667 42.666667z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M512 512m-170.666667 0a170.666667 170.666667 0 1 0 341.333334 0 170.666667 170.666667 0 1 0-341.333334 0Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-magnify': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M366.165333 593.749333a21.333333 21.333333 0 0 1 30.208 0l30.165334 30.165334a21.333333 21.333333 0 0 1 0 30.208l-170.752 170.666666H377.173333a21.333333 21.333333 0 0 1 21.333334 21.333334v42.666666a21.333333 21.333333 0 0 1-21.333334 21.333334H156.458667a42.538667 42.538667 0 0 1-42.666667-42.666667v-220.16a21.333333 21.333333 0 0 1 21.333333-21.333333h42.666667a21.333333 21.333333 0 0 1 21.333333 21.333333v113.493333l167.04-167.04z m500.992-480a42.538667 42.538667 0 0 1 42.666667 42.666667v220.16a21.333333 21.333333 0 0 1-21.333333 21.333333h-42.666667a21.333333 21.333333 0 0 1-21.333333-21.333333v-113.493333l-167.04 167.04a21.333333 21.333333 0 0 1-30.165334 0l-30.165333-30.165334a21.333333 21.333333 0 0 1 0-30.165333l170.709333-170.666667h-121.344a21.333333 21.333333 0 0 1-21.333333-21.333333v-42.666667a21.333333 21.333333 0 0 1 21.333333-21.333333h220.672z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-minify': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M384.341333 597.205333a42.538667 42.538667 0 0 1 42.666667 42.666667v220.16a21.333333 21.333333 0 0 1-21.333333 21.333333h-42.666667a21.333333 21.333333 0 0 1-21.333333-21.333333v-113.493333l-167.04 167.04a21.333333 21.333333 0 0 1-30.165334 0l-30.165333-30.208a21.333333 21.333333 0 0 1 0-30.165334l170.709333-170.666666H163.669333a21.333333 21.333333 0 0 1-21.333333-21.333334v-42.666666a21.333333 21.333333 0 0 1 21.333333-21.333334h220.672zM849.92 110.506667a21.333333 21.333333 0 0 1 30.165333 0l30.165334 30.165333a21.333333 21.333333 0 0 1 0 30.165333l-170.709334 170.666667h121.344a21.333333 21.333333 0 0 1 21.333334 21.333333v42.666667a21.333333 21.333333 0 0 1-21.333334 21.333333h-220.672a42.538667 42.538667 0 0 1-42.666666-42.666666v-220.16a21.333333 21.333333 0 0 1 21.333333-21.333334h42.666667a21.333333 21.333333 0 0 1 21.333333 21.333334v113.493333l167.04-166.997333z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-play-outlined': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 14 14',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M2.63333 1.82346C2.81847 1.72056 3.04484 1.72611 3.22472 1.83795L10.8081 6.55299C10.9793 6.65945 11.0834 6.84677 11.0834 7.04838C11.0834 7.24999 10.9793 7.43731 10.8081 7.54376L3.22472 12.2588C3.04484 12.3707 2.81847 12.3762 2.63333 12.2733C2.44819 12.1704 2.33337 11.9752 2.33337 11.7634V2.33333C2.33337 2.12152 2.44819 1.92635 2.63333 1.82346ZM3.50004 3.38293V10.7138L9.39529 7.04838L3.50004 3.38293Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-save-outlined': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 14 14',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M1.16666 2.53734C1.16666 1.78025 1.7804 1.1665 2.53749 1.1665H11.4625C12.2196 1.1665 12.8333 1.78025 12.8333 2.53734V11.4623C12.8333 12.2194 12.2196 12.8332 11.4625 12.8332H2.53749C1.7804 12.8332 1.16666 12.2194 1.16666 11.4623V2.53734ZM2.53749 2.33317C2.42473 2.33317 2.33332 2.42458 2.33332 2.53734V11.4623C2.33332 11.5751 2.42473 11.6665 2.53749 11.6665H11.4625C11.5753 11.6665 11.6667 11.5751 11.6667 11.4623V2.53734C11.6667 2.42457 11.5753 2.33317 11.4625 2.33317H2.53749Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M3.79166 1.74984C3.79166 1.42767 4.05282 1.1665 4.37499 1.1665H9.33332C9.65549 1.1665 9.91666 1.42767 9.91666 1.74984V6.99984C9.91666 7.322 9.65549 7.58317 9.33332 7.58317H4.37499C4.05282 7.58317 3.79166 7.322 3.79166 6.99984V1.74984ZM4.95832 2.33317V6.4165H8.74999V2.33317H4.95832Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M7.58333 3.2085C7.9055 3.2085 8.16667 3.46966 8.16667 3.79183V4.9585C8.16667 5.28066 7.9055 5.54183 7.58333 5.54183C7.26117 5.54183 7 5.28066 7 4.9585V3.79183C7 3.46966 7.26117 3.2085 7.58333 3.2085Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M2.62415 1.74984C2.62415 1.42767 2.88531 1.1665 3.20748 1.1665H10.4996C10.8217 1.1665 11.0829 1.42767 11.0829 1.74984C11.0829 2.072 10.8217 2.33317 10.4996 2.33317H3.20748C2.88531 2.33317 2.62415 2.072 2.62415 1.74984Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-reference-outlined': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M121.216 714.368c-7.082667-17.493333-7.466667-83.413333-7.424-104.32 0.341333-142.72 34.048-256.426667 88.32-330.112C262.4 198.229333 351.701333 161.024 460.8 172.8c7.893333 0.853333 11.946667 7.338667 10.581333 16.981333l-7.381333 51.285334c-1.749333 12.202667-9.813333 12.885333-17.621333 12.202666-138.709333-11.946667-232.576 84.053333-245.76 296.704a165.632 165.632 0 0 1 83.754666-22.528c91.050667 0 164.906667 72.96 164.906667 162.944C449.28 780.373333 375.466667 853.333333 284.373333 853.333333c-82.858667 0-151.424-60.330667-163.157333-138.965333z m438.570667 0c-7.082667-17.493333-7.509333-83.413333-7.466667-104.32 0.426667-142.72 34.090667-256.426667 88.405333-330.112 60.202667-81.706667 149.504-118.912 258.645334-107.136 7.893333 0.853333 11.946667 7.338667 10.581333 16.981333l-7.381333 51.285334c-1.749333 12.202667-9.813333 12.885333-17.621334 12.202666-138.752-11.946667-232.576 84.053333-245.76 296.704a165.632 165.632 0 0 1 83.712-22.528c91.093333 0 164.906667 72.96 164.906667 162.944 0 90.026667-73.813333 162.944-164.906667 162.944-82.773333 0-151.381333-60.330667-163.114666-138.965333z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-access': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M490.368 48.554667a42.666667 42.666667 0 0 1 43.264 0l362.666667 213.333333A42.666667 42.666667 0 0 1 917.333333 298.666667v426.666666a42.666667 42.666667 0 0 1-21.034666 36.778667l-362.666667 213.333333a42.666667 42.666667 0 0 1-43.264 0l-362.666667-213.333333A42.666667 42.666667 0 0 1 106.666667 725.333333V298.666667a42.666667 42.666667 0 0 1 21.034666-36.778667l362.666667-213.333333zM192 323.072v377.856L512 889.173333l320-188.245333V323.072L512 134.826667 192 323.072z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M705.194667 441.472a42.666667 42.666667 0 1 0-45.226667-72.362667l-148.096 92.586667L363.946667 369.066667a42.666667 42.666667 0 1 0-45.312 72.362666L469.333333 535.722667V704a42.666667 42.666667 0 1 0 85.333334 0v-168.448l150.528-94.08z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-access-active': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M533.632 48.554667a42.666667 42.666667 0 0 0-43.264 0l-362.666667 213.333333A42.666667 42.666667 0 0 0 106.666667 298.666667v426.666666a42.666667 42.666667 0 0 0 21.034666 36.778667l362.666667 213.333333a42.666667 42.666667 0 0 0 43.264 0l362.666667-213.333333A42.666667 42.666667 0 0 0 917.333333 725.333333V298.666667a42.666667 42.666667 0 0 0-21.034666-36.778667l-362.666667-213.333333z m185.130667 334.08a42.666667 42.666667 0 0 1-13.568 58.837333L554.666667 535.552V704a42.666667 42.666667 0 1 1-85.333334 0v-168.277333l-150.613333-94.293334a42.666667 42.666667 0 0 1 45.226667-72.32l147.925333 92.586667 148.053333-92.586667a42.666667 42.666667 0 0 1 58.837334 13.568z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-video-play': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 896a384 384 0 1 0 0-768 384 384 0 0 0 0 768z m469.333333-384c0 259.2-210.133333 469.333333-469.333333 469.333333S42.666667 771.2 42.666667 512 252.8 42.666667 512 42.666667s469.333333 210.133333 469.333333 469.333333z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M686.890667 539.776l-253.141334 159.274667a32.298667 32.298667 0 0 1-44.8-10.453334 32.896 32.896 0 0 1-4.949333-17.322666V352.768a32.64 32.64 0 0 1 32.512-32.768c6.101333 0 12.074667 1.706667 17.28 4.992l253.098667 159.232a32.853333 32.853333 0 0 1 0 55.552z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-video-stop': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M981.333333 512c0 259.2-210.133333 469.333333-469.333333 469.333333S42.666667 771.2 42.666667 512 252.8 42.666667 512 42.666667s469.333333 210.133333 469.333333 469.333333z m-85.333333 0a384 384 0 1 0-768 0 384 384 0 0 0 768 0zM384 341.333333h256c23.466667 0 42.666667 19.072 42.666667 42.666667v256c0 23.552-19.2 42.666667-42.666667 42.666667H384c-23.466667 0-42.666667-19.114667-42.666667-42.666667V384c0-23.594667 19.2-42.666667 42.666667-42.666667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-video-pause': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M405.333333 341.333333a21.333333 21.333333 0 0 0-21.333333 21.333334v298.666666a21.333333 21.333333 0 0 0 21.333333 21.333334h42.666667a21.333333 21.333333 0 0 0 21.333333-21.333334v-298.666666a21.333333 21.333333 0 0 0-21.333333-21.333334h-42.666667zM576 341.333333a21.333333 21.333333 0 0 0-21.333333 21.333334v298.666666a21.333333 21.333333 0 0 0 21.333333 21.333334h42.666667a21.333333 21.333333 0 0 0 21.333333-21.333334v-298.666666a21.333333 21.333333 0 0 0-21.333333-21.333334h-42.666667z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M512 42.666667C252.8 42.666667 42.666667 252.8 42.666667 512s210.133333 469.333333 469.333333 469.333333 469.333333-210.133333 469.333333-469.333333S771.2 42.666667 512 42.666667zM128 512a384 384 0 1 1 768 0 384 384 0 0 1-768 0z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-invisible': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M512 640c-28.032 0-55.466667-2.218667-82.090667-6.4l-21.248 79.274667a21.333333 21.333333 0 0 1-26.154666 15.061333L341.333333 716.885333a21.333333 21.333333 0 0 1-15.061333-26.112l20.821333-77.653333a473.770667 473.770667 0 0 1-97.152-45.653333l-67.84 67.84a21.333333 21.333333 0 0 1-30.122666 0l-30.165334-30.208a21.333333 21.333333 0 0 1 0-30.165334l59.733334-59.733333A386.389333 386.389333 0 0 1 104.789333 416.426667a37.76 37.76 0 0 1 7.594667-45.397334c10.496-9.514667 17.877333-16 24.32-22.442666a170.24 170.24 0 0 0 1.834667-1.92c9.301333-9.6 25.173333-6.016 30.634666 6.186666C222.336 471.936 349.568 554.666667 512 554.666667c155.648 0 285.866667-80.512 338.090667-190.976 1.365333-2.858667 2.901333-6.485333 4.437333-10.325334a18.346667 18.346667 0 0 1 29.866667-6.613333l27.392 27.434667a36.565333 36.565333 0 0 1 6.997333 42.666666c-1.792 3.456-3.541333 6.698667-5.034667 9.301334a390.4 390.4 0 0 1-76.928 94.293333l54.442667 54.485333a21.333333 21.333333 0 0 1 0 30.165334l-30.165333 30.165333a21.333333 21.333333 0 0 1-30.165334 0l-63.658666-63.658667a475.306667 475.306667 0 0 1-90.282667 41.514667l20.778667 77.653333a21.333333 21.333333 0 0 1-15.061334 26.112l-41.216 11.093334a21.333333 21.333333 0 0 1-26.154666-15.104l-21.248-79.317334c-26.581333 4.266667-54.058667 6.442667-82.090667 6.442667z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },

  'app-beautify': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 1024 1024',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M739.6864 689.92l4.2496 3.584 136.4992 135.936a34.1504 34.1504 0 0 1-43.9296 51.968l-4.1984-3.584-136.5504-135.936a34.1504 34.1504 0 0 1 43.9296-51.968zM663.4496 151.552a34.1504 34.1504 0 0 1 51.2512 30.464l-5.9392 216.6272 156.4672 146.1248a34.1504 34.1504 0 0 1-8.6528 55.808l-4.8128 1.792-202.8032 61.0816-87.4496 197.12a34.1504 34.1504 0 0 1-56.32 9.216l-3.2768-4.096-119.5008-178.432-209.9712-24.064a34.1504 34.1504 0 0 1-26.1632-50.176l2.7648-4.3008 129.28-171.7248-42.5472-212.3776a34.1504 34.1504 0 0 1 40.448-40.1408l4.6592 1.3312 198.912 72.3456z m-18.6368 89.7536l-144.5376 83.968a34.1504 34.1504 0 0 1-28.8256 2.56L314.5728 270.592l33.792 167.8848c1.4848 7.68 0.3584 15.5136-3.1744 22.3232l-3.072 4.9152-102.656 136.2944 166.4 19.1488c8.2944 0.9216 15.872 4.864 21.4016 10.9568l3.072 3.9424 93.8496 140.032 68.7104-154.7776a34.1504 34.1504 0 0 1 16.7936-17.0496l4.608-1.792 160.9216-48.4864-124.2624-116.0192a34.1504 34.1504 0 0 1-10.4448-20.0704l-0.3584-5.7856 4.6592-170.9056z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-retract': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M5.44661 0.747985C5.55509 0.639506 5.73097 0.639506 5.83945 0.747985L8.00004 2.90858L10.1606 0.748004C10.2691 0.639525 10.445 0.639525 10.5534 0.748004L11.1034 1.29798C11.2119 1.40645 11.2119 1.58233 11.1034 1.69081L8.7488 4.04544L8.74644 4.04782L8.19647 4.59779C8.16892 4.62534 8.13703 4.64589 8.10299 4.65945C8.003 4.6993 7.88453 4.67875 7.80359 4.59781L7.25362 4.04784L7.25003 4.04419L4.89664 1.69079C4.78816 1.58232 4.78816 1.40644 4.89664 1.29796L5.44661 0.747985Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M1.99999 5.82774C1.63181 5.82774 1.33333 6.12622 1.33333 6.49441V9.16107C1.33333 9.52926 1.63181 9.82774 2 9.82774H14C14.3682 9.82774 14.6667 9.52926 14.6667 9.16107V6.49441C14.6667 6.12622 14.3682 5.82774 14 5.82774H1.99999ZM13.3333 7.16108V8.49441H2.66666V7.16108H13.3333Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M10.1605 14.9075C10.269 15.016 10.4449 15.016 10.5534 14.9075L11.1033 14.3575C11.2118 14.249 11.2118 14.0732 11.1033 13.9647L8.75 11.6113L8.74637 11.6076L8.1964 11.0577C8.11546 10.9767 7.99699 10.9562 7.897 10.996C7.86296 11.0096 7.83107 11.0301 7.80352 11.0577L7.25354 11.6077L7.25117 11.6101L4.89657 13.9647C4.78809 14.0731 4.78809 14.249 4.89657 14.3575L5.44654 14.9075C5.55502 15.016 5.7309 15.016 5.83938 14.9075L7.99995 12.7469L10.1605 14.9075Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-extend': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M10.5534 5.07974C10.4449 5.18822 10.269 5.18822 10.1605 5.07974L7.99992 2.91915L5.83935 5.07972C5.73087 5.1882 5.555 5.1882 5.44652 5.07972L4.89654 4.52975C4.78807 4.42127 4.78807 4.24539 4.89654 4.13691L7.25117 1.78229L7.25352 1.77991L7.80349 1.22994C7.83019 1.20324 7.86098 1.18311 7.89384 1.16955C7.99448 1.12801 8.11459 1.14813 8.19638 1.22992L8.74635 1.77989L8.74998 1.78359L11.1033 4.13693C11.2118 4.24541 11.2118 4.42129 11.1033 4.52977L10.5534 5.07974Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M5.83943 10.9202C5.73095 10.8118 5.55507 10.8118 5.44659 10.9202L4.89662 11.4702C4.78814 11.5787 4.78814 11.7546 4.89662 11.863L7.24997 14.2164L7.25359 14.2201L7.80357 14.7701C7.8862 14.8527 8.00795 14.8724 8.10922 14.8291C8.14091 14.8156 8.17059 14.7959 8.19645 14.77L8.74642 14.2201L8.74873 14.2177L11.1034 11.8631C11.2119 11.7546 11.2119 11.5787 11.1034 11.4702L10.5534 10.9202C10.4449 10.8118 10.2691 10.8118 10.1606 10.9202L8.00002 13.0808L5.83943 10.9202Z',
              fill: 'currentColor'
            }),
            h('path', {
              d: 'M2.00004 6C1.63185 6 1.33337 6.29848 1.33337 6.66667V9.33333C1.33337 9.70152 1.63185 10 2.00004 10H14C14.3682 10 14.6667 9.70152 14.6667 9.33333V6.66667C14.6667 6.29848 14.3682 6 14 6H2.00004ZM13.3334 7.33333V8.66667H2.66671V7.33333H13.3334Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  },
  'app-close': {
    iconReader: () => {
      return h('i', [
        h(
          'svg',
          {
            style: { height: '100%', width: '100%' },
            viewBox: '0 0 16 16',
            version: '1.1',
            xmlns: 'http://www.w3.org/2000/svg'
          },
          [
            h('path', {
              d: 'M7.96141 6.98572L12.4398 2.50738C12.5699 2.3772 12.781 2.3772 12.9112 2.50738L13.3826 2.97878C13.5127 3.10895 13.5127 3.32001 13.3826 3.45018L8.90422 7.92853L13.3826 12.4069C13.5127 12.537 13.5127 12.7481 13.3826 12.8783L12.9112 13.3497C12.781 13.4799 12.5699 13.4799 12.4398 13.3497L7.96141 8.87134L3.48307 13.3497C3.35289 13.4799 3.14184 13.4799 3.01166 13.3497L2.54026 12.8783C2.41008 12.7481 2.41008 12.537 2.54026 12.4069L7.0186 7.92853L2.54026 3.45018C2.41008 3.32001 2.41008 3.10895 2.54026 2.97878L3.01166 2.50738C3.14184 2.3772 3.35289 2.3772 3.48307 2.50738L7.96141 6.98572Z',
              fill: 'currentColor'
            })
          ]
        )
      ])
    }
  }
}
