# Generated by Django 4.1.10 on 2024-03-18 16:02

import application.models.application
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('dataset', '0001_initial'),
        ('setting', '0001_initial'),
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False, verbose_name='主键id')),
                ('name', models.CharField(max_length=128, verbose_name='应用名称')),
                ('desc', models.CharField(default='', max_length=512, verbose_name='引用描述')),
                ('prologue', models.CharField(default='', max_length=1024, verbose_name='开场白')),
                ('dialogue_number', models.IntegerField(default=0, verbose_name='会话数量')),
                ('dataset_setting', models.JSONField(default=application.models.application.get_dataset_setting_dict, verbose_name='数据集参数设置')),
                ('model_setting', models.JSONField(default=application.models.application.get_model_setting_dict, verbose_name='模型参数相关设置')),
                ('problem_optimization', models.BooleanField(default=False, verbose_name='问题优化')),
                ('model', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to='setting.model')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='users.user')),
            ],
            options={
                'db_table': 'application',
            },
        ),
        migrations.CreateModel(
            name='Chat',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False, verbose_name='主键id')),
                ('abstract', models.CharField(max_length=256, verbose_name='摘要')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='application.application')),
            ],
            options={
                'db_table': 'application_chat',
            },
        ),
        migrations.CreateModel(
            name='ApplicationAccessToken',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('application', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='application.application', verbose_name='应用id')),
                ('access_token', models.CharField(max_length=128, unique=True, verbose_name='用户公开访问 认证token')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否开启公开访问')),
                ('access_num', models.IntegerField(default=100, verbose_name='访问次数')),
                ('white_active', models.BooleanField(default=False, verbose_name='是否开启白名单')),
                ('white_list', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=128), default=list, size=None, verbose_name='白名单列表')),
            ],
            options={
                'db_table': 'application_access_token',
            },
        ),
        migrations.CreateModel(
            name='ChatRecord',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False, verbose_name='主键id')),
                ('vote_status', models.CharField(choices=[('-1', '未投票'), ('0', '赞同'), ('1', '反对')], default='-1', max_length=10, verbose_name='投票')),
                ('problem_text', models.CharField(max_length=1024, verbose_name='问题')),
                ('answer_text', models.CharField(max_length=4096, verbose_name='答案')),
                ('message_tokens', models.IntegerField(default=0, verbose_name='请求token数量')),
                ('answer_tokens', models.IntegerField(default=0, verbose_name='响应token数量')),
                ('const', models.IntegerField(default=0, verbose_name='总费用')),
                ('details', models.JSONField(default=dict, verbose_name='对话详情')),
                ('improve_paragraph_id_list', django.contrib.postgres.fields.ArrayField(base_field=models.UUIDField(blank=True), default=list, size=None, verbose_name='改进标注列表')),
                ('run_time', models.FloatField(default=0, verbose_name='运行时长')),
                ('index', models.IntegerField(verbose_name='对话下标')),
                ('chat', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='application.chat')),
            ],
            options={
                'db_table': 'application_chat_record',
            },
        ),
        migrations.CreateModel(
            name='ApplicationPublicAccessClient',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(primary_key=True, serialize=False, verbose_name='公共访问链接客户端id')),
                ('access_num', models.IntegerField(default=0, verbose_name='访问总次数次数')),
                ('intraday_access_num', models.IntegerField(default=0, verbose_name='当日访问次数')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='application.application', verbose_name='应用id')),
            ],
            options={
                'db_table': 'application_public_access_client',
            },
        ),
        migrations.CreateModel(
            name='ApplicationDatasetMapping',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False, verbose_name='主键id')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='application.application')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='dataset.dataset')),
            ],
            options={
                'db_table': 'application_dataset_mapping',
            },
        ),
        migrations.CreateModel(
            name='ApplicationApiKey',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False, verbose_name='主键id')),
                ('secret_key', models.CharField(max_length=1024, unique=True, verbose_name='秘钥')),
                ('is_active', models.BooleanField(default=True, verbose_name='是否开启')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='application.application', verbose_name='应用id')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.user', verbose_name='用户id')),
            ],
            options={
                'db_table': 'application_api_key',
            },
        ),
    ]
