# Generated by Django 4.1.10 on 2024-03-18 16:02

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import uuid


def insert_default_data(apps, schema_editor):
    TeamModel = apps.get_model('setting', 'Team')
    TeamModel.objects.create(user_id='f0dd8f71-e4ee-11ee-8c84-a8a1595801ab', name='admin的团队')


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Team',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('user',
                 models.OneToOneField(on_delete=django.db.models.deletion.DO_NOTHING, primary_key=True, serialize=False,
                                      to='users.user', verbose_name='团队所有者')),
                ('name', models.CharField(max_length=128, verbose_name='团队名称')),
            ],
            options={
                'db_table': 'team',
            },
        ),
        migrations.RunPython(insert_default_data),
        migrations.CreateModel(
            name='TeamMember',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False,
                                        verbose_name='主键id')),
                ('team', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='setting.team',
                                           verbose_name='团队id')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='users.user',
                                           verbose_name='成员用户id')),
            ],
            options={
                'db_table': 'team_member',
            },
        ),
        migrations.CreateModel(
            name='TeamMemberPermission',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False,
                                        verbose_name='主键id')),
                ('auth_target_type',
                 models.CharField(choices=[('DATASET', '数据集'), ('APPLICATION', '应用')], default='DATASET',
                                  max_length=128, verbose_name='授权目标')),
                ('target', models.UUIDField(verbose_name='数据集/应用id')),
                ('operate', django.contrib.postgres.fields.ArrayField(
                    base_field=models.CharField(blank=True, choices=[('MANAGE', '管理'), ('USE', '使用')],
                                                default='USE', max_length=256), size=None,
                    verbose_name='权限操作列表')),
                ('member', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='setting.teammember',
                                             verbose_name='团队成员')),
            ],
            options={
                'db_table': 'team_member_permission',
            },
        ),
        migrations.CreateModel(
            name='Model',
            fields=[
                ('create_time', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='修改时间')),
                ('id', models.UUIDField(default=uuid.uuid1, editable=False, primary_key=True, serialize=False,
                                        verbose_name='主键id')),
                ('name', models.CharField(max_length=128, verbose_name='名称')),
                ('model_type', models.CharField(max_length=128, verbose_name='模型类型')),
                ('model_name', models.CharField(max_length=128, verbose_name='模型名称')),
                ('provider', models.CharField(max_length=128, verbose_name='供应商')),
                ('credential', models.CharField(max_length=5120, verbose_name='模型认证信息')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='users.user',
                                           verbose_name='成员用户id')),
            ],
            options={
                'db_table': 'model',
                'unique_together': {('name', 'user_id')},
            },
        ),
    ]
