<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [Cookie](./tough-cookie.cookie.md) &gt; [fromJSON](./tough-cookie.cookie.fromjson.md)

## Cookie.fromJSON() method

Does the reverse of [Cookie.toJSON()](./tough-cookie.cookie.tojson.md)<!-- -->.

**Signature:**

```typescript
static fromJSON(str: unknown): Cookie | undefined;
```

## Parameters

<table><thead><tr><th>

Parameter


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

str


</td><td>

unknown


</td><td>

An unparsed JSON string or a value that has already been parsed as JSON


</td></tr>
</tbody></table>
**Returns:**

[Cookie](./tough-cookie.cookie.md) \| undefined

## Remarks

Any Date properties (such as .expires, .creation, and .lastAccessed) are parsed via Date.parse, not tough-cookie's parseDate, since ISO timestamps are being handled at this layer.

## Example


```
const json = JSON.stringify({
  key: 'alpha',
  value: 'beta',
  domain: 'example.com',
  path: '/foo',
  expires: '2038-01-19T03:14:07.000Z',
})
const cookie = Cookie.fromJSON(json)
cookie.key === 'alpha'
cookie.value === 'beta'
cookie.domain === 'example.com'
cookie.path === '/foo'
cookie.expires === new Date(Date.parse('2038-01-19T03:14:07.000Z'))
```

