<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [Cookie](./tough-cookie.cookie.md)

## Cookie class

An HTTP cookie (web cookie, browser cookie) is a small piece of data that a server sends to a user's web browser. It is defined in [RFC6265](https://www.rfc-editor.org/rfc/rfc6265.html)<!-- -->.

**Signature:**

```typescript
export declare class Cookie 
```

## Constructors

<table><thead><tr><th>

Constructor


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[(constructor)(options)](./tough-cookie.cookie._constructor_.md)


</td><td>


</td><td>

Create a new Cookie instance.


</td></tr>
</tbody></table>

## Properties

<table><thead><tr><th>

Property


</th><th>

Modifiers


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[creation](./tough-cookie.cookie.creation.md)


</td><td>


</td><td>

Date \| 'Infinity' \| null


</td><td>

Set to the date and time when a Cookie is initially stored or a matching cookie is received that replaces an existing cookie (See [RFC6265 Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->).

Also used to maintain ordering among cookies. Among cookies that have equal-length path fields, cookies with earlier creation-times are listed before cookies with later creation-times (See [RFC6265 Section 5.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.4)<!-- -->).


</td></tr>
<tr><td>

[creationIndex](./tough-cookie.cookie.creationindex.md)


</td><td>


</td><td>

number


</td><td>

A global counter used to break ordering ties between two cookies that have equal-length path fields and the same creation-time.


</td></tr>
<tr><td>

[domain](./tough-cookie.cookie.domain.md)


</td><td>


</td><td>

string \| null


</td><td>

The 'Domain' attribute of the cookie represents the domain the cookie belongs to (See [RFC6265 Section 5.2.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.3)<!-- -->).


</td></tr>
<tr><td>

[expires](./tough-cookie.cookie.expires.md)


</td><td>


</td><td>

Date \| 'Infinity' \| null


</td><td>

The 'Expires' attribute of the cookie (See [RFC6265 Section 5.2.1](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.1)<!-- -->).


</td></tr>
<tr><td>

[extensions](./tough-cookie.cookie.extensions.md)


</td><td>


</td><td>

string\[\] \| null


</td><td>

Contains attributes which are not part of the defined spec but match the `extension-av` syntax defined in Section 4.1.1 of RFC6265 (See [RFC6265 Section 4.1.1](https://www.rfc-editor.org/rfc/rfc6265.html#section-4.1.1)<!-- -->).


</td></tr>
<tr><td>

[hostOnly](./tough-cookie.cookie.hostonly.md)


</td><td>


</td><td>

boolean \| null


</td><td>

A boolean flag indicating if a cookie is a host-only cookie (i.e.; when the request's host exactly matches the domain of the cookie) or not (See [RFC6265 Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->).


</td></tr>
<tr><td>

[httpOnly](./tough-cookie.cookie.httponly.md)


</td><td>


</td><td>

boolean


</td><td>

The 'HttpOnly' flag of the cookie indicates if the cookie is inaccessible to client scripts or not (See [RFC6265 Section 5.2.6](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.6)<!-- -->).


</td></tr>
<tr><td>

[key](./tough-cookie.cookie.key.md)


</td><td>


</td><td>

string


</td><td>

The name or key of the cookie


</td></tr>
<tr><td>

[lastAccessed](./tough-cookie.cookie.lastaccessed.md)


</td><td>


</td><td>

Date \| 'Infinity' \| null


</td><td>

Set to the date and time when a cookie was initially stored ([RFC6265 Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->) and updated whenever the cookie is retrieved from the [CookieJar](./tough-cookie.cookiejar.md) ([RFC6265 Section 5.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.4)<!-- -->).


</td></tr>
<tr><td>

[maxAge](./tough-cookie.cookie.maxage.md)


</td><td>


</td><td>

number \| 'Infinity' \| '-Infinity' \| null


</td><td>

The 'Max-Age' attribute of the cookie (See [RFC6265 Section 5.2.2](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.2)<!-- -->).


</td></tr>
<tr><td>

[path](./tough-cookie.cookie.path.md)


</td><td>


</td><td>

string \| null


</td><td>

The 'Path' attribute of the cookie represents the path of the cookie (See [RFC6265 Section 5.2.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.4)<!-- -->).


</td></tr>
<tr><td>

[pathIsDefault](./tough-cookie.cookie.pathisdefault.md)


</td><td>


</td><td>

boolean \| null


</td><td>

A boolean flag indicating if a cookie had no 'Path' attribute and the default path was used (See [RFC6265 Section 5.2.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.4)<!-- -->).


</td></tr>
<tr><td>

[sameSite](./tough-cookie.cookie.samesite.md)


</td><td>


</td><td>

string \| undefined


</td><td>

The 'SameSite' attribute of a cookie as defined in RFC6265bis (See [RFC6265bis (v13) Section 5.2](https://www.ietf.org/archive/id/draft-ietf-httpbis-rfc6265bis-13.html#section-5.2)<!-- -->).


</td></tr>
<tr><td>

[secure](./tough-cookie.cookie.secure.md)


</td><td>


</td><td>

boolean


</td><td>

The 'Secure' flag of the cookie indicates if the scope of the cookie is limited to secure channels (e.g.; HTTPS) or not (See [RFC6265 Section 5.2.5](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.2.5)<!-- -->).


</td></tr>
<tr><td>

[serializableProperties](./tough-cookie.cookie.serializableproperties.md)


</td><td>

`static`


</td><td>

readonly \["key", "value", "expires", "maxAge", "domain", "path", "secure", "httpOnly", "extensions", "hostOnly", "pathIsDefault", "creation", "lastAccessed", "sameSite"\]


</td><td>

Cookie properties that will be serialized when using [Cookie.fromJSON()](./tough-cookie.cookie.fromjson.md) and [Cookie.toJSON()](./tough-cookie.cookie.tojson.md)<!-- -->.


</td></tr>
<tr><td>

[value](./tough-cookie.cookie.value.md)


</td><td>


</td><td>

string


</td><td>

The value of the cookie


</td></tr>
</tbody></table>

## Methods

<table><thead><tr><th>

Method


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[canonicalizedDomain()](./tough-cookie.cookie.canonicalizeddomain.md)


</td><td>


</td><td>

Calls [canonicalDomain()](./tough-cookie.canonicaldomain.md) with the [Cookie.domain](./tough-cookie.cookie.domain.md) property.


</td></tr>
<tr><td>

[cdomain()](./tough-cookie.cookie.cdomain.md)


</td><td>


</td><td>

Alias for [Cookie.canonicalizedDomain()](./tough-cookie.cookie.canonicalizeddomain.md)


</td></tr>
<tr><td>

[clone()](./tough-cookie.cookie.clone.md)


</td><td>


</td><td>

Does a deep clone of this cookie, implemented exactly as `Cookie.fromJSON(cookie.toJSON())`<!-- -->.


</td></tr>
<tr><td>

[cookieString()](./tough-cookie.cookie.cookiestring.md)


</td><td>


</td><td>

Encodes to a `Cookie` header value (specifically, the [Cookie.key](./tough-cookie.cookie.key.md) and [Cookie.value](./tough-cookie.cookie.value.md) properties joined with "=").


</td></tr>
<tr><td>

[expiryDate(now)](./tough-cookie.cookie.expirydate.md)


</td><td>


</td><td>

Similar to [Cookie.expiryTime()](./tough-cookie.cookie.expirytime.md)<!-- -->, computes the absolute unix-epoch milliseconds that this cookie expires and returns it as a Date.

The "Max-Age" attribute takes precedence over "Expires" (as per the RFC). The [Cookie.lastAccessed](./tough-cookie.cookie.lastaccessed.md) attribute (or the `now` parameter if given) is used to offset the [Cookie.maxAge](./tough-cookie.cookie.maxage.md) attribute.

If Expires ([Cookie.expires](./tough-cookie.cookie.expires.md)<!-- -->) is set, that's returned.


</td></tr>
<tr><td>

[expiryTime(now)](./tough-cookie.cookie.expirytime.md)


</td><td>


</td><td>

Computes the absolute unix-epoch milliseconds that this cookie expires.

The "Max-Age" attribute takes precedence over "Expires" (as per the RFC). The [Cookie.lastAccessed](./tough-cookie.cookie.lastaccessed.md) attribute (or the `now` parameter if given) is used to offset the [Cookie.maxAge](./tough-cookie.cookie.maxage.md) attribute.

If Expires ([Cookie.expires](./tough-cookie.cookie.expires.md)<!-- -->) is set, that's returned.


</td></tr>
<tr><td>

[fromJSON(str)](./tough-cookie.cookie.fromjson.md)


</td><td>

`static`


</td><td>

Does the reverse of [Cookie.toJSON()](./tough-cookie.cookie.tojson.md)<!-- -->.


</td></tr>
<tr><td>

[isPersistent()](./tough-cookie.cookie.ispersistent.md)


</td><td>


</td><td>

Indicates if the cookie has been persisted to a store or not.


</td></tr>
<tr><td>

[parse(str, options)](./tough-cookie.cookie.parse.md)


</td><td>

`static`


</td><td>

Parses a string into a Cookie object.


</td></tr>
<tr><td>

[setExpires(exp)](./tough-cookie.cookie.setexpires.md)


</td><td>


</td><td>

Sets the 'Expires' attribute on a cookie.


</td></tr>
<tr><td>

[setMaxAge(age)](./tough-cookie.cookie.setmaxage.md)


</td><td>


</td><td>

Sets the 'Max-Age' attribute (in seconds) on a cookie.


</td></tr>
<tr><td>

[toJSON()](./tough-cookie.cookie.tojson.md)


</td><td>


</td><td>

For convenience in using `JSON.stringify(cookie)`<!-- -->. Returns a plain-old Object that can be JSON-serialized.


</td></tr>
<tr><td>

[toString()](./tough-cookie.cookie.tostring.md)


</td><td>


</td><td>

Encodes to a `Set-Cookie header` value.


</td></tr>
<tr><td>

[TTL(now)](./tough-cookie.cookie.ttl.md)


</td><td>


</td><td>

Computes the TTL relative to now (milliseconds).


</td></tr>
<tr><td>

[validate()](./tough-cookie.cookie.validate.md)


</td><td>


</td><td>

**_(BETA)_** Validates cookie attributes for semantic correctness. Useful for "lint" checking any `Set-Cookie` headers you generate. For now, it returns a boolean, but eventually could return a reason string.


</td></tr>
</tbody></table>
