<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [Cookie](./tough-cookie.cookie.md) &gt; [parse](./tough-cookie.cookie.parse.md)

## Cookie.parse() method

Parses a string into a Cookie object.

**Signature:**

```typescript
static parse(str: string, options?: ParseCookieOptions): Cookie | undefined;
```

## Parameters

<table><thead><tr><th>

Parameter


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

str


</td><td>

string


</td><td>

The `Set-Cookie` header or a Cookie string to parse.


</td></tr>
<tr><td>

options


</td><td>

[ParseCookieOptions](./tough-cookie.parsecookieoptions.md)


</td><td>

_(Optional)_ Configures `strict` or `loose` mode for cookie parsing


</td></tr>
</tbody></table>
**Returns:**

[Cookie](./tough-cookie.cookie.md) \| undefined

## Remarks

Note: when parsing a `Cookie` header it must be split by ';' before each Cookie string can be parsed.

## Example 1


```
// parse a `Set-Cookie` header
const setCookieHeader = 'a=bcd; Expires=Tue, 18 Oct 2011 07:05:03 GMT'
const cookie = Cookie.parse(setCookieHeader)
cookie.key === 'a'
cookie.value === 'bcd'
cookie.expires === new Date(Date.parse('Tue, 18 Oct 2011 07:05:03 GMT'))
```

## Example 2


```
// parse a `Cookie` header
const cookieHeader = 'name=value; name2=value2; name3=value3'
const cookies = cookieHeader.split(';').map(Cookie.parse)
cookies[0].name === 'name'
cookies[0].value === 'value'
cookies[1].name === 'name2'
cookies[1].value === 'value2'
cookies[2].name === 'name3'
cookies[2].value === 'value3'
```

