<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [CookieJar](./tough-cookie.cookiejar.md)

## CookieJar class

A CookieJar is for storage and retrieval of [Cookie](./tough-cookie.cookie.md) objects as defined in [RFC6265 - Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->.

It also supports a pluggable persistence layer via [Store](./tough-cookie.store.md)<!-- -->.

**Signature:**

```typescript
export declare class CookieJar 
```

## Constructors

<table><thead><tr><th>

Constructor


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[(constructor)(store, options)](./tough-cookie.cookiejar._constructor_.md)


</td><td>


</td><td>

Creates a new `CookieJar` instance.


</td></tr>
</tbody></table>

## Properties

<table><thead><tr><th>

Property


</th><th>

Modifiers


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[prefixSecurity](./tough-cookie.cookiejar.prefixsecurity.md)


</td><td>

`readonly`


</td><td>

string


</td><td>

The configured [PrefixSecurityEnum](./tough-cookie.prefixsecurityenum.md) value for the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[store](./tough-cookie.cookiejar.store.md)


</td><td>

`readonly`


</td><td>

[Store](./tough-cookie.store.md)


</td><td>

The configured [Store](./tough-cookie.store.md) for the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
</tbody></table>

## Methods

<table><thead><tr><th>

Method


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[clone(callback)](./tough-cookie.cookiejar.clone.md)


</td><td>


</td><td>

Produces a deep clone of this CookieJar. Modifications to the original do not affect the clone, and vice versa.


</td></tr>
<tr><td>

[clone(newStore, callback)](./tough-cookie.cookiejar.clone_1.md)


</td><td>


</td><td>

Produces a deep clone of this CookieJar. Modifications to the original do not affect the clone, and vice versa.


</td></tr>
<tr><td>

[clone(newStore)](./tough-cookie.cookiejar.clone_2.md)


</td><td>


</td><td>

Produces a deep clone of this CookieJar. Modifications to the original do not affect the clone, and vice versa.


</td></tr>
<tr><td>

[cloneSync(newStore)](./tough-cookie.cookiejar.clonesync.md)


</td><td>


</td><td>

Produces a deep clone of this CookieJar. Modifications to the original do not affect the clone, and vice versa.

<strong>Note</strong>: Only works if both the configured Store and destination Store are synchronous.


</td></tr>
<tr><td>

[deserialize(strOrObj, callback)](./tough-cookie.cookiejar.deserialize.md)


</td><td>

`static`


</td><td>

A new CookieJar is created and the serialized [Cookie](./tough-cookie.cookie.md) values are added to the underlying store. Each [Cookie](./tough-cookie.cookie.md) is added via `store.putCookie(...)` in the order in which they appear in the serialization.


</td></tr>
<tr><td>

[deserialize(strOrObj, store, callback)](./tough-cookie.cookiejar.deserialize_1.md)


</td><td>

`static`


</td><td>

A new CookieJar is created and the serialized [Cookie](./tough-cookie.cookie.md) values are added to the underlying store. Each [Cookie](./tough-cookie.cookie.md) is added via `store.putCookie(...)` in the order in which they appear in the serialization.


</td></tr>
<tr><td>

[deserialize(strOrObj, store)](./tough-cookie.cookiejar.deserialize_2.md)


</td><td>

`static`


</td><td>

A new CookieJar is created and the serialized [Cookie](./tough-cookie.cookie.md) values are added to the underlying store. Each [Cookie](./tough-cookie.cookie.md) is added via `store.putCookie(...)` in the order in which they appear in the serialization.


</td></tr>
<tr><td>

[deserializeSync(strOrObj, store)](./tough-cookie.cookiejar.deserializesync.md)


</td><td>

`static`


</td><td>

A new CookieJar is created and the serialized [Cookie](./tough-cookie.cookie.md) values are added to the underlying store. Each [Cookie](./tough-cookie.cookie.md) is added via `store.putCookie(...)` in the order in which they appear in the serialization.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[fromJSON(jsonString, store)](./tough-cookie.cookiejar.fromjson.md)


</td><td>

`static`


</td><td>

Alias of [CookieJar.deserializeSync()](./tough-cookie.cookiejar.deserializesync.md)<!-- -->.


</td></tr>
<tr><td>

[getCookies(url)](./tough-cookie.cookiejar.getcookies.md)


</td><td>


</td><td>

Retrieve the list of cookies that can be sent in a Cookie header for the current URL.


</td></tr>
<tr><td>

[getCookies(url, callback)](./tough-cookie.cookiejar.getcookies_1.md)


</td><td>


</td><td>

Retrieve the list of cookies that can be sent in a Cookie header for the current URL.


</td></tr>
<tr><td>

[getCookies(url, options, callback)](./tough-cookie.cookiejar.getcookies_2.md)


</td><td>


</td><td>

Retrieve the list of cookies that can be sent in a Cookie header for the current URL.


</td></tr>
<tr><td>

[getCookies(url, options)](./tough-cookie.cookiejar.getcookies_3.md)


</td><td>


</td><td>

Retrieve the list of cookies that can be sent in a Cookie header for the current URL.


</td></tr>
<tr><td>

[getCookiesSync(url, options)](./tough-cookie.cookiejar.getcookiessync.md)


</td><td>


</td><td>

Synchronously retrieve the list of cookies that can be sent in a Cookie header for the current URL.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[getCookieString(url, options, callback)](./tough-cookie.cookiejar.getcookiestring.md)


</td><td>


</td><td>

Accepts the same options as `.getCookies()` but returns a string suitable for a `Cookie` header rather than an Array.


</td></tr>
<tr><td>

[getCookieString(url, callback)](./tough-cookie.cookiejar.getcookiestring_1.md)


</td><td>


</td><td>

Accepts the same options as `.getCookies()` but returns a string suitable for a `Cookie` header rather than an Array.


</td></tr>
<tr><td>

[getCookieString(url, options)](./tough-cookie.cookiejar.getcookiestring_2.md)


</td><td>


</td><td>

Accepts the same options as `.getCookies()` but returns a string suitable for a `Cookie` header rather than an Array.


</td></tr>
<tr><td>

[getCookieStringSync(url, options)](./tough-cookie.cookiejar.getcookiestringsync.md)


</td><td>


</td><td>

Synchronous version of `.getCookieString()`<!-- -->. Accepts the same options as `.getCookies()` but returns a string suitable for a `Cookie` header rather than an Array.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[getSetCookieStrings(url, callback)](./tough-cookie.cookiejar.getsetcookiestrings.md)


</td><td>


</td><td>

Returns an array of strings suitable for `Set-Cookie` headers. Accepts the same options as `.getCookies()`<!-- -->.


</td></tr>
<tr><td>

[getSetCookieStrings(url, options, callback)](./tough-cookie.cookiejar.getsetcookiestrings_1.md)


</td><td>


</td><td>

Returns an array of strings suitable for `Set-Cookie` headers. Accepts the same options as `.getCookies()`<!-- -->.


</td></tr>
<tr><td>

[getSetCookieStrings(url, options)](./tough-cookie.cookiejar.getsetcookiestrings_2.md)


</td><td>


</td><td>

Returns an array of strings suitable for `Set-Cookie` headers. Accepts the same options as `.getCookies()`<!-- -->.


</td></tr>
<tr><td>

[getSetCookieStringsSync(url, options)](./tough-cookie.cookiejar.getsetcookiestringssync.md)


</td><td>


</td><td>

Synchronous version of `.getSetCookieStrings()`<!-- -->. Returns an array of strings suitable for `Set-Cookie` headers. Accepts the same options as `.getCookies()`<!-- -->.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[removeAllCookies(callback)](./tough-cookie.cookiejar.removeallcookies.md)


</td><td>


</td><td>

Removes all cookies from the CookieJar.


</td></tr>
<tr><td>

[removeAllCookies()](./tough-cookie.cookiejar.removeallcookies_1.md)


</td><td>


</td><td>

Removes all cookies from the CookieJar.


</td></tr>
<tr><td>

[removeAllCookiesSync()](./tough-cookie.cookiejar.removeallcookiessync.md)


</td><td>


</td><td>

Removes all cookies from the CookieJar.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[serialize(callback)](./tough-cookie.cookiejar.serialize.md)


</td><td>


</td><td>

Serialize the CookieJar if the underlying store supports `.getAllCookies`<!-- -->.


</td></tr>
<tr><td>

[serialize()](./tough-cookie.cookiejar.serialize_1.md)


</td><td>


</td><td>

Serialize the CookieJar if the underlying store supports `.getAllCookies`<!-- -->.


</td></tr>
<tr><td>

[serializeSync()](./tough-cookie.cookiejar.serializesync.md)


</td><td>


</td><td>

Serialize the CookieJar if the underlying store supports `.getAllCookies`<!-- -->.

<strong>Note</strong>: Only works if the configured Store is also synchronous.


</td></tr>
<tr><td>

[setCookie(cookie, url, callback)](./tough-cookie.cookiejar.setcookie.md)


</td><td>


</td><td>

Attempt to set the [Cookie](./tough-cookie.cookie.md) in the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[setCookie(cookie, url, options, callback)](./tough-cookie.cookiejar.setcookie_1.md)


</td><td>


</td><td>

Attempt to set the [Cookie](./tough-cookie.cookie.md) in the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[setCookie(cookie, url, options)](./tough-cookie.cookiejar.setcookie_2.md)


</td><td>


</td><td>

Attempt to set the [Cookie](./tough-cookie.cookie.md) in the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[setCookieSync(cookie, url, options)](./tough-cookie.cookiejar.setcookiesync.md)


</td><td>


</td><td>

Synchronously attempt to set the [Cookie](./tough-cookie.cookie.md) in the [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.

<strong>Note:</strong> Only works if the configured [Store](./tough-cookie.store.md) is also synchronous.


</td></tr>
<tr><td>

[toJSON()](./tough-cookie.cookiejar.tojson.md)


</td><td>


</td><td>

Alias of [CookieJar.serializeSync()](./tough-cookie.cookiejar.serializesync.md)<!-- -->. Allows the cookie to be serialized with `JSON.stringify(cookieJar)`<!-- -->.


</td></tr>
</tbody></table>
