<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [domainMatch](./tough-cookie.domainmatch.md)

## domainMatch() function

Answers "does this real domain match the domain in a cookie?". The `domain` is the "current" domain name and the `cookieDomain` is the "cookie" domain name. Matches according to [RFC6265 - Section 5.1.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.3)<!-- -->, but it helps to think of it as a "suffix match".

**Signature:**

```typescript
export declare function domainMatch(domain?: Nullable<string>, cookieDomain?: Nullable<string>, canonicalize?: boolean): boolean | undefined;
```

## Parameters

<table><thead><tr><th>

Parameter


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

domain


</td><td>

[Nullable](./tough-cookie.nullable.md)<!-- -->&lt;string&gt;


</td><td>

_(Optional)_ The domain string to test


</td></tr>
<tr><td>

cookieDomain


</td><td>

[Nullable](./tough-cookie.nullable.md)<!-- -->&lt;string&gt;


</td><td>

_(Optional)_ The cookie domain string to match against


</td></tr>
<tr><td>

canonicalize


</td><td>

boolean


</td><td>

_(Optional)_ The canonicalize parameter toggles whether the domain parameters get normalized with canonicalDomain or not


</td></tr>
</tbody></table>
**Returns:**

boolean \| undefined

## Remarks

\#\#\# 5.1.3. Domain Matching

A string domain-matches a given domain string if at least one of the following conditions hold:

- The domain string and the string are identical. (Note that both the domain string and the string will have been canonicalized to lower case at this point.)

- All of the following conditions hold:

- The domain string is a suffix of the string.

- The last character of the string that is not included in the domain string is a %x2E (".") character.

- The string is a host name (i.e., not an IP address).

## Example


```
domainMatch('example.com', 'example.com') === true
domainMatch('eXaMpLe.cOm', 'ExAmPlE.CoM') === true
domainMatch('no.ca', 'yes.ca') === false
```

