<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [getPublicSuffix](./tough-cookie.getpublicsuffix.md)

## getPublicSuffix() function

Returns the public suffix of this hostname. The public suffix is the shortest domain name upon which a cookie can be set.

**Signature:**

```typescript
export declare function getPublicSuffix(domain: string, options?: GetPublicSuffixOptions): string | undefined;
```

## Parameters

<table><thead><tr><th>

Parameter


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

domain


</td><td>

string


</td><td>

the domain attribute of a cookie


</td></tr>
<tr><td>

options


</td><td>

[GetPublicSuffixOptions](./tough-cookie.getpublicsuffixoptions.md)


</td><td>

_(Optional)_ optional configuration for controlling how the public suffix is determined


</td></tr>
</tbody></table>
**Returns:**

string \| undefined

## Remarks

A "public suffix" is a domain that is controlled by a public registry, such as "com", "co.uk", and "pvt.k12.wy.us". This step is essential for preventing attacker.com from disrupting the integrity of example.com by setting a cookie with a Domain attribute of "com". Unfortunately, the set of public suffixes (also known as "registry controlled domains") changes over time. If feasible, user agents SHOULD use an up-to-date public suffix list, such as the one maintained by the Mozilla project at http://publicsuffix.org/. (See [RFC6265 - Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->)

## Example


```
getPublicSuffix('www.example.com') === 'example.com'
getPublicSuffix('www.subdomain.example.com') === 'example.com'
```

