<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md)

## tough-cookie package

## Classes

<table><thead><tr><th>

Class


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[Cookie](./tough-cookie.cookie.md)


</td><td>

An HTTP cookie (web cookie, browser cookie) is a small piece of data that a server sends to a user's web browser. It is defined in [RFC6265](https://www.rfc-editor.org/rfc/rfc6265.html)<!-- -->.


</td></tr>
<tr><td>

[CookieJar](./tough-cookie.cookiejar.md)


</td><td>

A CookieJar is for storage and retrieval of [Cookie](./tough-cookie.cookie.md) objects as defined in [RFC6265 - Section 5.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.3)<!-- -->.

It also supports a pluggable persistence layer via [Store](./tough-cookie.store.md)<!-- -->.


</td></tr>
<tr><td>

[MemoryCookieStore](./tough-cookie.memorycookiestore.md)


</td><td>

An in-memory [Store](./tough-cookie.store.md) implementation for [CookieJar](./tough-cookie.cookiejar.md)<!-- -->. This is the default implementation used by [CookieJar](./tough-cookie.cookiejar.md) and supports both async and sync operations. Also supports serialization, getAllCookies, and removeAllCookies.


</td></tr>
<tr><td>

[ParameterError](./tough-cookie.parametererror.md)


</td><td>

Represents a validation error.


</td></tr>
<tr><td>

[Store](./tough-cookie.store.md)


</td><td>

Base class for [CookieJar](./tough-cookie.cookiejar.md) stores.

The storage model for each [CookieJar](./tough-cookie.cookiejar.md) instance can be replaced with a custom implementation. The default is [MemoryCookieStore](./tough-cookie.memorycookiestore.md)<!-- -->.


</td></tr>
</tbody></table>

## Functions

<table><thead><tr><th>

Function


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[canonicalDomain(domainName)](./tough-cookie.canonicaldomain.md)


</td><td>

Transforms a domain name into a canonical domain name. The canonical domain name is a domain name that has been trimmed, lowercased, stripped of leading dot, and optionally punycode-encoded ([Section 5.1.2 of RFC 6265](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.2)<!-- -->). For the most part, this function is idempotent (calling the function with the output from a previous call returns the same output).


</td></tr>
<tr><td>

[cookieCompare(a, b)](./tough-cookie.cookiecompare.md)


</td><td>

A comparison function that can be used with [Array.sort()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort)<!-- -->, which orders a list of cookies into the recommended order given in Step 2 of [RFC6265 - Section 5.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.4)<!-- -->.

The sort algorithm is, in order of precedence:

- Longest [Cookie.path](./tough-cookie.cookie.path.md)

- Oldest [Cookie.creation](./tough-cookie.cookie.creation.md) (which has a 1-ms precision, same as Date)

- Lowest [Cookie.creationIndex](./tough-cookie.cookie.creationindex.md) (to get beyond the 1-ms precision)


</td></tr>
<tr><td>

[defaultPath(path)](./tough-cookie.defaultpath.md)


</td><td>

Given a current request/response path, gives the path appropriate for storing in a cookie. This is basically the "directory" of a "file" in the path, but is specified by [RFC6265 - Section 5.1.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.4)<!-- -->.


</td></tr>
<tr><td>

[domainMatch(domain, cookieDomain, canonicalize)](./tough-cookie.domainmatch.md)


</td><td>

Answers "does this real domain match the domain in a cookie?". The `domain` is the "current" domain name and the `cookieDomain` is the "cookie" domain name. Matches according to [RFC6265 - Section 5.1.3](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.3)<!-- -->, but it helps to think of it as a "suffix match".


</td></tr>
<tr><td>

[formatDate(date)](./tough-cookie.formatdate.md)


</td><td>

Format a [Date](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date) into the [preferred Internet standard format](https://www.rfc-editor.org/rfc/rfc2616#section-3.3.1) defined in [RFC822](https://www.rfc-editor.org/rfc/rfc822#section-5) and updated in [RFC1123](https://www.rfc-editor.org/rfc/rfc1123#page-55)<!-- -->.


</td></tr>
<tr><td>

[fromJSON(str)](./tough-cookie.fromjson.md)


</td><td>

Does the reverse of [Cookie.toJSON()](./tough-cookie.cookie.tojson.md)<!-- -->.


</td></tr>
<tr><td>

[getPublicSuffix(domain, options)](./tough-cookie.getpublicsuffix.md)


</td><td>

Returns the public suffix of this hostname. The public suffix is the shortest domain name upon which a cookie can be set.


</td></tr>
<tr><td>

[parse(str, options)](./tough-cookie.parse.md)


</td><td>

Parses a string into a Cookie object.


</td></tr>
<tr><td>

[parseDate(cookieDate)](./tough-cookie.parsedate.md)


</td><td>

Parse a cookie date string into a [Date](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date)<!-- -->. Parses according to [RFC6265 - Section 5.1.1](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.1)<!-- -->, not [Date.parse()](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/parse)<!-- -->.


</td></tr>
<tr><td>

[pathMatch(reqPath, cookiePath)](./tough-cookie.pathmatch.md)


</td><td>

Answers "does the request-path path-match a given cookie-path?" as per [RFC6265 Section 5.1.4](https://www.rfc-editor.org/rfc/rfc6265.html#section-5.1.4)<!-- -->. This is essentially a prefix-match where cookiePath is a prefix of reqPath.


</td></tr>
<tr><td>

[permuteDomain(domain, allowSpecialUseDomain)](./tough-cookie.permutedomain.md)


</td><td>

Generates the permutation of all possible values that [domainMatch()](./tough-cookie.domainmatch.md) the given `domain` parameter. The array is in shortest-to-longest order. Useful when building custom [Store](./tough-cookie.store.md) implementations.


</td></tr>
<tr><td>

[permutePath(path)](./tough-cookie.permutepath.md)


</td><td>

Generates the permutation of all possible values that [pathMatch()](./tough-cookie.pathmatch.md) the `path` parameter. The array is in longest-to-shortest order. Useful when building custom [Store](./tough-cookie.store.md) implementations.


</td></tr>
</tbody></table>

## Interfaces

<table><thead><tr><th>

Interface


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[Callback](./tough-cookie.callback.md)


</td><td>

A callback function that accepts an error or a result.


</td></tr>
<tr><td>

[CreateCookieJarOptions](./tough-cookie.createcookiejaroptions.md)


</td><td>

Configuration settings to be used with a [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[CreateCookieOptions](./tough-cookie.createcookieoptions.md)


</td><td>

Configurable values that can be set when creating a [Cookie](./tough-cookie.cookie.md)<!-- -->.


</td></tr>
<tr><td>

[ErrorCallback](./tough-cookie.errorcallback.md)


</td><td>

A callback function that only accepts an error.


</td></tr>
<tr><td>

[GetCookiesOptions](./tough-cookie.getcookiesoptions.md)


</td><td>

Configuration options used when calling `CookieJar.getCookies(...)`<!-- -->.


</td></tr>
<tr><td>

[GetPublicSuffixOptions](./tough-cookie.getpublicsuffixoptions.md)


</td><td>

Options for configuring how [getPublicSuffix()](./tough-cookie.getpublicsuffix.md) behaves.


</td></tr>
<tr><td>

[ParseCookieOptions](./tough-cookie.parsecookieoptions.md)


</td><td>

Optional configuration to be used when parsing cookies.


</td></tr>
<tr><td>

[SerializedCookieJar](./tough-cookie.serializedcookiejar.md)


</td><td>

A JSON representation of a [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.


</td></tr>
<tr><td>

[SetCookieOptions](./tough-cookie.setcookieoptions.md)


</td><td>

Configuration options used when calling `CookieJar.setCookie(...)`


</td></tr>
</tbody></table>

## Variables

<table><thead><tr><th>

Variable


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[PrefixSecurityEnum](./tough-cookie.prefixsecurityenum.md)


</td><td>

Cookie prefixes are a way to indicate that a given cookie was set with a set of attributes simply by inspecting the first few characters of the cookie's name. These are defined in [RFC6265bis - Section 4.1.3](https://datatracker.ietf.org/doc/html/draft-ietf-httpbis-rfc6265bis-13#section-4.1.3)<!-- -->.

The following values can be used to configure how a [CookieJar](./tough-cookie.cookiejar.md) enforces attribute restrictions for Cookie prefixes:

- `silent` - Enable cookie prefix checking but silently ignores the cookie if conditions are not met. This is the default configuration for a [CookieJar](./tough-cookie.cookiejar.md)<!-- -->.

- `strict` - Enables cookie prefix checking and will raise an error if conditions are not met.

- `unsafe-disabled` - Disables cookie prefix checking.


</td></tr>
<tr><td>

[version](./tough-cookie.version.md)


</td><td>

The version of `tough-cookie`


</td></tr>
</tbody></table>

## Type Aliases

<table><thead><tr><th>

Type Alias


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[Nullable](./tough-cookie.nullable.md)


</td><td>

The inverse of NonNullable<T>.


</td></tr>
<tr><td>

[SerializedCookie](./tough-cookie.serializedcookie.md)


</td><td>

A JSON object that is created when [Cookie.toJSON()](./tough-cookie.cookie.tojson.md) is called. This object will contain the properties defined in [Cookie.serializableProperties](./tough-cookie.cookie.serializableproperties.md)<!-- -->.


</td></tr>
</tbody></table>
