<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [tough-cookie](./tough-cookie.md) &gt; [MemoryCookieStore](./tough-cookie.memorycookiestore.md)

## MemoryCookieStore class

An in-memory [Store](./tough-cookie.store.md) implementation for [CookieJar](./tough-cookie.cookiejar.md)<!-- -->. This is the default implementation used by [CookieJar](./tough-cookie.cookiejar.md) and supports both async and sync operations. Also supports serialization, getAllCookies, and removeAllCookies.

**Signature:**

```typescript
export declare class MemoryCookieStore extends Store 
```
**Extends:** [Store](./tough-cookie.store.md)

## Constructors

<table><thead><tr><th>

Constructor


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[(constructor)()](./tough-cookie.memorycookiestore._constructor_.md)


</td><td>


</td><td>

Create a new [MemoryCookieStore](./tough-cookie.memorycookiestore.md)<!-- -->.


</td></tr>
</tbody></table>

## Properties

<table><thead><tr><th>

Property


</th><th>

Modifiers


</th><th>

Type


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[synchronous](./tough-cookie.memorycookiestore.synchronous.md)


</td><td>


</td><td>

boolean


</td><td>

This value is `true` since [MemoryCookieStore](./tough-cookie.memorycookiestore.md) implements synchronous functionality.


</td></tr>
</tbody></table>

## Methods

<table><thead><tr><th>

Method


</th><th>

Modifiers


</th><th>

Description


</th></tr></thead>
<tbody><tr><td>

[findCookie(domain, path, key)](./tough-cookie.memorycookiestore.findcookie.md)


</td><td>


</td><td>

Retrieve a [Cookie](./tough-cookie.cookie.md) with the given `domain`<!-- -->, `path`<!-- -->, and `key` (`name`<!-- -->). The RFC maintains that exactly one of these cookies should exist in a store. If the store is using versioning, this means that the latest or newest such cookie should be returned.


</td></tr>
<tr><td>

[findCookie(domain, path, key, callback)](./tough-cookie.memorycookiestore.findcookie_1.md)


</td><td>


</td><td>

Retrieve a [Cookie](./tough-cookie.cookie.md) with the given `domain`<!-- -->, `path`<!-- -->, and `key` (`name`<!-- -->). The RFC maintains that exactly one of these cookies should exist in a store. If the store is using versioning, this means that the latest or newest such cookie should be returned.

Callback takes an error and the resulting Cookie object. If no cookie is found then null MUST be passed instead (that is, not an error).


</td></tr>
<tr><td>

[findCookies(domain, path, allowSpecialUseDomain)](./tough-cookie.memorycookiestore.findcookies.md)


</td><td>


</td><td>

Locates all [Cookie](./tough-cookie.cookie.md) values matching the given `domain` and `path`<!-- -->.

The resulting list is checked for applicability to the current request according to the RFC (`domain-match`<!-- -->, `path-match`<!-- -->, `http-only-flag`<!-- -->, `secure-flag`<!-- -->, `expiry`<!-- -->, and so on), so it's OK to use an optimistic search algorithm when implementing this method. However, the search algorithm used SHOULD try to find cookies that [domainMatch()](./tough-cookie.domainmatch.md) the `domain` and [pathMatch()](./tough-cookie.pathmatch.md) the `path` in order to limit the amount of checking that needs to be done.


</td></tr>
<tr><td>

[findCookies(domain, path, allowSpecialUseDomain, callback)](./tough-cookie.memorycookiestore.findcookies_1.md)


</td><td>


</td><td>

Locates all [Cookie](./tough-cookie.cookie.md) values matching the given `domain` and `path`<!-- -->.

The resulting list is checked for applicability to the current request according to the RFC (`domain-match`<!-- -->, `path-match`<!-- -->, `http-only-flag`<!-- -->, `secure-flag`<!-- -->, `expiry`<!-- -->, and so on), so it's OK to use an optimistic search algorithm when implementing this method. However, the search algorithm used SHOULD try to find cookies that [domainMatch()](./tough-cookie.domainmatch.md) the `domain` and [pathMatch()](./tough-cookie.pathmatch.md) the `path` in order to limit the amount of checking that needs to be done.


</td></tr>
<tr><td>

[getAllCookies()](./tough-cookie.memorycookiestore.getallcookies.md)


</td><td>


</td><td>

Gets all the cookies in the store.


</td></tr>
<tr><td>

[getAllCookies(callback)](./tough-cookie.memorycookiestore.getallcookies_1.md)


</td><td>


</td><td>

Gets all the cookies in the store.


</td></tr>
<tr><td>

[putCookie(cookie)](./tough-cookie.memorycookiestore.putcookie.md)


</td><td>


</td><td>

Adds a new [Cookie](./tough-cookie.cookie.md) to the store. The implementation SHOULD replace any existing cookie with the same `domain`<!-- -->, `path`<!-- -->, and `key` properties.


</td></tr>
<tr><td>

[putCookie(cookie, callback)](./tough-cookie.memorycookiestore.putcookie_1.md)


</td><td>


</td><td>

Adds a new [Cookie](./tough-cookie.cookie.md) to the store. The implementation SHOULD replace any existing cookie with the same `domain`<!-- -->, `path`<!-- -->, and `key` properties.


</td></tr>
<tr><td>

[removeAllCookies()](./tough-cookie.memorycookiestore.removeallcookies.md)


</td><td>


</td><td>

Removes all cookies from the store.


</td></tr>
<tr><td>

[removeAllCookies(callback)](./tough-cookie.memorycookiestore.removeallcookies_1.md)


</td><td>


</td><td>

Removes all cookies from the store.


</td></tr>
<tr><td>

[removeCookie(domain, path, key)](./tough-cookie.memorycookiestore.removecookie.md)


</td><td>


</td><td>

Remove a cookie from the store (see notes on `findCookie` about the uniqueness constraint).


</td></tr>
<tr><td>

[removeCookie(domain, path, key, callback)](./tough-cookie.memorycookiestore.removecookie_1.md)


</td><td>


</td><td>

Remove a cookie from the store (see notes on `findCookie` about the uniqueness constraint).


</td></tr>
<tr><td>

[removeCookies(domain, path)](./tough-cookie.memorycookiestore.removecookies.md)


</td><td>


</td><td>

Removes matching cookies from the store. The `path` parameter is optional and if missing, means all paths in a domain should be removed.


</td></tr>
<tr><td>

[removeCookies(domain, path, callback)](./tough-cookie.memorycookiestore.removecookies_1.md)


</td><td>


</td><td>

Removes matching cookies from the store. The `path` parameter is optional and if missing, means all paths in a domain should be removed.


</td></tr>
<tr><td>

[updateCookie(oldCookie, newCookie)](./tough-cookie.memorycookiestore.updatecookie.md)


</td><td>


</td><td>

Update an existing [Cookie](./tough-cookie.cookie.md)<!-- -->. The implementation MUST update the `value` for a cookie with the same `domain`<!-- -->, `path`<!-- -->, and `key`<!-- -->. The implementation SHOULD check that the old value in the store is equivalent to oldCookie - how the conflict is resolved is up to the store.


</td></tr>
<tr><td>

[updateCookie(oldCookie, newCookie, callback)](./tough-cookie.memorycookiestore.updatecookie_1.md)


</td><td>


</td><td>

Update an existing [Cookie](./tough-cookie.cookie.md)<!-- -->. The implementation MUST update the `value` for a cookie with the same `domain`<!-- -->, `path`<!-- -->, and `key`<!-- -->. The implementation SHOULD check that the old value in the store is equivalent to oldCookie - how the conflict is resolved is up to the store.


</td></tr>
</tbody></table>
