## API Report File for "tough-cookie"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export interface Callback<T> {
    // (undocumented)
    (error: Error, result?: never): void;
    // (undocumented)
    (error: null, result: T): void;
}

// @public
export function canonicalDomain(domainName: Nullable<string>): string | undefined;

// @public
export class Cookie {
    constructor(options?: CreateCookieOptions);
    canonicalizedDomain(): string | undefined;
    cdomain(): string | undefined;
    clone(): Cookie | undefined;
    cookieString(): string;
    creation: Date | 'Infinity' | null;
    creationIndex: number;
    domain: string | null;
    expires: Date | 'Infinity' | null;
    expiryDate(now?: Date): Date | undefined;
    expiryTime(now?: Date): number | undefined;
    extensions: string[] | null;
    static fromJSON(str: unknown): Cookie | undefined;
    hostOnly: boolean | null;
    httpOnly: boolean;
    isPersistent(): boolean;
    key: string;
    lastAccessed: Date | 'Infinity' | null;
    maxAge: number | 'Infinity' | '-Infinity' | null;
    static parse(str: string, options?: ParseCookieOptions): Cookie | undefined;
    path: string | null;
    pathIsDefault: boolean | null;
    sameSite: string | undefined;
    // @internal (undocumented)
    static sameSiteCanonical: {
        readonly strict: "Strict";
        readonly lax: "Lax";
    };
    // @internal (undocumented)
    static sameSiteLevel: {
        readonly strict: 3;
        readonly lax: 2;
        readonly none: 1;
    };
    secure: boolean;
    static serializableProperties: readonly ["key", "value", "expires", "maxAge", "domain", "path", "secure", "httpOnly", "extensions", "hostOnly", "pathIsDefault", "creation", "lastAccessed", "sameSite"];
    setExpires(exp: string | Date): void;
    setMaxAge(age: number): void;
    toJSON(): SerializedCookie;
    toString(): string;
    TTL(now?: number): number;
    // @beta
    validate(): boolean;
    value: string;
}

// @public
export function cookieCompare(a: Cookie, b: Cookie): number;

// @public
export class CookieJar {
    constructor(store?: Nullable<Store>, options?: CreateCookieJarOptions | boolean);
    clone(callback: Callback<CookieJar>): void;
    clone(newStore: Store, callback: Callback<CookieJar>): void;
    clone(newStore?: Store): Promise<CookieJar>;
    cloneSync(newStore?: Store): CookieJar | undefined;
    // @internal (undocumented)
    _cloneSync(newStore?: Store): CookieJar | undefined;
    static deserialize(strOrObj: string | object, callback: Callback<CookieJar>): void;
    static deserialize(strOrObj: string | object, store: Store, callback: Callback<CookieJar>): void;
    static deserialize(strOrObj: string | object, store?: Store): Promise<CookieJar>;
    // @internal
    static deserialize(strOrObj: string | object, store?: Store | Callback<CookieJar>, callback?: Callback<CookieJar>): unknown;
    static deserializeSync(strOrObj: string | SerializedCookieJar, store?: Store): CookieJar;
    static fromJSON(jsonString: string | SerializedCookieJar, store?: Store): CookieJar;
    getCookies(url: string): Promise<Cookie[]>;
    getCookies(url: string, callback: Callback<Cookie[]>): void;
    getCookies(url: string | URL, options: GetCookiesOptions | undefined, callback: Callback<Cookie[]>): void;
    getCookies(url: string | URL, options?: GetCookiesOptions): Promise<Cookie[]>;
    // @internal
    getCookies(url: string | URL, options: GetCookiesOptions | undefined | Callback<Cookie[]>, callback?: Callback<Cookie[]>): unknown;
    getCookiesSync(url: string, options?: GetCookiesOptions): Cookie[];
    getCookieString(url: string, options: GetCookiesOptions, callback: Callback<string | undefined>): void;
    getCookieString(url: string, callback: Callback<string | undefined>): void;
    getCookieString(url: string, options?: GetCookiesOptions): Promise<string>;
    // @internal
    getCookieString(url: string, options: GetCookiesOptions | Callback<string | undefined>, callback?: Callback<string | undefined>): unknown;
    getCookieStringSync(url: string, options?: GetCookiesOptions): string;
    getSetCookieStrings(url: string, callback: Callback<string[] | undefined>): void;
    getSetCookieStrings(url: string, options: GetCookiesOptions, callback: Callback<string[] | undefined>): void;
    getSetCookieStrings(url: string, options?: GetCookiesOptions): Promise<string[] | undefined>;
    // @internal
    getSetCookieStrings(url: string, options: GetCookiesOptions, callback?: Callback<string[] | undefined>): unknown;
    getSetCookieStringsSync(url: string, options?: GetCookiesOptions): string[];
    // @internal
    _importCookies(serialized: unknown, callback: Callback<CookieJar>): void;
    // @internal (undocumented)
    _importCookiesSync(serialized: unknown): void;
    readonly prefixSecurity: string;
    removeAllCookies(callback: ErrorCallback): void;
    removeAllCookies(): Promise<void>;
    removeAllCookiesSync(): void;
    serialize(callback: Callback<SerializedCookieJar>): void;
    serialize(): Promise<SerializedCookieJar>;
    serializeSync(): SerializedCookieJar | undefined;
    setCookie(cookie: string | Cookie, url: string | URL, callback: Callback<Cookie | undefined>): void;
    setCookie(cookie: string | Cookie, url: string | URL, options: SetCookieOptions, callback: Callback<Cookie | undefined>): void;
    setCookie(cookie: string | Cookie, url: string | URL, options?: SetCookieOptions): Promise<Cookie | undefined>;
    // @internal
    setCookie(cookie: string | Cookie, url: string | URL, options: SetCookieOptions | Callback<Cookie | undefined>, callback?: Callback<Cookie | undefined>): unknown;
    setCookieSync(cookie: string | Cookie, url: string, options?: SetCookieOptions): Cookie | undefined;
    readonly store: Store;
    toJSON(): SerializedCookieJar | undefined;
}

// @public
export interface CreateCookieJarOptions {
    allowSpecialUseDomain?: boolean | undefined;
    looseMode?: boolean | undefined;
    prefixSecurity?: 'strict' | 'silent' | 'unsafe-disabled' | undefined;
    rejectPublicSuffixes?: boolean | undefined;
}

// @public
export interface CreateCookieOptions {
    creation?: Date | 'Infinity' | null;
    domain?: string | null;
    expires?: Date | 'Infinity' | null;
    extensions?: string[] | null;
    hostOnly?: boolean | null;
    httpOnly?: boolean;
    key?: string;
    lastAccessed?: Date | 'Infinity' | null;
    maxAge?: number | 'Infinity' | '-Infinity' | null;
    path?: string | null;
    pathIsDefault?: boolean | null;
    sameSite?: string | undefined;
    secure?: boolean;
    value?: string;
}

// @public
export function defaultPath(path?: Nullable<string>): string;

// @public
export function domainMatch(domain?: Nullable<string>, cookieDomain?: Nullable<string>, canonicalize?: boolean): boolean | undefined;

// @public
export interface ErrorCallback {
    // (undocumented)
    (error: Error | null): void;
}

// @public
export function formatDate(date: Date): string;

// @public
export function fromJSON(str: unknown): Cookie | undefined;

// @public
export interface GetCookiesOptions {
    allPaths?: boolean | undefined;
    expire?: boolean | undefined;
    http?: boolean | undefined;
    sameSiteContext?: 'none' | 'lax' | 'strict' | undefined;
    sort?: boolean | undefined;
}

// @public
export function getPublicSuffix(domain: string, options?: GetPublicSuffixOptions): string | undefined;

// @public
export interface GetPublicSuffixOptions {
    allowSpecialUseDomain?: boolean | undefined;
    ignoreError?: boolean | undefined;
}

// @public
export class MemoryCookieStore extends Store {
    constructor();
    findCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>): Promise<Cookie | undefined>;
    findCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>, callback: Callback<Cookie | undefined>): void;
    findCookies(domain: string, path: string, allowSpecialUseDomain?: boolean): Promise<Cookie[]>;
    findCookies(domain: string, path: string, allowSpecialUseDomain?: boolean, callback?: Callback<Cookie[]>): void;
    getAllCookies(): Promise<Cookie[]>;
    getAllCookies(callback: Callback<Cookie[]>): void;
    // @internal (undocumented)
    idx: MemoryCookieStoreIndex;
    putCookie(cookie: Cookie): Promise<void>;
    putCookie(cookie: Cookie, callback: ErrorCallback): void;
    removeAllCookies(): Promise<void>;
    removeAllCookies(callback: ErrorCallback): void;
    removeCookie(domain: string, path: string, key: string): Promise<void>;
    removeCookie(domain: string, path: string, key: string, callback: ErrorCallback): void;
    removeCookies(domain: string, path: string): Promise<void>;
    removeCookies(domain: string, path: string, callback: ErrorCallback): void;
    synchronous: boolean;
    updateCookie(oldCookie: Cookie, newCookie: Cookie): Promise<void>;
    updateCookie(oldCookie: Cookie, newCookie: Cookie, callback: ErrorCallback): void;
}

// @internal
export type MemoryCookieStoreIndex = {
    [domain: string]: {
        [path: string]: {
            [key: string]: Cookie;
        };
    };
};

// @public
export type Nullable<T> = T | null | undefined;

// @public
export class ParameterError extends Error {
}

// @public
export function parse(str: string, options?: ParseCookieOptions): Cookie | undefined;

// @public
export interface ParseCookieOptions {
    loose?: boolean | undefined;
}

// @public
export function parseDate(cookieDate: Nullable<string>): Date | undefined;

// @public
export function pathMatch(reqPath: string, cookiePath: string): boolean;

// @public
export function permuteDomain(domain: string, allowSpecialUseDomain?: boolean): string[] | undefined;

// @public
export function permutePath(path: string): string[];

// @public
export const PrefixSecurityEnum: Readonly<{
    SILENT: "silent";
    STRICT: "strict";
    DISABLED: "unsafe-disabled";
}>;

// @public
export type SerializedCookie = {
    key?: string;
    value?: string;
    [key: string]: unknown;
};

// @public
export interface SerializedCookieJar {
    [key: string]: unknown;
    cookies: SerializedCookie[];
    rejectPublicSuffixes: boolean;
    storeType: string | null;
    version: string;
}

// @public
export interface SetCookieOptions {
    http?: boolean | undefined;
    ignoreError?: boolean | undefined;
    loose?: boolean | undefined;
    now?: Date | undefined;
    sameSiteContext?: 'strict' | 'lax' | 'none' | undefined;
}

// @public
export class Store {
    constructor();
    findCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>): Promise<Cookie | undefined>;
    findCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>, callback: Callback<Cookie | undefined>): void;
    findCookies(domain: Nullable<string>, path: Nullable<string>, allowSpecialUseDomain?: boolean): Promise<Cookie[]>;
    findCookies(domain: Nullable<string>, path: Nullable<string>, allowSpecialUseDomain?: boolean, callback?: Callback<Cookie[]>): void;
    getAllCookies(): Promise<Cookie[]>;
    getAllCookies(callback: Callback<Cookie[]>): void;
    putCookie(cookie: Cookie): Promise<void>;
    putCookie(cookie: Cookie, callback: ErrorCallback): void;
    removeAllCookies(): Promise<void>;
    removeAllCookies(callback: ErrorCallback): void;
    removeCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>): Promise<void>;
    removeCookie(domain: Nullable<string>, path: Nullable<string>, key: Nullable<string>, callback: ErrorCallback): void;
    removeCookies(domain: string, path: Nullable<string>): Promise<void>;
    removeCookies(domain: string, path: Nullable<string>, callback: ErrorCallback): void;
    synchronous: boolean;
    updateCookie(oldCookie: Cookie, newCookie: Cookie): Promise<void>;
    updateCookie(oldCookie: Cookie, newCookie: Cookie, callback: ErrorCallback): void;
}

// @public
export const version = "5.1.0-rc.0";

// (No @packageDocumentation comment for this package)

```
