/**
 * Provides a taint-tracking configuration for reasoning about unsafe deserialization.
 *
 * Note, for performance reasons: only import this file if
 * `UnsafeDeserialization::Configuration` is needed, otherwise
 * `UnsafeDeserializationCustomizations` should be imported instead.
 */

import javascript
import semmle.javascript.security.dataflow.RemoteFlowSources

module UnsafeDeserialization {
  import UnsafeDeserializationCustomizations::UnsafeDeserialization

  /**
   * A taint-tracking configuration for reasoning about unsafe deserialization.
   */
  class Configuration extends TaintTracking::Configuration {
    Configuration() { this = "UnsafeDeserialization" }

    override predicate isSource(DataFlow::Node source) { source instanceof Source }

    override predicate isSink(DataFlow::Node sink) { sink instanceof Sink }

    override predicate isSanitizer(DataFlow::Node node) {
      super.isSanitizer(node) or
      node instanceof Sanitizer
    }
  }
}
