/**
 * @name Uncontrolled command line
 * @description Using externally controlled strings in a command line may allow a malicious
 *              user to change the meaning of the command.
 * @kind path-problem
 * @problem.severity error
 * @sub-severity high
 * @precision high
 * @id py/command-line-injection
 * @tags correctness
 *       security
 *       external/owasp/owasp-a1
 *       external/cwe/cwe-078
 *       external/cwe/cwe-088
 */

import python
import semmle.python.security.Paths

/* Sources */
import semmle.python.web.HttpRequest

/* Sinks */
import semmle.python.security.injection.Command

class CommandInjectionConfiguration extends TaintTracking::Configuration {

    CommandInjectionConfiguration() { this = "Command injection configuration" }

    override predicate isSource(TaintTracking::Source source) { source instanceof HttpRequestTaintSource }

    override predicate isSink(TaintTracking::Sink sink) {
        sink instanceof OsCommandFirstArgument or
        sink instanceof ShellCommand
    }

    override predicate isExtension(TaintTracking::Extension extension) {
        extension instanceof FirstElementFlow
    }

}

from CommandInjectionConfiguration config, TaintedPathSource src, TaintedPathSink sink
where config.hasFlowPath(src, sink)
select sink.getSink(), src, sink, "This command depends on $@.", src.getSource(), "a user-provided value"
