# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import proto  # type: ignore

__protobuf__ = proto.module(
    package="google.cloud.talent.v4",
    manifest={
        "HistogramQuery",
        "HistogramQueryResult",
    },
)


class HistogramQuery(proto.Message):
    r"""The histogram request.

    Attributes:
        histogram_query (str):
            An expression specifies a histogram request against matching
            jobs for searches.

            See
            [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries]
            for details about syntax.
    """

    histogram_query = proto.Field(
        proto.STRING,
        number=1,
    )


class HistogramQueryResult(proto.Message):
    r"""Histogram result that matches
    [HistogramQuery][google.cloud.talent.v4.HistogramQuery] specified in
    searches.

    Attributes:
        histogram_query (str):
            Requested histogram expression.
        histogram (Mapping[str, int]):
            A map from the values of the facet associated with distinct
            values to the number of matching entries with corresponding
            value.

            The key format is:

            -  (for string histogram) string values stored in the field.
            -  (for named numeric bucket) name specified in ``bucket()``
               function, like for ``bucket(0, MAX, "non-negative")``,
               the key will be ``non-negative``.
            -  (for anonymous numeric bucket) range formatted as
               ``<low>-<high>``, for example, ``0-1000``, ``MIN-0``, and
               ``0-MAX``.
    """

    histogram_query = proto.Field(
        proto.STRING,
        number=1,
    )
    histogram = proto.MapField(
        proto.STRING,
        proto.INT64,
        number=2,
    )


__all__ = tuple(sorted(__protobuf__.manifest))
